/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.swing;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.mainwindow.MediathekGui;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmediathek/tool/swing/HyperlinkDecorator;", "", "()V", "A_HREF", "", "HREF_CLOSED", "HREF_END", "HTML", "HTML_END", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "createHtmlReference", "s", "makeLinkable", "", "c", "Ljavax/swing/JLabel;", "ml", "Ljava/awt/event/MouseListener;", "link", "placeInsideHtmlTag", "LinkMouseListener", "LinkRunner", "MediathekView"})
public final class HyperlinkDecorator {
    private static final String A_HREF = "<a href=\"";
    private static final String HREF_CLOSED = "\">";
    private static final String HREF_END = "</a>";
    private static final String HTML = "<html>";
    private static final String HTML_END = "</html>";
    private static final Logger logger;
    @NotNull
    public static final HyperlinkDecorator INSTANCE;

    private final void makeLinkable(JLabel c, MouseListener ml) {
        String string = c.getText();
        Intrinsics.checkNotNullExpressionValue(string, "c.text");
        c.setText(this.placeInsideHtmlTag(this.createHtmlReference(string)));
        c.setCursor(new Cursor(12));
        c.addMouseListener(ml);
    }

    @JvmStatic
    public static final void makeLinkable(@NotNull JLabel c, @NotNull String link) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(link, "link");
        try {
            INSTANCE.makeLinkable(c, new LinkMouseListener(link));
            c.setToolTipText(link);
        }
        catch (URISyntaxException e) {
            logger.error(e);
        }
    }

    private final String createHtmlReference(String s2) {
        return A_HREF + s2 + HREF_CLOSED + s2 + HREF_END;
    }

    private final String placeInsideHtmlTag(String s2) {
        return HTML + s2 + HTML_END;
    }

    private HyperlinkDecorator() {
    }

    static {
        HyperlinkDecorator hyperlinkDecorator;
        INSTANCE = hyperlinkDecorator = new HyperlinkDecorator();
        logger = LogManager.getLogger();
    }

    public static final /* synthetic */ Logger access$getLogger$p(HyperlinkDecorator $this) {
        HyperlinkDecorator hyperlinkDecorator = $this;
        return logger;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmediathek/tool/swing/HyperlinkDecorator$LinkMouseListener;", "Ljava/awt/event/MouseAdapter;", "link", "", "(Ljava/lang/String;)V", "Ljava/net/URI;", "mouseClicked", "", "evt", "Ljava/awt/event/MouseEvent;", "MediathekView"})
    private static final class LinkMouseListener
    extends MouseAdapter {
        private final URI link;

        @Override
        public void mouseClicked(@NotNull MouseEvent evt) {
            Intrinsics.checkNotNullParameter(evt, "evt");
            new LinkRunner(this.link).execute();
        }

        public LinkMouseListener(@NotNull String link) {
            Intrinsics.checkNotNullParameter(link, "link");
            this.link = new URI(link);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmediathek/tool/swing/HyperlinkDecorator$LinkRunner;", "Ljavax/swing/SwingWorker;", "Ljava/lang/Void;", "u", "Ljava/net/URI;", "(Ljava/net/URI;)V", "uri", "doInBackground", "done", "", "MediathekView"})
    private static final class LinkRunner
    extends SwingWorker<Void, Void> {
        private final URI uri;

        @Override
        @Nullable
        protected Void doInBackground() throws Exception {
            UrlHyperlinkAction.openURL(MediathekGui.ui(), this.uri.toString());
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (ExecutionException ee) {
                HyperlinkDecorator.access$getLogger$p(INSTANCE).error(ee);
            }
            catch (InterruptedException ee) {
                HyperlinkDecorator.access$getLogger$p(INSTANCE).error(ee);
            }
        }

        public LinkRunner(@NotNull URI u) {
            Intrinsics.checkNotNullParameter(u, "u");
            this.uri = u;
        }
    }
}

