/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.data;

import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.LatLon;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class ElevationHelper {
    private static final Log log = PlatformUtil.getLog(ElevationHelper.class);

    public void adjustElevations(final LatLonGeneralization pInput, Map<String, BinaryMapIndexReader> files) {
        final Vector<WptPtDistStruct> allDistances = new Vector<WptPtDistStruct>();
        int lb = Integer.MAX_VALUE;
        int tb = Integer.MAX_VALUE;
        int rb = -2147483647;
        int bb = -2147483647;
        for (LatLonHolder latLonHolder : pInput.getPoints()) {
            LatLon latLon = latLonHolder.getLatLon();
            lb = Math.min(lb, latLon.get31TileNumberX());
            rb = Math.max(rb, latLon.get31TileNumberX());
            tb = Math.min(tb, latLon.get31TileNumberY());
            bb = Math.max(bb, latLon.get31TileNumberY());
            allDistances.add(new WptPtDistStruct(latLonHolder));
        }
        for (BinaryMapIndexReader reader : files.values()) {
            if (!reader.containsMapData()) continue;
            log.info((Object)("Processing " + reader.getFile() + "."));
            ResultMatcher<BinaryMapDataObject> resultMatcher = new ResultMatcher<BinaryMapDataObject>(){
                long lastPublishTime = System.currentTimeMillis();

                @Override
                public boolean publish(BinaryMapDataObject pObject) {
                    for (int j = 1; j < pObject.getPointsLength(); ++j) {
                        double fromLat = MapUtils.get31LatitudeY(pObject.getPoint31YTile(j - 1));
                        double fromLon = MapUtils.get31LongitudeX(pObject.getPoint31XTile(j - 1));
                        double toLat = MapUtils.get31LatitudeY(pObject.getPoint31YTile(j));
                        double toLon = MapUtils.get31LongitudeX(pObject.getPoint31XTile(j));
                        for (WptPtDistStruct distStruct : allDistances) {
                            double dist;
                            if (distStruct.distance <= 5.0 || !((dist = MapUtils.getOrthogonalDistance(distStruct.mPoint.getLatitude(), distStruct.mPoint.getLongitude(), fromLat, fromLon, toLat, toLon)) < distStruct.distance)) continue;
                            distStruct.nearest = pObject;
                            distStruct.distance = dist;
                        }
                    }
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    if (System.currentTimeMillis() - this.lastPublishTime > 1000L) {
                        this.lastPublishTime = System.currentTimeMillis();
                        ElevationHelper.this.updateElevationsInList(allDistances);
                        pInput.updateGraphPanel();
                    }
                    return pInput.isCancelled();
                }
            };
            BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> req = BinaryMapIndexReader.buildSearchRequest(lb, rb, tb, bb, 22, new BinaryMapIndexReader.SearchFilter(){

                @Override
                public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex pIndex) {
                    for (int j = 0; j < types.size(); ++j) {
                        int type = types.get(j);
                        BinaryMapIndexReader.TagValuePair dType = pIndex.decodeType(type);
                        if (dType == null || !dType.tag.equals("contour") || !dType.value.equals("elevation")) continue;
                        return true;
                    }
                    return false;
                }
            }, resultMatcher);
            try {
                reader.searchMapIndex(req);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.updateElevationsInList(allDistances);
    }

    public void updateElevationsInList(List<WptPtDistStruct> allDistances) {
        for (WptPtDistStruct wptPtDistStruct : allDistances) {
            if (wptPtDistStruct.nearest == null) continue;
            double ele1 = this.getElevation(wptPtDistStruct.nearest);
            log.debug((Object)("Elevations for " + wptPtDistStruct.mPoint.getElevation() + ": " + ele1 + ", " + wptPtDistStruct.distance));
            wptPtDistStruct.mPoint.setElevation(ele1);
        }
    }

    public int getElevation(BinaryMapDataObject obj) {
        if (obj != null && !obj.getObjectNames().isEmpty()) {
            String lengthString = obj.getOrderedObjectNames().values().iterator().next();
            int elev = Integer.parseInt(lengthString);
            return elev;
        }
        throw new IllegalArgumentException("obj " + obj.getName() + " has no name :-( :" + obj);
    }

    public static class WptPtDistStruct {
        LatLonHolder mPoint;
        BinaryMapDataObject nearest = null;
        double distance = 2.147483647E9;

        public WptPtDistStruct(LatLonHolder pPoint) {
            this.mPoint = pPoint;
        }
    }

    public static interface LatLonGeneralization {
        public List<LatLonHolder> getPoints();

        public void updateGraphPanel();

        public boolean isCancelled();
    }

    public static interface LatLonHolder {
        public LatLon getLatLon();

        public double getLatitude();

        public double getLongitude();

        public void setElevation(double var1);

        public double getElevation();
    }
}

