// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32F446.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32f446

// STM32F446
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32F446"
)

// Interrupt numbers.
const (
	IRQ_WWDG               = 0  // Universal synchronous asynchronous receiver transmitter
	IRQ_TAMP_STAMP         = 2  // Power control
	IRQ_RTC_WKUP           = 3  //
	IRQ_FLASH              = 4  //
	IRQ_RCC                = 5  // Reset and clock control
	IRQ_EXTI0              = 6  // Power control
	IRQ_EXTI1              = 7  // Power control
	IRQ_EXTI2              = 8  // Power control
	IRQ_EXTI3              = 9  // Power control
	IRQ_EXTI4              = 10 // Power control
	IRQ_DMA1_Stream0       = 11 //
	IRQ_DMA1_Stream1       = 12 //
	IRQ_DMA1_Stream2       = 13 //
	IRQ_DMA1_Stream3       = 14 //
	IRQ_DMA1_Stream4       = 15 //
	IRQ_DMA1_Stream5       = 16 //
	IRQ_DMA1_Stream6       = 17 //
	IRQ_ADC                = 18 // Analog-to-digital converter //
	IRQ_CAN1_TX            = 19 // USB on the go high speed
	IRQ_CAN1_RX0           = 20 // USB on the go high speed
	IRQ_CAN1_RX1           = 21 // USB on the go high speed
	IRQ_CAN1_SCE           = 22 // USB on the go high speed
	IRQ_EXTI9_5            = 23 // Power control
	IRQ_TIM1_BRK_TIM9      = 24 // General-purpose-timers
	IRQ_TIM1_UP_TIM10      = 25 //
	IRQ_TIM1_TRG_COM_TIM11 = 26 //
	IRQ_TIM1_CC            = 27 // General purpose timers
	IRQ_TIM2               = 28 //
	IRQ_TIM3               = 29 // General-purpose-timers
	IRQ_TIM4               = 30 // General purpose timers
	IRQ_I2C1_EV            = 31 // Window watchdog
	IRQ_I2C1_ER            = 32 // Window watchdog
	IRQ_I2C2_EV            = 33 // Independent watchdog
	IRQ_I2C2_ER            = 34 // Independent watchdog
	IRQ_SPI1               = 35 // Serial peripheral interface
	IRQ_SPI2               = 36 //
	IRQ_USART1             = 37 //
	IRQ_USART2             = 38 //
	IRQ_USART3             = 39 //
	IRQ_EXTI15_10          = 40 // Power control
	IRQ_RTC_Alarm          = 41 //
	IRQ_OTG_FS_WKUP        = 42 // Nested Vectored Interrupt Controller
	IRQ_TIM8_BRK_TIM12     = 43 //
	IRQ_TIM8_UP_TIM13      = 44 // General purpose timers
	IRQ_TIM8_TRG_COM_TIM14 = 45 // General purpose timers
	IRQ_TIM8_CC            = 46 // General purpose timers
	IRQ_DMA1_Stream7       = 47 //
	IRQ_FMC                = 48 // Flexible memory controller
	IRQ_TIM5               = 50 //
	IRQ_SPI3               = 51 //
	IRQ_UART4              = 52 // Common ADC registers
	IRQ_UART5              = 53 // Advanced-timers
	IRQ_TIM6_DAC           = 54 // Cryptographic processor
	IRQ_TIM7               = 55 // USB on the go full speed
	IRQ_DMA2_Stream0       = 56 // DMA controller
	IRQ_DMA2_Stream1       = 57 // DMA controller
	IRQ_DMA2_Stream2       = 58 // DMA controller
	IRQ_DMA2_Stream3       = 59 // DMA controller
	IRQ_DMA2_Stream4       = 60 // DMA controller
	IRQ_ETH                = 61 // USB on the go full speed
	IRQ_ETH_WKUP           = 62 // USB on the go full speed
	IRQ_CAN2_TX            = 63 // USB on the go high speed
	IRQ_CAN2_RX0           = 64 // USB on the go high speed
	IRQ_CAN2_RX1           = 65 // USB on the go high speed
	IRQ_CAN2_SCE           = 66 // USB on the go high speed
	IRQ_OTG_FS             = 67 // Nested Vectored Interrupt Controller
	IRQ_DMA2_Stream5       = 68 // DMA controller
	IRQ_DMA2_Stream6       = 69 // DMA controller
	IRQ_DMA2_Stream7       = 70 // DMA controller
	IRQ_USART6             = 71 // Universal synchronous asynchronous receiver transmitter
	IRQ_I2C3_EV            = 72 //
	IRQ_I2C3_ER            = 73 //
	IRQ_DCMI               = 78 // Digital camera interface
	IRQ_FPU                = 81 // Floting point unit
	IRQ_UART7              = 82 // Digital-to-analog converter
	IRQ_UART8              = 83 // Inter-integrated circuit
	IRQ_SPI4               = 84 //
	IRQ_LCD_TFT            = 88 // QuadSPI interface
	IRQ_LCD_TFT_1          = 89 // QuadSPI interface
	IRQ_max                = 89 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_TAMP_STAMP, "TAMP_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2, "EXTI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream0, "DMA1_Stream0_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream1, "DMA1_Stream1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream2, "DMA1_Stream2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream3, "DMA1_Stream3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream4, "DMA1_Stream4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream5, "DMA1_Stream5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream6, "DMA1_Stream6_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_TX, "CAN1_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX0, "CAN1_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX1, "CAN1_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_SCE, "CAN1_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5, "EXTI9_5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_TIM9, "TIM1_BRK_TIM9_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP_TIM10, "TIM1_UP_TIM10_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM11, "TIM1_TRG_COM_TIM11_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM4, "TIM4_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV, "I2C1_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV, "I2C2_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER, "I2C2_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10, "EXTI15_10_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_Alarm, "RTC_Alarm_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS_WKUP, "OTG_FS_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_BRK_TIM12, "TIM8_BRK_TIM12_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_UP_TIM13, "TIM8_UP_TIM13_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_TRG_COM_TIM14, "TIM8_TRG_COM_TIM14_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_CC, "TIM8_CC_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream7, "DMA1_Stream7_IRQHandler")
	_ = interrupt.Register(IRQ_FMC, "FMC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM5, "TIM5_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3, "SPI3_IRQHandler")
	_ = interrupt.Register(IRQ_UART4, "UART4_IRQHandler")
	_ = interrupt.Register(IRQ_UART5, "UART5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DAC, "TIM6_DAC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream0, "DMA2_Stream0_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream1, "DMA2_Stream1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream2, "DMA2_Stream2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream3, "DMA2_Stream3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream4, "DMA2_Stream4_IRQHandler")
	_ = interrupt.Register(IRQ_ETH, "ETH_IRQHandler")
	_ = interrupt.Register(IRQ_ETH_WKUP, "ETH_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_TX, "CAN2_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_RX0, "CAN2_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_RX1, "CAN2_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_SCE, "CAN2_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS, "OTG_FS_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream5, "DMA2_Stream5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream6, "DMA2_Stream6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream7, "DMA2_Stream7_IRQHandler")
	_ = interrupt.Register(IRQ_USART6, "USART6_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_EV, "I2C3_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_ER, "I2C3_ER_IRQHandler")
	_ = interrupt.Register(IRQ_DCMI, "DCMI_IRQHandler")
	_ = interrupt.Register(IRQ_FPU, "FPU_IRQHandler")
	_ = interrupt.Register(IRQ_UART7, "UART7_IRQHandler")
	_ = interrupt.Register(IRQ_UART8, "UART8_IRQHandler")
	_ = interrupt.Register(IRQ_SPI4, "SPI4_IRQHandler")
	_ = interrupt.Register(IRQ_LCD_TFT, "LCD_TFT_IRQHandler")
	_ = interrupt.Register(IRQ_LCD_TFT_1, "LCD_TFT_1_IRQHandler")
)

// Peripherals.
var (
	DCMI          = (*DCMI_Type)(unsafe.Pointer(uintptr(0x50050000)))       // Digital camera interface
	FMC           = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))       // Flexible memory controller
	DBG           = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))        // Debug support
	DMA2          = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))        // DMA controller
	RCC           = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))        // Reset and clock control
	GPIOH         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))       // General-purpose I/Os
	GPIOB         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))       // General-purpose I/Os
	GPIOA         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))       // General-purpose I/Os
	SYSCFG        = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))     // System configuration controller
	SPI1          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))        // Serial peripheral interface
	ADC1          = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))        // Analog-to-digital converter
	USART6        = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))      // Universal synchronous asynchronous receiver transmitter
	DAC           = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))        // Digital-to-analog converter
	I2C3          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))        // Inter-integrated circuit
	IWDG          = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))       // Independent watchdog
	WWDG          = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))       // Window watchdog
	RTC           = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))        // Real-time clock
	UART4         = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))      // Universal synchronous asynchronous receiver transmitter
	C_ADC         = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012300)))        // Common ADC registers
	TIM1          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))        // Advanced-timers
	TIM2          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))        // General purpose timers
	TIM3          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))        // General purpose timers
	TIM5          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))        // General-purpose-timers
	TIM9          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))        // General purpose timers
	TIM10         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))        // General-purpose-timers
	TIM11         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))        // General-purpose-timers
	TIM6          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))        // Basic timers
	CRC           = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))        // Cryptographic processor
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000))) // USB on the go full speed
	OTG_FS_HOST   = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400))) // USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800))) // USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00))) // USB on the go full speed
	CAN1          = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))        // Controller area network
	NVIC          = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))       // Nested Vectored Interrupt Controller
	FLASH         = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))      // FLASH
	EXTI          = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))       // External interrupt/event controller
	OTG_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040000))) // USB on the go high speed
	OTG_HS_HOST   = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040400))) // USB on the go high speed
	OTG_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040800))) // USB on the go high speed
	OTG_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040e00))) // USB on the go high speed
	SAI1          = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))        // Serial audio interface
	PWR           = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))        // Power control
	QUADSPI       = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))    // QuadSPI interface
	SPDIF_RX      = (*SPDIF_RX_Type)(unsafe.Pointer(uintptr(0x40004000)))   // Receiver Interface
	SDMMC         = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40012c00)))      // SDMMC
	HDMI_CEC      = (*HDMI_CEC_Type)(unsafe.Pointer(uintptr(0x40006c00)))   // HDMI-CEC controller
	FPU           = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))        // Floting point unit
	MPU           = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))        // Memory protection unit
	STK           = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))        // SysTick timer
	SCB           = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))        // System control block
	NVIC_STIR     = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))       // Nested vectored interrupt controller
	FPU_CPACR     = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))        // Floating point unit CPACR
	SCB_ACTRL     = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))        // System control block ACTLR
	DMA1          = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))        // DMA controller
	GPIOG         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))       // General-purpose I/Os
	GPIOF         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))       // General-purpose I/Os
	GPIOE         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))       // General-purpose I/Os
	GPIOD         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))       // General-purpose I/Os
	GPIOC         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))       // General-purpose I/Os
	SPI2          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))        // Serial peripheral interface
	SPI3          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))        // Serial peripheral interface
	SPI4          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))        // Serial peripheral interface
	ADC2          = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012100)))        // Analog-to-digital converter
	ADC3          = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012200)))        // Analog-to-digital converter
	USART1        = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))      // Universal synchronous asynchronous receiver transmitter
	USART2        = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))      // Universal synchronous asynchronous receiver transmitter
	USART3        = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))      // Universal synchronous asynchronous receiver transmitter
	I2C2          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))        // Inter-integrated circuit
	I2C1          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))        // Inter-integrated circuit
	UART5         = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))      // Universal synchronous asynchronous receiver transmitter
	TIM8          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))        // Advanced-timers
	TIM4          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))        // General purpose timers
	TIM12         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))        // General purpose timers
	TIM13         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))        // General-purpose-timers
	TIM14         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))        // General-purpose-timers
	TIM7          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))        // Basic timers
	CAN2          = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006800)))        // Controller area network
	SAI2          = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015c00)))        // Serial audio interface
)

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// Flexible memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [64]byte
	PCR2  volatile.Register32 // 0x60
	SR2   volatile.Register32 // 0x64
	PMEM2 volatile.Register32 // 0x68
	PATT2 volatile.Register32 // 0x6C
	_     [4]byte
	ECCR2 volatile.Register32 // 0x74
	_     [8]byte
	PCR3  volatile.Register32 // 0x80
	SR3   volatile.Register32 // 0x84
	PMEM3 volatile.Register32 // 0x88
	PATT3 volatile.Register32 // 0x8C
	_     [4]byte
	ECCR3 volatile.Register32 // 0x94
	_     [8]byte
	PCR4  volatile.Register32 // 0xA0
	SR4   volatile.Register32 // 0xA4
	PMEM4 volatile.Register32 // 0xA8
	PATT4 volatile.Register32 // 0xAC
	PIO4  volatile.Register32 // 0xB0
	_     [80]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
	_     [32]byte
	SDCR1 volatile.Register32 // 0x140
	SDCR2 volatile.Register32 // 0x144
	SDTR1 volatile.Register32 // 0x148
	SDTR2 volatile.Register32 // 0x14C
	SDCMR volatile.Register32 // 0x150
	SDRTR volatile.Register32 // 0x154
	SDSR  volatile.Register32 // 0x158
}

// Debug support
type DBG_Type struct {
	DBGMCU_IDCODE  volatile.Register32 // 0x0
	DBGMCU_CR      volatile.Register32 // 0x4
	DBGMCU_APB1_FZ volatile.Register32 // 0x8
	DBGMCU_APB2_FZ volatile.Register32 // 0xC
}

// DMA controller
type DMA_Type struct {
	LISR   volatile.Register32 // 0x0
	HISR   volatile.Register32 // 0x4
	LIFCR  volatile.Register32 // 0x8
	HIFCR  volatile.Register32 // 0xC
	S0CR   volatile.Register32 // 0x10
	S0NDTR volatile.Register32 // 0x14
	S0PAR  volatile.Register32 // 0x18
	S0M0AR volatile.Register32 // 0x1C
	S0M1AR volatile.Register32 // 0x20
	S0FCR  volatile.Register32 // 0x24
	S1CR   volatile.Register32 // 0x28
	S1NDTR volatile.Register32 // 0x2C
	S1PAR  volatile.Register32 // 0x30
	S1M0AR volatile.Register32 // 0x34
	S1M1AR volatile.Register32 // 0x38
	S1FCR  volatile.Register32 // 0x3C
	S2CR   volatile.Register32 // 0x40
	S2NDTR volatile.Register32 // 0x44
	S2PAR  volatile.Register32 // 0x48
	S2M0AR volatile.Register32 // 0x4C
	S2M1AR volatile.Register32 // 0x50
	S2FCR  volatile.Register32 // 0x54
	S3CR   volatile.Register32 // 0x58
	S3NDTR volatile.Register32 // 0x5C
	S3PAR  volatile.Register32 // 0x60
	S3M0AR volatile.Register32 // 0x64
	S3M1AR volatile.Register32 // 0x68
	S3FCR  volatile.Register32 // 0x6C
	S4CR   volatile.Register32 // 0x70
	S4NDTR volatile.Register32 // 0x74
	S4PAR  volatile.Register32 // 0x78
	S4M0AR volatile.Register32 // 0x7C
	S4M1AR volatile.Register32 // 0x80
	S4FCR  volatile.Register32 // 0x84
	S5CR   volatile.Register32 // 0x88
	S5NDTR volatile.Register32 // 0x8C
	S5PAR  volatile.Register32 // 0x90
	S5M0AR volatile.Register32 // 0x94
	S5M1AR volatile.Register32 // 0x98
	S5FCR  volatile.Register32 // 0x9C
	S6CR   volatile.Register32 // 0xA0
	S6NDTR volatile.Register32 // 0xA4
	S6PAR  volatile.Register32 // 0xA8
	S6M0AR volatile.Register32 // 0xAC
	S6M1AR volatile.Register32 // 0xB0
	S6FCR  volatile.Register32 // 0xB4
	S7CR   volatile.Register32 // 0xB8
	S7NDTR volatile.Register32 // 0xBC
	S7PAR  volatile.Register32 // 0xC0
	S7M0AR volatile.Register32 // 0xC4
	S7M1AR volatile.Register32 // 0xC8
	S7FCR  volatile.Register32 // 0xCC
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	AHB3RSTR   volatile.Register32 // 0x18
	_          [4]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	AHB3ENR    volatile.Register32 // 0x38
	_          [4]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	AHB3LPENR  volatile.Register32 // 0x58
	_          [4]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
	PLLSAICFGR volatile.Register32 // 0x88
	DCKCFGR    volatile.Register32 // 0x8C
	CKGATENR   volatile.Register32 // 0x90
	DCKCFGR2   volatile.Register32 // 0x94
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRM   volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	SR   volatile.Register32 // 0x0
	DR   volatile.Register32 // 0x4
	BRR  volatile.Register32 // 0x8
	CR1  volatile.Register32 // 0xC
	CR2  volatile.Register32 // 0x10
	CR3  volatile.Register32 // 0x14
	GTPR volatile.Register32 // 0x18
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	OAR1  volatile.Register32 // 0x8
	OAR2  volatile.Register32 // 0xC
	DR    volatile.Register32 // 0x10
	SR1   volatile.Register32 // 0x14
	SR2   volatile.Register32 // 0x18
	CCR   volatile.Register32 // 0x1C
	TRISE volatile.Register32 // 0x20
	FLTR  volatile.Register32 // 0x24
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CALIBR   volatile.Register32 // 0x18
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// Cryptographic processor
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	FS_GOTGCTL          volatile.Register32 // 0x0
	FS_GOTGINT          volatile.Register32 // 0x4
	FS_GAHBCFG          volatile.Register32 // 0x8
	FS_GUSBCFG          volatile.Register32 // 0xC
	FS_GRSTCTL          volatile.Register32 // 0x10
	FS_GINTSTS          volatile.Register32 // 0x14
	FS_GINTMSK          volatile.Register32 // 0x18
	FS_GRXSTSR_Device   volatile.Register32 // 0x1C
	_                   [4]byte
	FS_GRXFSIZ          volatile.Register32 // 0x24
	FS_GNPTXFSIZ_Device volatile.Register32 // 0x28
	FS_GNPTXSTS         volatile.Register32 // 0x2C
	_                   [8]byte
	FS_GCCFG            volatile.Register32 // 0x38
	FS_CID              volatile.Register32 // 0x3C
	_                   [192]byte
	FS_HPTXFSIZ         volatile.Register32 // 0x100
	FS_DIEPTXF1         volatile.Register32 // 0x104
	FS_DIEPTXF2         volatile.Register32 // 0x108
	FS_DIEPTXF3         volatile.Register32 // 0x10C
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TI0R  volatile.Register32 // 0x180
	TDT0R volatile.Register32 // 0x184
	TDL0R volatile.Register32 // 0x188
	TDH0R volatile.Register32 // 0x18C
	TI1R  volatile.Register32 // 0x190
	TDT1R volatile.Register32 // 0x194
	TDL1R volatile.Register32 // 0x198
	TDH1R volatile.Register32 // 0x19C
	TI2R  volatile.Register32 // 0x1A0
	TDT2R volatile.Register32 // 0x1A4
	TDL2R volatile.Register32 // 0x1A8
	TDH2R volatile.Register32 // 0x1AC
	RI0R  volatile.Register32 // 0x1B0
	RDT0R volatile.Register32 // 0x1B4
	RDL0R volatile.Register32 // 0x1B8
	RDH0R volatile.Register32 // 0x1BC
	RI1R  volatile.Register32 // 0x1C0
	RDT1R volatile.Register32 // 0x1C4
	RDL1R volatile.Register32 // 0x1C8
	RDH1R volatile.Register32 // 0x1CC
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	F0R1  volatile.Register32 // 0x240
	F0R2  volatile.Register32 // 0x244
	F1R1  volatile.Register32 // 0x248
	F1R2  volatile.Register32 // 0x24C
	F2R1  volatile.Register32 // 0x250
	F2R2  volatile.Register32 // 0x254
	F3R1  volatile.Register32 // 0x258
	F3R2  volatile.Register32 // 0x25C
	F4R1  volatile.Register32 // 0x260
	F4R2  volatile.Register32 // 0x264
	F5R1  volatile.Register32 // 0x268
	F5R2  volatile.Register32 // 0x26C
	F6R1  volatile.Register32 // 0x270
	F6R2  volatile.Register32 // 0x274
	F7R1  volatile.Register32 // 0x278
	F7R2  volatile.Register32 // 0x27C
	F8R1  volatile.Register32 // 0x280
	F8R2  volatile.Register32 // 0x284
	F9R1  volatile.Register32 // 0x288
	F9R2  volatile.Register32 // 0x28C
	F10R1 volatile.Register32 // 0x290
	F10R2 volatile.Register32 // 0x294
	F11R1 volatile.Register32 // 0x298
	F11R2 volatile.Register32 // 0x29C
	F12R1 volatile.Register32 // 0x2A0
	F12R2 volatile.Register32 // 0x2A4
	F13R1 volatile.Register32 // 0x2A8
	F13R2 volatile.Register32 // 0x2AC
	F14R1 volatile.Register32 // 0x2B0
	F14R2 volatile.Register32 // 0x2B4
	F15R1 volatile.Register32 // 0x2B8
	F15R2 volatile.Register32 // 0x2BC
	F16R1 volatile.Register32 // 0x2C0
	F16R2 volatile.Register32 // 0x2C4
	F17R1 volatile.Register32 // 0x2C8
	F17R2 volatile.Register32 // 0x2CC
	F18R1 volatile.Register32 // 0x2D0
	F18R2 volatile.Register32 // 0x2D4
	F19R1 volatile.Register32 // 0x2D8
	F19R2 volatile.Register32 // 0x2DC
	F20R1 volatile.Register32 // 0x2E0
	F20R2 volatile.Register32 // 0x2E4
	F21R1 volatile.Register32 // 0x2E8
	F21R2 volatile.Register32 // 0x2EC
	F22R1 volatile.Register32 // 0x2F0
	F22R2 volatile.Register32 // 0x2F4
	F23R1 volatile.Register32 // 0x2F8
	F23R2 volatile.Register32 // 0x2FC
	F24R1 volatile.Register32 // 0x300
	F24R2 volatile.Register32 // 0x304
	F25R1 volatile.Register32 // 0x308
	F25R2 volatile.Register32 // 0x30C
	F26R1 volatile.Register32 // 0x310
	F26R2 volatile.Register32 // 0x314
	F27R1 volatile.Register32 // 0x318
	F27R2 volatile.Register32 // 0x31C
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// USB on the go high speed
type USB_OTG_HS_Type struct {
	OTG_HS_GOTGCTL        volatile.Register32 // 0x0
	OTG_HS_GOTGINT        volatile.Register32 // 0x4
	OTG_HS_GAHBCFG        volatile.Register32 // 0x8
	OTG_HS_GUSBCFG        volatile.Register32 // 0xC
	OTG_HS_GRSTCTL        volatile.Register32 // 0x10
	OTG_HS_GINTSTS        volatile.Register32 // 0x14
	OTG_HS_GINTMSK        volatile.Register32 // 0x18
	OTG_HS_GRXSTSR_Host   volatile.Register32 // 0x1C
	OTG_HS_GRXSTSP_Host   volatile.Register32 // 0x20
	OTG_HS_GRXFSIZ        volatile.Register32 // 0x24
	OTG_HS_GNPTXFSIZ_Host volatile.Register32 // 0x28
	OTG_HS_GNPTXSTS       volatile.Register32 // 0x2C
	_                     [8]byte
	OTG_HS_GCCFG          volatile.Register32 // 0x38
	OTG_HS_CID            volatile.Register32 // 0x3C
	_                     [192]byte
	OTG_HS_HPTXFSIZ       volatile.Register32 // 0x100
	OTG_HS_DIEPTXF1       volatile.Register32 // 0x104
	OTG_HS_DIEPTXF2       volatile.Register32 // 0x108
	_                     [16]byte
	OTG_HS_DIEPTXF3       volatile.Register32 // 0x11C
	OTG_HS_DIEPTXF4       volatile.Register32 // 0x120
	OTG_HS_DIEPTXF5       volatile.Register32 // 0x124
	OTG_HS_DIEPTXF6       volatile.Register32 // 0x128
	OTG_HS_DIEPTXF7       volatile.Register32 // 0x12C
}

// Serial audio interface
type SAI_Type struct {
	GCR    volatile.Register32 // 0x0
	ACR1   volatile.Register32 // 0x4
	ACR2   volatile.Register32 // 0x8
	AFRCR  volatile.Register32 // 0xC
	ASLOTR volatile.Register32 // 0x10
	AIM    volatile.Register32 // 0x14
	ASR    volatile.Register32 // 0x18
	ACLRFR volatile.Register32 // 0x1C
	ADR    volatile.Register32 // 0x20
	BCR1   volatile.Register32 // 0x24
	BCR2   volatile.Register32 // 0x28
	BFRCR  volatile.Register32 // 0x2C
	BSLOTR volatile.Register32 // 0x30
	BIM    volatile.Register32 // 0x34
	BSR    volatile.Register32 // 0x38
	BCLRFR volatile.Register32 // 0x3C
	BDR    volatile.Register32 // 0x40
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// Receiver Interface
type SPDIF_RX_Type struct {
	CR   volatile.Register32 // 0x0
	IMR  volatile.Register32 // 0x4
	SR   volatile.Register32 // 0x8
	IFCR volatile.Register32 // 0xC
	DR   volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	DIR  volatile.Register32 // 0x18
}

// SDMMC
type SDMMC_Type struct {
	SDMMC_POWER      volatile.Register32 // 0x0
	SDMMC_CLKCR      volatile.Register32 // 0x4
	SDMMC_ARGR       volatile.Register32 // 0x8
	SDMMC_CMDR       volatile.Register32 // 0xC
	SDMMC_RESP1R     volatile.Register32 // 0x10
	SDMMC_RESP2R     volatile.Register32 // 0x14
	SDMMC_RESP3R     volatile.Register32 // 0x18
	SDMMC_RESP4R     volatile.Register32 // 0x1C
	_                [4]byte
	SDMMC_DTIMER     volatile.Register32 // 0x24
	SDMMC_DLENR      volatile.Register32 // 0x28
	SDMMC_DCTRL      volatile.Register32 // 0x2C
	SDMMC_DCNTR      volatile.Register32 // 0x30
	SDMMC_STAR       volatile.Register32 // 0x34
	SDMMC_ICR        volatile.Register32 // 0x38
	SDMMC_MASKR      volatile.Register32 // 0x3C
	SDMMC_ACKTIMER   volatile.Register32 // 0x40
	_                [12]byte
	SDMMC_IDMACTRLR  volatile.Register32 // 0x50
	SDMMC_IDMABSIZER volatile.Register32 // 0x54
	SDMMC_IDMABASE0R volatile.Register32 // 0x58
	SDMMC_IDMABASE1R volatile.Register32 // 0x5C
	SDMMC_RESPCMDR   volatile.Register32 // 0x60
	_                [28]byte
	SDMMC_FIFOR      volatile.Register32 // 0x80
	_                [880]byte
	SDMMC_VER        volatile.Register32 // 0x3F4
	SDMMC_ID         volatile.Register32 // 0x3F8
}

// HDMI-CEC controller
type HDMI_CEC_Type struct {
	CEC_CR   volatile.Register32 // 0x0
	CEC_CFGR volatile.Register32 // 0x4
	CEC_TXDR volatile.Register32 // 0x8
	CEC_RXDR volatile.Register32 // 0xC
	CEC_ISR  volatile.Register32 // 0x10
	CEC_IER  volatile.Register32 // 0x14
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// Bitfields for DCMI: Digital camera interface
const (
	// CR: control register 1
	DCMI_CR_CAPTURE_Pos = 0x0      // Position of CAPTURE field.
	DCMI_CR_CAPTURE_Msk = 0x1      // Bit mask of CAPTURE field.
	DCMI_CR_CAPTURE     = 0x1      // Bit CAPTURE.
	DCMI_CR_CM_Pos      = 0x1      // Position of CM field.
	DCMI_CR_CM_Msk      = 0x2      // Bit mask of CM field.
	DCMI_CR_CM          = 0x2      // Bit CM.
	DCMI_CR_CROP_Pos    = 0x2      // Position of CROP field.
	DCMI_CR_CROP_Msk    = 0x4      // Bit mask of CROP field.
	DCMI_CR_CROP        = 0x4      // Bit CROP.
	DCMI_CR_JPEG_Pos    = 0x3      // Position of JPEG field.
	DCMI_CR_JPEG_Msk    = 0x8      // Bit mask of JPEG field.
	DCMI_CR_JPEG        = 0x8      // Bit JPEG.
	DCMI_CR_ESS_Pos     = 0x4      // Position of ESS field.
	DCMI_CR_ESS_Msk     = 0x10     // Bit mask of ESS field.
	DCMI_CR_ESS         = 0x10     // Bit ESS.
	DCMI_CR_PCKPOL_Pos  = 0x5      // Position of PCKPOL field.
	DCMI_CR_PCKPOL_Msk  = 0x20     // Bit mask of PCKPOL field.
	DCMI_CR_PCKPOL      = 0x20     // Bit PCKPOL.
	DCMI_CR_HSPOL_Pos   = 0x6      // Position of HSPOL field.
	DCMI_CR_HSPOL_Msk   = 0x40     // Bit mask of HSPOL field.
	DCMI_CR_HSPOL       = 0x40     // Bit HSPOL.
	DCMI_CR_VSPOL_Pos   = 0x7      // Position of VSPOL field.
	DCMI_CR_VSPOL_Msk   = 0x80     // Bit mask of VSPOL field.
	DCMI_CR_VSPOL       = 0x80     // Bit VSPOL.
	DCMI_CR_EDM_Pos     = 0xa      // Position of EDM field.
	DCMI_CR_EDM_Msk     = 0xc00    // Bit mask of EDM field.
	DCMI_CR_ENABLE_Pos  = 0xe      // Position of ENABLE field.
	DCMI_CR_ENABLE_Msk  = 0x4000   // Bit mask of ENABLE field.
	DCMI_CR_ENABLE      = 0x4000   // Bit ENABLE.
	DCMI_CR_BSM_Pos     = 0x10     // Position of BSM field.
	DCMI_CR_BSM_Msk     = 0x30000  // Bit mask of BSM field.
	DCMI_CR_OEBS_Pos    = 0x12     // Position of OEBS field.
	DCMI_CR_OEBS_Msk    = 0x40000  // Bit mask of OEBS field.
	DCMI_CR_OEBS        = 0x40000  // Bit OEBS.
	DCMI_CR_LSM_Pos     = 0x13     // Position of LSM field.
	DCMI_CR_LSM_Msk     = 0x80000  // Bit mask of LSM field.
	DCMI_CR_LSM         = 0x80000  // Bit LSM.
	DCMI_CR_OELS_Pos    = 0x14     // Position of OELS field.
	DCMI_CR_OELS_Msk    = 0x100000 // Bit mask of OELS field.
	DCMI_CR_OELS        = 0x100000 // Bit OELS.
	DCMI_CR_FCRC_Pos    = 0x8      // Position of FCRC field.
	DCMI_CR_FCRC_Msk    = 0x300    // Bit mask of FCRC field.

	// SR: status register
	DCMI_SR_FNE_Pos   = 0x2 // Position of FNE field.
	DCMI_SR_FNE_Msk   = 0x4 // Bit mask of FNE field.
	DCMI_SR_FNE       = 0x4 // Bit FNE.
	DCMI_SR_VSYNC_Pos = 0x1 // Position of VSYNC field.
	DCMI_SR_VSYNC_Msk = 0x2 // Bit mask of VSYNC field.
	DCMI_SR_VSYNC     = 0x2 // Bit VSYNC.
	DCMI_SR_HSYNC_Pos = 0x0 // Position of HSYNC field.
	DCMI_SR_HSYNC_Msk = 0x1 // Bit mask of HSYNC field.
	DCMI_SR_HSYNC     = 0x1 // Bit HSYNC.

	// RIS: raw interrupt status register
	DCMI_RIS_LINE_RIS_Pos  = 0x4  // Position of LINE_RIS field.
	DCMI_RIS_LINE_RIS_Msk  = 0x10 // Bit mask of LINE_RIS field.
	DCMI_RIS_LINE_RIS      = 0x10 // Bit LINE_RIS.
	DCMI_RIS_VSYNC_RIS_Pos = 0x3  // Position of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS_Msk = 0x8  // Bit mask of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS     = 0x8  // Bit VSYNC_RIS.
	DCMI_RIS_ERR_RIS_Pos   = 0x2  // Position of ERR_RIS field.
	DCMI_RIS_ERR_RIS_Msk   = 0x4  // Bit mask of ERR_RIS field.
	DCMI_RIS_ERR_RIS       = 0x4  // Bit ERR_RIS.
	DCMI_RIS_OVR_RIS_Pos   = 0x1  // Position of OVR_RIS field.
	DCMI_RIS_OVR_RIS_Msk   = 0x2  // Bit mask of OVR_RIS field.
	DCMI_RIS_OVR_RIS       = 0x2  // Bit OVR_RIS.
	DCMI_RIS_FRAME_RIS_Pos = 0x0  // Position of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS_Msk = 0x1  // Bit mask of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS     = 0x1  // Bit FRAME_RIS.

	// IER: interrupt enable register
	DCMI_IER_LINE_IE_Pos  = 0x4  // Position of LINE_IE field.
	DCMI_IER_LINE_IE_Msk  = 0x10 // Bit mask of LINE_IE field.
	DCMI_IER_LINE_IE      = 0x10 // Bit LINE_IE.
	DCMI_IER_VSYNC_IE_Pos = 0x3  // Position of VSYNC_IE field.
	DCMI_IER_VSYNC_IE_Msk = 0x8  // Bit mask of VSYNC_IE field.
	DCMI_IER_VSYNC_IE     = 0x8  // Bit VSYNC_IE.
	DCMI_IER_ERR_IE_Pos   = 0x2  // Position of ERR_IE field.
	DCMI_IER_ERR_IE_Msk   = 0x4  // Bit mask of ERR_IE field.
	DCMI_IER_ERR_IE       = 0x4  // Bit ERR_IE.
	DCMI_IER_OVR_IE_Pos   = 0x1  // Position of OVR_IE field.
	DCMI_IER_OVR_IE_Msk   = 0x2  // Bit mask of OVR_IE field.
	DCMI_IER_OVR_IE       = 0x2  // Bit OVR_IE.
	DCMI_IER_FRAME_IE_Pos = 0x0  // Position of FRAME_IE field.
	DCMI_IER_FRAME_IE_Msk = 0x1  // Bit mask of FRAME_IE field.
	DCMI_IER_FRAME_IE     = 0x1  // Bit FRAME_IE.

	// MIS: masked interrupt status           register
	DCMI_MIS_LINE_MIS_Pos  = 0x4  // Position of LINE_MIS field.
	DCMI_MIS_LINE_MIS_Msk  = 0x10 // Bit mask of LINE_MIS field.
	DCMI_MIS_LINE_MIS      = 0x10 // Bit LINE_MIS.
	DCMI_MIS_VSYNC_MIS_Pos = 0x3  // Position of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS_Msk = 0x8  // Bit mask of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS     = 0x8  // Bit VSYNC_MIS.
	DCMI_MIS_ERR_MIS_Pos   = 0x2  // Position of ERR_MIS field.
	DCMI_MIS_ERR_MIS_Msk   = 0x4  // Bit mask of ERR_MIS field.
	DCMI_MIS_ERR_MIS       = 0x4  // Bit ERR_MIS.
	DCMI_MIS_OVR_MIS_Pos   = 0x1  // Position of OVR_MIS field.
	DCMI_MIS_OVR_MIS_Msk   = 0x2  // Bit mask of OVR_MIS field.
	DCMI_MIS_OVR_MIS       = 0x2  // Bit OVR_MIS.
	DCMI_MIS_FRAME_MIS_Pos = 0x0  // Position of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS_Msk = 0x1  // Bit mask of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS     = 0x1  // Bit FRAME_MIS.

	// ICR: interrupt clear register
	DCMI_ICR_LINE_ISC_Pos  = 0x4  // Position of LINE_ISC field.
	DCMI_ICR_LINE_ISC_Msk  = 0x10 // Bit mask of LINE_ISC field.
	DCMI_ICR_LINE_ISC      = 0x10 // Bit LINE_ISC.
	DCMI_ICR_VSYNC_ISC_Pos = 0x3  // Position of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC_Msk = 0x8  // Bit mask of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC     = 0x8  // Bit VSYNC_ISC.
	DCMI_ICR_ERR_ISC_Pos   = 0x2  // Position of ERR_ISC field.
	DCMI_ICR_ERR_ISC_Msk   = 0x4  // Bit mask of ERR_ISC field.
	DCMI_ICR_ERR_ISC       = 0x4  // Bit ERR_ISC.
	DCMI_ICR_OVR_ISC_Pos   = 0x1  // Position of OVR_ISC field.
	DCMI_ICR_OVR_ISC_Msk   = 0x2  // Bit mask of OVR_ISC field.
	DCMI_ICR_OVR_ISC       = 0x2  // Bit OVR_ISC.
	DCMI_ICR_FRAME_ISC_Pos = 0x0  // Position of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC_Msk = 0x1  // Bit mask of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC     = 0x1  // Bit FRAME_ISC.

	// ESCR: embedded synchronization code           register
	DCMI_ESCR_FEC_Pos = 0x18       // Position of FEC field.
	DCMI_ESCR_FEC_Msk = 0xff000000 // Bit mask of FEC field.
	DCMI_ESCR_LEC_Pos = 0x10       // Position of LEC field.
	DCMI_ESCR_LEC_Msk = 0xff0000   // Bit mask of LEC field.
	DCMI_ESCR_LSC_Pos = 0x8        // Position of LSC field.
	DCMI_ESCR_LSC_Msk = 0xff00     // Bit mask of LSC field.
	DCMI_ESCR_FSC_Pos = 0x0        // Position of FSC field.
	DCMI_ESCR_FSC_Msk = 0xff       // Bit mask of FSC field.

	// ESUR: embedded synchronization unmask           register
	DCMI_ESUR_FEU_Pos = 0x18       // Position of FEU field.
	DCMI_ESUR_FEU_Msk = 0xff000000 // Bit mask of FEU field.
	DCMI_ESUR_LEU_Pos = 0x10       // Position of LEU field.
	DCMI_ESUR_LEU_Msk = 0xff0000   // Bit mask of LEU field.
	DCMI_ESUR_LSU_Pos = 0x8        // Position of LSU field.
	DCMI_ESUR_LSU_Msk = 0xff00     // Bit mask of LSU field.
	DCMI_ESUR_FSU_Pos = 0x0        // Position of FSU field.
	DCMI_ESUR_FSU_Msk = 0xff       // Bit mask of FSU field.

	// CWSTRT: crop window start
	DCMI_CWSTRT_VST_Pos     = 0x10       // Position of VST field.
	DCMI_CWSTRT_VST_Msk     = 0x1fff0000 // Bit mask of VST field.
	DCMI_CWSTRT_HOFFCNT_Pos = 0x0        // Position of HOFFCNT field.
	DCMI_CWSTRT_HOFFCNT_Msk = 0x3fff     // Bit mask of HOFFCNT field.

	// CWSIZE: crop window size
	DCMI_CWSIZE_VLINE_Pos  = 0x10       // Position of VLINE field.
	DCMI_CWSIZE_VLINE_Msk  = 0x3fff0000 // Bit mask of VLINE field.
	DCMI_CWSIZE_CAPCNT_Pos = 0x0        // Position of CAPCNT field.
	DCMI_CWSIZE_CAPCNT_Msk = 0x3fff     // Bit mask of CAPCNT field.

	// DR: data register
	DCMI_DR_Byte3_Pos = 0x18       // Position of Byte3 field.
	DCMI_DR_Byte3_Msk = 0xff000000 // Bit mask of Byte3 field.
	DCMI_DR_Byte2_Pos = 0x10       // Position of Byte2 field.
	DCMI_DR_Byte2_Msk = 0xff0000   // Bit mask of Byte2 field.
	DCMI_DR_Byte1_Pos = 0x8        // Position of Byte1 field.
	DCMI_DR_Byte1_Msk = 0xff00     // Bit mask of Byte1 field.
	DCMI_DR_Byte0_Pos = 0x0        // Position of Byte0 field.
	DCMI_DR_Byte0_Msk = 0xff       // Bit mask of Byte0 field.
)

// Bitfields for FMC: Flexible memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register           1
	FSMC_BCR1_CCLKEN_Pos    = 0x14     // Position of CCLKEN field.
	FSMC_BCR1_CCLKEN_Msk    = 0x100000 // Bit mask of CCLKEN field.
	FSMC_BCR1_CCLKEN        = 0x100000 // Bit CCLKEN.
	FSMC_BCR1_CBURSTRW_Pos  = 0x13     // Position of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Msk  = 0x80000  // Bit mask of CBURSTRW field.
	FSMC_BCR1_CBURSTRW      = 0x80000  // Bit CBURSTRW.
	FSMC_BCR1_ASYNCWAIT_Pos = 0xf      // Position of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Msk = 0x8000   // Bit mask of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT     = 0x8000   // Bit ASYNCWAIT.
	FSMC_BCR1_EXTMOD_Pos    = 0xe      // Position of EXTMOD field.
	FSMC_BCR1_EXTMOD_Msk    = 0x4000   // Bit mask of EXTMOD field.
	FSMC_BCR1_EXTMOD        = 0x4000   // Bit EXTMOD.
	FSMC_BCR1_WAITEN_Pos    = 0xd      // Position of WAITEN field.
	FSMC_BCR1_WAITEN_Msk    = 0x2000   // Bit mask of WAITEN field.
	FSMC_BCR1_WAITEN        = 0x2000   // Bit WAITEN.
	FSMC_BCR1_WREN_Pos      = 0xc      // Position of WREN field.
	FSMC_BCR1_WREN_Msk      = 0x1000   // Bit mask of WREN field.
	FSMC_BCR1_WREN          = 0x1000   // Bit WREN.
	FSMC_BCR1_WAITCFG_Pos   = 0xb      // Position of WAITCFG field.
	FSMC_BCR1_WAITCFG_Msk   = 0x800    // Bit mask of WAITCFG field.
	FSMC_BCR1_WAITCFG       = 0x800    // Bit WAITCFG.
	FSMC_BCR1_WAITPOL_Pos   = 0x9      // Position of WAITPOL field.
	FSMC_BCR1_WAITPOL_Msk   = 0x200    // Bit mask of WAITPOL field.
	FSMC_BCR1_WAITPOL       = 0x200    // Bit WAITPOL.
	FSMC_BCR1_BURSTEN_Pos   = 0x8      // Position of BURSTEN field.
	FSMC_BCR1_BURSTEN_Msk   = 0x100    // Bit mask of BURSTEN field.
	FSMC_BCR1_BURSTEN       = 0x100    // Bit BURSTEN.
	FSMC_BCR1_FACCEN_Pos    = 0x6      // Position of FACCEN field.
	FSMC_BCR1_FACCEN_Msk    = 0x40     // Bit mask of FACCEN field.
	FSMC_BCR1_FACCEN        = 0x40     // Bit FACCEN.
	FSMC_BCR1_MWID_Pos      = 0x4      // Position of MWID field.
	FSMC_BCR1_MWID_Msk      = 0x30     // Bit mask of MWID field.
	FSMC_BCR1_MTYP_Pos      = 0x2      // Position of MTYP field.
	FSMC_BCR1_MTYP_Msk      = 0xc      // Bit mask of MTYP field.
	FSMC_BCR1_MUXEN_Pos     = 0x1      // Position of MUXEN field.
	FSMC_BCR1_MUXEN_Msk     = 0x2      // Bit mask of MUXEN field.
	FSMC_BCR1_MUXEN         = 0x2      // Bit MUXEN.
	FSMC_BCR1_MBKEN_Pos     = 0x0      // Position of MBKEN field.
	FSMC_BCR1_MBKEN_Msk     = 0x1      // Bit mask of MBKEN field.
	FSMC_BCR1_MBKEN         = 0x1      // Bit MBKEN.

	// BTR1: SRAM/NOR-Flash chip-select timing register           1
	FSMC_BTR1_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR1_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR1_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR1_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR1_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR1_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR1_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR1_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR1_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR1_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR1_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR1_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR1_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR1_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR2: SRAM/NOR-Flash chip-select control register           2
	FSMC_BCR2_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR2_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR2_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR2_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR2_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR2_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR2_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR2_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR2_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR2_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR2_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR2_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR2_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR2_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR2_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR2_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR2_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR2_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR2_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FSMC_BCR2_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FSMC_BCR2_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FSMC_BCR2_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR2_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR2_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR2_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR2_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR2_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR2_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR2_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR2_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR2_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR2_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR2_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR2_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR2_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR2_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR2_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR2_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR2_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR2_MBKEN         = 0x1     // Bit MBKEN.

	// BTR2: SRAM/NOR-Flash chip-select timing register           2
	FSMC_BTR2_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR2_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR2_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR2_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR2_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR2_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR2_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR2_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR2_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR2_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR2_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR2_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR2_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR2_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR3: SRAM/NOR-Flash chip-select control register           3
	FSMC_BCR3_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR3_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR3_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR3_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR3_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR3_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR3_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR3_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR3_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR3_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR3_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR3_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR3_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR3_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR3_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR3_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR3_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR3_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR3_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FSMC_BCR3_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FSMC_BCR3_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FSMC_BCR3_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR3_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR3_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR3_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR3_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR3_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR3_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR3_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR3_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR3_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR3_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR3_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR3_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR3_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR3_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR3_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR3_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR3_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR3_MBKEN         = 0x1     // Bit MBKEN.

	// BTR3: SRAM/NOR-Flash chip-select timing register           3
	FSMC_BTR3_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR3_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR3_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR3_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR3_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR3_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR3_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR3_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR3_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR3_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR3_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR3_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR3_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR3_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR4: SRAM/NOR-Flash chip-select control register           4
	FSMC_BCR4_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR4_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR4_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR4_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR4_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR4_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR4_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR4_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR4_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR4_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR4_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR4_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR4_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR4_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR4_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR4_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR4_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR4_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR4_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FSMC_BCR4_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FSMC_BCR4_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FSMC_BCR4_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR4_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR4_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR4_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR4_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR4_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR4_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR4_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR4_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR4_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR4_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR4_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR4_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR4_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR4_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR4_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR4_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR4_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR4_MBKEN         = 0x1     // Bit MBKEN.

	// BTR4: SRAM/NOR-Flash chip-select timing register           4
	FSMC_BTR4_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR4_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR4_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR4_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR4_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR4_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR4_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR4_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR4_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR4_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR4_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR4_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR4_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR4_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// PCR2: PC Card/NAND Flash control register           2
	FSMC_PCR2_ECCPS_Pos   = 0x11    // Position of ECCPS field.
	FSMC_PCR2_ECCPS_Msk   = 0xe0000 // Bit mask of ECCPS field.
	FSMC_PCR2_TAR_Pos     = 0xd     // Position of TAR field.
	FSMC_PCR2_TAR_Msk     = 0x1e000 // Bit mask of TAR field.
	FSMC_PCR2_TCLR_Pos    = 0x9     // Position of TCLR field.
	FSMC_PCR2_TCLR_Msk    = 0x1e00  // Bit mask of TCLR field.
	FSMC_PCR2_ECCEN_Pos   = 0x6     // Position of ECCEN field.
	FSMC_PCR2_ECCEN_Msk   = 0x40    // Bit mask of ECCEN field.
	FSMC_PCR2_ECCEN       = 0x40    // Bit ECCEN.
	FSMC_PCR2_PWID_Pos    = 0x4     // Position of PWID field.
	FSMC_PCR2_PWID_Msk    = 0x30    // Bit mask of PWID field.
	FSMC_PCR2_PTYP_Pos    = 0x3     // Position of PTYP field.
	FSMC_PCR2_PTYP_Msk    = 0x8     // Bit mask of PTYP field.
	FSMC_PCR2_PTYP        = 0x8     // Bit PTYP.
	FSMC_PCR2_PBKEN_Pos   = 0x2     // Position of PBKEN field.
	FSMC_PCR2_PBKEN_Msk   = 0x4     // Bit mask of PBKEN field.
	FSMC_PCR2_PBKEN       = 0x4     // Bit PBKEN.
	FSMC_PCR2_PWAITEN_Pos = 0x1     // Position of PWAITEN field.
	FSMC_PCR2_PWAITEN_Msk = 0x2     // Bit mask of PWAITEN field.
	FSMC_PCR2_PWAITEN     = 0x2     // Bit PWAITEN.

	// SR2: FIFO status and interrupt register           2
	FSMC_SR2_FEMPT_Pos = 0x6  // Position of FEMPT field.
	FSMC_SR2_FEMPT_Msk = 0x40 // Bit mask of FEMPT field.
	FSMC_SR2_FEMPT     = 0x40 // Bit FEMPT.
	FSMC_SR2_IFEN_Pos  = 0x5  // Position of IFEN field.
	FSMC_SR2_IFEN_Msk  = 0x20 // Bit mask of IFEN field.
	FSMC_SR2_IFEN      = 0x20 // Bit IFEN.
	FSMC_SR2_ILEN_Pos  = 0x4  // Position of ILEN field.
	FSMC_SR2_ILEN_Msk  = 0x10 // Bit mask of ILEN field.
	FSMC_SR2_ILEN      = 0x10 // Bit ILEN.
	FSMC_SR2_IREN_Pos  = 0x3  // Position of IREN field.
	FSMC_SR2_IREN_Msk  = 0x8  // Bit mask of IREN field.
	FSMC_SR2_IREN      = 0x8  // Bit IREN.
	FSMC_SR2_IFS_Pos   = 0x2  // Position of IFS field.
	FSMC_SR2_IFS_Msk   = 0x4  // Bit mask of IFS field.
	FSMC_SR2_IFS       = 0x4  // Bit IFS.
	FSMC_SR2_ILS_Pos   = 0x1  // Position of ILS field.
	FSMC_SR2_ILS_Msk   = 0x2  // Bit mask of ILS field.
	FSMC_SR2_ILS       = 0x2  // Bit ILS.
	FSMC_SR2_IRS_Pos   = 0x0  // Position of IRS field.
	FSMC_SR2_IRS_Msk   = 0x1  // Bit mask of IRS field.
	FSMC_SR2_IRS       = 0x1  // Bit IRS.

	// PMEM2: Common memory space timing register           2
	FSMC_PMEM2_MEMHIZx_Pos  = 0x18       // Position of MEMHIZx field.
	FSMC_PMEM2_MEMHIZx_Msk  = 0xff000000 // Bit mask of MEMHIZx field.
	FSMC_PMEM2_MEMHOLDx_Pos = 0x10       // Position of MEMHOLDx field.
	FSMC_PMEM2_MEMHOLDx_Msk = 0xff0000   // Bit mask of MEMHOLDx field.
	FSMC_PMEM2_MEMWAITx_Pos = 0x8        // Position of MEMWAITx field.
	FSMC_PMEM2_MEMWAITx_Msk = 0xff00     // Bit mask of MEMWAITx field.
	FSMC_PMEM2_MEMSETx_Pos  = 0x0        // Position of MEMSETx field.
	FSMC_PMEM2_MEMSETx_Msk  = 0xff       // Bit mask of MEMSETx field.

	// PATT2: Attribute memory space timing register           2
	FSMC_PATT2_ATTHIZx_Pos  = 0x18       // Position of ATTHIZx field.
	FSMC_PATT2_ATTHIZx_Msk  = 0xff000000 // Bit mask of ATTHIZx field.
	FSMC_PATT2_ATTHOLDx_Pos = 0x10       // Position of ATTHOLDx field.
	FSMC_PATT2_ATTHOLDx_Msk = 0xff0000   // Bit mask of ATTHOLDx field.
	FSMC_PATT2_ATTWAITx_Pos = 0x8        // Position of ATTWAITx field.
	FSMC_PATT2_ATTWAITx_Msk = 0xff00     // Bit mask of ATTWAITx field.
	FSMC_PATT2_ATTSETx_Pos  = 0x0        // Position of ATTSETx field.
	FSMC_PATT2_ATTSETx_Msk  = 0xff       // Bit mask of ATTSETx field.

	// ECCR2: ECC result register 2
	FSMC_ECCR2_ECCx_Pos = 0x0        // Position of ECCx field.
	FSMC_ECCR2_ECCx_Msk = 0xffffffff // Bit mask of ECCx field.

	// PCR3: PC Card/NAND Flash control register           3
	FSMC_PCR3_ECCPS_Pos   = 0x11    // Position of ECCPS field.
	FSMC_PCR3_ECCPS_Msk   = 0xe0000 // Bit mask of ECCPS field.
	FSMC_PCR3_TAR_Pos     = 0xd     // Position of TAR field.
	FSMC_PCR3_TAR_Msk     = 0x1e000 // Bit mask of TAR field.
	FSMC_PCR3_TCLR_Pos    = 0x9     // Position of TCLR field.
	FSMC_PCR3_TCLR_Msk    = 0x1e00  // Bit mask of TCLR field.
	FSMC_PCR3_ECCEN_Pos   = 0x6     // Position of ECCEN field.
	FSMC_PCR3_ECCEN_Msk   = 0x40    // Bit mask of ECCEN field.
	FSMC_PCR3_ECCEN       = 0x40    // Bit ECCEN.
	FSMC_PCR3_PWID_Pos    = 0x4     // Position of PWID field.
	FSMC_PCR3_PWID_Msk    = 0x30    // Bit mask of PWID field.
	FSMC_PCR3_PTYP_Pos    = 0x3     // Position of PTYP field.
	FSMC_PCR3_PTYP_Msk    = 0x8     // Bit mask of PTYP field.
	FSMC_PCR3_PTYP        = 0x8     // Bit PTYP.
	FSMC_PCR3_PBKEN_Pos   = 0x2     // Position of PBKEN field.
	FSMC_PCR3_PBKEN_Msk   = 0x4     // Bit mask of PBKEN field.
	FSMC_PCR3_PBKEN       = 0x4     // Bit PBKEN.
	FSMC_PCR3_PWAITEN_Pos = 0x1     // Position of PWAITEN field.
	FSMC_PCR3_PWAITEN_Msk = 0x2     // Bit mask of PWAITEN field.
	FSMC_PCR3_PWAITEN     = 0x2     // Bit PWAITEN.

	// SR3: FIFO status and interrupt register           3
	FSMC_SR3_FEMPT_Pos = 0x6  // Position of FEMPT field.
	FSMC_SR3_FEMPT_Msk = 0x40 // Bit mask of FEMPT field.
	FSMC_SR3_FEMPT     = 0x40 // Bit FEMPT.
	FSMC_SR3_IFEN_Pos  = 0x5  // Position of IFEN field.
	FSMC_SR3_IFEN_Msk  = 0x20 // Bit mask of IFEN field.
	FSMC_SR3_IFEN      = 0x20 // Bit IFEN.
	FSMC_SR3_ILEN_Pos  = 0x4  // Position of ILEN field.
	FSMC_SR3_ILEN_Msk  = 0x10 // Bit mask of ILEN field.
	FSMC_SR3_ILEN      = 0x10 // Bit ILEN.
	FSMC_SR3_IREN_Pos  = 0x3  // Position of IREN field.
	FSMC_SR3_IREN_Msk  = 0x8  // Bit mask of IREN field.
	FSMC_SR3_IREN      = 0x8  // Bit IREN.
	FSMC_SR3_IFS_Pos   = 0x2  // Position of IFS field.
	FSMC_SR3_IFS_Msk   = 0x4  // Bit mask of IFS field.
	FSMC_SR3_IFS       = 0x4  // Bit IFS.
	FSMC_SR3_ILS_Pos   = 0x1  // Position of ILS field.
	FSMC_SR3_ILS_Msk   = 0x2  // Bit mask of ILS field.
	FSMC_SR3_ILS       = 0x2  // Bit ILS.
	FSMC_SR3_IRS_Pos   = 0x0  // Position of IRS field.
	FSMC_SR3_IRS_Msk   = 0x1  // Bit mask of IRS field.
	FSMC_SR3_IRS       = 0x1  // Bit IRS.

	// PMEM3: Common memory space timing register           3
	FSMC_PMEM3_MEMHIZx_Pos  = 0x18       // Position of MEMHIZx field.
	FSMC_PMEM3_MEMHIZx_Msk  = 0xff000000 // Bit mask of MEMHIZx field.
	FSMC_PMEM3_MEMHOLDx_Pos = 0x10       // Position of MEMHOLDx field.
	FSMC_PMEM3_MEMHOLDx_Msk = 0xff0000   // Bit mask of MEMHOLDx field.
	FSMC_PMEM3_MEMWAITx_Pos = 0x8        // Position of MEMWAITx field.
	FSMC_PMEM3_MEMWAITx_Msk = 0xff00     // Bit mask of MEMWAITx field.
	FSMC_PMEM3_MEMSETx_Pos  = 0x0        // Position of MEMSETx field.
	FSMC_PMEM3_MEMSETx_Msk  = 0xff       // Bit mask of MEMSETx field.

	// PATT3: Attribute memory space timing register           3
	FSMC_PATT3_ATTHIZx_Pos  = 0x18       // Position of ATTHIZx field.
	FSMC_PATT3_ATTHIZx_Msk  = 0xff000000 // Bit mask of ATTHIZx field.
	FSMC_PATT3_ATTHOLDx_Pos = 0x10       // Position of ATTHOLDx field.
	FSMC_PATT3_ATTHOLDx_Msk = 0xff0000   // Bit mask of ATTHOLDx field.
	FSMC_PATT3_ATTWAITx_Pos = 0x8        // Position of ATTWAITx field.
	FSMC_PATT3_ATTWAITx_Msk = 0xff00     // Bit mask of ATTWAITx field.
	FSMC_PATT3_ATTSETx_Pos  = 0x0        // Position of ATTSETx field.
	FSMC_PATT3_ATTSETx_Msk  = 0xff       // Bit mask of ATTSETx field.

	// ECCR3: ECC result register 3
	FSMC_ECCR3_ECCx_Pos = 0x0        // Position of ECCx field.
	FSMC_ECCR3_ECCx_Msk = 0xffffffff // Bit mask of ECCx field.

	// PCR4: PC Card/NAND Flash control register           4
	FSMC_PCR4_ECCPS_Pos   = 0x11    // Position of ECCPS field.
	FSMC_PCR4_ECCPS_Msk   = 0xe0000 // Bit mask of ECCPS field.
	FSMC_PCR4_TAR_Pos     = 0xd     // Position of TAR field.
	FSMC_PCR4_TAR_Msk     = 0x1e000 // Bit mask of TAR field.
	FSMC_PCR4_TCLR_Pos    = 0x9     // Position of TCLR field.
	FSMC_PCR4_TCLR_Msk    = 0x1e00  // Bit mask of TCLR field.
	FSMC_PCR4_ECCEN_Pos   = 0x6     // Position of ECCEN field.
	FSMC_PCR4_ECCEN_Msk   = 0x40    // Bit mask of ECCEN field.
	FSMC_PCR4_ECCEN       = 0x40    // Bit ECCEN.
	FSMC_PCR4_PWID_Pos    = 0x4     // Position of PWID field.
	FSMC_PCR4_PWID_Msk    = 0x30    // Bit mask of PWID field.
	FSMC_PCR4_PTYP_Pos    = 0x3     // Position of PTYP field.
	FSMC_PCR4_PTYP_Msk    = 0x8     // Bit mask of PTYP field.
	FSMC_PCR4_PTYP        = 0x8     // Bit PTYP.
	FSMC_PCR4_PBKEN_Pos   = 0x2     // Position of PBKEN field.
	FSMC_PCR4_PBKEN_Msk   = 0x4     // Bit mask of PBKEN field.
	FSMC_PCR4_PBKEN       = 0x4     // Bit PBKEN.
	FSMC_PCR4_PWAITEN_Pos = 0x1     // Position of PWAITEN field.
	FSMC_PCR4_PWAITEN_Msk = 0x2     // Bit mask of PWAITEN field.
	FSMC_PCR4_PWAITEN     = 0x2     // Bit PWAITEN.

	// SR4: FIFO status and interrupt register           4
	FSMC_SR4_FEMPT_Pos = 0x6  // Position of FEMPT field.
	FSMC_SR4_FEMPT_Msk = 0x40 // Bit mask of FEMPT field.
	FSMC_SR4_FEMPT     = 0x40 // Bit FEMPT.
	FSMC_SR4_IFEN_Pos  = 0x5  // Position of IFEN field.
	FSMC_SR4_IFEN_Msk  = 0x20 // Bit mask of IFEN field.
	FSMC_SR4_IFEN      = 0x20 // Bit IFEN.
	FSMC_SR4_ILEN_Pos  = 0x4  // Position of ILEN field.
	FSMC_SR4_ILEN_Msk  = 0x10 // Bit mask of ILEN field.
	FSMC_SR4_ILEN      = 0x10 // Bit ILEN.
	FSMC_SR4_IREN_Pos  = 0x3  // Position of IREN field.
	FSMC_SR4_IREN_Msk  = 0x8  // Bit mask of IREN field.
	FSMC_SR4_IREN      = 0x8  // Bit IREN.
	FSMC_SR4_IFS_Pos   = 0x2  // Position of IFS field.
	FSMC_SR4_IFS_Msk   = 0x4  // Bit mask of IFS field.
	FSMC_SR4_IFS       = 0x4  // Bit IFS.
	FSMC_SR4_ILS_Pos   = 0x1  // Position of ILS field.
	FSMC_SR4_ILS_Msk   = 0x2  // Bit mask of ILS field.
	FSMC_SR4_ILS       = 0x2  // Bit ILS.
	FSMC_SR4_IRS_Pos   = 0x0  // Position of IRS field.
	FSMC_SR4_IRS_Msk   = 0x1  // Bit mask of IRS field.
	FSMC_SR4_IRS       = 0x1  // Bit IRS.

	// PMEM4: Common memory space timing register           4
	FSMC_PMEM4_MEMHIZx_Pos  = 0x18       // Position of MEMHIZx field.
	FSMC_PMEM4_MEMHIZx_Msk  = 0xff000000 // Bit mask of MEMHIZx field.
	FSMC_PMEM4_MEMHOLDx_Pos = 0x10       // Position of MEMHOLDx field.
	FSMC_PMEM4_MEMHOLDx_Msk = 0xff0000   // Bit mask of MEMHOLDx field.
	FSMC_PMEM4_MEMWAITx_Pos = 0x8        // Position of MEMWAITx field.
	FSMC_PMEM4_MEMWAITx_Msk = 0xff00     // Bit mask of MEMWAITx field.
	FSMC_PMEM4_MEMSETx_Pos  = 0x0        // Position of MEMSETx field.
	FSMC_PMEM4_MEMSETx_Msk  = 0xff       // Bit mask of MEMSETx field.

	// PATT4: Attribute memory space timing register           4
	FSMC_PATT4_ATTHIZx_Pos  = 0x18       // Position of ATTHIZx field.
	FSMC_PATT4_ATTHIZx_Msk  = 0xff000000 // Bit mask of ATTHIZx field.
	FSMC_PATT4_ATTHOLDx_Pos = 0x10       // Position of ATTHOLDx field.
	FSMC_PATT4_ATTHOLDx_Msk = 0xff0000   // Bit mask of ATTHOLDx field.
	FSMC_PATT4_ATTWAITx_Pos = 0x8        // Position of ATTWAITx field.
	FSMC_PATT4_ATTWAITx_Msk = 0xff00     // Bit mask of ATTWAITx field.
	FSMC_PATT4_ATTSETx_Pos  = 0x0        // Position of ATTSETx field.
	FSMC_PATT4_ATTSETx_Msk  = 0xff       // Bit mask of ATTSETx field.

	// PIO4: I/O space timing register 4
	FSMC_PIO4_IOHIZx_Pos  = 0x18       // Position of IOHIZx field.
	FSMC_PIO4_IOHIZx_Msk  = 0xff000000 // Bit mask of IOHIZx field.
	FSMC_PIO4_IOHOLDx_Pos = 0x10       // Position of IOHOLDx field.
	FSMC_PIO4_IOHOLDx_Msk = 0xff0000   // Bit mask of IOHOLDx field.
	FSMC_PIO4_IOWAITx_Pos = 0x8        // Position of IOWAITx field.
	FSMC_PIO4_IOWAITx_Msk = 0xff00     // Bit mask of IOWAITx field.
	FSMC_PIO4_IOSETx_Pos  = 0x0        // Position of IOSETx field.
	FSMC_PIO4_IOSETx_Msk  = 0xff       // Bit mask of IOSETx field.

	// BWTR1: SRAM/NOR-Flash write timing registers           1
	FSMC_BWTR1_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR1_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR1_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR1_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR1_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR1_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR1_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR1_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR1_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR1_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR1_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR1_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// BWTR2: SRAM/NOR-Flash write timing registers           2
	FSMC_BWTR2_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR2_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR2_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR2_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR2_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR2_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR2_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR2_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR2_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR2_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR2_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR2_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// BWTR3: SRAM/NOR-Flash write timing registers           3
	FSMC_BWTR3_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR3_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR3_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR3_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR3_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR3_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR3_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR3_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR3_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR3_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR3_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR3_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// BWTR4: SRAM/NOR-Flash write timing registers           4
	FSMC_BWTR4_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR4_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR4_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR4_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR4_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR4_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR4_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR4_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR4_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR4_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR4_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR4_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// SDCR1: SDRAM Control Register 1
	FSMC_SDCR1_NC_Pos     = 0x0    // Position of NC field.
	FSMC_SDCR1_NC_Msk     = 0x3    // Bit mask of NC field.
	FSMC_SDCR1_NR_Pos     = 0x2    // Position of NR field.
	FSMC_SDCR1_NR_Msk     = 0xc    // Bit mask of NR field.
	FSMC_SDCR1_MWID_Pos   = 0x4    // Position of MWID field.
	FSMC_SDCR1_MWID_Msk   = 0x30   // Bit mask of MWID field.
	FSMC_SDCR1_NB_Pos     = 0x6    // Position of NB field.
	FSMC_SDCR1_NB_Msk     = 0x40   // Bit mask of NB field.
	FSMC_SDCR1_NB         = 0x40   // Bit NB.
	FSMC_SDCR1_CAS_Pos    = 0x7    // Position of CAS field.
	FSMC_SDCR1_CAS_Msk    = 0x180  // Bit mask of CAS field.
	FSMC_SDCR1_WP_Pos     = 0x9    // Position of WP field.
	FSMC_SDCR1_WP_Msk     = 0x200  // Bit mask of WP field.
	FSMC_SDCR1_WP         = 0x200  // Bit WP.
	FSMC_SDCR1_SDCLK_Pos  = 0xa    // Position of SDCLK field.
	FSMC_SDCR1_SDCLK_Msk  = 0xc00  // Bit mask of SDCLK field.
	FSMC_SDCR1_RBURST_Pos = 0xc    // Position of RBURST field.
	FSMC_SDCR1_RBURST_Msk = 0x1000 // Bit mask of RBURST field.
	FSMC_SDCR1_RBURST     = 0x1000 // Bit RBURST.
	FSMC_SDCR1_RPIPE_Pos  = 0xd    // Position of RPIPE field.
	FSMC_SDCR1_RPIPE_Msk  = 0x6000 // Bit mask of RPIPE field.

	// SDCR2: SDRAM Control Register 2
	FSMC_SDCR2_NC_Pos     = 0x0    // Position of NC field.
	FSMC_SDCR2_NC_Msk     = 0x3    // Bit mask of NC field.
	FSMC_SDCR2_NR_Pos     = 0x2    // Position of NR field.
	FSMC_SDCR2_NR_Msk     = 0xc    // Bit mask of NR field.
	FSMC_SDCR2_MWID_Pos   = 0x4    // Position of MWID field.
	FSMC_SDCR2_MWID_Msk   = 0x30   // Bit mask of MWID field.
	FSMC_SDCR2_NB_Pos     = 0x6    // Position of NB field.
	FSMC_SDCR2_NB_Msk     = 0x40   // Bit mask of NB field.
	FSMC_SDCR2_NB         = 0x40   // Bit NB.
	FSMC_SDCR2_CAS_Pos    = 0x7    // Position of CAS field.
	FSMC_SDCR2_CAS_Msk    = 0x180  // Bit mask of CAS field.
	FSMC_SDCR2_WP_Pos     = 0x9    // Position of WP field.
	FSMC_SDCR2_WP_Msk     = 0x200  // Bit mask of WP field.
	FSMC_SDCR2_WP         = 0x200  // Bit WP.
	FSMC_SDCR2_SDCLK_Pos  = 0xa    // Position of SDCLK field.
	FSMC_SDCR2_SDCLK_Msk  = 0xc00  // Bit mask of SDCLK field.
	FSMC_SDCR2_RBURST_Pos = 0xc    // Position of RBURST field.
	FSMC_SDCR2_RBURST_Msk = 0x1000 // Bit mask of RBURST field.
	FSMC_SDCR2_RBURST     = 0x1000 // Bit RBURST.
	FSMC_SDCR2_RPIPE_Pos  = 0xd    // Position of RPIPE field.
	FSMC_SDCR2_RPIPE_Msk  = 0x6000 // Bit mask of RPIPE field.

	// SDTR1: SDRAM Timing register 1
	FSMC_SDTR1_TMRD_Pos = 0x0       // Position of TMRD field.
	FSMC_SDTR1_TMRD_Msk = 0xf       // Bit mask of TMRD field.
	FSMC_SDTR1_TXSR_Pos = 0x4       // Position of TXSR field.
	FSMC_SDTR1_TXSR_Msk = 0xf0      // Bit mask of TXSR field.
	FSMC_SDTR1_TRAS_Pos = 0x8       // Position of TRAS field.
	FSMC_SDTR1_TRAS_Msk = 0xf00     // Bit mask of TRAS field.
	FSMC_SDTR1_TRC_Pos  = 0xc       // Position of TRC field.
	FSMC_SDTR1_TRC_Msk  = 0xf000    // Bit mask of TRC field.
	FSMC_SDTR1_TWR_Pos  = 0x10      // Position of TWR field.
	FSMC_SDTR1_TWR_Msk  = 0xf0000   // Bit mask of TWR field.
	FSMC_SDTR1_TRP_Pos  = 0x14      // Position of TRP field.
	FSMC_SDTR1_TRP_Msk  = 0xf00000  // Bit mask of TRP field.
	FSMC_SDTR1_TRCD_Pos = 0x18      // Position of TRCD field.
	FSMC_SDTR1_TRCD_Msk = 0xf000000 // Bit mask of TRCD field.

	// SDTR2: SDRAM Timing register 2
	FSMC_SDTR2_TMRD_Pos = 0x0       // Position of TMRD field.
	FSMC_SDTR2_TMRD_Msk = 0xf       // Bit mask of TMRD field.
	FSMC_SDTR2_TXSR_Pos = 0x4       // Position of TXSR field.
	FSMC_SDTR2_TXSR_Msk = 0xf0      // Bit mask of TXSR field.
	FSMC_SDTR2_TRAS_Pos = 0x8       // Position of TRAS field.
	FSMC_SDTR2_TRAS_Msk = 0xf00     // Bit mask of TRAS field.
	FSMC_SDTR2_TRC_Pos  = 0xc       // Position of TRC field.
	FSMC_SDTR2_TRC_Msk  = 0xf000    // Bit mask of TRC field.
	FSMC_SDTR2_TWR_Pos  = 0x10      // Position of TWR field.
	FSMC_SDTR2_TWR_Msk  = 0xf0000   // Bit mask of TWR field.
	FSMC_SDTR2_TRP_Pos  = 0x14      // Position of TRP field.
	FSMC_SDTR2_TRP_Msk  = 0xf00000  // Bit mask of TRP field.
	FSMC_SDTR2_TRCD_Pos = 0x18      // Position of TRCD field.
	FSMC_SDTR2_TRCD_Msk = 0xf000000 // Bit mask of TRCD field.

	// SDCMR: SDRAM Command Mode register
	FSMC_SDCMR_MODE_Pos = 0x0      // Position of MODE field.
	FSMC_SDCMR_MODE_Msk = 0x7      // Bit mask of MODE field.
	FSMC_SDCMR_CTB2_Pos = 0x3      // Position of CTB2 field.
	FSMC_SDCMR_CTB2_Msk = 0x8      // Bit mask of CTB2 field.
	FSMC_SDCMR_CTB2     = 0x8      // Bit CTB2.
	FSMC_SDCMR_CTB1_Pos = 0x4      // Position of CTB1 field.
	FSMC_SDCMR_CTB1_Msk = 0x10     // Bit mask of CTB1 field.
	FSMC_SDCMR_CTB1     = 0x10     // Bit CTB1.
	FSMC_SDCMR_NRFS_Pos = 0x5      // Position of NRFS field.
	FSMC_SDCMR_NRFS_Msk = 0x1e0    // Bit mask of NRFS field.
	FSMC_SDCMR_MRD_Pos  = 0x9      // Position of MRD field.
	FSMC_SDCMR_MRD_Msk  = 0x3ffe00 // Bit mask of MRD field.

	// SDRTR: SDRAM Refresh Timer register
	FSMC_SDRTR_CRE_Pos   = 0x0    // Position of CRE field.
	FSMC_SDRTR_CRE_Msk   = 0x1    // Bit mask of CRE field.
	FSMC_SDRTR_CRE       = 0x1    // Bit CRE.
	FSMC_SDRTR_COUNT_Pos = 0x1    // Position of COUNT field.
	FSMC_SDRTR_COUNT_Msk = 0x3ffe // Bit mask of COUNT field.
	FSMC_SDRTR_REIE_Pos  = 0xe    // Position of REIE field.
	FSMC_SDRTR_REIE_Msk  = 0x4000 // Bit mask of REIE field.
	FSMC_SDRTR_REIE      = 0x4000 // Bit REIE.

	// SDSR: SDRAM Status register
	FSMC_SDSR_RE_Pos     = 0x0  // Position of RE field.
	FSMC_SDSR_RE_Msk     = 0x1  // Bit mask of RE field.
	FSMC_SDSR_RE         = 0x1  // Bit RE.
	FSMC_SDSR_MODES1_Pos = 0x1  // Position of MODES1 field.
	FSMC_SDSR_MODES1_Msk = 0x6  // Bit mask of MODES1 field.
	FSMC_SDSR_MODES2_Pos = 0x3  // Position of MODES2 field.
	FSMC_SDSR_MODES2_Msk = 0x18 // Bit mask of MODES2 field.
	FSMC_SDSR_BUSY_Pos   = 0x5  // Position of BUSY field.
	FSMC_SDSR_BUSY_Msk   = 0x20 // Bit mask of BUSY field.
	FSMC_SDSR_BUSY       = 0x20 // Bit BUSY.
)

// Bitfields for DBG: Debug support
const (
	// DBGMCU_IDCODE: IDCODE
	DBG_DBGMCU_IDCODE_DEV_ID_Pos = 0x0        // Position of DEV_ID field.
	DBG_DBGMCU_IDCODE_DEV_ID_Msk = 0xfff      // Bit mask of DEV_ID field.
	DBG_DBGMCU_IDCODE_REV_ID_Pos = 0x10       // Position of REV_ID field.
	DBG_DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000 // Bit mask of REV_ID field.

	// DBGMCU_CR: Control Register
	DBG_DBGMCU_CR_DBG_SLEEP_Pos   = 0x0  // Position of DBG_SLEEP field.
	DBG_DBGMCU_CR_DBG_SLEEP_Msk   = 0x1  // Bit mask of DBG_SLEEP field.
	DBG_DBGMCU_CR_DBG_SLEEP       = 0x1  // Bit DBG_SLEEP.
	DBG_DBGMCU_CR_DBG_STOP_Pos    = 0x1  // Position of DBG_STOP field.
	DBG_DBGMCU_CR_DBG_STOP_Msk    = 0x2  // Bit mask of DBG_STOP field.
	DBG_DBGMCU_CR_DBG_STOP        = 0x2  // Bit DBG_STOP.
	DBG_DBGMCU_CR_DBG_STANDBY_Pos = 0x2  // Position of DBG_STANDBY field.
	DBG_DBGMCU_CR_DBG_STANDBY_Msk = 0x4  // Bit mask of DBG_STANDBY field.
	DBG_DBGMCU_CR_DBG_STANDBY     = 0x4  // Bit DBG_STANDBY.
	DBG_DBGMCU_CR_TRACE_IOEN_Pos  = 0x5  // Position of TRACE_IOEN field.
	DBG_DBGMCU_CR_TRACE_IOEN_Msk  = 0x20 // Bit mask of TRACE_IOEN field.
	DBG_DBGMCU_CR_TRACE_IOEN      = 0x20 // Bit TRACE_IOEN.
	DBG_DBGMCU_CR_TRACE_MODE_Pos  = 0x6  // Position of TRACE_MODE field.
	DBG_DBGMCU_CR_TRACE_MODE_Msk  = 0xc0 // Bit mask of TRACE_MODE field.

	// DBGMCU_APB1_FZ: Debug MCU APB1 Freeze registe
	DBG_DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos            = 0x0       // Position of DBG_TIM2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk            = 0x1       // Bit mask of DBG_TIM2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM2_STOP                = 0x1       // Bit DBG_TIM2_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos            = 0x1       // Position of DBG_TIM3_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk            = 0x2       // Bit mask of DBG_TIM3_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM3_STOP                = 0x2       // Bit DBG_TIM3_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM4_STOP_Pos            = 0x2       // Position of DBG_TIM4_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM4_STOP_Msk            = 0x4       // Bit mask of DBG_TIM4_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM4_STOP                = 0x4       // Bit DBG_TIM4_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM5_STOP_Pos            = 0x3       // Position of DBG_TIM5_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM5_STOP_Msk            = 0x8       // Bit mask of DBG_TIM5_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM5_STOP                = 0x8       // Bit DBG_TIM5_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos            = 0x4       // Position of DBG_TIM6_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk            = 0x10      // Bit mask of DBG_TIM6_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM6_STOP                = 0x10      // Bit DBG_TIM6_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos            = 0x5       // Position of DBG_TIM7_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk            = 0x20      // Bit mask of DBG_TIM7_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM7_STOP                = 0x20      // Bit DBG_TIM7_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM12_STOP_Pos           = 0x6       // Position of DBG_TIM12_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM12_STOP_Msk           = 0x40      // Bit mask of DBG_TIM12_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM12_STOP               = 0x40      // Bit DBG_TIM12_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM13_STOP_Pos           = 0x7       // Position of DBG_TIM13_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM13_STOP_Msk           = 0x80      // Bit mask of DBG_TIM13_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM13_STOP               = 0x80      // Bit DBG_TIM13_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM14_STOP_Pos           = 0x8       // Position of DBG_TIM14_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM14_STOP_Msk           = 0x100     // Bit mask of DBG_TIM14_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM14_STOP               = 0x100     // Bit DBG_TIM14_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_RTC_STOP_Pos             = 0xa       // Position of DBG_RTC_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_RTC_STOP_Msk             = 0x400     // Bit mask of DBG_RTC_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_RTC_STOP                 = 0x400     // Bit DBG_RTC_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_WWDG_STOP_Pos            = 0xb       // Position of DBG_WWDG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_WWDG_STOP_Msk            = 0x800     // Bit mask of DBG_WWDG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_WWDG_STOP                = 0x800     // Bit DBG_WWDG_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_IWDEG_STOP_Pos           = 0xc       // Position of DBG_IWDEG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_IWDEG_STOP_Msk           = 0x1000    // Bit mask of DBG_IWDEG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_IWDEG_STOP               = 0x1000    // Bit DBG_IWDEG_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT_Pos   = 0x15      // Position of DBG_J2C1_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT_Msk   = 0x200000  // Bit mask of DBG_J2C1_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT       = 0x200000  // Bit DBG_J2C1_SMBUS_TIMEOUT.
	DBG_DBGMCU_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT_Pos   = 0x16      // Position of DBG_J2C2_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT_Msk   = 0x400000  // Bit mask of DBG_J2C2_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT       = 0x400000  // Bit DBG_J2C2_SMBUS_TIMEOUT.
	DBG_DBGMCU_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT_Pos    = 0x17      // Position of DBG_J2C3SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT_Msk    = 0x800000  // Bit mask of DBG_J2C3SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT        = 0x800000  // Bit DBG_J2C3SMBUS_TIMEOUT.
	DBG_DBGMCU_APB1_FZ_DBG_I2CFMP_SMBUS_TIMEOUT_Pos = 0x18      // Position of DBG_I2CFMP_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_I2CFMP_SMBUS_TIMEOUT_Msk = 0x1000000 // Bit mask of DBG_I2CFMP_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_I2CFMP_SMBUS_TIMEOUT     = 0x1000000 // Bit DBG_I2CFMP_SMBUS_TIMEOUT.
	DBG_DBGMCU_APB1_FZ_DBG_CAN1_STOP_Pos            = 0x19      // Position of DBG_CAN1_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_CAN1_STOP_Msk            = 0x2000000 // Bit mask of DBG_CAN1_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_CAN1_STOP                = 0x2000000 // Bit DBG_CAN1_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_CAN2_STOP_Pos            = 0x1a      // Position of DBG_CAN2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_CAN2_STOP_Msk            = 0x4000000 // Bit mask of DBG_CAN2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_CAN2_STOP                = 0x4000000 // Bit DBG_CAN2_STOP.

	// DBGMCU_APB2_FZ: Debug MCU APB2 Freeze registe
	DBG_DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos  = 0x0     // Position of DBG_TIM1_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk  = 0x1     // Bit mask of DBG_TIM1_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM1_STOP      = 0x1     // Bit DBG_TIM1_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM8_STOP_Pos  = 0x1     // Position of DBG_TIM8_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM8_STOP_Msk  = 0x2     // Bit mask of DBG_TIM8_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM8_STOP      = 0x2     // Bit DBG_TIM8_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM9_STOP_Pos  = 0x10    // Position of DBG_TIM9_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM9_STOP_Msk  = 0x10000 // Bit mask of DBG_TIM9_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM9_STOP      = 0x10000 // Bit DBG_TIM9_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM10_STOP_Pos = 0x11    // Position of DBG_TIM10_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM10_STOP_Msk = 0x20000 // Bit mask of DBG_TIM10_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM10_STOP     = 0x20000 // Bit DBG_TIM10_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM11_STOP_Pos = 0x12    // Position of DBG_TIM11_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM11_STOP_Msk = 0x40000 // Bit mask of DBG_TIM11_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM11_STOP     = 0x40000 // Bit DBG_TIM11_STOP.
)

// Bitfields for DMA2: DMA controller
const (
	// LISR: low interrupt status register
	DMA_LISR_TCIF3_Pos  = 0x1b      // Position of TCIF3 field.
	DMA_LISR_TCIF3_Msk  = 0x8000000 // Bit mask of TCIF3 field.
	DMA_LISR_TCIF3      = 0x8000000 // Bit TCIF3.
	DMA_LISR_HTIF3_Pos  = 0x1a      // Position of HTIF3 field.
	DMA_LISR_HTIF3_Msk  = 0x4000000 // Bit mask of HTIF3 field.
	DMA_LISR_HTIF3      = 0x4000000 // Bit HTIF3.
	DMA_LISR_TEIF3_Pos  = 0x19      // Position of TEIF3 field.
	DMA_LISR_TEIF3_Msk  = 0x2000000 // Bit mask of TEIF3 field.
	DMA_LISR_TEIF3      = 0x2000000 // Bit TEIF3.
	DMA_LISR_DMEIF3_Pos = 0x18      // Position of DMEIF3 field.
	DMA_LISR_DMEIF3_Msk = 0x1000000 // Bit mask of DMEIF3 field.
	DMA_LISR_DMEIF3     = 0x1000000 // Bit DMEIF3.
	DMA_LISR_FEIF3_Pos  = 0x16      // Position of FEIF3 field.
	DMA_LISR_FEIF3_Msk  = 0x400000  // Bit mask of FEIF3 field.
	DMA_LISR_FEIF3      = 0x400000  // Bit FEIF3.
	DMA_LISR_TCIF2_Pos  = 0x15      // Position of TCIF2 field.
	DMA_LISR_TCIF2_Msk  = 0x200000  // Bit mask of TCIF2 field.
	DMA_LISR_TCIF2      = 0x200000  // Bit TCIF2.
	DMA_LISR_HTIF2_Pos  = 0x14      // Position of HTIF2 field.
	DMA_LISR_HTIF2_Msk  = 0x100000  // Bit mask of HTIF2 field.
	DMA_LISR_HTIF2      = 0x100000  // Bit HTIF2.
	DMA_LISR_TEIF2_Pos  = 0x13      // Position of TEIF2 field.
	DMA_LISR_TEIF2_Msk  = 0x80000   // Bit mask of TEIF2 field.
	DMA_LISR_TEIF2      = 0x80000   // Bit TEIF2.
	DMA_LISR_DMEIF2_Pos = 0x12      // Position of DMEIF2 field.
	DMA_LISR_DMEIF2_Msk = 0x40000   // Bit mask of DMEIF2 field.
	DMA_LISR_DMEIF2     = 0x40000   // Bit DMEIF2.
	DMA_LISR_FEIF2_Pos  = 0x10      // Position of FEIF2 field.
	DMA_LISR_FEIF2_Msk  = 0x10000   // Bit mask of FEIF2 field.
	DMA_LISR_FEIF2      = 0x10000   // Bit FEIF2.
	DMA_LISR_TCIF1_Pos  = 0xb       // Position of TCIF1 field.
	DMA_LISR_TCIF1_Msk  = 0x800     // Bit mask of TCIF1 field.
	DMA_LISR_TCIF1      = 0x800     // Bit TCIF1.
	DMA_LISR_HTIF1_Pos  = 0xa       // Position of HTIF1 field.
	DMA_LISR_HTIF1_Msk  = 0x400     // Bit mask of HTIF1 field.
	DMA_LISR_HTIF1      = 0x400     // Bit HTIF1.
	DMA_LISR_TEIF1_Pos  = 0x9       // Position of TEIF1 field.
	DMA_LISR_TEIF1_Msk  = 0x200     // Bit mask of TEIF1 field.
	DMA_LISR_TEIF1      = 0x200     // Bit TEIF1.
	DMA_LISR_DMEIF1_Pos = 0x8       // Position of DMEIF1 field.
	DMA_LISR_DMEIF1_Msk = 0x100     // Bit mask of DMEIF1 field.
	DMA_LISR_DMEIF1     = 0x100     // Bit DMEIF1.
	DMA_LISR_FEIF1_Pos  = 0x6       // Position of FEIF1 field.
	DMA_LISR_FEIF1_Msk  = 0x40      // Bit mask of FEIF1 field.
	DMA_LISR_FEIF1      = 0x40      // Bit FEIF1.
	DMA_LISR_TCIF0_Pos  = 0x5       // Position of TCIF0 field.
	DMA_LISR_TCIF0_Msk  = 0x20      // Bit mask of TCIF0 field.
	DMA_LISR_TCIF0      = 0x20      // Bit TCIF0.
	DMA_LISR_HTIF0_Pos  = 0x4       // Position of HTIF0 field.
	DMA_LISR_HTIF0_Msk  = 0x10      // Bit mask of HTIF0 field.
	DMA_LISR_HTIF0      = 0x10      // Bit HTIF0.
	DMA_LISR_TEIF0_Pos  = 0x3       // Position of TEIF0 field.
	DMA_LISR_TEIF0_Msk  = 0x8       // Bit mask of TEIF0 field.
	DMA_LISR_TEIF0      = 0x8       // Bit TEIF0.
	DMA_LISR_DMEIF0_Pos = 0x2       // Position of DMEIF0 field.
	DMA_LISR_DMEIF0_Msk = 0x4       // Bit mask of DMEIF0 field.
	DMA_LISR_DMEIF0     = 0x4       // Bit DMEIF0.
	DMA_LISR_FEIF0_Pos  = 0x0       // Position of FEIF0 field.
	DMA_LISR_FEIF0_Msk  = 0x1       // Bit mask of FEIF0 field.
	DMA_LISR_FEIF0      = 0x1       // Bit FEIF0.

	// HISR: high interrupt status register
	DMA_HISR_TCIF7_Pos  = 0x1b      // Position of TCIF7 field.
	DMA_HISR_TCIF7_Msk  = 0x8000000 // Bit mask of TCIF7 field.
	DMA_HISR_TCIF7      = 0x8000000 // Bit TCIF7.
	DMA_HISR_HTIF7_Pos  = 0x1a      // Position of HTIF7 field.
	DMA_HISR_HTIF7_Msk  = 0x4000000 // Bit mask of HTIF7 field.
	DMA_HISR_HTIF7      = 0x4000000 // Bit HTIF7.
	DMA_HISR_TEIF7_Pos  = 0x19      // Position of TEIF7 field.
	DMA_HISR_TEIF7_Msk  = 0x2000000 // Bit mask of TEIF7 field.
	DMA_HISR_TEIF7      = 0x2000000 // Bit TEIF7.
	DMA_HISR_DMEIF7_Pos = 0x18      // Position of DMEIF7 field.
	DMA_HISR_DMEIF7_Msk = 0x1000000 // Bit mask of DMEIF7 field.
	DMA_HISR_DMEIF7     = 0x1000000 // Bit DMEIF7.
	DMA_HISR_FEIF7_Pos  = 0x16      // Position of FEIF7 field.
	DMA_HISR_FEIF7_Msk  = 0x400000  // Bit mask of FEIF7 field.
	DMA_HISR_FEIF7      = 0x400000  // Bit FEIF7.
	DMA_HISR_TCIF6_Pos  = 0x15      // Position of TCIF6 field.
	DMA_HISR_TCIF6_Msk  = 0x200000  // Bit mask of TCIF6 field.
	DMA_HISR_TCIF6      = 0x200000  // Bit TCIF6.
	DMA_HISR_HTIF6_Pos  = 0x14      // Position of HTIF6 field.
	DMA_HISR_HTIF6_Msk  = 0x100000  // Bit mask of HTIF6 field.
	DMA_HISR_HTIF6      = 0x100000  // Bit HTIF6.
	DMA_HISR_TEIF6_Pos  = 0x13      // Position of TEIF6 field.
	DMA_HISR_TEIF6_Msk  = 0x80000   // Bit mask of TEIF6 field.
	DMA_HISR_TEIF6      = 0x80000   // Bit TEIF6.
	DMA_HISR_DMEIF6_Pos = 0x12      // Position of DMEIF6 field.
	DMA_HISR_DMEIF6_Msk = 0x40000   // Bit mask of DMEIF6 field.
	DMA_HISR_DMEIF6     = 0x40000   // Bit DMEIF6.
	DMA_HISR_FEIF6_Pos  = 0x10      // Position of FEIF6 field.
	DMA_HISR_FEIF6_Msk  = 0x10000   // Bit mask of FEIF6 field.
	DMA_HISR_FEIF6      = 0x10000   // Bit FEIF6.
	DMA_HISR_TCIF5_Pos  = 0xb       // Position of TCIF5 field.
	DMA_HISR_TCIF5_Msk  = 0x800     // Bit mask of TCIF5 field.
	DMA_HISR_TCIF5      = 0x800     // Bit TCIF5.
	DMA_HISR_HTIF5_Pos  = 0xa       // Position of HTIF5 field.
	DMA_HISR_HTIF5_Msk  = 0x400     // Bit mask of HTIF5 field.
	DMA_HISR_HTIF5      = 0x400     // Bit HTIF5.
	DMA_HISR_TEIF5_Pos  = 0x9       // Position of TEIF5 field.
	DMA_HISR_TEIF5_Msk  = 0x200     // Bit mask of TEIF5 field.
	DMA_HISR_TEIF5      = 0x200     // Bit TEIF5.
	DMA_HISR_DMEIF5_Pos = 0x8       // Position of DMEIF5 field.
	DMA_HISR_DMEIF5_Msk = 0x100     // Bit mask of DMEIF5 field.
	DMA_HISR_DMEIF5     = 0x100     // Bit DMEIF5.
	DMA_HISR_FEIF5_Pos  = 0x6       // Position of FEIF5 field.
	DMA_HISR_FEIF5_Msk  = 0x40      // Bit mask of FEIF5 field.
	DMA_HISR_FEIF5      = 0x40      // Bit FEIF5.
	DMA_HISR_TCIF4_Pos  = 0x5       // Position of TCIF4 field.
	DMA_HISR_TCIF4_Msk  = 0x20      // Bit mask of TCIF4 field.
	DMA_HISR_TCIF4      = 0x20      // Bit TCIF4.
	DMA_HISR_HTIF4_Pos  = 0x4       // Position of HTIF4 field.
	DMA_HISR_HTIF4_Msk  = 0x10      // Bit mask of HTIF4 field.
	DMA_HISR_HTIF4      = 0x10      // Bit HTIF4.
	DMA_HISR_TEIF4_Pos  = 0x3       // Position of TEIF4 field.
	DMA_HISR_TEIF4_Msk  = 0x8       // Bit mask of TEIF4 field.
	DMA_HISR_TEIF4      = 0x8       // Bit TEIF4.
	DMA_HISR_DMEIF4_Pos = 0x2       // Position of DMEIF4 field.
	DMA_HISR_DMEIF4_Msk = 0x4       // Bit mask of DMEIF4 field.
	DMA_HISR_DMEIF4     = 0x4       // Bit DMEIF4.
	DMA_HISR_FEIF4_Pos  = 0x0       // Position of FEIF4 field.
	DMA_HISR_FEIF4_Msk  = 0x1       // Bit mask of FEIF4 field.
	DMA_HISR_FEIF4      = 0x1       // Bit FEIF4.

	// LIFCR: low interrupt flag clear           register
	DMA_LIFCR_CTCIF3_Pos  = 0x1b      // Position of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Msk  = 0x8000000 // Bit mask of CTCIF3 field.
	DMA_LIFCR_CTCIF3      = 0x8000000 // Bit CTCIF3.
	DMA_LIFCR_CHTIF3_Pos  = 0x1a      // Position of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Msk  = 0x4000000 // Bit mask of CHTIF3 field.
	DMA_LIFCR_CHTIF3      = 0x4000000 // Bit CHTIF3.
	DMA_LIFCR_CTEIF3_Pos  = 0x19      // Position of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Msk  = 0x2000000 // Bit mask of CTEIF3 field.
	DMA_LIFCR_CTEIF3      = 0x2000000 // Bit CTEIF3.
	DMA_LIFCR_CDMEIF3_Pos = 0x18      // Position of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Msk = 0x1000000 // Bit mask of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3     = 0x1000000 // Bit CDMEIF3.
	DMA_LIFCR_CFEIF3_Pos  = 0x16      // Position of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Msk  = 0x400000  // Bit mask of CFEIF3 field.
	DMA_LIFCR_CFEIF3      = 0x400000  // Bit CFEIF3.
	DMA_LIFCR_CTCIF2_Pos  = 0x15      // Position of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Msk  = 0x200000  // Bit mask of CTCIF2 field.
	DMA_LIFCR_CTCIF2      = 0x200000  // Bit CTCIF2.
	DMA_LIFCR_CHTIF2_Pos  = 0x14      // Position of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Msk  = 0x100000  // Bit mask of CHTIF2 field.
	DMA_LIFCR_CHTIF2      = 0x100000  // Bit CHTIF2.
	DMA_LIFCR_CTEIF2_Pos  = 0x13      // Position of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Msk  = 0x80000   // Bit mask of CTEIF2 field.
	DMA_LIFCR_CTEIF2      = 0x80000   // Bit CTEIF2.
	DMA_LIFCR_CDMEIF2_Pos = 0x12      // Position of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Msk = 0x40000   // Bit mask of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2     = 0x40000   // Bit CDMEIF2.
	DMA_LIFCR_CFEIF2_Pos  = 0x10      // Position of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Msk  = 0x10000   // Bit mask of CFEIF2 field.
	DMA_LIFCR_CFEIF2      = 0x10000   // Bit CFEIF2.
	DMA_LIFCR_CTCIF1_Pos  = 0xb       // Position of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Msk  = 0x800     // Bit mask of CTCIF1 field.
	DMA_LIFCR_CTCIF1      = 0x800     // Bit CTCIF1.
	DMA_LIFCR_CHTIF1_Pos  = 0xa       // Position of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Msk  = 0x400     // Bit mask of CHTIF1 field.
	DMA_LIFCR_CHTIF1      = 0x400     // Bit CHTIF1.
	DMA_LIFCR_CTEIF1_Pos  = 0x9       // Position of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Msk  = 0x200     // Bit mask of CTEIF1 field.
	DMA_LIFCR_CTEIF1      = 0x200     // Bit CTEIF1.
	DMA_LIFCR_CDMEIF1_Pos = 0x8       // Position of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Msk = 0x100     // Bit mask of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1     = 0x100     // Bit CDMEIF1.
	DMA_LIFCR_CFEIF1_Pos  = 0x6       // Position of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Msk  = 0x40      // Bit mask of CFEIF1 field.
	DMA_LIFCR_CFEIF1      = 0x40      // Bit CFEIF1.
	DMA_LIFCR_CTCIF0_Pos  = 0x5       // Position of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Msk  = 0x20      // Bit mask of CTCIF0 field.
	DMA_LIFCR_CTCIF0      = 0x20      // Bit CTCIF0.
	DMA_LIFCR_CHTIF0_Pos  = 0x4       // Position of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Msk  = 0x10      // Bit mask of CHTIF0 field.
	DMA_LIFCR_CHTIF0      = 0x10      // Bit CHTIF0.
	DMA_LIFCR_CTEIF0_Pos  = 0x3       // Position of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Msk  = 0x8       // Bit mask of CTEIF0 field.
	DMA_LIFCR_CTEIF0      = 0x8       // Bit CTEIF0.
	DMA_LIFCR_CDMEIF0_Pos = 0x2       // Position of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Msk = 0x4       // Bit mask of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0     = 0x4       // Bit CDMEIF0.
	DMA_LIFCR_CFEIF0_Pos  = 0x0       // Position of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Msk  = 0x1       // Bit mask of CFEIF0 field.
	DMA_LIFCR_CFEIF0      = 0x1       // Bit CFEIF0.

	// HIFCR: high interrupt flag clear           register
	DMA_HIFCR_CTCIF7_Pos  = 0x1b      // Position of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Msk  = 0x8000000 // Bit mask of CTCIF7 field.
	DMA_HIFCR_CTCIF7      = 0x8000000 // Bit CTCIF7.
	DMA_HIFCR_CHTIF7_Pos  = 0x1a      // Position of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Msk  = 0x4000000 // Bit mask of CHTIF7 field.
	DMA_HIFCR_CHTIF7      = 0x4000000 // Bit CHTIF7.
	DMA_HIFCR_CTEIF7_Pos  = 0x19      // Position of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Msk  = 0x2000000 // Bit mask of CTEIF7 field.
	DMA_HIFCR_CTEIF7      = 0x2000000 // Bit CTEIF7.
	DMA_HIFCR_CDMEIF7_Pos = 0x18      // Position of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Msk = 0x1000000 // Bit mask of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7     = 0x1000000 // Bit CDMEIF7.
	DMA_HIFCR_CFEIF7_Pos  = 0x16      // Position of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Msk  = 0x400000  // Bit mask of CFEIF7 field.
	DMA_HIFCR_CFEIF7      = 0x400000  // Bit CFEIF7.
	DMA_HIFCR_CTCIF6_Pos  = 0x15      // Position of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Msk  = 0x200000  // Bit mask of CTCIF6 field.
	DMA_HIFCR_CTCIF6      = 0x200000  // Bit CTCIF6.
	DMA_HIFCR_CHTIF6_Pos  = 0x14      // Position of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Msk  = 0x100000  // Bit mask of CHTIF6 field.
	DMA_HIFCR_CHTIF6      = 0x100000  // Bit CHTIF6.
	DMA_HIFCR_CTEIF6_Pos  = 0x13      // Position of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Msk  = 0x80000   // Bit mask of CTEIF6 field.
	DMA_HIFCR_CTEIF6      = 0x80000   // Bit CTEIF6.
	DMA_HIFCR_CDMEIF6_Pos = 0x12      // Position of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Msk = 0x40000   // Bit mask of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6     = 0x40000   // Bit CDMEIF6.
	DMA_HIFCR_CFEIF6_Pos  = 0x10      // Position of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Msk  = 0x10000   // Bit mask of CFEIF6 field.
	DMA_HIFCR_CFEIF6      = 0x10000   // Bit CFEIF6.
	DMA_HIFCR_CTCIF5_Pos  = 0xb       // Position of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Msk  = 0x800     // Bit mask of CTCIF5 field.
	DMA_HIFCR_CTCIF5      = 0x800     // Bit CTCIF5.
	DMA_HIFCR_CHTIF5_Pos  = 0xa       // Position of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Msk  = 0x400     // Bit mask of CHTIF5 field.
	DMA_HIFCR_CHTIF5      = 0x400     // Bit CHTIF5.
	DMA_HIFCR_CTEIF5_Pos  = 0x9       // Position of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Msk  = 0x200     // Bit mask of CTEIF5 field.
	DMA_HIFCR_CTEIF5      = 0x200     // Bit CTEIF5.
	DMA_HIFCR_CDMEIF5_Pos = 0x8       // Position of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Msk = 0x100     // Bit mask of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5     = 0x100     // Bit CDMEIF5.
	DMA_HIFCR_CFEIF5_Pos  = 0x6       // Position of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Msk  = 0x40      // Bit mask of CFEIF5 field.
	DMA_HIFCR_CFEIF5      = 0x40      // Bit CFEIF5.
	DMA_HIFCR_CTCIF4_Pos  = 0x5       // Position of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Msk  = 0x20      // Bit mask of CTCIF4 field.
	DMA_HIFCR_CTCIF4      = 0x20      // Bit CTCIF4.
	DMA_HIFCR_CHTIF4_Pos  = 0x4       // Position of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Msk  = 0x10      // Bit mask of CHTIF4 field.
	DMA_HIFCR_CHTIF4      = 0x10      // Bit CHTIF4.
	DMA_HIFCR_CTEIF4_Pos  = 0x3       // Position of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Msk  = 0x8       // Bit mask of CTEIF4 field.
	DMA_HIFCR_CTEIF4      = 0x8       // Bit CTEIF4.
	DMA_HIFCR_CDMEIF4_Pos = 0x2       // Position of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Msk = 0x4       // Bit mask of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4     = 0x4       // Bit CDMEIF4.
	DMA_HIFCR_CFEIF4_Pos  = 0x0       // Position of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Msk  = 0x1       // Bit mask of CFEIF4 field.
	DMA_HIFCR_CFEIF4      = 0x1       // Bit CFEIF4.

	// S0CR: stream x configuration           register
	DMA_S0CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S0CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S0CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S0CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S0CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S0CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S0CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S0CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S0CR_CT         = 0x80000   // Bit CT.
	DMA_S0CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S0CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S0CR_DBM        = 0x40000   // Bit DBM.
	DMA_S0CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S0CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S0CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S0CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S0CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S0CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S0CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S0CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S0CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S0CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S0CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S0CR_MINC       = 0x400     // Bit MINC.
	DMA_S0CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S0CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S0CR_PINC       = 0x200     // Bit PINC.
	DMA_S0CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S0CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S0CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S0CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S0CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S0CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S0CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S0CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S0CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S0CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S0CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S0CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S0CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S0CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S0CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S0CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S0CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S0CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S0CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S0CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S0CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S0CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S0CR_EN         = 0x1       // Bit EN.

	// S0NDTR: stream x number of data           register
	DMA_S0NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S0NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S0PAR: stream x peripheral address           register
	DMA_S0PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S0PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S0M0AR: stream x memory 0 address           register
	DMA_S0M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S0M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S0M1AR: stream x memory 1 address           register
	DMA_S0M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S0M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S0FCR: stream x FIFO control register
	DMA_S0FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S0FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S0FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S0FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S0FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S0FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S0FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S0FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S0FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S0FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S1CR: stream x configuration           register
	DMA_S1CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S1CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S1CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S1CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S1CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S1CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S1CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S1CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S1CR_ACK        = 0x100000  // Bit ACK.
	DMA_S1CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S1CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S1CR_CT         = 0x80000   // Bit CT.
	DMA_S1CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S1CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S1CR_DBM        = 0x40000   // Bit DBM.
	DMA_S1CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S1CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S1CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S1CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S1CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S1CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S1CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S1CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S1CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S1CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S1CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S1CR_MINC       = 0x400     // Bit MINC.
	DMA_S1CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S1CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S1CR_PINC       = 0x200     // Bit PINC.
	DMA_S1CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S1CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S1CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S1CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S1CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S1CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S1CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S1CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S1CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S1CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S1CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S1CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S1CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S1CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S1CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S1CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S1CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S1CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S1CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S1CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S1CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S1CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S1CR_EN         = 0x1       // Bit EN.

	// S1NDTR: stream x number of data           register
	DMA_S1NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S1NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S1PAR: stream x peripheral address           register
	DMA_S1PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S1PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S1M0AR: stream x memory 0 address           register
	DMA_S1M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S1M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S1M1AR: stream x memory 1 address           register
	DMA_S1M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S1M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S1FCR: stream x FIFO control register
	DMA_S1FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S1FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S1FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S1FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S1FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S1FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S1FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S1FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S1FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S1FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S2CR: stream x configuration           register
	DMA_S2CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S2CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S2CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S2CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S2CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S2CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S2CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S2CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S2CR_ACK        = 0x100000  // Bit ACK.
	DMA_S2CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S2CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S2CR_CT         = 0x80000   // Bit CT.
	DMA_S2CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S2CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S2CR_DBM        = 0x40000   // Bit DBM.
	DMA_S2CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S2CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S2CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S2CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S2CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S2CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S2CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S2CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S2CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S2CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S2CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S2CR_MINC       = 0x400     // Bit MINC.
	DMA_S2CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S2CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S2CR_PINC       = 0x200     // Bit PINC.
	DMA_S2CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S2CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S2CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S2CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S2CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S2CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S2CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S2CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S2CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S2CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S2CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S2CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S2CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S2CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S2CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S2CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S2CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S2CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S2CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S2CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S2CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S2CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S2CR_EN         = 0x1       // Bit EN.

	// S2NDTR: stream x number of data           register
	DMA_S2NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S2NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S2PAR: stream x peripheral address           register
	DMA_S2PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S2PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S2M0AR: stream x memory 0 address           register
	DMA_S2M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S2M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S2M1AR: stream x memory 1 address           register
	DMA_S2M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S2M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S2FCR: stream x FIFO control register
	DMA_S2FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S2FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S2FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S2FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S2FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S2FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S2FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S2FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S2FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S2FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S3CR: stream x configuration           register
	DMA_S3CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S3CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S3CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S3CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S3CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S3CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S3CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S3CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S3CR_ACK        = 0x100000  // Bit ACK.
	DMA_S3CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S3CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S3CR_CT         = 0x80000   // Bit CT.
	DMA_S3CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S3CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S3CR_DBM        = 0x40000   // Bit DBM.
	DMA_S3CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S3CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S3CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S3CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S3CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S3CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S3CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S3CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S3CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S3CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S3CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S3CR_MINC       = 0x400     // Bit MINC.
	DMA_S3CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S3CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S3CR_PINC       = 0x200     // Bit PINC.
	DMA_S3CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S3CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S3CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S3CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S3CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S3CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S3CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S3CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S3CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S3CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S3CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S3CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S3CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S3CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S3CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S3CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S3CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S3CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S3CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S3CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S3CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S3CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S3CR_EN         = 0x1       // Bit EN.

	// S3NDTR: stream x number of data           register
	DMA_S3NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S3NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S3PAR: stream x peripheral address           register
	DMA_S3PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S3PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S3M0AR: stream x memory 0 address           register
	DMA_S3M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S3M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S3M1AR: stream x memory 1 address           register
	DMA_S3M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S3M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S3FCR: stream x FIFO control register
	DMA_S3FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S3FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S3FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S3FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S3FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S3FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S3FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S3FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S3FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S3FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S4CR: stream x configuration           register
	DMA_S4CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S4CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S4CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S4CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S4CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S4CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S4CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S4CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S4CR_ACK        = 0x100000  // Bit ACK.
	DMA_S4CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S4CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S4CR_CT         = 0x80000   // Bit CT.
	DMA_S4CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S4CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S4CR_DBM        = 0x40000   // Bit DBM.
	DMA_S4CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S4CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S4CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S4CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S4CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S4CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S4CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S4CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S4CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S4CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S4CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S4CR_MINC       = 0x400     // Bit MINC.
	DMA_S4CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S4CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S4CR_PINC       = 0x200     // Bit PINC.
	DMA_S4CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S4CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S4CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S4CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S4CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S4CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S4CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S4CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S4CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S4CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S4CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S4CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S4CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S4CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S4CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S4CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S4CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S4CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S4CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S4CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S4CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S4CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S4CR_EN         = 0x1       // Bit EN.

	// S4NDTR: stream x number of data           register
	DMA_S4NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S4NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S4PAR: stream x peripheral address           register
	DMA_S4PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S4PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S4M0AR: stream x memory 0 address           register
	DMA_S4M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S4M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S4M1AR: stream x memory 1 address           register
	DMA_S4M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S4M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S4FCR: stream x FIFO control register
	DMA_S4FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S4FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S4FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S4FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S4FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S4FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S4FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S4FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S4FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S4FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S5CR: stream x configuration           register
	DMA_S5CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S5CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S5CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S5CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S5CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S5CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S5CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S5CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S5CR_ACK        = 0x100000  // Bit ACK.
	DMA_S5CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S5CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S5CR_CT         = 0x80000   // Bit CT.
	DMA_S5CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S5CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S5CR_DBM        = 0x40000   // Bit DBM.
	DMA_S5CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S5CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S5CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S5CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S5CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S5CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S5CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S5CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S5CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S5CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S5CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S5CR_MINC       = 0x400     // Bit MINC.
	DMA_S5CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S5CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S5CR_PINC       = 0x200     // Bit PINC.
	DMA_S5CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S5CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S5CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S5CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S5CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S5CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S5CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S5CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S5CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S5CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S5CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S5CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S5CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S5CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S5CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S5CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S5CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S5CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S5CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S5CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S5CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S5CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S5CR_EN         = 0x1       // Bit EN.

	// S5NDTR: stream x number of data           register
	DMA_S5NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S5NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S5PAR: stream x peripheral address           register
	DMA_S5PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S5PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S5M0AR: stream x memory 0 address           register
	DMA_S5M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S5M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S5M1AR: stream x memory 1 address           register
	DMA_S5M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S5M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S5FCR: stream x FIFO control register
	DMA_S5FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S5FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S5FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S5FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S5FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S5FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S5FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S5FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S5FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S5FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S6CR: stream x configuration           register
	DMA_S6CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S6CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S6CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S6CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S6CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S6CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S6CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S6CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S6CR_ACK        = 0x100000  // Bit ACK.
	DMA_S6CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S6CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S6CR_CT         = 0x80000   // Bit CT.
	DMA_S6CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S6CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S6CR_DBM        = 0x40000   // Bit DBM.
	DMA_S6CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S6CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S6CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S6CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S6CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S6CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S6CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S6CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S6CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S6CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S6CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S6CR_MINC       = 0x400     // Bit MINC.
	DMA_S6CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S6CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S6CR_PINC       = 0x200     // Bit PINC.
	DMA_S6CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S6CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S6CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S6CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S6CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S6CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S6CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S6CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S6CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S6CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S6CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S6CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S6CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S6CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S6CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S6CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S6CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S6CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S6CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S6CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S6CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S6CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S6CR_EN         = 0x1       // Bit EN.

	// S6NDTR: stream x number of data           register
	DMA_S6NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S6NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S6PAR: stream x peripheral address           register
	DMA_S6PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S6PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S6M0AR: stream x memory 0 address           register
	DMA_S6M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S6M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S6M1AR: stream x memory 1 address           register
	DMA_S6M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S6M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S6FCR: stream x FIFO control register
	DMA_S6FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S6FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S6FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S6FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S6FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S6FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S6FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S6FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S6FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S6FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S7CR: stream x configuration           register
	DMA_S7CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S7CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S7CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S7CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S7CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S7CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S7CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S7CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S7CR_ACK        = 0x100000  // Bit ACK.
	DMA_S7CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S7CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S7CR_CT         = 0x80000   // Bit CT.
	DMA_S7CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S7CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S7CR_DBM        = 0x40000   // Bit DBM.
	DMA_S7CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S7CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S7CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S7CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S7CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S7CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S7CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S7CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S7CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S7CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S7CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S7CR_MINC       = 0x400     // Bit MINC.
	DMA_S7CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S7CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S7CR_PINC       = 0x200     // Bit PINC.
	DMA_S7CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S7CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S7CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S7CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S7CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S7CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S7CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S7CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S7CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S7CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S7CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S7CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S7CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S7CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S7CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S7CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S7CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S7CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S7CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S7CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S7CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S7CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S7CR_EN         = 0x1       // Bit EN.

	// S7NDTR: stream x number of data           register
	DMA_S7NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S7NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S7PAR: stream x peripheral address           register
	DMA_S7PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S7PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S7M0AR: stream x memory 0 address           register
	DMA_S7M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S7M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S7M1AR: stream x memory 1 address           register
	DMA_S7M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S7M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S7FCR: stream x FIFO control register
	DMA_S7FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S7FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S7FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S7FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S7FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S7FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S7FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S7FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S7FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S7FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: clock control register
	RCC_CR_PLLI2SRDY_Pos = 0x1b      // Position of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Msk = 0x8000000 // Bit mask of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY     = 0x8000000 // Bit PLLI2SRDY.
	RCC_CR_PLLI2SON_Pos  = 0x1a      // Position of PLLI2SON field.
	RCC_CR_PLLI2SON_Msk  = 0x4000000 // Bit mask of PLLI2SON field.
	RCC_CR_PLLI2SON      = 0x4000000 // Bit PLLI2SON.
	RCC_CR_PLLRDY_Pos    = 0x19      // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk    = 0x2000000 // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY        = 0x2000000 // Bit PLLRDY.
	RCC_CR_PLLON_Pos     = 0x18      // Position of PLLON field.
	RCC_CR_PLLON_Msk     = 0x1000000 // Bit mask of PLLON field.
	RCC_CR_PLLON         = 0x1000000 // Bit PLLON.
	RCC_CR_CSSON_Pos     = 0x13      // Position of CSSON field.
	RCC_CR_CSSON_Msk     = 0x80000   // Bit mask of CSSON field.
	RCC_CR_CSSON         = 0x80000   // Bit CSSON.
	RCC_CR_HSEBYP_Pos    = 0x12      // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk    = 0x40000   // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP        = 0x40000   // Bit HSEBYP.
	RCC_CR_HSERDY_Pos    = 0x11      // Position of HSERDY field.
	RCC_CR_HSERDY_Msk    = 0x20000   // Bit mask of HSERDY field.
	RCC_CR_HSERDY        = 0x20000   // Bit HSERDY.
	RCC_CR_HSEON_Pos     = 0x10      // Position of HSEON field.
	RCC_CR_HSEON_Msk     = 0x10000   // Bit mask of HSEON field.
	RCC_CR_HSEON         = 0x10000   // Bit HSEON.
	RCC_CR_HSICAL_Pos    = 0x8       // Position of HSICAL field.
	RCC_CR_HSICAL_Msk    = 0xff00    // Bit mask of HSICAL field.
	RCC_CR_HSITRIM_Pos   = 0x3       // Position of HSITRIM field.
	RCC_CR_HSITRIM_Msk   = 0xf8      // Bit mask of HSITRIM field.
	RCC_CR_HSIRDY_Pos    = 0x1       // Position of HSIRDY field.
	RCC_CR_HSIRDY_Msk    = 0x2       // Bit mask of HSIRDY field.
	RCC_CR_HSIRDY        = 0x2       // Bit HSIRDY.
	RCC_CR_HSION_Pos     = 0x0       // Position of HSION field.
	RCC_CR_HSION_Msk     = 0x1       // Bit mask of HSION field.
	RCC_CR_HSION         = 0x1       // Bit HSION.

	// PLLCFGR: PLL configuration register
	RCC_PLLCFGR_PLLQ3_Pos  = 0x1b      // Position of PLLQ3 field.
	RCC_PLLCFGR_PLLQ3_Msk  = 0x8000000 // Bit mask of PLLQ3 field.
	RCC_PLLCFGR_PLLQ3      = 0x8000000 // Bit PLLQ3.
	RCC_PLLCFGR_PLLQ2_Pos  = 0x1a      // Position of PLLQ2 field.
	RCC_PLLCFGR_PLLQ2_Msk  = 0x4000000 // Bit mask of PLLQ2 field.
	RCC_PLLCFGR_PLLQ2      = 0x4000000 // Bit PLLQ2.
	RCC_PLLCFGR_PLLQ1_Pos  = 0x19      // Position of PLLQ1 field.
	RCC_PLLCFGR_PLLQ1_Msk  = 0x2000000 // Bit mask of PLLQ1 field.
	RCC_PLLCFGR_PLLQ1      = 0x2000000 // Bit PLLQ1.
	RCC_PLLCFGR_PLLQ0_Pos  = 0x18      // Position of PLLQ0 field.
	RCC_PLLCFGR_PLLQ0_Msk  = 0x1000000 // Bit mask of PLLQ0 field.
	RCC_PLLCFGR_PLLQ0      = 0x1000000 // Bit PLLQ0.
	RCC_PLLCFGR_PLLSRC_Pos = 0x16      // Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x400000  // Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC     = 0x400000  // Bit PLLSRC.
	RCC_PLLCFGR_PLLP1_Pos  = 0x11      // Position of PLLP1 field.
	RCC_PLLCFGR_PLLP1_Msk  = 0x20000   // Bit mask of PLLP1 field.
	RCC_PLLCFGR_PLLP1      = 0x20000   // Bit PLLP1.
	RCC_PLLCFGR_PLLP0_Pos  = 0x10      // Position of PLLP0 field.
	RCC_PLLCFGR_PLLP0_Msk  = 0x10000   // Bit mask of PLLP0 field.
	RCC_PLLCFGR_PLLP0      = 0x10000   // Bit PLLP0.
	RCC_PLLCFGR_PLLN8_Pos  = 0xe       // Position of PLLN8 field.
	RCC_PLLCFGR_PLLN8_Msk  = 0x4000    // Bit mask of PLLN8 field.
	RCC_PLLCFGR_PLLN8      = 0x4000    // Bit PLLN8.
	RCC_PLLCFGR_PLLN7_Pos  = 0xd       // Position of PLLN7 field.
	RCC_PLLCFGR_PLLN7_Msk  = 0x2000    // Bit mask of PLLN7 field.
	RCC_PLLCFGR_PLLN7      = 0x2000    // Bit PLLN7.
	RCC_PLLCFGR_PLLN6_Pos  = 0xc       // Position of PLLN6 field.
	RCC_PLLCFGR_PLLN6_Msk  = 0x1000    // Bit mask of PLLN6 field.
	RCC_PLLCFGR_PLLN6      = 0x1000    // Bit PLLN6.
	RCC_PLLCFGR_PLLN5_Pos  = 0xb       // Position of PLLN5 field.
	RCC_PLLCFGR_PLLN5_Msk  = 0x800     // Bit mask of PLLN5 field.
	RCC_PLLCFGR_PLLN5      = 0x800     // Bit PLLN5.
	RCC_PLLCFGR_PLLN4_Pos  = 0xa       // Position of PLLN4 field.
	RCC_PLLCFGR_PLLN4_Msk  = 0x400     // Bit mask of PLLN4 field.
	RCC_PLLCFGR_PLLN4      = 0x400     // Bit PLLN4.
	RCC_PLLCFGR_PLLN3_Pos  = 0x9       // Position of PLLN3 field.
	RCC_PLLCFGR_PLLN3_Msk  = 0x200     // Bit mask of PLLN3 field.
	RCC_PLLCFGR_PLLN3      = 0x200     // Bit PLLN3.
	RCC_PLLCFGR_PLLN2_Pos  = 0x8       // Position of PLLN2 field.
	RCC_PLLCFGR_PLLN2_Msk  = 0x100     // Bit mask of PLLN2 field.
	RCC_PLLCFGR_PLLN2      = 0x100     // Bit PLLN2.
	RCC_PLLCFGR_PLLN1_Pos  = 0x7       // Position of PLLN1 field.
	RCC_PLLCFGR_PLLN1_Msk  = 0x80      // Bit mask of PLLN1 field.
	RCC_PLLCFGR_PLLN1      = 0x80      // Bit PLLN1.
	RCC_PLLCFGR_PLLN0_Pos  = 0x6       // Position of PLLN0 field.
	RCC_PLLCFGR_PLLN0_Msk  = 0x40      // Bit mask of PLLN0 field.
	RCC_PLLCFGR_PLLN0      = 0x40      // Bit PLLN0.
	RCC_PLLCFGR_PLLM5_Pos  = 0x5       // Position of PLLM5 field.
	RCC_PLLCFGR_PLLM5_Msk  = 0x20      // Bit mask of PLLM5 field.
	RCC_PLLCFGR_PLLM5      = 0x20      // Bit PLLM5.
	RCC_PLLCFGR_PLLM4_Pos  = 0x4       // Position of PLLM4 field.
	RCC_PLLCFGR_PLLM4_Msk  = 0x10      // Bit mask of PLLM4 field.
	RCC_PLLCFGR_PLLM4      = 0x10      // Bit PLLM4.
	RCC_PLLCFGR_PLLM3_Pos  = 0x3       // Position of PLLM3 field.
	RCC_PLLCFGR_PLLM3_Msk  = 0x8       // Bit mask of PLLM3 field.
	RCC_PLLCFGR_PLLM3      = 0x8       // Bit PLLM3.
	RCC_PLLCFGR_PLLM2_Pos  = 0x2       // Position of PLLM2 field.
	RCC_PLLCFGR_PLLM2_Msk  = 0x4       // Bit mask of PLLM2 field.
	RCC_PLLCFGR_PLLM2      = 0x4       // Bit PLLM2.
	RCC_PLLCFGR_PLLM1_Pos  = 0x1       // Position of PLLM1 field.
	RCC_PLLCFGR_PLLM1_Msk  = 0x2       // Bit mask of PLLM1 field.
	RCC_PLLCFGR_PLLM1      = 0x2       // Bit PLLM1.
	RCC_PLLCFGR_PLLM0_Pos  = 0x0       // Position of PLLM0 field.
	RCC_PLLCFGR_PLLM0_Msk  = 0x1       // Bit mask of PLLM0 field.
	RCC_PLLCFGR_PLLM0      = 0x1       // Bit PLLM0.

	// CFGR: clock configuration register
	RCC_CFGR_MCO2_Pos    = 0x1e       // Position of MCO2 field.
	RCC_CFGR_MCO2_Msk    = 0xc0000000 // Bit mask of MCO2 field.
	RCC_CFGR_MCO2PRE_Pos = 0x1b       // Position of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Msk = 0x38000000 // Bit mask of MCO2PRE field.
	RCC_CFGR_MCO1PRE_Pos = 0x18       // Position of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Msk = 0x7000000  // Bit mask of MCO1PRE field.
	RCC_CFGR_I2SSRC_Pos  = 0x17       // Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk  = 0x800000   // Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC      = 0x800000   // Bit I2SSRC.
	RCC_CFGR_MCO1_Pos    = 0x15       // Position of MCO1 field.
	RCC_CFGR_MCO1_Msk    = 0x600000   // Bit mask of MCO1 field.
	RCC_CFGR_RTCPRE_Pos  = 0x10       // Position of RTCPRE field.
	RCC_CFGR_RTCPRE_Msk  = 0x1f0000   // Bit mask of RTCPRE field.
	RCC_CFGR_PPRE2_Pos   = 0xd        // Position of PPRE2 field.
	RCC_CFGR_PPRE2_Msk   = 0xe000     // Bit mask of PPRE2 field.
	RCC_CFGR_PPRE1_Pos   = 0xa        // Position of PPRE1 field.
	RCC_CFGR_PPRE1_Msk   = 0x1c00     // Bit mask of PPRE1 field.
	RCC_CFGR_HPRE_Pos    = 0x4        // Position of HPRE field.
	RCC_CFGR_HPRE_Msk    = 0xf0       // Bit mask of HPRE field.
	RCC_CFGR_SWS1_Pos    = 0x3        // Position of SWS1 field.
	RCC_CFGR_SWS1_Msk    = 0x8        // Bit mask of SWS1 field.
	RCC_CFGR_SWS1        = 0x8        // Bit SWS1.
	RCC_CFGR_SWS0_Pos    = 0x2        // Position of SWS0 field.
	RCC_CFGR_SWS0_Msk    = 0x4        // Bit mask of SWS0 field.
	RCC_CFGR_SWS0        = 0x4        // Bit SWS0.
	RCC_CFGR_SW1_Pos     = 0x1        // Position of SW1 field.
	RCC_CFGR_SW1_Msk     = 0x2        // Bit mask of SW1 field.
	RCC_CFGR_SW1         = 0x2        // Bit SW1.
	RCC_CFGR_SW0_Pos     = 0x0        // Position of SW0 field.
	RCC_CFGR_SW0_Msk     = 0x1        // Bit mask of SW0 field.
	RCC_CFGR_SW0         = 0x1        // Bit SW0.

	// CIR: clock interrupt register
	RCC_CIR_CSSC_Pos        = 0x17     // Position of CSSC field.
	RCC_CIR_CSSC_Msk        = 0x800000 // Bit mask of CSSC field.
	RCC_CIR_CSSC            = 0x800000 // Bit CSSC.
	RCC_CIR_PLLSAIRDYC_Pos  = 0x16     // Position of PLLSAIRDYC field.
	RCC_CIR_PLLSAIRDYC_Msk  = 0x400000 // Bit mask of PLLSAIRDYC field.
	RCC_CIR_PLLSAIRDYC      = 0x400000 // Bit PLLSAIRDYC.
	RCC_CIR_PLLI2SRDYC_Pos  = 0x15     // Position of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Msk  = 0x200000 // Bit mask of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC      = 0x200000 // Bit PLLI2SRDYC.
	RCC_CIR_PLLRDYC_Pos     = 0x14     // Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk     = 0x100000 // Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC         = 0x100000 // Bit PLLRDYC.
	RCC_CIR_HSERDYC_Pos     = 0x13     // Position of HSERDYC field.
	RCC_CIR_HSERDYC_Msk     = 0x80000  // Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC         = 0x80000  // Bit HSERDYC.
	RCC_CIR_HSIRDYC_Pos     = 0x12     // Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk     = 0x40000  // Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC         = 0x40000  // Bit HSIRDYC.
	RCC_CIR_LSERDYC_Pos     = 0x11     // Position of LSERDYC field.
	RCC_CIR_LSERDYC_Msk     = 0x20000  // Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC         = 0x20000  // Bit LSERDYC.
	RCC_CIR_LSIRDYC_Pos     = 0x10     // Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk     = 0x10000  // Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC         = 0x10000  // Bit LSIRDYC.
	RCC_CIR_PLLSAIRDYIE_Pos = 0xe      // Position of PLLSAIRDYIE field.
	RCC_CIR_PLLSAIRDYIE_Msk = 0x4000   // Bit mask of PLLSAIRDYIE field.
	RCC_CIR_PLLSAIRDYIE     = 0x4000   // Bit PLLSAIRDYIE.
	RCC_CIR_PLLI2SRDYIE_Pos = 0xd      // Position of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Msk = 0x2000   // Bit mask of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE     = 0x2000   // Bit PLLI2SRDYIE.
	RCC_CIR_PLLRDYIE_Pos    = 0xc      // Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk    = 0x1000   // Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE        = 0x1000   // Bit PLLRDYIE.
	RCC_CIR_HSERDYIE_Pos    = 0xb      // Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk    = 0x800    // Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE        = 0x800    // Bit HSERDYIE.
	RCC_CIR_HSIRDYIE_Pos    = 0xa      // Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk    = 0x400    // Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE        = 0x400    // Bit HSIRDYIE.
	RCC_CIR_LSERDYIE_Pos    = 0x9      // Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk    = 0x200    // Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE        = 0x200    // Bit LSERDYIE.
	RCC_CIR_LSIRDYIE_Pos    = 0x8      // Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk    = 0x100    // Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE        = 0x100    // Bit LSIRDYIE.
	RCC_CIR_CSSF_Pos        = 0x7      // Position of CSSF field.
	RCC_CIR_CSSF_Msk        = 0x80     // Bit mask of CSSF field.
	RCC_CIR_CSSF            = 0x80     // Bit CSSF.
	RCC_CIR_PLLSAIRDYF_Pos  = 0x6      // Position of PLLSAIRDYF field.
	RCC_CIR_PLLSAIRDYF_Msk  = 0x40     // Bit mask of PLLSAIRDYF field.
	RCC_CIR_PLLSAIRDYF      = 0x40     // Bit PLLSAIRDYF.
	RCC_CIR_PLLI2SRDYF_Pos  = 0x5      // Position of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Msk  = 0x20     // Bit mask of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF      = 0x20     // Bit PLLI2SRDYF.
	RCC_CIR_PLLRDYF_Pos     = 0x4      // Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk     = 0x10     // Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF         = 0x10     // Bit PLLRDYF.
	RCC_CIR_HSERDYF_Pos     = 0x3      // Position of HSERDYF field.
	RCC_CIR_HSERDYF_Msk     = 0x8      // Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF         = 0x8      // Bit HSERDYF.
	RCC_CIR_HSIRDYF_Pos     = 0x2      // Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk     = 0x4      // Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF         = 0x4      // Bit HSIRDYF.
	RCC_CIR_LSERDYF_Pos     = 0x1      // Position of LSERDYF field.
	RCC_CIR_LSERDYF_Msk     = 0x2      // Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF         = 0x2      // Bit LSERDYF.
	RCC_CIR_LSIRDYF_Pos     = 0x0      // Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk     = 0x1      // Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF         = 0x1      // Bit LSIRDYF.

	// AHB1RSTR: AHB1 peripheral reset register
	RCC_AHB1RSTR_OTGHSRST_Pos = 0x1d       // Position of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST_Msk = 0x20000000 // Bit mask of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST     = 0x20000000 // Bit OTGHSRST.
	RCC_AHB1RSTR_DMA2RST_Pos  = 0x16       // Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk  = 0x400000   // Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST      = 0x400000   // Bit DMA2RST.
	RCC_AHB1RSTR_DMA1RST_Pos  = 0x15       // Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk  = 0x200000   // Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST      = 0x200000   // Bit DMA1RST.
	RCC_AHB1RSTR_CRCRST_Pos   = 0xc        // Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk   = 0x1000     // Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST       = 0x1000     // Bit CRCRST.
	RCC_AHB1RSTR_GPIOHRST_Pos = 0x7        // Position of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Msk = 0x80       // Bit mask of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST     = 0x80       // Bit GPIOHRST.
	RCC_AHB1RSTR_GPIOGRST_Pos = 0x6        // Position of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST_Msk = 0x40       // Bit mask of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST     = 0x40       // Bit GPIOGRST.
	RCC_AHB1RSTR_GPIOFRST_Pos = 0x5        // Position of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST_Msk = 0x20       // Bit mask of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST     = 0x20       // Bit GPIOFRST.
	RCC_AHB1RSTR_GPIOERST_Pos = 0x4        // Position of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Msk = 0x10       // Bit mask of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST     = 0x10       // Bit GPIOERST.
	RCC_AHB1RSTR_GPIODRST_Pos = 0x3        // Position of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Msk = 0x8        // Bit mask of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST     = 0x8        // Bit GPIODRST.
	RCC_AHB1RSTR_GPIOCRST_Pos = 0x2        // Position of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Msk = 0x4        // Bit mask of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST     = 0x4        // Bit GPIOCRST.
	RCC_AHB1RSTR_GPIOBRST_Pos = 0x1        // Position of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Msk = 0x2        // Bit mask of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST     = 0x2        // Bit GPIOBRST.
	RCC_AHB1RSTR_GPIOARST_Pos = 0x0        // Position of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Msk = 0x1        // Bit mask of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST     = 0x1        // Bit GPIOARST.

	// AHB2RSTR: AHB2 peripheral reset register
	RCC_AHB2RSTR_OTGFSRST_Pos = 0x7  // Position of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Msk = 0x80 // Bit mask of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST     = 0x80 // Bit OTGFSRST.
	RCC_AHB2RSTR_DCMIRST_Pos  = 0x0  // Position of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST_Msk  = 0x1  // Bit mask of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST      = 0x1  // Bit DCMIRST.

	// AHB3RSTR: AHB3 peripheral reset register
	RCC_AHB3RSTR_FMCRST_Pos  = 0x0 // Position of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Msk  = 0x1 // Bit mask of FMCRST field.
	RCC_AHB3RSTR_FMCRST      = 0x1 // Bit FMCRST.
	RCC_AHB3RSTR_QSPIRST_Pos = 0x1 // Position of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Msk = 0x2 // Bit mask of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST     = 0x2 // Bit QSPIRST.

	// APB1RSTR: APB1 peripheral reset register
	RCC_APB1RSTR_TIM2RST_Pos    = 0x0        // Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk    = 0x1        // Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST        = 0x1        // Bit TIM2RST.
	RCC_APB1RSTR_TIM3RST_Pos    = 0x1        // Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk    = 0x2        // Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST        = 0x2        // Bit TIM3RST.
	RCC_APB1RSTR_TIM4RST_Pos    = 0x2        // Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk    = 0x4        // Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST        = 0x4        // Bit TIM4RST.
	RCC_APB1RSTR_TIM5RST_Pos    = 0x3        // Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk    = 0x8        // Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST        = 0x8        // Bit TIM5RST.
	RCC_APB1RSTR_TIM6RST_Pos    = 0x4        // Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk    = 0x10       // Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST        = 0x10       // Bit TIM6RST.
	RCC_APB1RSTR_TIM7RST_Pos    = 0x5        // Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk    = 0x20       // Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST        = 0x20       // Bit TIM7RST.
	RCC_APB1RSTR_TIM12RST_Pos   = 0x6        // Position of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Msk   = 0x40       // Bit mask of TIM12RST field.
	RCC_APB1RSTR_TIM12RST       = 0x40       // Bit TIM12RST.
	RCC_APB1RSTR_TIM13RST_Pos   = 0x7        // Position of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Msk   = 0x80       // Bit mask of TIM13RST field.
	RCC_APB1RSTR_TIM13RST       = 0x80       // Bit TIM13RST.
	RCC_APB1RSTR_TIM14RST_Pos   = 0x8        // Position of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Msk   = 0x100      // Bit mask of TIM14RST field.
	RCC_APB1RSTR_TIM14RST       = 0x100      // Bit TIM14RST.
	RCC_APB1RSTR_WWDGRST_Pos    = 0xb        // Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk    = 0x800      // Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST        = 0x800      // Bit WWDGRST.
	RCC_APB1RSTR_SPI2RST_Pos    = 0xe        // Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk    = 0x4000     // Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST        = 0x4000     // Bit SPI2RST.
	RCC_APB1RSTR_SPI3RST_Pos    = 0xf        // Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk    = 0x8000     // Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST        = 0x8000     // Bit SPI3RST.
	RCC_APB1RSTR_SPDIFRST_Pos   = 0x10       // Position of SPDIFRST field.
	RCC_APB1RSTR_SPDIFRST_Msk   = 0x10000    // Bit mask of SPDIFRST field.
	RCC_APB1RSTR_SPDIFRST       = 0x10000    // Bit SPDIFRST.
	RCC_APB1RSTR_UART2RST_Pos   = 0x11       // Position of UART2RST field.
	RCC_APB1RSTR_UART2RST_Msk   = 0x20000    // Bit mask of UART2RST field.
	RCC_APB1RSTR_UART2RST       = 0x20000    // Bit UART2RST.
	RCC_APB1RSTR_UART3RST_Pos   = 0x12       // Position of UART3RST field.
	RCC_APB1RSTR_UART3RST_Msk   = 0x40000    // Bit mask of UART3RST field.
	RCC_APB1RSTR_UART3RST       = 0x40000    // Bit UART3RST.
	RCC_APB1RSTR_UART4RST_Pos   = 0x13       // Position of UART4RST field.
	RCC_APB1RSTR_UART4RST_Msk   = 0x80000    // Bit mask of UART4RST field.
	RCC_APB1RSTR_UART4RST       = 0x80000    // Bit UART4RST.
	RCC_APB1RSTR_UART5RST_Pos   = 0x14       // Position of UART5RST field.
	RCC_APB1RSTR_UART5RST_Msk   = 0x100000   // Bit mask of UART5RST field.
	RCC_APB1RSTR_UART5RST       = 0x100000   // Bit UART5RST.
	RCC_APB1RSTR_I2C1RST_Pos    = 0x15       // Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk    = 0x200000   // Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST        = 0x200000   // Bit I2C1RST.
	RCC_APB1RSTR_I2C2RST_Pos    = 0x16       // Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk    = 0x400000   // Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST        = 0x400000   // Bit I2C2RST.
	RCC_APB1RSTR_I2C3RST_Pos    = 0x17       // Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk    = 0x800000   // Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST        = 0x800000   // Bit I2C3RST.
	RCC_APB1RSTR_I2CFMP1RST_Pos = 0x18       // Position of I2CFMP1RST field.
	RCC_APB1RSTR_I2CFMP1RST_Msk = 0x1000000  // Bit mask of I2CFMP1RST field.
	RCC_APB1RSTR_I2CFMP1RST     = 0x1000000  // Bit I2CFMP1RST.
	RCC_APB1RSTR_CAN1RST_Pos    = 0x19       // Position of CAN1RST field.
	RCC_APB1RSTR_CAN1RST_Msk    = 0x2000000  // Bit mask of CAN1RST field.
	RCC_APB1RSTR_CAN1RST        = 0x2000000  // Bit CAN1RST.
	RCC_APB1RSTR_CAN2RST_Pos    = 0x1a       // Position of CAN2RST field.
	RCC_APB1RSTR_CAN2RST_Msk    = 0x4000000  // Bit mask of CAN2RST field.
	RCC_APB1RSTR_CAN2RST        = 0x4000000  // Bit CAN2RST.
	RCC_APB1RSTR_PWRRST_Pos     = 0x1c       // Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk     = 0x10000000 // Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST         = 0x10000000 // Bit PWRRST.
	RCC_APB1RSTR_DACRST_Pos     = 0x1d       // Position of DACRST field.
	RCC_APB1RSTR_DACRST_Msk     = 0x20000000 // Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST         = 0x20000000 // Bit DACRST.

	// APB2RSTR: APB2 peripheral reset register
	RCC_APB2RSTR_TIM1RST_Pos   = 0x0      // Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk   = 0x1      // Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST       = 0x1      // Bit TIM1RST.
	RCC_APB2RSTR_TIM8RST_Pos   = 0x1      // Position of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Msk   = 0x2      // Bit mask of TIM8RST field.
	RCC_APB2RSTR_TIM8RST       = 0x2      // Bit TIM8RST.
	RCC_APB2RSTR_USART1RST_Pos = 0x4      // Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x10     // Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST     = 0x10     // Bit USART1RST.
	RCC_APB2RSTR_USART6RST_Pos = 0x5      // Position of USART6RST field.
	RCC_APB2RSTR_USART6RST_Msk = 0x20     // Bit mask of USART6RST field.
	RCC_APB2RSTR_USART6RST     = 0x20     // Bit USART6RST.
	RCC_APB2RSTR_ADCRST_Pos    = 0x8      // Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk    = 0x100    // Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST        = 0x100    // Bit ADCRST.
	RCC_APB2RSTR_SDIORST_Pos   = 0xb      // Position of SDIORST field.
	RCC_APB2RSTR_SDIORST_Msk   = 0x800    // Bit mask of SDIORST field.
	RCC_APB2RSTR_SDIORST       = 0x800    // Bit SDIORST.
	RCC_APB2RSTR_SPI1RST_Pos   = 0xc      // Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk   = 0x1000   // Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST       = 0x1000   // Bit SPI1RST.
	RCC_APB2RSTR_SPI4RST_Pos   = 0xd      // Position of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Msk   = 0x2000   // Bit mask of SPI4RST field.
	RCC_APB2RSTR_SPI4RST       = 0x2000   // Bit SPI4RST.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0xe      // Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x4000   // Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST     = 0x4000   // Bit SYSCFGRST.
	RCC_APB2RSTR_TIM9RST_Pos   = 0x10     // Position of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Msk   = 0x10000  // Bit mask of TIM9RST field.
	RCC_APB2RSTR_TIM9RST       = 0x10000  // Bit TIM9RST.
	RCC_APB2RSTR_TIM10RST_Pos  = 0x11     // Position of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Msk  = 0x20000  // Bit mask of TIM10RST field.
	RCC_APB2RSTR_TIM10RST      = 0x20000  // Bit TIM10RST.
	RCC_APB2RSTR_TIM11RST_Pos  = 0x12     // Position of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Msk  = 0x40000  // Bit mask of TIM11RST field.
	RCC_APB2RSTR_TIM11RST      = 0x40000  // Bit TIM11RST.
	RCC_APB2RSTR_SAI1RST_Pos   = 0x16     // Position of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Msk   = 0x400000 // Bit mask of SAI1RST field.
	RCC_APB2RSTR_SAI1RST       = 0x400000 // Bit SAI1RST.
	RCC_APB2RSTR_SAI2RST_Pos   = 0x17     // Position of SAI2RST field.
	RCC_APB2RSTR_SAI2RST_Msk   = 0x800000 // Bit mask of SAI2RST field.
	RCC_APB2RSTR_SAI2RST       = 0x800000 // Bit SAI2RST.

	// AHB1ENR: AHB1 peripheral clock register
	RCC_AHB1ENR_OTGHSULPIEN_Pos = 0x1e       // Position of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN_Msk = 0x40000000 // Bit mask of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN     = 0x40000000 // Bit OTGHSULPIEN.
	RCC_AHB1ENR_OTGHSEN_Pos     = 0x1d       // Position of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN_Msk     = 0x20000000 // Bit mask of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN         = 0x20000000 // Bit OTGHSEN.
	RCC_AHB1ENR_DMA2EN_Pos      = 0x16       // Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk      = 0x400000   // Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN          = 0x400000   // Bit DMA2EN.
	RCC_AHB1ENR_DMA1EN_Pos      = 0x15       // Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk      = 0x200000   // Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN          = 0x200000   // Bit DMA1EN.
	RCC_AHB1ENR_BKPSRAMEN_Pos   = 0x12       // Position of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN_Msk   = 0x40000    // Bit mask of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN       = 0x40000    // Bit BKPSRAMEN.
	RCC_AHB1ENR_CRCEN_Pos       = 0xc        // Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk       = 0x1000     // Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN           = 0x1000     // Bit CRCEN.
	RCC_AHB1ENR_GPIOHEN_Pos     = 0x7        // Position of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Msk     = 0x80       // Bit mask of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN         = 0x80       // Bit GPIOHEN.
	RCC_AHB1ENR_GPIOGEN_Pos     = 0x6        // Position of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN_Msk     = 0x40       // Bit mask of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN         = 0x40       // Bit GPIOGEN.
	RCC_AHB1ENR_GPIOFEN_Pos     = 0x5        // Position of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN_Msk     = 0x20       // Bit mask of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN         = 0x20       // Bit GPIOFEN.
	RCC_AHB1ENR_GPIOEEN_Pos     = 0x4        // Position of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Msk     = 0x10       // Bit mask of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN         = 0x10       // Bit GPIOEEN.
	RCC_AHB1ENR_GPIODEN_Pos     = 0x3        // Position of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Msk     = 0x8        // Bit mask of GPIODEN field.
	RCC_AHB1ENR_GPIODEN         = 0x8        // Bit GPIODEN.
	RCC_AHB1ENR_GPIOCEN_Pos     = 0x2        // Position of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Msk     = 0x4        // Bit mask of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN         = 0x4        // Bit GPIOCEN.
	RCC_AHB1ENR_GPIOBEN_Pos     = 0x1        // Position of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Msk     = 0x2        // Bit mask of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN         = 0x2        // Bit GPIOBEN.
	RCC_AHB1ENR_GPIOAEN_Pos     = 0x0        // Position of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Msk     = 0x1        // Bit mask of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN         = 0x1        // Bit GPIOAEN.

	// AHB2ENR: AHB2 peripheral clock enable           register
	RCC_AHB2ENR_OTGFSEN_Pos = 0x7  // Position of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Msk = 0x80 // Bit mask of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN     = 0x80 // Bit OTGFSEN.
	RCC_AHB2ENR_DCMIEN_Pos  = 0x0  // Position of DCMIEN field.
	RCC_AHB2ENR_DCMIEN_Msk  = 0x1  // Bit mask of DCMIEN field.
	RCC_AHB2ENR_DCMIEN      = 0x1  // Bit DCMIEN.

	// AHB3ENR: AHB3 peripheral clock enable           register
	RCC_AHB3ENR_FMCEN_Pos  = 0x0 // Position of FMCEN field.
	RCC_AHB3ENR_FMCEN_Msk  = 0x1 // Bit mask of FMCEN field.
	RCC_AHB3ENR_FMCEN      = 0x1 // Bit FMCEN.
	RCC_AHB3ENR_QSPIEN_Pos = 0x1 // Position of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Msk = 0x2 // Bit mask of QSPIEN field.
	RCC_AHB3ENR_QSPIEN     = 0x2 // Bit QSPIEN.

	// APB1ENR: APB1 peripheral clock enable           register
	RCC_APB1ENR_TIM2EN_Pos    = 0x0        // Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk    = 0x1        // Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN        = 0x1        // Bit TIM2EN.
	RCC_APB1ENR_TIM3EN_Pos    = 0x1        // Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk    = 0x2        // Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN        = 0x2        // Bit TIM3EN.
	RCC_APB1ENR_TIM4EN_Pos    = 0x2        // Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk    = 0x4        // Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN        = 0x4        // Bit TIM4EN.
	RCC_APB1ENR_TIM5EN_Pos    = 0x3        // Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk    = 0x8        // Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN        = 0x8        // Bit TIM5EN.
	RCC_APB1ENR_TIM6EN_Pos    = 0x4        // Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk    = 0x10       // Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN        = 0x10       // Bit TIM6EN.
	RCC_APB1ENR_TIM7EN_Pos    = 0x5        // Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk    = 0x20       // Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN        = 0x20       // Bit TIM7EN.
	RCC_APB1ENR_TIM12EN_Pos   = 0x6        // Position of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Msk   = 0x40       // Bit mask of TIM12EN field.
	RCC_APB1ENR_TIM12EN       = 0x40       // Bit TIM12EN.
	RCC_APB1ENR_TIM13EN_Pos   = 0x7        // Position of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Msk   = 0x80       // Bit mask of TIM13EN field.
	RCC_APB1ENR_TIM13EN       = 0x80       // Bit TIM13EN.
	RCC_APB1ENR_TIM14EN_Pos   = 0x8        // Position of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Msk   = 0x100      // Bit mask of TIM14EN field.
	RCC_APB1ENR_TIM14EN       = 0x100      // Bit TIM14EN.
	RCC_APB1ENR_WWDGEN_Pos    = 0xb        // Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk    = 0x800      // Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN        = 0x800      // Bit WWDGEN.
	RCC_APB1ENR_SPI2EN_Pos    = 0xe        // Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk    = 0x4000     // Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN        = 0x4000     // Bit SPI2EN.
	RCC_APB1ENR_SPI3EN_Pos    = 0xf        // Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk    = 0x8000     // Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN        = 0x8000     // Bit SPI3EN.
	RCC_APB1ENR_SPDIFEN_Pos   = 0x10       // Position of SPDIFEN field.
	RCC_APB1ENR_SPDIFEN_Msk   = 0x10000    // Bit mask of SPDIFEN field.
	RCC_APB1ENR_SPDIFEN       = 0x10000    // Bit SPDIFEN.
	RCC_APB1ENR_USART2EN_Pos  = 0x11       // Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk  = 0x20000    // Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN      = 0x20000    // Bit USART2EN.
	RCC_APB1ENR_USART3EN_Pos  = 0x12       // Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk  = 0x40000    // Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN      = 0x40000    // Bit USART3EN.
	RCC_APB1ENR_UART4EN_Pos   = 0x13       // Position of UART4EN field.
	RCC_APB1ENR_UART4EN_Msk   = 0x80000    // Bit mask of UART4EN field.
	RCC_APB1ENR_UART4EN       = 0x80000    // Bit UART4EN.
	RCC_APB1ENR_UART5EN_Pos   = 0x14       // Position of UART5EN field.
	RCC_APB1ENR_UART5EN_Msk   = 0x100000   // Bit mask of UART5EN field.
	RCC_APB1ENR_UART5EN       = 0x100000   // Bit UART5EN.
	RCC_APB1ENR_I2C1EN_Pos    = 0x15       // Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk    = 0x200000   // Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN        = 0x200000   // Bit I2C1EN.
	RCC_APB1ENR_I2C2EN_Pos    = 0x16       // Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk    = 0x400000   // Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN        = 0x400000   // Bit I2C2EN.
	RCC_APB1ENR_I2C3EN_Pos    = 0x17       // Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk    = 0x800000   // Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN        = 0x800000   // Bit I2C3EN.
	RCC_APB1ENR_I2CFMP1EN_Pos = 0x18       // Position of I2CFMP1EN field.
	RCC_APB1ENR_I2CFMP1EN_Msk = 0x1000000  // Bit mask of I2CFMP1EN field.
	RCC_APB1ENR_I2CFMP1EN     = 0x1000000  // Bit I2CFMP1EN.
	RCC_APB1ENR_CAN1EN_Pos    = 0x19       // Position of CAN1EN field.
	RCC_APB1ENR_CAN1EN_Msk    = 0x2000000  // Bit mask of CAN1EN field.
	RCC_APB1ENR_CAN1EN        = 0x2000000  // Bit CAN1EN.
	RCC_APB1ENR_CAN2EN_Pos    = 0x1a       // Position of CAN2EN field.
	RCC_APB1ENR_CAN2EN_Msk    = 0x4000000  // Bit mask of CAN2EN field.
	RCC_APB1ENR_CAN2EN        = 0x4000000  // Bit CAN2EN.
	RCC_APB1ENR_CEC_Pos       = 0x1b       // Position of CEC field.
	RCC_APB1ENR_CEC_Msk       = 0x8000000  // Bit mask of CEC field.
	RCC_APB1ENR_CEC           = 0x8000000  // Bit CEC.
	RCC_APB1ENR_PWREN_Pos     = 0x1c       // Position of PWREN field.
	RCC_APB1ENR_PWREN_Msk     = 0x10000000 // Bit mask of PWREN field.
	RCC_APB1ENR_PWREN         = 0x10000000 // Bit PWREN.
	RCC_APB1ENR_DACEN_Pos     = 0x1d       // Position of DACEN field.
	RCC_APB1ENR_DACEN_Msk     = 0x20000000 // Bit mask of DACEN field.
	RCC_APB1ENR_DACEN         = 0x20000000 // Bit DACEN.

	// APB2ENR: APB2 peripheral clock enable           register
	RCC_APB2ENR_TIM1EN_Pos   = 0x0      // Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk   = 0x1      // Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN       = 0x1      // Bit TIM1EN.
	RCC_APB2ENR_TIM8EN_Pos   = 0x1      // Position of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Msk   = 0x2      // Bit mask of TIM8EN field.
	RCC_APB2ENR_TIM8EN       = 0x2      // Bit TIM8EN.
	RCC_APB2ENR_USART1EN_Pos = 0x4      // Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x10     // Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN     = 0x10     // Bit USART1EN.
	RCC_APB2ENR_USART6EN_Pos = 0x5      // Position of USART6EN field.
	RCC_APB2ENR_USART6EN_Msk = 0x20     // Bit mask of USART6EN field.
	RCC_APB2ENR_USART6EN     = 0x20     // Bit USART6EN.
	RCC_APB2ENR_ADC1EN_Pos   = 0x8      // Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk   = 0x100    // Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN       = 0x100    // Bit ADC1EN.
	RCC_APB2ENR_ADC2EN_Pos   = 0x9      // Position of ADC2EN field.
	RCC_APB2ENR_ADC2EN_Msk   = 0x200    // Bit mask of ADC2EN field.
	RCC_APB2ENR_ADC2EN       = 0x200    // Bit ADC2EN.
	RCC_APB2ENR_ADC3EN_Pos   = 0xa      // Position of ADC3EN field.
	RCC_APB2ENR_ADC3EN_Msk   = 0x400    // Bit mask of ADC3EN field.
	RCC_APB2ENR_ADC3EN       = 0x400    // Bit ADC3EN.
	RCC_APB2ENR_SDIOEN_Pos   = 0xb      // Position of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Msk   = 0x800    // Bit mask of SDIOEN field.
	RCC_APB2ENR_SDIOEN       = 0x800    // Bit SDIOEN.
	RCC_APB2ENR_SPI1EN_Pos   = 0xc      // Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk   = 0x1000   // Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN       = 0x1000   // Bit SPI1EN.
	RCC_APB2ENR_SPI4ENR_Pos  = 0xd      // Position of SPI4ENR field.
	RCC_APB2ENR_SPI4ENR_Msk  = 0x2000   // Bit mask of SPI4ENR field.
	RCC_APB2ENR_SPI4ENR      = 0x2000   // Bit SPI4ENR.
	RCC_APB2ENR_SYSCFGEN_Pos = 0xe      // Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x4000   // Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN     = 0x4000   // Bit SYSCFGEN.
	RCC_APB2ENR_TIM9EN_Pos   = 0x10     // Position of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Msk   = 0x10000  // Bit mask of TIM9EN field.
	RCC_APB2ENR_TIM9EN       = 0x10000  // Bit TIM9EN.
	RCC_APB2ENR_TIM10EN_Pos  = 0x11     // Position of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Msk  = 0x20000  // Bit mask of TIM10EN field.
	RCC_APB2ENR_TIM10EN      = 0x20000  // Bit TIM10EN.
	RCC_APB2ENR_TIM11EN_Pos  = 0x12     // Position of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Msk  = 0x40000  // Bit mask of TIM11EN field.
	RCC_APB2ENR_TIM11EN      = 0x40000  // Bit TIM11EN.
	RCC_APB2ENR_SAI1EN_Pos   = 0x16     // Position of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Msk   = 0x400000 // Bit mask of SAI1EN field.
	RCC_APB2ENR_SAI1EN       = 0x400000 // Bit SAI1EN.
	RCC_APB2ENR_SAI2EN_Pos   = 0x17     // Position of SAI2EN field.
	RCC_APB2ENR_SAI2EN_Msk   = 0x800000 // Bit mask of SAI2EN field.
	RCC_APB2ENR_SAI2EN       = 0x800000 // Bit SAI2EN.

	// AHB1LPENR: AHB1 peripheral clock enable in low power           mode register
	RCC_AHB1LPENR_GPIOALPEN_Pos     = 0x0        // Position of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Msk     = 0x1        // Bit mask of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN         = 0x1        // Bit GPIOALPEN.
	RCC_AHB1LPENR_GPIOBLPEN_Pos     = 0x1        // Position of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Msk     = 0x2        // Bit mask of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN         = 0x2        // Bit GPIOBLPEN.
	RCC_AHB1LPENR_GPIOCLPEN_Pos     = 0x2        // Position of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Msk     = 0x4        // Bit mask of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN         = 0x4        // Bit GPIOCLPEN.
	RCC_AHB1LPENR_GPIODLPEN_Pos     = 0x3        // Position of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Msk     = 0x8        // Bit mask of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN         = 0x8        // Bit GPIODLPEN.
	RCC_AHB1LPENR_GPIOELPEN_Pos     = 0x4        // Position of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Msk     = 0x10       // Bit mask of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN         = 0x10       // Bit GPIOELPEN.
	RCC_AHB1LPENR_GPIOFLPEN_Pos     = 0x5        // Position of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN_Msk     = 0x20       // Bit mask of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN         = 0x20       // Bit GPIOFLPEN.
	RCC_AHB1LPENR_GPIOGLPEN_Pos     = 0x6        // Position of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN_Msk     = 0x40       // Bit mask of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN         = 0x40       // Bit GPIOGLPEN.
	RCC_AHB1LPENR_GPIOHLPEN_Pos     = 0x7        // Position of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Msk     = 0x80       // Bit mask of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN         = 0x80       // Bit GPIOHLPEN.
	RCC_AHB1LPENR_CRCLPEN_Pos       = 0xc        // Position of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Msk       = 0x1000     // Bit mask of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN           = 0x1000     // Bit CRCLPEN.
	RCC_AHB1LPENR_FLITFLPEN_Pos     = 0xf        // Position of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Msk     = 0x8000     // Bit mask of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN         = 0x8000     // Bit FLITFLPEN.
	RCC_AHB1LPENR_SRAM1LPEN_Pos     = 0x10       // Position of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Msk     = 0x10000    // Bit mask of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN         = 0x10000    // Bit SRAM1LPEN.
	RCC_AHB1LPENR_SRAM2LPEN_Pos     = 0x11       // Position of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN_Msk     = 0x20000    // Bit mask of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN         = 0x20000    // Bit SRAM2LPEN.
	RCC_AHB1LPENR_BKPSRAMLPEN_Pos   = 0x12       // Position of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN_Msk   = 0x40000    // Bit mask of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN       = 0x40000    // Bit BKPSRAMLPEN.
	RCC_AHB1LPENR_DMA1LPEN_Pos      = 0x15       // Position of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Msk      = 0x200000   // Bit mask of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN          = 0x200000   // Bit DMA1LPEN.
	RCC_AHB1LPENR_DMA2LPEN_Pos      = 0x16       // Position of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Msk      = 0x400000   // Bit mask of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN          = 0x400000   // Bit DMA2LPEN.
	RCC_AHB1LPENR_OTGHSLPEN_Pos     = 0x1d       // Position of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN_Msk     = 0x20000000 // Bit mask of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN         = 0x20000000 // Bit OTGHSLPEN.
	RCC_AHB1LPENR_OTGHSULPILPEN_Pos = 0x1e       // Position of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN_Msk = 0x40000000 // Bit mask of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN     = 0x40000000 // Bit OTGHSULPILPEN.

	// AHB2LPENR: AHB2 peripheral clock enable in low power           mode register
	RCC_AHB2LPENR_OTGFSLPEN_Pos = 0x7  // Position of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Msk = 0x80 // Bit mask of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN     = 0x80 // Bit OTGFSLPEN.
	RCC_AHB2LPENR_DCMILPEN_Pos  = 0x0  // Position of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN_Msk  = 0x1  // Bit mask of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN      = 0x1  // Bit DCMILPEN.

	// AHB3LPENR: AHB3 peripheral clock enable in low power           mode register
	RCC_AHB3LPENR_FMCLPEN_Pos  = 0x0 // Position of FMCLPEN field.
	RCC_AHB3LPENR_FMCLPEN_Msk  = 0x1 // Bit mask of FMCLPEN field.
	RCC_AHB3LPENR_FMCLPEN      = 0x1 // Bit FMCLPEN.
	RCC_AHB3LPENR_QSPILPEN_Pos = 0x1 // Position of QSPILPEN field.
	RCC_AHB3LPENR_QSPILPEN_Msk = 0x2 // Bit mask of QSPILPEN field.
	RCC_AHB3LPENR_QSPILPEN     = 0x2 // Bit QSPILPEN.

	// APB1LPENR: APB1 peripheral clock enable in low power           mode register
	RCC_APB1LPENR_TIM2LPEN_Pos    = 0x0        // Position of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Msk    = 0x1        // Bit mask of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN        = 0x1        // Bit TIM2LPEN.
	RCC_APB1LPENR_TIM3LPEN_Pos    = 0x1        // Position of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Msk    = 0x2        // Bit mask of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN        = 0x2        // Bit TIM3LPEN.
	RCC_APB1LPENR_TIM4LPEN_Pos    = 0x2        // Position of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Msk    = 0x4        // Bit mask of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN        = 0x4        // Bit TIM4LPEN.
	RCC_APB1LPENR_TIM5LPEN_Pos    = 0x3        // Position of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Msk    = 0x8        // Bit mask of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN        = 0x8        // Bit TIM5LPEN.
	RCC_APB1LPENR_TIM6LPEN_Pos    = 0x4        // Position of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Msk    = 0x10       // Bit mask of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN        = 0x10       // Bit TIM6LPEN.
	RCC_APB1LPENR_TIM7LPEN_Pos    = 0x5        // Position of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Msk    = 0x20       // Bit mask of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN        = 0x20       // Bit TIM7LPEN.
	RCC_APB1LPENR_TIM12LPEN_Pos   = 0x6        // Position of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN_Msk   = 0x40       // Bit mask of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN       = 0x40       // Bit TIM12LPEN.
	RCC_APB1LPENR_TIM13LPEN_Pos   = 0x7        // Position of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN_Msk   = 0x80       // Bit mask of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN       = 0x80       // Bit TIM13LPEN.
	RCC_APB1LPENR_TIM14LPEN_Pos   = 0x8        // Position of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN_Msk   = 0x100      // Bit mask of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN       = 0x100      // Bit TIM14LPEN.
	RCC_APB1LPENR_WWDGLPEN_Pos    = 0xb        // Position of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Msk    = 0x800      // Bit mask of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN        = 0x800      // Bit WWDGLPEN.
	RCC_APB1LPENR_SPI2LPEN_Pos    = 0xe        // Position of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Msk    = 0x4000     // Bit mask of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN        = 0x4000     // Bit SPI2LPEN.
	RCC_APB1LPENR_SPI3LPEN_Pos    = 0xf        // Position of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Msk    = 0x8000     // Bit mask of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN        = 0x8000     // Bit SPI3LPEN.
	RCC_APB1LPENR_SPDIFLPEN_Pos   = 0x10       // Position of SPDIFLPEN field.
	RCC_APB1LPENR_SPDIFLPEN_Msk   = 0x10000    // Bit mask of SPDIFLPEN field.
	RCC_APB1LPENR_SPDIFLPEN       = 0x10000    // Bit SPDIFLPEN.
	RCC_APB1LPENR_USART2LPEN_Pos  = 0x11       // Position of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Msk  = 0x20000    // Bit mask of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN      = 0x20000    // Bit USART2LPEN.
	RCC_APB1LPENR_USART3LPEN_Pos  = 0x12       // Position of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Msk  = 0x40000    // Bit mask of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN      = 0x40000    // Bit USART3LPEN.
	RCC_APB1LPENR_UART4LPEN_Pos   = 0x13       // Position of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN_Msk   = 0x80000    // Bit mask of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN       = 0x80000    // Bit UART4LPEN.
	RCC_APB1LPENR_UART5LPEN_Pos   = 0x14       // Position of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN_Msk   = 0x100000   // Bit mask of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN       = 0x100000   // Bit UART5LPEN.
	RCC_APB1LPENR_I2C1LPEN_Pos    = 0x15       // Position of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Msk    = 0x200000   // Bit mask of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN        = 0x200000   // Bit I2C1LPEN.
	RCC_APB1LPENR_I2C2LPEN_Pos    = 0x16       // Position of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Msk    = 0x400000   // Bit mask of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN        = 0x400000   // Bit I2C2LPEN.
	RCC_APB1LPENR_I2C3LPEN_Pos    = 0x17       // Position of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Msk    = 0x800000   // Bit mask of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN        = 0x800000   // Bit I2C3LPEN.
	RCC_APB1LPENR_I2CFMP1LPEN_Pos = 0x18       // Position of I2CFMP1LPEN field.
	RCC_APB1LPENR_I2CFMP1LPEN_Msk = 0x1000000  // Bit mask of I2CFMP1LPEN field.
	RCC_APB1LPENR_I2CFMP1LPEN     = 0x1000000  // Bit I2CFMP1LPEN.
	RCC_APB1LPENR_CAN1LPEN_Pos    = 0x19       // Position of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN_Msk    = 0x2000000  // Bit mask of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN        = 0x2000000  // Bit CAN1LPEN.
	RCC_APB1LPENR_CAN2LPEN_Pos    = 0x1a       // Position of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN_Msk    = 0x4000000  // Bit mask of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN        = 0x4000000  // Bit CAN2LPEN.
	RCC_APB1LPENR_CECLPEN_Pos     = 0x1b       // Position of CECLPEN field.
	RCC_APB1LPENR_CECLPEN_Msk     = 0x8000000  // Bit mask of CECLPEN field.
	RCC_APB1LPENR_CECLPEN         = 0x8000000  // Bit CECLPEN.
	RCC_APB1LPENR_PWRLPEN_Pos     = 0x1c       // Position of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Msk     = 0x10000000 // Bit mask of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN         = 0x10000000 // Bit PWRLPEN.
	RCC_APB1LPENR_DACLPEN_Pos     = 0x1d       // Position of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Msk     = 0x20000000 // Bit mask of DACLPEN field.
	RCC_APB1LPENR_DACLPEN         = 0x20000000 // Bit DACLPEN.

	// APB2LPENR: APB2 peripheral clock enabled in low power           mode register
	RCC_APB2LPENR_TIM1LPEN_Pos   = 0x0      // Position of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Msk   = 0x1      // Bit mask of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN       = 0x1      // Bit TIM1LPEN.
	RCC_APB2LPENR_TIM8LPEN_Pos   = 0x1      // Position of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN_Msk   = 0x2      // Bit mask of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN       = 0x2      // Bit TIM8LPEN.
	RCC_APB2LPENR_USART1LPEN_Pos = 0x4      // Position of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Msk = 0x10     // Bit mask of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN     = 0x10     // Bit USART1LPEN.
	RCC_APB2LPENR_USART6LPEN_Pos = 0x5      // Position of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Msk = 0x20     // Bit mask of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN     = 0x20     // Bit USART6LPEN.
	RCC_APB2LPENR_ADC1LPEN_Pos   = 0x8      // Position of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Msk   = 0x100    // Bit mask of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN       = 0x100    // Bit ADC1LPEN.
	RCC_APB2LPENR_ADC2LPEN_Pos   = 0x9      // Position of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN_Msk   = 0x200    // Bit mask of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN       = 0x200    // Bit ADC2LPEN.
	RCC_APB2LPENR_ADC3LPEN_Pos   = 0xa      // Position of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN_Msk   = 0x400    // Bit mask of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN       = 0x400    // Bit ADC3LPEN.
	RCC_APB2LPENR_SDIOLPEN_Pos   = 0xb      // Position of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Msk   = 0x800    // Bit mask of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN       = 0x800    // Bit SDIOLPEN.
	RCC_APB2LPENR_SPI1LPEN_Pos   = 0xc      // Position of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Msk   = 0x1000   // Bit mask of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN       = 0x1000   // Bit SPI1LPEN.
	RCC_APB2LPENR_SPI4LPEN_Pos   = 0xd      // Position of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN_Msk   = 0x2000   // Bit mask of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN       = 0x2000   // Bit SPI4LPEN.
	RCC_APB2LPENR_SYSCFGLPEN_Pos = 0xe      // Position of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Msk = 0x4000   // Bit mask of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN     = 0x4000   // Bit SYSCFGLPEN.
	RCC_APB2LPENR_TIM9LPEN_Pos   = 0x10     // Position of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Msk   = 0x10000  // Bit mask of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN       = 0x10000  // Bit TIM9LPEN.
	RCC_APB2LPENR_TIM10LPEN_Pos  = 0x11     // Position of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Msk  = 0x20000  // Bit mask of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN      = 0x20000  // Bit TIM10LPEN.
	RCC_APB2LPENR_TIM11LPEN_Pos  = 0x12     // Position of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Msk  = 0x40000  // Bit mask of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN      = 0x40000  // Bit TIM11LPEN.
	RCC_APB2LPENR_SAI1LPEN_Pos   = 0x16     // Position of SAI1LPEN field.
	RCC_APB2LPENR_SAI1LPEN_Msk   = 0x400000 // Bit mask of SAI1LPEN field.
	RCC_APB2LPENR_SAI1LPEN       = 0x400000 // Bit SAI1LPEN.
	RCC_APB2LPENR_SAI2LPEN_Pos   = 0x17     // Position of SAI2LPEN field.
	RCC_APB2LPENR_SAI2LPEN_Msk   = 0x800000 // Bit mask of SAI2LPEN field.
	RCC_APB2LPENR_SAI2LPEN       = 0x800000 // Bit SAI2LPEN.

	// BDCR: Backup domain control register
	RCC_BDCR_BDRST_Pos  = 0x10    // Position of BDRST field.
	RCC_BDCR_BDRST_Msk  = 0x10000 // Bit mask of BDRST field.
	RCC_BDCR_BDRST      = 0x10000 // Bit BDRST.
	RCC_BDCR_RTCEN_Pos  = 0xf     // Position of RTCEN field.
	RCC_BDCR_RTCEN_Msk  = 0x8000  // Bit mask of RTCEN field.
	RCC_BDCR_RTCEN      = 0x8000  // Bit RTCEN.
	RCC_BDCR_RTCSEL_Pos = 0x8     // Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300   // Bit mask of RTCSEL field.
	RCC_BDCR_LSEMOD_Pos = 0x3     // Position of LSEMOD field.
	RCC_BDCR_LSEMOD_Msk = 0x8     // Bit mask of LSEMOD field.
	RCC_BDCR_LSEMOD     = 0x8     // Bit LSEMOD.
	RCC_BDCR_LSEBYP_Pos = 0x2     // Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4     // Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP     = 0x4     // Bit LSEBYP.
	RCC_BDCR_LSERDY_Pos = 0x1     // Position of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2     // Bit mask of LSERDY field.
	RCC_BDCR_LSERDY     = 0x2     // Bit LSERDY.
	RCC_BDCR_LSEON_Pos  = 0x0     // Position of LSEON field.
	RCC_BDCR_LSEON_Msk  = 0x1     // Bit mask of LSEON field.
	RCC_BDCR_LSEON      = 0x1     // Bit LSEON.

	// CSR: clock control & status           register
	RCC_CSR_LPWRRSTF_Pos = 0x1f       // Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000 // Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF     = 0x80000000 // Bit LPWRRSTF.
	RCC_CSR_WWDGRSTF_Pos = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF     = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_WDGRSTF_Pos  = 0x1d       // Position of WDGRSTF field.
	RCC_CSR_WDGRSTF_Msk  = 0x20000000 // Bit mask of WDGRSTF field.
	RCC_CSR_WDGRSTF      = 0x20000000 // Bit WDGRSTF.
	RCC_CSR_SFTRSTF_Pos  = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk  = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF      = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_PORRSTF_Pos  = 0x1b       // Position of PORRSTF field.
	RCC_CSR_PORRSTF_Msk  = 0x8000000  // Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF      = 0x8000000  // Bit PORRSTF.
	RCC_CSR_PADRSTF_Pos  = 0x1a       // Position of PADRSTF field.
	RCC_CSR_PADRSTF_Msk  = 0x4000000  // Bit mask of PADRSTF field.
	RCC_CSR_PADRSTF      = 0x4000000  // Bit PADRSTF.
	RCC_CSR_BORRSTF_Pos  = 0x19       // Position of BORRSTF field.
	RCC_CSR_BORRSTF_Msk  = 0x2000000  // Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF      = 0x2000000  // Bit BORRSTF.
	RCC_CSR_RMVF_Pos     = 0x18       // Position of RMVF field.
	RCC_CSR_RMVF_Msk     = 0x1000000  // Bit mask of RMVF field.
	RCC_CSR_RMVF         = 0x1000000  // Bit RMVF.
	RCC_CSR_LSIRDY_Pos   = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk   = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY       = 0x2        // Bit LSIRDY.
	RCC_CSR_LSION_Pos    = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk    = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION        = 0x1        // Bit LSION.

	// SSCGR: spread spectrum clock generation           register
	RCC_SSCGR_SSCGEN_Pos    = 0x1f       // Position of SSCGEN field.
	RCC_SSCGR_SSCGEN_Msk    = 0x80000000 // Bit mask of SSCGEN field.
	RCC_SSCGR_SSCGEN        = 0x80000000 // Bit SSCGEN.
	RCC_SSCGR_SPREADSEL_Pos = 0x1e       // Position of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Msk = 0x40000000 // Bit mask of SPREADSEL field.
	RCC_SSCGR_SPREADSEL     = 0x40000000 // Bit SPREADSEL.
	RCC_SSCGR_INCSTEP_Pos   = 0xd        // Position of INCSTEP field.
	RCC_SSCGR_INCSTEP_Msk   = 0xfffe000  // Bit mask of INCSTEP field.
	RCC_SSCGR_MODPER_Pos    = 0x0        // Position of MODPER field.
	RCC_SSCGR_MODPER_Msk    = 0x1fff     // Bit mask of MODPER field.

	// PLLI2SCFGR: PLLI2S configuration register
	RCC_PLLI2SCFGR_PLLI2SM_Pos = 0x0        // Position of PLLI2SM field.
	RCC_PLLI2SCFGR_PLLI2SM_Msk = 0x3f       // Bit mask of PLLI2SM field.
	RCC_PLLI2SCFGR_PLLI2SN_Pos = 0x6        // Position of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Msk = 0x7fc0     // Bit mask of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SP_Pos = 0x10       // Position of PLLI2SP field.
	RCC_PLLI2SCFGR_PLLI2SP_Msk = 0x30000    // Bit mask of PLLI2SP field.
	RCC_PLLI2SCFGR_PLLI2SQ_Pos = 0x18       // Position of PLLI2SQ field.
	RCC_PLLI2SCFGR_PLLI2SQ_Msk = 0xf000000  // Bit mask of PLLI2SQ field.
	RCC_PLLI2SCFGR_PLLI2SR_Pos = 0x1c       // Position of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Msk = 0x70000000 // Bit mask of PLLI2SR field.

	// PLLSAICFGR: PLL configuration register
	RCC_PLLSAICFGR_PLLSAIM_Pos = 0x0       // Position of PLLSAIM field.
	RCC_PLLSAICFGR_PLLSAIM_Msk = 0x3f      // Bit mask of PLLSAIM field.
	RCC_PLLSAICFGR_PLLSAIN_Pos = 0x6       // Position of PLLSAIN field.
	RCC_PLLSAICFGR_PLLSAIN_Msk = 0x7fc0    // Bit mask of PLLSAIN field.
	RCC_PLLSAICFGR_PLLSAIP_Pos = 0x10      // Position of PLLSAIP field.
	RCC_PLLSAICFGR_PLLSAIP_Msk = 0x30000   // Bit mask of PLLSAIP field.
	RCC_PLLSAICFGR_PLLSAIQ_Pos = 0x18      // Position of PLLSAIQ field.
	RCC_PLLSAICFGR_PLLSAIQ_Msk = 0xf000000 // Bit mask of PLLSAIQ field.

	// DCKCFGR: Dedicated Clock Configuration           Register
	RCC_DCKCFGR_PLLI2SDIVQ_Pos = 0x0        // Position of PLLI2SDIVQ field.
	RCC_DCKCFGR_PLLI2SDIVQ_Msk = 0x1f       // Bit mask of PLLI2SDIVQ field.
	RCC_DCKCFGR_PLLSAIDIVQ_Pos = 0x8        // Position of PLLSAIDIVQ field.
	RCC_DCKCFGR_PLLSAIDIVQ_Msk = 0x1f00     // Bit mask of PLLSAIDIVQ field.
	RCC_DCKCFGR_SAI1SRC_Pos    = 0x14       // Position of SAI1SRC field.
	RCC_DCKCFGR_SAI1SRC_Msk    = 0x300000   // Bit mask of SAI1SRC field.
	RCC_DCKCFGR_SAI2SRC_Pos    = 0x16       // Position of SAI2SRC field.
	RCC_DCKCFGR_SAI2SRC_Msk    = 0xc00000   // Bit mask of SAI2SRC field.
	RCC_DCKCFGR_TIMPRE_Pos     = 0x18       // Position of TIMPRE field.
	RCC_DCKCFGR_TIMPRE_Msk     = 0x1000000  // Bit mask of TIMPRE field.
	RCC_DCKCFGR_TIMPRE         = 0x1000000  // Bit TIMPRE.
	RCC_DCKCFGR_I2S1SRC_Pos    = 0x19       // Position of I2S1SRC field.
	RCC_DCKCFGR_I2S1SRC_Msk    = 0x6000000  // Bit mask of I2S1SRC field.
	RCC_DCKCFGR_I2S2SRC_Pos    = 0x1b       // Position of I2S2SRC field.
	RCC_DCKCFGR_I2S2SRC_Msk    = 0x18000000 // Bit mask of I2S2SRC field.

	// CKGATENR: clocks gated enable register
	RCC_CKGATENR_AHB2APB1_CKEN_Pos = 0x0  // Position of AHB2APB1_CKEN field.
	RCC_CKGATENR_AHB2APB1_CKEN_Msk = 0x1  // Bit mask of AHB2APB1_CKEN field.
	RCC_CKGATENR_AHB2APB1_CKEN     = 0x1  // Bit AHB2APB1_CKEN.
	RCC_CKGATENR_AHB2APB2_CKEN_Pos = 0x1  // Position of AHB2APB2_CKEN field.
	RCC_CKGATENR_AHB2APB2_CKEN_Msk = 0x2  // Bit mask of AHB2APB2_CKEN field.
	RCC_CKGATENR_AHB2APB2_CKEN     = 0x2  // Bit AHB2APB2_CKEN.
	RCC_CKGATENR_CM4DBG_CKEN_Pos   = 0x2  // Position of CM4DBG_CKEN field.
	RCC_CKGATENR_CM4DBG_CKEN_Msk   = 0x4  // Bit mask of CM4DBG_CKEN field.
	RCC_CKGATENR_CM4DBG_CKEN       = 0x4  // Bit CM4DBG_CKEN.
	RCC_CKGATENR_SPARE_CKEN_Pos    = 0x3  // Position of SPARE_CKEN field.
	RCC_CKGATENR_SPARE_CKEN_Msk    = 0x8  // Bit mask of SPARE_CKEN field.
	RCC_CKGATENR_SPARE_CKEN        = 0x8  // Bit SPARE_CKEN.
	RCC_CKGATENR_SRAM_CKEN_Pos     = 0x4  // Position of SRAM_CKEN field.
	RCC_CKGATENR_SRAM_CKEN_Msk     = 0x10 // Bit mask of SRAM_CKEN field.
	RCC_CKGATENR_SRAM_CKEN         = 0x10 // Bit SRAM_CKEN.
	RCC_CKGATENR_FLITF_CKEN_Pos    = 0x5  // Position of FLITF_CKEN field.
	RCC_CKGATENR_FLITF_CKEN_Msk    = 0x20 // Bit mask of FLITF_CKEN field.
	RCC_CKGATENR_FLITF_CKEN        = 0x20 // Bit FLITF_CKEN.
	RCC_CKGATENR_RCC_CKEN_Pos      = 0x6  // Position of RCC_CKEN field.
	RCC_CKGATENR_RCC_CKEN_Msk      = 0x40 // Bit mask of RCC_CKEN field.
	RCC_CKGATENR_RCC_CKEN          = 0x40 // Bit RCC_CKEN.

	// DCKCFGR2: dedicated clocks configuration register           2
	RCC_DCKCFGR2_FMPI2C1SEL_Pos = 0x16       // Position of FMPI2C1SEL field.
	RCC_DCKCFGR2_FMPI2C1SEL_Msk = 0xc00000   // Bit mask of FMPI2C1SEL field.
	RCC_DCKCFGR2_CECSEL_Pos     = 0x1a       // Position of CECSEL field.
	RCC_DCKCFGR2_CECSEL_Msk     = 0x4000000  // Bit mask of CECSEL field.
	RCC_DCKCFGR2_CECSEL         = 0x4000000  // Bit CECSEL.
	RCC_DCKCFGR2_CK48MSEL_Pos   = 0x1b       // Position of CK48MSEL field.
	RCC_DCKCFGR2_CK48MSEL_Msk   = 0x8000000  // Bit mask of CK48MSEL field.
	RCC_DCKCFGR2_CK48MSEL       = 0x8000000  // Bit CK48MSEL.
	RCC_DCKCFGR2_SDIOSEL_Pos    = 0x1c       // Position of SDIOSEL field.
	RCC_DCKCFGR2_SDIOSEL_Msk    = 0x10000000 // Bit mask of SDIOSEL field.
	RCC_DCKCFGR2_SDIOSEL        = 0x10000000 // Bit SDIOSEL.
	RCC_DCKCFGR2_SPDIFSEL_Pos   = 0x1d       // Position of SPDIFSEL field.
	RCC_DCKCFGR2_SPDIFSEL_Msk   = 0x20000000 // Bit mask of SPDIFSEL field.
	RCC_DCKCFGR2_SPDIFSEL       = 0x20000000 // Bit SPDIFSEL.
)

// Bitfields for GPIOH: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	GPIO_MODER_MODER15_Pos = 0x1e       // Position of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000 // Bit mask of MODER15 field.
	GPIO_MODER_MODER14_Pos = 0x1c       // Position of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000 // Bit mask of MODER14 field.
	GPIO_MODER_MODER13_Pos = 0x1a       // Position of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000  // Bit mask of MODER13 field.
	GPIO_MODER_MODER12_Pos = 0x18       // Position of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000  // Bit mask of MODER12 field.
	GPIO_MODER_MODER11_Pos = 0x16       // Position of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000   // Bit mask of MODER11 field.
	GPIO_MODER_MODER10_Pos = 0x14       // Position of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000   // Bit mask of MODER10 field.
	GPIO_MODER_MODER9_Pos  = 0x12       // Position of MODER9 field.
	GPIO_MODER_MODER9_Msk  = 0xc0000    // Bit mask of MODER9 field.
	GPIO_MODER_MODER8_Pos  = 0x10       // Position of MODER8 field.
	GPIO_MODER_MODER8_Msk  = 0x30000    // Bit mask of MODER8 field.
	GPIO_MODER_MODER7_Pos  = 0xe        // Position of MODER7 field.
	GPIO_MODER_MODER7_Msk  = 0xc000     // Bit mask of MODER7 field.
	GPIO_MODER_MODER6_Pos  = 0xc        // Position of MODER6 field.
	GPIO_MODER_MODER6_Msk  = 0x3000     // Bit mask of MODER6 field.
	GPIO_MODER_MODER5_Pos  = 0xa        // Position of MODER5 field.
	GPIO_MODER_MODER5_Msk  = 0xc00      // Bit mask of MODER5 field.
	GPIO_MODER_MODER4_Pos  = 0x8        // Position of MODER4 field.
	GPIO_MODER_MODER4_Msk  = 0x300      // Bit mask of MODER4 field.
	GPIO_MODER_MODER3_Pos  = 0x6        // Position of MODER3 field.
	GPIO_MODER_MODER3_Msk  = 0xc0       // Bit mask of MODER3 field.
	GPIO_MODER_MODER2_Pos  = 0x4        // Position of MODER2 field.
	GPIO_MODER_MODER2_Msk  = 0x30       // Bit mask of MODER2 field.
	GPIO_MODER_MODER1_Pos  = 0x2        // Position of MODER1 field.
	GPIO_MODER_MODER1_Msk  = 0xc        // Bit mask of MODER1 field.
	GPIO_MODER_MODER0_Pos  = 0x0        // Position of MODER0 field.
	GPIO_MODER_MODER0_Msk  = 0x3        // Bit mask of MODER0 field.

	// OTYPER: GPIO port output type register
	GPIO_OTYPER_OT15_Pos = 0xf    // Position of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000 // Bit mask of OT15 field.
	GPIO_OTYPER_OT15     = 0x8000 // Bit OT15.
	GPIO_OTYPER_OT14_Pos = 0xe    // Position of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000 // Bit mask of OT14 field.
	GPIO_OTYPER_OT14     = 0x4000 // Bit OT14.
	GPIO_OTYPER_OT13_Pos = 0xd    // Position of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000 // Bit mask of OT13 field.
	GPIO_OTYPER_OT13     = 0x2000 // Bit OT13.
	GPIO_OTYPER_OT12_Pos = 0xc    // Position of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000 // Bit mask of OT12 field.
	GPIO_OTYPER_OT12     = 0x1000 // Bit OT12.
	GPIO_OTYPER_OT11_Pos = 0xb    // Position of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800  // Bit mask of OT11 field.
	GPIO_OTYPER_OT11     = 0x800  // Bit OT11.
	GPIO_OTYPER_OT10_Pos = 0xa    // Position of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400  // Bit mask of OT10 field.
	GPIO_OTYPER_OT10     = 0x400  // Bit OT10.
	GPIO_OTYPER_OT9_Pos  = 0x9    // Position of OT9 field.
	GPIO_OTYPER_OT9_Msk  = 0x200  // Bit mask of OT9 field.
	GPIO_OTYPER_OT9      = 0x200  // Bit OT9.
	GPIO_OTYPER_OT8_Pos  = 0x8    // Position of OT8 field.
	GPIO_OTYPER_OT8_Msk  = 0x100  // Bit mask of OT8 field.
	GPIO_OTYPER_OT8      = 0x100  // Bit OT8.
	GPIO_OTYPER_OT7_Pos  = 0x7    // Position of OT7 field.
	GPIO_OTYPER_OT7_Msk  = 0x80   // Bit mask of OT7 field.
	GPIO_OTYPER_OT7      = 0x80   // Bit OT7.
	GPIO_OTYPER_OT6_Pos  = 0x6    // Position of OT6 field.
	GPIO_OTYPER_OT6_Msk  = 0x40   // Bit mask of OT6 field.
	GPIO_OTYPER_OT6      = 0x40   // Bit OT6.
	GPIO_OTYPER_OT5_Pos  = 0x5    // Position of OT5 field.
	GPIO_OTYPER_OT5_Msk  = 0x20   // Bit mask of OT5 field.
	GPIO_OTYPER_OT5      = 0x20   // Bit OT5.
	GPIO_OTYPER_OT4_Pos  = 0x4    // Position of OT4 field.
	GPIO_OTYPER_OT4_Msk  = 0x10   // Bit mask of OT4 field.
	GPIO_OTYPER_OT4      = 0x10   // Bit OT4.
	GPIO_OTYPER_OT3_Pos  = 0x3    // Position of OT3 field.
	GPIO_OTYPER_OT3_Msk  = 0x8    // Bit mask of OT3 field.
	GPIO_OTYPER_OT3      = 0x8    // Bit OT3.
	GPIO_OTYPER_OT2_Pos  = 0x2    // Position of OT2 field.
	GPIO_OTYPER_OT2_Msk  = 0x4    // Bit mask of OT2 field.
	GPIO_OTYPER_OT2      = 0x4    // Bit OT2.
	GPIO_OTYPER_OT1_Pos  = 0x1    // Position of OT1 field.
	GPIO_OTYPER_OT1_Msk  = 0x2    // Bit mask of OT1 field.
	GPIO_OTYPER_OT1      = 0x2    // Bit OT1.
	GPIO_OTYPER_OT0_Pos  = 0x0    // Position of OT0 field.
	GPIO_OTYPER_OT0_Msk  = 0x1    // Bit mask of OT0 field.
	GPIO_OTYPER_OT0      = 0x1    // Bit OT0.

	// OSPEEDR: GPIO port output speed           register
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e       // Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000 // Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c       // Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000 // Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a       // Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000  // Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18       // Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000  // Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16       // Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000   // Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14       // Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000   // Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos  = 0x12       // Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk  = 0xc0000    // Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos  = 0x10       // Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk  = 0x30000    // Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos  = 0xe        // Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk  = 0xc000     // Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos  = 0xc        // Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk  = 0x3000     // Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos  = 0xa        // Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk  = 0xc00      // Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos  = 0x8        // Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk  = 0x300      // Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos  = 0x6        // Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk  = 0xc0       // Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos  = 0x4        // Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk  = 0x30       // Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos  = 0x2        // Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk  = 0xc        // Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos  = 0x0        // Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk  = 0x3        // Bit mask of OSPEEDR0 field.

	// PUPDR: GPIO port pull-up/pull-down           register
	GPIO_PUPDR_PUPDR15_Pos = 0x1e       // Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000 // Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c       // Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000 // Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a       // Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000  // Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18       // Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000  // Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16       // Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000   // Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14       // Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000   // Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR9_Pos  = 0x12       // Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk  = 0xc0000    // Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR8_Pos  = 0x10       // Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk  = 0x30000    // Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR7_Pos  = 0xe        // Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk  = 0xc000     // Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR6_Pos  = 0xc        // Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk  = 0x3000     // Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR5_Pos  = 0xa        // Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk  = 0xc00      // Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR4_Pos  = 0x8        // Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk  = 0x300      // Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR3_Pos  = 0x6        // Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk  = 0xc0       // Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR2_Pos  = 0x4        // Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk  = 0x30       // Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR1_Pos  = 0x2        // Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk  = 0xc        // Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR0_Pos  = 0x0        // Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk  = 0x3        // Bit mask of PUPDR0 field.

	// IDR: GPIO port input data register
	GPIO_IDR_IDR15_Pos = 0xf    // Position of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000 // Bit mask of IDR15 field.
	GPIO_IDR_IDR15     = 0x8000 // Bit IDR15.
	GPIO_IDR_IDR14_Pos = 0xe    // Position of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000 // Bit mask of IDR14 field.
	GPIO_IDR_IDR14     = 0x4000 // Bit IDR14.
	GPIO_IDR_IDR13_Pos = 0xd    // Position of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000 // Bit mask of IDR13 field.
	GPIO_IDR_IDR13     = 0x2000 // Bit IDR13.
	GPIO_IDR_IDR12_Pos = 0xc    // Position of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000 // Bit mask of IDR12 field.
	GPIO_IDR_IDR12     = 0x1000 // Bit IDR12.
	GPIO_IDR_IDR11_Pos = 0xb    // Position of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800  // Bit mask of IDR11 field.
	GPIO_IDR_IDR11     = 0x800  // Bit IDR11.
	GPIO_IDR_IDR10_Pos = 0xa    // Position of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400  // Bit mask of IDR10 field.
	GPIO_IDR_IDR10     = 0x400  // Bit IDR10.
	GPIO_IDR_IDR9_Pos  = 0x9    // Position of IDR9 field.
	GPIO_IDR_IDR9_Msk  = 0x200  // Bit mask of IDR9 field.
	GPIO_IDR_IDR9      = 0x200  // Bit IDR9.
	GPIO_IDR_IDR8_Pos  = 0x8    // Position of IDR8 field.
	GPIO_IDR_IDR8_Msk  = 0x100  // Bit mask of IDR8 field.
	GPIO_IDR_IDR8      = 0x100  // Bit IDR8.
	GPIO_IDR_IDR7_Pos  = 0x7    // Position of IDR7 field.
	GPIO_IDR_IDR7_Msk  = 0x80   // Bit mask of IDR7 field.
	GPIO_IDR_IDR7      = 0x80   // Bit IDR7.
	GPIO_IDR_IDR6_Pos  = 0x6    // Position of IDR6 field.
	GPIO_IDR_IDR6_Msk  = 0x40   // Bit mask of IDR6 field.
	GPIO_IDR_IDR6      = 0x40   // Bit IDR6.
	GPIO_IDR_IDR5_Pos  = 0x5    // Position of IDR5 field.
	GPIO_IDR_IDR5_Msk  = 0x20   // Bit mask of IDR5 field.
	GPIO_IDR_IDR5      = 0x20   // Bit IDR5.
	GPIO_IDR_IDR4_Pos  = 0x4    // Position of IDR4 field.
	GPIO_IDR_IDR4_Msk  = 0x10   // Bit mask of IDR4 field.
	GPIO_IDR_IDR4      = 0x10   // Bit IDR4.
	GPIO_IDR_IDR3_Pos  = 0x3    // Position of IDR3 field.
	GPIO_IDR_IDR3_Msk  = 0x8    // Bit mask of IDR3 field.
	GPIO_IDR_IDR3      = 0x8    // Bit IDR3.
	GPIO_IDR_IDR2_Pos  = 0x2    // Position of IDR2 field.
	GPIO_IDR_IDR2_Msk  = 0x4    // Bit mask of IDR2 field.
	GPIO_IDR_IDR2      = 0x4    // Bit IDR2.
	GPIO_IDR_IDR1_Pos  = 0x1    // Position of IDR1 field.
	GPIO_IDR_IDR1_Msk  = 0x2    // Bit mask of IDR1 field.
	GPIO_IDR_IDR1      = 0x2    // Bit IDR1.
	GPIO_IDR_IDR0_Pos  = 0x0    // Position of IDR0 field.
	GPIO_IDR_IDR0_Msk  = 0x1    // Bit mask of IDR0 field.
	GPIO_IDR_IDR0      = 0x1    // Bit IDR0.

	// ODR: GPIO port output data register
	GPIO_ODR_ODR15_Pos = 0xf    // Position of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000 // Bit mask of ODR15 field.
	GPIO_ODR_ODR15     = 0x8000 // Bit ODR15.
	GPIO_ODR_ODR14_Pos = 0xe    // Position of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000 // Bit mask of ODR14 field.
	GPIO_ODR_ODR14     = 0x4000 // Bit ODR14.
	GPIO_ODR_ODR13_Pos = 0xd    // Position of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000 // Bit mask of ODR13 field.
	GPIO_ODR_ODR13     = 0x2000 // Bit ODR13.
	GPIO_ODR_ODR12_Pos = 0xc    // Position of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000 // Bit mask of ODR12 field.
	GPIO_ODR_ODR12     = 0x1000 // Bit ODR12.
	GPIO_ODR_ODR11_Pos = 0xb    // Position of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800  // Bit mask of ODR11 field.
	GPIO_ODR_ODR11     = 0x800  // Bit ODR11.
	GPIO_ODR_ODR10_Pos = 0xa    // Position of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400  // Bit mask of ODR10 field.
	GPIO_ODR_ODR10     = 0x400  // Bit ODR10.
	GPIO_ODR_ODR9_Pos  = 0x9    // Position of ODR9 field.
	GPIO_ODR_ODR9_Msk  = 0x200  // Bit mask of ODR9 field.
	GPIO_ODR_ODR9      = 0x200  // Bit ODR9.
	GPIO_ODR_ODR8_Pos  = 0x8    // Position of ODR8 field.
	GPIO_ODR_ODR8_Msk  = 0x100  // Bit mask of ODR8 field.
	GPIO_ODR_ODR8      = 0x100  // Bit ODR8.
	GPIO_ODR_ODR7_Pos  = 0x7    // Position of ODR7 field.
	GPIO_ODR_ODR7_Msk  = 0x80   // Bit mask of ODR7 field.
	GPIO_ODR_ODR7      = 0x80   // Bit ODR7.
	GPIO_ODR_ODR6_Pos  = 0x6    // Position of ODR6 field.
	GPIO_ODR_ODR6_Msk  = 0x40   // Bit mask of ODR6 field.
	GPIO_ODR_ODR6      = 0x40   // Bit ODR6.
	GPIO_ODR_ODR5_Pos  = 0x5    // Position of ODR5 field.
	GPIO_ODR_ODR5_Msk  = 0x20   // Bit mask of ODR5 field.
	GPIO_ODR_ODR5      = 0x20   // Bit ODR5.
	GPIO_ODR_ODR4_Pos  = 0x4    // Position of ODR4 field.
	GPIO_ODR_ODR4_Msk  = 0x10   // Bit mask of ODR4 field.
	GPIO_ODR_ODR4      = 0x10   // Bit ODR4.
	GPIO_ODR_ODR3_Pos  = 0x3    // Position of ODR3 field.
	GPIO_ODR_ODR3_Msk  = 0x8    // Bit mask of ODR3 field.
	GPIO_ODR_ODR3      = 0x8    // Bit ODR3.
	GPIO_ODR_ODR2_Pos  = 0x2    // Position of ODR2 field.
	GPIO_ODR_ODR2_Msk  = 0x4    // Bit mask of ODR2 field.
	GPIO_ODR_ODR2      = 0x4    // Bit ODR2.
	GPIO_ODR_ODR1_Pos  = 0x1    // Position of ODR1 field.
	GPIO_ODR_ODR1_Msk  = 0x2    // Bit mask of ODR1 field.
	GPIO_ODR_ODR1      = 0x2    // Bit ODR1.
	GPIO_ODR_ODR0_Pos  = 0x0    // Position of ODR0 field.
	GPIO_ODR_ODR0_Msk  = 0x1    // Bit mask of ODR0 field.
	GPIO_ODR_ODR0      = 0x1    // Bit ODR0.

	// BSRR: GPIO port bit set/reset           register
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.

	// LCKR: GPIO port configuration lock           register
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.

	// AFRL: GPIO alternate function low           register
	GPIO_AFRL_AFRL7_Pos = 0x1c       // Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000 // Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL6_Pos = 0x18       // Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000  // Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL5_Pos = 0x14       // Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000   // Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL4_Pos = 0x10       // Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000    // Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL3_Pos = 0xc        // Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000     // Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL2_Pos = 0x8        // Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00      // Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL1_Pos = 0x4        // Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0       // Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL0_Pos = 0x0        // Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf        // Bit mask of AFRL0 field.

	// AFRH: GPIO alternate function high           register
	GPIO_AFRH_AFRH15_Pos = 0x1c       // Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000 // Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH14_Pos = 0x18       // Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000  // Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH13_Pos = 0x14       // Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000   // Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH12_Pos = 0x10       // Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000    // Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH11_Pos = 0xc        // Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000     // Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH10_Pos = 0x8        // Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00      // Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH9_Pos  = 0x4        // Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk  = 0xf0       // Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH8_Pos  = 0x0        // Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk  = 0xf        // Bit mask of AFRH8 field.
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRM: memory remap register
	SYSCFG_MEMRM_MEM_MODE_Pos = 0x0   // Position of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Msk = 0x7   // Bit mask of MEM_MODE field.
	SYSCFG_MEMRM_FB_MODE_Pos  = 0x8   // Position of FB_MODE field.
	SYSCFG_MEMRM_FB_MODE_Msk  = 0x100 // Bit mask of FB_MODE field.
	SYSCFG_MEMRM_FB_MODE      = 0x100 // Bit FB_MODE.
	SYSCFG_MEMRM_SWP_FMC_Pos  = 0xa   // Position of SWP_FMC field.
	SYSCFG_MEMRM_SWP_FMC_Msk  = 0xc00 // Bit mask of SWP_FMC field.

	// PMC: peripheral mode configuration           register
	SYSCFG_PMC_MII_RMII_SEL_Pos = 0x17     // Position of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL_Msk = 0x800000 // Bit mask of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL     = 0x800000 // Bit MII_RMII_SEL.
	SYSCFG_PMC_ADC1DC2_Pos      = 0x10     // Position of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2_Msk      = 0x10000  // Bit mask of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2          = 0x10000  // Bit ADC1DC2.
	SYSCFG_PMC_ADC2DC2_Pos      = 0x11     // Position of ADC2DC2 field.
	SYSCFG_PMC_ADC2DC2_Msk      = 0x20000  // Bit mask of ADC2DC2 field.
	SYSCFG_PMC_ADC2DC2          = 0x20000  // Bit ADC2DC2.
	SYSCFG_PMC_ADC3DC2_Pos      = 0x12     // Position of ADC3DC2 field.
	SYSCFG_PMC_ADC3DC2_Msk      = 0x40000  // Bit mask of ADC3DC2 field.
	SYSCFG_PMC_ADC3DC2          = 0x40000  // Bit ADC3DC2.

	// EXTICR1: external interrupt configuration register           1
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc    // Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000 // Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8    // Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00  // Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4    // Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0   // Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0    // Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf    // Bit mask of EXTI0 field.

	// EXTICR2: external interrupt configuration register           2
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc    // Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000 // Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8    // Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00  // Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4    // Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0   // Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0    // Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf    // Bit mask of EXTI4 field.

	// EXTICR3: external interrupt configuration register           3
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc    // Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000 // Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8    // Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00  // Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI9_Pos  = 0x4    // Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk  = 0xf0   // Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI8_Pos  = 0x0    // Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk  = 0xf    // Bit mask of EXTI8 field.

	// EXTICR4: external interrupt configuration register           4
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc    // Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000 // Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8    // Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00  // Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4    // Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0   // Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0    // Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf    // Bit mask of EXTI12 field.

	// CMPCR: Compensation cell control           register
	SYSCFG_CMPCR_READY_Pos  = 0x8   // Position of READY field.
	SYSCFG_CMPCR_READY_Msk  = 0x100 // Bit mask of READY field.
	SYSCFG_CMPCR_READY      = 0x100 // Bit READY.
	SYSCFG_CMPCR_CMP_PD_Pos = 0x0   // Position of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Msk = 0x1   // Bit mask of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD     = 0x1   // Bit CMP_PD.
)

// Bitfields for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_DFF_Pos      = 0xb    // Position of DFF field.
	SPI_CR1_DFF_Msk      = 0x800  // Bit mask of DFF field.
	SPI_CR1_DFF          = 0x800  // Bit DFF.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_TXEIE_Pos   = 0x7  // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80 // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80 // Bit TXEIE.
	SPI_CR2_RXNEIE_Pos  = 0x6  // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40 // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40 // Bit RXNEIE.
	SPI_CR2_ERRIE_Pos   = 0x5  // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20 // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20 // Bit ERRIE.
	SPI_CR2_FRF_Pos     = 0x4  // Position of FRF field.
	SPI_CR2_FRF_Msk     = 0x10 // Bit mask of FRF field.
	SPI_CR2_FRF         = 0x10 // Bit FRF.
	SPI_CR2_SSOE_Pos    = 0x2  // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4  // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4  // Bit SSOE.
	SPI_CR2_TXDMAEN_Pos = 0x1  // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2  // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2  // Bit TXDMAEN.
	SPI_CR2_RXDMAEN_Pos = 0x0  // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1  // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1  // Bit RXDMAEN.

	// SR: status register
	SPI_SR_TIFRFE_Pos = 0x8   // Position of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100 // Bit mask of TIFRFE field.
	SPI_SR_TIFRFE     = 0x100 // Bit TIFRFE.
	SPI_SR_BSY_Pos    = 0x7   // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80  // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80  // Bit BSY.
	SPI_SR_OVR_Pos    = 0x6   // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40  // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40  // Bit OVR.
	SPI_SR_MODF_Pos   = 0x5   // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20  // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20  // Bit MODF.
	SPI_SR_CRCERR_Pos = 0x4   // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10  // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10  // Bit CRCERR.
	SPI_SR_UDR_Pos    = 0x3   // Position of UDR field.
	SPI_SR_UDR_Msk    = 0x8   // Bit mask of UDR field.
	SPI_SR_UDR        = 0x8   // Bit UDR.
	SPI_SR_CHSIDE_Pos = 0x2   // Position of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4   // Bit mask of CHSIDE field.
	SPI_SR_CHSIDE     = 0x4   // Bit CHSIDE.
	SPI_SR_TXE_Pos    = 0x1   // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2   // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2   // Bit TXE.
	SPI_SR_RXNE_Pos   = 0x0   // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1   // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1   // Bit RXNE.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.

	// I2SCFGR: I2S configuration register
	SPI_I2SCFGR_I2SMOD_Pos  = 0xb   // Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk  = 0x800 // Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD      = 0x800 // Bit I2SMOD.
	SPI_I2SCFGR_I2SE_Pos    = 0xa   // Position of I2SE field.
	SPI_I2SCFGR_I2SE_Msk    = 0x400 // Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE        = 0x400 // Bit I2SE.
	SPI_I2SCFGR_I2SCFG_Pos  = 0x8   // Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk  = 0x300 // Bit mask of I2SCFG field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7   // Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80  // Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC     = 0x80  // Bit PCMSYNC.
	SPI_I2SCFGR_I2SSTD_Pos  = 0x4   // Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk  = 0x30  // Bit mask of I2SSTD field.
	SPI_I2SCFGR_CKPOL_Pos   = 0x3   // Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk   = 0x8   // Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL       = 0x8   // Bit CKPOL.
	SPI_I2SCFGR_DATLEN_Pos  = 0x1   // Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk  = 0x6   // Bit mask of DATLEN field.
	SPI_I2SCFGR_CHLEN_Pos   = 0x0   // Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk   = 0x1   // Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN       = 0x1   // Bit CHLEN.

	// I2SPR: I2S prescaler register
	SPI_I2SPR_MCKOE_Pos  = 0x9   // Position of MCKOE field.
	SPI_I2SPR_MCKOE_Msk  = 0x200 // Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE      = 0x200 // Bit MCKOE.
	SPI_I2SPR_ODD_Pos    = 0x8   // Position of ODD field.
	SPI_I2SPR_ODD_Msk    = 0x100 // Bit mask of ODD field.
	SPI_I2SPR_ODD        = 0x100 // Bit ODD.
	SPI_I2SPR_I2SDIV_Pos = 0x0   // Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff  // Bit mask of I2SDIV field.
)

// Bitfields for ADC1: Analog-to-digital converter
const (
	// SR: status register
	ADC_SR_OVR_Pos   = 0x5  // Position of OVR field.
	ADC_SR_OVR_Msk   = 0x20 // Bit mask of OVR field.
	ADC_SR_OVR       = 0x20 // Bit OVR.
	ADC_SR_STRT_Pos  = 0x4  // Position of STRT field.
	ADC_SR_STRT_Msk  = 0x10 // Bit mask of STRT field.
	ADC_SR_STRT      = 0x10 // Bit STRT.
	ADC_SR_JSTRT_Pos = 0x3  // Position of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8  // Bit mask of JSTRT field.
	ADC_SR_JSTRT     = 0x8  // Bit JSTRT.
	ADC_SR_JEOC_Pos  = 0x2  // Position of JEOC field.
	ADC_SR_JEOC_Msk  = 0x4  // Bit mask of JEOC field.
	ADC_SR_JEOC      = 0x4  // Bit JEOC.
	ADC_SR_EOC_Pos   = 0x1  // Position of EOC field.
	ADC_SR_EOC_Msk   = 0x2  // Bit mask of EOC field.
	ADC_SR_EOC       = 0x2  // Bit EOC.
	ADC_SR_AWD_Pos   = 0x0  // Position of AWD field.
	ADC_SR_AWD_Msk   = 0x1  // Bit mask of AWD field.
	ADC_SR_AWD       = 0x1  // Bit AWD.

	// CR1: control register 1
	ADC_CR1_OVRIE_Pos   = 0x1a      // Position of OVRIE field.
	ADC_CR1_OVRIE_Msk   = 0x4000000 // Bit mask of OVRIE field.
	ADC_CR1_OVRIE       = 0x4000000 // Bit OVRIE.
	ADC_CR1_RES_Pos     = 0x18      // Position of RES field.
	ADC_CR1_RES_Msk     = 0x3000000 // Bit mask of RES field.
	ADC_CR1_AWDEN_Pos   = 0x17      // Position of AWDEN field.
	ADC_CR1_AWDEN_Msk   = 0x800000  // Bit mask of AWDEN field.
	ADC_CR1_AWDEN       = 0x800000  // Bit AWDEN.
	ADC_CR1_JAWDEN_Pos  = 0x16      // Position of JAWDEN field.
	ADC_CR1_JAWDEN_Msk  = 0x400000  // Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN      = 0x400000  // Bit JAWDEN.
	ADC_CR1_DISCNUM_Pos = 0xd       // Position of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000    // Bit mask of DISCNUM field.
	ADC_CR1_JDISCEN_Pos = 0xc       // Position of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000    // Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN     = 0x1000    // Bit JDISCEN.
	ADC_CR1_DISCEN_Pos  = 0xb       // Position of DISCEN field.
	ADC_CR1_DISCEN_Msk  = 0x800     // Bit mask of DISCEN field.
	ADC_CR1_DISCEN      = 0x800     // Bit DISCEN.
	ADC_CR1_JAUTO_Pos   = 0xa       // Position of JAUTO field.
	ADC_CR1_JAUTO_Msk   = 0x400     // Bit mask of JAUTO field.
	ADC_CR1_JAUTO       = 0x400     // Bit JAUTO.
	ADC_CR1_AWDSGL_Pos  = 0x9       // Position of AWDSGL field.
	ADC_CR1_AWDSGL_Msk  = 0x200     // Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL      = 0x200     // Bit AWDSGL.
	ADC_CR1_SCAN_Pos    = 0x8       // Position of SCAN field.
	ADC_CR1_SCAN_Msk    = 0x100     // Bit mask of SCAN field.
	ADC_CR1_SCAN        = 0x100     // Bit SCAN.
	ADC_CR1_JEOCIE_Pos  = 0x7       // Position of JEOCIE field.
	ADC_CR1_JEOCIE_Msk  = 0x80      // Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE      = 0x80      // Bit JEOCIE.
	ADC_CR1_AWDIE_Pos   = 0x6       // Position of AWDIE field.
	ADC_CR1_AWDIE_Msk   = 0x40      // Bit mask of AWDIE field.
	ADC_CR1_AWDIE       = 0x40      // Bit AWDIE.
	ADC_CR1_EOCIE_Pos   = 0x5       // Position of EOCIE field.
	ADC_CR1_EOCIE_Msk   = 0x20      // Bit mask of EOCIE field.
	ADC_CR1_EOCIE       = 0x20      // Bit EOCIE.
	ADC_CR1_AWDCH_Pos   = 0x0       // Position of AWDCH field.
	ADC_CR1_AWDCH_Msk   = 0x1f      // Bit mask of AWDCH field.

	// CR2: control register 2
	ADC_CR2_SWSTART_Pos  = 0x1e       // Position of SWSTART field.
	ADC_CR2_SWSTART_Msk  = 0x40000000 // Bit mask of SWSTART field.
	ADC_CR2_SWSTART      = 0x40000000 // Bit SWSTART.
	ADC_CR2_EXTEN_Pos    = 0x1c       // Position of EXTEN field.
	ADC_CR2_EXTEN_Msk    = 0x30000000 // Bit mask of EXTEN field.
	ADC_CR2_EXTSEL_Pos   = 0x18       // Position of EXTSEL field.
	ADC_CR2_EXTSEL_Msk   = 0xf000000  // Bit mask of EXTSEL field.
	ADC_CR2_JSWSTART_Pos = 0x16       // Position of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x400000   // Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART     = 0x400000   // Bit JSWSTART.
	ADC_CR2_JEXTEN_Pos   = 0x14       // Position of JEXTEN field.
	ADC_CR2_JEXTEN_Msk   = 0x300000   // Bit mask of JEXTEN field.
	ADC_CR2_JEXTSEL_Pos  = 0x10       // Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk  = 0xf0000    // Bit mask of JEXTSEL field.
	ADC_CR2_ALIGN_Pos    = 0xb        // Position of ALIGN field.
	ADC_CR2_ALIGN_Msk    = 0x800      // Bit mask of ALIGN field.
	ADC_CR2_ALIGN        = 0x800      // Bit ALIGN.
	ADC_CR2_EOCS_Pos     = 0xa        // Position of EOCS field.
	ADC_CR2_EOCS_Msk     = 0x400      // Bit mask of EOCS field.
	ADC_CR2_EOCS         = 0x400      // Bit EOCS.
	ADC_CR2_DDS_Pos      = 0x9        // Position of DDS field.
	ADC_CR2_DDS_Msk      = 0x200      // Bit mask of DDS field.
	ADC_CR2_DDS          = 0x200      // Bit DDS.
	ADC_CR2_DMA_Pos      = 0x8        // Position of DMA field.
	ADC_CR2_DMA_Msk      = 0x100      // Bit mask of DMA field.
	ADC_CR2_DMA          = 0x100      // Bit DMA.
	ADC_CR2_CONT_Pos     = 0x1        // Position of CONT field.
	ADC_CR2_CONT_Msk     = 0x2        // Bit mask of CONT field.
	ADC_CR2_CONT         = 0x2        // Bit CONT.
	ADC_CR2_ADON_Pos     = 0x0        // Position of ADON field.
	ADC_CR2_ADON_Msk     = 0x1        // Bit mask of ADON field.
	ADC_CR2_ADON         = 0x1        // Bit ADON.

	// SMPR1: sample time register 1
	ADC_SMPR1_SMPx_x_Pos = 0x0        // Position of SMPx_x field.
	ADC_SMPR1_SMPx_x_Msk = 0xffffffff // Bit mask of SMPx_x field.

	// SMPR2: sample time register 2
	ADC_SMPR2_SMPx_x_Pos = 0x0        // Position of SMPx_x field.
	ADC_SMPR2_SMPx_x_Msk = 0xffffffff // Bit mask of SMPx_x field.

	// JOFR1: injected channel data offset register           x
	ADC_JOFR1_JOFFSET1_Pos = 0x0   // Position of JOFFSET1 field.
	ADC_JOFR1_JOFFSET1_Msk = 0xfff // Bit mask of JOFFSET1 field.

	// JOFR2: injected channel data offset register           x
	ADC_JOFR2_JOFFSET2_Pos = 0x0   // Position of JOFFSET2 field.
	ADC_JOFR2_JOFFSET2_Msk = 0xfff // Bit mask of JOFFSET2 field.

	// JOFR3: injected channel data offset register           x
	ADC_JOFR3_JOFFSET3_Pos = 0x0   // Position of JOFFSET3 field.
	ADC_JOFR3_JOFFSET3_Msk = 0xfff // Bit mask of JOFFSET3 field.

	// JOFR4: injected channel data offset register           x
	ADC_JOFR4_JOFFSET4_Pos = 0x0   // Position of JOFFSET4 field.
	ADC_JOFR4_JOFFSET4_Msk = 0xfff // Bit mask of JOFFSET4 field.

	// HTR: watchdog higher threshold           register
	ADC_HTR_HT_Pos = 0x0   // Position of HT field.
	ADC_HTR_HT_Msk = 0xfff // Bit mask of HT field.

	// LTR: watchdog lower threshold           register
	ADC_LTR_LT_Pos = 0x0   // Position of LT field.
	ADC_LTR_LT_Msk = 0xfff // Bit mask of LT field.

	// SQR1: regular sequence register 1
	ADC_SQR1_L_Pos    = 0x14     // Position of L field.
	ADC_SQR1_L_Msk    = 0xf00000 // Bit mask of L field.
	ADC_SQR1_SQ16_Pos = 0xf      // Position of SQ16 field.
	ADC_SQR1_SQ16_Msk = 0xf8000  // Bit mask of SQ16 field.
	ADC_SQR1_SQ15_Pos = 0xa      // Position of SQ15 field.
	ADC_SQR1_SQ15_Msk = 0x7c00   // Bit mask of SQ15 field.
	ADC_SQR1_SQ14_Pos = 0x5      // Position of SQ14 field.
	ADC_SQR1_SQ14_Msk = 0x3e0    // Bit mask of SQ14 field.
	ADC_SQR1_SQ13_Pos = 0x0      // Position of SQ13 field.
	ADC_SQR1_SQ13_Msk = 0x1f     // Bit mask of SQ13 field.

	// SQR2: regular sequence register 2
	ADC_SQR2_SQ12_Pos = 0x19       // Position of SQ12 field.
	ADC_SQR2_SQ12_Msk = 0x3e000000 // Bit mask of SQ12 field.
	ADC_SQR2_SQ11_Pos = 0x14       // Position of SQ11 field.
	ADC_SQR2_SQ11_Msk = 0x1f00000  // Bit mask of SQ11 field.
	ADC_SQR2_SQ10_Pos = 0xf        // Position of SQ10 field.
	ADC_SQR2_SQ10_Msk = 0xf8000    // Bit mask of SQ10 field.
	ADC_SQR2_SQ9_Pos  = 0xa        // Position of SQ9 field.
	ADC_SQR2_SQ9_Msk  = 0x7c00     // Bit mask of SQ9 field.
	ADC_SQR2_SQ8_Pos  = 0x5        // Position of SQ8 field.
	ADC_SQR2_SQ8_Msk  = 0x3e0      // Bit mask of SQ8 field.
	ADC_SQR2_SQ7_Pos  = 0x0        // Position of SQ7 field.
	ADC_SQR2_SQ7_Msk  = 0x1f       // Bit mask of SQ7 field.

	// SQR3: regular sequence register 3
	ADC_SQR3_SQ6_Pos = 0x19       // Position of SQ6 field.
	ADC_SQR3_SQ6_Msk = 0x3e000000 // Bit mask of SQ6 field.
	ADC_SQR3_SQ5_Pos = 0x14       // Position of SQ5 field.
	ADC_SQR3_SQ5_Msk = 0x1f00000  // Bit mask of SQ5 field.
	ADC_SQR3_SQ4_Pos = 0xf        // Position of SQ4 field.
	ADC_SQR3_SQ4_Msk = 0xf8000    // Bit mask of SQ4 field.
	ADC_SQR3_SQ3_Pos = 0xa        // Position of SQ3 field.
	ADC_SQR3_SQ3_Msk = 0x7c00     // Bit mask of SQ3 field.
	ADC_SQR3_SQ2_Pos = 0x5        // Position of SQ2 field.
	ADC_SQR3_SQ2_Msk = 0x3e0      // Bit mask of SQ2 field.
	ADC_SQR3_SQ1_Pos = 0x0        // Position of SQ1 field.
	ADC_SQR3_SQ1_Msk = 0x1f       // Bit mask of SQ1 field.

	// JSQR: injected sequence register
	ADC_JSQR_JL_Pos   = 0x14     // Position of JL field.
	ADC_JSQR_JL_Msk   = 0x300000 // Bit mask of JL field.
	ADC_JSQR_JSQ4_Pos = 0xf      // Position of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000  // Bit mask of JSQ4 field.
	ADC_JSQR_JSQ3_Pos = 0xa      // Position of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00   // Bit mask of JSQ3 field.
	ADC_JSQR_JSQ2_Pos = 0x5      // Position of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0    // Bit mask of JSQ2 field.
	ADC_JSQR_JSQ1_Pos = 0x0      // Position of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f     // Bit mask of JSQ1 field.

	// JDR1: injected data register x
	ADC_JDR1_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR1_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR2: injected data register x
	ADC_JDR2_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR2_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR3: injected data register x
	ADC_JDR3_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR3_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR4: injected data register x
	ADC_JDR4_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR4_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// DR: regular data register
	ADC_DR_DATA_Pos = 0x0    // Position of DATA field.
	ADC_DR_DATA_Msk = 0xffff // Bit mask of DATA field.
)

// Bitfields for USART6: Universal synchronous asynchronous receiver transmitter
const (
	// SR: Status register
	USART_SR_CTS_Pos  = 0x9   // Position of CTS field.
	USART_SR_CTS_Msk  = 0x200 // Bit mask of CTS field.
	USART_SR_CTS      = 0x200 // Bit CTS.
	USART_SR_LBD_Pos  = 0x8   // Position of LBD field.
	USART_SR_LBD_Msk  = 0x100 // Bit mask of LBD field.
	USART_SR_LBD      = 0x100 // Bit LBD.
	USART_SR_TXE_Pos  = 0x7   // Position of TXE field.
	USART_SR_TXE_Msk  = 0x80  // Bit mask of TXE field.
	USART_SR_TXE      = 0x80  // Bit TXE.
	USART_SR_TC_Pos   = 0x6   // Position of TC field.
	USART_SR_TC_Msk   = 0x40  // Bit mask of TC field.
	USART_SR_TC       = 0x40  // Bit TC.
	USART_SR_RXNE_Pos = 0x5   // Position of RXNE field.
	USART_SR_RXNE_Msk = 0x20  // Bit mask of RXNE field.
	USART_SR_RXNE     = 0x20  // Bit RXNE.
	USART_SR_IDLE_Pos = 0x4   // Position of IDLE field.
	USART_SR_IDLE_Msk = 0x10  // Bit mask of IDLE field.
	USART_SR_IDLE     = 0x10  // Bit IDLE.
	USART_SR_ORE_Pos  = 0x3   // Position of ORE field.
	USART_SR_ORE_Msk  = 0x8   // Bit mask of ORE field.
	USART_SR_ORE      = 0x8   // Bit ORE.
	USART_SR_NF_Pos   = 0x2   // Position of NF field.
	USART_SR_NF_Msk   = 0x4   // Bit mask of NF field.
	USART_SR_NF       = 0x4   // Bit NF.
	USART_SR_FE_Pos   = 0x1   // Position of FE field.
	USART_SR_FE_Msk   = 0x2   // Bit mask of FE field.
	USART_SR_FE       = 0x2   // Bit FE.
	USART_SR_PE_Pos   = 0x0   // Position of PE field.
	USART_SR_PE_Msk   = 0x1   // Bit mask of PE field.
	USART_SR_PE       = 0x1   // Bit PE.

	// DR: Data register
	USART_DR_DR_Pos = 0x0   // Position of DR field.
	USART_DR_DR_Msk = 0x1ff // Bit mask of DR field.

	// BRR: Baud rate register
	USART_BRR_DIV_Mantissa_Pos = 0x4    // Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0 // Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Fraction_Pos = 0x0    // Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf    // Bit mask of DIV_Fraction field.

	// CR1: Control register 1
	USART_CR1_OVER8_Pos  = 0xf    // Position of OVER8 field.
	USART_CR1_OVER8_Msk  = 0x8000 // Bit mask of OVER8 field.
	USART_CR1_OVER8      = 0x8000 // Bit OVER8.
	USART_CR1_UE_Pos     = 0xd    // Position of UE field.
	USART_CR1_UE_Msk     = 0x2000 // Bit mask of UE field.
	USART_CR1_UE         = 0x2000 // Bit UE.
	USART_CR1_M_Pos      = 0xc    // Position of M field.
	USART_CR1_M_Msk      = 0x1000 // Bit mask of M field.
	USART_CR1_M          = 0x1000 // Bit M.
	USART_CR1_WAKE_Pos   = 0xb    // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800  // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800  // Bit WAKE.
	USART_CR1_PCE_Pos    = 0xa    // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400  // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400  // Bit PCE.
	USART_CR1_PS_Pos     = 0x9    // Position of PS field.
	USART_CR1_PS_Msk     = 0x200  // Bit mask of PS field.
	USART_CR1_PS         = 0x200  // Bit PS.
	USART_CR1_PEIE_Pos   = 0x8    // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100  // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100  // Bit PEIE.
	USART_CR1_TXEIE_Pos  = 0x7    // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80   // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80   // Bit TXEIE.
	USART_CR1_TCIE_Pos   = 0x6    // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40   // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40   // Bit TCIE.
	USART_CR1_RXNEIE_Pos = 0x5    // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20   // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20   // Bit RXNEIE.
	USART_CR1_IDLEIE_Pos = 0x4    // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10   // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10   // Bit IDLEIE.
	USART_CR1_TE_Pos     = 0x3    // Position of TE field.
	USART_CR1_TE_Msk     = 0x8    // Bit mask of TE field.
	USART_CR1_TE         = 0x8    // Bit TE.
	USART_CR1_RE_Pos     = 0x2    // Position of RE field.
	USART_CR1_RE_Msk     = 0x4    // Bit mask of RE field.
	USART_CR1_RE         = 0x4    // Bit RE.
	USART_CR1_RWU_Pos    = 0x1    // Position of RWU field.
	USART_CR1_RWU_Msk    = 0x2    // Bit mask of RWU field.
	USART_CR1_RWU        = 0x2    // Bit RWU.
	USART_CR1_SBK_Pos    = 0x0    // Position of SBK field.
	USART_CR1_SBK_Msk    = 0x1    // Bit mask of SBK field.
	USART_CR1_SBK        = 0x1    // Bit SBK.

	// CR2: Control register 2
	USART_CR2_LINEN_Pos = 0xe    // Position of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000 // Bit mask of LINEN field.
	USART_CR2_LINEN     = 0x4000 // Bit LINEN.
	USART_CR2_STOP_Pos  = 0xc    // Position of STOP field.
	USART_CR2_STOP_Msk  = 0x3000 // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos = 0xb    // Position of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800  // Bit mask of CLKEN field.
	USART_CR2_CLKEN     = 0x800  // Bit CLKEN.
	USART_CR2_CPOL_Pos  = 0xa    // Position of CPOL field.
	USART_CR2_CPOL_Msk  = 0x400  // Bit mask of CPOL field.
	USART_CR2_CPOL      = 0x400  // Bit CPOL.
	USART_CR2_CPHA_Pos  = 0x9    // Position of CPHA field.
	USART_CR2_CPHA_Msk  = 0x200  // Bit mask of CPHA field.
	USART_CR2_CPHA      = 0x200  // Bit CPHA.
	USART_CR2_LBCL_Pos  = 0x8    // Position of LBCL field.
	USART_CR2_LBCL_Msk  = 0x100  // Bit mask of LBCL field.
	USART_CR2_LBCL      = 0x100  // Bit LBCL.
	USART_CR2_LBDIE_Pos = 0x6    // Position of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40   // Bit mask of LBDIE field.
	USART_CR2_LBDIE     = 0x40   // Bit LBDIE.
	USART_CR2_LBDL_Pos  = 0x5    // Position of LBDL field.
	USART_CR2_LBDL_Msk  = 0x20   // Bit mask of LBDL field.
	USART_CR2_LBDL      = 0x20   // Bit LBDL.
	USART_CR2_ADD_Pos   = 0x0    // Position of ADD field.
	USART_CR2_ADD_Msk   = 0xf    // Bit mask of ADD field.

	// CR3: Control register 3
	USART_CR3_ONEBIT_Pos = 0xb   // Position of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800 // Bit mask of ONEBIT field.
	USART_CR3_ONEBIT     = 0x800 // Bit ONEBIT.
	USART_CR3_CTSIE_Pos  = 0xa   // Position of CTSIE field.
	USART_CR3_CTSIE_Msk  = 0x400 // Bit mask of CTSIE field.
	USART_CR3_CTSIE      = 0x400 // Bit CTSIE.
	USART_CR3_CTSE_Pos   = 0x9   // Position of CTSE field.
	USART_CR3_CTSE_Msk   = 0x200 // Bit mask of CTSE field.
	USART_CR3_CTSE       = 0x200 // Bit CTSE.
	USART_CR3_RTSE_Pos   = 0x8   // Position of RTSE field.
	USART_CR3_RTSE_Msk   = 0x100 // Bit mask of RTSE field.
	USART_CR3_RTSE       = 0x100 // Bit RTSE.
	USART_CR3_DMAT_Pos   = 0x7   // Position of DMAT field.
	USART_CR3_DMAT_Msk   = 0x80  // Bit mask of DMAT field.
	USART_CR3_DMAT       = 0x80  // Bit DMAT.
	USART_CR3_DMAR_Pos   = 0x6   // Position of DMAR field.
	USART_CR3_DMAR_Msk   = 0x40  // Bit mask of DMAR field.
	USART_CR3_DMAR       = 0x40  // Bit DMAR.
	USART_CR3_SCEN_Pos   = 0x5   // Position of SCEN field.
	USART_CR3_SCEN_Msk   = 0x20  // Bit mask of SCEN field.
	USART_CR3_SCEN       = 0x20  // Bit SCEN.
	USART_CR3_NACK_Pos   = 0x4   // Position of NACK field.
	USART_CR3_NACK_Msk   = 0x10  // Bit mask of NACK field.
	USART_CR3_NACK       = 0x10  // Bit NACK.
	USART_CR3_HDSEL_Pos  = 0x3   // Position of HDSEL field.
	USART_CR3_HDSEL_Msk  = 0x8   // Bit mask of HDSEL field.
	USART_CR3_HDSEL      = 0x8   // Bit HDSEL.
	USART_CR3_IRLP_Pos   = 0x2   // Position of IRLP field.
	USART_CR3_IRLP_Msk   = 0x4   // Bit mask of IRLP field.
	USART_CR3_IRLP       = 0x4   // Bit IRLP.
	USART_CR3_IREN_Pos   = 0x1   // Position of IREN field.
	USART_CR3_IREN_Msk   = 0x2   // Bit mask of IREN field.
	USART_CR3_IREN       = 0x2   // Bit IREN.
	USART_CR3_EIE_Pos    = 0x0   // Position of EIE field.
	USART_CR3_EIE_Msk    = 0x1   // Bit mask of EIE field.
	USART_CR3_EIE        = 0x1   // Bit EIE.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	DAC_CR_DMAUDRIE2_Pos = 0x1d       // Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000 // Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2     = 0x20000000 // Bit DMAUDRIE2.
	DAC_CR_DMAEN2_Pos    = 0x1c       // Position of DMAEN2 field.
	DAC_CR_DMAEN2_Msk    = 0x10000000 // Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2        = 0x10000000 // Bit DMAEN2.
	DAC_CR_MAMP2_Pos     = 0x18       // Position of MAMP2 field.
	DAC_CR_MAMP2_Msk     = 0xf000000  // Bit mask of MAMP2 field.
	DAC_CR_WAVE2_Pos     = 0x16       // Position of WAVE2 field.
	DAC_CR_WAVE2_Msk     = 0xc00000   // Bit mask of WAVE2 field.
	DAC_CR_TSEL2_Pos     = 0x13       // Position of TSEL2 field.
	DAC_CR_TSEL2_Msk     = 0x380000   // Bit mask of TSEL2 field.
	DAC_CR_TEN2_Pos      = 0x12       // Position of TEN2 field.
	DAC_CR_TEN2_Msk      = 0x40000    // Bit mask of TEN2 field.
	DAC_CR_TEN2          = 0x40000    // Bit TEN2.
	DAC_CR_BOFF2_Pos     = 0x11       // Position of BOFF2 field.
	DAC_CR_BOFF2_Msk     = 0x20000    // Bit mask of BOFF2 field.
	DAC_CR_BOFF2         = 0x20000    // Bit BOFF2.
	DAC_CR_EN2_Pos       = 0x10       // Position of EN2 field.
	DAC_CR_EN2_Msk       = 0x10000    // Bit mask of EN2 field.
	DAC_CR_EN2           = 0x10000    // Bit EN2.
	DAC_CR_DMAUDRIE1_Pos = 0xd        // Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000     // Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1     = 0x2000     // Bit DMAUDRIE1.
	DAC_CR_DMAEN1_Pos    = 0xc        // Position of DMAEN1 field.
	DAC_CR_DMAEN1_Msk    = 0x1000     // Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1        = 0x1000     // Bit DMAEN1.
	DAC_CR_MAMP1_Pos     = 0x8        // Position of MAMP1 field.
	DAC_CR_MAMP1_Msk     = 0xf00      // Bit mask of MAMP1 field.
	DAC_CR_WAVE1_Pos     = 0x6        // Position of WAVE1 field.
	DAC_CR_WAVE1_Msk     = 0xc0       // Bit mask of WAVE1 field.
	DAC_CR_TSEL1_Pos     = 0x3        // Position of TSEL1 field.
	DAC_CR_TSEL1_Msk     = 0x38       // Bit mask of TSEL1 field.
	DAC_CR_TEN1_Pos      = 0x2        // Position of TEN1 field.
	DAC_CR_TEN1_Msk      = 0x4        // Bit mask of TEN1 field.
	DAC_CR_TEN1          = 0x4        // Bit TEN1.
	DAC_CR_BOFF1_Pos     = 0x1        // Position of BOFF1 field.
	DAC_CR_BOFF1_Msk     = 0x2        // Bit mask of BOFF1 field.
	DAC_CR_BOFF1         = 0x2        // Bit BOFF1.
	DAC_CR_EN1_Pos       = 0x0        // Position of EN1 field.
	DAC_CR_EN1_Msk       = 0x1        // Bit mask of EN1 field.
	DAC_CR_EN1           = 0x1        // Bit EN1.

	// SWTRIGR: software trigger register
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1 // Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2 // Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2     = 0x2 // Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0 // Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1 // Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1     = 0x1 // Bit SWTRIG1.

	// DHR12R1: channel1 12-bit right-aligned data holding           register
	DAC_DHR12R1_DACC1DHR_Pos = 0x0   // Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff // Bit mask of DACC1DHR field.

	// DHR12L1: channel1 12-bit left aligned data holding           register
	DAC_DHR12L1_DACC1DHR_Pos = 0x4    // Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0 // Bit mask of DACC1DHR field.

	// DHR8R1: channel1 8-bit right aligned data holding           register
	DAC_DHR8R1_DACC1DHR_Pos = 0x0  // Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff // Bit mask of DACC1DHR field.

	// DHR12R2: channel2 12-bit right aligned data holding           register
	DAC_DHR12R2_DACC2DHR_Pos = 0x0   // Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff // Bit mask of DACC2DHR field.

	// DHR12L2: channel2 12-bit left aligned data holding           register
	DAC_DHR12L2_DACC2DHR_Pos = 0x4    // Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0 // Bit mask of DACC2DHR field.

	// DHR8R2: channel2 8-bit right-aligned data holding           register
	DAC_DHR8R2_DACC2DHR_Pos = 0x0  // Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff // Bit mask of DACC2DHR field.

	// DHR12RD: Dual DAC 12-bit right-aligned data holding           register
	DAC_DHR12RD_DACC2DHR_Pos = 0x10      // Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000 // Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0       // Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff     // Bit mask of DACC1DHR field.

	// DHR12LD: DUAL DAC 12-bit left aligned data holding           register
	DAC_DHR12LD_DACC2DHR_Pos = 0x14       // Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000 // Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4        // Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0     // Bit mask of DACC1DHR field.

	// DHR8RD: DUAL DAC 8-bit right aligned data holding           register
	DAC_DHR8RD_DACC2DHR_Pos = 0x8    // Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00 // Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0    // Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff   // Bit mask of DACC1DHR field.

	// DOR1: channel1 data output register
	DAC_DOR1_DACC1DOR_Pos = 0x0   // Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff // Bit mask of DACC1DOR field.

	// DOR2: channel2 data output register
	DAC_DOR2_DACC2DOR_Pos = 0x0   // Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff // Bit mask of DACC2DOR field.

	// SR: status register
	DAC_SR_DMAUDR2_Pos = 0x1d       // Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000 // Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2     = 0x20000000 // Bit DMAUDR2.
	DAC_SR_DMAUDR1_Pos = 0xd        // Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000     // Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1     = 0x2000     // Bit DMAUDR1.
)

// Bitfields for I2C3: Inter-integrated circuit
const (
	// CR1: Control register 1
	I2C_CR1_SWRST_Pos     = 0xf    // Position of SWRST field.
	I2C_CR1_SWRST_Msk     = 0x8000 // Bit mask of SWRST field.
	I2C_CR1_SWRST         = 0x8000 // Bit SWRST.
	I2C_CR1_ALERT_Pos     = 0xd    // Position of ALERT field.
	I2C_CR1_ALERT_Msk     = 0x2000 // Bit mask of ALERT field.
	I2C_CR1_ALERT         = 0x2000 // Bit ALERT.
	I2C_CR1_PEC_Pos       = 0xc    // Position of PEC field.
	I2C_CR1_PEC_Msk       = 0x1000 // Bit mask of PEC field.
	I2C_CR1_PEC           = 0x1000 // Bit PEC.
	I2C_CR1_POS_Pos       = 0xb    // Position of POS field.
	I2C_CR1_POS_Msk       = 0x800  // Bit mask of POS field.
	I2C_CR1_POS           = 0x800  // Bit POS.
	I2C_CR1_ACK_Pos       = 0xa    // Position of ACK field.
	I2C_CR1_ACK_Msk       = 0x400  // Bit mask of ACK field.
	I2C_CR1_ACK           = 0x400  // Bit ACK.
	I2C_CR1_STOP_Pos      = 0x9    // Position of STOP field.
	I2C_CR1_STOP_Msk      = 0x200  // Bit mask of STOP field.
	I2C_CR1_STOP          = 0x200  // Bit STOP.
	I2C_CR1_START_Pos     = 0x8    // Position of START field.
	I2C_CR1_START_Msk     = 0x100  // Bit mask of START field.
	I2C_CR1_START         = 0x100  // Bit START.
	I2C_CR1_NOSTRETCH_Pos = 0x7    // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x80   // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x80   // Bit NOSTRETCH.
	I2C_CR1_ENGC_Pos      = 0x6    // Position of ENGC field.
	I2C_CR1_ENGC_Msk      = 0x40   // Bit mask of ENGC field.
	I2C_CR1_ENGC          = 0x40   // Bit ENGC.
	I2C_CR1_ENPEC_Pos     = 0x5    // Position of ENPEC field.
	I2C_CR1_ENPEC_Msk     = 0x20   // Bit mask of ENPEC field.
	I2C_CR1_ENPEC         = 0x20   // Bit ENPEC.
	I2C_CR1_ENARP_Pos     = 0x4    // Position of ENARP field.
	I2C_CR1_ENARP_Msk     = 0x10   // Bit mask of ENARP field.
	I2C_CR1_ENARP         = 0x10   // Bit ENARP.
	I2C_CR1_SMBTYPE_Pos   = 0x3    // Position of SMBTYPE field.
	I2C_CR1_SMBTYPE_Msk   = 0x8    // Bit mask of SMBTYPE field.
	I2C_CR1_SMBTYPE       = 0x8    // Bit SMBTYPE.
	I2C_CR1_SMBUS_Pos     = 0x1    // Position of SMBUS field.
	I2C_CR1_SMBUS_Msk     = 0x2    // Bit mask of SMBUS field.
	I2C_CR1_SMBUS         = 0x2    // Bit SMBUS.
	I2C_CR1_PE_Pos        = 0x0    // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1    // Bit mask of PE field.
	I2C_CR1_PE            = 0x1    // Bit PE.

	// CR2: Control register 2
	I2C_CR2_LAST_Pos    = 0xc    // Position of LAST field.
	I2C_CR2_LAST_Msk    = 0x1000 // Bit mask of LAST field.
	I2C_CR2_LAST        = 0x1000 // Bit LAST.
	I2C_CR2_DMAEN_Pos   = 0xb    // Position of DMAEN field.
	I2C_CR2_DMAEN_Msk   = 0x800  // Bit mask of DMAEN field.
	I2C_CR2_DMAEN       = 0x800  // Bit DMAEN.
	I2C_CR2_ITBUFEN_Pos = 0xa    // Position of ITBUFEN field.
	I2C_CR2_ITBUFEN_Msk = 0x400  // Bit mask of ITBUFEN field.
	I2C_CR2_ITBUFEN     = 0x400  // Bit ITBUFEN.
	I2C_CR2_ITEVTEN_Pos = 0x9    // Position of ITEVTEN field.
	I2C_CR2_ITEVTEN_Msk = 0x200  // Bit mask of ITEVTEN field.
	I2C_CR2_ITEVTEN     = 0x200  // Bit ITEVTEN.
	I2C_CR2_ITERREN_Pos = 0x8    // Position of ITERREN field.
	I2C_CR2_ITERREN_Msk = 0x100  // Bit mask of ITERREN field.
	I2C_CR2_ITERREN     = 0x100  // Bit ITERREN.
	I2C_CR2_FREQ_Pos    = 0x0    // Position of FREQ field.
	I2C_CR2_FREQ_Msk    = 0x3f   // Bit mask of FREQ field.

	// OAR1: Own address register 1
	I2C_OAR1_ADDMODE_Pos = 0xf    // Position of ADDMODE field.
	I2C_OAR1_ADDMODE_Msk = 0x8000 // Bit mask of ADDMODE field.
	I2C_OAR1_ADDMODE     = 0x8000 // Bit ADDMODE.
	I2C_OAR1_ADD10_Pos   = 0x8    // Position of ADD10 field.
	I2C_OAR1_ADD10_Msk   = 0x300  // Bit mask of ADD10 field.
	I2C_OAR1_ADD7_Pos    = 0x1    // Position of ADD7 field.
	I2C_OAR1_ADD7_Msk    = 0xfe   // Bit mask of ADD7 field.
	I2C_OAR1_ADD0_Pos    = 0x0    // Position of ADD0 field.
	I2C_OAR1_ADD0_Msk    = 0x1    // Bit mask of ADD0 field.
	I2C_OAR1_ADD0        = 0x1    // Bit ADD0.

	// OAR2: Own address register 2
	I2C_OAR2_ADD2_Pos   = 0x1  // Position of ADD2 field.
	I2C_OAR2_ADD2_Msk   = 0xfe // Bit mask of ADD2 field.
	I2C_OAR2_ENDUAL_Pos = 0x0  // Position of ENDUAL field.
	I2C_OAR2_ENDUAL_Msk = 0x1  // Bit mask of ENDUAL field.
	I2C_OAR2_ENDUAL     = 0x1  // Bit ENDUAL.

	// DR: Data register
	I2C_DR_DR_Pos = 0x0  // Position of DR field.
	I2C_DR_DR_Msk = 0xff // Bit mask of DR field.

	// SR1: Status register 1
	I2C_SR1_SMBALERT_Pos = 0xf    // Position of SMBALERT field.
	I2C_SR1_SMBALERT_Msk = 0x8000 // Bit mask of SMBALERT field.
	I2C_SR1_SMBALERT     = 0x8000 // Bit SMBALERT.
	I2C_SR1_TIMEOUT_Pos  = 0xe    // Position of TIMEOUT field.
	I2C_SR1_TIMEOUT_Msk  = 0x4000 // Bit mask of TIMEOUT field.
	I2C_SR1_TIMEOUT      = 0x4000 // Bit TIMEOUT.
	I2C_SR1_PECERR_Pos   = 0xc    // Position of PECERR field.
	I2C_SR1_PECERR_Msk   = 0x1000 // Bit mask of PECERR field.
	I2C_SR1_PECERR       = 0x1000 // Bit PECERR.
	I2C_SR1_OVR_Pos      = 0xb    // Position of OVR field.
	I2C_SR1_OVR_Msk      = 0x800  // Bit mask of OVR field.
	I2C_SR1_OVR          = 0x800  // Bit OVR.
	I2C_SR1_AF_Pos       = 0xa    // Position of AF field.
	I2C_SR1_AF_Msk       = 0x400  // Bit mask of AF field.
	I2C_SR1_AF           = 0x400  // Bit AF.
	I2C_SR1_ARLO_Pos     = 0x9    // Position of ARLO field.
	I2C_SR1_ARLO_Msk     = 0x200  // Bit mask of ARLO field.
	I2C_SR1_ARLO         = 0x200  // Bit ARLO.
	I2C_SR1_BERR_Pos     = 0x8    // Position of BERR field.
	I2C_SR1_BERR_Msk     = 0x100  // Bit mask of BERR field.
	I2C_SR1_BERR         = 0x100  // Bit BERR.
	I2C_SR1_TxE_Pos      = 0x7    // Position of TxE field.
	I2C_SR1_TxE_Msk      = 0x80   // Bit mask of TxE field.
	I2C_SR1_TxE          = 0x80   // Bit TxE.
	I2C_SR1_RxNE_Pos     = 0x6    // Position of RxNE field.
	I2C_SR1_RxNE_Msk     = 0x40   // Bit mask of RxNE field.
	I2C_SR1_RxNE         = 0x40   // Bit RxNE.
	I2C_SR1_STOPF_Pos    = 0x4    // Position of STOPF field.
	I2C_SR1_STOPF_Msk    = 0x10   // Bit mask of STOPF field.
	I2C_SR1_STOPF        = 0x10   // Bit STOPF.
	I2C_SR1_ADD10_Pos    = 0x3    // Position of ADD10 field.
	I2C_SR1_ADD10_Msk    = 0x8    // Bit mask of ADD10 field.
	I2C_SR1_ADD10        = 0x8    // Bit ADD10.
	I2C_SR1_BTF_Pos      = 0x2    // Position of BTF field.
	I2C_SR1_BTF_Msk      = 0x4    // Bit mask of BTF field.
	I2C_SR1_BTF          = 0x4    // Bit BTF.
	I2C_SR1_ADDR_Pos     = 0x1    // Position of ADDR field.
	I2C_SR1_ADDR_Msk     = 0x2    // Bit mask of ADDR field.
	I2C_SR1_ADDR         = 0x2    // Bit ADDR.
	I2C_SR1_SB_Pos       = 0x0    // Position of SB field.
	I2C_SR1_SB_Msk       = 0x1    // Bit mask of SB field.
	I2C_SR1_SB           = 0x1    // Bit SB.

	// SR2: Status register 2
	I2C_SR2_PEC_Pos        = 0x8    // Position of PEC field.
	I2C_SR2_PEC_Msk        = 0xff00 // Bit mask of PEC field.
	I2C_SR2_DUALF_Pos      = 0x7    // Position of DUALF field.
	I2C_SR2_DUALF_Msk      = 0x80   // Bit mask of DUALF field.
	I2C_SR2_DUALF          = 0x80   // Bit DUALF.
	I2C_SR2_SMBHOST_Pos    = 0x6    // Position of SMBHOST field.
	I2C_SR2_SMBHOST_Msk    = 0x40   // Bit mask of SMBHOST field.
	I2C_SR2_SMBHOST        = 0x40   // Bit SMBHOST.
	I2C_SR2_SMBDEFAULT_Pos = 0x5    // Position of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Msk = 0x20   // Bit mask of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT     = 0x20   // Bit SMBDEFAULT.
	I2C_SR2_GENCALL_Pos    = 0x4    // Position of GENCALL field.
	I2C_SR2_GENCALL_Msk    = 0x10   // Bit mask of GENCALL field.
	I2C_SR2_GENCALL        = 0x10   // Bit GENCALL.
	I2C_SR2_TRA_Pos        = 0x2    // Position of TRA field.
	I2C_SR2_TRA_Msk        = 0x4    // Bit mask of TRA field.
	I2C_SR2_TRA            = 0x4    // Bit TRA.
	I2C_SR2_BUSY_Pos       = 0x1    // Position of BUSY field.
	I2C_SR2_BUSY_Msk       = 0x2    // Bit mask of BUSY field.
	I2C_SR2_BUSY           = 0x2    // Bit BUSY.
	I2C_SR2_MSL_Pos        = 0x0    // Position of MSL field.
	I2C_SR2_MSL_Msk        = 0x1    // Bit mask of MSL field.
	I2C_SR2_MSL            = 0x1    // Bit MSL.

	// CCR: Clock control register
	I2C_CCR_F_S_Pos  = 0xf    // Position of F_S field.
	I2C_CCR_F_S_Msk  = 0x8000 // Bit mask of F_S field.
	I2C_CCR_F_S      = 0x8000 // Bit F_S.
	I2C_CCR_DUTY_Pos = 0xe    // Position of DUTY field.
	I2C_CCR_DUTY_Msk = 0x4000 // Bit mask of DUTY field.
	I2C_CCR_DUTY     = 0x4000 // Bit DUTY.
	I2C_CCR_CCR_Pos  = 0x0    // Position of CCR field.
	I2C_CCR_CCR_Msk  = 0xfff  // Bit mask of CCR field.

	// TRISE: TRISE register
	I2C_TRISE_TRISE_Pos = 0x0  // Position of TRISE field.
	I2C_TRISE_TRISE_Msk = 0x3f // Bit mask of TRISE field.

	// FLTR: I2C FLTR register
	I2C_FLTR_DNF_Pos   = 0x0  // Position of DNF field.
	I2C_FLTR_DNF_Msk   = 0xf  // Bit mask of DNF field.
	I2C_FLTR_ANOFF_Pos = 0x4  // Position of ANOFF field.
	I2C_FLTR_ANOFF_Msk = 0x10 // Bit mask of ANOFF field.
	I2C_FLTR_ANOFF     = 0x10 // Bit ANOFF.
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.

	// CFR: Configuration register
	WWDG_CFR_EWI_Pos    = 0x9   // Position of EWI field.
	WWDG_CFR_EWI_Msk    = 0x200 // Bit mask of EWI field.
	WWDG_CFR_EWI        = 0x200 // Bit EWI.
	WWDG_CFR_WDGTB1_Pos = 0x8   // Position of WDGTB1 field.
	WWDG_CFR_WDGTB1_Msk = 0x100 // Bit mask of WDGTB1 field.
	WWDG_CFR_WDGTB1     = 0x100 // Bit WDGTB1.
	WWDG_CFR_WDGTB0_Pos = 0x7   // Position of WDGTB0 field.
	WWDG_CFR_WDGTB0_Msk = 0x80  // Bit mask of WDGTB0 field.
	WWDG_CFR_WDGTB0     = 0x80  // Bit WDGTB0.
	WWDG_CFR_W_Pos      = 0x0   // Position of W field.
	WWDG_CFR_W_Msk      = 0x7f  // Bit mask of W field.

	// SR: Status register
	WWDG_SR_EWIF_Pos = 0x0 // Position of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1 // Bit mask of EWIF field.
	WWDG_SR_EWIF     = 0x1 // Bit EWIF.
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	RTC_TR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TR_PM      = 0x400000 // Bit PM.
	RTC_TR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TR_SU_Msk  = 0xf      // Bit mask of SU field.

	// DR: date register
	RTC_DR_YT_Pos  = 0x14     // Position of YT field.
	RTC_DR_YT_Msk  = 0xf00000 // Bit mask of YT field.
	RTC_DR_YU_Pos  = 0x10     // Position of YU field.
	RTC_DR_YU_Msk  = 0xf0000  // Bit mask of YU field.
	RTC_DR_WDU_Pos = 0xd      // Position of WDU field.
	RTC_DR_WDU_Msk = 0xe000   // Bit mask of WDU field.
	RTC_DR_MT_Pos  = 0xc      // Position of MT field.
	RTC_DR_MT_Msk  = 0x1000   // Bit mask of MT field.
	RTC_DR_MT      = 0x1000   // Bit MT.
	RTC_DR_MU_Pos  = 0x8      // Position of MU field.
	RTC_DR_MU_Msk  = 0xf00    // Bit mask of MU field.
	RTC_DR_DT_Pos  = 0x4      // Position of DT field.
	RTC_DR_DT_Msk  = 0x30     // Bit mask of DT field.
	RTC_DR_DU_Pos  = 0x0      // Position of DU field.
	RTC_DR_DU_Msk  = 0xf      // Bit mask of DU field.

	// CR: control register
	RTC_CR_COE_Pos     = 0x17     // Position of COE field.
	RTC_CR_COE_Msk     = 0x800000 // Bit mask of COE field.
	RTC_CR_COE         = 0x800000 // Bit COE.
	RTC_CR_OSEL_Pos    = 0x15     // Position of OSEL field.
	RTC_CR_OSEL_Msk    = 0x600000 // Bit mask of OSEL field.
	RTC_CR_POL_Pos     = 0x14     // Position of POL field.
	RTC_CR_POL_Msk     = 0x100000 // Bit mask of POL field.
	RTC_CR_POL         = 0x100000 // Bit POL.
	RTC_CR_BKP_Pos     = 0x12     // Position of BKP field.
	RTC_CR_BKP_Msk     = 0x40000  // Bit mask of BKP field.
	RTC_CR_BKP         = 0x40000  // Bit BKP.
	RTC_CR_SUB1H_Pos   = 0x11     // Position of SUB1H field.
	RTC_CR_SUB1H_Msk   = 0x20000  // Bit mask of SUB1H field.
	RTC_CR_SUB1H       = 0x20000  // Bit SUB1H.
	RTC_CR_ADD1H_Pos   = 0x10     // Position of ADD1H field.
	RTC_CR_ADD1H_Msk   = 0x10000  // Bit mask of ADD1H field.
	RTC_CR_ADD1H       = 0x10000  // Bit ADD1H.
	RTC_CR_TSIE_Pos    = 0xf      // Position of TSIE field.
	RTC_CR_TSIE_Msk    = 0x8000   // Bit mask of TSIE field.
	RTC_CR_TSIE        = 0x8000   // Bit TSIE.
	RTC_CR_WUTIE_Pos   = 0xe      // Position of WUTIE field.
	RTC_CR_WUTIE_Msk   = 0x4000   // Bit mask of WUTIE field.
	RTC_CR_WUTIE       = 0x4000   // Bit WUTIE.
	RTC_CR_ALRBIE_Pos  = 0xd      // Position of ALRBIE field.
	RTC_CR_ALRBIE_Msk  = 0x2000   // Bit mask of ALRBIE field.
	RTC_CR_ALRBIE      = 0x2000   // Bit ALRBIE.
	RTC_CR_ALRAIE_Pos  = 0xc      // Position of ALRAIE field.
	RTC_CR_ALRAIE_Msk  = 0x1000   // Bit mask of ALRAIE field.
	RTC_CR_ALRAIE      = 0x1000   // Bit ALRAIE.
	RTC_CR_TSE_Pos     = 0xb      // Position of TSE field.
	RTC_CR_TSE_Msk     = 0x800    // Bit mask of TSE field.
	RTC_CR_TSE         = 0x800    // Bit TSE.
	RTC_CR_WUTE_Pos    = 0xa      // Position of WUTE field.
	RTC_CR_WUTE_Msk    = 0x400    // Bit mask of WUTE field.
	RTC_CR_WUTE        = 0x400    // Bit WUTE.
	RTC_CR_ALRBE_Pos   = 0x9      // Position of ALRBE field.
	RTC_CR_ALRBE_Msk   = 0x200    // Bit mask of ALRBE field.
	RTC_CR_ALRBE       = 0x200    // Bit ALRBE.
	RTC_CR_ALRAE_Pos   = 0x8      // Position of ALRAE field.
	RTC_CR_ALRAE_Msk   = 0x100    // Bit mask of ALRAE field.
	RTC_CR_ALRAE       = 0x100    // Bit ALRAE.
	RTC_CR_DCE_Pos     = 0x7      // Position of DCE field.
	RTC_CR_DCE_Msk     = 0x80     // Bit mask of DCE field.
	RTC_CR_DCE         = 0x80     // Bit DCE.
	RTC_CR_FMT_Pos     = 0x6      // Position of FMT field.
	RTC_CR_FMT_Msk     = 0x40     // Bit mask of FMT field.
	RTC_CR_FMT         = 0x40     // Bit FMT.
	RTC_CR_REFCKON_Pos = 0x4      // Position of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10     // Bit mask of REFCKON field.
	RTC_CR_REFCKON     = 0x10     // Bit REFCKON.
	RTC_CR_TSEDGE_Pos  = 0x3      // Position of TSEDGE field.
	RTC_CR_TSEDGE_Msk  = 0x8      // Bit mask of TSEDGE field.
	RTC_CR_TSEDGE      = 0x8      // Bit TSEDGE.
	RTC_CR_WCKSEL_Pos  = 0x0      // Position of WCKSEL field.
	RTC_CR_WCKSEL_Msk  = 0x7      // Bit mask of WCKSEL field.

	// ISR: initialization and status           register
	RTC_ISR_ALRAWF_Pos  = 0x0     // Position of ALRAWF field.
	RTC_ISR_ALRAWF_Msk  = 0x1     // Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF      = 0x1     // Bit ALRAWF.
	RTC_ISR_ALRBWF_Pos  = 0x1     // Position of ALRBWF field.
	RTC_ISR_ALRBWF_Msk  = 0x2     // Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF      = 0x2     // Bit ALRBWF.
	RTC_ISR_WUTWF_Pos   = 0x2     // Position of WUTWF field.
	RTC_ISR_WUTWF_Msk   = 0x4     // Bit mask of WUTWF field.
	RTC_ISR_WUTWF       = 0x4     // Bit WUTWF.
	RTC_ISR_SHPF_Pos    = 0x3     // Position of SHPF field.
	RTC_ISR_SHPF_Msk    = 0x8     // Bit mask of SHPF field.
	RTC_ISR_SHPF        = 0x8     // Bit SHPF.
	RTC_ISR_INITS_Pos   = 0x4     // Position of INITS field.
	RTC_ISR_INITS_Msk   = 0x10    // Bit mask of INITS field.
	RTC_ISR_INITS       = 0x10    // Bit INITS.
	RTC_ISR_RSF_Pos     = 0x5     // Position of RSF field.
	RTC_ISR_RSF_Msk     = 0x20    // Bit mask of RSF field.
	RTC_ISR_RSF         = 0x20    // Bit RSF.
	RTC_ISR_INITF_Pos   = 0x6     // Position of INITF field.
	RTC_ISR_INITF_Msk   = 0x40    // Bit mask of INITF field.
	RTC_ISR_INITF       = 0x40    // Bit INITF.
	RTC_ISR_INIT_Pos    = 0x7     // Position of INIT field.
	RTC_ISR_INIT_Msk    = 0x80    // Bit mask of INIT field.
	RTC_ISR_INIT        = 0x80    // Bit INIT.
	RTC_ISR_ALRAF_Pos   = 0x8     // Position of ALRAF field.
	RTC_ISR_ALRAF_Msk   = 0x100   // Bit mask of ALRAF field.
	RTC_ISR_ALRAF       = 0x100   // Bit ALRAF.
	RTC_ISR_ALRBF_Pos   = 0x9     // Position of ALRBF field.
	RTC_ISR_ALRBF_Msk   = 0x200   // Bit mask of ALRBF field.
	RTC_ISR_ALRBF       = 0x200   // Bit ALRBF.
	RTC_ISR_WUTF_Pos    = 0xa     // Position of WUTF field.
	RTC_ISR_WUTF_Msk    = 0x400   // Bit mask of WUTF field.
	RTC_ISR_WUTF        = 0x400   // Bit WUTF.
	RTC_ISR_TSF_Pos     = 0xb     // Position of TSF field.
	RTC_ISR_TSF_Msk     = 0x800   // Bit mask of TSF field.
	RTC_ISR_TSF         = 0x800   // Bit TSF.
	RTC_ISR_TSOVF_Pos   = 0xc     // Position of TSOVF field.
	RTC_ISR_TSOVF_Msk   = 0x1000  // Bit mask of TSOVF field.
	RTC_ISR_TSOVF       = 0x1000  // Bit TSOVF.
	RTC_ISR_TAMP1F_Pos  = 0xd     // Position of TAMP1F field.
	RTC_ISR_TAMP1F_Msk  = 0x2000  // Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F      = 0x2000  // Bit TAMP1F.
	RTC_ISR_TAMP2F_Pos  = 0xe     // Position of TAMP2F field.
	RTC_ISR_TAMP2F_Msk  = 0x4000  // Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F      = 0x4000  // Bit TAMP2F.
	RTC_ISR_RECALPF_Pos = 0x10    // Position of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000 // Bit mask of RECALPF field.
	RTC_ISR_RECALPF     = 0x10000 // Bit RECALPF.

	// PRER: prescaler register
	RTC_PRER_PREDIV_A_Pos = 0x10     // Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000 // Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_S_Pos = 0x0      // Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff   // Bit mask of PREDIV_S field.

	// WUTR: wakeup timer register
	RTC_WUTR_WUT_Pos = 0x0    // Position of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff // Bit mask of WUT field.

	// CALIBR: calibration register
	RTC_CALIBR_DCS_Pos = 0x7  // Position of DCS field.
	RTC_CALIBR_DCS_Msk = 0x80 // Bit mask of DCS field.
	RTC_CALIBR_DCS     = 0x80 // Bit DCS.
	RTC_CALIBR_DC_Pos  = 0x0  // Position of DC field.
	RTC_CALIBR_DC_Msk  = 0x1f // Bit mask of DC field.

	// ALRMAR: alarm A register
	RTC_ALRMAR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMAR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMAR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMAR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMAR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMAR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMAR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMAR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMAR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMAR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMAR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMAR_PM        = 0x400000   // Bit PM.
	RTC_ALRMAR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMAR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMAR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMAR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMAR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMAR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMAR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMAR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMAR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMAR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMAR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMAR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMAR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMAR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMAR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMAR_SU_Msk    = 0xf        // Bit mask of SU field.

	// ALRMBR: alarm B register
	RTC_ALRMBR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMBR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMBR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMBR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMBR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMBR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMBR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMBR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMBR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMBR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMBR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMBR_PM        = 0x400000   // Bit PM.
	RTC_ALRMBR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMBR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMBR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMBR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMBR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMBR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMBR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMBR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMBR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMBR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMBR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMBR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMBR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMBR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMBR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMBR_SU_Msk    = 0xf        // Bit mask of SU field.

	// WPR: write protection register
	RTC_WPR_KEY_Pos = 0x0  // Position of KEY field.
	RTC_WPR_KEY_Msk = 0xff // Bit mask of KEY field.

	// SSR: sub second register
	RTC_SSR_SS_Pos = 0x0    // Position of SS field.
	RTC_SSR_SS_Msk = 0xffff // Bit mask of SS field.

	// SHIFTR: shift control register
	RTC_SHIFTR_ADD1S_Pos = 0x1f       // Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000 // Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S     = 0x80000000 // Bit ADD1S.
	RTC_SHIFTR_SUBFS_Pos = 0x0        // Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff     // Bit mask of SUBFS field.

	// TSTR: time stamp time register
	RTC_TSTR_ALARMOUTTYPE_Pos = 0x12    // Position of ALARMOUTTYPE field.
	RTC_TSTR_ALARMOUTTYPE_Msk = 0x40000 // Bit mask of ALARMOUTTYPE field.
	RTC_TSTR_ALARMOUTTYPE     = 0x40000 // Bit ALARMOUTTYPE.
	RTC_TSTR_TSINSEL_Pos      = 0x11    // Position of TSINSEL field.
	RTC_TSTR_TSINSEL_Msk      = 0x20000 // Bit mask of TSINSEL field.
	RTC_TSTR_TSINSEL          = 0x20000 // Bit TSINSEL.
	RTC_TSTR_TAMP1INSEL_Pos   = 0x10    // Position of TAMP1INSEL field.
	RTC_TSTR_TAMP1INSEL_Msk   = 0x10000 // Bit mask of TAMP1INSEL field.
	RTC_TSTR_TAMP1INSEL       = 0x10000 // Bit TAMP1INSEL.
	RTC_TSTR_TAMPIE_Pos       = 0x2     // Position of TAMPIE field.
	RTC_TSTR_TAMPIE_Msk       = 0x4     // Bit mask of TAMPIE field.
	RTC_TSTR_TAMPIE           = 0x4     // Bit TAMPIE.
	RTC_TSTR_TAMP1TRG_Pos     = 0x1     // Position of TAMP1TRG field.
	RTC_TSTR_TAMP1TRG_Msk     = 0x2     // Bit mask of TAMP1TRG field.
	RTC_TSTR_TAMP1TRG         = 0x2     // Bit TAMP1TRG.
	RTC_TSTR_TAMP1E_Pos       = 0x0     // Position of TAMP1E field.
	RTC_TSTR_TAMP1E_Msk       = 0x1     // Bit mask of TAMP1E field.
	RTC_TSTR_TAMP1E           = 0x1     // Bit TAMP1E.

	// TSDR: time stamp date register
	RTC_TSDR_WDU_Pos = 0xd    // Position of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000 // Bit mask of WDU field.
	RTC_TSDR_MT_Pos  = 0xc    // Position of MT field.
	RTC_TSDR_MT_Msk  = 0x1000 // Bit mask of MT field.
	RTC_TSDR_MT      = 0x1000 // Bit MT.
	RTC_TSDR_MU_Pos  = 0x8    // Position of MU field.
	RTC_TSDR_MU_Msk  = 0xf00  // Bit mask of MU field.
	RTC_TSDR_DT_Pos  = 0x4    // Position of DT field.
	RTC_TSDR_DT_Msk  = 0x30   // Bit mask of DT field.
	RTC_TSDR_DU_Pos  = 0x0    // Position of DU field.
	RTC_TSDR_DU_Msk  = 0xf    // Bit mask of DU field.

	// TSSSR: timestamp sub second register
	RTC_TSSSR_SS_Pos = 0x0    // Position of SS field.
	RTC_TSSSR_SS_Msk = 0xffff // Bit mask of SS field.

	// CALR: calibration register
	RTC_CALR_CALP_Pos   = 0xf    // Position of CALP field.
	RTC_CALR_CALP_Msk   = 0x8000 // Bit mask of CALP field.
	RTC_CALR_CALP       = 0x8000 // Bit CALP.
	RTC_CALR_CALW8_Pos  = 0xe    // Position of CALW8 field.
	RTC_CALR_CALW8_Msk  = 0x4000 // Bit mask of CALW8 field.
	RTC_CALR_CALW8      = 0x4000 // Bit CALW8.
	RTC_CALR_CALW16_Pos = 0xd    // Position of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000 // Bit mask of CALW16 field.
	RTC_CALR_CALW16     = 0x2000 // Bit CALW16.
	RTC_CALR_CALM_Pos   = 0x0    // Position of CALM field.
	RTC_CALR_CALM_Msk   = 0x1ff  // Bit mask of CALM field.

	// TAFCR: tamper and alternate function configuration           register
	RTC_TAFCR_ALARMOUTTYPE_Pos = 0x12    // Position of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Msk = 0x40000 // Bit mask of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE     = 0x40000 // Bit ALARMOUTTYPE.
	RTC_TAFCR_TSINSEL_Pos      = 0x11    // Position of TSINSEL field.
	RTC_TAFCR_TSINSEL_Msk      = 0x20000 // Bit mask of TSINSEL field.
	RTC_TAFCR_TSINSEL          = 0x20000 // Bit TSINSEL.
	RTC_TAFCR_TAMP1INSEL_Pos   = 0x10    // Position of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Msk   = 0x10000 // Bit mask of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL       = 0x10000 // Bit TAMP1INSEL.
	RTC_TAFCR_TAMPPUDIS_Pos    = 0xf     // Position of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Msk    = 0x8000  // Bit mask of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS        = 0x8000  // Bit TAMPPUDIS.
	RTC_TAFCR_TAMPPRCH_Pos     = 0xd     // Position of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Msk     = 0x6000  // Bit mask of TAMPPRCH field.
	RTC_TAFCR_TAMPFLT_Pos      = 0xb     // Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk      = 0x1800  // Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPFREQ_Pos     = 0x8     // Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk     = 0x700   // Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPTS_Pos       = 0x7     // Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk       = 0x80    // Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS           = 0x80    // Bit TAMPTS.
	RTC_TAFCR_TAMP2TRG_Pos     = 0x4     // Position of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Msk     = 0x10    // Bit mask of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG         = 0x10    // Bit TAMP2TRG.
	RTC_TAFCR_TAMP2E_Pos       = 0x3     // Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk       = 0x8     // Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E           = 0x8     // Bit TAMP2E.
	RTC_TAFCR_TAMPIE_Pos       = 0x2     // Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk       = 0x4     // Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE           = 0x4     // Bit TAMPIE.
	RTC_TAFCR_TAMP1TRG_Pos     = 0x1     // Position of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Msk     = 0x2     // Bit mask of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG         = 0x2     // Bit TAMP1TRG.
	RTC_TAFCR_TAMP1E_Pos       = 0x0     // Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk       = 0x1     // Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E           = 0x1     // Bit TAMP1E.

	// ALRMASSR: alarm A sub second register
	RTC_ALRMASSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMASSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMASSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// ALRMBSSR: alarm B sub second register
	RTC_ALRMBSSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMBSSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMBSSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// BKP0R: backup register
	RTC_BKP0R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP0R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP1R: backup register
	RTC_BKP1R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP1R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP2R: backup register
	RTC_BKP2R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP2R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP3R: backup register
	RTC_BKP3R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP3R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP4R: backup register
	RTC_BKP4R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP4R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP5R: backup register
	RTC_BKP5R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP5R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP6R: backup register
	RTC_BKP6R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP6R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP7R: backup register
	RTC_BKP7R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP7R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP8R: backup register
	RTC_BKP8R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP8R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP9R: backup register
	RTC_BKP9R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP9R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP10R: backup register
	RTC_BKP10R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP10R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP11R: backup register
	RTC_BKP11R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP11R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP12R: backup register
	RTC_BKP12R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP12R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP13R: backup register
	RTC_BKP13R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP13R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP14R: backup register
	RTC_BKP14R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP14R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP15R: backup register
	RTC_BKP15R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP15R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP16R: backup register
	RTC_BKP16R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP16R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP17R: backup register
	RTC_BKP17R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP17R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP18R: backup register
	RTC_BKP18R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP18R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP19R: backup register
	RTC_BKP19R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP19R_BKP_Msk = 0xffffffff // Bit mask of BKP field.
)

// Bitfields for TIM1: Advanced-timers
const (
	// CR1: control register 1
	TIM_CR1_CKD_Pos  = 0x8   // Position of CKD field.
	TIM_CR1_CKD_Msk  = 0x300 // Bit mask of CKD field.
	TIM_CR1_ARPE_Pos = 0x7   // Position of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80  // Bit mask of ARPE field.
	TIM_CR1_ARPE     = 0x80  // Bit ARPE.
	TIM_CR1_CMS_Pos  = 0x5   // Position of CMS field.
	TIM_CR1_CMS_Msk  = 0x60  // Bit mask of CMS field.
	TIM_CR1_DIR_Pos  = 0x4   // Position of DIR field.
	TIM_CR1_DIR_Msk  = 0x10  // Bit mask of DIR field.
	TIM_CR1_DIR      = 0x10  // Bit DIR.
	TIM_CR1_OPM_Pos  = 0x3   // Position of OPM field.
	TIM_CR1_OPM_Msk  = 0x8   // Bit mask of OPM field.
	TIM_CR1_OPM      = 0x8   // Bit OPM.
	TIM_CR1_URS_Pos  = 0x2   // Position of URS field.
	TIM_CR1_URS_Msk  = 0x4   // Bit mask of URS field.
	TIM_CR1_URS      = 0x4   // Bit URS.
	TIM_CR1_UDIS_Pos = 0x1   // Position of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2   // Bit mask of UDIS field.
	TIM_CR1_UDIS     = 0x2   // Bit UDIS.
	TIM_CR1_CEN_Pos  = 0x0   // Position of CEN field.
	TIM_CR1_CEN_Msk  = 0x1   // Bit mask of CEN field.
	TIM_CR1_CEN      = 0x1   // Bit CEN.

	// CR2: control register 2
	TIM_CR2_OIS4_Pos  = 0xe    // Position of OIS4 field.
	TIM_CR2_OIS4_Msk  = 0x4000 // Bit mask of OIS4 field.
	TIM_CR2_OIS4      = 0x4000 // Bit OIS4.
	TIM_CR2_OIS3N_Pos = 0xd    // Position of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000 // Bit mask of OIS3N field.
	TIM_CR2_OIS3N     = 0x2000 // Bit OIS3N.
	TIM_CR2_OIS3_Pos  = 0xc    // Position of OIS3 field.
	TIM_CR2_OIS3_Msk  = 0x1000 // Bit mask of OIS3 field.
	TIM_CR2_OIS3      = 0x1000 // Bit OIS3.
	TIM_CR2_OIS2N_Pos = 0xb    // Position of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800  // Bit mask of OIS2N field.
	TIM_CR2_OIS2N     = 0x800  // Bit OIS2N.
	TIM_CR2_OIS2_Pos  = 0xa    // Position of OIS2 field.
	TIM_CR2_OIS2_Msk  = 0x400  // Bit mask of OIS2 field.
	TIM_CR2_OIS2      = 0x400  // Bit OIS2.
	TIM_CR2_OIS1N_Pos = 0x9    // Position of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200  // Bit mask of OIS1N field.
	TIM_CR2_OIS1N     = 0x200  // Bit OIS1N.
	TIM_CR2_OIS1_Pos  = 0x8    // Position of OIS1 field.
	TIM_CR2_OIS1_Msk  = 0x100  // Bit mask of OIS1 field.
	TIM_CR2_OIS1      = 0x100  // Bit OIS1.
	TIM_CR2_TI1S_Pos  = 0x7    // Position of TI1S field.
	TIM_CR2_TI1S_Msk  = 0x80   // Bit mask of TI1S field.
	TIM_CR2_TI1S      = 0x80   // Bit TI1S.
	TIM_CR2_MMS_Pos   = 0x4    // Position of MMS field.
	TIM_CR2_MMS_Msk   = 0x70   // Bit mask of MMS field.
	TIM_CR2_CCDS_Pos  = 0x3    // Position of CCDS field.
	TIM_CR2_CCDS_Msk  = 0x8    // Bit mask of CCDS field.
	TIM_CR2_CCDS      = 0x8    // Bit CCDS.
	TIM_CR2_CCUS_Pos  = 0x2    // Position of CCUS field.
	TIM_CR2_CCUS_Msk  = 0x4    // Bit mask of CCUS field.
	TIM_CR2_CCUS      = 0x4    // Bit CCUS.
	TIM_CR2_CCPC_Pos  = 0x0    // Position of CCPC field.
	TIM_CR2_CCPC_Msk  = 0x1    // Bit mask of CCPC field.
	TIM_CR2_CCPC      = 0x1    // Bit CCPC.

	// SMCR: slave mode control register
	TIM_SMCR_ETP_Pos  = 0xf    // Position of ETP field.
	TIM_SMCR_ETP_Msk  = 0x8000 // Bit mask of ETP field.
	TIM_SMCR_ETP      = 0x8000 // Bit ETP.
	TIM_SMCR_ECE_Pos  = 0xe    // Position of ECE field.
	TIM_SMCR_ECE_Msk  = 0x4000 // Bit mask of ECE field.
	TIM_SMCR_ECE      = 0x4000 // Bit ECE.
	TIM_SMCR_ETPS_Pos = 0xc    // Position of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000 // Bit mask of ETPS field.
	TIM_SMCR_ETF_Pos  = 0x8    // Position of ETF field.
	TIM_SMCR_ETF_Msk  = 0xf00  // Bit mask of ETF field.
	TIM_SMCR_MSM_Pos  = 0x7    // Position of MSM field.
	TIM_SMCR_MSM_Msk  = 0x80   // Bit mask of MSM field.
	TIM_SMCR_MSM      = 0x80   // Bit MSM.
	TIM_SMCR_TS_Pos   = 0x4    // Position of TS field.
	TIM_SMCR_TS_Msk   = 0x70   // Bit mask of TS field.
	TIM_SMCR_SMS_Pos  = 0x0    // Position of SMS field.
	TIM_SMCR_SMS_Msk  = 0x7    // Bit mask of SMS field.

	// DIER: DMA/Interrupt enable register
	TIM_DIER_TDE_Pos   = 0xe    // Position of TDE field.
	TIM_DIER_TDE_Msk   = 0x4000 // Bit mask of TDE field.
	TIM_DIER_TDE       = 0x4000 // Bit TDE.
	TIM_DIER_COMDE_Pos = 0xd    // Position of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000 // Bit mask of COMDE field.
	TIM_DIER_COMDE     = 0x2000 // Bit COMDE.
	TIM_DIER_CC4DE_Pos = 0xc    // Position of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000 // Bit mask of CC4DE field.
	TIM_DIER_CC4DE     = 0x1000 // Bit CC4DE.
	TIM_DIER_CC3DE_Pos = 0xb    // Position of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800  // Bit mask of CC3DE field.
	TIM_DIER_CC3DE     = 0x800  // Bit CC3DE.
	TIM_DIER_CC2DE_Pos = 0xa    // Position of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400  // Bit mask of CC2DE field.
	TIM_DIER_CC2DE     = 0x400  // Bit CC2DE.
	TIM_DIER_CC1DE_Pos = 0x9    // Position of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200  // Bit mask of CC1DE field.
	TIM_DIER_CC1DE     = 0x200  // Bit CC1DE.
	TIM_DIER_UDE_Pos   = 0x8    // Position of UDE field.
	TIM_DIER_UDE_Msk   = 0x100  // Bit mask of UDE field.
	TIM_DIER_UDE       = 0x100  // Bit UDE.
	TIM_DIER_TIE_Pos   = 0x6    // Position of TIE field.
	TIM_DIER_TIE_Msk   = 0x40   // Bit mask of TIE field.
	TIM_DIER_TIE       = 0x40   // Bit TIE.
	TIM_DIER_CC4IE_Pos = 0x4    // Position of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10   // Bit mask of CC4IE field.
	TIM_DIER_CC4IE     = 0x10   // Bit CC4IE.
	TIM_DIER_CC3IE_Pos = 0x3    // Position of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8    // Bit mask of CC3IE field.
	TIM_DIER_CC3IE     = 0x8    // Bit CC3IE.
	TIM_DIER_CC2IE_Pos = 0x2    // Position of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4    // Bit mask of CC2IE field.
	TIM_DIER_CC2IE     = 0x4    // Bit CC2IE.
	TIM_DIER_CC1IE_Pos = 0x1    // Position of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2    // Bit mask of CC1IE field.
	TIM_DIER_CC1IE     = 0x2    // Bit CC1IE.
	TIM_DIER_UIE_Pos   = 0x0    // Position of UIE field.
	TIM_DIER_UIE_Msk   = 0x1    // Bit mask of UIE field.
	TIM_DIER_UIE       = 0x1    // Bit UIE.
	TIM_DIER_BIE_Pos   = 0x7    // Position of BIE field.
	TIM_DIER_BIE_Msk   = 0x80   // Bit mask of BIE field.
	TIM_DIER_BIE       = 0x80   // Bit BIE.
	TIM_DIER_COMIE_Pos = 0x5    // Position of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20   // Bit mask of COMIE field.
	TIM_DIER_COMIE     = 0x20   // Bit COMIE.

	// SR: status register
	TIM_SR_CC4OF_Pos = 0xc    // Position of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000 // Bit mask of CC4OF field.
	TIM_SR_CC4OF     = 0x1000 // Bit CC4OF.
	TIM_SR_CC3OF_Pos = 0xb    // Position of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800  // Bit mask of CC3OF field.
	TIM_SR_CC3OF     = 0x800  // Bit CC3OF.
	TIM_SR_CC2OF_Pos = 0xa    // Position of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400  // Bit mask of CC2OF field.
	TIM_SR_CC2OF     = 0x400  // Bit CC2OF.
	TIM_SR_CC1OF_Pos = 0x9    // Position of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200  // Bit mask of CC1OF field.
	TIM_SR_CC1OF     = 0x200  // Bit CC1OF.
	TIM_SR_BIF_Pos   = 0x7    // Position of BIF field.
	TIM_SR_BIF_Msk   = 0x80   // Bit mask of BIF field.
	TIM_SR_BIF       = 0x80   // Bit BIF.
	TIM_SR_TIF_Pos   = 0x6    // Position of TIF field.
	TIM_SR_TIF_Msk   = 0x40   // Bit mask of TIF field.
	TIM_SR_TIF       = 0x40   // Bit TIF.
	TIM_SR_COMIF_Pos = 0x5    // Position of COMIF field.
	TIM_SR_COMIF_Msk = 0x20   // Bit mask of COMIF field.
	TIM_SR_COMIF     = 0x20   // Bit COMIF.
	TIM_SR_CC4IF_Pos = 0x4    // Position of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10   // Bit mask of CC4IF field.
	TIM_SR_CC4IF     = 0x10   // Bit CC4IF.
	TIM_SR_CC3IF_Pos = 0x3    // Position of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8    // Bit mask of CC3IF field.
	TIM_SR_CC3IF     = 0x8    // Bit CC3IF.
	TIM_SR_CC2IF_Pos = 0x2    // Position of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4    // Bit mask of CC2IF field.
	TIM_SR_CC2IF     = 0x4    // Bit CC2IF.
	TIM_SR_CC1IF_Pos = 0x1    // Position of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2    // Bit mask of CC1IF field.
	TIM_SR_CC1IF     = 0x2    // Bit CC1IF.
	TIM_SR_UIF_Pos   = 0x0    // Position of UIF field.
	TIM_SR_UIF_Msk   = 0x1    // Bit mask of UIF field.
	TIM_SR_UIF       = 0x1    // Bit UIF.

	// EGR: event generation register
	TIM_EGR_BG_Pos   = 0x7  // Position of BG field.
	TIM_EGR_BG_Msk   = 0x80 // Bit mask of BG field.
	TIM_EGR_BG       = 0x80 // Bit BG.
	TIM_EGR_TG_Pos   = 0x6  // Position of TG field.
	TIM_EGR_TG_Msk   = 0x40 // Bit mask of TG field.
	TIM_EGR_TG       = 0x40 // Bit TG.
	TIM_EGR_COMG_Pos = 0x5  // Position of COMG field.
	TIM_EGR_COMG_Msk = 0x20 // Bit mask of COMG field.
	TIM_EGR_COMG     = 0x20 // Bit COMG.
	TIM_EGR_CC4G_Pos = 0x4  // Position of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10 // Bit mask of CC4G field.
	TIM_EGR_CC4G     = 0x10 // Bit CC4G.
	TIM_EGR_CC3G_Pos = 0x3  // Position of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8  // Bit mask of CC3G field.
	TIM_EGR_CC3G     = 0x8  // Bit CC3G.
	TIM_EGR_CC2G_Pos = 0x2  // Position of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4  // Bit mask of CC2G field.
	TIM_EGR_CC2G     = 0x4  // Bit CC2G.
	TIM_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIM_EGR_CC1G     = 0x2  // Bit CC1G.
	TIM_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIM_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIM_EGR_UG       = 0x1  // Bit UG.

	// CCMR1_Output: capture/compare mode register 1 (output           mode)
	TIM_CCMR1_Output_OC2CE_Pos = 0xf    // Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000 // Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE     = 0x8000 // Bit OC2CE.
	TIM_CCMR1_Output_OC2M_Pos  = 0xc    // Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk  = 0x7000 // Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb    // Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800  // Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE     = 0x800  // Bit OC2PE.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa    // Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400  // Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE     = 0x400  // Bit OC2FE.
	TIM_CCMR1_Output_CC2S_Pos  = 0x8    // Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk  = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7    // Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80   // Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE     = 0x80   // Bit OC1CE.
	TIM_CCMR1_Output_OC1M_Pos  = 0x4    // Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk  = 0x70   // Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3    // Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8    // Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE     = 0x8    // Bit OC1PE.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2    // Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4    // Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE     = 0x4    // Bit OC1FE.
	TIM_CCMR1_Output_CC1S_Pos  = 0x0    // Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk  = 0x3    // Bit mask of CC1S field.

	// CCMR1_Input: capture/compare mode register 1 (input           mode)
	TIM_CCMR1_Input_IC2F_Pos   = 0xc    // Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk   = 0xf000 // Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2PCS_Pos = 0xa    // Position of IC2PCS field.
	TIM_CCMR1_Input_IC2PCS_Msk = 0xc00  // Bit mask of IC2PCS field.
	TIM_CCMR1_Input_CC2S_Pos   = 0x8    // Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk   = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Input_IC1F_Pos   = 0x4    // Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk   = 0xf0   // Bit mask of IC1F field.
	TIM_CCMR1_Input_ICPCS_Pos  = 0x2    // Position of ICPCS field.
	TIM_CCMR1_Input_ICPCS_Msk  = 0xc    // Bit mask of ICPCS field.
	TIM_CCMR1_Input_CC1S_Pos   = 0x0    // Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk   = 0x3    // Bit mask of CC1S field.

	// CCMR2_Output: capture/compare mode register 2 (output           mode)
	TIM_CCMR2_Output_OC4CE_Pos = 0xf    // Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000 // Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE     = 0x8000 // Bit OC4CE.
	TIM_CCMR2_Output_OC4M_Pos  = 0xc    // Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk  = 0x7000 // Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb    // Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800  // Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE     = 0x800  // Bit OC4PE.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa    // Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400  // Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE     = 0x400  // Bit OC4FE.
	TIM_CCMR2_Output_CC4S_Pos  = 0x8    // Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk  = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7    // Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80   // Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE     = 0x80   // Bit OC3CE.
	TIM_CCMR2_Output_OC3M_Pos  = 0x4    // Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk  = 0x70   // Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3    // Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8    // Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE     = 0x8    // Bit OC3PE.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2    // Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4    // Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE     = 0x4    // Bit OC3FE.
	TIM_CCMR2_Output_CC3S_Pos  = 0x0    // Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk  = 0x3    // Bit mask of CC3S field.

	// CCMR2_Input: capture/compare mode register 2 (input           mode)
	TIM_CCMR2_Input_IC4F_Pos   = 0xc    // Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk   = 0xf000 // Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa    // Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00  // Bit mask of IC4PSC field.
	TIM_CCMR2_Input_CC4S_Pos   = 0x8    // Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk   = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Input_IC3F_Pos   = 0x4    // Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk   = 0xf0   // Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2    // Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc    // Bit mask of IC3PSC field.
	TIM_CCMR2_Input_CC3S_Pos   = 0x0    // Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk   = 0x3    // Bit mask of CC3S field.

	// CCER: capture/compare enable           register
	TIM_CCER_CC4P_Pos  = 0xd    // Position of CC4P field.
	TIM_CCER_CC4P_Msk  = 0x2000 // Bit mask of CC4P field.
	TIM_CCER_CC4P      = 0x2000 // Bit CC4P.
	TIM_CCER_CC4E_Pos  = 0xc    // Position of CC4E field.
	TIM_CCER_CC4E_Msk  = 0x1000 // Bit mask of CC4E field.
	TIM_CCER_CC4E      = 0x1000 // Bit CC4E.
	TIM_CCER_CC3NP_Pos = 0xb    // Position of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800  // Bit mask of CC3NP field.
	TIM_CCER_CC3NP     = 0x800  // Bit CC3NP.
	TIM_CCER_CC3NE_Pos = 0xa    // Position of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400  // Bit mask of CC3NE field.
	TIM_CCER_CC3NE     = 0x400  // Bit CC3NE.
	TIM_CCER_CC3P_Pos  = 0x9    // Position of CC3P field.
	TIM_CCER_CC3P_Msk  = 0x200  // Bit mask of CC3P field.
	TIM_CCER_CC3P      = 0x200  // Bit CC3P.
	TIM_CCER_CC3E_Pos  = 0x8    // Position of CC3E field.
	TIM_CCER_CC3E_Msk  = 0x100  // Bit mask of CC3E field.
	TIM_CCER_CC3E      = 0x100  // Bit CC3E.
	TIM_CCER_CC2NP_Pos = 0x7    // Position of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80   // Bit mask of CC2NP field.
	TIM_CCER_CC2NP     = 0x80   // Bit CC2NP.
	TIM_CCER_CC2NE_Pos = 0x6    // Position of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40   // Bit mask of CC2NE field.
	TIM_CCER_CC2NE     = 0x40   // Bit CC2NE.
	TIM_CCER_CC2P_Pos  = 0x5    // Position of CC2P field.
	TIM_CCER_CC2P_Msk  = 0x20   // Bit mask of CC2P field.
	TIM_CCER_CC2P      = 0x20   // Bit CC2P.
	TIM_CCER_CC2E_Pos  = 0x4    // Position of CC2E field.
	TIM_CCER_CC2E_Msk  = 0x10   // Bit mask of CC2E field.
	TIM_CCER_CC2E      = 0x10   // Bit CC2E.
	TIM_CCER_CC1NP_Pos = 0x3    // Position of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8    // Bit mask of CC1NP field.
	TIM_CCER_CC1NP     = 0x8    // Bit CC1NP.
	TIM_CCER_CC1NE_Pos = 0x2    // Position of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4    // Bit mask of CC1NE field.
	TIM_CCER_CC1NE     = 0x4    // Bit CC1NE.
	TIM_CCER_CC1P_Pos  = 0x1    // Position of CC1P field.
	TIM_CCER_CC1P_Msk  = 0x2    // Bit mask of CC1P field.
	TIM_CCER_CC1P      = 0x2    // Bit CC1P.
	TIM_CCER_CC1E_Pos  = 0x0    // Position of CC1E field.
	TIM_CCER_CC1E_Msk  = 0x1    // Bit mask of CC1E field.
	TIM_CCER_CC1E      = 0x1    // Bit CC1E.

	// CNT: counter
	TIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	TIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.

	// PSC: prescaler
	TIM_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: auto-reload register
	TIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	TIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// RCR: repetition counter register
	TIM_RCR_REP_Pos = 0x0  // Position of REP field.
	TIM_RCR_REP_Msk = 0xff // Bit mask of REP field.

	// CCR1: capture/compare register 1
	TIM_CCR1_CCR1_Pos = 0x0    // Position of CCR1 field.
	TIM_CCR1_CCR1_Msk = 0xffff // Bit mask of CCR1 field.

	// CCR2: capture/compare register 2
	TIM_CCR2_CCR2_Pos = 0x0    // Position of CCR2 field.
	TIM_CCR2_CCR2_Msk = 0xffff // Bit mask of CCR2 field.

	// CCR3: capture/compare register 3
	TIM_CCR3_CCR3_Pos = 0x0    // Position of CCR3 field.
	TIM_CCR3_CCR3_Msk = 0xffff // Bit mask of CCR3 field.

	// CCR4: capture/compare register 4
	TIM_CCR4_CCR4_Pos = 0x0    // Position of CCR4 field.
	TIM_CCR4_CCR4_Msk = 0xffff // Bit mask of CCR4 field.

	// BDTR: break and dead-time register
	TIM_BDTR_MOE_Pos  = 0xf    // Position of MOE field.
	TIM_BDTR_MOE_Msk  = 0x8000 // Bit mask of MOE field.
	TIM_BDTR_MOE      = 0x8000 // Bit MOE.
	TIM_BDTR_AOE_Pos  = 0xe    // Position of AOE field.
	TIM_BDTR_AOE_Msk  = 0x4000 // Bit mask of AOE field.
	TIM_BDTR_AOE      = 0x4000 // Bit AOE.
	TIM_BDTR_BKP_Pos  = 0xd    // Position of BKP field.
	TIM_BDTR_BKP_Msk  = 0x2000 // Bit mask of BKP field.
	TIM_BDTR_BKP      = 0x2000 // Bit BKP.
	TIM_BDTR_BKE_Pos  = 0xc    // Position of BKE field.
	TIM_BDTR_BKE_Msk  = 0x1000 // Bit mask of BKE field.
	TIM_BDTR_BKE      = 0x1000 // Bit BKE.
	TIM_BDTR_OSSR_Pos = 0xb    // Position of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800  // Bit mask of OSSR field.
	TIM_BDTR_OSSR     = 0x800  // Bit OSSR.
	TIM_BDTR_OSSI_Pos = 0xa    // Position of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400  // Bit mask of OSSI field.
	TIM_BDTR_OSSI     = 0x400  // Bit OSSI.
	TIM_BDTR_LOCK_Pos = 0x8    // Position of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300  // Bit mask of LOCK field.
	TIM_BDTR_DTG_Pos  = 0x0    // Position of DTG field.
	TIM_BDTR_DTG_Msk  = 0xff   // Bit mask of DTG field.

	// DCR: DMA control register
	TIM_DCR_DBL_Pos = 0x8    // Position of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00 // Bit mask of DBL field.
	TIM_DCR_DBA_Pos = 0x0    // Position of DBA field.
	TIM_DCR_DBA_Msk = 0x1f   // Bit mask of DBA field.

	// DMAR: DMA address for full transfer
	TIM_DMAR_DMAB_Pos = 0x0    // Position of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff // Bit mask of DMAB field.
)

// Bitfields for CRC: Cryptographic processor
const (
	// DR: Data register
	CRC_DR_DR_Pos = 0x0        // Position of DR field.
	CRC_DR_DR_Msk = 0xffffffff // Bit mask of DR field.

	// IDR: Independent Data register
	CRC_IDR_IDR_Pos = 0x0  // Position of IDR field.
	CRC_IDR_IDR_Msk = 0xff // Bit mask of IDR field.

	// CR: Control register
	CRC_CR_CR_Pos = 0x0 // Position of CR field.
	CRC_CR_CR_Msk = 0x1 // Bit mask of CR field.
	CRC_CR_CR     = 0x1 // Bit CR.
)

// Bitfields for OTG_FS_GLOBAL: USB on the go full speed
const (
	// FS_GOTGCTL: OTG_FS control and status register           (OTG_FS_GOTGCTL)
	USB_OTG_FS_FS_GOTGCTL_SRQSCS_Pos  = 0x0     // Position of SRQSCS field.
	USB_OTG_FS_FS_GOTGCTL_SRQSCS_Msk  = 0x1     // Bit mask of SRQSCS field.
	USB_OTG_FS_FS_GOTGCTL_SRQSCS      = 0x1     // Bit SRQSCS.
	USB_OTG_FS_FS_GOTGCTL_SRQ_Pos     = 0x1     // Position of SRQ field.
	USB_OTG_FS_FS_GOTGCTL_SRQ_Msk     = 0x2     // Bit mask of SRQ field.
	USB_OTG_FS_FS_GOTGCTL_SRQ         = 0x2     // Bit SRQ.
	USB_OTG_FS_FS_GOTGCTL_HNGSCS_Pos  = 0x8     // Position of HNGSCS field.
	USB_OTG_FS_FS_GOTGCTL_HNGSCS_Msk  = 0x100   // Bit mask of HNGSCS field.
	USB_OTG_FS_FS_GOTGCTL_HNGSCS      = 0x100   // Bit HNGSCS.
	USB_OTG_FS_FS_GOTGCTL_HNPRQ_Pos   = 0x9     // Position of HNPRQ field.
	USB_OTG_FS_FS_GOTGCTL_HNPRQ_Msk   = 0x200   // Bit mask of HNPRQ field.
	USB_OTG_FS_FS_GOTGCTL_HNPRQ       = 0x200   // Bit HNPRQ.
	USB_OTG_FS_FS_GOTGCTL_HSHNPEN_Pos = 0xa     // Position of HSHNPEN field.
	USB_OTG_FS_FS_GOTGCTL_HSHNPEN_Msk = 0x400   // Bit mask of HSHNPEN field.
	USB_OTG_FS_FS_GOTGCTL_HSHNPEN     = 0x400   // Bit HSHNPEN.
	USB_OTG_FS_FS_GOTGCTL_DHNPEN_Pos  = 0xb     // Position of DHNPEN field.
	USB_OTG_FS_FS_GOTGCTL_DHNPEN_Msk  = 0x800   // Bit mask of DHNPEN field.
	USB_OTG_FS_FS_GOTGCTL_DHNPEN      = 0x800   // Bit DHNPEN.
	USB_OTG_FS_FS_GOTGCTL_CIDSTS_Pos  = 0x10    // Position of CIDSTS field.
	USB_OTG_FS_FS_GOTGCTL_CIDSTS_Msk  = 0x10000 // Bit mask of CIDSTS field.
	USB_OTG_FS_FS_GOTGCTL_CIDSTS      = 0x10000 // Bit CIDSTS.
	USB_OTG_FS_FS_GOTGCTL_DBCT_Pos    = 0x11    // Position of DBCT field.
	USB_OTG_FS_FS_GOTGCTL_DBCT_Msk    = 0x20000 // Bit mask of DBCT field.
	USB_OTG_FS_FS_GOTGCTL_DBCT        = 0x20000 // Bit DBCT.
	USB_OTG_FS_FS_GOTGCTL_ASVLD_Pos   = 0x12    // Position of ASVLD field.
	USB_OTG_FS_FS_GOTGCTL_ASVLD_Msk   = 0x40000 // Bit mask of ASVLD field.
	USB_OTG_FS_FS_GOTGCTL_ASVLD       = 0x40000 // Bit ASVLD.
	USB_OTG_FS_FS_GOTGCTL_BSVLD_Pos   = 0x13    // Position of BSVLD field.
	USB_OTG_FS_FS_GOTGCTL_BSVLD_Msk   = 0x80000 // Bit mask of BSVLD field.
	USB_OTG_FS_FS_GOTGCTL_BSVLD       = 0x80000 // Bit BSVLD.

	// FS_GOTGINT: OTG_FS interrupt register           (OTG_FS_GOTGINT)
	USB_OTG_FS_FS_GOTGINT_SEDET_Pos   = 0x2     // Position of SEDET field.
	USB_OTG_FS_FS_GOTGINT_SEDET_Msk   = 0x4     // Bit mask of SEDET field.
	USB_OTG_FS_FS_GOTGINT_SEDET       = 0x4     // Bit SEDET.
	USB_OTG_FS_FS_GOTGINT_SRSSCHG_Pos = 0x8     // Position of SRSSCHG field.
	USB_OTG_FS_FS_GOTGINT_SRSSCHG_Msk = 0x100   // Bit mask of SRSSCHG field.
	USB_OTG_FS_FS_GOTGINT_SRSSCHG     = 0x100   // Bit SRSSCHG.
	USB_OTG_FS_FS_GOTGINT_HNSSCHG_Pos = 0x9     // Position of HNSSCHG field.
	USB_OTG_FS_FS_GOTGINT_HNSSCHG_Msk = 0x200   // Bit mask of HNSSCHG field.
	USB_OTG_FS_FS_GOTGINT_HNSSCHG     = 0x200   // Bit HNSSCHG.
	USB_OTG_FS_FS_GOTGINT_HNGDET_Pos  = 0x11    // Position of HNGDET field.
	USB_OTG_FS_FS_GOTGINT_HNGDET_Msk  = 0x20000 // Bit mask of HNGDET field.
	USB_OTG_FS_FS_GOTGINT_HNGDET      = 0x20000 // Bit HNGDET.
	USB_OTG_FS_FS_GOTGINT_ADTOCHG_Pos = 0x12    // Position of ADTOCHG field.
	USB_OTG_FS_FS_GOTGINT_ADTOCHG_Msk = 0x40000 // Bit mask of ADTOCHG field.
	USB_OTG_FS_FS_GOTGINT_ADTOCHG     = 0x40000 // Bit ADTOCHG.
	USB_OTG_FS_FS_GOTGINT_DBCDNE_Pos  = 0x13    // Position of DBCDNE field.
	USB_OTG_FS_FS_GOTGINT_DBCDNE_Msk  = 0x80000 // Bit mask of DBCDNE field.
	USB_OTG_FS_FS_GOTGINT_DBCDNE      = 0x80000 // Bit DBCDNE.

	// FS_GAHBCFG: OTG_FS AHB configuration register           (OTG_FS_GAHBCFG)
	USB_OTG_FS_FS_GAHBCFG_GINT_Pos     = 0x0   // Position of GINT field.
	USB_OTG_FS_FS_GAHBCFG_GINT_Msk     = 0x1   // Bit mask of GINT field.
	USB_OTG_FS_FS_GAHBCFG_GINT         = 0x1   // Bit GINT.
	USB_OTG_FS_FS_GAHBCFG_TXFELVL_Pos  = 0x7   // Position of TXFELVL field.
	USB_OTG_FS_FS_GAHBCFG_TXFELVL_Msk  = 0x80  // Bit mask of TXFELVL field.
	USB_OTG_FS_FS_GAHBCFG_TXFELVL      = 0x80  // Bit TXFELVL.
	USB_OTG_FS_FS_GAHBCFG_PTXFELVL_Pos = 0x8   // Position of PTXFELVL field.
	USB_OTG_FS_FS_GAHBCFG_PTXFELVL_Msk = 0x100 // Bit mask of PTXFELVL field.
	USB_OTG_FS_FS_GAHBCFG_PTXFELVL     = 0x100 // Bit PTXFELVL.

	// FS_GUSBCFG: OTG_FS USB configuration register           (OTG_FS_GUSBCFG)
	USB_OTG_FS_FS_GUSBCFG_TOCAL_Pos  = 0x0        // Position of TOCAL field.
	USB_OTG_FS_FS_GUSBCFG_TOCAL_Msk  = 0x7        // Bit mask of TOCAL field.
	USB_OTG_FS_FS_GUSBCFG_PHYSEL_Pos = 0x6        // Position of PHYSEL field.
	USB_OTG_FS_FS_GUSBCFG_PHYSEL_Msk = 0x40       // Bit mask of PHYSEL field.
	USB_OTG_FS_FS_GUSBCFG_PHYSEL     = 0x40       // Bit PHYSEL.
	USB_OTG_FS_FS_GUSBCFG_SRPCAP_Pos = 0x8        // Position of SRPCAP field.
	USB_OTG_FS_FS_GUSBCFG_SRPCAP_Msk = 0x100      // Bit mask of SRPCAP field.
	USB_OTG_FS_FS_GUSBCFG_SRPCAP     = 0x100      // Bit SRPCAP.
	USB_OTG_FS_FS_GUSBCFG_HNPCAP_Pos = 0x9        // Position of HNPCAP field.
	USB_OTG_FS_FS_GUSBCFG_HNPCAP_Msk = 0x200      // Bit mask of HNPCAP field.
	USB_OTG_FS_FS_GUSBCFG_HNPCAP     = 0x200      // Bit HNPCAP.
	USB_OTG_FS_FS_GUSBCFG_TRDT_Pos   = 0xa        // Position of TRDT field.
	USB_OTG_FS_FS_GUSBCFG_TRDT_Msk   = 0x3c00     // Bit mask of TRDT field.
	USB_OTG_FS_FS_GUSBCFG_FHMOD_Pos  = 0x1d       // Position of FHMOD field.
	USB_OTG_FS_FS_GUSBCFG_FHMOD_Msk  = 0x20000000 // Bit mask of FHMOD field.
	USB_OTG_FS_FS_GUSBCFG_FHMOD      = 0x20000000 // Bit FHMOD.
	USB_OTG_FS_FS_GUSBCFG_FDMOD_Pos  = 0x1e       // Position of FDMOD field.
	USB_OTG_FS_FS_GUSBCFG_FDMOD_Msk  = 0x40000000 // Bit mask of FDMOD field.
	USB_OTG_FS_FS_GUSBCFG_FDMOD      = 0x40000000 // Bit FDMOD.
	USB_OTG_FS_FS_GUSBCFG_CTXPKT_Pos = 0x1f       // Position of CTXPKT field.
	USB_OTG_FS_FS_GUSBCFG_CTXPKT_Msk = 0x80000000 // Bit mask of CTXPKT field.
	USB_OTG_FS_FS_GUSBCFG_CTXPKT     = 0x80000000 // Bit CTXPKT.

	// FS_GRSTCTL: OTG_FS reset register           (OTG_FS_GRSTCTL)
	USB_OTG_FS_FS_GRSTCTL_CSRST_Pos   = 0x0        // Position of CSRST field.
	USB_OTG_FS_FS_GRSTCTL_CSRST_Msk   = 0x1        // Bit mask of CSRST field.
	USB_OTG_FS_FS_GRSTCTL_CSRST       = 0x1        // Bit CSRST.
	USB_OTG_FS_FS_GRSTCTL_HSRST_Pos   = 0x1        // Position of HSRST field.
	USB_OTG_FS_FS_GRSTCTL_HSRST_Msk   = 0x2        // Bit mask of HSRST field.
	USB_OTG_FS_FS_GRSTCTL_HSRST       = 0x2        // Bit HSRST.
	USB_OTG_FS_FS_GRSTCTL_FCRST_Pos   = 0x2        // Position of FCRST field.
	USB_OTG_FS_FS_GRSTCTL_FCRST_Msk   = 0x4        // Bit mask of FCRST field.
	USB_OTG_FS_FS_GRSTCTL_FCRST       = 0x4        // Bit FCRST.
	USB_OTG_FS_FS_GRSTCTL_RXFFLSH_Pos = 0x4        // Position of RXFFLSH field.
	USB_OTG_FS_FS_GRSTCTL_RXFFLSH_Msk = 0x10       // Bit mask of RXFFLSH field.
	USB_OTG_FS_FS_GRSTCTL_RXFFLSH     = 0x10       // Bit RXFFLSH.
	USB_OTG_FS_FS_GRSTCTL_TXFFLSH_Pos = 0x5        // Position of TXFFLSH field.
	USB_OTG_FS_FS_GRSTCTL_TXFFLSH_Msk = 0x20       // Bit mask of TXFFLSH field.
	USB_OTG_FS_FS_GRSTCTL_TXFFLSH     = 0x20       // Bit TXFFLSH.
	USB_OTG_FS_FS_GRSTCTL_TXFNUM_Pos  = 0x6        // Position of TXFNUM field.
	USB_OTG_FS_FS_GRSTCTL_TXFNUM_Msk  = 0x7c0      // Bit mask of TXFNUM field.
	USB_OTG_FS_FS_GRSTCTL_AHBIDL_Pos  = 0x1f       // Position of AHBIDL field.
	USB_OTG_FS_FS_GRSTCTL_AHBIDL_Msk  = 0x80000000 // Bit mask of AHBIDL field.
	USB_OTG_FS_FS_GRSTCTL_AHBIDL      = 0x80000000 // Bit AHBIDL.

	// FS_GINTSTS: OTG_FS core interrupt register           (OTG_FS_GINTSTS)
	USB_OTG_FS_FS_GINTSTS_CMOD_Pos               = 0x0        // Position of CMOD field.
	USB_OTG_FS_FS_GINTSTS_CMOD_Msk               = 0x1        // Bit mask of CMOD field.
	USB_OTG_FS_FS_GINTSTS_CMOD                   = 0x1        // Bit CMOD.
	USB_OTG_FS_FS_GINTSTS_MMIS_Pos               = 0x1        // Position of MMIS field.
	USB_OTG_FS_FS_GINTSTS_MMIS_Msk               = 0x2        // Bit mask of MMIS field.
	USB_OTG_FS_FS_GINTSTS_MMIS                   = 0x2        // Bit MMIS.
	USB_OTG_FS_FS_GINTSTS_OTGINT_Pos             = 0x2        // Position of OTGINT field.
	USB_OTG_FS_FS_GINTSTS_OTGINT_Msk             = 0x4        // Bit mask of OTGINT field.
	USB_OTG_FS_FS_GINTSTS_OTGINT                 = 0x4        // Bit OTGINT.
	USB_OTG_FS_FS_GINTSTS_SOF_Pos                = 0x3        // Position of SOF field.
	USB_OTG_FS_FS_GINTSTS_SOF_Msk                = 0x8        // Bit mask of SOF field.
	USB_OTG_FS_FS_GINTSTS_SOF                    = 0x8        // Bit SOF.
	USB_OTG_FS_FS_GINTSTS_RXFLVL_Pos             = 0x4        // Position of RXFLVL field.
	USB_OTG_FS_FS_GINTSTS_RXFLVL_Msk             = 0x10       // Bit mask of RXFLVL field.
	USB_OTG_FS_FS_GINTSTS_RXFLVL                 = 0x10       // Bit RXFLVL.
	USB_OTG_FS_FS_GINTSTS_NPTXFE_Pos             = 0x5        // Position of NPTXFE field.
	USB_OTG_FS_FS_GINTSTS_NPTXFE_Msk             = 0x20       // Bit mask of NPTXFE field.
	USB_OTG_FS_FS_GINTSTS_NPTXFE                 = 0x20       // Bit NPTXFE.
	USB_OTG_FS_FS_GINTSTS_GINAKEFF_Pos           = 0x6        // Position of GINAKEFF field.
	USB_OTG_FS_FS_GINTSTS_GINAKEFF_Msk           = 0x40       // Bit mask of GINAKEFF field.
	USB_OTG_FS_FS_GINTSTS_GINAKEFF               = 0x40       // Bit GINAKEFF.
	USB_OTG_FS_FS_GINTSTS_GOUTNAKEFF_Pos         = 0x7        // Position of GOUTNAKEFF field.
	USB_OTG_FS_FS_GINTSTS_GOUTNAKEFF_Msk         = 0x80       // Bit mask of GOUTNAKEFF field.
	USB_OTG_FS_FS_GINTSTS_GOUTNAKEFF             = 0x80       // Bit GOUTNAKEFF.
	USB_OTG_FS_FS_GINTSTS_ESUSP_Pos              = 0xa        // Position of ESUSP field.
	USB_OTG_FS_FS_GINTSTS_ESUSP_Msk              = 0x400      // Bit mask of ESUSP field.
	USB_OTG_FS_FS_GINTSTS_ESUSP                  = 0x400      // Bit ESUSP.
	USB_OTG_FS_FS_GINTSTS_USBSUSP_Pos            = 0xb        // Position of USBSUSP field.
	USB_OTG_FS_FS_GINTSTS_USBSUSP_Msk            = 0x800      // Bit mask of USBSUSP field.
	USB_OTG_FS_FS_GINTSTS_USBSUSP                = 0x800      // Bit USBSUSP.
	USB_OTG_FS_FS_GINTSTS_USBRST_Pos             = 0xc        // Position of USBRST field.
	USB_OTG_FS_FS_GINTSTS_USBRST_Msk             = 0x1000     // Bit mask of USBRST field.
	USB_OTG_FS_FS_GINTSTS_USBRST                 = 0x1000     // Bit USBRST.
	USB_OTG_FS_FS_GINTSTS_ENUMDNE_Pos            = 0xd        // Position of ENUMDNE field.
	USB_OTG_FS_FS_GINTSTS_ENUMDNE_Msk            = 0x2000     // Bit mask of ENUMDNE field.
	USB_OTG_FS_FS_GINTSTS_ENUMDNE                = 0x2000     // Bit ENUMDNE.
	USB_OTG_FS_FS_GINTSTS_ISOODRP_Pos            = 0xe        // Position of ISOODRP field.
	USB_OTG_FS_FS_GINTSTS_ISOODRP_Msk            = 0x4000     // Bit mask of ISOODRP field.
	USB_OTG_FS_FS_GINTSTS_ISOODRP                = 0x4000     // Bit ISOODRP.
	USB_OTG_FS_FS_GINTSTS_EOPF_Pos               = 0xf        // Position of EOPF field.
	USB_OTG_FS_FS_GINTSTS_EOPF_Msk               = 0x8000     // Bit mask of EOPF field.
	USB_OTG_FS_FS_GINTSTS_EOPF                   = 0x8000     // Bit EOPF.
	USB_OTG_FS_FS_GINTSTS_IEPINT_Pos             = 0x12       // Position of IEPINT field.
	USB_OTG_FS_FS_GINTSTS_IEPINT_Msk             = 0x40000    // Bit mask of IEPINT field.
	USB_OTG_FS_FS_GINTSTS_IEPINT                 = 0x40000    // Bit IEPINT.
	USB_OTG_FS_FS_GINTSTS_OEPINT_Pos             = 0x13       // Position of OEPINT field.
	USB_OTG_FS_FS_GINTSTS_OEPINT_Msk             = 0x80000    // Bit mask of OEPINT field.
	USB_OTG_FS_FS_GINTSTS_OEPINT                 = 0x80000    // Bit OEPINT.
	USB_OTG_FS_FS_GINTSTS_IISOIXFR_Pos           = 0x14       // Position of IISOIXFR field.
	USB_OTG_FS_FS_GINTSTS_IISOIXFR_Msk           = 0x100000   // Bit mask of IISOIXFR field.
	USB_OTG_FS_FS_GINTSTS_IISOIXFR               = 0x100000   // Bit IISOIXFR.
	USB_OTG_FS_FS_GINTSTS_IPXFR_INCOMPISOOUT_Pos = 0x15       // Position of IPXFR_INCOMPISOOUT field.
	USB_OTG_FS_FS_GINTSTS_IPXFR_INCOMPISOOUT_Msk = 0x200000   // Bit mask of IPXFR_INCOMPISOOUT field.
	USB_OTG_FS_FS_GINTSTS_IPXFR_INCOMPISOOUT     = 0x200000   // Bit IPXFR_INCOMPISOOUT.
	USB_OTG_FS_FS_GINTSTS_HPRTINT_Pos            = 0x18       // Position of HPRTINT field.
	USB_OTG_FS_FS_GINTSTS_HPRTINT_Msk            = 0x1000000  // Bit mask of HPRTINT field.
	USB_OTG_FS_FS_GINTSTS_HPRTINT                = 0x1000000  // Bit HPRTINT.
	USB_OTG_FS_FS_GINTSTS_HCINT_Pos              = 0x19       // Position of HCINT field.
	USB_OTG_FS_FS_GINTSTS_HCINT_Msk              = 0x2000000  // Bit mask of HCINT field.
	USB_OTG_FS_FS_GINTSTS_HCINT                  = 0x2000000  // Bit HCINT.
	USB_OTG_FS_FS_GINTSTS_PTXFE_Pos              = 0x1a       // Position of PTXFE field.
	USB_OTG_FS_FS_GINTSTS_PTXFE_Msk              = 0x4000000  // Bit mask of PTXFE field.
	USB_OTG_FS_FS_GINTSTS_PTXFE                  = 0x4000000  // Bit PTXFE.
	USB_OTG_FS_FS_GINTSTS_CIDSCHG_Pos            = 0x1c       // Position of CIDSCHG field.
	USB_OTG_FS_FS_GINTSTS_CIDSCHG_Msk            = 0x10000000 // Bit mask of CIDSCHG field.
	USB_OTG_FS_FS_GINTSTS_CIDSCHG                = 0x10000000 // Bit CIDSCHG.
	USB_OTG_FS_FS_GINTSTS_DISCINT_Pos            = 0x1d       // Position of DISCINT field.
	USB_OTG_FS_FS_GINTSTS_DISCINT_Msk            = 0x20000000 // Bit mask of DISCINT field.
	USB_OTG_FS_FS_GINTSTS_DISCINT                = 0x20000000 // Bit DISCINT.
	USB_OTG_FS_FS_GINTSTS_SRQINT_Pos             = 0x1e       // Position of SRQINT field.
	USB_OTG_FS_FS_GINTSTS_SRQINT_Msk             = 0x40000000 // Bit mask of SRQINT field.
	USB_OTG_FS_FS_GINTSTS_SRQINT                 = 0x40000000 // Bit SRQINT.
	USB_OTG_FS_FS_GINTSTS_WKUPINT_Pos            = 0x1f       // Position of WKUPINT field.
	USB_OTG_FS_FS_GINTSTS_WKUPINT_Msk            = 0x80000000 // Bit mask of WKUPINT field.
	USB_OTG_FS_FS_GINTSTS_WKUPINT                = 0x80000000 // Bit WKUPINT.

	// FS_GINTMSK: OTG_FS interrupt mask register           (OTG_FS_GINTMSK)
	USB_OTG_FS_FS_GINTMSK_MMISM_Pos            = 0x1        // Position of MMISM field.
	USB_OTG_FS_FS_GINTMSK_MMISM_Msk            = 0x2        // Bit mask of MMISM field.
	USB_OTG_FS_FS_GINTMSK_MMISM                = 0x2        // Bit MMISM.
	USB_OTG_FS_FS_GINTMSK_OTGINT_Pos           = 0x2        // Position of OTGINT field.
	USB_OTG_FS_FS_GINTMSK_OTGINT_Msk           = 0x4        // Bit mask of OTGINT field.
	USB_OTG_FS_FS_GINTMSK_OTGINT               = 0x4        // Bit OTGINT.
	USB_OTG_FS_FS_GINTMSK_SOFM_Pos             = 0x3        // Position of SOFM field.
	USB_OTG_FS_FS_GINTMSK_SOFM_Msk             = 0x8        // Bit mask of SOFM field.
	USB_OTG_FS_FS_GINTMSK_SOFM                 = 0x8        // Bit SOFM.
	USB_OTG_FS_FS_GINTMSK_RXFLVLM_Pos          = 0x4        // Position of RXFLVLM field.
	USB_OTG_FS_FS_GINTMSK_RXFLVLM_Msk          = 0x10       // Bit mask of RXFLVLM field.
	USB_OTG_FS_FS_GINTMSK_RXFLVLM              = 0x10       // Bit RXFLVLM.
	USB_OTG_FS_FS_GINTMSK_NPTXFEM_Pos          = 0x5        // Position of NPTXFEM field.
	USB_OTG_FS_FS_GINTMSK_NPTXFEM_Msk          = 0x20       // Bit mask of NPTXFEM field.
	USB_OTG_FS_FS_GINTMSK_NPTXFEM              = 0x20       // Bit NPTXFEM.
	USB_OTG_FS_FS_GINTMSK_GINAKEFFM_Pos        = 0x6        // Position of GINAKEFFM field.
	USB_OTG_FS_FS_GINTMSK_GINAKEFFM_Msk        = 0x40       // Bit mask of GINAKEFFM field.
	USB_OTG_FS_FS_GINTMSK_GINAKEFFM            = 0x40       // Bit GINAKEFFM.
	USB_OTG_FS_FS_GINTMSK_GONAKEFFM_Pos        = 0x7        // Position of GONAKEFFM field.
	USB_OTG_FS_FS_GINTMSK_GONAKEFFM_Msk        = 0x80       // Bit mask of GONAKEFFM field.
	USB_OTG_FS_FS_GINTMSK_GONAKEFFM            = 0x80       // Bit GONAKEFFM.
	USB_OTG_FS_FS_GINTMSK_ESUSPM_Pos           = 0xa        // Position of ESUSPM field.
	USB_OTG_FS_FS_GINTMSK_ESUSPM_Msk           = 0x400      // Bit mask of ESUSPM field.
	USB_OTG_FS_FS_GINTMSK_ESUSPM               = 0x400      // Bit ESUSPM.
	USB_OTG_FS_FS_GINTMSK_USBSUSPM_Pos         = 0xb        // Position of USBSUSPM field.
	USB_OTG_FS_FS_GINTMSK_USBSUSPM_Msk         = 0x800      // Bit mask of USBSUSPM field.
	USB_OTG_FS_FS_GINTMSK_USBSUSPM             = 0x800      // Bit USBSUSPM.
	USB_OTG_FS_FS_GINTMSK_USBRST_Pos           = 0xc        // Position of USBRST field.
	USB_OTG_FS_FS_GINTMSK_USBRST_Msk           = 0x1000     // Bit mask of USBRST field.
	USB_OTG_FS_FS_GINTMSK_USBRST               = 0x1000     // Bit USBRST.
	USB_OTG_FS_FS_GINTMSK_ENUMDNEM_Pos         = 0xd        // Position of ENUMDNEM field.
	USB_OTG_FS_FS_GINTMSK_ENUMDNEM_Msk         = 0x2000     // Bit mask of ENUMDNEM field.
	USB_OTG_FS_FS_GINTMSK_ENUMDNEM             = 0x2000     // Bit ENUMDNEM.
	USB_OTG_FS_FS_GINTMSK_ISOODRPM_Pos         = 0xe        // Position of ISOODRPM field.
	USB_OTG_FS_FS_GINTMSK_ISOODRPM_Msk         = 0x4000     // Bit mask of ISOODRPM field.
	USB_OTG_FS_FS_GINTMSK_ISOODRPM             = 0x4000     // Bit ISOODRPM.
	USB_OTG_FS_FS_GINTMSK_EOPFM_Pos            = 0xf        // Position of EOPFM field.
	USB_OTG_FS_FS_GINTMSK_EOPFM_Msk            = 0x8000     // Bit mask of EOPFM field.
	USB_OTG_FS_FS_GINTMSK_EOPFM                = 0x8000     // Bit EOPFM.
	USB_OTG_FS_FS_GINTMSK_EPMISM_Pos           = 0x11       // Position of EPMISM field.
	USB_OTG_FS_FS_GINTMSK_EPMISM_Msk           = 0x20000    // Bit mask of EPMISM field.
	USB_OTG_FS_FS_GINTMSK_EPMISM               = 0x20000    // Bit EPMISM.
	USB_OTG_FS_FS_GINTMSK_IEPINT_Pos           = 0x12       // Position of IEPINT field.
	USB_OTG_FS_FS_GINTMSK_IEPINT_Msk           = 0x40000    // Bit mask of IEPINT field.
	USB_OTG_FS_FS_GINTMSK_IEPINT               = 0x40000    // Bit IEPINT.
	USB_OTG_FS_FS_GINTMSK_OEPINT_Pos           = 0x13       // Position of OEPINT field.
	USB_OTG_FS_FS_GINTMSK_OEPINT_Msk           = 0x80000    // Bit mask of OEPINT field.
	USB_OTG_FS_FS_GINTMSK_OEPINT               = 0x80000    // Bit OEPINT.
	USB_OTG_FS_FS_GINTMSK_IISOIXFRM_Pos        = 0x14       // Position of IISOIXFRM field.
	USB_OTG_FS_FS_GINTMSK_IISOIXFRM_Msk        = 0x100000   // Bit mask of IISOIXFRM field.
	USB_OTG_FS_FS_GINTMSK_IISOIXFRM            = 0x100000   // Bit IISOIXFRM.
	USB_OTG_FS_FS_GINTMSK_IPXFRM_IISOOXFRM_Pos = 0x15       // Position of IPXFRM_IISOOXFRM field.
	USB_OTG_FS_FS_GINTMSK_IPXFRM_IISOOXFRM_Msk = 0x200000   // Bit mask of IPXFRM_IISOOXFRM field.
	USB_OTG_FS_FS_GINTMSK_IPXFRM_IISOOXFRM     = 0x200000   // Bit IPXFRM_IISOOXFRM.
	USB_OTG_FS_FS_GINTMSK_PRTIM_Pos            = 0x18       // Position of PRTIM field.
	USB_OTG_FS_FS_GINTMSK_PRTIM_Msk            = 0x1000000  // Bit mask of PRTIM field.
	USB_OTG_FS_FS_GINTMSK_PRTIM                = 0x1000000  // Bit PRTIM.
	USB_OTG_FS_FS_GINTMSK_HCIM_Pos             = 0x19       // Position of HCIM field.
	USB_OTG_FS_FS_GINTMSK_HCIM_Msk             = 0x2000000  // Bit mask of HCIM field.
	USB_OTG_FS_FS_GINTMSK_HCIM                 = 0x2000000  // Bit HCIM.
	USB_OTG_FS_FS_GINTMSK_PTXFEM_Pos           = 0x1a       // Position of PTXFEM field.
	USB_OTG_FS_FS_GINTMSK_PTXFEM_Msk           = 0x4000000  // Bit mask of PTXFEM field.
	USB_OTG_FS_FS_GINTMSK_PTXFEM               = 0x4000000  // Bit PTXFEM.
	USB_OTG_FS_FS_GINTMSK_CIDSCHGM_Pos         = 0x1c       // Position of CIDSCHGM field.
	USB_OTG_FS_FS_GINTMSK_CIDSCHGM_Msk         = 0x10000000 // Bit mask of CIDSCHGM field.
	USB_OTG_FS_FS_GINTMSK_CIDSCHGM             = 0x10000000 // Bit CIDSCHGM.
	USB_OTG_FS_FS_GINTMSK_DISCINT_Pos          = 0x1d       // Position of DISCINT field.
	USB_OTG_FS_FS_GINTMSK_DISCINT_Msk          = 0x20000000 // Bit mask of DISCINT field.
	USB_OTG_FS_FS_GINTMSK_DISCINT              = 0x20000000 // Bit DISCINT.
	USB_OTG_FS_FS_GINTMSK_SRQIM_Pos            = 0x1e       // Position of SRQIM field.
	USB_OTG_FS_FS_GINTMSK_SRQIM_Msk            = 0x40000000 // Bit mask of SRQIM field.
	USB_OTG_FS_FS_GINTMSK_SRQIM                = 0x40000000 // Bit SRQIM.
	USB_OTG_FS_FS_GINTMSK_WUIM_Pos             = 0x1f       // Position of WUIM field.
	USB_OTG_FS_FS_GINTMSK_WUIM_Msk             = 0x80000000 // Bit mask of WUIM field.
	USB_OTG_FS_FS_GINTMSK_WUIM                 = 0x80000000 // Bit WUIM.

	// FS_GRXSTSR_Device: OTG_FS Receive status debug read(Device           mode)
	USB_OTG_FS_FS_GRXSTSR_Device_EPNUM_Pos  = 0x0       // Position of EPNUM field.
	USB_OTG_FS_FS_GRXSTSR_Device_EPNUM_Msk  = 0xf       // Bit mask of EPNUM field.
	USB_OTG_FS_FS_GRXSTSR_Device_BCNT_Pos   = 0x4       // Position of BCNT field.
	USB_OTG_FS_FS_GRXSTSR_Device_BCNT_Msk   = 0x7ff0    // Bit mask of BCNT field.
	USB_OTG_FS_FS_GRXSTSR_Device_DPID_Pos   = 0xf       // Position of DPID field.
	USB_OTG_FS_FS_GRXSTSR_Device_DPID_Msk   = 0x18000   // Bit mask of DPID field.
	USB_OTG_FS_FS_GRXSTSR_Device_PKTSTS_Pos = 0x11      // Position of PKTSTS field.
	USB_OTG_FS_FS_GRXSTSR_Device_PKTSTS_Msk = 0x1e0000  // Bit mask of PKTSTS field.
	USB_OTG_FS_FS_GRXSTSR_Device_FRMNUM_Pos = 0x15      // Position of FRMNUM field.
	USB_OTG_FS_FS_GRXSTSR_Device_FRMNUM_Msk = 0x1e00000 // Bit mask of FRMNUM field.

	// FS_GRXSTSR_Host: OTG_FS Receive status debug read(Host           mode)
	USB_OTG_FS_FS_GRXSTSR_Host_EPNUM_Pos  = 0x0       // Position of EPNUM field.
	USB_OTG_FS_FS_GRXSTSR_Host_EPNUM_Msk  = 0xf       // Bit mask of EPNUM field.
	USB_OTG_FS_FS_GRXSTSR_Host_BCNT_Pos   = 0x4       // Position of BCNT field.
	USB_OTG_FS_FS_GRXSTSR_Host_BCNT_Msk   = 0x7ff0    // Bit mask of BCNT field.
	USB_OTG_FS_FS_GRXSTSR_Host_DPID_Pos   = 0xf       // Position of DPID field.
	USB_OTG_FS_FS_GRXSTSR_Host_DPID_Msk   = 0x18000   // Bit mask of DPID field.
	USB_OTG_FS_FS_GRXSTSR_Host_PKTSTS_Pos = 0x11      // Position of PKTSTS field.
	USB_OTG_FS_FS_GRXSTSR_Host_PKTSTS_Msk = 0x1e0000  // Bit mask of PKTSTS field.
	USB_OTG_FS_FS_GRXSTSR_Host_FRMNUM_Pos = 0x15      // Position of FRMNUM field.
	USB_OTG_FS_FS_GRXSTSR_Host_FRMNUM_Msk = 0x1e00000 // Bit mask of FRMNUM field.

	// FS_GRXFSIZ: OTG_FS Receive FIFO size register           (OTG_FS_GRXFSIZ)
	USB_OTG_FS_FS_GRXFSIZ_RXFD_Pos = 0x0    // Position of RXFD field.
	USB_OTG_FS_FS_GRXFSIZ_RXFD_Msk = 0xffff // Bit mask of RXFD field.

	// FS_GNPTXFSIZ_Device: OTG_FS non-periodic transmit FIFO size           register (Device mode)
	USB_OTG_FS_FS_GNPTXFSIZ_Device_TX0FSA_Pos = 0x0        // Position of TX0FSA field.
	USB_OTG_FS_FS_GNPTXFSIZ_Device_TX0FSA_Msk = 0xffff     // Bit mask of TX0FSA field.
	USB_OTG_FS_FS_GNPTXFSIZ_Device_TX0FD_Pos  = 0x10       // Position of TX0FD field.
	USB_OTG_FS_FS_GNPTXFSIZ_Device_TX0FD_Msk  = 0xffff0000 // Bit mask of TX0FD field.

	// FS_GNPTXFSIZ_Host: OTG_FS non-periodic transmit FIFO size           register (Host mode)
	USB_OTG_FS_FS_GNPTXFSIZ_Host_NPTXFSA_Pos = 0x0        // Position of NPTXFSA field.
	USB_OTG_FS_FS_GNPTXFSIZ_Host_NPTXFSA_Msk = 0xffff     // Bit mask of NPTXFSA field.
	USB_OTG_FS_FS_GNPTXFSIZ_Host_NPTXFD_Pos  = 0x10       // Position of NPTXFD field.
	USB_OTG_FS_FS_GNPTXFSIZ_Host_NPTXFD_Msk  = 0xffff0000 // Bit mask of NPTXFD field.

	// FS_GNPTXSTS: OTG_FS non-periodic transmit FIFO/queue           status register (OTG_FS_GNPTXSTS)
	USB_OTG_FS_FS_GNPTXSTS_NPTXFSAV_Pos = 0x0        // Position of NPTXFSAV field.
	USB_OTG_FS_FS_GNPTXSTS_NPTXFSAV_Msk = 0xffff     // Bit mask of NPTXFSAV field.
	USB_OTG_FS_FS_GNPTXSTS_NPTQXSAV_Pos = 0x10       // Position of NPTQXSAV field.
	USB_OTG_FS_FS_GNPTXSTS_NPTQXSAV_Msk = 0xff0000   // Bit mask of NPTQXSAV field.
	USB_OTG_FS_FS_GNPTXSTS_NPTXQTOP_Pos = 0x18       // Position of NPTXQTOP field.
	USB_OTG_FS_FS_GNPTXSTS_NPTXQTOP_Msk = 0x7f000000 // Bit mask of NPTXQTOP field.

	// FS_GCCFG: OTG_FS general core configuration register           (OTG_FS_GCCFG)
	USB_OTG_FS_FS_GCCFG_PWRDWN_Pos   = 0x10     // Position of PWRDWN field.
	USB_OTG_FS_FS_GCCFG_PWRDWN_Msk   = 0x10000  // Bit mask of PWRDWN field.
	USB_OTG_FS_FS_GCCFG_PWRDWN       = 0x10000  // Bit PWRDWN.
	USB_OTG_FS_FS_GCCFG_VBUSASEN_Pos = 0x12     // Position of VBUSASEN field.
	USB_OTG_FS_FS_GCCFG_VBUSASEN_Msk = 0x40000  // Bit mask of VBUSASEN field.
	USB_OTG_FS_FS_GCCFG_VBUSASEN     = 0x40000  // Bit VBUSASEN.
	USB_OTG_FS_FS_GCCFG_VBUSBSEN_Pos = 0x13     // Position of VBUSBSEN field.
	USB_OTG_FS_FS_GCCFG_VBUSBSEN_Msk = 0x80000  // Bit mask of VBUSBSEN field.
	USB_OTG_FS_FS_GCCFG_VBUSBSEN     = 0x80000  // Bit VBUSBSEN.
	USB_OTG_FS_FS_GCCFG_SOFOUTEN_Pos = 0x14     // Position of SOFOUTEN field.
	USB_OTG_FS_FS_GCCFG_SOFOUTEN_Msk = 0x100000 // Bit mask of SOFOUTEN field.
	USB_OTG_FS_FS_GCCFG_SOFOUTEN     = 0x100000 // Bit SOFOUTEN.

	// FS_CID: core ID register
	USB_OTG_FS_FS_CID_PRODUCT_ID_Pos = 0x0        // Position of PRODUCT_ID field.
	USB_OTG_FS_FS_CID_PRODUCT_ID_Msk = 0xffffffff // Bit mask of PRODUCT_ID field.

	// FS_HPTXFSIZ: OTG_FS Host periodic transmit FIFO size           register (OTG_FS_HPTXFSIZ)
	USB_OTG_FS_FS_HPTXFSIZ_PTXSA_Pos   = 0x0        // Position of PTXSA field.
	USB_OTG_FS_FS_HPTXFSIZ_PTXSA_Msk   = 0xffff     // Bit mask of PTXSA field.
	USB_OTG_FS_FS_HPTXFSIZ_PTXFSIZ_Pos = 0x10       // Position of PTXFSIZ field.
	USB_OTG_FS_FS_HPTXFSIZ_PTXFSIZ_Msk = 0xffff0000 // Bit mask of PTXFSIZ field.

	// FS_DIEPTXF1: OTG_FS device IN endpoint transmit FIFO size           register (OTG_FS_DIEPTXF2)
	USB_OTG_FS_FS_DIEPTXF1_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_FS_FS_DIEPTXF1_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_FS_FS_DIEPTXF1_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_FS_FS_DIEPTXF1_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// FS_DIEPTXF2: OTG_FS device IN endpoint transmit FIFO size           register (OTG_FS_DIEPTXF3)
	USB_OTG_FS_FS_DIEPTXF2_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_FS_FS_DIEPTXF2_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_FS_FS_DIEPTXF2_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_FS_FS_DIEPTXF2_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// FS_DIEPTXF3: OTG_FS device IN endpoint transmit FIFO size           register (OTG_FS_DIEPTXF4)
	USB_OTG_FS_FS_DIEPTXF3_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_FS_FS_DIEPTXF3_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_FS_FS_DIEPTXF3_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_FS_FS_DIEPTXF3_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.
)

// Bitfields for CAN1: Controller area network
const (
	// MCR: master control register
	CAN_MCR_DBF_Pos   = 0x10    // Position of DBF field.
	CAN_MCR_DBF_Msk   = 0x10000 // Bit mask of DBF field.
	CAN_MCR_DBF       = 0x10000 // Bit DBF.
	CAN_MCR_RESET_Pos = 0xf     // Position of RESET field.
	CAN_MCR_RESET_Msk = 0x8000  // Bit mask of RESET field.
	CAN_MCR_RESET     = 0x8000  // Bit RESET.
	CAN_MCR_TTCM_Pos  = 0x7     // Position of TTCM field.
	CAN_MCR_TTCM_Msk  = 0x80    // Bit mask of TTCM field.
	CAN_MCR_TTCM      = 0x80    // Bit TTCM.
	CAN_MCR_ABOM_Pos  = 0x6     // Position of ABOM field.
	CAN_MCR_ABOM_Msk  = 0x40    // Bit mask of ABOM field.
	CAN_MCR_ABOM      = 0x40    // Bit ABOM.
	CAN_MCR_AWUM_Pos  = 0x5     // Position of AWUM field.
	CAN_MCR_AWUM_Msk  = 0x20    // Bit mask of AWUM field.
	CAN_MCR_AWUM      = 0x20    // Bit AWUM.
	CAN_MCR_NART_Pos  = 0x4     // Position of NART field.
	CAN_MCR_NART_Msk  = 0x10    // Bit mask of NART field.
	CAN_MCR_NART      = 0x10    // Bit NART.
	CAN_MCR_RFLM_Pos  = 0x3     // Position of RFLM field.
	CAN_MCR_RFLM_Msk  = 0x8     // Bit mask of RFLM field.
	CAN_MCR_RFLM      = 0x8     // Bit RFLM.
	CAN_MCR_TXFP_Pos  = 0x2     // Position of TXFP field.
	CAN_MCR_TXFP_Msk  = 0x4     // Bit mask of TXFP field.
	CAN_MCR_TXFP      = 0x4     // Bit TXFP.
	CAN_MCR_SLEEP_Pos = 0x1     // Position of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2     // Bit mask of SLEEP field.
	CAN_MCR_SLEEP     = 0x2     // Bit SLEEP.
	CAN_MCR_INRQ_Pos  = 0x0     // Position of INRQ field.
	CAN_MCR_INRQ_Msk  = 0x1     // Bit mask of INRQ field.
	CAN_MCR_INRQ      = 0x1     // Bit INRQ.

	// MSR: master status register
	CAN_MSR_RX_Pos    = 0xb   // Position of RX field.
	CAN_MSR_RX_Msk    = 0x800 // Bit mask of RX field.
	CAN_MSR_RX        = 0x800 // Bit RX.
	CAN_MSR_SAMP_Pos  = 0xa   // Position of SAMP field.
	CAN_MSR_SAMP_Msk  = 0x400 // Bit mask of SAMP field.
	CAN_MSR_SAMP      = 0x400 // Bit SAMP.
	CAN_MSR_RXM_Pos   = 0x9   // Position of RXM field.
	CAN_MSR_RXM_Msk   = 0x200 // Bit mask of RXM field.
	CAN_MSR_RXM       = 0x200 // Bit RXM.
	CAN_MSR_TXM_Pos   = 0x8   // Position of TXM field.
	CAN_MSR_TXM_Msk   = 0x100 // Bit mask of TXM field.
	CAN_MSR_TXM       = 0x100 // Bit TXM.
	CAN_MSR_SLAKI_Pos = 0x4   // Position of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10  // Bit mask of SLAKI field.
	CAN_MSR_SLAKI     = 0x10  // Bit SLAKI.
	CAN_MSR_WKUI_Pos  = 0x3   // Position of WKUI field.
	CAN_MSR_WKUI_Msk  = 0x8   // Bit mask of WKUI field.
	CAN_MSR_WKUI      = 0x8   // Bit WKUI.
	CAN_MSR_ERRI_Pos  = 0x2   // Position of ERRI field.
	CAN_MSR_ERRI_Msk  = 0x4   // Bit mask of ERRI field.
	CAN_MSR_ERRI      = 0x4   // Bit ERRI.
	CAN_MSR_SLAK_Pos  = 0x1   // Position of SLAK field.
	CAN_MSR_SLAK_Msk  = 0x2   // Bit mask of SLAK field.
	CAN_MSR_SLAK      = 0x2   // Bit SLAK.
	CAN_MSR_INAK_Pos  = 0x0   // Position of INAK field.
	CAN_MSR_INAK_Msk  = 0x1   // Bit mask of INAK field.
	CAN_MSR_INAK      = 0x1   // Bit INAK.

	// TSR: transmit status register
	CAN_TSR_LOW2_Pos  = 0x1f       // Position of LOW2 field.
	CAN_TSR_LOW2_Msk  = 0x80000000 // Bit mask of LOW2 field.
	CAN_TSR_LOW2      = 0x80000000 // Bit LOW2.
	CAN_TSR_LOW1_Pos  = 0x1e       // Position of LOW1 field.
	CAN_TSR_LOW1_Msk  = 0x40000000 // Bit mask of LOW1 field.
	CAN_TSR_LOW1      = 0x40000000 // Bit LOW1.
	CAN_TSR_LOW0_Pos  = 0x1d       // Position of LOW0 field.
	CAN_TSR_LOW0_Msk  = 0x20000000 // Bit mask of LOW0 field.
	CAN_TSR_LOW0      = 0x20000000 // Bit LOW0.
	CAN_TSR_TME2_Pos  = 0x1c       // Position of TME2 field.
	CAN_TSR_TME2_Msk  = 0x10000000 // Bit mask of TME2 field.
	CAN_TSR_TME2      = 0x10000000 // Bit TME2.
	CAN_TSR_TME1_Pos  = 0x1b       // Position of TME1 field.
	CAN_TSR_TME1_Msk  = 0x8000000  // Bit mask of TME1 field.
	CAN_TSR_TME1      = 0x8000000  // Bit TME1.
	CAN_TSR_TME0_Pos  = 0x1a       // Position of TME0 field.
	CAN_TSR_TME0_Msk  = 0x4000000  // Bit mask of TME0 field.
	CAN_TSR_TME0      = 0x4000000  // Bit TME0.
	CAN_TSR_CODE_Pos  = 0x18       // Position of CODE field.
	CAN_TSR_CODE_Msk  = 0x3000000  // Bit mask of CODE field.
	CAN_TSR_ABRQ2_Pos = 0x17       // Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000   // Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2     = 0x800000   // Bit ABRQ2.
	CAN_TSR_TERR2_Pos = 0x13       // Position of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000    // Bit mask of TERR2 field.
	CAN_TSR_TERR2     = 0x80000    // Bit TERR2.
	CAN_TSR_ALST2_Pos = 0x12       // Position of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000    // Bit mask of ALST2 field.
	CAN_TSR_ALST2     = 0x40000    // Bit ALST2.
	CAN_TSR_TXOK2_Pos = 0x11       // Position of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000    // Bit mask of TXOK2 field.
	CAN_TSR_TXOK2     = 0x20000    // Bit TXOK2.
	CAN_TSR_RQCP2_Pos = 0x10       // Position of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000    // Bit mask of RQCP2 field.
	CAN_TSR_RQCP2     = 0x10000    // Bit RQCP2.
	CAN_TSR_ABRQ1_Pos = 0xf        // Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000     // Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1     = 0x8000     // Bit ABRQ1.
	CAN_TSR_TERR1_Pos = 0xb        // Position of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800      // Bit mask of TERR1 field.
	CAN_TSR_TERR1     = 0x800      // Bit TERR1.
	CAN_TSR_ALST1_Pos = 0xa        // Position of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400      // Bit mask of ALST1 field.
	CAN_TSR_ALST1     = 0x400      // Bit ALST1.
	CAN_TSR_TXOK1_Pos = 0x9        // Position of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200      // Bit mask of TXOK1 field.
	CAN_TSR_TXOK1     = 0x200      // Bit TXOK1.
	CAN_TSR_RQCP1_Pos = 0x8        // Position of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100      // Bit mask of RQCP1 field.
	CAN_TSR_RQCP1     = 0x100      // Bit RQCP1.
	CAN_TSR_ABRQ0_Pos = 0x7        // Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80       // Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0     = 0x80       // Bit ABRQ0.
	CAN_TSR_TERR0_Pos = 0x3        // Position of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8        // Bit mask of TERR0 field.
	CAN_TSR_TERR0     = 0x8        // Bit TERR0.
	CAN_TSR_ALST0_Pos = 0x2        // Position of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4        // Bit mask of ALST0 field.
	CAN_TSR_ALST0     = 0x4        // Bit ALST0.
	CAN_TSR_TXOK0_Pos = 0x1        // Position of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2        // Bit mask of TXOK0 field.
	CAN_TSR_TXOK0     = 0x2        // Bit TXOK0.
	CAN_TSR_RQCP0_Pos = 0x0        // Position of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1        // Bit mask of RQCP0 field.
	CAN_TSR_RQCP0     = 0x1        // Bit RQCP0.

	// RF0R: receive FIFO 0 register
	CAN_RF0R_RFOM0_Pos = 0x5  // Position of RFOM0 field.
	CAN_RF0R_RFOM0_Msk = 0x20 // Bit mask of RFOM0 field.
	CAN_RF0R_RFOM0     = 0x20 // Bit RFOM0.
	CAN_RF0R_FOVR0_Pos = 0x4  // Position of FOVR0 field.
	CAN_RF0R_FOVR0_Msk = 0x10 // Bit mask of FOVR0 field.
	CAN_RF0R_FOVR0     = 0x10 // Bit FOVR0.
	CAN_RF0R_FULL0_Pos = 0x3  // Position of FULL0 field.
	CAN_RF0R_FULL0_Msk = 0x8  // Bit mask of FULL0 field.
	CAN_RF0R_FULL0     = 0x8  // Bit FULL0.
	CAN_RF0R_FMP0_Pos  = 0x0  // Position of FMP0 field.
	CAN_RF0R_FMP0_Msk  = 0x3  // Bit mask of FMP0 field.

	// RF1R: receive FIFO 1 register
	CAN_RF1R_RFOM1_Pos = 0x5  // Position of RFOM1 field.
	CAN_RF1R_RFOM1_Msk = 0x20 // Bit mask of RFOM1 field.
	CAN_RF1R_RFOM1     = 0x20 // Bit RFOM1.
	CAN_RF1R_FOVR1_Pos = 0x4  // Position of FOVR1 field.
	CAN_RF1R_FOVR1_Msk = 0x10 // Bit mask of FOVR1 field.
	CAN_RF1R_FOVR1     = 0x10 // Bit FOVR1.
	CAN_RF1R_FULL1_Pos = 0x3  // Position of FULL1 field.
	CAN_RF1R_FULL1_Msk = 0x8  // Bit mask of FULL1 field.
	CAN_RF1R_FULL1     = 0x8  // Bit FULL1.
	CAN_RF1R_FMP1_Pos  = 0x0  // Position of FMP1 field.
	CAN_RF1R_FMP1_Msk  = 0x3  // Bit mask of FMP1 field.

	// IER: interrupt enable register
	CAN_IER_SLKIE_Pos  = 0x11    // Position of SLKIE field.
	CAN_IER_SLKIE_Msk  = 0x20000 // Bit mask of SLKIE field.
	CAN_IER_SLKIE      = 0x20000 // Bit SLKIE.
	CAN_IER_WKUIE_Pos  = 0x10    // Position of WKUIE field.
	CAN_IER_WKUIE_Msk  = 0x10000 // Bit mask of WKUIE field.
	CAN_IER_WKUIE      = 0x10000 // Bit WKUIE.
	CAN_IER_ERRIE_Pos  = 0xf     // Position of ERRIE field.
	CAN_IER_ERRIE_Msk  = 0x8000  // Bit mask of ERRIE field.
	CAN_IER_ERRIE      = 0x8000  // Bit ERRIE.
	CAN_IER_LECIE_Pos  = 0xb     // Position of LECIE field.
	CAN_IER_LECIE_Msk  = 0x800   // Bit mask of LECIE field.
	CAN_IER_LECIE      = 0x800   // Bit LECIE.
	CAN_IER_BOFIE_Pos  = 0xa     // Position of BOFIE field.
	CAN_IER_BOFIE_Msk  = 0x400   // Bit mask of BOFIE field.
	CAN_IER_BOFIE      = 0x400   // Bit BOFIE.
	CAN_IER_EPVIE_Pos  = 0x9     // Position of EPVIE field.
	CAN_IER_EPVIE_Msk  = 0x200   // Bit mask of EPVIE field.
	CAN_IER_EPVIE      = 0x200   // Bit EPVIE.
	CAN_IER_EWGIE_Pos  = 0x8     // Position of EWGIE field.
	CAN_IER_EWGIE_Msk  = 0x100   // Bit mask of EWGIE field.
	CAN_IER_EWGIE      = 0x100   // Bit EWGIE.
	CAN_IER_FOVIE1_Pos = 0x6     // Position of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40    // Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1     = 0x40    // Bit FOVIE1.
	CAN_IER_FFIE1_Pos  = 0x5     // Position of FFIE1 field.
	CAN_IER_FFIE1_Msk  = 0x20    // Bit mask of FFIE1 field.
	CAN_IER_FFIE1      = 0x20    // Bit FFIE1.
	CAN_IER_FMPIE1_Pos = 0x4     // Position of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10    // Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1     = 0x10    // Bit FMPIE1.
	CAN_IER_FOVIE0_Pos = 0x3     // Position of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8     // Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0     = 0x8     // Bit FOVIE0.
	CAN_IER_FFIE0_Pos  = 0x2     // Position of FFIE0 field.
	CAN_IER_FFIE0_Msk  = 0x4     // Bit mask of FFIE0 field.
	CAN_IER_FFIE0      = 0x4     // Bit FFIE0.
	CAN_IER_FMPIE0_Pos = 0x1     // Position of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2     // Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0     = 0x2     // Bit FMPIE0.
	CAN_IER_TMEIE_Pos  = 0x0     // Position of TMEIE field.
	CAN_IER_TMEIE_Msk  = 0x1     // Bit mask of TMEIE field.
	CAN_IER_TMEIE      = 0x1     // Bit TMEIE.

	// ESR: interrupt enable register
	CAN_ESR_REC_Pos  = 0x18       // Position of REC field.
	CAN_ESR_REC_Msk  = 0xff000000 // Bit mask of REC field.
	CAN_ESR_TEC_Pos  = 0x10       // Position of TEC field.
	CAN_ESR_TEC_Msk  = 0xff0000   // Bit mask of TEC field.
	CAN_ESR_LEC_Pos  = 0x4        // Position of LEC field.
	CAN_ESR_LEC_Msk  = 0x70       // Bit mask of LEC field.
	CAN_ESR_BOFF_Pos = 0x2        // Position of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4        // Bit mask of BOFF field.
	CAN_ESR_BOFF     = 0x4        // Bit BOFF.
	CAN_ESR_EPVF_Pos = 0x1        // Position of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2        // Bit mask of EPVF field.
	CAN_ESR_EPVF     = 0x2        // Bit EPVF.
	CAN_ESR_EWGF_Pos = 0x0        // Position of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1        // Bit mask of EWGF field.
	CAN_ESR_EWGF     = 0x1        // Bit EWGF.

	// BTR: bit timing register
	CAN_BTR_SILM_Pos = 0x1f       // Position of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000 // Bit mask of SILM field.
	CAN_BTR_SILM     = 0x80000000 // Bit SILM.
	CAN_BTR_LBKM_Pos = 0x1e       // Position of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000 // Bit mask of LBKM field.
	CAN_BTR_LBKM     = 0x40000000 // Bit LBKM.
	CAN_BTR_SJW_Pos  = 0x18       // Position of SJW field.
	CAN_BTR_SJW_Msk  = 0x3000000  // Bit mask of SJW field.
	CAN_BTR_TS2_Pos  = 0x14       // Position of TS2 field.
	CAN_BTR_TS2_Msk  = 0x700000   // Bit mask of TS2 field.
	CAN_BTR_TS1_Pos  = 0x10       // Position of TS1 field.
	CAN_BTR_TS1_Msk  = 0xf0000    // Bit mask of TS1 field.
	CAN_BTR_BRP_Pos  = 0x0        // Position of BRP field.
	CAN_BTR_BRP_Msk  = 0x3ff      // Bit mask of BRP field.

	// TI0R: TX mailbox identifier register
	CAN_TI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI0R_IDE      = 0x4        // Bit IDE.
	CAN_TI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI0R_RTR      = 0x2        // Bit RTR.
	CAN_TI0R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI0R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI0R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT0R: mailbox data length control and time stamp           register
	CAN_TDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT0R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT0R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT0R_TGT      = 0x100      // Bit TGT.
	CAN_TDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL0R: mailbox data low register
	CAN_TDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH0R: mailbox data high register
	CAN_TDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// TI1R: mailbox identifier register
	CAN_TI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI1R_IDE      = 0x4        // Bit IDE.
	CAN_TI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI1R_RTR      = 0x2        // Bit RTR.
	CAN_TI1R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI1R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI1R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT1R: mailbox data length control and time stamp           register
	CAN_TDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT1R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT1R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT1R_TGT      = 0x100      // Bit TGT.
	CAN_TDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL1R: mailbox data low register
	CAN_TDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH1R: mailbox data high register
	CAN_TDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// TI2R: mailbox identifier register
	CAN_TI2R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI2R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI2R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI2R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI2R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI2R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI2R_IDE      = 0x4        // Bit IDE.
	CAN_TI2R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI2R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI2R_RTR      = 0x2        // Bit RTR.
	CAN_TI2R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI2R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI2R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT2R: mailbox data length control and time stamp           register
	CAN_TDT2R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT2R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT2R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT2R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT2R_TGT      = 0x100      // Bit TGT.
	CAN_TDT2R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT2R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL2R: mailbox data low register
	CAN_TDL2R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL2R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL2R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL2R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL2R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL2R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL2R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL2R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH2R: mailbox data high register
	CAN_TDH2R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH2R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH2R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH2R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH2R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH2R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH2R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH2R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// RI0R: receive FIFO mailbox identifier           register
	CAN_RI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_RI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_RI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_RI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_RI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_RI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_RI0R_IDE      = 0x4        // Bit IDE.
	CAN_RI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_RI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_RI0R_RTR      = 0x2        // Bit RTR.

	// RDT0R: mailbox data high register
	CAN_RDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_RDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_RDT0R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_RDT0R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_RDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_RDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// RDL0R: mailbox data high register
	CAN_RDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_RDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_RDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_RDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_RDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_RDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_RDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_RDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// RDH0R: receive FIFO mailbox data high           register
	CAN_RDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_RDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_RDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_RDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_RDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_RDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_RDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_RDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// RI1R: mailbox data high register
	CAN_RI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_RI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_RI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_RI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_RI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_RI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_RI1R_IDE      = 0x4        // Bit IDE.
	CAN_RI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_RI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_RI1R_RTR      = 0x2        // Bit RTR.

	// RDT1R: mailbox data high register
	CAN_RDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_RDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_RDT1R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_RDT1R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_RDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_RDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// RDL1R: mailbox data high register
	CAN_RDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_RDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_RDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_RDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_RDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_RDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_RDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_RDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// RDH1R: mailbox data high register
	CAN_RDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_RDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_RDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_RDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_RDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_RDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_RDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_RDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// FMR: filter master register
	CAN_FMR_CAN2SB_Pos = 0x8    // Position of CAN2SB field.
	CAN_FMR_CAN2SB_Msk = 0x3f00 // Bit mask of CAN2SB field.
	CAN_FMR_FINIT_Pos  = 0x0    // Position of FINIT field.
	CAN_FMR_FINIT_Msk  = 0x1    // Bit mask of FINIT field.
	CAN_FMR_FINIT      = 0x1    // Bit FINIT.

	// FM1R: filter mode register
	CAN_FM1R_FBM0_Pos  = 0x0       // Position of FBM0 field.
	CAN_FM1R_FBM0_Msk  = 0x1       // Bit mask of FBM0 field.
	CAN_FM1R_FBM0      = 0x1       // Bit FBM0.
	CAN_FM1R_FBM1_Pos  = 0x1       // Position of FBM1 field.
	CAN_FM1R_FBM1_Msk  = 0x2       // Bit mask of FBM1 field.
	CAN_FM1R_FBM1      = 0x2       // Bit FBM1.
	CAN_FM1R_FBM2_Pos  = 0x2       // Position of FBM2 field.
	CAN_FM1R_FBM2_Msk  = 0x4       // Bit mask of FBM2 field.
	CAN_FM1R_FBM2      = 0x4       // Bit FBM2.
	CAN_FM1R_FBM3_Pos  = 0x3       // Position of FBM3 field.
	CAN_FM1R_FBM3_Msk  = 0x8       // Bit mask of FBM3 field.
	CAN_FM1R_FBM3      = 0x8       // Bit FBM3.
	CAN_FM1R_FBM4_Pos  = 0x4       // Position of FBM4 field.
	CAN_FM1R_FBM4_Msk  = 0x10      // Bit mask of FBM4 field.
	CAN_FM1R_FBM4      = 0x10      // Bit FBM4.
	CAN_FM1R_FBM5_Pos  = 0x5       // Position of FBM5 field.
	CAN_FM1R_FBM5_Msk  = 0x20      // Bit mask of FBM5 field.
	CAN_FM1R_FBM5      = 0x20      // Bit FBM5.
	CAN_FM1R_FBM6_Pos  = 0x6       // Position of FBM6 field.
	CAN_FM1R_FBM6_Msk  = 0x40      // Bit mask of FBM6 field.
	CAN_FM1R_FBM6      = 0x40      // Bit FBM6.
	CAN_FM1R_FBM7_Pos  = 0x7       // Position of FBM7 field.
	CAN_FM1R_FBM7_Msk  = 0x80      // Bit mask of FBM7 field.
	CAN_FM1R_FBM7      = 0x80      // Bit FBM7.
	CAN_FM1R_FBM8_Pos  = 0x8       // Position of FBM8 field.
	CAN_FM1R_FBM8_Msk  = 0x100     // Bit mask of FBM8 field.
	CAN_FM1R_FBM8      = 0x100     // Bit FBM8.
	CAN_FM1R_FBM9_Pos  = 0x9       // Position of FBM9 field.
	CAN_FM1R_FBM9_Msk  = 0x200     // Bit mask of FBM9 field.
	CAN_FM1R_FBM9      = 0x200     // Bit FBM9.
	CAN_FM1R_FBM10_Pos = 0xa       // Position of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400     // Bit mask of FBM10 field.
	CAN_FM1R_FBM10     = 0x400     // Bit FBM10.
	CAN_FM1R_FBM11_Pos = 0xb       // Position of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800     // Bit mask of FBM11 field.
	CAN_FM1R_FBM11     = 0x800     // Bit FBM11.
	CAN_FM1R_FBM12_Pos = 0xc       // Position of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000    // Bit mask of FBM12 field.
	CAN_FM1R_FBM12     = 0x1000    // Bit FBM12.
	CAN_FM1R_FBM13_Pos = 0xd       // Position of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000    // Bit mask of FBM13 field.
	CAN_FM1R_FBM13     = 0x2000    // Bit FBM13.
	CAN_FM1R_FBM14_Pos = 0xe       // Position of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000    // Bit mask of FBM14 field.
	CAN_FM1R_FBM14     = 0x4000    // Bit FBM14.
	CAN_FM1R_FBM15_Pos = 0xf       // Position of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000    // Bit mask of FBM15 field.
	CAN_FM1R_FBM15     = 0x8000    // Bit FBM15.
	CAN_FM1R_FBM16_Pos = 0x10      // Position of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000   // Bit mask of FBM16 field.
	CAN_FM1R_FBM16     = 0x10000   // Bit FBM16.
	CAN_FM1R_FBM17_Pos = 0x11      // Position of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000   // Bit mask of FBM17 field.
	CAN_FM1R_FBM17     = 0x20000   // Bit FBM17.
	CAN_FM1R_FBM18_Pos = 0x12      // Position of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000   // Bit mask of FBM18 field.
	CAN_FM1R_FBM18     = 0x40000   // Bit FBM18.
	CAN_FM1R_FBM19_Pos = 0x13      // Position of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000   // Bit mask of FBM19 field.
	CAN_FM1R_FBM19     = 0x80000   // Bit FBM19.
	CAN_FM1R_FBM20_Pos = 0x14      // Position of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000  // Bit mask of FBM20 field.
	CAN_FM1R_FBM20     = 0x100000  // Bit FBM20.
	CAN_FM1R_FBM21_Pos = 0x15      // Position of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000  // Bit mask of FBM21 field.
	CAN_FM1R_FBM21     = 0x200000  // Bit FBM21.
	CAN_FM1R_FBM22_Pos = 0x16      // Position of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000  // Bit mask of FBM22 field.
	CAN_FM1R_FBM22     = 0x400000  // Bit FBM22.
	CAN_FM1R_FBM23_Pos = 0x17      // Position of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000  // Bit mask of FBM23 field.
	CAN_FM1R_FBM23     = 0x800000  // Bit FBM23.
	CAN_FM1R_FBM24_Pos = 0x18      // Position of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000 // Bit mask of FBM24 field.
	CAN_FM1R_FBM24     = 0x1000000 // Bit FBM24.
	CAN_FM1R_FBM25_Pos = 0x19      // Position of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000 // Bit mask of FBM25 field.
	CAN_FM1R_FBM25     = 0x2000000 // Bit FBM25.
	CAN_FM1R_FBM26_Pos = 0x1a      // Position of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000 // Bit mask of FBM26 field.
	CAN_FM1R_FBM26     = 0x4000000 // Bit FBM26.
	CAN_FM1R_FBM27_Pos = 0x1b      // Position of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000 // Bit mask of FBM27 field.
	CAN_FM1R_FBM27     = 0x8000000 // Bit FBM27.

	// FS1R: filter scale register
	CAN_FS1R_FSC0_Pos  = 0x0       // Position of FSC0 field.
	CAN_FS1R_FSC0_Msk  = 0x1       // Bit mask of FSC0 field.
	CAN_FS1R_FSC0      = 0x1       // Bit FSC0.
	CAN_FS1R_FSC1_Pos  = 0x1       // Position of FSC1 field.
	CAN_FS1R_FSC1_Msk  = 0x2       // Bit mask of FSC1 field.
	CAN_FS1R_FSC1      = 0x2       // Bit FSC1.
	CAN_FS1R_FSC2_Pos  = 0x2       // Position of FSC2 field.
	CAN_FS1R_FSC2_Msk  = 0x4       // Bit mask of FSC2 field.
	CAN_FS1R_FSC2      = 0x4       // Bit FSC2.
	CAN_FS1R_FSC3_Pos  = 0x3       // Position of FSC3 field.
	CAN_FS1R_FSC3_Msk  = 0x8       // Bit mask of FSC3 field.
	CAN_FS1R_FSC3      = 0x8       // Bit FSC3.
	CAN_FS1R_FSC4_Pos  = 0x4       // Position of FSC4 field.
	CAN_FS1R_FSC4_Msk  = 0x10      // Bit mask of FSC4 field.
	CAN_FS1R_FSC4      = 0x10      // Bit FSC4.
	CAN_FS1R_FSC5_Pos  = 0x5       // Position of FSC5 field.
	CAN_FS1R_FSC5_Msk  = 0x20      // Bit mask of FSC5 field.
	CAN_FS1R_FSC5      = 0x20      // Bit FSC5.
	CAN_FS1R_FSC6_Pos  = 0x6       // Position of FSC6 field.
	CAN_FS1R_FSC6_Msk  = 0x40      // Bit mask of FSC6 field.
	CAN_FS1R_FSC6      = 0x40      // Bit FSC6.
	CAN_FS1R_FSC7_Pos  = 0x7       // Position of FSC7 field.
	CAN_FS1R_FSC7_Msk  = 0x80      // Bit mask of FSC7 field.
	CAN_FS1R_FSC7      = 0x80      // Bit FSC7.
	CAN_FS1R_FSC8_Pos  = 0x8       // Position of FSC8 field.
	CAN_FS1R_FSC8_Msk  = 0x100     // Bit mask of FSC8 field.
	CAN_FS1R_FSC8      = 0x100     // Bit FSC8.
	CAN_FS1R_FSC9_Pos  = 0x9       // Position of FSC9 field.
	CAN_FS1R_FSC9_Msk  = 0x200     // Bit mask of FSC9 field.
	CAN_FS1R_FSC9      = 0x200     // Bit FSC9.
	CAN_FS1R_FSC10_Pos = 0xa       // Position of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400     // Bit mask of FSC10 field.
	CAN_FS1R_FSC10     = 0x400     // Bit FSC10.
	CAN_FS1R_FSC11_Pos = 0xb       // Position of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800     // Bit mask of FSC11 field.
	CAN_FS1R_FSC11     = 0x800     // Bit FSC11.
	CAN_FS1R_FSC12_Pos = 0xc       // Position of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000    // Bit mask of FSC12 field.
	CAN_FS1R_FSC12     = 0x1000    // Bit FSC12.
	CAN_FS1R_FSC13_Pos = 0xd       // Position of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000    // Bit mask of FSC13 field.
	CAN_FS1R_FSC13     = 0x2000    // Bit FSC13.
	CAN_FS1R_FSC14_Pos = 0xe       // Position of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000    // Bit mask of FSC14 field.
	CAN_FS1R_FSC14     = 0x4000    // Bit FSC14.
	CAN_FS1R_FSC15_Pos = 0xf       // Position of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000    // Bit mask of FSC15 field.
	CAN_FS1R_FSC15     = 0x8000    // Bit FSC15.
	CAN_FS1R_FSC16_Pos = 0x10      // Position of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000   // Bit mask of FSC16 field.
	CAN_FS1R_FSC16     = 0x10000   // Bit FSC16.
	CAN_FS1R_FSC17_Pos = 0x11      // Position of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000   // Bit mask of FSC17 field.
	CAN_FS1R_FSC17     = 0x20000   // Bit FSC17.
	CAN_FS1R_FSC18_Pos = 0x12      // Position of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000   // Bit mask of FSC18 field.
	CAN_FS1R_FSC18     = 0x40000   // Bit FSC18.
	CAN_FS1R_FSC19_Pos = 0x13      // Position of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000   // Bit mask of FSC19 field.
	CAN_FS1R_FSC19     = 0x80000   // Bit FSC19.
	CAN_FS1R_FSC20_Pos = 0x14      // Position of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000  // Bit mask of FSC20 field.
	CAN_FS1R_FSC20     = 0x100000  // Bit FSC20.
	CAN_FS1R_FSC21_Pos = 0x15      // Position of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000  // Bit mask of FSC21 field.
	CAN_FS1R_FSC21     = 0x200000  // Bit FSC21.
	CAN_FS1R_FSC22_Pos = 0x16      // Position of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000  // Bit mask of FSC22 field.
	CAN_FS1R_FSC22     = 0x400000  // Bit FSC22.
	CAN_FS1R_FSC23_Pos = 0x17      // Position of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000  // Bit mask of FSC23 field.
	CAN_FS1R_FSC23     = 0x800000  // Bit FSC23.
	CAN_FS1R_FSC24_Pos = 0x18      // Position of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000 // Bit mask of FSC24 field.
	CAN_FS1R_FSC24     = 0x1000000 // Bit FSC24.
	CAN_FS1R_FSC25_Pos = 0x19      // Position of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000 // Bit mask of FSC25 field.
	CAN_FS1R_FSC25     = 0x2000000 // Bit FSC25.
	CAN_FS1R_FSC26_Pos = 0x1a      // Position of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000 // Bit mask of FSC26 field.
	CAN_FS1R_FSC26     = 0x4000000 // Bit FSC26.
	CAN_FS1R_FSC27_Pos = 0x1b      // Position of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000 // Bit mask of FSC27 field.
	CAN_FS1R_FSC27     = 0x8000000 // Bit FSC27.

	// FFA1R: filter FIFO assignment           register
	CAN_FFA1R_FFA0_Pos  = 0x0       // Position of FFA0 field.
	CAN_FFA1R_FFA0_Msk  = 0x1       // Bit mask of FFA0 field.
	CAN_FFA1R_FFA0      = 0x1       // Bit FFA0.
	CAN_FFA1R_FFA1_Pos  = 0x1       // Position of FFA1 field.
	CAN_FFA1R_FFA1_Msk  = 0x2       // Bit mask of FFA1 field.
	CAN_FFA1R_FFA1      = 0x2       // Bit FFA1.
	CAN_FFA1R_FFA2_Pos  = 0x2       // Position of FFA2 field.
	CAN_FFA1R_FFA2_Msk  = 0x4       // Bit mask of FFA2 field.
	CAN_FFA1R_FFA2      = 0x4       // Bit FFA2.
	CAN_FFA1R_FFA3_Pos  = 0x3       // Position of FFA3 field.
	CAN_FFA1R_FFA3_Msk  = 0x8       // Bit mask of FFA3 field.
	CAN_FFA1R_FFA3      = 0x8       // Bit FFA3.
	CAN_FFA1R_FFA4_Pos  = 0x4       // Position of FFA4 field.
	CAN_FFA1R_FFA4_Msk  = 0x10      // Bit mask of FFA4 field.
	CAN_FFA1R_FFA4      = 0x10      // Bit FFA4.
	CAN_FFA1R_FFA5_Pos  = 0x5       // Position of FFA5 field.
	CAN_FFA1R_FFA5_Msk  = 0x20      // Bit mask of FFA5 field.
	CAN_FFA1R_FFA5      = 0x20      // Bit FFA5.
	CAN_FFA1R_FFA6_Pos  = 0x6       // Position of FFA6 field.
	CAN_FFA1R_FFA6_Msk  = 0x40      // Bit mask of FFA6 field.
	CAN_FFA1R_FFA6      = 0x40      // Bit FFA6.
	CAN_FFA1R_FFA7_Pos  = 0x7       // Position of FFA7 field.
	CAN_FFA1R_FFA7_Msk  = 0x80      // Bit mask of FFA7 field.
	CAN_FFA1R_FFA7      = 0x80      // Bit FFA7.
	CAN_FFA1R_FFA8_Pos  = 0x8       // Position of FFA8 field.
	CAN_FFA1R_FFA8_Msk  = 0x100     // Bit mask of FFA8 field.
	CAN_FFA1R_FFA8      = 0x100     // Bit FFA8.
	CAN_FFA1R_FFA9_Pos  = 0x9       // Position of FFA9 field.
	CAN_FFA1R_FFA9_Msk  = 0x200     // Bit mask of FFA9 field.
	CAN_FFA1R_FFA9      = 0x200     // Bit FFA9.
	CAN_FFA1R_FFA10_Pos = 0xa       // Position of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400     // Bit mask of FFA10 field.
	CAN_FFA1R_FFA10     = 0x400     // Bit FFA10.
	CAN_FFA1R_FFA11_Pos = 0xb       // Position of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800     // Bit mask of FFA11 field.
	CAN_FFA1R_FFA11     = 0x800     // Bit FFA11.
	CAN_FFA1R_FFA12_Pos = 0xc       // Position of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000    // Bit mask of FFA12 field.
	CAN_FFA1R_FFA12     = 0x1000    // Bit FFA12.
	CAN_FFA1R_FFA13_Pos = 0xd       // Position of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000    // Bit mask of FFA13 field.
	CAN_FFA1R_FFA13     = 0x2000    // Bit FFA13.
	CAN_FFA1R_FFA14_Pos = 0xe       // Position of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000    // Bit mask of FFA14 field.
	CAN_FFA1R_FFA14     = 0x4000    // Bit FFA14.
	CAN_FFA1R_FFA15_Pos = 0xf       // Position of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000    // Bit mask of FFA15 field.
	CAN_FFA1R_FFA15     = 0x8000    // Bit FFA15.
	CAN_FFA1R_FFA16_Pos = 0x10      // Position of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000   // Bit mask of FFA16 field.
	CAN_FFA1R_FFA16     = 0x10000   // Bit FFA16.
	CAN_FFA1R_FFA17_Pos = 0x11      // Position of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000   // Bit mask of FFA17 field.
	CAN_FFA1R_FFA17     = 0x20000   // Bit FFA17.
	CAN_FFA1R_FFA18_Pos = 0x12      // Position of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000   // Bit mask of FFA18 field.
	CAN_FFA1R_FFA18     = 0x40000   // Bit FFA18.
	CAN_FFA1R_FFA19_Pos = 0x13      // Position of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000   // Bit mask of FFA19 field.
	CAN_FFA1R_FFA19     = 0x80000   // Bit FFA19.
	CAN_FFA1R_FFA20_Pos = 0x14      // Position of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000  // Bit mask of FFA20 field.
	CAN_FFA1R_FFA20     = 0x100000  // Bit FFA20.
	CAN_FFA1R_FFA21_Pos = 0x15      // Position of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000  // Bit mask of FFA21 field.
	CAN_FFA1R_FFA21     = 0x200000  // Bit FFA21.
	CAN_FFA1R_FFA22_Pos = 0x16      // Position of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000  // Bit mask of FFA22 field.
	CAN_FFA1R_FFA22     = 0x400000  // Bit FFA22.
	CAN_FFA1R_FFA23_Pos = 0x17      // Position of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000  // Bit mask of FFA23 field.
	CAN_FFA1R_FFA23     = 0x800000  // Bit FFA23.
	CAN_FFA1R_FFA24_Pos = 0x18      // Position of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000 // Bit mask of FFA24 field.
	CAN_FFA1R_FFA24     = 0x1000000 // Bit FFA24.
	CAN_FFA1R_FFA25_Pos = 0x19      // Position of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000 // Bit mask of FFA25 field.
	CAN_FFA1R_FFA25     = 0x2000000 // Bit FFA25.
	CAN_FFA1R_FFA26_Pos = 0x1a      // Position of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000 // Bit mask of FFA26 field.
	CAN_FFA1R_FFA26     = 0x4000000 // Bit FFA26.
	CAN_FFA1R_FFA27_Pos = 0x1b      // Position of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000 // Bit mask of FFA27 field.
	CAN_FFA1R_FFA27     = 0x8000000 // Bit FFA27.

	// FA1R: filter activation register
	CAN_FA1R_FACT0_Pos  = 0x0       // Position of FACT0 field.
	CAN_FA1R_FACT0_Msk  = 0x1       // Bit mask of FACT0 field.
	CAN_FA1R_FACT0      = 0x1       // Bit FACT0.
	CAN_FA1R_FACT1_Pos  = 0x1       // Position of FACT1 field.
	CAN_FA1R_FACT1_Msk  = 0x2       // Bit mask of FACT1 field.
	CAN_FA1R_FACT1      = 0x2       // Bit FACT1.
	CAN_FA1R_FACT2_Pos  = 0x2       // Position of FACT2 field.
	CAN_FA1R_FACT2_Msk  = 0x4       // Bit mask of FACT2 field.
	CAN_FA1R_FACT2      = 0x4       // Bit FACT2.
	CAN_FA1R_FACT3_Pos  = 0x3       // Position of FACT3 field.
	CAN_FA1R_FACT3_Msk  = 0x8       // Bit mask of FACT3 field.
	CAN_FA1R_FACT3      = 0x8       // Bit FACT3.
	CAN_FA1R_FACT4_Pos  = 0x4       // Position of FACT4 field.
	CAN_FA1R_FACT4_Msk  = 0x10      // Bit mask of FACT4 field.
	CAN_FA1R_FACT4      = 0x10      // Bit FACT4.
	CAN_FA1R_FACT5_Pos  = 0x5       // Position of FACT5 field.
	CAN_FA1R_FACT5_Msk  = 0x20      // Bit mask of FACT5 field.
	CAN_FA1R_FACT5      = 0x20      // Bit FACT5.
	CAN_FA1R_FACT6_Pos  = 0x6       // Position of FACT6 field.
	CAN_FA1R_FACT6_Msk  = 0x40      // Bit mask of FACT6 field.
	CAN_FA1R_FACT6      = 0x40      // Bit FACT6.
	CAN_FA1R_FACT7_Pos  = 0x7       // Position of FACT7 field.
	CAN_FA1R_FACT7_Msk  = 0x80      // Bit mask of FACT7 field.
	CAN_FA1R_FACT7      = 0x80      // Bit FACT7.
	CAN_FA1R_FACT8_Pos  = 0x8       // Position of FACT8 field.
	CAN_FA1R_FACT8_Msk  = 0x100     // Bit mask of FACT8 field.
	CAN_FA1R_FACT8      = 0x100     // Bit FACT8.
	CAN_FA1R_FACT9_Pos  = 0x9       // Position of FACT9 field.
	CAN_FA1R_FACT9_Msk  = 0x200     // Bit mask of FACT9 field.
	CAN_FA1R_FACT9      = 0x200     // Bit FACT9.
	CAN_FA1R_FACT10_Pos = 0xa       // Position of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400     // Bit mask of FACT10 field.
	CAN_FA1R_FACT10     = 0x400     // Bit FACT10.
	CAN_FA1R_FACT11_Pos = 0xb       // Position of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800     // Bit mask of FACT11 field.
	CAN_FA1R_FACT11     = 0x800     // Bit FACT11.
	CAN_FA1R_FACT12_Pos = 0xc       // Position of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000    // Bit mask of FACT12 field.
	CAN_FA1R_FACT12     = 0x1000    // Bit FACT12.
	CAN_FA1R_FACT13_Pos = 0xd       // Position of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000    // Bit mask of FACT13 field.
	CAN_FA1R_FACT13     = 0x2000    // Bit FACT13.
	CAN_FA1R_FACT14_Pos = 0xe       // Position of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000    // Bit mask of FACT14 field.
	CAN_FA1R_FACT14     = 0x4000    // Bit FACT14.
	CAN_FA1R_FACT15_Pos = 0xf       // Position of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000    // Bit mask of FACT15 field.
	CAN_FA1R_FACT15     = 0x8000    // Bit FACT15.
	CAN_FA1R_FACT16_Pos = 0x10      // Position of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000   // Bit mask of FACT16 field.
	CAN_FA1R_FACT16     = 0x10000   // Bit FACT16.
	CAN_FA1R_FACT17_Pos = 0x11      // Position of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000   // Bit mask of FACT17 field.
	CAN_FA1R_FACT17     = 0x20000   // Bit FACT17.
	CAN_FA1R_FACT18_Pos = 0x12      // Position of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000   // Bit mask of FACT18 field.
	CAN_FA1R_FACT18     = 0x40000   // Bit FACT18.
	CAN_FA1R_FACT19_Pos = 0x13      // Position of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000   // Bit mask of FACT19 field.
	CAN_FA1R_FACT19     = 0x80000   // Bit FACT19.
	CAN_FA1R_FACT20_Pos = 0x14      // Position of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000  // Bit mask of FACT20 field.
	CAN_FA1R_FACT20     = 0x100000  // Bit FACT20.
	CAN_FA1R_FACT21_Pos = 0x15      // Position of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000  // Bit mask of FACT21 field.
	CAN_FA1R_FACT21     = 0x200000  // Bit FACT21.
	CAN_FA1R_FACT22_Pos = 0x16      // Position of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000  // Bit mask of FACT22 field.
	CAN_FA1R_FACT22     = 0x400000  // Bit FACT22.
	CAN_FA1R_FACT23_Pos = 0x17      // Position of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000  // Bit mask of FACT23 field.
	CAN_FA1R_FACT23     = 0x800000  // Bit FACT23.
	CAN_FA1R_FACT24_Pos = 0x18      // Position of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000 // Bit mask of FACT24 field.
	CAN_FA1R_FACT24     = 0x1000000 // Bit FACT24.
	CAN_FA1R_FACT25_Pos = 0x19      // Position of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000 // Bit mask of FACT25 field.
	CAN_FA1R_FACT25     = 0x2000000 // Bit FACT25.
	CAN_FA1R_FACT26_Pos = 0x1a      // Position of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000 // Bit mask of FACT26 field.
	CAN_FA1R_FACT26     = 0x4000000 // Bit FACT26.
	CAN_FA1R_FACT27_Pos = 0x1b      // Position of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000 // Bit mask of FACT27 field.
	CAN_FA1R_FACT27     = 0x8000000 // Bit FACT27.

	// F0R1: Filter bank 0 register 1
	CAN_F0R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R1_FB0      = 0x1        // Bit FB0.
	CAN_F0R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R1_FB1      = 0x2        // Bit FB1.
	CAN_F0R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R1_FB2      = 0x4        // Bit FB2.
	CAN_F0R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R1_FB3      = 0x8        // Bit FB3.
	CAN_F0R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R1_FB4      = 0x10       // Bit FB4.
	CAN_F0R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R1_FB5      = 0x20       // Bit FB5.
	CAN_F0R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R1_FB6      = 0x40       // Bit FB6.
	CAN_F0R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R1_FB7      = 0x80       // Bit FB7.
	CAN_F0R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R1_FB8      = 0x100      // Bit FB8.
	CAN_F0R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R1_FB9      = 0x200      // Bit FB9.
	CAN_F0R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R1_FB10     = 0x400      // Bit FB10.
	CAN_F0R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R1_FB11     = 0x800      // Bit FB11.
	CAN_F0R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R1_FB12     = 0x1000     // Bit FB12.
	CAN_F0R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R1_FB13     = 0x2000     // Bit FB13.
	CAN_F0R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R1_FB14     = 0x4000     // Bit FB14.
	CAN_F0R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R1_FB15     = 0x8000     // Bit FB15.
	CAN_F0R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R1_FB16     = 0x10000    // Bit FB16.
	CAN_F0R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R1_FB17     = 0x20000    // Bit FB17.
	CAN_F0R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R1_FB18     = 0x40000    // Bit FB18.
	CAN_F0R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R1_FB19     = 0x80000    // Bit FB19.
	CAN_F0R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R1_FB20     = 0x100000   // Bit FB20.
	CAN_F0R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R1_FB21     = 0x200000   // Bit FB21.
	CAN_F0R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R1_FB22     = 0x400000   // Bit FB22.
	CAN_F0R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R1_FB23     = 0x800000   // Bit FB23.
	CAN_F0R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R1_FB31     = 0x80000000 // Bit FB31.

	// F0R2: Filter bank 0 register 2
	CAN_F0R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R2_FB0      = 0x1        // Bit FB0.
	CAN_F0R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R2_FB1      = 0x2        // Bit FB1.
	CAN_F0R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R2_FB2      = 0x4        // Bit FB2.
	CAN_F0R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R2_FB3      = 0x8        // Bit FB3.
	CAN_F0R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R2_FB4      = 0x10       // Bit FB4.
	CAN_F0R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R2_FB5      = 0x20       // Bit FB5.
	CAN_F0R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R2_FB6      = 0x40       // Bit FB6.
	CAN_F0R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R2_FB7      = 0x80       // Bit FB7.
	CAN_F0R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R2_FB8      = 0x100      // Bit FB8.
	CAN_F0R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R2_FB9      = 0x200      // Bit FB9.
	CAN_F0R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R2_FB10     = 0x400      // Bit FB10.
	CAN_F0R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R2_FB11     = 0x800      // Bit FB11.
	CAN_F0R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R2_FB12     = 0x1000     // Bit FB12.
	CAN_F0R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R2_FB13     = 0x2000     // Bit FB13.
	CAN_F0R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R2_FB14     = 0x4000     // Bit FB14.
	CAN_F0R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R2_FB15     = 0x8000     // Bit FB15.
	CAN_F0R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R2_FB16     = 0x10000    // Bit FB16.
	CAN_F0R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R2_FB17     = 0x20000    // Bit FB17.
	CAN_F0R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R2_FB18     = 0x40000    // Bit FB18.
	CAN_F0R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R2_FB19     = 0x80000    // Bit FB19.
	CAN_F0R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R2_FB20     = 0x100000   // Bit FB20.
	CAN_F0R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R2_FB21     = 0x200000   // Bit FB21.
	CAN_F0R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R2_FB22     = 0x400000   // Bit FB22.
	CAN_F0R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R2_FB23     = 0x800000   // Bit FB23.
	CAN_F0R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R2_FB31     = 0x80000000 // Bit FB31.

	// F1R1: Filter bank 1 register 1
	CAN_F1R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R1_FB0      = 0x1        // Bit FB0.
	CAN_F1R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R1_FB1      = 0x2        // Bit FB1.
	CAN_F1R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R1_FB2      = 0x4        // Bit FB2.
	CAN_F1R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R1_FB3      = 0x8        // Bit FB3.
	CAN_F1R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R1_FB4      = 0x10       // Bit FB4.
	CAN_F1R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R1_FB5      = 0x20       // Bit FB5.
	CAN_F1R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R1_FB6      = 0x40       // Bit FB6.
	CAN_F1R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R1_FB7      = 0x80       // Bit FB7.
	CAN_F1R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R1_FB8      = 0x100      // Bit FB8.
	CAN_F1R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R1_FB9      = 0x200      // Bit FB9.
	CAN_F1R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R1_FB10     = 0x400      // Bit FB10.
	CAN_F1R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R1_FB11     = 0x800      // Bit FB11.
	CAN_F1R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R1_FB12     = 0x1000     // Bit FB12.
	CAN_F1R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R1_FB13     = 0x2000     // Bit FB13.
	CAN_F1R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R1_FB14     = 0x4000     // Bit FB14.
	CAN_F1R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R1_FB15     = 0x8000     // Bit FB15.
	CAN_F1R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R1_FB16     = 0x10000    // Bit FB16.
	CAN_F1R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R1_FB17     = 0x20000    // Bit FB17.
	CAN_F1R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R1_FB18     = 0x40000    // Bit FB18.
	CAN_F1R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R1_FB19     = 0x80000    // Bit FB19.
	CAN_F1R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R1_FB20     = 0x100000   // Bit FB20.
	CAN_F1R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R1_FB21     = 0x200000   // Bit FB21.
	CAN_F1R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R1_FB22     = 0x400000   // Bit FB22.
	CAN_F1R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R1_FB23     = 0x800000   // Bit FB23.
	CAN_F1R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R1_FB31     = 0x80000000 // Bit FB31.

	// F1R2: Filter bank 1 register 2
	CAN_F1R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R2_FB0      = 0x1        // Bit FB0.
	CAN_F1R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R2_FB1      = 0x2        // Bit FB1.
	CAN_F1R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R2_FB2      = 0x4        // Bit FB2.
	CAN_F1R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R2_FB3      = 0x8        // Bit FB3.
	CAN_F1R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R2_FB4      = 0x10       // Bit FB4.
	CAN_F1R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R2_FB5      = 0x20       // Bit FB5.
	CAN_F1R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R2_FB6      = 0x40       // Bit FB6.
	CAN_F1R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R2_FB7      = 0x80       // Bit FB7.
	CAN_F1R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R2_FB8      = 0x100      // Bit FB8.
	CAN_F1R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R2_FB9      = 0x200      // Bit FB9.
	CAN_F1R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R2_FB10     = 0x400      // Bit FB10.
	CAN_F1R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R2_FB11     = 0x800      // Bit FB11.
	CAN_F1R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R2_FB12     = 0x1000     // Bit FB12.
	CAN_F1R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R2_FB13     = 0x2000     // Bit FB13.
	CAN_F1R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R2_FB14     = 0x4000     // Bit FB14.
	CAN_F1R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R2_FB15     = 0x8000     // Bit FB15.
	CAN_F1R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R2_FB16     = 0x10000    // Bit FB16.
	CAN_F1R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R2_FB17     = 0x20000    // Bit FB17.
	CAN_F1R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R2_FB18     = 0x40000    // Bit FB18.
	CAN_F1R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R2_FB19     = 0x80000    // Bit FB19.
	CAN_F1R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R2_FB20     = 0x100000   // Bit FB20.
	CAN_F1R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R2_FB21     = 0x200000   // Bit FB21.
	CAN_F1R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R2_FB22     = 0x400000   // Bit FB22.
	CAN_F1R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R2_FB23     = 0x800000   // Bit FB23.
	CAN_F1R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R2_FB31     = 0x80000000 // Bit FB31.

	// F2R1: Filter bank 2 register 1
	CAN_F2R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R1_FB0      = 0x1        // Bit FB0.
	CAN_F2R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R1_FB1      = 0x2        // Bit FB1.
	CAN_F2R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R1_FB2      = 0x4        // Bit FB2.
	CAN_F2R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R1_FB3      = 0x8        // Bit FB3.
	CAN_F2R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R1_FB4      = 0x10       // Bit FB4.
	CAN_F2R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R1_FB5      = 0x20       // Bit FB5.
	CAN_F2R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R1_FB6      = 0x40       // Bit FB6.
	CAN_F2R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R1_FB7      = 0x80       // Bit FB7.
	CAN_F2R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R1_FB8      = 0x100      // Bit FB8.
	CAN_F2R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R1_FB9      = 0x200      // Bit FB9.
	CAN_F2R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R1_FB10     = 0x400      // Bit FB10.
	CAN_F2R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R1_FB11     = 0x800      // Bit FB11.
	CAN_F2R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R1_FB12     = 0x1000     // Bit FB12.
	CAN_F2R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R1_FB13     = 0x2000     // Bit FB13.
	CAN_F2R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R1_FB14     = 0x4000     // Bit FB14.
	CAN_F2R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R1_FB15     = 0x8000     // Bit FB15.
	CAN_F2R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R1_FB16     = 0x10000    // Bit FB16.
	CAN_F2R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R1_FB17     = 0x20000    // Bit FB17.
	CAN_F2R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R1_FB18     = 0x40000    // Bit FB18.
	CAN_F2R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R1_FB19     = 0x80000    // Bit FB19.
	CAN_F2R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R1_FB20     = 0x100000   // Bit FB20.
	CAN_F2R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R1_FB21     = 0x200000   // Bit FB21.
	CAN_F2R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R1_FB22     = 0x400000   // Bit FB22.
	CAN_F2R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R1_FB23     = 0x800000   // Bit FB23.
	CAN_F2R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R1_FB31     = 0x80000000 // Bit FB31.

	// F2R2: Filter bank 2 register 2
	CAN_F2R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R2_FB0      = 0x1        // Bit FB0.
	CAN_F2R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R2_FB1      = 0x2        // Bit FB1.
	CAN_F2R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R2_FB2      = 0x4        // Bit FB2.
	CAN_F2R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R2_FB3      = 0x8        // Bit FB3.
	CAN_F2R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R2_FB4      = 0x10       // Bit FB4.
	CAN_F2R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R2_FB5      = 0x20       // Bit FB5.
	CAN_F2R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R2_FB6      = 0x40       // Bit FB6.
	CAN_F2R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R2_FB7      = 0x80       // Bit FB7.
	CAN_F2R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R2_FB8      = 0x100      // Bit FB8.
	CAN_F2R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R2_FB9      = 0x200      // Bit FB9.
	CAN_F2R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R2_FB10     = 0x400      // Bit FB10.
	CAN_F2R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R2_FB11     = 0x800      // Bit FB11.
	CAN_F2R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R2_FB12     = 0x1000     // Bit FB12.
	CAN_F2R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R2_FB13     = 0x2000     // Bit FB13.
	CAN_F2R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R2_FB14     = 0x4000     // Bit FB14.
	CAN_F2R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R2_FB15     = 0x8000     // Bit FB15.
	CAN_F2R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R2_FB16     = 0x10000    // Bit FB16.
	CAN_F2R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R2_FB17     = 0x20000    // Bit FB17.
	CAN_F2R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R2_FB18     = 0x40000    // Bit FB18.
	CAN_F2R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R2_FB19     = 0x80000    // Bit FB19.
	CAN_F2R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R2_FB20     = 0x100000   // Bit FB20.
	CAN_F2R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R2_FB21     = 0x200000   // Bit FB21.
	CAN_F2R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R2_FB22     = 0x400000   // Bit FB22.
	CAN_F2R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R2_FB23     = 0x800000   // Bit FB23.
	CAN_F2R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R2_FB31     = 0x80000000 // Bit FB31.

	// F3R1: Filter bank 3 register 1
	CAN_F3R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R1_FB0      = 0x1        // Bit FB0.
	CAN_F3R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R1_FB1      = 0x2        // Bit FB1.
	CAN_F3R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R1_FB2      = 0x4        // Bit FB2.
	CAN_F3R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R1_FB3      = 0x8        // Bit FB3.
	CAN_F3R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R1_FB4      = 0x10       // Bit FB4.
	CAN_F3R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R1_FB5      = 0x20       // Bit FB5.
	CAN_F3R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R1_FB6      = 0x40       // Bit FB6.
	CAN_F3R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R1_FB7      = 0x80       // Bit FB7.
	CAN_F3R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R1_FB8      = 0x100      // Bit FB8.
	CAN_F3R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R1_FB9      = 0x200      // Bit FB9.
	CAN_F3R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R1_FB10     = 0x400      // Bit FB10.
	CAN_F3R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R1_FB11     = 0x800      // Bit FB11.
	CAN_F3R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R1_FB12     = 0x1000     // Bit FB12.
	CAN_F3R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R1_FB13     = 0x2000     // Bit FB13.
	CAN_F3R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R1_FB14     = 0x4000     // Bit FB14.
	CAN_F3R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R1_FB15     = 0x8000     // Bit FB15.
	CAN_F3R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R1_FB16     = 0x10000    // Bit FB16.
	CAN_F3R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R1_FB17     = 0x20000    // Bit FB17.
	CAN_F3R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R1_FB18     = 0x40000    // Bit FB18.
	CAN_F3R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R1_FB19     = 0x80000    // Bit FB19.
	CAN_F3R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R1_FB20     = 0x100000   // Bit FB20.
	CAN_F3R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R1_FB21     = 0x200000   // Bit FB21.
	CAN_F3R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R1_FB22     = 0x400000   // Bit FB22.
	CAN_F3R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R1_FB23     = 0x800000   // Bit FB23.
	CAN_F3R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R1_FB31     = 0x80000000 // Bit FB31.

	// F3R2: Filter bank 3 register 2
	CAN_F3R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R2_FB0      = 0x1        // Bit FB0.
	CAN_F3R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R2_FB1      = 0x2        // Bit FB1.
	CAN_F3R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R2_FB2      = 0x4        // Bit FB2.
	CAN_F3R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R2_FB3      = 0x8        // Bit FB3.
	CAN_F3R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R2_FB4      = 0x10       // Bit FB4.
	CAN_F3R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R2_FB5      = 0x20       // Bit FB5.
	CAN_F3R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R2_FB6      = 0x40       // Bit FB6.
	CAN_F3R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R2_FB7      = 0x80       // Bit FB7.
	CAN_F3R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R2_FB8      = 0x100      // Bit FB8.
	CAN_F3R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R2_FB9      = 0x200      // Bit FB9.
	CAN_F3R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R2_FB10     = 0x400      // Bit FB10.
	CAN_F3R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R2_FB11     = 0x800      // Bit FB11.
	CAN_F3R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R2_FB12     = 0x1000     // Bit FB12.
	CAN_F3R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R2_FB13     = 0x2000     // Bit FB13.
	CAN_F3R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R2_FB14     = 0x4000     // Bit FB14.
	CAN_F3R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R2_FB15     = 0x8000     // Bit FB15.
	CAN_F3R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R2_FB16     = 0x10000    // Bit FB16.
	CAN_F3R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R2_FB17     = 0x20000    // Bit FB17.
	CAN_F3R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R2_FB18     = 0x40000    // Bit FB18.
	CAN_F3R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R2_FB19     = 0x80000    // Bit FB19.
	CAN_F3R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R2_FB20     = 0x100000   // Bit FB20.
	CAN_F3R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R2_FB21     = 0x200000   // Bit FB21.
	CAN_F3R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R2_FB22     = 0x400000   // Bit FB22.
	CAN_F3R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R2_FB23     = 0x800000   // Bit FB23.
	CAN_F3R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R2_FB31     = 0x80000000 // Bit FB31.

	// F4R1: Filter bank 4 register 1
	CAN_F4R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R1_FB0      = 0x1        // Bit FB0.
	CAN_F4R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R1_FB1      = 0x2        // Bit FB1.
	CAN_F4R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R1_FB2      = 0x4        // Bit FB2.
	CAN_F4R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R1_FB3      = 0x8        // Bit FB3.
	CAN_F4R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R1_FB4      = 0x10       // Bit FB4.
	CAN_F4R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R1_FB5      = 0x20       // Bit FB5.
	CAN_F4R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R1_FB6      = 0x40       // Bit FB6.
	CAN_F4R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R1_FB7      = 0x80       // Bit FB7.
	CAN_F4R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R1_FB8      = 0x100      // Bit FB8.
	CAN_F4R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R1_FB9      = 0x200      // Bit FB9.
	CAN_F4R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R1_FB10     = 0x400      // Bit FB10.
	CAN_F4R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R1_FB11     = 0x800      // Bit FB11.
	CAN_F4R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R1_FB12     = 0x1000     // Bit FB12.
	CAN_F4R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R1_FB13     = 0x2000     // Bit FB13.
	CAN_F4R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R1_FB14     = 0x4000     // Bit FB14.
	CAN_F4R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R1_FB15     = 0x8000     // Bit FB15.
	CAN_F4R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R1_FB16     = 0x10000    // Bit FB16.
	CAN_F4R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R1_FB17     = 0x20000    // Bit FB17.
	CAN_F4R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R1_FB18     = 0x40000    // Bit FB18.
	CAN_F4R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R1_FB19     = 0x80000    // Bit FB19.
	CAN_F4R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R1_FB20     = 0x100000   // Bit FB20.
	CAN_F4R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R1_FB21     = 0x200000   // Bit FB21.
	CAN_F4R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R1_FB22     = 0x400000   // Bit FB22.
	CAN_F4R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R1_FB23     = 0x800000   // Bit FB23.
	CAN_F4R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R1_FB31     = 0x80000000 // Bit FB31.

	// F4R2: Filter bank 4 register 2
	CAN_F4R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R2_FB0      = 0x1        // Bit FB0.
	CAN_F4R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R2_FB1      = 0x2        // Bit FB1.
	CAN_F4R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R2_FB2      = 0x4        // Bit FB2.
	CAN_F4R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R2_FB3      = 0x8        // Bit FB3.
	CAN_F4R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R2_FB4      = 0x10       // Bit FB4.
	CAN_F4R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R2_FB5      = 0x20       // Bit FB5.
	CAN_F4R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R2_FB6      = 0x40       // Bit FB6.
	CAN_F4R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R2_FB7      = 0x80       // Bit FB7.
	CAN_F4R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R2_FB8      = 0x100      // Bit FB8.
	CAN_F4R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R2_FB9      = 0x200      // Bit FB9.
	CAN_F4R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R2_FB10     = 0x400      // Bit FB10.
	CAN_F4R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R2_FB11     = 0x800      // Bit FB11.
	CAN_F4R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R2_FB12     = 0x1000     // Bit FB12.
	CAN_F4R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R2_FB13     = 0x2000     // Bit FB13.
	CAN_F4R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R2_FB14     = 0x4000     // Bit FB14.
	CAN_F4R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R2_FB15     = 0x8000     // Bit FB15.
	CAN_F4R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R2_FB16     = 0x10000    // Bit FB16.
	CAN_F4R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R2_FB17     = 0x20000    // Bit FB17.
	CAN_F4R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R2_FB18     = 0x40000    // Bit FB18.
	CAN_F4R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R2_FB19     = 0x80000    // Bit FB19.
	CAN_F4R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R2_FB20     = 0x100000   // Bit FB20.
	CAN_F4R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R2_FB21     = 0x200000   // Bit FB21.
	CAN_F4R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R2_FB22     = 0x400000   // Bit FB22.
	CAN_F4R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R2_FB23     = 0x800000   // Bit FB23.
	CAN_F4R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R2_FB31     = 0x80000000 // Bit FB31.

	// F5R1: Filter bank 5 register 1
	CAN_F5R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R1_FB0      = 0x1        // Bit FB0.
	CAN_F5R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R1_FB1      = 0x2        // Bit FB1.
	CAN_F5R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R1_FB2      = 0x4        // Bit FB2.
	CAN_F5R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R1_FB3      = 0x8        // Bit FB3.
	CAN_F5R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R1_FB4      = 0x10       // Bit FB4.
	CAN_F5R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R1_FB5      = 0x20       // Bit FB5.
	CAN_F5R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R1_FB6      = 0x40       // Bit FB6.
	CAN_F5R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R1_FB7      = 0x80       // Bit FB7.
	CAN_F5R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R1_FB8      = 0x100      // Bit FB8.
	CAN_F5R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R1_FB9      = 0x200      // Bit FB9.
	CAN_F5R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R1_FB10     = 0x400      // Bit FB10.
	CAN_F5R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R1_FB11     = 0x800      // Bit FB11.
	CAN_F5R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R1_FB12     = 0x1000     // Bit FB12.
	CAN_F5R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R1_FB13     = 0x2000     // Bit FB13.
	CAN_F5R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R1_FB14     = 0x4000     // Bit FB14.
	CAN_F5R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R1_FB15     = 0x8000     // Bit FB15.
	CAN_F5R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R1_FB16     = 0x10000    // Bit FB16.
	CAN_F5R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R1_FB17     = 0x20000    // Bit FB17.
	CAN_F5R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R1_FB18     = 0x40000    // Bit FB18.
	CAN_F5R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R1_FB19     = 0x80000    // Bit FB19.
	CAN_F5R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R1_FB20     = 0x100000   // Bit FB20.
	CAN_F5R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R1_FB21     = 0x200000   // Bit FB21.
	CAN_F5R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R1_FB22     = 0x400000   // Bit FB22.
	CAN_F5R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R1_FB23     = 0x800000   // Bit FB23.
	CAN_F5R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R1_FB31     = 0x80000000 // Bit FB31.

	// F5R2: Filter bank 5 register 2
	CAN_F5R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R2_FB0      = 0x1        // Bit FB0.
	CAN_F5R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R2_FB1      = 0x2        // Bit FB1.
	CAN_F5R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R2_FB2      = 0x4        // Bit FB2.
	CAN_F5R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R2_FB3      = 0x8        // Bit FB3.
	CAN_F5R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R2_FB4      = 0x10       // Bit FB4.
	CAN_F5R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R2_FB5      = 0x20       // Bit FB5.
	CAN_F5R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R2_FB6      = 0x40       // Bit FB6.
	CAN_F5R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R2_FB7      = 0x80       // Bit FB7.
	CAN_F5R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R2_FB8      = 0x100      // Bit FB8.
	CAN_F5R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R2_FB9      = 0x200      // Bit FB9.
	CAN_F5R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R2_FB10     = 0x400      // Bit FB10.
	CAN_F5R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R2_FB11     = 0x800      // Bit FB11.
	CAN_F5R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R2_FB12     = 0x1000     // Bit FB12.
	CAN_F5R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R2_FB13     = 0x2000     // Bit FB13.
	CAN_F5R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R2_FB14     = 0x4000     // Bit FB14.
	CAN_F5R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R2_FB15     = 0x8000     // Bit FB15.
	CAN_F5R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R2_FB16     = 0x10000    // Bit FB16.
	CAN_F5R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R2_FB17     = 0x20000    // Bit FB17.
	CAN_F5R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R2_FB18     = 0x40000    // Bit FB18.
	CAN_F5R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R2_FB19     = 0x80000    // Bit FB19.
	CAN_F5R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R2_FB20     = 0x100000   // Bit FB20.
	CAN_F5R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R2_FB21     = 0x200000   // Bit FB21.
	CAN_F5R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R2_FB22     = 0x400000   // Bit FB22.
	CAN_F5R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R2_FB23     = 0x800000   // Bit FB23.
	CAN_F5R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R2_FB31     = 0x80000000 // Bit FB31.

	// F6R1: Filter bank 6 register 1
	CAN_F6R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R1_FB0      = 0x1        // Bit FB0.
	CAN_F6R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R1_FB1      = 0x2        // Bit FB1.
	CAN_F6R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R1_FB2      = 0x4        // Bit FB2.
	CAN_F6R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R1_FB3      = 0x8        // Bit FB3.
	CAN_F6R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R1_FB4      = 0x10       // Bit FB4.
	CAN_F6R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R1_FB5      = 0x20       // Bit FB5.
	CAN_F6R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R1_FB6      = 0x40       // Bit FB6.
	CAN_F6R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R1_FB7      = 0x80       // Bit FB7.
	CAN_F6R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R1_FB8      = 0x100      // Bit FB8.
	CAN_F6R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R1_FB9      = 0x200      // Bit FB9.
	CAN_F6R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R1_FB10     = 0x400      // Bit FB10.
	CAN_F6R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R1_FB11     = 0x800      // Bit FB11.
	CAN_F6R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R1_FB12     = 0x1000     // Bit FB12.
	CAN_F6R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R1_FB13     = 0x2000     // Bit FB13.
	CAN_F6R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R1_FB14     = 0x4000     // Bit FB14.
	CAN_F6R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R1_FB15     = 0x8000     // Bit FB15.
	CAN_F6R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R1_FB16     = 0x10000    // Bit FB16.
	CAN_F6R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R1_FB17     = 0x20000    // Bit FB17.
	CAN_F6R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R1_FB18     = 0x40000    // Bit FB18.
	CAN_F6R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R1_FB19     = 0x80000    // Bit FB19.
	CAN_F6R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R1_FB20     = 0x100000   // Bit FB20.
	CAN_F6R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R1_FB21     = 0x200000   // Bit FB21.
	CAN_F6R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R1_FB22     = 0x400000   // Bit FB22.
	CAN_F6R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R1_FB23     = 0x800000   // Bit FB23.
	CAN_F6R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R1_FB31     = 0x80000000 // Bit FB31.

	// F6R2: Filter bank 6 register 2
	CAN_F6R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R2_FB0      = 0x1        // Bit FB0.
	CAN_F6R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R2_FB1      = 0x2        // Bit FB1.
	CAN_F6R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R2_FB2      = 0x4        // Bit FB2.
	CAN_F6R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R2_FB3      = 0x8        // Bit FB3.
	CAN_F6R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R2_FB4      = 0x10       // Bit FB4.
	CAN_F6R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R2_FB5      = 0x20       // Bit FB5.
	CAN_F6R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R2_FB6      = 0x40       // Bit FB6.
	CAN_F6R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R2_FB7      = 0x80       // Bit FB7.
	CAN_F6R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R2_FB8      = 0x100      // Bit FB8.
	CAN_F6R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R2_FB9      = 0x200      // Bit FB9.
	CAN_F6R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R2_FB10     = 0x400      // Bit FB10.
	CAN_F6R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R2_FB11     = 0x800      // Bit FB11.
	CAN_F6R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R2_FB12     = 0x1000     // Bit FB12.
	CAN_F6R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R2_FB13     = 0x2000     // Bit FB13.
	CAN_F6R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R2_FB14     = 0x4000     // Bit FB14.
	CAN_F6R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R2_FB15     = 0x8000     // Bit FB15.
	CAN_F6R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R2_FB16     = 0x10000    // Bit FB16.
	CAN_F6R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R2_FB17     = 0x20000    // Bit FB17.
	CAN_F6R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R2_FB18     = 0x40000    // Bit FB18.
	CAN_F6R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R2_FB19     = 0x80000    // Bit FB19.
	CAN_F6R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R2_FB20     = 0x100000   // Bit FB20.
	CAN_F6R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R2_FB21     = 0x200000   // Bit FB21.
	CAN_F6R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R2_FB22     = 0x400000   // Bit FB22.
	CAN_F6R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R2_FB23     = 0x800000   // Bit FB23.
	CAN_F6R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R2_FB31     = 0x80000000 // Bit FB31.

	// F7R1: Filter bank 7 register 1
	CAN_F7R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R1_FB0      = 0x1        // Bit FB0.
	CAN_F7R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R1_FB1      = 0x2        // Bit FB1.
	CAN_F7R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R1_FB2      = 0x4        // Bit FB2.
	CAN_F7R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R1_FB3      = 0x8        // Bit FB3.
	CAN_F7R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R1_FB4      = 0x10       // Bit FB4.
	CAN_F7R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R1_FB5      = 0x20       // Bit FB5.
	CAN_F7R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R1_FB6      = 0x40       // Bit FB6.
	CAN_F7R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R1_FB7      = 0x80       // Bit FB7.
	CAN_F7R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R1_FB8      = 0x100      // Bit FB8.
	CAN_F7R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R1_FB9      = 0x200      // Bit FB9.
	CAN_F7R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R1_FB10     = 0x400      // Bit FB10.
	CAN_F7R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R1_FB11     = 0x800      // Bit FB11.
	CAN_F7R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R1_FB12     = 0x1000     // Bit FB12.
	CAN_F7R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R1_FB13     = 0x2000     // Bit FB13.
	CAN_F7R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R1_FB14     = 0x4000     // Bit FB14.
	CAN_F7R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R1_FB15     = 0x8000     // Bit FB15.
	CAN_F7R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R1_FB16     = 0x10000    // Bit FB16.
	CAN_F7R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R1_FB17     = 0x20000    // Bit FB17.
	CAN_F7R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R1_FB18     = 0x40000    // Bit FB18.
	CAN_F7R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R1_FB19     = 0x80000    // Bit FB19.
	CAN_F7R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R1_FB20     = 0x100000   // Bit FB20.
	CAN_F7R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R1_FB21     = 0x200000   // Bit FB21.
	CAN_F7R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R1_FB22     = 0x400000   // Bit FB22.
	CAN_F7R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R1_FB23     = 0x800000   // Bit FB23.
	CAN_F7R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R1_FB31     = 0x80000000 // Bit FB31.

	// F7R2: Filter bank 7 register 2
	CAN_F7R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R2_FB0      = 0x1        // Bit FB0.
	CAN_F7R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R2_FB1      = 0x2        // Bit FB1.
	CAN_F7R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R2_FB2      = 0x4        // Bit FB2.
	CAN_F7R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R2_FB3      = 0x8        // Bit FB3.
	CAN_F7R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R2_FB4      = 0x10       // Bit FB4.
	CAN_F7R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R2_FB5      = 0x20       // Bit FB5.
	CAN_F7R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R2_FB6      = 0x40       // Bit FB6.
	CAN_F7R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R2_FB7      = 0x80       // Bit FB7.
	CAN_F7R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R2_FB8      = 0x100      // Bit FB8.
	CAN_F7R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R2_FB9      = 0x200      // Bit FB9.
	CAN_F7R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R2_FB10     = 0x400      // Bit FB10.
	CAN_F7R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R2_FB11     = 0x800      // Bit FB11.
	CAN_F7R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R2_FB12     = 0x1000     // Bit FB12.
	CAN_F7R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R2_FB13     = 0x2000     // Bit FB13.
	CAN_F7R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R2_FB14     = 0x4000     // Bit FB14.
	CAN_F7R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R2_FB15     = 0x8000     // Bit FB15.
	CAN_F7R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R2_FB16     = 0x10000    // Bit FB16.
	CAN_F7R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R2_FB17     = 0x20000    // Bit FB17.
	CAN_F7R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R2_FB18     = 0x40000    // Bit FB18.
	CAN_F7R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R2_FB19     = 0x80000    // Bit FB19.
	CAN_F7R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R2_FB20     = 0x100000   // Bit FB20.
	CAN_F7R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R2_FB21     = 0x200000   // Bit FB21.
	CAN_F7R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R2_FB22     = 0x400000   // Bit FB22.
	CAN_F7R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R2_FB23     = 0x800000   // Bit FB23.
	CAN_F7R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R2_FB31     = 0x80000000 // Bit FB31.

	// F8R1: Filter bank 8 register 1
	CAN_F8R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R1_FB0      = 0x1        // Bit FB0.
	CAN_F8R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R1_FB1      = 0x2        // Bit FB1.
	CAN_F8R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R1_FB2      = 0x4        // Bit FB2.
	CAN_F8R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R1_FB3      = 0x8        // Bit FB3.
	CAN_F8R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R1_FB4      = 0x10       // Bit FB4.
	CAN_F8R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R1_FB5      = 0x20       // Bit FB5.
	CAN_F8R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R1_FB6      = 0x40       // Bit FB6.
	CAN_F8R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R1_FB7      = 0x80       // Bit FB7.
	CAN_F8R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R1_FB8      = 0x100      // Bit FB8.
	CAN_F8R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R1_FB9      = 0x200      // Bit FB9.
	CAN_F8R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R1_FB10     = 0x400      // Bit FB10.
	CAN_F8R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R1_FB11     = 0x800      // Bit FB11.
	CAN_F8R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R1_FB12     = 0x1000     // Bit FB12.
	CAN_F8R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R1_FB13     = 0x2000     // Bit FB13.
	CAN_F8R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R1_FB14     = 0x4000     // Bit FB14.
	CAN_F8R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R1_FB15     = 0x8000     // Bit FB15.
	CAN_F8R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R1_FB16     = 0x10000    // Bit FB16.
	CAN_F8R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R1_FB17     = 0x20000    // Bit FB17.
	CAN_F8R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R1_FB18     = 0x40000    // Bit FB18.
	CAN_F8R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R1_FB19     = 0x80000    // Bit FB19.
	CAN_F8R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R1_FB20     = 0x100000   // Bit FB20.
	CAN_F8R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R1_FB21     = 0x200000   // Bit FB21.
	CAN_F8R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R1_FB22     = 0x400000   // Bit FB22.
	CAN_F8R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R1_FB23     = 0x800000   // Bit FB23.
	CAN_F8R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R1_FB31     = 0x80000000 // Bit FB31.

	// F8R2: Filter bank 8 register 2
	CAN_F8R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R2_FB0      = 0x1        // Bit FB0.
	CAN_F8R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R2_FB1      = 0x2        // Bit FB1.
	CAN_F8R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R2_FB2      = 0x4        // Bit FB2.
	CAN_F8R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R2_FB3      = 0x8        // Bit FB3.
	CAN_F8R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R2_FB4      = 0x10       // Bit FB4.
	CAN_F8R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R2_FB5      = 0x20       // Bit FB5.
	CAN_F8R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R2_FB6      = 0x40       // Bit FB6.
	CAN_F8R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R2_FB7      = 0x80       // Bit FB7.
	CAN_F8R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R2_FB8      = 0x100      // Bit FB8.
	CAN_F8R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R2_FB9      = 0x200      // Bit FB9.
	CAN_F8R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R2_FB10     = 0x400      // Bit FB10.
	CAN_F8R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R2_FB11     = 0x800      // Bit FB11.
	CAN_F8R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R2_FB12     = 0x1000     // Bit FB12.
	CAN_F8R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R2_FB13     = 0x2000     // Bit FB13.
	CAN_F8R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R2_FB14     = 0x4000     // Bit FB14.
	CAN_F8R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R2_FB15     = 0x8000     // Bit FB15.
	CAN_F8R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R2_FB16     = 0x10000    // Bit FB16.
	CAN_F8R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R2_FB17     = 0x20000    // Bit FB17.
	CAN_F8R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R2_FB18     = 0x40000    // Bit FB18.
	CAN_F8R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R2_FB19     = 0x80000    // Bit FB19.
	CAN_F8R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R2_FB20     = 0x100000   // Bit FB20.
	CAN_F8R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R2_FB21     = 0x200000   // Bit FB21.
	CAN_F8R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R2_FB22     = 0x400000   // Bit FB22.
	CAN_F8R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R2_FB23     = 0x800000   // Bit FB23.
	CAN_F8R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R2_FB31     = 0x80000000 // Bit FB31.

	// F9R1: Filter bank 9 register 1
	CAN_F9R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R1_FB0      = 0x1        // Bit FB0.
	CAN_F9R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R1_FB1      = 0x2        // Bit FB1.
	CAN_F9R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R1_FB2      = 0x4        // Bit FB2.
	CAN_F9R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R1_FB3      = 0x8        // Bit FB3.
	CAN_F9R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R1_FB4      = 0x10       // Bit FB4.
	CAN_F9R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R1_FB5      = 0x20       // Bit FB5.
	CAN_F9R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R1_FB6      = 0x40       // Bit FB6.
	CAN_F9R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R1_FB7      = 0x80       // Bit FB7.
	CAN_F9R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R1_FB8      = 0x100      // Bit FB8.
	CAN_F9R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R1_FB9      = 0x200      // Bit FB9.
	CAN_F9R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R1_FB10     = 0x400      // Bit FB10.
	CAN_F9R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R1_FB11     = 0x800      // Bit FB11.
	CAN_F9R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R1_FB12     = 0x1000     // Bit FB12.
	CAN_F9R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R1_FB13     = 0x2000     // Bit FB13.
	CAN_F9R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R1_FB14     = 0x4000     // Bit FB14.
	CAN_F9R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R1_FB15     = 0x8000     // Bit FB15.
	CAN_F9R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R1_FB16     = 0x10000    // Bit FB16.
	CAN_F9R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R1_FB17     = 0x20000    // Bit FB17.
	CAN_F9R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R1_FB18     = 0x40000    // Bit FB18.
	CAN_F9R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R1_FB19     = 0x80000    // Bit FB19.
	CAN_F9R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R1_FB20     = 0x100000   // Bit FB20.
	CAN_F9R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R1_FB21     = 0x200000   // Bit FB21.
	CAN_F9R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R1_FB22     = 0x400000   // Bit FB22.
	CAN_F9R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R1_FB23     = 0x800000   // Bit FB23.
	CAN_F9R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R1_FB31     = 0x80000000 // Bit FB31.

	// F9R2: Filter bank 9 register 2
	CAN_F9R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R2_FB0      = 0x1        // Bit FB0.
	CAN_F9R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R2_FB1      = 0x2        // Bit FB1.
	CAN_F9R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R2_FB2      = 0x4        // Bit FB2.
	CAN_F9R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R2_FB3      = 0x8        // Bit FB3.
	CAN_F9R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R2_FB4      = 0x10       // Bit FB4.
	CAN_F9R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R2_FB5      = 0x20       // Bit FB5.
	CAN_F9R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R2_FB6      = 0x40       // Bit FB6.
	CAN_F9R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R2_FB7      = 0x80       // Bit FB7.
	CAN_F9R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R2_FB8      = 0x100      // Bit FB8.
	CAN_F9R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R2_FB9      = 0x200      // Bit FB9.
	CAN_F9R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R2_FB10     = 0x400      // Bit FB10.
	CAN_F9R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R2_FB11     = 0x800      // Bit FB11.
	CAN_F9R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R2_FB12     = 0x1000     // Bit FB12.
	CAN_F9R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R2_FB13     = 0x2000     // Bit FB13.
	CAN_F9R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R2_FB14     = 0x4000     // Bit FB14.
	CAN_F9R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R2_FB15     = 0x8000     // Bit FB15.
	CAN_F9R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R2_FB16     = 0x10000    // Bit FB16.
	CAN_F9R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R2_FB17     = 0x20000    // Bit FB17.
	CAN_F9R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R2_FB18     = 0x40000    // Bit FB18.
	CAN_F9R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R2_FB19     = 0x80000    // Bit FB19.
	CAN_F9R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R2_FB20     = 0x100000   // Bit FB20.
	CAN_F9R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R2_FB21     = 0x200000   // Bit FB21.
	CAN_F9R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R2_FB22     = 0x400000   // Bit FB22.
	CAN_F9R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R2_FB23     = 0x800000   // Bit FB23.
	CAN_F9R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R2_FB31     = 0x80000000 // Bit FB31.

	// F10R1: Filter bank 10 register 1
	CAN_F10R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R1_FB0      = 0x1        // Bit FB0.
	CAN_F10R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R1_FB1      = 0x2        // Bit FB1.
	CAN_F10R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R1_FB2      = 0x4        // Bit FB2.
	CAN_F10R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R1_FB3      = 0x8        // Bit FB3.
	CAN_F10R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R1_FB4      = 0x10       // Bit FB4.
	CAN_F10R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R1_FB5      = 0x20       // Bit FB5.
	CAN_F10R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R1_FB6      = 0x40       // Bit FB6.
	CAN_F10R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R1_FB7      = 0x80       // Bit FB7.
	CAN_F10R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R1_FB8      = 0x100      // Bit FB8.
	CAN_F10R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R1_FB9      = 0x200      // Bit FB9.
	CAN_F10R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R1_FB10     = 0x400      // Bit FB10.
	CAN_F10R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R1_FB11     = 0x800      // Bit FB11.
	CAN_F10R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R1_FB12     = 0x1000     // Bit FB12.
	CAN_F10R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R1_FB13     = 0x2000     // Bit FB13.
	CAN_F10R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R1_FB14     = 0x4000     // Bit FB14.
	CAN_F10R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R1_FB15     = 0x8000     // Bit FB15.
	CAN_F10R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R1_FB16     = 0x10000    // Bit FB16.
	CAN_F10R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R1_FB17     = 0x20000    // Bit FB17.
	CAN_F10R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R1_FB18     = 0x40000    // Bit FB18.
	CAN_F10R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R1_FB19     = 0x80000    // Bit FB19.
	CAN_F10R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R1_FB20     = 0x100000   // Bit FB20.
	CAN_F10R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R1_FB21     = 0x200000   // Bit FB21.
	CAN_F10R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R1_FB22     = 0x400000   // Bit FB22.
	CAN_F10R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R1_FB23     = 0x800000   // Bit FB23.
	CAN_F10R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R1_FB31     = 0x80000000 // Bit FB31.

	// F10R2: Filter bank 10 register 2
	CAN_F10R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R2_FB0      = 0x1        // Bit FB0.
	CAN_F10R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R2_FB1      = 0x2        // Bit FB1.
	CAN_F10R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R2_FB2      = 0x4        // Bit FB2.
	CAN_F10R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R2_FB3      = 0x8        // Bit FB3.
	CAN_F10R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R2_FB4      = 0x10       // Bit FB4.
	CAN_F10R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R2_FB5      = 0x20       // Bit FB5.
	CAN_F10R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R2_FB6      = 0x40       // Bit FB6.
	CAN_F10R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R2_FB7      = 0x80       // Bit FB7.
	CAN_F10R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R2_FB8      = 0x100      // Bit FB8.
	CAN_F10R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R2_FB9      = 0x200      // Bit FB9.
	CAN_F10R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R2_FB10     = 0x400      // Bit FB10.
	CAN_F10R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R2_FB11     = 0x800      // Bit FB11.
	CAN_F10R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R2_FB12     = 0x1000     // Bit FB12.
	CAN_F10R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R2_FB13     = 0x2000     // Bit FB13.
	CAN_F10R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R2_FB14     = 0x4000     // Bit FB14.
	CAN_F10R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R2_FB15     = 0x8000     // Bit FB15.
	CAN_F10R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R2_FB16     = 0x10000    // Bit FB16.
	CAN_F10R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R2_FB17     = 0x20000    // Bit FB17.
	CAN_F10R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R2_FB18     = 0x40000    // Bit FB18.
	CAN_F10R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R2_FB19     = 0x80000    // Bit FB19.
	CAN_F10R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R2_FB20     = 0x100000   // Bit FB20.
	CAN_F10R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R2_FB21     = 0x200000   // Bit FB21.
	CAN_F10R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R2_FB22     = 0x400000   // Bit FB22.
	CAN_F10R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R2_FB23     = 0x800000   // Bit FB23.
	CAN_F10R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R2_FB31     = 0x80000000 // Bit FB31.

	// F11R1: Filter bank 11 register 1
	CAN_F11R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R1_FB0      = 0x1        // Bit FB0.
	CAN_F11R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R1_FB1      = 0x2        // Bit FB1.
	CAN_F11R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R1_FB2      = 0x4        // Bit FB2.
	CAN_F11R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R1_FB3      = 0x8        // Bit FB3.
	CAN_F11R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R1_FB4      = 0x10       // Bit FB4.
	CAN_F11R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R1_FB5      = 0x20       // Bit FB5.
	CAN_F11R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R1_FB6      = 0x40       // Bit FB6.
	CAN_F11R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R1_FB7      = 0x80       // Bit FB7.
	CAN_F11R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R1_FB8      = 0x100      // Bit FB8.
	CAN_F11R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R1_FB9      = 0x200      // Bit FB9.
	CAN_F11R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R1_FB10     = 0x400      // Bit FB10.
	CAN_F11R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R1_FB11     = 0x800      // Bit FB11.
	CAN_F11R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R1_FB12     = 0x1000     // Bit FB12.
	CAN_F11R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R1_FB13     = 0x2000     // Bit FB13.
	CAN_F11R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R1_FB14     = 0x4000     // Bit FB14.
	CAN_F11R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R1_FB15     = 0x8000     // Bit FB15.
	CAN_F11R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R1_FB16     = 0x10000    // Bit FB16.
	CAN_F11R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R1_FB17     = 0x20000    // Bit FB17.
	CAN_F11R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R1_FB18     = 0x40000    // Bit FB18.
	CAN_F11R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R1_FB19     = 0x80000    // Bit FB19.
	CAN_F11R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R1_FB20     = 0x100000   // Bit FB20.
	CAN_F11R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R1_FB21     = 0x200000   // Bit FB21.
	CAN_F11R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R1_FB22     = 0x400000   // Bit FB22.
	CAN_F11R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R1_FB23     = 0x800000   // Bit FB23.
	CAN_F11R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R1_FB31     = 0x80000000 // Bit FB31.

	// F11R2: Filter bank 11 register 2
	CAN_F11R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R2_FB0      = 0x1        // Bit FB0.
	CAN_F11R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R2_FB1      = 0x2        // Bit FB1.
	CAN_F11R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R2_FB2      = 0x4        // Bit FB2.
	CAN_F11R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R2_FB3      = 0x8        // Bit FB3.
	CAN_F11R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R2_FB4      = 0x10       // Bit FB4.
	CAN_F11R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R2_FB5      = 0x20       // Bit FB5.
	CAN_F11R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R2_FB6      = 0x40       // Bit FB6.
	CAN_F11R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R2_FB7      = 0x80       // Bit FB7.
	CAN_F11R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R2_FB8      = 0x100      // Bit FB8.
	CAN_F11R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R2_FB9      = 0x200      // Bit FB9.
	CAN_F11R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R2_FB10     = 0x400      // Bit FB10.
	CAN_F11R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R2_FB11     = 0x800      // Bit FB11.
	CAN_F11R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R2_FB12     = 0x1000     // Bit FB12.
	CAN_F11R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R2_FB13     = 0x2000     // Bit FB13.
	CAN_F11R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R2_FB14     = 0x4000     // Bit FB14.
	CAN_F11R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R2_FB15     = 0x8000     // Bit FB15.
	CAN_F11R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R2_FB16     = 0x10000    // Bit FB16.
	CAN_F11R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R2_FB17     = 0x20000    // Bit FB17.
	CAN_F11R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R2_FB18     = 0x40000    // Bit FB18.
	CAN_F11R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R2_FB19     = 0x80000    // Bit FB19.
	CAN_F11R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R2_FB20     = 0x100000   // Bit FB20.
	CAN_F11R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R2_FB21     = 0x200000   // Bit FB21.
	CAN_F11R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R2_FB22     = 0x400000   // Bit FB22.
	CAN_F11R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R2_FB23     = 0x800000   // Bit FB23.
	CAN_F11R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R2_FB31     = 0x80000000 // Bit FB31.

	// F12R1: Filter bank 4 register 1
	CAN_F12R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R1_FB0      = 0x1        // Bit FB0.
	CAN_F12R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R1_FB1      = 0x2        // Bit FB1.
	CAN_F12R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R1_FB2      = 0x4        // Bit FB2.
	CAN_F12R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R1_FB3      = 0x8        // Bit FB3.
	CAN_F12R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R1_FB4      = 0x10       // Bit FB4.
	CAN_F12R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R1_FB5      = 0x20       // Bit FB5.
	CAN_F12R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R1_FB6      = 0x40       // Bit FB6.
	CAN_F12R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R1_FB7      = 0x80       // Bit FB7.
	CAN_F12R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R1_FB8      = 0x100      // Bit FB8.
	CAN_F12R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R1_FB9      = 0x200      // Bit FB9.
	CAN_F12R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R1_FB10     = 0x400      // Bit FB10.
	CAN_F12R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R1_FB11     = 0x800      // Bit FB11.
	CAN_F12R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R1_FB12     = 0x1000     // Bit FB12.
	CAN_F12R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R1_FB13     = 0x2000     // Bit FB13.
	CAN_F12R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R1_FB14     = 0x4000     // Bit FB14.
	CAN_F12R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R1_FB15     = 0x8000     // Bit FB15.
	CAN_F12R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R1_FB16     = 0x10000    // Bit FB16.
	CAN_F12R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R1_FB17     = 0x20000    // Bit FB17.
	CAN_F12R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R1_FB18     = 0x40000    // Bit FB18.
	CAN_F12R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R1_FB19     = 0x80000    // Bit FB19.
	CAN_F12R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R1_FB20     = 0x100000   // Bit FB20.
	CAN_F12R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R1_FB21     = 0x200000   // Bit FB21.
	CAN_F12R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R1_FB22     = 0x400000   // Bit FB22.
	CAN_F12R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R1_FB23     = 0x800000   // Bit FB23.
	CAN_F12R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R1_FB31     = 0x80000000 // Bit FB31.

	// F12R2: Filter bank 12 register 2
	CAN_F12R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R2_FB0      = 0x1        // Bit FB0.
	CAN_F12R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R2_FB1      = 0x2        // Bit FB1.
	CAN_F12R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R2_FB2      = 0x4        // Bit FB2.
	CAN_F12R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R2_FB3      = 0x8        // Bit FB3.
	CAN_F12R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R2_FB4      = 0x10       // Bit FB4.
	CAN_F12R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R2_FB5      = 0x20       // Bit FB5.
	CAN_F12R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R2_FB6      = 0x40       // Bit FB6.
	CAN_F12R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R2_FB7      = 0x80       // Bit FB7.
	CAN_F12R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R2_FB8      = 0x100      // Bit FB8.
	CAN_F12R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R2_FB9      = 0x200      // Bit FB9.
	CAN_F12R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R2_FB10     = 0x400      // Bit FB10.
	CAN_F12R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R2_FB11     = 0x800      // Bit FB11.
	CAN_F12R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R2_FB12     = 0x1000     // Bit FB12.
	CAN_F12R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R2_FB13     = 0x2000     // Bit FB13.
	CAN_F12R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R2_FB14     = 0x4000     // Bit FB14.
	CAN_F12R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R2_FB15     = 0x8000     // Bit FB15.
	CAN_F12R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R2_FB16     = 0x10000    // Bit FB16.
	CAN_F12R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R2_FB17     = 0x20000    // Bit FB17.
	CAN_F12R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R2_FB18     = 0x40000    // Bit FB18.
	CAN_F12R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R2_FB19     = 0x80000    // Bit FB19.
	CAN_F12R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R2_FB20     = 0x100000   // Bit FB20.
	CAN_F12R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R2_FB21     = 0x200000   // Bit FB21.
	CAN_F12R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R2_FB22     = 0x400000   // Bit FB22.
	CAN_F12R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R2_FB23     = 0x800000   // Bit FB23.
	CAN_F12R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R2_FB31     = 0x80000000 // Bit FB31.

	// F13R1: Filter bank 13 register 1
	CAN_F13R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R1_FB0      = 0x1        // Bit FB0.
	CAN_F13R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R1_FB1      = 0x2        // Bit FB1.
	CAN_F13R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R1_FB2      = 0x4        // Bit FB2.
	CAN_F13R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R1_FB3      = 0x8        // Bit FB3.
	CAN_F13R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R1_FB4      = 0x10       // Bit FB4.
	CAN_F13R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R1_FB5      = 0x20       // Bit FB5.
	CAN_F13R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R1_FB6      = 0x40       // Bit FB6.
	CAN_F13R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R1_FB7      = 0x80       // Bit FB7.
	CAN_F13R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R1_FB8      = 0x100      // Bit FB8.
	CAN_F13R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R1_FB9      = 0x200      // Bit FB9.
	CAN_F13R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R1_FB10     = 0x400      // Bit FB10.
	CAN_F13R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R1_FB11     = 0x800      // Bit FB11.
	CAN_F13R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R1_FB12     = 0x1000     // Bit FB12.
	CAN_F13R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R1_FB13     = 0x2000     // Bit FB13.
	CAN_F13R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R1_FB14     = 0x4000     // Bit FB14.
	CAN_F13R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R1_FB15     = 0x8000     // Bit FB15.
	CAN_F13R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R1_FB16     = 0x10000    // Bit FB16.
	CAN_F13R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R1_FB17     = 0x20000    // Bit FB17.
	CAN_F13R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R1_FB18     = 0x40000    // Bit FB18.
	CAN_F13R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R1_FB19     = 0x80000    // Bit FB19.
	CAN_F13R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R1_FB20     = 0x100000   // Bit FB20.
	CAN_F13R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R1_FB21     = 0x200000   // Bit FB21.
	CAN_F13R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R1_FB22     = 0x400000   // Bit FB22.
	CAN_F13R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R1_FB23     = 0x800000   // Bit FB23.
	CAN_F13R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R1_FB31     = 0x80000000 // Bit FB31.

	// F13R2: Filter bank 13 register 2
	CAN_F13R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R2_FB0      = 0x1        // Bit FB0.
	CAN_F13R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R2_FB1      = 0x2        // Bit FB1.
	CAN_F13R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R2_FB2      = 0x4        // Bit FB2.
	CAN_F13R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R2_FB3      = 0x8        // Bit FB3.
	CAN_F13R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R2_FB4      = 0x10       // Bit FB4.
	CAN_F13R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R2_FB5      = 0x20       // Bit FB5.
	CAN_F13R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R2_FB6      = 0x40       // Bit FB6.
	CAN_F13R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R2_FB7      = 0x80       // Bit FB7.
	CAN_F13R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R2_FB8      = 0x100      // Bit FB8.
	CAN_F13R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R2_FB9      = 0x200      // Bit FB9.
	CAN_F13R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R2_FB10     = 0x400      // Bit FB10.
	CAN_F13R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R2_FB11     = 0x800      // Bit FB11.
	CAN_F13R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R2_FB12     = 0x1000     // Bit FB12.
	CAN_F13R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R2_FB13     = 0x2000     // Bit FB13.
	CAN_F13R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R2_FB14     = 0x4000     // Bit FB14.
	CAN_F13R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R2_FB15     = 0x8000     // Bit FB15.
	CAN_F13R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R2_FB16     = 0x10000    // Bit FB16.
	CAN_F13R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R2_FB17     = 0x20000    // Bit FB17.
	CAN_F13R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R2_FB18     = 0x40000    // Bit FB18.
	CAN_F13R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R2_FB19     = 0x80000    // Bit FB19.
	CAN_F13R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R2_FB20     = 0x100000   // Bit FB20.
	CAN_F13R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R2_FB21     = 0x200000   // Bit FB21.
	CAN_F13R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R2_FB22     = 0x400000   // Bit FB22.
	CAN_F13R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R2_FB23     = 0x800000   // Bit FB23.
	CAN_F13R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R2_FB31     = 0x80000000 // Bit FB31.

	// F14R1: Filter bank 14 register 1
	CAN_F14R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R1_FB0      = 0x1        // Bit FB0.
	CAN_F14R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R1_FB1      = 0x2        // Bit FB1.
	CAN_F14R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R1_FB2      = 0x4        // Bit FB2.
	CAN_F14R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R1_FB3      = 0x8        // Bit FB3.
	CAN_F14R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R1_FB4      = 0x10       // Bit FB4.
	CAN_F14R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R1_FB5      = 0x20       // Bit FB5.
	CAN_F14R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R1_FB6      = 0x40       // Bit FB6.
	CAN_F14R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R1_FB7      = 0x80       // Bit FB7.
	CAN_F14R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R1_FB8      = 0x100      // Bit FB8.
	CAN_F14R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R1_FB9      = 0x200      // Bit FB9.
	CAN_F14R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R1_FB10     = 0x400      // Bit FB10.
	CAN_F14R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R1_FB11     = 0x800      // Bit FB11.
	CAN_F14R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R1_FB12     = 0x1000     // Bit FB12.
	CAN_F14R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R1_FB13     = 0x2000     // Bit FB13.
	CAN_F14R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R1_FB14     = 0x4000     // Bit FB14.
	CAN_F14R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R1_FB15     = 0x8000     // Bit FB15.
	CAN_F14R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R1_FB16     = 0x10000    // Bit FB16.
	CAN_F14R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R1_FB17     = 0x20000    // Bit FB17.
	CAN_F14R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R1_FB18     = 0x40000    // Bit FB18.
	CAN_F14R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R1_FB19     = 0x80000    // Bit FB19.
	CAN_F14R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R1_FB20     = 0x100000   // Bit FB20.
	CAN_F14R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R1_FB21     = 0x200000   // Bit FB21.
	CAN_F14R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R1_FB22     = 0x400000   // Bit FB22.
	CAN_F14R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R1_FB23     = 0x800000   // Bit FB23.
	CAN_F14R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R1_FB31     = 0x80000000 // Bit FB31.

	// F14R2: Filter bank 14 register 2
	CAN_F14R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R2_FB0      = 0x1        // Bit FB0.
	CAN_F14R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R2_FB1      = 0x2        // Bit FB1.
	CAN_F14R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R2_FB2      = 0x4        // Bit FB2.
	CAN_F14R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R2_FB3      = 0x8        // Bit FB3.
	CAN_F14R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R2_FB4      = 0x10       // Bit FB4.
	CAN_F14R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R2_FB5      = 0x20       // Bit FB5.
	CAN_F14R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R2_FB6      = 0x40       // Bit FB6.
	CAN_F14R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R2_FB7      = 0x80       // Bit FB7.
	CAN_F14R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R2_FB8      = 0x100      // Bit FB8.
	CAN_F14R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R2_FB9      = 0x200      // Bit FB9.
	CAN_F14R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R2_FB10     = 0x400      // Bit FB10.
	CAN_F14R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R2_FB11     = 0x800      // Bit FB11.
	CAN_F14R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R2_FB12     = 0x1000     // Bit FB12.
	CAN_F14R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R2_FB13     = 0x2000     // Bit FB13.
	CAN_F14R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R2_FB14     = 0x4000     // Bit FB14.
	CAN_F14R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R2_FB15     = 0x8000     // Bit FB15.
	CAN_F14R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R2_FB16     = 0x10000    // Bit FB16.
	CAN_F14R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R2_FB17     = 0x20000    // Bit FB17.
	CAN_F14R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R2_FB18     = 0x40000    // Bit FB18.
	CAN_F14R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R2_FB19     = 0x80000    // Bit FB19.
	CAN_F14R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R2_FB20     = 0x100000   // Bit FB20.
	CAN_F14R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R2_FB21     = 0x200000   // Bit FB21.
	CAN_F14R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R2_FB22     = 0x400000   // Bit FB22.
	CAN_F14R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R2_FB23     = 0x800000   // Bit FB23.
	CAN_F14R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R2_FB31     = 0x80000000 // Bit FB31.

	// F15R1: Filter bank 15 register 1
	CAN_F15R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R1_FB0      = 0x1        // Bit FB0.
	CAN_F15R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R1_FB1      = 0x2        // Bit FB1.
	CAN_F15R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R1_FB2      = 0x4        // Bit FB2.
	CAN_F15R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R1_FB3      = 0x8        // Bit FB3.
	CAN_F15R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R1_FB4      = 0x10       // Bit FB4.
	CAN_F15R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R1_FB5      = 0x20       // Bit FB5.
	CAN_F15R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R1_FB6      = 0x40       // Bit FB6.
	CAN_F15R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R1_FB7      = 0x80       // Bit FB7.
	CAN_F15R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R1_FB8      = 0x100      // Bit FB8.
	CAN_F15R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R1_FB9      = 0x200      // Bit FB9.
	CAN_F15R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R1_FB10     = 0x400      // Bit FB10.
	CAN_F15R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R1_FB11     = 0x800      // Bit FB11.
	CAN_F15R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R1_FB12     = 0x1000     // Bit FB12.
	CAN_F15R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R1_FB13     = 0x2000     // Bit FB13.
	CAN_F15R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R1_FB14     = 0x4000     // Bit FB14.
	CAN_F15R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R1_FB15     = 0x8000     // Bit FB15.
	CAN_F15R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R1_FB16     = 0x10000    // Bit FB16.
	CAN_F15R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R1_FB17     = 0x20000    // Bit FB17.
	CAN_F15R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R1_FB18     = 0x40000    // Bit FB18.
	CAN_F15R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R1_FB19     = 0x80000    // Bit FB19.
	CAN_F15R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R1_FB20     = 0x100000   // Bit FB20.
	CAN_F15R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R1_FB21     = 0x200000   // Bit FB21.
	CAN_F15R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R1_FB22     = 0x400000   // Bit FB22.
	CAN_F15R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R1_FB23     = 0x800000   // Bit FB23.
	CAN_F15R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R1_FB31     = 0x80000000 // Bit FB31.

	// F15R2: Filter bank 15 register 2
	CAN_F15R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R2_FB0      = 0x1        // Bit FB0.
	CAN_F15R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R2_FB1      = 0x2        // Bit FB1.
	CAN_F15R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R2_FB2      = 0x4        // Bit FB2.
	CAN_F15R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R2_FB3      = 0x8        // Bit FB3.
	CAN_F15R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R2_FB4      = 0x10       // Bit FB4.
	CAN_F15R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R2_FB5      = 0x20       // Bit FB5.
	CAN_F15R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R2_FB6      = 0x40       // Bit FB6.
	CAN_F15R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R2_FB7      = 0x80       // Bit FB7.
	CAN_F15R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R2_FB8      = 0x100      // Bit FB8.
	CAN_F15R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R2_FB9      = 0x200      // Bit FB9.
	CAN_F15R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R2_FB10     = 0x400      // Bit FB10.
	CAN_F15R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R2_FB11     = 0x800      // Bit FB11.
	CAN_F15R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R2_FB12     = 0x1000     // Bit FB12.
	CAN_F15R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R2_FB13     = 0x2000     // Bit FB13.
	CAN_F15R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R2_FB14     = 0x4000     // Bit FB14.
	CAN_F15R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R2_FB15     = 0x8000     // Bit FB15.
	CAN_F15R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R2_FB16     = 0x10000    // Bit FB16.
	CAN_F15R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R2_FB17     = 0x20000    // Bit FB17.
	CAN_F15R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R2_FB18     = 0x40000    // Bit FB18.
	CAN_F15R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R2_FB19     = 0x80000    // Bit FB19.
	CAN_F15R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R2_FB20     = 0x100000   // Bit FB20.
	CAN_F15R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R2_FB21     = 0x200000   // Bit FB21.
	CAN_F15R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R2_FB22     = 0x400000   // Bit FB22.
	CAN_F15R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R2_FB23     = 0x800000   // Bit FB23.
	CAN_F15R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R2_FB31     = 0x80000000 // Bit FB31.

	// F16R1: Filter bank 16 register 1
	CAN_F16R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R1_FB0      = 0x1        // Bit FB0.
	CAN_F16R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R1_FB1      = 0x2        // Bit FB1.
	CAN_F16R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R1_FB2      = 0x4        // Bit FB2.
	CAN_F16R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R1_FB3      = 0x8        // Bit FB3.
	CAN_F16R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R1_FB4      = 0x10       // Bit FB4.
	CAN_F16R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R1_FB5      = 0x20       // Bit FB5.
	CAN_F16R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R1_FB6      = 0x40       // Bit FB6.
	CAN_F16R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R1_FB7      = 0x80       // Bit FB7.
	CAN_F16R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R1_FB8      = 0x100      // Bit FB8.
	CAN_F16R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R1_FB9      = 0x200      // Bit FB9.
	CAN_F16R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R1_FB10     = 0x400      // Bit FB10.
	CAN_F16R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R1_FB11     = 0x800      // Bit FB11.
	CAN_F16R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R1_FB12     = 0x1000     // Bit FB12.
	CAN_F16R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R1_FB13     = 0x2000     // Bit FB13.
	CAN_F16R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R1_FB14     = 0x4000     // Bit FB14.
	CAN_F16R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R1_FB15     = 0x8000     // Bit FB15.
	CAN_F16R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R1_FB16     = 0x10000    // Bit FB16.
	CAN_F16R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R1_FB17     = 0x20000    // Bit FB17.
	CAN_F16R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R1_FB18     = 0x40000    // Bit FB18.
	CAN_F16R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R1_FB19     = 0x80000    // Bit FB19.
	CAN_F16R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R1_FB20     = 0x100000   // Bit FB20.
	CAN_F16R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R1_FB21     = 0x200000   // Bit FB21.
	CAN_F16R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R1_FB22     = 0x400000   // Bit FB22.
	CAN_F16R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R1_FB23     = 0x800000   // Bit FB23.
	CAN_F16R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R1_FB31     = 0x80000000 // Bit FB31.

	// F16R2: Filter bank 16 register 2
	CAN_F16R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R2_FB0      = 0x1        // Bit FB0.
	CAN_F16R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R2_FB1      = 0x2        // Bit FB1.
	CAN_F16R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R2_FB2      = 0x4        // Bit FB2.
	CAN_F16R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R2_FB3      = 0x8        // Bit FB3.
	CAN_F16R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R2_FB4      = 0x10       // Bit FB4.
	CAN_F16R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R2_FB5      = 0x20       // Bit FB5.
	CAN_F16R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R2_FB6      = 0x40       // Bit FB6.
	CAN_F16R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R2_FB7      = 0x80       // Bit FB7.
	CAN_F16R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R2_FB8      = 0x100      // Bit FB8.
	CAN_F16R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R2_FB9      = 0x200      // Bit FB9.
	CAN_F16R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R2_FB10     = 0x400      // Bit FB10.
	CAN_F16R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R2_FB11     = 0x800      // Bit FB11.
	CAN_F16R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R2_FB12     = 0x1000     // Bit FB12.
	CAN_F16R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R2_FB13     = 0x2000     // Bit FB13.
	CAN_F16R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R2_FB14     = 0x4000     // Bit FB14.
	CAN_F16R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R2_FB15     = 0x8000     // Bit FB15.
	CAN_F16R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R2_FB16     = 0x10000    // Bit FB16.
	CAN_F16R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R2_FB17     = 0x20000    // Bit FB17.
	CAN_F16R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R2_FB18     = 0x40000    // Bit FB18.
	CAN_F16R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R2_FB19     = 0x80000    // Bit FB19.
	CAN_F16R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R2_FB20     = 0x100000   // Bit FB20.
	CAN_F16R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R2_FB21     = 0x200000   // Bit FB21.
	CAN_F16R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R2_FB22     = 0x400000   // Bit FB22.
	CAN_F16R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R2_FB23     = 0x800000   // Bit FB23.
	CAN_F16R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R2_FB31     = 0x80000000 // Bit FB31.

	// F17R1: Filter bank 17 register 1
	CAN_F17R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R1_FB0      = 0x1        // Bit FB0.
	CAN_F17R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R1_FB1      = 0x2        // Bit FB1.
	CAN_F17R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R1_FB2      = 0x4        // Bit FB2.
	CAN_F17R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R1_FB3      = 0x8        // Bit FB3.
	CAN_F17R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R1_FB4      = 0x10       // Bit FB4.
	CAN_F17R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R1_FB5      = 0x20       // Bit FB5.
	CAN_F17R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R1_FB6      = 0x40       // Bit FB6.
	CAN_F17R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R1_FB7      = 0x80       // Bit FB7.
	CAN_F17R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R1_FB8      = 0x100      // Bit FB8.
	CAN_F17R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R1_FB9      = 0x200      // Bit FB9.
	CAN_F17R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R1_FB10     = 0x400      // Bit FB10.
	CAN_F17R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R1_FB11     = 0x800      // Bit FB11.
	CAN_F17R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R1_FB12     = 0x1000     // Bit FB12.
	CAN_F17R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R1_FB13     = 0x2000     // Bit FB13.
	CAN_F17R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R1_FB14     = 0x4000     // Bit FB14.
	CAN_F17R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R1_FB15     = 0x8000     // Bit FB15.
	CAN_F17R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R1_FB16     = 0x10000    // Bit FB16.
	CAN_F17R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R1_FB17     = 0x20000    // Bit FB17.
	CAN_F17R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R1_FB18     = 0x40000    // Bit FB18.
	CAN_F17R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R1_FB19     = 0x80000    // Bit FB19.
	CAN_F17R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R1_FB20     = 0x100000   // Bit FB20.
	CAN_F17R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R1_FB21     = 0x200000   // Bit FB21.
	CAN_F17R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R1_FB22     = 0x400000   // Bit FB22.
	CAN_F17R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R1_FB23     = 0x800000   // Bit FB23.
	CAN_F17R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R1_FB31     = 0x80000000 // Bit FB31.

	// F17R2: Filter bank 17 register 2
	CAN_F17R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R2_FB0      = 0x1        // Bit FB0.
	CAN_F17R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R2_FB1      = 0x2        // Bit FB1.
	CAN_F17R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R2_FB2      = 0x4        // Bit FB2.
	CAN_F17R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R2_FB3      = 0x8        // Bit FB3.
	CAN_F17R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R2_FB4      = 0x10       // Bit FB4.
	CAN_F17R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R2_FB5      = 0x20       // Bit FB5.
	CAN_F17R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R2_FB6      = 0x40       // Bit FB6.
	CAN_F17R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R2_FB7      = 0x80       // Bit FB7.
	CAN_F17R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R2_FB8      = 0x100      // Bit FB8.
	CAN_F17R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R2_FB9      = 0x200      // Bit FB9.
	CAN_F17R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R2_FB10     = 0x400      // Bit FB10.
	CAN_F17R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R2_FB11     = 0x800      // Bit FB11.
	CAN_F17R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R2_FB12     = 0x1000     // Bit FB12.
	CAN_F17R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R2_FB13     = 0x2000     // Bit FB13.
	CAN_F17R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R2_FB14     = 0x4000     // Bit FB14.
	CAN_F17R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R2_FB15     = 0x8000     // Bit FB15.
	CAN_F17R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R2_FB16     = 0x10000    // Bit FB16.
	CAN_F17R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R2_FB17     = 0x20000    // Bit FB17.
	CAN_F17R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R2_FB18     = 0x40000    // Bit FB18.
	CAN_F17R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R2_FB19     = 0x80000    // Bit FB19.
	CAN_F17R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R2_FB20     = 0x100000   // Bit FB20.
	CAN_F17R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R2_FB21     = 0x200000   // Bit FB21.
	CAN_F17R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R2_FB22     = 0x400000   // Bit FB22.
	CAN_F17R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R2_FB23     = 0x800000   // Bit FB23.
	CAN_F17R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R2_FB31     = 0x80000000 // Bit FB31.

	// F18R1: Filter bank 18 register 1
	CAN_F18R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R1_FB0      = 0x1        // Bit FB0.
	CAN_F18R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R1_FB1      = 0x2        // Bit FB1.
	CAN_F18R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R1_FB2      = 0x4        // Bit FB2.
	CAN_F18R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R1_FB3      = 0x8        // Bit FB3.
	CAN_F18R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R1_FB4      = 0x10       // Bit FB4.
	CAN_F18R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R1_FB5      = 0x20       // Bit FB5.
	CAN_F18R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R1_FB6      = 0x40       // Bit FB6.
	CAN_F18R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R1_FB7      = 0x80       // Bit FB7.
	CAN_F18R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R1_FB8      = 0x100      // Bit FB8.
	CAN_F18R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R1_FB9      = 0x200      // Bit FB9.
	CAN_F18R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R1_FB10     = 0x400      // Bit FB10.
	CAN_F18R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R1_FB11     = 0x800      // Bit FB11.
	CAN_F18R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R1_FB12     = 0x1000     // Bit FB12.
	CAN_F18R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R1_FB13     = 0x2000     // Bit FB13.
	CAN_F18R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R1_FB14     = 0x4000     // Bit FB14.
	CAN_F18R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R1_FB15     = 0x8000     // Bit FB15.
	CAN_F18R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R1_FB16     = 0x10000    // Bit FB16.
	CAN_F18R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R1_FB17     = 0x20000    // Bit FB17.
	CAN_F18R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R1_FB18     = 0x40000    // Bit FB18.
	CAN_F18R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R1_FB19     = 0x80000    // Bit FB19.
	CAN_F18R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R1_FB20     = 0x100000   // Bit FB20.
	CAN_F18R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R1_FB21     = 0x200000   // Bit FB21.
	CAN_F18R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R1_FB22     = 0x400000   // Bit FB22.
	CAN_F18R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R1_FB23     = 0x800000   // Bit FB23.
	CAN_F18R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R1_FB31     = 0x80000000 // Bit FB31.

	// F18R2: Filter bank 18 register 2
	CAN_F18R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R2_FB0      = 0x1        // Bit FB0.
	CAN_F18R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R2_FB1      = 0x2        // Bit FB1.
	CAN_F18R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R2_FB2      = 0x4        // Bit FB2.
	CAN_F18R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R2_FB3      = 0x8        // Bit FB3.
	CAN_F18R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R2_FB4      = 0x10       // Bit FB4.
	CAN_F18R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R2_FB5      = 0x20       // Bit FB5.
	CAN_F18R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R2_FB6      = 0x40       // Bit FB6.
	CAN_F18R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R2_FB7      = 0x80       // Bit FB7.
	CAN_F18R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R2_FB8      = 0x100      // Bit FB8.
	CAN_F18R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R2_FB9      = 0x200      // Bit FB9.
	CAN_F18R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R2_FB10     = 0x400      // Bit FB10.
	CAN_F18R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R2_FB11     = 0x800      // Bit FB11.
	CAN_F18R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R2_FB12     = 0x1000     // Bit FB12.
	CAN_F18R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R2_FB13     = 0x2000     // Bit FB13.
	CAN_F18R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R2_FB14     = 0x4000     // Bit FB14.
	CAN_F18R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R2_FB15     = 0x8000     // Bit FB15.
	CAN_F18R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R2_FB16     = 0x10000    // Bit FB16.
	CAN_F18R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R2_FB17     = 0x20000    // Bit FB17.
	CAN_F18R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R2_FB18     = 0x40000    // Bit FB18.
	CAN_F18R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R2_FB19     = 0x80000    // Bit FB19.
	CAN_F18R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R2_FB20     = 0x100000   // Bit FB20.
	CAN_F18R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R2_FB21     = 0x200000   // Bit FB21.
	CAN_F18R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R2_FB22     = 0x400000   // Bit FB22.
	CAN_F18R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R2_FB23     = 0x800000   // Bit FB23.
	CAN_F18R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R2_FB31     = 0x80000000 // Bit FB31.

	// F19R1: Filter bank 19 register 1
	CAN_F19R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R1_FB0      = 0x1        // Bit FB0.
	CAN_F19R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R1_FB1      = 0x2        // Bit FB1.
	CAN_F19R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R1_FB2      = 0x4        // Bit FB2.
	CAN_F19R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R1_FB3      = 0x8        // Bit FB3.
	CAN_F19R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R1_FB4      = 0x10       // Bit FB4.
	CAN_F19R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R1_FB5      = 0x20       // Bit FB5.
	CAN_F19R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R1_FB6      = 0x40       // Bit FB6.
	CAN_F19R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R1_FB7      = 0x80       // Bit FB7.
	CAN_F19R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R1_FB8      = 0x100      // Bit FB8.
	CAN_F19R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R1_FB9      = 0x200      // Bit FB9.
	CAN_F19R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R1_FB10     = 0x400      // Bit FB10.
	CAN_F19R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R1_FB11     = 0x800      // Bit FB11.
	CAN_F19R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R1_FB12     = 0x1000     // Bit FB12.
	CAN_F19R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R1_FB13     = 0x2000     // Bit FB13.
	CAN_F19R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R1_FB14     = 0x4000     // Bit FB14.
	CAN_F19R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R1_FB15     = 0x8000     // Bit FB15.
	CAN_F19R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R1_FB16     = 0x10000    // Bit FB16.
	CAN_F19R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R1_FB17     = 0x20000    // Bit FB17.
	CAN_F19R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R1_FB18     = 0x40000    // Bit FB18.
	CAN_F19R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R1_FB19     = 0x80000    // Bit FB19.
	CAN_F19R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R1_FB20     = 0x100000   // Bit FB20.
	CAN_F19R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R1_FB21     = 0x200000   // Bit FB21.
	CAN_F19R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R1_FB22     = 0x400000   // Bit FB22.
	CAN_F19R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R1_FB23     = 0x800000   // Bit FB23.
	CAN_F19R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R1_FB31     = 0x80000000 // Bit FB31.

	// F19R2: Filter bank 19 register 2
	CAN_F19R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R2_FB0      = 0x1        // Bit FB0.
	CAN_F19R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R2_FB1      = 0x2        // Bit FB1.
	CAN_F19R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R2_FB2      = 0x4        // Bit FB2.
	CAN_F19R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R2_FB3      = 0x8        // Bit FB3.
	CAN_F19R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R2_FB4      = 0x10       // Bit FB4.
	CAN_F19R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R2_FB5      = 0x20       // Bit FB5.
	CAN_F19R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R2_FB6      = 0x40       // Bit FB6.
	CAN_F19R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R2_FB7      = 0x80       // Bit FB7.
	CAN_F19R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R2_FB8      = 0x100      // Bit FB8.
	CAN_F19R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R2_FB9      = 0x200      // Bit FB9.
	CAN_F19R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R2_FB10     = 0x400      // Bit FB10.
	CAN_F19R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R2_FB11     = 0x800      // Bit FB11.
	CAN_F19R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R2_FB12     = 0x1000     // Bit FB12.
	CAN_F19R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R2_FB13     = 0x2000     // Bit FB13.
	CAN_F19R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R2_FB14     = 0x4000     // Bit FB14.
	CAN_F19R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R2_FB15     = 0x8000     // Bit FB15.
	CAN_F19R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R2_FB16     = 0x10000    // Bit FB16.
	CAN_F19R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R2_FB17     = 0x20000    // Bit FB17.
	CAN_F19R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R2_FB18     = 0x40000    // Bit FB18.
	CAN_F19R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R2_FB19     = 0x80000    // Bit FB19.
	CAN_F19R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R2_FB20     = 0x100000   // Bit FB20.
	CAN_F19R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R2_FB21     = 0x200000   // Bit FB21.
	CAN_F19R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R2_FB22     = 0x400000   // Bit FB22.
	CAN_F19R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R2_FB23     = 0x800000   // Bit FB23.
	CAN_F19R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R2_FB31     = 0x80000000 // Bit FB31.

	// F20R1: Filter bank 20 register 1
	CAN_F20R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R1_FB0      = 0x1        // Bit FB0.
	CAN_F20R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R1_FB1      = 0x2        // Bit FB1.
	CAN_F20R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R1_FB2      = 0x4        // Bit FB2.
	CAN_F20R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R1_FB3      = 0x8        // Bit FB3.
	CAN_F20R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R1_FB4      = 0x10       // Bit FB4.
	CAN_F20R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R1_FB5      = 0x20       // Bit FB5.
	CAN_F20R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R1_FB6      = 0x40       // Bit FB6.
	CAN_F20R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R1_FB7      = 0x80       // Bit FB7.
	CAN_F20R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R1_FB8      = 0x100      // Bit FB8.
	CAN_F20R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R1_FB9      = 0x200      // Bit FB9.
	CAN_F20R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R1_FB10     = 0x400      // Bit FB10.
	CAN_F20R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R1_FB11     = 0x800      // Bit FB11.
	CAN_F20R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R1_FB12     = 0x1000     // Bit FB12.
	CAN_F20R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R1_FB13     = 0x2000     // Bit FB13.
	CAN_F20R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R1_FB14     = 0x4000     // Bit FB14.
	CAN_F20R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R1_FB15     = 0x8000     // Bit FB15.
	CAN_F20R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R1_FB16     = 0x10000    // Bit FB16.
	CAN_F20R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R1_FB17     = 0x20000    // Bit FB17.
	CAN_F20R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R1_FB18     = 0x40000    // Bit FB18.
	CAN_F20R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R1_FB19     = 0x80000    // Bit FB19.
	CAN_F20R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R1_FB20     = 0x100000   // Bit FB20.
	CAN_F20R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R1_FB21     = 0x200000   // Bit FB21.
	CAN_F20R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R1_FB22     = 0x400000   // Bit FB22.
	CAN_F20R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R1_FB23     = 0x800000   // Bit FB23.
	CAN_F20R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R1_FB31     = 0x80000000 // Bit FB31.

	// F20R2: Filter bank 20 register 2
	CAN_F20R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R2_FB0      = 0x1        // Bit FB0.
	CAN_F20R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R2_FB1      = 0x2        // Bit FB1.
	CAN_F20R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R2_FB2      = 0x4        // Bit FB2.
	CAN_F20R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R2_FB3      = 0x8        // Bit FB3.
	CAN_F20R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R2_FB4      = 0x10       // Bit FB4.
	CAN_F20R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R2_FB5      = 0x20       // Bit FB5.
	CAN_F20R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R2_FB6      = 0x40       // Bit FB6.
	CAN_F20R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R2_FB7      = 0x80       // Bit FB7.
	CAN_F20R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R2_FB8      = 0x100      // Bit FB8.
	CAN_F20R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R2_FB9      = 0x200      // Bit FB9.
	CAN_F20R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R2_FB10     = 0x400      // Bit FB10.
	CAN_F20R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R2_FB11     = 0x800      // Bit FB11.
	CAN_F20R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R2_FB12     = 0x1000     // Bit FB12.
	CAN_F20R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R2_FB13     = 0x2000     // Bit FB13.
	CAN_F20R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R2_FB14     = 0x4000     // Bit FB14.
	CAN_F20R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R2_FB15     = 0x8000     // Bit FB15.
	CAN_F20R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R2_FB16     = 0x10000    // Bit FB16.
	CAN_F20R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R2_FB17     = 0x20000    // Bit FB17.
	CAN_F20R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R2_FB18     = 0x40000    // Bit FB18.
	CAN_F20R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R2_FB19     = 0x80000    // Bit FB19.
	CAN_F20R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R2_FB20     = 0x100000   // Bit FB20.
	CAN_F20R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R2_FB21     = 0x200000   // Bit FB21.
	CAN_F20R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R2_FB22     = 0x400000   // Bit FB22.
	CAN_F20R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R2_FB23     = 0x800000   // Bit FB23.
	CAN_F20R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R2_FB31     = 0x80000000 // Bit FB31.

	// F21R1: Filter bank 21 register 1
	CAN_F21R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R1_FB0      = 0x1        // Bit FB0.
	CAN_F21R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R1_FB1      = 0x2        // Bit FB1.
	CAN_F21R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R1_FB2      = 0x4        // Bit FB2.
	CAN_F21R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R1_FB3      = 0x8        // Bit FB3.
	CAN_F21R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R1_FB4      = 0x10       // Bit FB4.
	CAN_F21R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R1_FB5      = 0x20       // Bit FB5.
	CAN_F21R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R1_FB6      = 0x40       // Bit FB6.
	CAN_F21R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R1_FB7      = 0x80       // Bit FB7.
	CAN_F21R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R1_FB8      = 0x100      // Bit FB8.
	CAN_F21R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R1_FB9      = 0x200      // Bit FB9.
	CAN_F21R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R1_FB10     = 0x400      // Bit FB10.
	CAN_F21R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R1_FB11     = 0x800      // Bit FB11.
	CAN_F21R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R1_FB12     = 0x1000     // Bit FB12.
	CAN_F21R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R1_FB13     = 0x2000     // Bit FB13.
	CAN_F21R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R1_FB14     = 0x4000     // Bit FB14.
	CAN_F21R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R1_FB15     = 0x8000     // Bit FB15.
	CAN_F21R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R1_FB16     = 0x10000    // Bit FB16.
	CAN_F21R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R1_FB17     = 0x20000    // Bit FB17.
	CAN_F21R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R1_FB18     = 0x40000    // Bit FB18.
	CAN_F21R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R1_FB19     = 0x80000    // Bit FB19.
	CAN_F21R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R1_FB20     = 0x100000   // Bit FB20.
	CAN_F21R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R1_FB21     = 0x200000   // Bit FB21.
	CAN_F21R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R1_FB22     = 0x400000   // Bit FB22.
	CAN_F21R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R1_FB23     = 0x800000   // Bit FB23.
	CAN_F21R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R1_FB31     = 0x80000000 // Bit FB31.

	// F21R2: Filter bank 21 register 2
	CAN_F21R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R2_FB0      = 0x1        // Bit FB0.
	CAN_F21R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R2_FB1      = 0x2        // Bit FB1.
	CAN_F21R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R2_FB2      = 0x4        // Bit FB2.
	CAN_F21R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R2_FB3      = 0x8        // Bit FB3.
	CAN_F21R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R2_FB4      = 0x10       // Bit FB4.
	CAN_F21R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R2_FB5      = 0x20       // Bit FB5.
	CAN_F21R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R2_FB6      = 0x40       // Bit FB6.
	CAN_F21R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R2_FB7      = 0x80       // Bit FB7.
	CAN_F21R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R2_FB8      = 0x100      // Bit FB8.
	CAN_F21R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R2_FB9      = 0x200      // Bit FB9.
	CAN_F21R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R2_FB10     = 0x400      // Bit FB10.
	CAN_F21R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R2_FB11     = 0x800      // Bit FB11.
	CAN_F21R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R2_FB12     = 0x1000     // Bit FB12.
	CAN_F21R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R2_FB13     = 0x2000     // Bit FB13.
	CAN_F21R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R2_FB14     = 0x4000     // Bit FB14.
	CAN_F21R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R2_FB15     = 0x8000     // Bit FB15.
	CAN_F21R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R2_FB16     = 0x10000    // Bit FB16.
	CAN_F21R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R2_FB17     = 0x20000    // Bit FB17.
	CAN_F21R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R2_FB18     = 0x40000    // Bit FB18.
	CAN_F21R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R2_FB19     = 0x80000    // Bit FB19.
	CAN_F21R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R2_FB20     = 0x100000   // Bit FB20.
	CAN_F21R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R2_FB21     = 0x200000   // Bit FB21.
	CAN_F21R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R2_FB22     = 0x400000   // Bit FB22.
	CAN_F21R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R2_FB23     = 0x800000   // Bit FB23.
	CAN_F21R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R2_FB31     = 0x80000000 // Bit FB31.

	// F22R1: Filter bank 22 register 1
	CAN_F22R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R1_FB0      = 0x1        // Bit FB0.
	CAN_F22R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R1_FB1      = 0x2        // Bit FB1.
	CAN_F22R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R1_FB2      = 0x4        // Bit FB2.
	CAN_F22R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R1_FB3      = 0x8        // Bit FB3.
	CAN_F22R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R1_FB4      = 0x10       // Bit FB4.
	CAN_F22R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R1_FB5      = 0x20       // Bit FB5.
	CAN_F22R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R1_FB6      = 0x40       // Bit FB6.
	CAN_F22R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R1_FB7      = 0x80       // Bit FB7.
	CAN_F22R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R1_FB8      = 0x100      // Bit FB8.
	CAN_F22R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R1_FB9      = 0x200      // Bit FB9.
	CAN_F22R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R1_FB10     = 0x400      // Bit FB10.
	CAN_F22R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R1_FB11     = 0x800      // Bit FB11.
	CAN_F22R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R1_FB12     = 0x1000     // Bit FB12.
	CAN_F22R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R1_FB13     = 0x2000     // Bit FB13.
	CAN_F22R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R1_FB14     = 0x4000     // Bit FB14.
	CAN_F22R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R1_FB15     = 0x8000     // Bit FB15.
	CAN_F22R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R1_FB16     = 0x10000    // Bit FB16.
	CAN_F22R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R1_FB17     = 0x20000    // Bit FB17.
	CAN_F22R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R1_FB18     = 0x40000    // Bit FB18.
	CAN_F22R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R1_FB19     = 0x80000    // Bit FB19.
	CAN_F22R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R1_FB20     = 0x100000   // Bit FB20.
	CAN_F22R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R1_FB21     = 0x200000   // Bit FB21.
	CAN_F22R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R1_FB22     = 0x400000   // Bit FB22.
	CAN_F22R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R1_FB23     = 0x800000   // Bit FB23.
	CAN_F22R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R1_FB31     = 0x80000000 // Bit FB31.

	// F22R2: Filter bank 22 register 2
	CAN_F22R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R2_FB0      = 0x1        // Bit FB0.
	CAN_F22R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R2_FB1      = 0x2        // Bit FB1.
	CAN_F22R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R2_FB2      = 0x4        // Bit FB2.
	CAN_F22R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R2_FB3      = 0x8        // Bit FB3.
	CAN_F22R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R2_FB4      = 0x10       // Bit FB4.
	CAN_F22R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R2_FB5      = 0x20       // Bit FB5.
	CAN_F22R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R2_FB6      = 0x40       // Bit FB6.
	CAN_F22R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R2_FB7      = 0x80       // Bit FB7.
	CAN_F22R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R2_FB8      = 0x100      // Bit FB8.
	CAN_F22R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R2_FB9      = 0x200      // Bit FB9.
	CAN_F22R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R2_FB10     = 0x400      // Bit FB10.
	CAN_F22R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R2_FB11     = 0x800      // Bit FB11.
	CAN_F22R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R2_FB12     = 0x1000     // Bit FB12.
	CAN_F22R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R2_FB13     = 0x2000     // Bit FB13.
	CAN_F22R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R2_FB14     = 0x4000     // Bit FB14.
	CAN_F22R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R2_FB15     = 0x8000     // Bit FB15.
	CAN_F22R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R2_FB16     = 0x10000    // Bit FB16.
	CAN_F22R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R2_FB17     = 0x20000    // Bit FB17.
	CAN_F22R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R2_FB18     = 0x40000    // Bit FB18.
	CAN_F22R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R2_FB19     = 0x80000    // Bit FB19.
	CAN_F22R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R2_FB20     = 0x100000   // Bit FB20.
	CAN_F22R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R2_FB21     = 0x200000   // Bit FB21.
	CAN_F22R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R2_FB22     = 0x400000   // Bit FB22.
	CAN_F22R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R2_FB23     = 0x800000   // Bit FB23.
	CAN_F22R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R2_FB31     = 0x80000000 // Bit FB31.

	// F23R1: Filter bank 23 register 1
	CAN_F23R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R1_FB0      = 0x1        // Bit FB0.
	CAN_F23R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R1_FB1      = 0x2        // Bit FB1.
	CAN_F23R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R1_FB2      = 0x4        // Bit FB2.
	CAN_F23R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R1_FB3      = 0x8        // Bit FB3.
	CAN_F23R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R1_FB4      = 0x10       // Bit FB4.
	CAN_F23R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R1_FB5      = 0x20       // Bit FB5.
	CAN_F23R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R1_FB6      = 0x40       // Bit FB6.
	CAN_F23R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R1_FB7      = 0x80       // Bit FB7.
	CAN_F23R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R1_FB8      = 0x100      // Bit FB8.
	CAN_F23R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R1_FB9      = 0x200      // Bit FB9.
	CAN_F23R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R1_FB10     = 0x400      // Bit FB10.
	CAN_F23R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R1_FB11     = 0x800      // Bit FB11.
	CAN_F23R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R1_FB12     = 0x1000     // Bit FB12.
	CAN_F23R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R1_FB13     = 0x2000     // Bit FB13.
	CAN_F23R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R1_FB14     = 0x4000     // Bit FB14.
	CAN_F23R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R1_FB15     = 0x8000     // Bit FB15.
	CAN_F23R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R1_FB16     = 0x10000    // Bit FB16.
	CAN_F23R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R1_FB17     = 0x20000    // Bit FB17.
	CAN_F23R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R1_FB18     = 0x40000    // Bit FB18.
	CAN_F23R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R1_FB19     = 0x80000    // Bit FB19.
	CAN_F23R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R1_FB20     = 0x100000   // Bit FB20.
	CAN_F23R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R1_FB21     = 0x200000   // Bit FB21.
	CAN_F23R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R1_FB22     = 0x400000   // Bit FB22.
	CAN_F23R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R1_FB23     = 0x800000   // Bit FB23.
	CAN_F23R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R1_FB31     = 0x80000000 // Bit FB31.

	// F23R2: Filter bank 23 register 2
	CAN_F23R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R2_FB0      = 0x1        // Bit FB0.
	CAN_F23R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R2_FB1      = 0x2        // Bit FB1.
	CAN_F23R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R2_FB2      = 0x4        // Bit FB2.
	CAN_F23R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R2_FB3      = 0x8        // Bit FB3.
	CAN_F23R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R2_FB4      = 0x10       // Bit FB4.
	CAN_F23R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R2_FB5      = 0x20       // Bit FB5.
	CAN_F23R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R2_FB6      = 0x40       // Bit FB6.
	CAN_F23R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R2_FB7      = 0x80       // Bit FB7.
	CAN_F23R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R2_FB8      = 0x100      // Bit FB8.
	CAN_F23R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R2_FB9      = 0x200      // Bit FB9.
	CAN_F23R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R2_FB10     = 0x400      // Bit FB10.
	CAN_F23R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R2_FB11     = 0x800      // Bit FB11.
	CAN_F23R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R2_FB12     = 0x1000     // Bit FB12.
	CAN_F23R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R2_FB13     = 0x2000     // Bit FB13.
	CAN_F23R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R2_FB14     = 0x4000     // Bit FB14.
	CAN_F23R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R2_FB15     = 0x8000     // Bit FB15.
	CAN_F23R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R2_FB16     = 0x10000    // Bit FB16.
	CAN_F23R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R2_FB17     = 0x20000    // Bit FB17.
	CAN_F23R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R2_FB18     = 0x40000    // Bit FB18.
	CAN_F23R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R2_FB19     = 0x80000    // Bit FB19.
	CAN_F23R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R2_FB20     = 0x100000   // Bit FB20.
	CAN_F23R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R2_FB21     = 0x200000   // Bit FB21.
	CAN_F23R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R2_FB22     = 0x400000   // Bit FB22.
	CAN_F23R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R2_FB23     = 0x800000   // Bit FB23.
	CAN_F23R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R2_FB31     = 0x80000000 // Bit FB31.

	// F24R1: Filter bank 24 register 1
	CAN_F24R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R1_FB0      = 0x1        // Bit FB0.
	CAN_F24R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R1_FB1      = 0x2        // Bit FB1.
	CAN_F24R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R1_FB2      = 0x4        // Bit FB2.
	CAN_F24R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R1_FB3      = 0x8        // Bit FB3.
	CAN_F24R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R1_FB4      = 0x10       // Bit FB4.
	CAN_F24R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R1_FB5      = 0x20       // Bit FB5.
	CAN_F24R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R1_FB6      = 0x40       // Bit FB6.
	CAN_F24R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R1_FB7      = 0x80       // Bit FB7.
	CAN_F24R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R1_FB8      = 0x100      // Bit FB8.
	CAN_F24R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R1_FB9      = 0x200      // Bit FB9.
	CAN_F24R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R1_FB10     = 0x400      // Bit FB10.
	CAN_F24R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R1_FB11     = 0x800      // Bit FB11.
	CAN_F24R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R1_FB12     = 0x1000     // Bit FB12.
	CAN_F24R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R1_FB13     = 0x2000     // Bit FB13.
	CAN_F24R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R1_FB14     = 0x4000     // Bit FB14.
	CAN_F24R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R1_FB15     = 0x8000     // Bit FB15.
	CAN_F24R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R1_FB16     = 0x10000    // Bit FB16.
	CAN_F24R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R1_FB17     = 0x20000    // Bit FB17.
	CAN_F24R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R1_FB18     = 0x40000    // Bit FB18.
	CAN_F24R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R1_FB19     = 0x80000    // Bit FB19.
	CAN_F24R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R1_FB20     = 0x100000   // Bit FB20.
	CAN_F24R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R1_FB21     = 0x200000   // Bit FB21.
	CAN_F24R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R1_FB22     = 0x400000   // Bit FB22.
	CAN_F24R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R1_FB23     = 0x800000   // Bit FB23.
	CAN_F24R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R1_FB31     = 0x80000000 // Bit FB31.

	// F24R2: Filter bank 24 register 2
	CAN_F24R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R2_FB0      = 0x1        // Bit FB0.
	CAN_F24R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R2_FB1      = 0x2        // Bit FB1.
	CAN_F24R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R2_FB2      = 0x4        // Bit FB2.
	CAN_F24R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R2_FB3      = 0x8        // Bit FB3.
	CAN_F24R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R2_FB4      = 0x10       // Bit FB4.
	CAN_F24R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R2_FB5      = 0x20       // Bit FB5.
	CAN_F24R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R2_FB6      = 0x40       // Bit FB6.
	CAN_F24R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R2_FB7      = 0x80       // Bit FB7.
	CAN_F24R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R2_FB8      = 0x100      // Bit FB8.
	CAN_F24R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R2_FB9      = 0x200      // Bit FB9.
	CAN_F24R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R2_FB10     = 0x400      // Bit FB10.
	CAN_F24R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R2_FB11     = 0x800      // Bit FB11.
	CAN_F24R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R2_FB12     = 0x1000     // Bit FB12.
	CAN_F24R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R2_FB13     = 0x2000     // Bit FB13.
	CAN_F24R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R2_FB14     = 0x4000     // Bit FB14.
	CAN_F24R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R2_FB15     = 0x8000     // Bit FB15.
	CAN_F24R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R2_FB16     = 0x10000    // Bit FB16.
	CAN_F24R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R2_FB17     = 0x20000    // Bit FB17.
	CAN_F24R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R2_FB18     = 0x40000    // Bit FB18.
	CAN_F24R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R2_FB19     = 0x80000    // Bit FB19.
	CAN_F24R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R2_FB20     = 0x100000   // Bit FB20.
	CAN_F24R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R2_FB21     = 0x200000   // Bit FB21.
	CAN_F24R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R2_FB22     = 0x400000   // Bit FB22.
	CAN_F24R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R2_FB23     = 0x800000   // Bit FB23.
	CAN_F24R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R2_FB31     = 0x80000000 // Bit FB31.

	// F25R1: Filter bank 25 register 1
	CAN_F25R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R1_FB0      = 0x1        // Bit FB0.
	CAN_F25R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R1_FB1      = 0x2        // Bit FB1.
	CAN_F25R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R1_FB2      = 0x4        // Bit FB2.
	CAN_F25R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R1_FB3      = 0x8        // Bit FB3.
	CAN_F25R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R1_FB4      = 0x10       // Bit FB4.
	CAN_F25R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R1_FB5      = 0x20       // Bit FB5.
	CAN_F25R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R1_FB6      = 0x40       // Bit FB6.
	CAN_F25R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R1_FB7      = 0x80       // Bit FB7.
	CAN_F25R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R1_FB8      = 0x100      // Bit FB8.
	CAN_F25R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R1_FB9      = 0x200      // Bit FB9.
	CAN_F25R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R1_FB10     = 0x400      // Bit FB10.
	CAN_F25R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R1_FB11     = 0x800      // Bit FB11.
	CAN_F25R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R1_FB12     = 0x1000     // Bit FB12.
	CAN_F25R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R1_FB13     = 0x2000     // Bit FB13.
	CAN_F25R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R1_FB14     = 0x4000     // Bit FB14.
	CAN_F25R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R1_FB15     = 0x8000     // Bit FB15.
	CAN_F25R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R1_FB16     = 0x10000    // Bit FB16.
	CAN_F25R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R1_FB17     = 0x20000    // Bit FB17.
	CAN_F25R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R1_FB18     = 0x40000    // Bit FB18.
	CAN_F25R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R1_FB19     = 0x80000    // Bit FB19.
	CAN_F25R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R1_FB20     = 0x100000   // Bit FB20.
	CAN_F25R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R1_FB21     = 0x200000   // Bit FB21.
	CAN_F25R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R1_FB22     = 0x400000   // Bit FB22.
	CAN_F25R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R1_FB23     = 0x800000   // Bit FB23.
	CAN_F25R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R1_FB31     = 0x80000000 // Bit FB31.

	// F25R2: Filter bank 25 register 2
	CAN_F25R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R2_FB0      = 0x1        // Bit FB0.
	CAN_F25R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R2_FB1      = 0x2        // Bit FB1.
	CAN_F25R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R2_FB2      = 0x4        // Bit FB2.
	CAN_F25R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R2_FB3      = 0x8        // Bit FB3.
	CAN_F25R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R2_FB4      = 0x10       // Bit FB4.
	CAN_F25R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R2_FB5      = 0x20       // Bit FB5.
	CAN_F25R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R2_FB6      = 0x40       // Bit FB6.
	CAN_F25R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R2_FB7      = 0x80       // Bit FB7.
	CAN_F25R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R2_FB8      = 0x100      // Bit FB8.
	CAN_F25R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R2_FB9      = 0x200      // Bit FB9.
	CAN_F25R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R2_FB10     = 0x400      // Bit FB10.
	CAN_F25R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R2_FB11     = 0x800      // Bit FB11.
	CAN_F25R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R2_FB12     = 0x1000     // Bit FB12.
	CAN_F25R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R2_FB13     = 0x2000     // Bit FB13.
	CAN_F25R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R2_FB14     = 0x4000     // Bit FB14.
	CAN_F25R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R2_FB15     = 0x8000     // Bit FB15.
	CAN_F25R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R2_FB16     = 0x10000    // Bit FB16.
	CAN_F25R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R2_FB17     = 0x20000    // Bit FB17.
	CAN_F25R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R2_FB18     = 0x40000    // Bit FB18.
	CAN_F25R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R2_FB19     = 0x80000    // Bit FB19.
	CAN_F25R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R2_FB20     = 0x100000   // Bit FB20.
	CAN_F25R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R2_FB21     = 0x200000   // Bit FB21.
	CAN_F25R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R2_FB22     = 0x400000   // Bit FB22.
	CAN_F25R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R2_FB23     = 0x800000   // Bit FB23.
	CAN_F25R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R2_FB31     = 0x80000000 // Bit FB31.

	// F26R1: Filter bank 26 register 1
	CAN_F26R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R1_FB0      = 0x1        // Bit FB0.
	CAN_F26R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R1_FB1      = 0x2        // Bit FB1.
	CAN_F26R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R1_FB2      = 0x4        // Bit FB2.
	CAN_F26R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R1_FB3      = 0x8        // Bit FB3.
	CAN_F26R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R1_FB4      = 0x10       // Bit FB4.
	CAN_F26R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R1_FB5      = 0x20       // Bit FB5.
	CAN_F26R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R1_FB6      = 0x40       // Bit FB6.
	CAN_F26R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R1_FB7      = 0x80       // Bit FB7.
	CAN_F26R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R1_FB8      = 0x100      // Bit FB8.
	CAN_F26R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R1_FB9      = 0x200      // Bit FB9.
	CAN_F26R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R1_FB10     = 0x400      // Bit FB10.
	CAN_F26R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R1_FB11     = 0x800      // Bit FB11.
	CAN_F26R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R1_FB12     = 0x1000     // Bit FB12.
	CAN_F26R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R1_FB13     = 0x2000     // Bit FB13.
	CAN_F26R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R1_FB14     = 0x4000     // Bit FB14.
	CAN_F26R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R1_FB15     = 0x8000     // Bit FB15.
	CAN_F26R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R1_FB16     = 0x10000    // Bit FB16.
	CAN_F26R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R1_FB17     = 0x20000    // Bit FB17.
	CAN_F26R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R1_FB18     = 0x40000    // Bit FB18.
	CAN_F26R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R1_FB19     = 0x80000    // Bit FB19.
	CAN_F26R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R1_FB20     = 0x100000   // Bit FB20.
	CAN_F26R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R1_FB21     = 0x200000   // Bit FB21.
	CAN_F26R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R1_FB22     = 0x400000   // Bit FB22.
	CAN_F26R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R1_FB23     = 0x800000   // Bit FB23.
	CAN_F26R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R1_FB31     = 0x80000000 // Bit FB31.

	// F26R2: Filter bank 26 register 2
	CAN_F26R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R2_FB0      = 0x1        // Bit FB0.
	CAN_F26R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R2_FB1      = 0x2        // Bit FB1.
	CAN_F26R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R2_FB2      = 0x4        // Bit FB2.
	CAN_F26R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R2_FB3      = 0x8        // Bit FB3.
	CAN_F26R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R2_FB4      = 0x10       // Bit FB4.
	CAN_F26R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R2_FB5      = 0x20       // Bit FB5.
	CAN_F26R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R2_FB6      = 0x40       // Bit FB6.
	CAN_F26R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R2_FB7      = 0x80       // Bit FB7.
	CAN_F26R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R2_FB8      = 0x100      // Bit FB8.
	CAN_F26R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R2_FB9      = 0x200      // Bit FB9.
	CAN_F26R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R2_FB10     = 0x400      // Bit FB10.
	CAN_F26R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R2_FB11     = 0x800      // Bit FB11.
	CAN_F26R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R2_FB12     = 0x1000     // Bit FB12.
	CAN_F26R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R2_FB13     = 0x2000     // Bit FB13.
	CAN_F26R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R2_FB14     = 0x4000     // Bit FB14.
	CAN_F26R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R2_FB15     = 0x8000     // Bit FB15.
	CAN_F26R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R2_FB16     = 0x10000    // Bit FB16.
	CAN_F26R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R2_FB17     = 0x20000    // Bit FB17.
	CAN_F26R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R2_FB18     = 0x40000    // Bit FB18.
	CAN_F26R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R2_FB19     = 0x80000    // Bit FB19.
	CAN_F26R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R2_FB20     = 0x100000   // Bit FB20.
	CAN_F26R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R2_FB21     = 0x200000   // Bit FB21.
	CAN_F26R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R2_FB22     = 0x400000   // Bit FB22.
	CAN_F26R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R2_FB23     = 0x800000   // Bit FB23.
	CAN_F26R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R2_FB31     = 0x80000000 // Bit FB31.

	// F27R1: Filter bank 27 register 1
	CAN_F27R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R1_FB0      = 0x1        // Bit FB0.
	CAN_F27R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R1_FB1      = 0x2        // Bit FB1.
	CAN_F27R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R1_FB2      = 0x4        // Bit FB2.
	CAN_F27R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R1_FB3      = 0x8        // Bit FB3.
	CAN_F27R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R1_FB4      = 0x10       // Bit FB4.
	CAN_F27R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R1_FB5      = 0x20       // Bit FB5.
	CAN_F27R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R1_FB6      = 0x40       // Bit FB6.
	CAN_F27R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R1_FB7      = 0x80       // Bit FB7.
	CAN_F27R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R1_FB8      = 0x100      // Bit FB8.
	CAN_F27R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R1_FB9      = 0x200      // Bit FB9.
	CAN_F27R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R1_FB10     = 0x400      // Bit FB10.
	CAN_F27R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R1_FB11     = 0x800      // Bit FB11.
	CAN_F27R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R1_FB12     = 0x1000     // Bit FB12.
	CAN_F27R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R1_FB13     = 0x2000     // Bit FB13.
	CAN_F27R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R1_FB14     = 0x4000     // Bit FB14.
	CAN_F27R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R1_FB15     = 0x8000     // Bit FB15.
	CAN_F27R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R1_FB16     = 0x10000    // Bit FB16.
	CAN_F27R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R1_FB17     = 0x20000    // Bit FB17.
	CAN_F27R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R1_FB18     = 0x40000    // Bit FB18.
	CAN_F27R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R1_FB19     = 0x80000    // Bit FB19.
	CAN_F27R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R1_FB20     = 0x100000   // Bit FB20.
	CAN_F27R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R1_FB21     = 0x200000   // Bit FB21.
	CAN_F27R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R1_FB22     = 0x400000   // Bit FB22.
	CAN_F27R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R1_FB23     = 0x800000   // Bit FB23.
	CAN_F27R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R1_FB31     = 0x80000000 // Bit FB31.

	// F27R2: Filter bank 27 register 2
	CAN_F27R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R2_FB0      = 0x1        // Bit FB0.
	CAN_F27R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R2_FB1      = 0x2        // Bit FB1.
	CAN_F27R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R2_FB2      = 0x4        // Bit FB2.
	CAN_F27R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R2_FB3      = 0x8        // Bit FB3.
	CAN_F27R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R2_FB4      = 0x10       // Bit FB4.
	CAN_F27R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R2_FB5      = 0x20       // Bit FB5.
	CAN_F27R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R2_FB6      = 0x40       // Bit FB6.
	CAN_F27R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R2_FB7      = 0x80       // Bit FB7.
	CAN_F27R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R2_FB8      = 0x100      // Bit FB8.
	CAN_F27R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R2_FB9      = 0x200      // Bit FB9.
	CAN_F27R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R2_FB10     = 0x400      // Bit FB10.
	CAN_F27R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R2_FB11     = 0x800      // Bit FB11.
	CAN_F27R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R2_FB12     = 0x1000     // Bit FB12.
	CAN_F27R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R2_FB13     = 0x2000     // Bit FB13.
	CAN_F27R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R2_FB14     = 0x4000     // Bit FB14.
	CAN_F27R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R2_FB15     = 0x8000     // Bit FB15.
	CAN_F27R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R2_FB16     = 0x10000    // Bit FB16.
	CAN_F27R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R2_FB17     = 0x20000    // Bit FB17.
	CAN_F27R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R2_FB18     = 0x40000    // Bit FB18.
	CAN_F27R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R2_FB19     = 0x80000    // Bit FB19.
	CAN_F27R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R2_FB20     = 0x100000   // Bit FB20.
	CAN_F27R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R2_FB21     = 0x200000   // Bit FB21.
	CAN_F27R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R2_FB22     = 0x400000   // Bit FB22.
	CAN_F27R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R2_FB23     = 0x800000   // Bit FB23.
	CAN_F27R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R2_FB31     = 0x80000000 // Bit FB31.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	NVIC_ISER0_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ISER1: Interrupt Set-Enable Register
	NVIC_ISER1_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ISER2: Interrupt Set-Enable Register
	NVIC_ISER2_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER2_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ICER0: Interrupt Clear-Enable           Register
	NVIC_ICER0_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ICER1: Interrupt Clear-Enable           Register
	NVIC_ICER1_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ICER2: Interrupt Clear-Enable           Register
	NVIC_ICER2_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER2_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ISPR0: Interrupt Set-Pending Register
	NVIC_ISPR0_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ISPR1: Interrupt Set-Pending Register
	NVIC_ISPR1_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ISPR2: Interrupt Set-Pending Register
	NVIC_ISPR2_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR2_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ICPR0: Interrupt Clear-Pending           Register
	NVIC_ICPR0_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// ICPR1: Interrupt Clear-Pending           Register
	NVIC_ICPR1_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// ICPR2: Interrupt Clear-Pending           Register
	NVIC_ICPR2_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// IABR0: Interrupt Active Bit Register
	NVIC_IABR0_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IABR1: Interrupt Active Bit Register
	NVIC_IABR1_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IABR2: Interrupt Active Bit Register
	NVIC_IABR2_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR2_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IPR0: Interrupt Priority Register
	NVIC_IPR0_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR1: Interrupt Priority Register
	NVIC_IPR1_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR2: Interrupt Priority Register
	NVIC_IPR2_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR3: Interrupt Priority Register
	NVIC_IPR3_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR4: Interrupt Priority Register
	NVIC_IPR4_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR5: Interrupt Priority Register
	NVIC_IPR5_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR6: Interrupt Priority Register
	NVIC_IPR6_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR7: Interrupt Priority Register
	NVIC_IPR7_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR8: Interrupt Priority Register
	NVIC_IPR8_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR9: Interrupt Priority Register
	NVIC_IPR9_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR10: Interrupt Priority Register
	NVIC_IPR10_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR11: Interrupt Priority Register
	NVIC_IPR11_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR12: Interrupt Priority Register
	NVIC_IPR12_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR13: Interrupt Priority Register
	NVIC_IPR13_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR14: Interrupt Priority Register
	NVIC_IPR14_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR15: Interrupt Priority Register
	NVIC_IPR15_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR15_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR15_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR15_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR16: Interrupt Priority Register
	NVIC_IPR16_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR16_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR16_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR16_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR17: Interrupt Priority Register
	NVIC_IPR17_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR17_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR17_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR17_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR18: Interrupt Priority Register
	NVIC_IPR18_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR18_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR18_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR18_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR19: Interrupt Priority Register
	NVIC_IPR19_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR19_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR19_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR19_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR20: Interrupt Priority Register
	NVIC_IPR20_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR20_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR20_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR20_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR20_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR20_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR20_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR20_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.
)

// Bitfields for FLASH: FLASH
const (
	// ACR: Flash access control register
	FLASH_ACR_LATENCY_Pos = 0x0    // Position of LATENCY field.
	FLASH_ACR_LATENCY_Msk = 0x7    // Bit mask of LATENCY field.
	FLASH_ACR_PRFTEN_Pos  = 0x8    // Position of PRFTEN field.
	FLASH_ACR_PRFTEN_Msk  = 0x100  // Bit mask of PRFTEN field.
	FLASH_ACR_PRFTEN      = 0x100  // Bit PRFTEN.
	FLASH_ACR_ICEN_Pos    = 0x9    // Position of ICEN field.
	FLASH_ACR_ICEN_Msk    = 0x200  // Bit mask of ICEN field.
	FLASH_ACR_ICEN        = 0x200  // Bit ICEN.
	FLASH_ACR_DCEN_Pos    = 0xa    // Position of DCEN field.
	FLASH_ACR_DCEN_Msk    = 0x400  // Bit mask of DCEN field.
	FLASH_ACR_DCEN        = 0x400  // Bit DCEN.
	FLASH_ACR_ICRST_Pos   = 0xb    // Position of ICRST field.
	FLASH_ACR_ICRST_Msk   = 0x800  // Bit mask of ICRST field.
	FLASH_ACR_ICRST       = 0x800  // Bit ICRST.
	FLASH_ACR_DCRST_Pos   = 0xc    // Position of DCRST field.
	FLASH_ACR_DCRST_Msk   = 0x1000 // Bit mask of DCRST field.
	FLASH_ACR_DCRST       = 0x1000 // Bit DCRST.

	// KEYR: Flash key register
	FLASH_KEYR_KEY_Pos = 0x0        // Position of KEY field.
	FLASH_KEYR_KEY_Msk = 0xffffffff // Bit mask of KEY field.

	// OPTKEYR: Flash option key register
	FLASH_OPTKEYR_OPTKEY_Pos = 0x0        // Position of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Msk = 0xffffffff // Bit mask of OPTKEY field.

	// SR: Status register
	FLASH_SR_EOP_Pos    = 0x0     // Position of EOP field.
	FLASH_SR_EOP_Msk    = 0x1     // Bit mask of EOP field.
	FLASH_SR_EOP        = 0x1     // Bit EOP.
	FLASH_SR_OPERR_Pos  = 0x1     // Position of OPERR field.
	FLASH_SR_OPERR_Msk  = 0x2     // Bit mask of OPERR field.
	FLASH_SR_OPERR      = 0x2     // Bit OPERR.
	FLASH_SR_WRPERR_Pos = 0x4     // Position of WRPERR field.
	FLASH_SR_WRPERR_Msk = 0x10    // Bit mask of WRPERR field.
	FLASH_SR_WRPERR     = 0x10    // Bit WRPERR.
	FLASH_SR_PGAERR_Pos = 0x5     // Position of PGAERR field.
	FLASH_SR_PGAERR_Msk = 0x20    // Bit mask of PGAERR field.
	FLASH_SR_PGAERR     = 0x20    // Bit PGAERR.
	FLASH_SR_PGPERR_Pos = 0x6     // Position of PGPERR field.
	FLASH_SR_PGPERR_Msk = 0x40    // Bit mask of PGPERR field.
	FLASH_SR_PGPERR     = 0x40    // Bit PGPERR.
	FLASH_SR_PGSERR_Pos = 0x7     // Position of PGSERR field.
	FLASH_SR_PGSERR_Msk = 0x80    // Bit mask of PGSERR field.
	FLASH_SR_PGSERR     = 0x80    // Bit PGSERR.
	FLASH_SR_RDERR_Pos  = 0x8     // Position of RDERR field.
	FLASH_SR_RDERR_Msk  = 0x100   // Bit mask of RDERR field.
	FLASH_SR_RDERR      = 0x100   // Bit RDERR.
	FLASH_SR_BSY_Pos    = 0x10    // Position of BSY field.
	FLASH_SR_BSY_Msk    = 0x10000 // Bit mask of BSY field.
	FLASH_SR_BSY        = 0x10000 // Bit BSY.

	// CR: Control register
	FLASH_CR_PG_Pos    = 0x0        // Position of PG field.
	FLASH_CR_PG_Msk    = 0x1        // Bit mask of PG field.
	FLASH_CR_PG        = 0x1        // Bit PG.
	FLASH_CR_SER_Pos   = 0x1        // Position of SER field.
	FLASH_CR_SER_Msk   = 0x2        // Bit mask of SER field.
	FLASH_CR_SER       = 0x2        // Bit SER.
	FLASH_CR_MER_Pos   = 0x2        // Position of MER field.
	FLASH_CR_MER_Msk   = 0x4        // Bit mask of MER field.
	FLASH_CR_MER       = 0x4        // Bit MER.
	FLASH_CR_SNB_Pos   = 0x3        // Position of SNB field.
	FLASH_CR_SNB_Msk   = 0x78       // Bit mask of SNB field.
	FLASH_CR_PSIZE_Pos = 0x8        // Position of PSIZE field.
	FLASH_CR_PSIZE_Msk = 0x300      // Bit mask of PSIZE field.
	FLASH_CR_STRT_Pos  = 0x10       // Position of STRT field.
	FLASH_CR_STRT_Msk  = 0x10000    // Bit mask of STRT field.
	FLASH_CR_STRT      = 0x10000    // Bit STRT.
	FLASH_CR_EOPIE_Pos = 0x18       // Position of EOPIE field.
	FLASH_CR_EOPIE_Msk = 0x1000000  // Bit mask of EOPIE field.
	FLASH_CR_EOPIE     = 0x1000000  // Bit EOPIE.
	FLASH_CR_ERRIE_Pos = 0x19       // Position of ERRIE field.
	FLASH_CR_ERRIE_Msk = 0x2000000  // Bit mask of ERRIE field.
	FLASH_CR_ERRIE     = 0x2000000  // Bit ERRIE.
	FLASH_CR_LOCK_Pos  = 0x1f       // Position of LOCK field.
	FLASH_CR_LOCK_Msk  = 0x80000000 // Bit mask of LOCK field.
	FLASH_CR_LOCK      = 0x80000000 // Bit LOCK.

	// OPTCR: Flash option control register
	FLASH_OPTCR_OPTLOCK_Pos    = 0x0        // Position of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Msk    = 0x1        // Bit mask of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK        = 0x1        // Bit OPTLOCK.
	FLASH_OPTCR_OPTSTRT_Pos    = 0x1        // Position of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Msk    = 0x2        // Bit mask of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT        = 0x2        // Bit OPTSTRT.
	FLASH_OPTCR_BOR_LEV_Pos    = 0x2        // Position of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Msk    = 0xc        // Bit mask of BOR_LEV field.
	FLASH_OPTCR_WDG_SW_Pos     = 0x5        // Position of WDG_SW field.
	FLASH_OPTCR_WDG_SW_Msk     = 0x20       // Bit mask of WDG_SW field.
	FLASH_OPTCR_WDG_SW         = 0x20       // Bit WDG_SW.
	FLASH_OPTCR_NRST_STOP_Pos  = 0x6        // Position of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Msk  = 0x40       // Bit mask of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP      = 0x40       // Bit NRST_STOP.
	FLASH_OPTCR_NRST_STDBY_Pos = 0x7        // Position of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Msk = 0x80       // Bit mask of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY     = 0x80       // Bit NRST_STDBY.
	FLASH_OPTCR_RDP_Pos        = 0x8        // Position of RDP field.
	FLASH_OPTCR_RDP_Msk        = 0xff00     // Bit mask of RDP field.
	FLASH_OPTCR_NWRP_Pos       = 0x10       // Position of NWRP field.
	FLASH_OPTCR_NWRP_Msk       = 0xff0000   // Bit mask of NWRP field.
	FLASH_OPTCR_SPRMOD_Pos     = 0x1f       // Position of SPRMOD field.
	FLASH_OPTCR_SPRMOD_Msk     = 0x80000000 // Bit mask of SPRMOD field.
	FLASH_OPTCR_SPRMOD         = 0x80000000 // Bit SPRMOD.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register           (EXTI_IMR)
	EXTI_IMR_MR0_Pos  = 0x0      // Position of MR0 field.
	EXTI_IMR_MR0_Msk  = 0x1      // Bit mask of MR0 field.
	EXTI_IMR_MR0      = 0x1      // Bit MR0.
	EXTI_IMR_MR1_Pos  = 0x1      // Position of MR1 field.
	EXTI_IMR_MR1_Msk  = 0x2      // Bit mask of MR1 field.
	EXTI_IMR_MR1      = 0x2      // Bit MR1.
	EXTI_IMR_MR2_Pos  = 0x2      // Position of MR2 field.
	EXTI_IMR_MR2_Msk  = 0x4      // Bit mask of MR2 field.
	EXTI_IMR_MR2      = 0x4      // Bit MR2.
	EXTI_IMR_MR3_Pos  = 0x3      // Position of MR3 field.
	EXTI_IMR_MR3_Msk  = 0x8      // Bit mask of MR3 field.
	EXTI_IMR_MR3      = 0x8      // Bit MR3.
	EXTI_IMR_MR4_Pos  = 0x4      // Position of MR4 field.
	EXTI_IMR_MR4_Msk  = 0x10     // Bit mask of MR4 field.
	EXTI_IMR_MR4      = 0x10     // Bit MR4.
	EXTI_IMR_MR5_Pos  = 0x5      // Position of MR5 field.
	EXTI_IMR_MR5_Msk  = 0x20     // Bit mask of MR5 field.
	EXTI_IMR_MR5      = 0x20     // Bit MR5.
	EXTI_IMR_MR6_Pos  = 0x6      // Position of MR6 field.
	EXTI_IMR_MR6_Msk  = 0x40     // Bit mask of MR6 field.
	EXTI_IMR_MR6      = 0x40     // Bit MR6.
	EXTI_IMR_MR7_Pos  = 0x7      // Position of MR7 field.
	EXTI_IMR_MR7_Msk  = 0x80     // Bit mask of MR7 field.
	EXTI_IMR_MR7      = 0x80     // Bit MR7.
	EXTI_IMR_MR8_Pos  = 0x8      // Position of MR8 field.
	EXTI_IMR_MR8_Msk  = 0x100    // Bit mask of MR8 field.
	EXTI_IMR_MR8      = 0x100    // Bit MR8.
	EXTI_IMR_MR9_Pos  = 0x9      // Position of MR9 field.
	EXTI_IMR_MR9_Msk  = 0x200    // Bit mask of MR9 field.
	EXTI_IMR_MR9      = 0x200    // Bit MR9.
	EXTI_IMR_MR10_Pos = 0xa      // Position of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400    // Bit mask of MR10 field.
	EXTI_IMR_MR10     = 0x400    // Bit MR10.
	EXTI_IMR_MR11_Pos = 0xb      // Position of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800    // Bit mask of MR11 field.
	EXTI_IMR_MR11     = 0x800    // Bit MR11.
	EXTI_IMR_MR12_Pos = 0xc      // Position of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000   // Bit mask of MR12 field.
	EXTI_IMR_MR12     = 0x1000   // Bit MR12.
	EXTI_IMR_MR13_Pos = 0xd      // Position of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000   // Bit mask of MR13 field.
	EXTI_IMR_MR13     = 0x2000   // Bit MR13.
	EXTI_IMR_MR14_Pos = 0xe      // Position of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000   // Bit mask of MR14 field.
	EXTI_IMR_MR14     = 0x4000   // Bit MR14.
	EXTI_IMR_MR15_Pos = 0xf      // Position of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000   // Bit mask of MR15 field.
	EXTI_IMR_MR15     = 0x8000   // Bit MR15.
	EXTI_IMR_MR16_Pos = 0x10     // Position of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000  // Bit mask of MR16 field.
	EXTI_IMR_MR16     = 0x10000  // Bit MR16.
	EXTI_IMR_MR17_Pos = 0x11     // Position of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000  // Bit mask of MR17 field.
	EXTI_IMR_MR17     = 0x20000  // Bit MR17.
	EXTI_IMR_MR18_Pos = 0x12     // Position of MR18 field.
	EXTI_IMR_MR18_Msk = 0x40000  // Bit mask of MR18 field.
	EXTI_IMR_MR18     = 0x40000  // Bit MR18.
	EXTI_IMR_MR19_Pos = 0x13     // Position of MR19 field.
	EXTI_IMR_MR19_Msk = 0x80000  // Bit mask of MR19 field.
	EXTI_IMR_MR19     = 0x80000  // Bit MR19.
	EXTI_IMR_MR20_Pos = 0x14     // Position of MR20 field.
	EXTI_IMR_MR20_Msk = 0x100000 // Bit mask of MR20 field.
	EXTI_IMR_MR20     = 0x100000 // Bit MR20.
	EXTI_IMR_MR21_Pos = 0x15     // Position of MR21 field.
	EXTI_IMR_MR21_Msk = 0x200000 // Bit mask of MR21 field.
	EXTI_IMR_MR21     = 0x200000 // Bit MR21.
	EXTI_IMR_MR22_Pos = 0x16     // Position of MR22 field.
	EXTI_IMR_MR22_Msk = 0x400000 // Bit mask of MR22 field.
	EXTI_IMR_MR22     = 0x400000 // Bit MR22.

	// EMR: Event mask register (EXTI_EMR)
	EXTI_EMR_MR0_Pos  = 0x0      // Position of MR0 field.
	EXTI_EMR_MR0_Msk  = 0x1      // Bit mask of MR0 field.
	EXTI_EMR_MR0      = 0x1      // Bit MR0.
	EXTI_EMR_MR1_Pos  = 0x1      // Position of MR1 field.
	EXTI_EMR_MR1_Msk  = 0x2      // Bit mask of MR1 field.
	EXTI_EMR_MR1      = 0x2      // Bit MR1.
	EXTI_EMR_MR2_Pos  = 0x2      // Position of MR2 field.
	EXTI_EMR_MR2_Msk  = 0x4      // Bit mask of MR2 field.
	EXTI_EMR_MR2      = 0x4      // Bit MR2.
	EXTI_EMR_MR3_Pos  = 0x3      // Position of MR3 field.
	EXTI_EMR_MR3_Msk  = 0x8      // Bit mask of MR3 field.
	EXTI_EMR_MR3      = 0x8      // Bit MR3.
	EXTI_EMR_MR4_Pos  = 0x4      // Position of MR4 field.
	EXTI_EMR_MR4_Msk  = 0x10     // Bit mask of MR4 field.
	EXTI_EMR_MR4      = 0x10     // Bit MR4.
	EXTI_EMR_MR5_Pos  = 0x5      // Position of MR5 field.
	EXTI_EMR_MR5_Msk  = 0x20     // Bit mask of MR5 field.
	EXTI_EMR_MR5      = 0x20     // Bit MR5.
	EXTI_EMR_MR6_Pos  = 0x6      // Position of MR6 field.
	EXTI_EMR_MR6_Msk  = 0x40     // Bit mask of MR6 field.
	EXTI_EMR_MR6      = 0x40     // Bit MR6.
	EXTI_EMR_MR7_Pos  = 0x7      // Position of MR7 field.
	EXTI_EMR_MR7_Msk  = 0x80     // Bit mask of MR7 field.
	EXTI_EMR_MR7      = 0x80     // Bit MR7.
	EXTI_EMR_MR8_Pos  = 0x8      // Position of MR8 field.
	EXTI_EMR_MR8_Msk  = 0x100    // Bit mask of MR8 field.
	EXTI_EMR_MR8      = 0x100    // Bit MR8.
	EXTI_EMR_MR9_Pos  = 0x9      // Position of MR9 field.
	EXTI_EMR_MR9_Msk  = 0x200    // Bit mask of MR9 field.
	EXTI_EMR_MR9      = 0x200    // Bit MR9.
	EXTI_EMR_MR10_Pos = 0xa      // Position of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400    // Bit mask of MR10 field.
	EXTI_EMR_MR10     = 0x400    // Bit MR10.
	EXTI_EMR_MR11_Pos = 0xb      // Position of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800    // Bit mask of MR11 field.
	EXTI_EMR_MR11     = 0x800    // Bit MR11.
	EXTI_EMR_MR12_Pos = 0xc      // Position of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000   // Bit mask of MR12 field.
	EXTI_EMR_MR12     = 0x1000   // Bit MR12.
	EXTI_EMR_MR13_Pos = 0xd      // Position of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000   // Bit mask of MR13 field.
	EXTI_EMR_MR13     = 0x2000   // Bit MR13.
	EXTI_EMR_MR14_Pos = 0xe      // Position of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000   // Bit mask of MR14 field.
	EXTI_EMR_MR14     = 0x4000   // Bit MR14.
	EXTI_EMR_MR15_Pos = 0xf      // Position of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000   // Bit mask of MR15 field.
	EXTI_EMR_MR15     = 0x8000   // Bit MR15.
	EXTI_EMR_MR16_Pos = 0x10     // Position of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000  // Bit mask of MR16 field.
	EXTI_EMR_MR16     = 0x10000  // Bit MR16.
	EXTI_EMR_MR17_Pos = 0x11     // Position of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000  // Bit mask of MR17 field.
	EXTI_EMR_MR17     = 0x20000  // Bit MR17.
	EXTI_EMR_MR18_Pos = 0x12     // Position of MR18 field.
	EXTI_EMR_MR18_Msk = 0x40000  // Bit mask of MR18 field.
	EXTI_EMR_MR18     = 0x40000  // Bit MR18.
	EXTI_EMR_MR19_Pos = 0x13     // Position of MR19 field.
	EXTI_EMR_MR19_Msk = 0x80000  // Bit mask of MR19 field.
	EXTI_EMR_MR19     = 0x80000  // Bit MR19.
	EXTI_EMR_MR20_Pos = 0x14     // Position of MR20 field.
	EXTI_EMR_MR20_Msk = 0x100000 // Bit mask of MR20 field.
	EXTI_EMR_MR20     = 0x100000 // Bit MR20.
	EXTI_EMR_MR21_Pos = 0x15     // Position of MR21 field.
	EXTI_EMR_MR21_Msk = 0x200000 // Bit mask of MR21 field.
	EXTI_EMR_MR21     = 0x200000 // Bit MR21.
	EXTI_EMR_MR22_Pos = 0x16     // Position of MR22 field.
	EXTI_EMR_MR22_Msk = 0x400000 // Bit mask of MR22 field.
	EXTI_EMR_MR22     = 0x400000 // Bit MR22.

	// RTSR: Rising Trigger selection register           (EXTI_RTSR)
	EXTI_RTSR_TR0_Pos  = 0x0      // Position of TR0 field.
	EXTI_RTSR_TR0_Msk  = 0x1      // Bit mask of TR0 field.
	EXTI_RTSR_TR0      = 0x1      // Bit TR0.
	EXTI_RTSR_TR1_Pos  = 0x1      // Position of TR1 field.
	EXTI_RTSR_TR1_Msk  = 0x2      // Bit mask of TR1 field.
	EXTI_RTSR_TR1      = 0x2      // Bit TR1.
	EXTI_RTSR_TR2_Pos  = 0x2      // Position of TR2 field.
	EXTI_RTSR_TR2_Msk  = 0x4      // Bit mask of TR2 field.
	EXTI_RTSR_TR2      = 0x4      // Bit TR2.
	EXTI_RTSR_TR3_Pos  = 0x3      // Position of TR3 field.
	EXTI_RTSR_TR3_Msk  = 0x8      // Bit mask of TR3 field.
	EXTI_RTSR_TR3      = 0x8      // Bit TR3.
	EXTI_RTSR_TR4_Pos  = 0x4      // Position of TR4 field.
	EXTI_RTSR_TR4_Msk  = 0x10     // Bit mask of TR4 field.
	EXTI_RTSR_TR4      = 0x10     // Bit TR4.
	EXTI_RTSR_TR5_Pos  = 0x5      // Position of TR5 field.
	EXTI_RTSR_TR5_Msk  = 0x20     // Bit mask of TR5 field.
	EXTI_RTSR_TR5      = 0x20     // Bit TR5.
	EXTI_RTSR_TR6_Pos  = 0x6      // Position of TR6 field.
	EXTI_RTSR_TR6_Msk  = 0x40     // Bit mask of TR6 field.
	EXTI_RTSR_TR6      = 0x40     // Bit TR6.
	EXTI_RTSR_TR7_Pos  = 0x7      // Position of TR7 field.
	EXTI_RTSR_TR7_Msk  = 0x80     // Bit mask of TR7 field.
	EXTI_RTSR_TR7      = 0x80     // Bit TR7.
	EXTI_RTSR_TR8_Pos  = 0x8      // Position of TR8 field.
	EXTI_RTSR_TR8_Msk  = 0x100    // Bit mask of TR8 field.
	EXTI_RTSR_TR8      = 0x100    // Bit TR8.
	EXTI_RTSR_TR9_Pos  = 0x9      // Position of TR9 field.
	EXTI_RTSR_TR9_Msk  = 0x200    // Bit mask of TR9 field.
	EXTI_RTSR_TR9      = 0x200    // Bit TR9.
	EXTI_RTSR_TR10_Pos = 0xa      // Position of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400    // Bit mask of TR10 field.
	EXTI_RTSR_TR10     = 0x400    // Bit TR10.
	EXTI_RTSR_TR11_Pos = 0xb      // Position of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800    // Bit mask of TR11 field.
	EXTI_RTSR_TR11     = 0x800    // Bit TR11.
	EXTI_RTSR_TR12_Pos = 0xc      // Position of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000   // Bit mask of TR12 field.
	EXTI_RTSR_TR12     = 0x1000   // Bit TR12.
	EXTI_RTSR_TR13_Pos = 0xd      // Position of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000   // Bit mask of TR13 field.
	EXTI_RTSR_TR13     = 0x2000   // Bit TR13.
	EXTI_RTSR_TR14_Pos = 0xe      // Position of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000   // Bit mask of TR14 field.
	EXTI_RTSR_TR14     = 0x4000   // Bit TR14.
	EXTI_RTSR_TR15_Pos = 0xf      // Position of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000   // Bit mask of TR15 field.
	EXTI_RTSR_TR15     = 0x8000   // Bit TR15.
	EXTI_RTSR_TR16_Pos = 0x10     // Position of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000  // Bit mask of TR16 field.
	EXTI_RTSR_TR16     = 0x10000  // Bit TR16.
	EXTI_RTSR_TR17_Pos = 0x11     // Position of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000  // Bit mask of TR17 field.
	EXTI_RTSR_TR17     = 0x20000  // Bit TR17.
	EXTI_RTSR_TR18_Pos = 0x12     // Position of TR18 field.
	EXTI_RTSR_TR18_Msk = 0x40000  // Bit mask of TR18 field.
	EXTI_RTSR_TR18     = 0x40000  // Bit TR18.
	EXTI_RTSR_TR19_Pos = 0x13     // Position of TR19 field.
	EXTI_RTSR_TR19_Msk = 0x80000  // Bit mask of TR19 field.
	EXTI_RTSR_TR19     = 0x80000  // Bit TR19.
	EXTI_RTSR_TR20_Pos = 0x14     // Position of TR20 field.
	EXTI_RTSR_TR20_Msk = 0x100000 // Bit mask of TR20 field.
	EXTI_RTSR_TR20     = 0x100000 // Bit TR20.
	EXTI_RTSR_TR21_Pos = 0x15     // Position of TR21 field.
	EXTI_RTSR_TR21_Msk = 0x200000 // Bit mask of TR21 field.
	EXTI_RTSR_TR21     = 0x200000 // Bit TR21.
	EXTI_RTSR_TR22_Pos = 0x16     // Position of TR22 field.
	EXTI_RTSR_TR22_Msk = 0x400000 // Bit mask of TR22 field.
	EXTI_RTSR_TR22     = 0x400000 // Bit TR22.

	// FTSR: Falling Trigger selection register           (EXTI_FTSR)
	EXTI_FTSR_TR0_Pos  = 0x0      // Position of TR0 field.
	EXTI_FTSR_TR0_Msk  = 0x1      // Bit mask of TR0 field.
	EXTI_FTSR_TR0      = 0x1      // Bit TR0.
	EXTI_FTSR_TR1_Pos  = 0x1      // Position of TR1 field.
	EXTI_FTSR_TR1_Msk  = 0x2      // Bit mask of TR1 field.
	EXTI_FTSR_TR1      = 0x2      // Bit TR1.
	EXTI_FTSR_TR2_Pos  = 0x2      // Position of TR2 field.
	EXTI_FTSR_TR2_Msk  = 0x4      // Bit mask of TR2 field.
	EXTI_FTSR_TR2      = 0x4      // Bit TR2.
	EXTI_FTSR_TR3_Pos  = 0x3      // Position of TR3 field.
	EXTI_FTSR_TR3_Msk  = 0x8      // Bit mask of TR3 field.
	EXTI_FTSR_TR3      = 0x8      // Bit TR3.
	EXTI_FTSR_TR4_Pos  = 0x4      // Position of TR4 field.
	EXTI_FTSR_TR4_Msk  = 0x10     // Bit mask of TR4 field.
	EXTI_FTSR_TR4      = 0x10     // Bit TR4.
	EXTI_FTSR_TR5_Pos  = 0x5      // Position of TR5 field.
	EXTI_FTSR_TR5_Msk  = 0x20     // Bit mask of TR5 field.
	EXTI_FTSR_TR5      = 0x20     // Bit TR5.
	EXTI_FTSR_TR6_Pos  = 0x6      // Position of TR6 field.
	EXTI_FTSR_TR6_Msk  = 0x40     // Bit mask of TR6 field.
	EXTI_FTSR_TR6      = 0x40     // Bit TR6.
	EXTI_FTSR_TR7_Pos  = 0x7      // Position of TR7 field.
	EXTI_FTSR_TR7_Msk  = 0x80     // Bit mask of TR7 field.
	EXTI_FTSR_TR7      = 0x80     // Bit TR7.
	EXTI_FTSR_TR8_Pos  = 0x8      // Position of TR8 field.
	EXTI_FTSR_TR8_Msk  = 0x100    // Bit mask of TR8 field.
	EXTI_FTSR_TR8      = 0x100    // Bit TR8.
	EXTI_FTSR_TR9_Pos  = 0x9      // Position of TR9 field.
	EXTI_FTSR_TR9_Msk  = 0x200    // Bit mask of TR9 field.
	EXTI_FTSR_TR9      = 0x200    // Bit TR9.
	EXTI_FTSR_TR10_Pos = 0xa      // Position of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400    // Bit mask of TR10 field.
	EXTI_FTSR_TR10     = 0x400    // Bit TR10.
	EXTI_FTSR_TR11_Pos = 0xb      // Position of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800    // Bit mask of TR11 field.
	EXTI_FTSR_TR11     = 0x800    // Bit TR11.
	EXTI_FTSR_TR12_Pos = 0xc      // Position of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000   // Bit mask of TR12 field.
	EXTI_FTSR_TR12     = 0x1000   // Bit TR12.
	EXTI_FTSR_TR13_Pos = 0xd      // Position of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000   // Bit mask of TR13 field.
	EXTI_FTSR_TR13     = 0x2000   // Bit TR13.
	EXTI_FTSR_TR14_Pos = 0xe      // Position of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000   // Bit mask of TR14 field.
	EXTI_FTSR_TR14     = 0x4000   // Bit TR14.
	EXTI_FTSR_TR15_Pos = 0xf      // Position of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000   // Bit mask of TR15 field.
	EXTI_FTSR_TR15     = 0x8000   // Bit TR15.
	EXTI_FTSR_TR16_Pos = 0x10     // Position of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000  // Bit mask of TR16 field.
	EXTI_FTSR_TR16     = 0x10000  // Bit TR16.
	EXTI_FTSR_TR17_Pos = 0x11     // Position of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000  // Bit mask of TR17 field.
	EXTI_FTSR_TR17     = 0x20000  // Bit TR17.
	EXTI_FTSR_TR18_Pos = 0x12     // Position of TR18 field.
	EXTI_FTSR_TR18_Msk = 0x40000  // Bit mask of TR18 field.
	EXTI_FTSR_TR18     = 0x40000  // Bit TR18.
	EXTI_FTSR_TR19_Pos = 0x13     // Position of TR19 field.
	EXTI_FTSR_TR19_Msk = 0x80000  // Bit mask of TR19 field.
	EXTI_FTSR_TR19     = 0x80000  // Bit TR19.
	EXTI_FTSR_TR20_Pos = 0x14     // Position of TR20 field.
	EXTI_FTSR_TR20_Msk = 0x100000 // Bit mask of TR20 field.
	EXTI_FTSR_TR20     = 0x100000 // Bit TR20.
	EXTI_FTSR_TR21_Pos = 0x15     // Position of TR21 field.
	EXTI_FTSR_TR21_Msk = 0x200000 // Bit mask of TR21 field.
	EXTI_FTSR_TR21     = 0x200000 // Bit TR21.
	EXTI_FTSR_TR22_Pos = 0x16     // Position of TR22 field.
	EXTI_FTSR_TR22_Msk = 0x400000 // Bit mask of TR22 field.
	EXTI_FTSR_TR22     = 0x400000 // Bit TR22.

	// SWIER: Software interrupt event register           (EXTI_SWIER)
	EXTI_SWIER_SWIER0_Pos  = 0x0      // Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk  = 0x1      // Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0      = 0x1      // Bit SWIER0.
	EXTI_SWIER_SWIER1_Pos  = 0x1      // Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk  = 0x2      // Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1      = 0x2      // Bit SWIER1.
	EXTI_SWIER_SWIER2_Pos  = 0x2      // Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk  = 0x4      // Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2      = 0x4      // Bit SWIER2.
	EXTI_SWIER_SWIER3_Pos  = 0x3      // Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk  = 0x8      // Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3      = 0x8      // Bit SWIER3.
	EXTI_SWIER_SWIER4_Pos  = 0x4      // Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk  = 0x10     // Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4      = 0x10     // Bit SWIER4.
	EXTI_SWIER_SWIER5_Pos  = 0x5      // Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk  = 0x20     // Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5      = 0x20     // Bit SWIER5.
	EXTI_SWIER_SWIER6_Pos  = 0x6      // Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk  = 0x40     // Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6      = 0x40     // Bit SWIER6.
	EXTI_SWIER_SWIER7_Pos  = 0x7      // Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk  = 0x80     // Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7      = 0x80     // Bit SWIER7.
	EXTI_SWIER_SWIER8_Pos  = 0x8      // Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk  = 0x100    // Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8      = 0x100    // Bit SWIER8.
	EXTI_SWIER_SWIER9_Pos  = 0x9      // Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk  = 0x200    // Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9      = 0x200    // Bit SWIER9.
	EXTI_SWIER_SWIER10_Pos = 0xa      // Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400    // Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10     = 0x400    // Bit SWIER10.
	EXTI_SWIER_SWIER11_Pos = 0xb      // Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800    // Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11     = 0x800    // Bit SWIER11.
	EXTI_SWIER_SWIER12_Pos = 0xc      // Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000   // Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12     = 0x1000   // Bit SWIER12.
	EXTI_SWIER_SWIER13_Pos = 0xd      // Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000   // Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13     = 0x2000   // Bit SWIER13.
	EXTI_SWIER_SWIER14_Pos = 0xe      // Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000   // Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14     = 0x4000   // Bit SWIER14.
	EXTI_SWIER_SWIER15_Pos = 0xf      // Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000   // Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15     = 0x8000   // Bit SWIER15.
	EXTI_SWIER_SWIER16_Pos = 0x10     // Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000  // Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16     = 0x10000  // Bit SWIER16.
	EXTI_SWIER_SWIER17_Pos = 0x11     // Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000  // Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17     = 0x20000  // Bit SWIER17.
	EXTI_SWIER_SWIER18_Pos = 0x12     // Position of SWIER18 field.
	EXTI_SWIER_SWIER18_Msk = 0x40000  // Bit mask of SWIER18 field.
	EXTI_SWIER_SWIER18     = 0x40000  // Bit SWIER18.
	EXTI_SWIER_SWIER19_Pos = 0x13     // Position of SWIER19 field.
	EXTI_SWIER_SWIER19_Msk = 0x80000  // Bit mask of SWIER19 field.
	EXTI_SWIER_SWIER19     = 0x80000  // Bit SWIER19.
	EXTI_SWIER_SWIER20_Pos = 0x14     // Position of SWIER20 field.
	EXTI_SWIER_SWIER20_Msk = 0x100000 // Bit mask of SWIER20 field.
	EXTI_SWIER_SWIER20     = 0x100000 // Bit SWIER20.
	EXTI_SWIER_SWIER21_Pos = 0x15     // Position of SWIER21 field.
	EXTI_SWIER_SWIER21_Msk = 0x200000 // Bit mask of SWIER21 field.
	EXTI_SWIER_SWIER21     = 0x200000 // Bit SWIER21.
	EXTI_SWIER_SWIER22_Pos = 0x16     // Position of SWIER22 field.
	EXTI_SWIER_SWIER22_Msk = 0x400000 // Bit mask of SWIER22 field.
	EXTI_SWIER_SWIER22     = 0x400000 // Bit SWIER22.

	// PR: Pending register (EXTI_PR)
	EXTI_PR_PR0_Pos  = 0x0      // Position of PR0 field.
	EXTI_PR_PR0_Msk  = 0x1      // Bit mask of PR0 field.
	EXTI_PR_PR0      = 0x1      // Bit PR0.
	EXTI_PR_PR1_Pos  = 0x1      // Position of PR1 field.
	EXTI_PR_PR1_Msk  = 0x2      // Bit mask of PR1 field.
	EXTI_PR_PR1      = 0x2      // Bit PR1.
	EXTI_PR_PR2_Pos  = 0x2      // Position of PR2 field.
	EXTI_PR_PR2_Msk  = 0x4      // Bit mask of PR2 field.
	EXTI_PR_PR2      = 0x4      // Bit PR2.
	EXTI_PR_PR3_Pos  = 0x3      // Position of PR3 field.
	EXTI_PR_PR3_Msk  = 0x8      // Bit mask of PR3 field.
	EXTI_PR_PR3      = 0x8      // Bit PR3.
	EXTI_PR_PR4_Pos  = 0x4      // Position of PR4 field.
	EXTI_PR_PR4_Msk  = 0x10     // Bit mask of PR4 field.
	EXTI_PR_PR4      = 0x10     // Bit PR4.
	EXTI_PR_PR5_Pos  = 0x5      // Position of PR5 field.
	EXTI_PR_PR5_Msk  = 0x20     // Bit mask of PR5 field.
	EXTI_PR_PR5      = 0x20     // Bit PR5.
	EXTI_PR_PR6_Pos  = 0x6      // Position of PR6 field.
	EXTI_PR_PR6_Msk  = 0x40     // Bit mask of PR6 field.
	EXTI_PR_PR6      = 0x40     // Bit PR6.
	EXTI_PR_PR7_Pos  = 0x7      // Position of PR7 field.
	EXTI_PR_PR7_Msk  = 0x80     // Bit mask of PR7 field.
	EXTI_PR_PR7      = 0x80     // Bit PR7.
	EXTI_PR_PR8_Pos  = 0x8      // Position of PR8 field.
	EXTI_PR_PR8_Msk  = 0x100    // Bit mask of PR8 field.
	EXTI_PR_PR8      = 0x100    // Bit PR8.
	EXTI_PR_PR9_Pos  = 0x9      // Position of PR9 field.
	EXTI_PR_PR9_Msk  = 0x200    // Bit mask of PR9 field.
	EXTI_PR_PR9      = 0x200    // Bit PR9.
	EXTI_PR_PR10_Pos = 0xa      // Position of PR10 field.
	EXTI_PR_PR10_Msk = 0x400    // Bit mask of PR10 field.
	EXTI_PR_PR10     = 0x400    // Bit PR10.
	EXTI_PR_PR11_Pos = 0xb      // Position of PR11 field.
	EXTI_PR_PR11_Msk = 0x800    // Bit mask of PR11 field.
	EXTI_PR_PR11     = 0x800    // Bit PR11.
	EXTI_PR_PR12_Pos = 0xc      // Position of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000   // Bit mask of PR12 field.
	EXTI_PR_PR12     = 0x1000   // Bit PR12.
	EXTI_PR_PR13_Pos = 0xd      // Position of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000   // Bit mask of PR13 field.
	EXTI_PR_PR13     = 0x2000   // Bit PR13.
	EXTI_PR_PR14_Pos = 0xe      // Position of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000   // Bit mask of PR14 field.
	EXTI_PR_PR14     = 0x4000   // Bit PR14.
	EXTI_PR_PR15_Pos = 0xf      // Position of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000   // Bit mask of PR15 field.
	EXTI_PR_PR15     = 0x8000   // Bit PR15.
	EXTI_PR_PR16_Pos = 0x10     // Position of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000  // Bit mask of PR16 field.
	EXTI_PR_PR16     = 0x10000  // Bit PR16.
	EXTI_PR_PR17_Pos = 0x11     // Position of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000  // Bit mask of PR17 field.
	EXTI_PR_PR17     = 0x20000  // Bit PR17.
	EXTI_PR_PR18_Pos = 0x12     // Position of PR18 field.
	EXTI_PR_PR18_Msk = 0x40000  // Bit mask of PR18 field.
	EXTI_PR_PR18     = 0x40000  // Bit PR18.
	EXTI_PR_PR19_Pos = 0x13     // Position of PR19 field.
	EXTI_PR_PR19_Msk = 0x80000  // Bit mask of PR19 field.
	EXTI_PR_PR19     = 0x80000  // Bit PR19.
	EXTI_PR_PR20_Pos = 0x14     // Position of PR20 field.
	EXTI_PR_PR20_Msk = 0x100000 // Bit mask of PR20 field.
	EXTI_PR_PR20     = 0x100000 // Bit PR20.
	EXTI_PR_PR21_Pos = 0x15     // Position of PR21 field.
	EXTI_PR_PR21_Msk = 0x200000 // Bit mask of PR21 field.
	EXTI_PR_PR21     = 0x200000 // Bit PR21.
	EXTI_PR_PR22_Pos = 0x16     // Position of PR22 field.
	EXTI_PR_PR22_Msk = 0x400000 // Bit mask of PR22 field.
	EXTI_PR_PR22     = 0x400000 // Bit PR22.
)

// Bitfields for OTG_HS_GLOBAL: USB on the go high speed
const (
	// OTG_HS_GOTGCTL: OTG_HS control and status           register
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQSCS_Pos  = 0x0     // Position of SRQSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQSCS_Msk  = 0x1     // Bit mask of SRQSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQSCS      = 0x1     // Bit SRQSCS.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQ_Pos     = 0x1     // Position of SRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQ_Msk     = 0x2     // Bit mask of SRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQ         = 0x2     // Bit SRQ.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNGSCS_Pos  = 0x8     // Position of HNGSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNGSCS_Msk  = 0x100   // Bit mask of HNGSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNGSCS      = 0x100   // Bit HNGSCS.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNPRQ_Pos   = 0x9     // Position of HNPRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNPRQ_Msk   = 0x200   // Bit mask of HNPRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNPRQ       = 0x200   // Bit HNPRQ.
	USB_OTG_HS_OTG_HS_GOTGCTL_HSHNPEN_Pos = 0xa     // Position of HSHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HSHNPEN_Msk = 0x400   // Bit mask of HSHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HSHNPEN     = 0x400   // Bit HSHNPEN.
	USB_OTG_HS_OTG_HS_GOTGCTL_DHNPEN_Pos  = 0xb     // Position of DHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DHNPEN_Msk  = 0x800   // Bit mask of DHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DHNPEN      = 0x800   // Bit DHNPEN.
	USB_OTG_HS_OTG_HS_GOTGCTL_CIDSTS_Pos  = 0x10    // Position of CIDSTS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_CIDSTS_Msk  = 0x10000 // Bit mask of CIDSTS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_CIDSTS      = 0x10000 // Bit CIDSTS.
	USB_OTG_HS_OTG_HS_GOTGCTL_DBCT_Pos    = 0x11    // Position of DBCT field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DBCT_Msk    = 0x20000 // Bit mask of DBCT field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DBCT        = 0x20000 // Bit DBCT.
	USB_OTG_HS_OTG_HS_GOTGCTL_ASVLD_Pos   = 0x12    // Position of ASVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_ASVLD_Msk   = 0x40000 // Bit mask of ASVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_ASVLD       = 0x40000 // Bit ASVLD.
	USB_OTG_HS_OTG_HS_GOTGCTL_BSVLD_Pos   = 0x13    // Position of BSVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_BSVLD_Msk   = 0x80000 // Bit mask of BSVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_BSVLD       = 0x80000 // Bit BSVLD.

	// OTG_HS_GOTGINT: OTG_HS interrupt register
	USB_OTG_HS_OTG_HS_GOTGINT_SEDET_Pos   = 0x2     // Position of SEDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_SEDET_Msk   = 0x4     // Bit mask of SEDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_SEDET       = 0x4     // Bit SEDET.
	USB_OTG_HS_OTG_HS_GOTGINT_SRSSCHG_Pos = 0x8     // Position of SRSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_SRSSCHG_Msk = 0x100   // Bit mask of SRSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_SRSSCHG     = 0x100   // Bit SRSSCHG.
	USB_OTG_HS_OTG_HS_GOTGINT_HNSSCHG_Pos = 0x9     // Position of HNSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNSSCHG_Msk = 0x200   // Bit mask of HNSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNSSCHG     = 0x200   // Bit HNSSCHG.
	USB_OTG_HS_OTG_HS_GOTGINT_HNGDET_Pos  = 0x11    // Position of HNGDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNGDET_Msk  = 0x20000 // Bit mask of HNGDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNGDET      = 0x20000 // Bit HNGDET.
	USB_OTG_HS_OTG_HS_GOTGINT_ADTOCHG_Pos = 0x12    // Position of ADTOCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_ADTOCHG_Msk = 0x40000 // Bit mask of ADTOCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_ADTOCHG     = 0x40000 // Bit ADTOCHG.
	USB_OTG_HS_OTG_HS_GOTGINT_DBCDNE_Pos  = 0x13    // Position of DBCDNE field.
	USB_OTG_HS_OTG_HS_GOTGINT_DBCDNE_Msk  = 0x80000 // Bit mask of DBCDNE field.
	USB_OTG_HS_OTG_HS_GOTGINT_DBCDNE      = 0x80000 // Bit DBCDNE.

	// OTG_HS_GAHBCFG: OTG_HS AHB configuration           register
	USB_OTG_HS_OTG_HS_GAHBCFG_GINT_Pos     = 0x0   // Position of GINT field.
	USB_OTG_HS_OTG_HS_GAHBCFG_GINT_Msk     = 0x1   // Bit mask of GINT field.
	USB_OTG_HS_OTG_HS_GAHBCFG_GINT         = 0x1   // Bit GINT.
	USB_OTG_HS_OTG_HS_GAHBCFG_HBSTLEN_Pos  = 0x1   // Position of HBSTLEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_HBSTLEN_Msk  = 0x1e  // Bit mask of HBSTLEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_DMAEN_Pos    = 0x5   // Position of DMAEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_DMAEN_Msk    = 0x20  // Bit mask of DMAEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_DMAEN        = 0x20  // Bit DMAEN.
	USB_OTG_HS_OTG_HS_GAHBCFG_TXFELVL_Pos  = 0x7   // Position of TXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_TXFELVL_Msk  = 0x80  // Bit mask of TXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_TXFELVL      = 0x80  // Bit TXFELVL.
	USB_OTG_HS_OTG_HS_GAHBCFG_PTXFELVL_Pos = 0x8   // Position of PTXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_PTXFELVL_Msk = 0x100 // Bit mask of PTXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_PTXFELVL     = 0x100 // Bit PTXFELVL.

	// OTG_HS_GUSBCFG: OTG_HS USB configuration           register
	USB_OTG_HS_OTG_HS_GUSBCFG_TOCAL_Pos      = 0x0        // Position of TOCAL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TOCAL_Msk      = 0x7        // Bit mask of TOCAL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYSEL_Pos     = 0x6        // Position of PHYSEL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYSEL_Msk     = 0x40       // Bit mask of PHYSEL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYSEL         = 0x40       // Bit PHYSEL.
	USB_OTG_HS_OTG_HS_GUSBCFG_SRPCAP_Pos     = 0x8        // Position of SRPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_SRPCAP_Msk     = 0x100      // Bit mask of SRPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_SRPCAP         = 0x100      // Bit SRPCAP.
	USB_OTG_HS_OTG_HS_GUSBCFG_HNPCAP_Pos     = 0x9        // Position of HNPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_HNPCAP_Msk     = 0x200      // Bit mask of HNPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_HNPCAP         = 0x200      // Bit HNPCAP.
	USB_OTG_HS_OTG_HS_GUSBCFG_TRDT_Pos       = 0xa        // Position of TRDT field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TRDT_Msk       = 0x3c00     // Bit mask of TRDT field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYLPCS_Pos    = 0xf        // Position of PHYLPCS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYLPCS_Msk    = 0x8000     // Bit mask of PHYLPCS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYLPCS        = 0x8000     // Bit PHYLPCS.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIFSLS_Pos   = 0x11       // Position of ULPIFSLS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIFSLS_Msk   = 0x20000    // Bit mask of ULPIFSLS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIFSLS       = 0x20000    // Bit ULPIFSLS.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIAR_Pos     = 0x12       // Position of ULPIAR field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIAR_Msk     = 0x40000    // Bit mask of ULPIAR field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIAR         = 0x40000    // Bit ULPIAR.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPICSM_Pos    = 0x13       // Position of ULPICSM field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPICSM_Msk    = 0x80000    // Bit mask of ULPICSM field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPICSM        = 0x80000    // Bit ULPICSM.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSD_Pos = 0x14       // Position of ULPIEVBUSD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSD_Msk = 0x100000   // Bit mask of ULPIEVBUSD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSD     = 0x100000   // Bit ULPIEVBUSD.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSI_Pos = 0x15       // Position of ULPIEVBUSI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSI_Msk = 0x200000   // Bit mask of ULPIEVBUSI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSI     = 0x200000   // Bit ULPIEVBUSI.
	USB_OTG_HS_OTG_HS_GUSBCFG_TSDPS_Pos      = 0x16       // Position of TSDPS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TSDPS_Msk      = 0x400000   // Bit mask of TSDPS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TSDPS          = 0x400000   // Bit TSDPS.
	USB_OTG_HS_OTG_HS_GUSBCFG_PCCI_Pos       = 0x17       // Position of PCCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PCCI_Msk       = 0x800000   // Bit mask of PCCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PCCI           = 0x800000   // Bit PCCI.
	USB_OTG_HS_OTG_HS_GUSBCFG_PTCI_Pos       = 0x18       // Position of PTCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PTCI_Msk       = 0x1000000  // Bit mask of PTCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PTCI           = 0x1000000  // Bit PTCI.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIIPD_Pos    = 0x19       // Position of ULPIIPD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIIPD_Msk    = 0x2000000  // Bit mask of ULPIIPD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIIPD        = 0x2000000  // Bit ULPIIPD.
	USB_OTG_HS_OTG_HS_GUSBCFG_FHMOD_Pos      = 0x1d       // Position of FHMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FHMOD_Msk      = 0x20000000 // Bit mask of FHMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FHMOD          = 0x20000000 // Bit FHMOD.
	USB_OTG_HS_OTG_HS_GUSBCFG_FDMOD_Pos      = 0x1e       // Position of FDMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FDMOD_Msk      = 0x40000000 // Bit mask of FDMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FDMOD          = 0x40000000 // Bit FDMOD.
	USB_OTG_HS_OTG_HS_GUSBCFG_CTXPKT_Pos     = 0x1f       // Position of CTXPKT field.
	USB_OTG_HS_OTG_HS_GUSBCFG_CTXPKT_Msk     = 0x80000000 // Bit mask of CTXPKT field.
	USB_OTG_HS_OTG_HS_GUSBCFG_CTXPKT         = 0x80000000 // Bit CTXPKT.

	// OTG_HS_GRSTCTL: OTG_HS reset register
	USB_OTG_HS_OTG_HS_GRSTCTL_CSRST_Pos   = 0x0        // Position of CSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_CSRST_Msk   = 0x1        // Bit mask of CSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_CSRST       = 0x1        // Bit CSRST.
	USB_OTG_HS_OTG_HS_GRSTCTL_HSRST_Pos   = 0x1        // Position of HSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_HSRST_Msk   = 0x2        // Bit mask of HSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_HSRST       = 0x2        // Bit HSRST.
	USB_OTG_HS_OTG_HS_GRSTCTL_FCRST_Pos   = 0x2        // Position of FCRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_FCRST_Msk   = 0x4        // Bit mask of FCRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_FCRST       = 0x4        // Bit FCRST.
	USB_OTG_HS_OTG_HS_GRSTCTL_RXFFLSH_Pos = 0x4        // Position of RXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_RXFFLSH_Msk = 0x10       // Bit mask of RXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_RXFFLSH     = 0x10       // Bit RXFFLSH.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFFLSH_Pos = 0x5        // Position of TXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFFLSH_Msk = 0x20       // Bit mask of TXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFFLSH     = 0x20       // Bit TXFFLSH.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFNUM_Pos  = 0x6        // Position of TXFNUM field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFNUM_Msk  = 0x7c0      // Bit mask of TXFNUM field.
	USB_OTG_HS_OTG_HS_GRSTCTL_DMAREQ_Pos  = 0x1e       // Position of DMAREQ field.
	USB_OTG_HS_OTG_HS_GRSTCTL_DMAREQ_Msk  = 0x40000000 // Bit mask of DMAREQ field.
	USB_OTG_HS_OTG_HS_GRSTCTL_DMAREQ      = 0x40000000 // Bit DMAREQ.
	USB_OTG_HS_OTG_HS_GRSTCTL_AHBIDL_Pos  = 0x1f       // Position of AHBIDL field.
	USB_OTG_HS_OTG_HS_GRSTCTL_AHBIDL_Msk  = 0x80000000 // Bit mask of AHBIDL field.
	USB_OTG_HS_OTG_HS_GRSTCTL_AHBIDL      = 0x80000000 // Bit AHBIDL.

	// OTG_HS_GINTSTS: OTG_HS core interrupt register
	USB_OTG_HS_OTG_HS_GINTSTS_CMOD_Pos              = 0x0        // Position of CMOD field.
	USB_OTG_HS_OTG_HS_GINTSTS_CMOD_Msk              = 0x1        // Bit mask of CMOD field.
	USB_OTG_HS_OTG_HS_GINTSTS_CMOD                  = 0x1        // Bit CMOD.
	USB_OTG_HS_OTG_HS_GINTSTS_MMIS_Pos              = 0x1        // Position of MMIS field.
	USB_OTG_HS_OTG_HS_GINTSTS_MMIS_Msk              = 0x2        // Bit mask of MMIS field.
	USB_OTG_HS_OTG_HS_GINTSTS_MMIS                  = 0x2        // Bit MMIS.
	USB_OTG_HS_OTG_HS_GINTSTS_OTGINT_Pos            = 0x2        // Position of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OTGINT_Msk            = 0x4        // Bit mask of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OTGINT                = 0x4        // Bit OTGINT.
	USB_OTG_HS_OTG_HS_GINTSTS_SOF_Pos               = 0x3        // Position of SOF field.
	USB_OTG_HS_OTG_HS_GINTSTS_SOF_Msk               = 0x8        // Bit mask of SOF field.
	USB_OTG_HS_OTG_HS_GINTSTS_SOF                   = 0x8        // Bit SOF.
	USB_OTG_HS_OTG_HS_GINTSTS_RXFLVL_Pos            = 0x4        // Position of RXFLVL field.
	USB_OTG_HS_OTG_HS_GINTSTS_RXFLVL_Msk            = 0x10       // Bit mask of RXFLVL field.
	USB_OTG_HS_OTG_HS_GINTSTS_RXFLVL                = 0x10       // Bit RXFLVL.
	USB_OTG_HS_OTG_HS_GINTSTS_NPTXFE_Pos            = 0x5        // Position of NPTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_NPTXFE_Msk            = 0x20       // Bit mask of NPTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_NPTXFE                = 0x20       // Bit NPTXFE.
	USB_OTG_HS_OTG_HS_GINTSTS_GINAKEFF_Pos          = 0x6        // Position of GINAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_GINAKEFF_Msk          = 0x40       // Bit mask of GINAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_GINAKEFF              = 0x40       // Bit GINAKEFF.
	USB_OTG_HS_OTG_HS_GINTSTS_BOUTNAKEFF_Pos        = 0x7        // Position of BOUTNAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_BOUTNAKEFF_Msk        = 0x80       // Bit mask of BOUTNAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_BOUTNAKEFF            = 0x80       // Bit BOUTNAKEFF.
	USB_OTG_HS_OTG_HS_GINTSTS_ESUSP_Pos             = 0xa        // Position of ESUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ESUSP_Msk             = 0x400      // Bit mask of ESUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ESUSP                 = 0x400      // Bit ESUSP.
	USB_OTG_HS_OTG_HS_GINTSTS_USBSUSP_Pos           = 0xb        // Position of USBSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBSUSP_Msk           = 0x800      // Bit mask of USBSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBSUSP               = 0x800      // Bit USBSUSP.
	USB_OTG_HS_OTG_HS_GINTSTS_USBRST_Pos            = 0xc        // Position of USBRST field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBRST_Msk            = 0x1000     // Bit mask of USBRST field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBRST                = 0x1000     // Bit USBRST.
	USB_OTG_HS_OTG_HS_GINTSTS_ENUMDNE_Pos           = 0xd        // Position of ENUMDNE field.
	USB_OTG_HS_OTG_HS_GINTSTS_ENUMDNE_Msk           = 0x2000     // Bit mask of ENUMDNE field.
	USB_OTG_HS_OTG_HS_GINTSTS_ENUMDNE               = 0x2000     // Bit ENUMDNE.
	USB_OTG_HS_OTG_HS_GINTSTS_ISOODRP_Pos           = 0xe        // Position of ISOODRP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ISOODRP_Msk           = 0x4000     // Bit mask of ISOODRP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ISOODRP               = 0x4000     // Bit ISOODRP.
	USB_OTG_HS_OTG_HS_GINTSTS_EOPF_Pos              = 0xf        // Position of EOPF field.
	USB_OTG_HS_OTG_HS_GINTSTS_EOPF_Msk              = 0x8000     // Bit mask of EOPF field.
	USB_OTG_HS_OTG_HS_GINTSTS_EOPF                  = 0x8000     // Bit EOPF.
	USB_OTG_HS_OTG_HS_GINTSTS_IEPINT_Pos            = 0x12       // Position of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_IEPINT_Msk            = 0x40000    // Bit mask of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_IEPINT                = 0x40000    // Bit IEPINT.
	USB_OTG_HS_OTG_HS_GINTSTS_OEPINT_Pos            = 0x13       // Position of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OEPINT_Msk            = 0x80000    // Bit mask of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OEPINT                = 0x80000    // Bit OEPINT.
	USB_OTG_HS_OTG_HS_GINTSTS_IISOIXFR_Pos          = 0x14       // Position of IISOIXFR field.
	USB_OTG_HS_OTG_HS_GINTSTS_IISOIXFR_Msk          = 0x100000   // Bit mask of IISOIXFR field.
	USB_OTG_HS_OTG_HS_GINTSTS_IISOIXFR              = 0x100000   // Bit IISOIXFR.
	USB_OTG_HS_OTG_HS_GINTSTS_PXFR_INCOMPISOOUT_Pos = 0x15       // Position of PXFR_INCOMPISOOUT field.
	USB_OTG_HS_OTG_HS_GINTSTS_PXFR_INCOMPISOOUT_Msk = 0x200000   // Bit mask of PXFR_INCOMPISOOUT field.
	USB_OTG_HS_OTG_HS_GINTSTS_PXFR_INCOMPISOOUT     = 0x200000   // Bit PXFR_INCOMPISOOUT.
	USB_OTG_HS_OTG_HS_GINTSTS_DATAFSUSP_Pos         = 0x16       // Position of DATAFSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_DATAFSUSP_Msk         = 0x400000   // Bit mask of DATAFSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_DATAFSUSP             = 0x400000   // Bit DATAFSUSP.
	USB_OTG_HS_OTG_HS_GINTSTS_HPRTINT_Pos           = 0x18       // Position of HPRTINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_HPRTINT_Msk           = 0x1000000  // Bit mask of HPRTINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_HPRTINT               = 0x1000000  // Bit HPRTINT.
	USB_OTG_HS_OTG_HS_GINTSTS_HCINT_Pos             = 0x19       // Position of HCINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_HCINT_Msk             = 0x2000000  // Bit mask of HCINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_HCINT                 = 0x2000000  // Bit HCINT.
	USB_OTG_HS_OTG_HS_GINTSTS_PTXFE_Pos             = 0x1a       // Position of PTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_PTXFE_Msk             = 0x4000000  // Bit mask of PTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_PTXFE                 = 0x4000000  // Bit PTXFE.
	USB_OTG_HS_OTG_HS_GINTSTS_CIDSCHG_Pos           = 0x1c       // Position of CIDSCHG field.
	USB_OTG_HS_OTG_HS_GINTSTS_CIDSCHG_Msk           = 0x10000000 // Bit mask of CIDSCHG field.
	USB_OTG_HS_OTG_HS_GINTSTS_CIDSCHG               = 0x10000000 // Bit CIDSCHG.
	USB_OTG_HS_OTG_HS_GINTSTS_DISCINT_Pos           = 0x1d       // Position of DISCINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_DISCINT_Msk           = 0x20000000 // Bit mask of DISCINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_DISCINT               = 0x20000000 // Bit DISCINT.
	USB_OTG_HS_OTG_HS_GINTSTS_SRQINT_Pos            = 0x1e       // Position of SRQINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_SRQINT_Msk            = 0x40000000 // Bit mask of SRQINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_SRQINT                = 0x40000000 // Bit SRQINT.
	USB_OTG_HS_OTG_HS_GINTSTS_WKUINT_Pos            = 0x1f       // Position of WKUINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_WKUINT_Msk            = 0x80000000 // Bit mask of WKUINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_WKUINT                = 0x80000000 // Bit WKUINT.

	// OTG_HS_GINTMSK: OTG_HS interrupt mask register
	USB_OTG_HS_OTG_HS_GINTMSK_MMISM_Pos           = 0x1        // Position of MMISM field.
	USB_OTG_HS_OTG_HS_GINTMSK_MMISM_Msk           = 0x2        // Bit mask of MMISM field.
	USB_OTG_HS_OTG_HS_GINTMSK_MMISM               = 0x2        // Bit MMISM.
	USB_OTG_HS_OTG_HS_GINTMSK_OTGINT_Pos          = 0x2        // Position of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_OTGINT_Msk          = 0x4        // Bit mask of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_OTGINT              = 0x4        // Bit OTGINT.
	USB_OTG_HS_OTG_HS_GINTMSK_SOFM_Pos            = 0x3        // Position of SOFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_SOFM_Msk            = 0x8        // Bit mask of SOFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_SOFM                = 0x8        // Bit SOFM.
	USB_OTG_HS_OTG_HS_GINTMSK_RXFLVLM_Pos         = 0x4        // Position of RXFLVLM field.
	USB_OTG_HS_OTG_HS_GINTMSK_RXFLVLM_Msk         = 0x10       // Bit mask of RXFLVLM field.
	USB_OTG_HS_OTG_HS_GINTMSK_RXFLVLM             = 0x10       // Bit RXFLVLM.
	USB_OTG_HS_OTG_HS_GINTMSK_NPTXFEM_Pos         = 0x5        // Position of NPTXFEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_NPTXFEM_Msk         = 0x20       // Bit mask of NPTXFEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_NPTXFEM             = 0x20       // Bit NPTXFEM.
	USB_OTG_HS_OTG_HS_GINTMSK_GINAKEFFM_Pos       = 0x6        // Position of GINAKEFFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_GINAKEFFM_Msk       = 0x40       // Bit mask of GINAKEFFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_GINAKEFFM           = 0x40       // Bit GINAKEFFM.
	USB_OTG_HS_OTG_HS_GINTMSK_GONAKEFFM_Pos       = 0x7        // Position of GONAKEFFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_GONAKEFFM_Msk       = 0x80       // Bit mask of GONAKEFFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_GONAKEFFM           = 0x80       // Bit GONAKEFFM.
	USB_OTG_HS_OTG_HS_GINTMSK_ESUSPM_Pos          = 0xa        // Position of ESUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ESUSPM_Msk          = 0x400      // Bit mask of ESUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ESUSPM              = 0x400      // Bit ESUSPM.
	USB_OTG_HS_OTG_HS_GINTMSK_USBSUSPM_Pos        = 0xb        // Position of USBSUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_USBSUSPM_Msk        = 0x800      // Bit mask of USBSUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_USBSUSPM            = 0x800      // Bit USBSUSPM.
	USB_OTG_HS_OTG_HS_GINTMSK_USBRST_Pos          = 0xc        // Position of USBRST field.
	USB_OTG_HS_OTG_HS_GINTMSK_USBRST_Msk          = 0x1000     // Bit mask of USBRST field.
	USB_OTG_HS_OTG_HS_GINTMSK_USBRST              = 0x1000     // Bit USBRST.
	USB_OTG_HS_OTG_HS_GINTMSK_ENUMDNEM_Pos        = 0xd        // Position of ENUMDNEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ENUMDNEM_Msk        = 0x2000     // Bit mask of ENUMDNEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ENUMDNEM            = 0x2000     // Bit ENUMDNEM.
	USB_OTG_HS_OTG_HS_GINTMSK_ISOODRPM_Pos        = 0xe        // Position of ISOODRPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ISOODRPM_Msk        = 0x4000     // Bit mask of ISOODRPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ISOODRPM            = 0x4000     // Bit ISOODRPM.
	USB_OTG_HS_OTG_HS_GINTMSK_EOPFM_Pos           = 0xf        // Position of EOPFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_EOPFM_Msk           = 0x8000     // Bit mask of EOPFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_EOPFM               = 0x8000     // Bit EOPFM.
	USB_OTG_HS_OTG_HS_GINTMSK_EPMISM_Pos          = 0x11       // Position of EPMISM field.
	USB_OTG_HS_OTG_HS_GINTMSK_EPMISM_Msk          = 0x20000    // Bit mask of EPMISM field.
	USB_OTG_HS_OTG_HS_GINTMSK_EPMISM              = 0x20000    // Bit EPMISM.
	USB_OTG_HS_OTG_HS_GINTMSK_IEPINT_Pos          = 0x12       // Position of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_IEPINT_Msk          = 0x40000    // Bit mask of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_IEPINT              = 0x40000    // Bit IEPINT.
	USB_OTG_HS_OTG_HS_GINTMSK_OEPINT_Pos          = 0x13       // Position of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_OEPINT_Msk          = 0x80000    // Bit mask of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_OEPINT              = 0x80000    // Bit OEPINT.
	USB_OTG_HS_OTG_HS_GINTMSK_IISOIXFRM_Pos       = 0x14       // Position of IISOIXFRM field.
	USB_OTG_HS_OTG_HS_GINTMSK_IISOIXFRM_Msk       = 0x100000   // Bit mask of IISOIXFRM field.
	USB_OTG_HS_OTG_HS_GINTMSK_IISOIXFRM           = 0x100000   // Bit IISOIXFRM.
	USB_OTG_HS_OTG_HS_GINTMSK_PXFRM_IISOOXFRM_Pos = 0x15       // Position of PXFRM_IISOOXFRM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PXFRM_IISOOXFRM_Msk = 0x200000   // Bit mask of PXFRM_IISOOXFRM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PXFRM_IISOOXFRM     = 0x200000   // Bit PXFRM_IISOOXFRM.
	USB_OTG_HS_OTG_HS_GINTMSK_FSUSPM_Pos          = 0x16       // Position of FSUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_FSUSPM_Msk          = 0x400000   // Bit mask of FSUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_FSUSPM              = 0x400000   // Bit FSUSPM.
	USB_OTG_HS_OTG_HS_GINTMSK_PRTIM_Pos           = 0x18       // Position of PRTIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PRTIM_Msk           = 0x1000000  // Bit mask of PRTIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PRTIM               = 0x1000000  // Bit PRTIM.
	USB_OTG_HS_OTG_HS_GINTMSK_HCIM_Pos            = 0x19       // Position of HCIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_HCIM_Msk            = 0x2000000  // Bit mask of HCIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_HCIM                = 0x2000000  // Bit HCIM.
	USB_OTG_HS_OTG_HS_GINTMSK_PTXFEM_Pos          = 0x1a       // Position of PTXFEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PTXFEM_Msk          = 0x4000000  // Bit mask of PTXFEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PTXFEM              = 0x4000000  // Bit PTXFEM.
	USB_OTG_HS_OTG_HS_GINTMSK_CIDSCHGM_Pos        = 0x1c       // Position of CIDSCHGM field.
	USB_OTG_HS_OTG_HS_GINTMSK_CIDSCHGM_Msk        = 0x10000000 // Bit mask of CIDSCHGM field.
	USB_OTG_HS_OTG_HS_GINTMSK_CIDSCHGM            = 0x10000000 // Bit CIDSCHGM.
	USB_OTG_HS_OTG_HS_GINTMSK_DISCINT_Pos         = 0x1d       // Position of DISCINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_DISCINT_Msk         = 0x20000000 // Bit mask of DISCINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_DISCINT             = 0x20000000 // Bit DISCINT.
	USB_OTG_HS_OTG_HS_GINTMSK_SRQIM_Pos           = 0x1e       // Position of SRQIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_SRQIM_Msk           = 0x40000000 // Bit mask of SRQIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_SRQIM               = 0x40000000 // Bit SRQIM.
	USB_OTG_HS_OTG_HS_GINTMSK_WUIM_Pos            = 0x1f       // Position of WUIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_WUIM_Msk            = 0x80000000 // Bit mask of WUIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_WUIM                = 0x80000000 // Bit WUIM.

	// OTG_HS_GRXSTSR_Host: OTG_HS Receive status debug read register           (host mode)
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_CHNUM_Pos  = 0x0      // Position of CHNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_CHNUM_Msk  = 0xf      // Bit mask of CHNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_BCNT_Pos   = 0x4      // Position of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_BCNT_Msk   = 0x7ff0   // Bit mask of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_DPID_Pos   = 0xf      // Position of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_DPID_Msk   = 0x18000  // Bit mask of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_PKTSTS_Pos = 0x11     // Position of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_PKTSTS_Msk = 0x1e0000 // Bit mask of PKTSTS field.

	// OTG_HS_GRXSTSR_Peripheral: OTG_HS Receive status debug read register           (peripheral mode mode)
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_EPNUM_Pos  = 0x0       // Position of EPNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_EPNUM_Msk  = 0xf       // Bit mask of EPNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_BCNT_Pos   = 0x4       // Position of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_BCNT_Msk   = 0x7ff0    // Bit mask of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_DPID_Pos   = 0xf       // Position of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_DPID_Msk   = 0x18000   // Bit mask of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_PKTSTS_Pos = 0x11      // Position of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_PKTSTS_Msk = 0x1e0000  // Bit mask of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_FRMNUM_Pos = 0x15      // Position of FRMNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Peripheral_FRMNUM_Msk = 0x1e00000 // Bit mask of FRMNUM field.

	// OTG_HS_GRXSTSP_Host: OTG_HS status read and pop register (host           mode)
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_CHNUM_Pos  = 0x0      // Position of CHNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_CHNUM_Msk  = 0xf      // Bit mask of CHNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_BCNT_Pos   = 0x4      // Position of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_BCNT_Msk   = 0x7ff0   // Bit mask of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_DPID_Pos   = 0xf      // Position of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_DPID_Msk   = 0x18000  // Bit mask of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_PKTSTS_Pos = 0x11     // Position of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_PKTSTS_Msk = 0x1e0000 // Bit mask of PKTSTS field.

	// OTG_HS_GRXSTSP_Peripheral: OTG_HS status read and pop register           (peripheral mode)
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_EPNUM_Pos  = 0x0       // Position of EPNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_EPNUM_Msk  = 0xf       // Bit mask of EPNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_BCNT_Pos   = 0x4       // Position of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_BCNT_Msk   = 0x7ff0    // Bit mask of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_DPID_Pos   = 0xf       // Position of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_DPID_Msk   = 0x18000   // Bit mask of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_PKTSTS_Pos = 0x11      // Position of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_PKTSTS_Msk = 0x1e0000  // Bit mask of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_FRMNUM_Pos = 0x15      // Position of FRMNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Peripheral_FRMNUM_Msk = 0x1e00000 // Bit mask of FRMNUM field.

	// OTG_HS_GRXFSIZ: OTG_HS Receive FIFO size           register
	USB_OTG_HS_OTG_HS_GRXFSIZ_RXFD_Pos = 0x0    // Position of RXFD field.
	USB_OTG_HS_OTG_HS_GRXFSIZ_RXFD_Msk = 0xffff // Bit mask of RXFD field.

	// OTG_HS_GNPTXFSIZ_Host: OTG_HS nonperiodic transmit FIFO size           register (host mode)
	USB_OTG_HS_OTG_HS_GNPTXFSIZ_Host_NPTXFSA_Pos = 0x0        // Position of NPTXFSA field.
	USB_OTG_HS_OTG_HS_GNPTXFSIZ_Host_NPTXFSA_Msk = 0xffff     // Bit mask of NPTXFSA field.
	USB_OTG_HS_OTG_HS_GNPTXFSIZ_Host_NPTXFD_Pos  = 0x10       // Position of NPTXFD field.
	USB_OTG_HS_OTG_HS_GNPTXFSIZ_Host_NPTXFD_Msk  = 0xffff0000 // Bit mask of NPTXFD field.

	// OTG_HS_TX0FSIZ_Peripheral: Endpoint 0 transmit FIFO size (peripheral           mode)
	USB_OTG_HS_OTG_HS_TX0FSIZ_Peripheral_TX0FSA_Pos = 0x0        // Position of TX0FSA field.
	USB_OTG_HS_OTG_HS_TX0FSIZ_Peripheral_TX0FSA_Msk = 0xffff     // Bit mask of TX0FSA field.
	USB_OTG_HS_OTG_HS_TX0FSIZ_Peripheral_TX0FD_Pos  = 0x10       // Position of TX0FD field.
	USB_OTG_HS_OTG_HS_TX0FSIZ_Peripheral_TX0FD_Msk  = 0xffff0000 // Bit mask of TX0FD field.

	// OTG_HS_GNPTXSTS: OTG_HS nonperiodic transmit FIFO/queue           status register
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTXFSAV_Pos = 0x0        // Position of NPTXFSAV field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTXFSAV_Msk = 0xffff     // Bit mask of NPTXFSAV field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTQXSAV_Pos = 0x10       // Position of NPTQXSAV field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTQXSAV_Msk = 0xff0000   // Bit mask of NPTQXSAV field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTXQTOP_Pos = 0x18       // Position of NPTXQTOP field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTXQTOP_Msk = 0x7f000000 // Bit mask of NPTXQTOP field.

	// OTG_HS_GCCFG: OTG_HS general core configuration           register
	USB_OTG_HS_OTG_HS_GCCFG_PWRDWN_Pos     = 0x10     // Position of PWRDWN field.
	USB_OTG_HS_OTG_HS_GCCFG_PWRDWN_Msk     = 0x10000  // Bit mask of PWRDWN field.
	USB_OTG_HS_OTG_HS_GCCFG_PWRDWN         = 0x10000  // Bit PWRDWN.
	USB_OTG_HS_OTG_HS_GCCFG_I2CPADEN_Pos   = 0x11     // Position of I2CPADEN field.
	USB_OTG_HS_OTG_HS_GCCFG_I2CPADEN_Msk   = 0x20000  // Bit mask of I2CPADEN field.
	USB_OTG_HS_OTG_HS_GCCFG_I2CPADEN       = 0x20000  // Bit I2CPADEN.
	USB_OTG_HS_OTG_HS_GCCFG_VBUSASEN_Pos   = 0x12     // Position of VBUSASEN field.
	USB_OTG_HS_OTG_HS_GCCFG_VBUSASEN_Msk   = 0x40000  // Bit mask of VBUSASEN field.
	USB_OTG_HS_OTG_HS_GCCFG_VBUSASEN       = 0x40000  // Bit VBUSASEN.
	USB_OTG_HS_OTG_HS_GCCFG_VBUSBSEN_Pos   = 0x13     // Position of VBUSBSEN field.
	USB_OTG_HS_OTG_HS_GCCFG_VBUSBSEN_Msk   = 0x80000  // Bit mask of VBUSBSEN field.
	USB_OTG_HS_OTG_HS_GCCFG_VBUSBSEN       = 0x80000  // Bit VBUSBSEN.
	USB_OTG_HS_OTG_HS_GCCFG_SOFOUTEN_Pos   = 0x14     // Position of SOFOUTEN field.
	USB_OTG_HS_OTG_HS_GCCFG_SOFOUTEN_Msk   = 0x100000 // Bit mask of SOFOUTEN field.
	USB_OTG_HS_OTG_HS_GCCFG_SOFOUTEN       = 0x100000 // Bit SOFOUTEN.
	USB_OTG_HS_OTG_HS_GCCFG_NOVBUSSENS_Pos = 0x15     // Position of NOVBUSSENS field.
	USB_OTG_HS_OTG_HS_GCCFG_NOVBUSSENS_Msk = 0x200000 // Bit mask of NOVBUSSENS field.
	USB_OTG_HS_OTG_HS_GCCFG_NOVBUSSENS     = 0x200000 // Bit NOVBUSSENS.

	// OTG_HS_CID: OTG_HS core ID register
	USB_OTG_HS_OTG_HS_CID_PRODUCT_ID_Pos = 0x0        // Position of PRODUCT_ID field.
	USB_OTG_HS_OTG_HS_CID_PRODUCT_ID_Msk = 0xffffffff // Bit mask of PRODUCT_ID field.

	// OTG_HS_HPTXFSIZ: OTG_HS Host periodic transmit FIFO size           register
	USB_OTG_HS_OTG_HS_HPTXFSIZ_PTXSA_Pos = 0x0        // Position of PTXSA field.
	USB_OTG_HS_OTG_HS_HPTXFSIZ_PTXSA_Msk = 0xffff     // Bit mask of PTXSA field.
	USB_OTG_HS_OTG_HS_HPTXFSIZ_PTXFD_Pos = 0x10       // Position of PTXFD field.
	USB_OTG_HS_OTG_HS_HPTXFSIZ_PTXFD_Msk = 0xffff0000 // Bit mask of PTXFD field.

	// OTG_HS_DIEPTXF1: OTG_HS device IN endpoint transmit FIFO size           register
	USB_OTG_HS_OTG_HS_DIEPTXF1_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF1_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF1_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF1_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_HS_DIEPTXF2: OTG_HS device IN endpoint transmit FIFO size           register
	USB_OTG_HS_OTG_HS_DIEPTXF2_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF2_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF2_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF2_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_HS_DIEPTXF3: OTG_HS device IN endpoint transmit FIFO size           register
	USB_OTG_HS_OTG_HS_DIEPTXF3_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF3_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF3_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF3_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_HS_DIEPTXF4: OTG_HS device IN endpoint transmit FIFO size           register
	USB_OTG_HS_OTG_HS_DIEPTXF4_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF4_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF4_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF4_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_HS_DIEPTXF5: OTG_HS device IN endpoint transmit FIFO size           register
	USB_OTG_HS_OTG_HS_DIEPTXF5_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF5_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF5_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF5_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_HS_DIEPTXF6: OTG_HS device IN endpoint transmit FIFO size           register
	USB_OTG_HS_OTG_HS_DIEPTXF6_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF6_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF6_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF6_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.

	// OTG_HS_DIEPTXF7: OTG_HS device IN endpoint transmit FIFO size           register
	USB_OTG_HS_OTG_HS_DIEPTXF7_INEPTXSA_Pos = 0x0        // Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF7_INEPTXSA_Msk = 0xffff     // Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF7_INEPTXFD_Pos = 0x10       // Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF7_INEPTXFD_Msk = 0xffff0000 // Bit mask of INEPTXFD field.
)

// Bitfields for SAI1: Serial audio interface
const (
	// GCR: Global configuration register
	SAI_GCR_SYNCIN_Pos  = 0x0  // Position of SYNCIN field.
	SAI_GCR_SYNCIN_Msk  = 0x3  // Bit mask of SYNCIN field.
	SAI_GCR_SYNCOUT_Pos = 0x4  // Position of SYNCOUT field.
	SAI_GCR_SYNCOUT_Msk = 0x30 // Bit mask of SYNCOUT field.

	// ACR1: AConfiguration register 1
	SAI_ACR1_MCJDIV_Pos   = 0x14     // Position of MCJDIV field.
	SAI_ACR1_MCJDIV_Msk   = 0xf00000 // Bit mask of MCJDIV field.
	SAI_ACR1_NODIV_Pos    = 0x13     // Position of NODIV field.
	SAI_ACR1_NODIV_Msk    = 0x80000  // Bit mask of NODIV field.
	SAI_ACR1_NODIV        = 0x80000  // Bit NODIV.
	SAI_ACR1_DMAEN_Pos    = 0x11     // Position of DMAEN field.
	SAI_ACR1_DMAEN_Msk    = 0x20000  // Bit mask of DMAEN field.
	SAI_ACR1_DMAEN        = 0x20000  // Bit DMAEN.
	SAI_ACR1_SAIAEN_Pos   = 0x10     // Position of SAIAEN field.
	SAI_ACR1_SAIAEN_Msk   = 0x10000  // Bit mask of SAIAEN field.
	SAI_ACR1_SAIAEN       = 0x10000  // Bit SAIAEN.
	SAI_ACR1_OutDri_Pos   = 0xd      // Position of OutDri field.
	SAI_ACR1_OutDri_Msk   = 0x2000   // Bit mask of OutDri field.
	SAI_ACR1_OutDri       = 0x2000   // Bit OutDri.
	SAI_ACR1_MONO_Pos     = 0xc      // Position of MONO field.
	SAI_ACR1_MONO_Msk     = 0x1000   // Bit mask of MONO field.
	SAI_ACR1_MONO         = 0x1000   // Bit MONO.
	SAI_ACR1_SYNCEN_Pos   = 0xa      // Position of SYNCEN field.
	SAI_ACR1_SYNCEN_Msk   = 0xc00    // Bit mask of SYNCEN field.
	SAI_ACR1_CKSTR_Pos    = 0x9      // Position of CKSTR field.
	SAI_ACR1_CKSTR_Msk    = 0x200    // Bit mask of CKSTR field.
	SAI_ACR1_CKSTR        = 0x200    // Bit CKSTR.
	SAI_ACR1_LSBFIRST_Pos = 0x8      // Position of LSBFIRST field.
	SAI_ACR1_LSBFIRST_Msk = 0x100    // Bit mask of LSBFIRST field.
	SAI_ACR1_LSBFIRST     = 0x100    // Bit LSBFIRST.
	SAI_ACR1_DS_Pos       = 0x5      // Position of DS field.
	SAI_ACR1_DS_Msk       = 0xe0     // Bit mask of DS field.
	SAI_ACR1_PRTCFG_Pos   = 0x2      // Position of PRTCFG field.
	SAI_ACR1_PRTCFG_Msk   = 0xc      // Bit mask of PRTCFG field.
	SAI_ACR1_MODE_Pos     = 0x0      // Position of MODE field.
	SAI_ACR1_MODE_Msk     = 0x3      // Bit mask of MODE field.

	// ACR2: AConfiguration register 2
	SAI_ACR2_COMP_Pos    = 0xe    // Position of COMP field.
	SAI_ACR2_COMP_Msk    = 0xc000 // Bit mask of COMP field.
	SAI_ACR2_CPL_Pos     = 0xd    // Position of CPL field.
	SAI_ACR2_CPL_Msk     = 0x2000 // Bit mask of CPL field.
	SAI_ACR2_CPL         = 0x2000 // Bit CPL.
	SAI_ACR2_MUTECN_Pos  = 0x7    // Position of MUTECN field.
	SAI_ACR2_MUTECN_Msk  = 0x1f80 // Bit mask of MUTECN field.
	SAI_ACR2_MUTEVAL_Pos = 0x6    // Position of MUTEVAL field.
	SAI_ACR2_MUTEVAL_Msk = 0x40   // Bit mask of MUTEVAL field.
	SAI_ACR2_MUTEVAL     = 0x40   // Bit MUTEVAL.
	SAI_ACR2_MUTE_Pos    = 0x5    // Position of MUTE field.
	SAI_ACR2_MUTE_Msk    = 0x20   // Bit mask of MUTE field.
	SAI_ACR2_MUTE        = 0x20   // Bit MUTE.
	SAI_ACR2_TRIS_Pos    = 0x4    // Position of TRIS field.
	SAI_ACR2_TRIS_Msk    = 0x10   // Bit mask of TRIS field.
	SAI_ACR2_TRIS        = 0x10   // Bit TRIS.
	SAI_ACR2_FFLUS_Pos   = 0x3    // Position of FFLUS field.
	SAI_ACR2_FFLUS_Msk   = 0x8    // Bit mask of FFLUS field.
	SAI_ACR2_FFLUS       = 0x8    // Bit FFLUS.
	SAI_ACR2_FTH_Pos     = 0x0    // Position of FTH field.
	SAI_ACR2_FTH_Msk     = 0x7    // Bit mask of FTH field.

	// AFRCR: AFRCR
	SAI_AFRCR_FSOFF_Pos = 0x12    // Position of FSOFF field.
	SAI_AFRCR_FSOFF_Msk = 0x40000 // Bit mask of FSOFF field.
	SAI_AFRCR_FSOFF     = 0x40000 // Bit FSOFF.
	SAI_AFRCR_FSPOL_Pos = 0x11    // Position of FSPOL field.
	SAI_AFRCR_FSPOL_Msk = 0x20000 // Bit mask of FSPOL field.
	SAI_AFRCR_FSPOL     = 0x20000 // Bit FSPOL.
	SAI_AFRCR_FSDEF_Pos = 0x10    // Position of FSDEF field.
	SAI_AFRCR_FSDEF_Msk = 0x10000 // Bit mask of FSDEF field.
	SAI_AFRCR_FSDEF     = 0x10000 // Bit FSDEF.
	SAI_AFRCR_FSALL_Pos = 0x8     // Position of FSALL field.
	SAI_AFRCR_FSALL_Msk = 0x7f00  // Bit mask of FSALL field.
	SAI_AFRCR_FRL_Pos   = 0x0     // Position of FRL field.
	SAI_AFRCR_FRL_Msk   = 0xff    // Bit mask of FRL field.

	// ASLOTR: ASlot register
	SAI_ASLOTR_SLOTEN_Pos = 0x10       // Position of SLOTEN field.
	SAI_ASLOTR_SLOTEN_Msk = 0xffff0000 // Bit mask of SLOTEN field.
	SAI_ASLOTR_NBSLOT_Pos = 0x8        // Position of NBSLOT field.
	SAI_ASLOTR_NBSLOT_Msk = 0xf00      // Bit mask of NBSLOT field.
	SAI_ASLOTR_SLOTSZ_Pos = 0x6        // Position of SLOTSZ field.
	SAI_ASLOTR_SLOTSZ_Msk = 0xc0       // Bit mask of SLOTSZ field.
	SAI_ASLOTR_FBOFF_Pos  = 0x0        // Position of FBOFF field.
	SAI_ASLOTR_FBOFF_Msk  = 0x1f       // Bit mask of FBOFF field.

	// AIM: AInterrupt mask register2
	SAI_AIM_LFSDET_Pos   = 0x6  // Position of LFSDET field.
	SAI_AIM_LFSDET_Msk   = 0x40 // Bit mask of LFSDET field.
	SAI_AIM_LFSDET       = 0x40 // Bit LFSDET.
	SAI_AIM_AFSDETIE_Pos = 0x5  // Position of AFSDETIE field.
	SAI_AIM_AFSDETIE_Msk = 0x20 // Bit mask of AFSDETIE field.
	SAI_AIM_AFSDETIE     = 0x20 // Bit AFSDETIE.
	SAI_AIM_CNRDYIE_Pos  = 0x4  // Position of CNRDYIE field.
	SAI_AIM_CNRDYIE_Msk  = 0x10 // Bit mask of CNRDYIE field.
	SAI_AIM_CNRDYIE      = 0x10 // Bit CNRDYIE.
	SAI_AIM_FREQIE_Pos   = 0x3  // Position of FREQIE field.
	SAI_AIM_FREQIE_Msk   = 0x8  // Bit mask of FREQIE field.
	SAI_AIM_FREQIE       = 0x8  // Bit FREQIE.
	SAI_AIM_WCKCFG_Pos   = 0x2  // Position of WCKCFG field.
	SAI_AIM_WCKCFG_Msk   = 0x4  // Bit mask of WCKCFG field.
	SAI_AIM_WCKCFG       = 0x4  // Bit WCKCFG.
	SAI_AIM_MUTEDET_Pos  = 0x1  // Position of MUTEDET field.
	SAI_AIM_MUTEDET_Msk  = 0x2  // Bit mask of MUTEDET field.
	SAI_AIM_MUTEDET      = 0x2  // Bit MUTEDET.
	SAI_AIM_OVRUDRIE_Pos = 0x0  // Position of OVRUDRIE field.
	SAI_AIM_OVRUDRIE_Msk = 0x1  // Bit mask of OVRUDRIE field.
	SAI_AIM_OVRUDRIE     = 0x1  // Bit OVRUDRIE.

	// ASR: AStatus register
	SAI_ASR_FLVL_Pos    = 0x10    // Position of FLVL field.
	SAI_ASR_FLVL_Msk    = 0x70000 // Bit mask of FLVL field.
	SAI_ASR_LFSDET_Pos  = 0x6     // Position of LFSDET field.
	SAI_ASR_LFSDET_Msk  = 0x40    // Bit mask of LFSDET field.
	SAI_ASR_LFSDET      = 0x40    // Bit LFSDET.
	SAI_ASR_AFSDET_Pos  = 0x5     // Position of AFSDET field.
	SAI_ASR_AFSDET_Msk  = 0x20    // Bit mask of AFSDET field.
	SAI_ASR_AFSDET      = 0x20    // Bit AFSDET.
	SAI_ASR_CNRDY_Pos   = 0x4     // Position of CNRDY field.
	SAI_ASR_CNRDY_Msk   = 0x10    // Bit mask of CNRDY field.
	SAI_ASR_CNRDY       = 0x10    // Bit CNRDY.
	SAI_ASR_FREQ_Pos    = 0x3     // Position of FREQ field.
	SAI_ASR_FREQ_Msk    = 0x8     // Bit mask of FREQ field.
	SAI_ASR_FREQ        = 0x8     // Bit FREQ.
	SAI_ASR_WCKCFG_Pos  = 0x2     // Position of WCKCFG field.
	SAI_ASR_WCKCFG_Msk  = 0x4     // Bit mask of WCKCFG field.
	SAI_ASR_WCKCFG      = 0x4     // Bit WCKCFG.
	SAI_ASR_MUTEDET_Pos = 0x1     // Position of MUTEDET field.
	SAI_ASR_MUTEDET_Msk = 0x2     // Bit mask of MUTEDET field.
	SAI_ASR_MUTEDET     = 0x2     // Bit MUTEDET.
	SAI_ASR_OVRUDR_Pos  = 0x0     // Position of OVRUDR field.
	SAI_ASR_OVRUDR_Msk  = 0x1     // Bit mask of OVRUDR field.
	SAI_ASR_OVRUDR      = 0x1     // Bit OVRUDR.

	// ACLRFR: AClear flag register
	SAI_ACLRFR_LFSDET_Pos  = 0x6  // Position of LFSDET field.
	SAI_ACLRFR_LFSDET_Msk  = 0x40 // Bit mask of LFSDET field.
	SAI_ACLRFR_LFSDET      = 0x40 // Bit LFSDET.
	SAI_ACLRFR_CAFSDET_Pos = 0x5  // Position of CAFSDET field.
	SAI_ACLRFR_CAFSDET_Msk = 0x20 // Bit mask of CAFSDET field.
	SAI_ACLRFR_CAFSDET     = 0x20 // Bit CAFSDET.
	SAI_ACLRFR_CNRDY_Pos   = 0x4  // Position of CNRDY field.
	SAI_ACLRFR_CNRDY_Msk   = 0x10 // Bit mask of CNRDY field.
	SAI_ACLRFR_CNRDY       = 0x10 // Bit CNRDY.
	SAI_ACLRFR_WCKCFG_Pos  = 0x2  // Position of WCKCFG field.
	SAI_ACLRFR_WCKCFG_Msk  = 0x4  // Bit mask of WCKCFG field.
	SAI_ACLRFR_WCKCFG      = 0x4  // Bit WCKCFG.
	SAI_ACLRFR_MUTEDET_Pos = 0x1  // Position of MUTEDET field.
	SAI_ACLRFR_MUTEDET_Msk = 0x2  // Bit mask of MUTEDET field.
	SAI_ACLRFR_MUTEDET     = 0x2  // Bit MUTEDET.
	SAI_ACLRFR_OVRUDR_Pos  = 0x0  // Position of OVRUDR field.
	SAI_ACLRFR_OVRUDR_Msk  = 0x1  // Bit mask of OVRUDR field.
	SAI_ACLRFR_OVRUDR      = 0x1  // Bit OVRUDR.

	// ADR: AData register
	SAI_ADR_DATA_Pos = 0x0        // Position of DATA field.
	SAI_ADR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// BCR1: BConfiguration register 1
	SAI_BCR1_MCJDIV_Pos   = 0x14     // Position of MCJDIV field.
	SAI_BCR1_MCJDIV_Msk   = 0xf00000 // Bit mask of MCJDIV field.
	SAI_BCR1_NODIV_Pos    = 0x13     // Position of NODIV field.
	SAI_BCR1_NODIV_Msk    = 0x80000  // Bit mask of NODIV field.
	SAI_BCR1_NODIV        = 0x80000  // Bit NODIV.
	SAI_BCR1_DMAEN_Pos    = 0x11     // Position of DMAEN field.
	SAI_BCR1_DMAEN_Msk    = 0x20000  // Bit mask of DMAEN field.
	SAI_BCR1_DMAEN        = 0x20000  // Bit DMAEN.
	SAI_BCR1_SAIBEN_Pos   = 0x10     // Position of SAIBEN field.
	SAI_BCR1_SAIBEN_Msk   = 0x10000  // Bit mask of SAIBEN field.
	SAI_BCR1_SAIBEN       = 0x10000  // Bit SAIBEN.
	SAI_BCR1_OutDri_Pos   = 0xd      // Position of OutDri field.
	SAI_BCR1_OutDri_Msk   = 0x2000   // Bit mask of OutDri field.
	SAI_BCR1_OutDri       = 0x2000   // Bit OutDri.
	SAI_BCR1_MONO_Pos     = 0xc      // Position of MONO field.
	SAI_BCR1_MONO_Msk     = 0x1000   // Bit mask of MONO field.
	SAI_BCR1_MONO         = 0x1000   // Bit MONO.
	SAI_BCR1_SYNCEN_Pos   = 0xa      // Position of SYNCEN field.
	SAI_BCR1_SYNCEN_Msk   = 0xc00    // Bit mask of SYNCEN field.
	SAI_BCR1_CKSTR_Pos    = 0x9      // Position of CKSTR field.
	SAI_BCR1_CKSTR_Msk    = 0x200    // Bit mask of CKSTR field.
	SAI_BCR1_CKSTR        = 0x200    // Bit CKSTR.
	SAI_BCR1_LSBFIRST_Pos = 0x8      // Position of LSBFIRST field.
	SAI_BCR1_LSBFIRST_Msk = 0x100    // Bit mask of LSBFIRST field.
	SAI_BCR1_LSBFIRST     = 0x100    // Bit LSBFIRST.
	SAI_BCR1_DS_Pos       = 0x5      // Position of DS field.
	SAI_BCR1_DS_Msk       = 0xe0     // Bit mask of DS field.
	SAI_BCR1_PRTCFG_Pos   = 0x2      // Position of PRTCFG field.
	SAI_BCR1_PRTCFG_Msk   = 0xc      // Bit mask of PRTCFG field.
	SAI_BCR1_MODE_Pos     = 0x0      // Position of MODE field.
	SAI_BCR1_MODE_Msk     = 0x3      // Bit mask of MODE field.

	// BCR2: BConfiguration register 2
	SAI_BCR2_COMP_Pos    = 0xe    // Position of COMP field.
	SAI_BCR2_COMP_Msk    = 0xc000 // Bit mask of COMP field.
	SAI_BCR2_CPL_Pos     = 0xd    // Position of CPL field.
	SAI_BCR2_CPL_Msk     = 0x2000 // Bit mask of CPL field.
	SAI_BCR2_CPL         = 0x2000 // Bit CPL.
	SAI_BCR2_MUTECN_Pos  = 0x7    // Position of MUTECN field.
	SAI_BCR2_MUTECN_Msk  = 0x1f80 // Bit mask of MUTECN field.
	SAI_BCR2_MUTEVAL_Pos = 0x6    // Position of MUTEVAL field.
	SAI_BCR2_MUTEVAL_Msk = 0x40   // Bit mask of MUTEVAL field.
	SAI_BCR2_MUTEVAL     = 0x40   // Bit MUTEVAL.
	SAI_BCR2_MUTE_Pos    = 0x5    // Position of MUTE field.
	SAI_BCR2_MUTE_Msk    = 0x20   // Bit mask of MUTE field.
	SAI_BCR2_MUTE        = 0x20   // Bit MUTE.
	SAI_BCR2_TRIS_Pos    = 0x4    // Position of TRIS field.
	SAI_BCR2_TRIS_Msk    = 0x10   // Bit mask of TRIS field.
	SAI_BCR2_TRIS        = 0x10   // Bit TRIS.
	SAI_BCR2_FFLUS_Pos   = 0x3    // Position of FFLUS field.
	SAI_BCR2_FFLUS_Msk   = 0x8    // Bit mask of FFLUS field.
	SAI_BCR2_FFLUS       = 0x8    // Bit FFLUS.
	SAI_BCR2_FTH_Pos     = 0x0    // Position of FTH field.
	SAI_BCR2_FTH_Msk     = 0x7    // Bit mask of FTH field.

	// BFRCR: BFRCR
	SAI_BFRCR_FSOFF_Pos = 0x12    // Position of FSOFF field.
	SAI_BFRCR_FSOFF_Msk = 0x40000 // Bit mask of FSOFF field.
	SAI_BFRCR_FSOFF     = 0x40000 // Bit FSOFF.
	SAI_BFRCR_FSPOL_Pos = 0x11    // Position of FSPOL field.
	SAI_BFRCR_FSPOL_Msk = 0x20000 // Bit mask of FSPOL field.
	SAI_BFRCR_FSPOL     = 0x20000 // Bit FSPOL.
	SAI_BFRCR_FSDEF_Pos = 0x10    // Position of FSDEF field.
	SAI_BFRCR_FSDEF_Msk = 0x10000 // Bit mask of FSDEF field.
	SAI_BFRCR_FSDEF     = 0x10000 // Bit FSDEF.
	SAI_BFRCR_FSALL_Pos = 0x8     // Position of FSALL field.
	SAI_BFRCR_FSALL_Msk = 0x7f00  // Bit mask of FSALL field.
	SAI_BFRCR_FRL_Pos   = 0x0     // Position of FRL field.
	SAI_BFRCR_FRL_Msk   = 0xff    // Bit mask of FRL field.

	// BSLOTR: BSlot register
	SAI_BSLOTR_SLOTEN_Pos = 0x10       // Position of SLOTEN field.
	SAI_BSLOTR_SLOTEN_Msk = 0xffff0000 // Bit mask of SLOTEN field.
	SAI_BSLOTR_NBSLOT_Pos = 0x8        // Position of NBSLOT field.
	SAI_BSLOTR_NBSLOT_Msk = 0xf00      // Bit mask of NBSLOT field.
	SAI_BSLOTR_SLOTSZ_Pos = 0x6        // Position of SLOTSZ field.
	SAI_BSLOTR_SLOTSZ_Msk = 0xc0       // Bit mask of SLOTSZ field.
	SAI_BSLOTR_FBOFF_Pos  = 0x0        // Position of FBOFF field.
	SAI_BSLOTR_FBOFF_Msk  = 0x1f       // Bit mask of FBOFF field.

	// BIM: BInterrupt mask register2
	SAI_BIM_LFSDETIE_Pos = 0x6  // Position of LFSDETIE field.
	SAI_BIM_LFSDETIE_Msk = 0x40 // Bit mask of LFSDETIE field.
	SAI_BIM_LFSDETIE     = 0x40 // Bit LFSDETIE.
	SAI_BIM_AFSDETIE_Pos = 0x5  // Position of AFSDETIE field.
	SAI_BIM_AFSDETIE_Msk = 0x20 // Bit mask of AFSDETIE field.
	SAI_BIM_AFSDETIE     = 0x20 // Bit AFSDETIE.
	SAI_BIM_CNRDYIE_Pos  = 0x4  // Position of CNRDYIE field.
	SAI_BIM_CNRDYIE_Msk  = 0x10 // Bit mask of CNRDYIE field.
	SAI_BIM_CNRDYIE      = 0x10 // Bit CNRDYIE.
	SAI_BIM_FREQIE_Pos   = 0x3  // Position of FREQIE field.
	SAI_BIM_FREQIE_Msk   = 0x8  // Bit mask of FREQIE field.
	SAI_BIM_FREQIE       = 0x8  // Bit FREQIE.
	SAI_BIM_WCKCFG_Pos   = 0x2  // Position of WCKCFG field.
	SAI_BIM_WCKCFG_Msk   = 0x4  // Bit mask of WCKCFG field.
	SAI_BIM_WCKCFG       = 0x4  // Bit WCKCFG.
	SAI_BIM_MUTEDET_Pos  = 0x1  // Position of MUTEDET field.
	SAI_BIM_MUTEDET_Msk  = 0x2  // Bit mask of MUTEDET field.
	SAI_BIM_MUTEDET      = 0x2  // Bit MUTEDET.
	SAI_BIM_OVRUDRIE_Pos = 0x0  // Position of OVRUDRIE field.
	SAI_BIM_OVRUDRIE_Msk = 0x1  // Bit mask of OVRUDRIE field.
	SAI_BIM_OVRUDRIE     = 0x1  // Bit OVRUDRIE.

	// BSR: BStatus register
	SAI_BSR_FLVL_Pos    = 0x10    // Position of FLVL field.
	SAI_BSR_FLVL_Msk    = 0x70000 // Bit mask of FLVL field.
	SAI_BSR_LFSDET_Pos  = 0x6     // Position of LFSDET field.
	SAI_BSR_LFSDET_Msk  = 0x40    // Bit mask of LFSDET field.
	SAI_BSR_LFSDET      = 0x40    // Bit LFSDET.
	SAI_BSR_AFSDET_Pos  = 0x5     // Position of AFSDET field.
	SAI_BSR_AFSDET_Msk  = 0x20    // Bit mask of AFSDET field.
	SAI_BSR_AFSDET      = 0x20    // Bit AFSDET.
	SAI_BSR_CNRDY_Pos   = 0x4     // Position of CNRDY field.
	SAI_BSR_CNRDY_Msk   = 0x10    // Bit mask of CNRDY field.
	SAI_BSR_CNRDY       = 0x10    // Bit CNRDY.
	SAI_BSR_FREQ_Pos    = 0x3     // Position of FREQ field.
	SAI_BSR_FREQ_Msk    = 0x8     // Bit mask of FREQ field.
	SAI_BSR_FREQ        = 0x8     // Bit FREQ.
	SAI_BSR_WCKCFG_Pos  = 0x2     // Position of WCKCFG field.
	SAI_BSR_WCKCFG_Msk  = 0x4     // Bit mask of WCKCFG field.
	SAI_BSR_WCKCFG      = 0x4     // Bit WCKCFG.
	SAI_BSR_MUTEDET_Pos = 0x1     // Position of MUTEDET field.
	SAI_BSR_MUTEDET_Msk = 0x2     // Bit mask of MUTEDET field.
	SAI_BSR_MUTEDET     = 0x2     // Bit MUTEDET.
	SAI_BSR_OVRUDR_Pos  = 0x0     // Position of OVRUDR field.
	SAI_BSR_OVRUDR_Msk  = 0x1     // Bit mask of OVRUDR field.
	SAI_BSR_OVRUDR      = 0x1     // Bit OVRUDR.

	// BCLRFR: BClear flag register
	SAI_BCLRFR_LFSDET_Pos  = 0x6  // Position of LFSDET field.
	SAI_BCLRFR_LFSDET_Msk  = 0x40 // Bit mask of LFSDET field.
	SAI_BCLRFR_LFSDET      = 0x40 // Bit LFSDET.
	SAI_BCLRFR_CAFSDET_Pos = 0x5  // Position of CAFSDET field.
	SAI_BCLRFR_CAFSDET_Msk = 0x20 // Bit mask of CAFSDET field.
	SAI_BCLRFR_CAFSDET     = 0x20 // Bit CAFSDET.
	SAI_BCLRFR_CNRDY_Pos   = 0x4  // Position of CNRDY field.
	SAI_BCLRFR_CNRDY_Msk   = 0x10 // Bit mask of CNRDY field.
	SAI_BCLRFR_CNRDY       = 0x10 // Bit CNRDY.
	SAI_BCLRFR_WCKCFG_Pos  = 0x2  // Position of WCKCFG field.
	SAI_BCLRFR_WCKCFG_Msk  = 0x4  // Bit mask of WCKCFG field.
	SAI_BCLRFR_WCKCFG      = 0x4  // Bit WCKCFG.
	SAI_BCLRFR_MUTEDET_Pos = 0x1  // Position of MUTEDET field.
	SAI_BCLRFR_MUTEDET_Msk = 0x2  // Bit mask of MUTEDET field.
	SAI_BCLRFR_MUTEDET     = 0x2  // Bit MUTEDET.
	SAI_BCLRFR_OVRUDR_Pos  = 0x0  // Position of OVRUDR field.
	SAI_BCLRFR_OVRUDR_Msk  = 0x1  // Bit mask of OVRUDR field.
	SAI_BCLRFR_OVRUDR      = 0x1  // Bit OVRUDR.

	// BDR: BData register
	SAI_BDR_DATA_Pos = 0x0        // Position of DATA field.
	SAI_BDR_DATA_Msk = 0xffffffff // Bit mask of DATA field.
)

// Bitfields for PWR: Power control
const (
	// CR: power control register
	PWR_CR_LPDS_Pos   = 0x0      // Position of LPDS field.
	PWR_CR_LPDS_Msk   = 0x1      // Bit mask of LPDS field.
	PWR_CR_LPDS       = 0x1      // Bit LPDS.
	PWR_CR_PDDS_Pos   = 0x1      // Position of PDDS field.
	PWR_CR_PDDS_Msk   = 0x2      // Bit mask of PDDS field.
	PWR_CR_PDDS       = 0x2      // Bit PDDS.
	PWR_CR_CWUF_Pos   = 0x2      // Position of CWUF field.
	PWR_CR_CWUF_Msk   = 0x4      // Bit mask of CWUF field.
	PWR_CR_CWUF       = 0x4      // Bit CWUF.
	PWR_CR_CSBF_Pos   = 0x3      // Position of CSBF field.
	PWR_CR_CSBF_Msk   = 0x8      // Bit mask of CSBF field.
	PWR_CR_CSBF       = 0x8      // Bit CSBF.
	PWR_CR_PVDE_Pos   = 0x4      // Position of PVDE field.
	PWR_CR_PVDE_Msk   = 0x10     // Bit mask of PVDE field.
	PWR_CR_PVDE       = 0x10     // Bit PVDE.
	PWR_CR_PLS_Pos    = 0x5      // Position of PLS field.
	PWR_CR_PLS_Msk    = 0xe0     // Bit mask of PLS field.
	PWR_CR_DBP_Pos    = 0x8      // Position of DBP field.
	PWR_CR_DBP_Msk    = 0x100    // Bit mask of DBP field.
	PWR_CR_DBP        = 0x100    // Bit DBP.
	PWR_CR_FPDS_Pos   = 0x9      // Position of FPDS field.
	PWR_CR_FPDS_Msk   = 0x200    // Bit mask of FPDS field.
	PWR_CR_FPDS       = 0x200    // Bit FPDS.
	PWR_CR_LPLVDS_Pos = 0xa      // Position of LPLVDS field.
	PWR_CR_LPLVDS_Msk = 0x400    // Bit mask of LPLVDS field.
	PWR_CR_LPLVDS     = 0x400    // Bit LPLVDS.
	PWR_CR_MRLVDS_Pos = 0xb      // Position of MRLVDS field.
	PWR_CR_MRLVDS_Msk = 0x800    // Bit mask of MRLVDS field.
	PWR_CR_MRLVDS     = 0x800    // Bit MRLVDS.
	PWR_CR_ADCDC1_Pos = 0xd      // Position of ADCDC1 field.
	PWR_CR_ADCDC1_Msk = 0x2000   // Bit mask of ADCDC1 field.
	PWR_CR_ADCDC1     = 0x2000   // Bit ADCDC1.
	PWR_CR_VOS_Pos    = 0xe      // Position of VOS field.
	PWR_CR_VOS_Msk    = 0xc000   // Bit mask of VOS field.
	PWR_CR_ODEN_Pos   = 0x10     // Position of ODEN field.
	PWR_CR_ODEN_Msk   = 0x10000  // Bit mask of ODEN field.
	PWR_CR_ODEN       = 0x10000  // Bit ODEN.
	PWR_CR_ODSWEN_Pos = 0x11     // Position of ODSWEN field.
	PWR_CR_ODSWEN_Msk = 0x20000  // Bit mask of ODSWEN field.
	PWR_CR_ODSWEN     = 0x20000  // Bit ODSWEN.
	PWR_CR_UDEN_Pos   = 0x12     // Position of UDEN field.
	PWR_CR_UDEN_Msk   = 0xc0000  // Bit mask of UDEN field.
	PWR_CR_FMSSR_Pos  = 0x14     // Position of FMSSR field.
	PWR_CR_FMSSR_Msk  = 0x100000 // Bit mask of FMSSR field.
	PWR_CR_FMSSR      = 0x100000 // Bit FMSSR.
	PWR_CR_FISSR_Pos  = 0x15     // Position of FISSR field.
	PWR_CR_FISSR_Msk  = 0x200000 // Bit mask of FISSR field.
	PWR_CR_FISSR      = 0x200000 // Bit FISSR.

	// CSR: power control/status register
	PWR_CSR_WUF_Pos     = 0x0     // Position of WUF field.
	PWR_CSR_WUF_Msk     = 0x1     // Bit mask of WUF field.
	PWR_CSR_WUF         = 0x1     // Bit WUF.
	PWR_CSR_SBF_Pos     = 0x1     // Position of SBF field.
	PWR_CSR_SBF_Msk     = 0x2     // Bit mask of SBF field.
	PWR_CSR_SBF         = 0x2     // Bit SBF.
	PWR_CSR_PVDO_Pos    = 0x2     // Position of PVDO field.
	PWR_CSR_PVDO_Msk    = 0x4     // Bit mask of PVDO field.
	PWR_CSR_PVDO        = 0x4     // Bit PVDO.
	PWR_CSR_BRR_Pos     = 0x3     // Position of BRR field.
	PWR_CSR_BRR_Msk     = 0x8     // Bit mask of BRR field.
	PWR_CSR_BRR         = 0x8     // Bit BRR.
	PWR_CSR_EWUP2_Pos   = 0x7     // Position of EWUP2 field.
	PWR_CSR_EWUP2_Msk   = 0x80    // Bit mask of EWUP2 field.
	PWR_CSR_EWUP2       = 0x80    // Bit EWUP2.
	PWR_CSR_EWUP_Pos    = 0x8     // Position of EWUP field.
	PWR_CSR_EWUP_Msk    = 0x100   // Bit mask of EWUP field.
	PWR_CSR_EWUP        = 0x100   // Bit EWUP.
	PWR_CSR_BRE_Pos     = 0x9     // Position of BRE field.
	PWR_CSR_BRE_Msk     = 0x200   // Bit mask of BRE field.
	PWR_CSR_BRE         = 0x200   // Bit BRE.
	PWR_CSR_VOSRDY_Pos  = 0xe     // Position of VOSRDY field.
	PWR_CSR_VOSRDY_Msk  = 0x4000  // Bit mask of VOSRDY field.
	PWR_CSR_VOSRDY      = 0x4000  // Bit VOSRDY.
	PWR_CSR_ODRDY_Pos   = 0x10    // Position of ODRDY field.
	PWR_CSR_ODRDY_Msk   = 0x10000 // Bit mask of ODRDY field.
	PWR_CSR_ODRDY       = 0x10000 // Bit ODRDY.
	PWR_CSR_ODSWRDY_Pos = 0x11    // Position of ODSWRDY field.
	PWR_CSR_ODSWRDY_Msk = 0x20000 // Bit mask of ODSWRDY field.
	PWR_CSR_ODSWRDY     = 0x20000 // Bit ODSWRDY.
	PWR_CSR_UDRDY_Pos   = 0x12    // Position of UDRDY field.
	PWR_CSR_UDRDY_Msk   = 0xc0000 // Bit mask of UDRDY field.
)

// Bitfields for QUADSPI: QuadSPI interface
const (
	// CR: control register
	QUADSPI_CR_PRESCALER_Pos = 0x18       // Position of PRESCALER field.
	QUADSPI_CR_PRESCALER_Msk = 0xff000000 // Bit mask of PRESCALER field.
	QUADSPI_CR_PMM_Pos       = 0x17       // Position of PMM field.
	QUADSPI_CR_PMM_Msk       = 0x800000   // Bit mask of PMM field.
	QUADSPI_CR_PMM           = 0x800000   // Bit PMM.
	QUADSPI_CR_APMS_Pos      = 0x16       // Position of APMS field.
	QUADSPI_CR_APMS_Msk      = 0x400000   // Bit mask of APMS field.
	QUADSPI_CR_APMS          = 0x400000   // Bit APMS.
	QUADSPI_CR_TOIE_Pos      = 0x14       // Position of TOIE field.
	QUADSPI_CR_TOIE_Msk      = 0x100000   // Bit mask of TOIE field.
	QUADSPI_CR_TOIE          = 0x100000   // Bit TOIE.
	QUADSPI_CR_SMIE_Pos      = 0x13       // Position of SMIE field.
	QUADSPI_CR_SMIE_Msk      = 0x80000    // Bit mask of SMIE field.
	QUADSPI_CR_SMIE          = 0x80000    // Bit SMIE.
	QUADSPI_CR_FTIE_Pos      = 0x12       // Position of FTIE field.
	QUADSPI_CR_FTIE_Msk      = 0x40000    // Bit mask of FTIE field.
	QUADSPI_CR_FTIE          = 0x40000    // Bit FTIE.
	QUADSPI_CR_TCIE_Pos      = 0x11       // Position of TCIE field.
	QUADSPI_CR_TCIE_Msk      = 0x20000    // Bit mask of TCIE field.
	QUADSPI_CR_TCIE          = 0x20000    // Bit TCIE.
	QUADSPI_CR_TEIE_Pos      = 0x10       // Position of TEIE field.
	QUADSPI_CR_TEIE_Msk      = 0x10000    // Bit mask of TEIE field.
	QUADSPI_CR_TEIE          = 0x10000    // Bit TEIE.
	QUADSPI_CR_FTHRES_Pos    = 0x8        // Position of FTHRES field.
	QUADSPI_CR_FTHRES_Msk    = 0x1f00     // Bit mask of FTHRES field.
	QUADSPI_CR_FSEL_Pos      = 0x7        // Position of FSEL field.
	QUADSPI_CR_FSEL_Msk      = 0x80       // Bit mask of FSEL field.
	QUADSPI_CR_FSEL          = 0x80       // Bit FSEL.
	QUADSPI_CR_DFM_Pos       = 0x6        // Position of DFM field.
	QUADSPI_CR_DFM_Msk       = 0x40       // Bit mask of DFM field.
	QUADSPI_CR_DFM           = 0x40       // Bit DFM.
	QUADSPI_CR_SSHIFT_Pos    = 0x4        // Position of SSHIFT field.
	QUADSPI_CR_SSHIFT_Msk    = 0x10       // Bit mask of SSHIFT field.
	QUADSPI_CR_SSHIFT        = 0x10       // Bit SSHIFT.
	QUADSPI_CR_TCEN_Pos      = 0x3        // Position of TCEN field.
	QUADSPI_CR_TCEN_Msk      = 0x8        // Bit mask of TCEN field.
	QUADSPI_CR_TCEN          = 0x8        // Bit TCEN.
	QUADSPI_CR_DMAEN_Pos     = 0x2        // Position of DMAEN field.
	QUADSPI_CR_DMAEN_Msk     = 0x4        // Bit mask of DMAEN field.
	QUADSPI_CR_DMAEN         = 0x4        // Bit DMAEN.
	QUADSPI_CR_ABORT_Pos     = 0x1        // Position of ABORT field.
	QUADSPI_CR_ABORT_Msk     = 0x2        // Bit mask of ABORT field.
	QUADSPI_CR_ABORT         = 0x2        // Bit ABORT.
	QUADSPI_CR_EN_Pos        = 0x0        // Position of EN field.
	QUADSPI_CR_EN_Msk        = 0x1        // Bit mask of EN field.
	QUADSPI_CR_EN            = 0x1        // Bit EN.

	// DCR: device configuration register
	QUADSPI_DCR_FSIZE_Pos  = 0x10     // Position of FSIZE field.
	QUADSPI_DCR_FSIZE_Msk  = 0x1f0000 // Bit mask of FSIZE field.
	QUADSPI_DCR_CSHT_Pos   = 0x8      // Position of CSHT field.
	QUADSPI_DCR_CSHT_Msk   = 0x700    // Bit mask of CSHT field.
	QUADSPI_DCR_CKMODE_Pos = 0x0      // Position of CKMODE field.
	QUADSPI_DCR_CKMODE_Msk = 0x1      // Bit mask of CKMODE field.
	QUADSPI_DCR_CKMODE     = 0x1      // Bit CKMODE.

	// SR: status register
	QUADSPI_SR_FLEVEL_Pos = 0x8    // Position of FLEVEL field.
	QUADSPI_SR_FLEVEL_Msk = 0x7f00 // Bit mask of FLEVEL field.
	QUADSPI_SR_BUSY_Pos   = 0x5    // Position of BUSY field.
	QUADSPI_SR_BUSY_Msk   = 0x20   // Bit mask of BUSY field.
	QUADSPI_SR_BUSY       = 0x20   // Bit BUSY.
	QUADSPI_SR_TOF_Pos    = 0x4    // Position of TOF field.
	QUADSPI_SR_TOF_Msk    = 0x10   // Bit mask of TOF field.
	QUADSPI_SR_TOF        = 0x10   // Bit TOF.
	QUADSPI_SR_SMF_Pos    = 0x3    // Position of SMF field.
	QUADSPI_SR_SMF_Msk    = 0x8    // Bit mask of SMF field.
	QUADSPI_SR_SMF        = 0x8    // Bit SMF.
	QUADSPI_SR_FTF_Pos    = 0x2    // Position of FTF field.
	QUADSPI_SR_FTF_Msk    = 0x4    // Bit mask of FTF field.
	QUADSPI_SR_FTF        = 0x4    // Bit FTF.
	QUADSPI_SR_TCF_Pos    = 0x1    // Position of TCF field.
	QUADSPI_SR_TCF_Msk    = 0x2    // Bit mask of TCF field.
	QUADSPI_SR_TCF        = 0x2    // Bit TCF.
	QUADSPI_SR_TEF_Pos    = 0x0    // Position of TEF field.
	QUADSPI_SR_TEF_Msk    = 0x1    // Bit mask of TEF field.
	QUADSPI_SR_TEF        = 0x1    // Bit TEF.

	// FCR: flag clear register
	QUADSPI_FCR_CTOF_Pos = 0x4  // Position of CTOF field.
	QUADSPI_FCR_CTOF_Msk = 0x10 // Bit mask of CTOF field.
	QUADSPI_FCR_CTOF     = 0x10 // Bit CTOF.
	QUADSPI_FCR_CSMF_Pos = 0x3  // Position of CSMF field.
	QUADSPI_FCR_CSMF_Msk = 0x8  // Bit mask of CSMF field.
	QUADSPI_FCR_CSMF     = 0x8  // Bit CSMF.
	QUADSPI_FCR_CTCF_Pos = 0x1  // Position of CTCF field.
	QUADSPI_FCR_CTCF_Msk = 0x2  // Bit mask of CTCF field.
	QUADSPI_FCR_CTCF     = 0x2  // Bit CTCF.
	QUADSPI_FCR_CTEF_Pos = 0x0  // Position of CTEF field.
	QUADSPI_FCR_CTEF_Msk = 0x1  // Bit mask of CTEF field.
	QUADSPI_FCR_CTEF     = 0x1  // Bit CTEF.

	// DLR: data length register
	QUADSPI_DLR_DL_Pos = 0x0        // Position of DL field.
	QUADSPI_DLR_DL_Msk = 0xffffffff // Bit mask of DL field.

	// CCR: communication configuration           register
	QUADSPI_CCR_DDRM_Pos        = 0x1f       // Position of DDRM field.
	QUADSPI_CCR_DDRM_Msk        = 0x80000000 // Bit mask of DDRM field.
	QUADSPI_CCR_DDRM            = 0x80000000 // Bit DDRM.
	QUADSPI_CCR_DHHC_Pos        = 0x1e       // Position of DHHC field.
	QUADSPI_CCR_DHHC_Msk        = 0x40000000 // Bit mask of DHHC field.
	QUADSPI_CCR_DHHC            = 0x40000000 // Bit DHHC.
	QUADSPI_CCR_SIOO_Pos        = 0x1c       // Position of SIOO field.
	QUADSPI_CCR_SIOO_Msk        = 0x10000000 // Bit mask of SIOO field.
	QUADSPI_CCR_SIOO            = 0x10000000 // Bit SIOO.
	QUADSPI_CCR_FMODE_Pos       = 0x1a       // Position of FMODE field.
	QUADSPI_CCR_FMODE_Msk       = 0xc000000  // Bit mask of FMODE field.
	QUADSPI_CCR_DMODE_Pos       = 0x18       // Position of DMODE field.
	QUADSPI_CCR_DMODE_Msk       = 0x3000000  // Bit mask of DMODE field.
	QUADSPI_CCR_DCYC_Pos        = 0x12       // Position of DCYC field.
	QUADSPI_CCR_DCYC_Msk        = 0x7c0000   // Bit mask of DCYC field.
	QUADSPI_CCR_ABSIZE_Pos      = 0x10       // Position of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Msk      = 0x30000    // Bit mask of ABSIZE field.
	QUADSPI_CCR_ABMODE_Pos      = 0xe        // Position of ABMODE field.
	QUADSPI_CCR_ABMODE_Msk      = 0xc000     // Bit mask of ABMODE field.
	QUADSPI_CCR_ADSIZE_Pos      = 0xc        // Position of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Msk      = 0x3000     // Bit mask of ADSIZE field.
	QUADSPI_CCR_ADMODE_Pos      = 0xa        // Position of ADMODE field.
	QUADSPI_CCR_ADMODE_Msk      = 0xc00      // Bit mask of ADMODE field.
	QUADSPI_CCR_IMODE_Pos       = 0x8        // Position of IMODE field.
	QUADSPI_CCR_IMODE_Msk       = 0x300      // Bit mask of IMODE field.
	QUADSPI_CCR_INSTRUCTION_Pos = 0x0        // Position of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Msk = 0xff       // Bit mask of INSTRUCTION field.

	// AR: address register
	QUADSPI_AR_ADDRESS_Pos = 0x0        // Position of ADDRESS field.
	QUADSPI_AR_ADDRESS_Msk = 0xffffffff // Bit mask of ADDRESS field.

	// ABR: ABR
	QUADSPI_ABR_ALTERNATE_Pos = 0x0        // Position of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Msk = 0xffffffff // Bit mask of ALTERNATE field.

	// DR: data register
	QUADSPI_DR_DATA_Pos = 0x0        // Position of DATA field.
	QUADSPI_DR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// PSMKR: polling status mask register
	QUADSPI_PSMKR_MASK_Pos = 0x0        // Position of MASK field.
	QUADSPI_PSMKR_MASK_Msk = 0xffffffff // Bit mask of MASK field.

	// PSMAR: polling status match register
	QUADSPI_PSMAR_MATCH_Pos = 0x0        // Position of MATCH field.
	QUADSPI_PSMAR_MATCH_Msk = 0xffffffff // Bit mask of MATCH field.

	// PIR: polling interval register
	QUADSPI_PIR_INTERVAL_Pos = 0x0    // Position of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Msk = 0xffff // Bit mask of INTERVAL field.

	// LPTR: low-power timeout register
	QUADSPI_LPTR_TIMEOUT_Pos = 0x0    // Position of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Msk = 0xffff // Bit mask of TIMEOUT field.
)

// Bitfields for SPDIF_RX: Receiver Interface
const (
	// CR: Control register
	SPDIF_RX_CR_SPDIFEN_Pos = 0x0     // Position of SPDIFEN field.
	SPDIF_RX_CR_SPDIFEN_Msk = 0x3     // Bit mask of SPDIFEN field.
	SPDIF_RX_CR_RXDMAEN_Pos = 0x2     // Position of RXDMAEN field.
	SPDIF_RX_CR_RXDMAEN_Msk = 0x4     // Bit mask of RXDMAEN field.
	SPDIF_RX_CR_RXDMAEN     = 0x4     // Bit RXDMAEN.
	SPDIF_RX_CR_RXSTEO_Pos  = 0x3     // Position of RXSTEO field.
	SPDIF_RX_CR_RXSTEO_Msk  = 0x8     // Bit mask of RXSTEO field.
	SPDIF_RX_CR_RXSTEO      = 0x8     // Bit RXSTEO.
	SPDIF_RX_CR_DRFMT_Pos   = 0x4     // Position of DRFMT field.
	SPDIF_RX_CR_DRFMT_Msk   = 0x30    // Bit mask of DRFMT field.
	SPDIF_RX_CR_PMSK_Pos    = 0x6     // Position of PMSK field.
	SPDIF_RX_CR_PMSK_Msk    = 0x40    // Bit mask of PMSK field.
	SPDIF_RX_CR_PMSK        = 0x40    // Bit PMSK.
	SPDIF_RX_CR_VMSK_Pos    = 0x7     // Position of VMSK field.
	SPDIF_RX_CR_VMSK_Msk    = 0x80    // Bit mask of VMSK field.
	SPDIF_RX_CR_VMSK        = 0x80    // Bit VMSK.
	SPDIF_RX_CR_CUMSK_Pos   = 0x8     // Position of CUMSK field.
	SPDIF_RX_CR_CUMSK_Msk   = 0x100   // Bit mask of CUMSK field.
	SPDIF_RX_CR_CUMSK       = 0x100   // Bit CUMSK.
	SPDIF_RX_CR_PTMSK_Pos   = 0x9     // Position of PTMSK field.
	SPDIF_RX_CR_PTMSK_Msk   = 0x200   // Bit mask of PTMSK field.
	SPDIF_RX_CR_PTMSK       = 0x200   // Bit PTMSK.
	SPDIF_RX_CR_CBDMAEN_Pos = 0xa     // Position of CBDMAEN field.
	SPDIF_RX_CR_CBDMAEN_Msk = 0x400   // Bit mask of CBDMAEN field.
	SPDIF_RX_CR_CBDMAEN     = 0x400   // Bit CBDMAEN.
	SPDIF_RX_CR_CHSEL_Pos   = 0xb     // Position of CHSEL field.
	SPDIF_RX_CR_CHSEL_Msk   = 0x800   // Bit mask of CHSEL field.
	SPDIF_RX_CR_CHSEL       = 0x800   // Bit CHSEL.
	SPDIF_RX_CR_NBTR_Pos    = 0xc     // Position of NBTR field.
	SPDIF_RX_CR_NBTR_Msk    = 0x3000  // Bit mask of NBTR field.
	SPDIF_RX_CR_WFA_Pos     = 0xe     // Position of WFA field.
	SPDIF_RX_CR_WFA_Msk     = 0x4000  // Bit mask of WFA field.
	SPDIF_RX_CR_WFA         = 0x4000  // Bit WFA.
	SPDIF_RX_CR_INSEL_Pos   = 0x10    // Position of INSEL field.
	SPDIF_RX_CR_INSEL_Msk   = 0x70000 // Bit mask of INSEL field.

	// IMR: Interrupt mask register
	SPDIF_RX_IMR_RXNEIE_Pos  = 0x0  // Position of RXNEIE field.
	SPDIF_RX_IMR_RXNEIE_Msk  = 0x1  // Bit mask of RXNEIE field.
	SPDIF_RX_IMR_RXNEIE      = 0x1  // Bit RXNEIE.
	SPDIF_RX_IMR_CSRNEIE_Pos = 0x1  // Position of CSRNEIE field.
	SPDIF_RX_IMR_CSRNEIE_Msk = 0x2  // Bit mask of CSRNEIE field.
	SPDIF_RX_IMR_CSRNEIE     = 0x2  // Bit CSRNEIE.
	SPDIF_RX_IMR_PERRIE_Pos  = 0x2  // Position of PERRIE field.
	SPDIF_RX_IMR_PERRIE_Msk  = 0x4  // Bit mask of PERRIE field.
	SPDIF_RX_IMR_PERRIE      = 0x4  // Bit PERRIE.
	SPDIF_RX_IMR_OVRIE_Pos   = 0x3  // Position of OVRIE field.
	SPDIF_RX_IMR_OVRIE_Msk   = 0x8  // Bit mask of OVRIE field.
	SPDIF_RX_IMR_OVRIE       = 0x8  // Bit OVRIE.
	SPDIF_RX_IMR_SBLKIE_Pos  = 0x4  // Position of SBLKIE field.
	SPDIF_RX_IMR_SBLKIE_Msk  = 0x10 // Bit mask of SBLKIE field.
	SPDIF_RX_IMR_SBLKIE      = 0x10 // Bit SBLKIE.
	SPDIF_RX_IMR_SYNCDIE_Pos = 0x5  // Position of SYNCDIE field.
	SPDIF_RX_IMR_SYNCDIE_Msk = 0x20 // Bit mask of SYNCDIE field.
	SPDIF_RX_IMR_SYNCDIE     = 0x20 // Bit SYNCDIE.
	SPDIF_RX_IMR_IFEIE_Pos   = 0x6  // Position of IFEIE field.
	SPDIF_RX_IMR_IFEIE_Msk   = 0x40 // Bit mask of IFEIE field.
	SPDIF_RX_IMR_IFEIE       = 0x40 // Bit IFEIE.

	// SR: Status register
	SPDIF_RX_SR_RXNE_Pos   = 0x0        // Position of RXNE field.
	SPDIF_RX_SR_RXNE_Msk   = 0x1        // Bit mask of RXNE field.
	SPDIF_RX_SR_RXNE       = 0x1        // Bit RXNE.
	SPDIF_RX_SR_CSRNE_Pos  = 0x1        // Position of CSRNE field.
	SPDIF_RX_SR_CSRNE_Msk  = 0x2        // Bit mask of CSRNE field.
	SPDIF_RX_SR_CSRNE      = 0x2        // Bit CSRNE.
	SPDIF_RX_SR_PERR_Pos   = 0x2        // Position of PERR field.
	SPDIF_RX_SR_PERR_Msk   = 0x4        // Bit mask of PERR field.
	SPDIF_RX_SR_PERR       = 0x4        // Bit PERR.
	SPDIF_RX_SR_OVR_Pos    = 0x3        // Position of OVR field.
	SPDIF_RX_SR_OVR_Msk    = 0x8        // Bit mask of OVR field.
	SPDIF_RX_SR_OVR        = 0x8        // Bit OVR.
	SPDIF_RX_SR_SBD_Pos    = 0x4        // Position of SBD field.
	SPDIF_RX_SR_SBD_Msk    = 0x10       // Bit mask of SBD field.
	SPDIF_RX_SR_SBD        = 0x10       // Bit SBD.
	SPDIF_RX_SR_SYNCD_Pos  = 0x5        // Position of SYNCD field.
	SPDIF_RX_SR_SYNCD_Msk  = 0x20       // Bit mask of SYNCD field.
	SPDIF_RX_SR_SYNCD      = 0x20       // Bit SYNCD.
	SPDIF_RX_SR_FERR_Pos   = 0x6        // Position of FERR field.
	SPDIF_RX_SR_FERR_Msk   = 0x40       // Bit mask of FERR field.
	SPDIF_RX_SR_FERR       = 0x40       // Bit FERR.
	SPDIF_RX_SR_SERR_Pos   = 0x7        // Position of SERR field.
	SPDIF_RX_SR_SERR_Msk   = 0x80       // Bit mask of SERR field.
	SPDIF_RX_SR_SERR       = 0x80       // Bit SERR.
	SPDIF_RX_SR_TERR_Pos   = 0x8        // Position of TERR field.
	SPDIF_RX_SR_TERR_Msk   = 0x100      // Bit mask of TERR field.
	SPDIF_RX_SR_TERR       = 0x100      // Bit TERR.
	SPDIF_RX_SR_WIDTH5_Pos = 0x10       // Position of WIDTH5 field.
	SPDIF_RX_SR_WIDTH5_Msk = 0x7fff0000 // Bit mask of WIDTH5 field.

	// IFCR: Interrupt Flag Clear register
	SPDIF_RX_IFCR_PERRCF_Pos  = 0x2  // Position of PERRCF field.
	SPDIF_RX_IFCR_PERRCF_Msk  = 0x4  // Bit mask of PERRCF field.
	SPDIF_RX_IFCR_PERRCF      = 0x4  // Bit PERRCF.
	SPDIF_RX_IFCR_OVRCF_Pos   = 0x3  // Position of OVRCF field.
	SPDIF_RX_IFCR_OVRCF_Msk   = 0x8  // Bit mask of OVRCF field.
	SPDIF_RX_IFCR_OVRCF       = 0x8  // Bit OVRCF.
	SPDIF_RX_IFCR_SBDCF_Pos   = 0x4  // Position of SBDCF field.
	SPDIF_RX_IFCR_SBDCF_Msk   = 0x10 // Bit mask of SBDCF field.
	SPDIF_RX_IFCR_SBDCF       = 0x10 // Bit SBDCF.
	SPDIF_RX_IFCR_SYNCDCF_Pos = 0x5  // Position of SYNCDCF field.
	SPDIF_RX_IFCR_SYNCDCF_Msk = 0x20 // Bit mask of SYNCDCF field.
	SPDIF_RX_IFCR_SYNCDCF     = 0x20 // Bit SYNCDCF.

	// DR: Data input register
	SPDIF_RX_DR_DR_Pos = 0x0        // Position of DR field.
	SPDIF_RX_DR_DR_Msk = 0xffffff   // Bit mask of DR field.
	SPDIF_RX_DR_PE_Pos = 0x18       // Position of PE field.
	SPDIF_RX_DR_PE_Msk = 0x1000000  // Bit mask of PE field.
	SPDIF_RX_DR_PE     = 0x1000000  // Bit PE.
	SPDIF_RX_DR_V_Pos  = 0x19       // Position of V field.
	SPDIF_RX_DR_V_Msk  = 0x2000000  // Bit mask of V field.
	SPDIF_RX_DR_V      = 0x2000000  // Bit V.
	SPDIF_RX_DR_U_Pos  = 0x1a       // Position of U field.
	SPDIF_RX_DR_U_Msk  = 0x4000000  // Bit mask of U field.
	SPDIF_RX_DR_U      = 0x4000000  // Bit U.
	SPDIF_RX_DR_C_Pos  = 0x1b       // Position of C field.
	SPDIF_RX_DR_C_Msk  = 0x8000000  // Bit mask of C field.
	SPDIF_RX_DR_C      = 0x8000000  // Bit C.
	SPDIF_RX_DR_PT_Pos = 0x1c       // Position of PT field.
	SPDIF_RX_DR_PT_Msk = 0x30000000 // Bit mask of PT field.

	// CSR: Channel Status register
	SPDIF_RX_CSR_USR_Pos = 0x0       // Position of USR field.
	SPDIF_RX_CSR_USR_Msk = 0xffff    // Bit mask of USR field.
	SPDIF_RX_CSR_CS_Pos  = 0x10      // Position of CS field.
	SPDIF_RX_CSR_CS_Msk  = 0xff0000  // Bit mask of CS field.
	SPDIF_RX_CSR_SOB_Pos = 0x18      // Position of SOB field.
	SPDIF_RX_CSR_SOB_Msk = 0x1000000 // Bit mask of SOB field.
	SPDIF_RX_CSR_SOB     = 0x1000000 // Bit SOB.

	// DIR: Debug Information register
	SPDIF_RX_DIR_THI_Pos = 0x0        // Position of THI field.
	SPDIF_RX_DIR_THI_Msk = 0x1fff     // Bit mask of THI field.
	SPDIF_RX_DIR_TLO_Pos = 0x10       // Position of TLO field.
	SPDIF_RX_DIR_TLO_Msk = 0x1fff0000 // Bit mask of TLO field.
)

// Bitfields for SDMMC: SDMMC
const (
	// SDMMC_POWER: SDMMC power control register
	SDMMC_SDMMC_POWER_PWRCTRL_Pos   = 0x0  // Position of PWRCTRL field.
	SDMMC_SDMMC_POWER_PWRCTRL_Msk   = 0x3  // Bit mask of PWRCTRL field.
	SDMMC_SDMMC_POWER_VSWITCH_Pos   = 0x2  // Position of VSWITCH field.
	SDMMC_SDMMC_POWER_VSWITCH_Msk   = 0x4  // Bit mask of VSWITCH field.
	SDMMC_SDMMC_POWER_VSWITCH       = 0x4  // Bit VSWITCH.
	SDMMC_SDMMC_POWER_VSWITCHEN_Pos = 0x3  // Position of VSWITCHEN field.
	SDMMC_SDMMC_POWER_VSWITCHEN_Msk = 0x8  // Bit mask of VSWITCHEN field.
	SDMMC_SDMMC_POWER_VSWITCHEN     = 0x8  // Bit VSWITCHEN.
	SDMMC_SDMMC_POWER_DIRPOL_Pos    = 0x4  // Position of DIRPOL field.
	SDMMC_SDMMC_POWER_DIRPOL_Msk    = 0x10 // Bit mask of DIRPOL field.
	SDMMC_SDMMC_POWER_DIRPOL        = 0x10 // Bit DIRPOL.

	// SDMMC_CLKCR: The SDMMC_CLKCR register controls the           SDMMC_CK output clock, the SDMMC_RX_CLK receive clock,           and the bus width.
	SDMMC_SDMMC_CLKCR_CLKDIV_Pos   = 0x0      // Position of CLKDIV field.
	SDMMC_SDMMC_CLKCR_CLKDIV_Msk   = 0x3ff    // Bit mask of CLKDIV field.
	SDMMC_SDMMC_CLKCR_PWRSAV_Pos   = 0xc      // Position of PWRSAV field.
	SDMMC_SDMMC_CLKCR_PWRSAV_Msk   = 0x1000   // Bit mask of PWRSAV field.
	SDMMC_SDMMC_CLKCR_PWRSAV       = 0x1000   // Bit PWRSAV.
	SDMMC_SDMMC_CLKCR_WIDBUS_Pos   = 0xe      // Position of WIDBUS field.
	SDMMC_SDMMC_CLKCR_WIDBUS_Msk   = 0xc000   // Bit mask of WIDBUS field.
	SDMMC_SDMMC_CLKCR_NEGEDGE_Pos  = 0x10     // Position of NEGEDGE field.
	SDMMC_SDMMC_CLKCR_NEGEDGE_Msk  = 0x10000  // Bit mask of NEGEDGE field.
	SDMMC_SDMMC_CLKCR_NEGEDGE      = 0x10000  // Bit NEGEDGE.
	SDMMC_SDMMC_CLKCR_HWFC_EN_Pos  = 0x11     // Position of HWFC_EN field.
	SDMMC_SDMMC_CLKCR_HWFC_EN_Msk  = 0x20000  // Bit mask of HWFC_EN field.
	SDMMC_SDMMC_CLKCR_HWFC_EN      = 0x20000  // Bit HWFC_EN.
	SDMMC_SDMMC_CLKCR_DDR_Pos      = 0x12     // Position of DDR field.
	SDMMC_SDMMC_CLKCR_DDR_Msk      = 0x40000  // Bit mask of DDR field.
	SDMMC_SDMMC_CLKCR_DDR          = 0x40000  // Bit DDR.
	SDMMC_SDMMC_CLKCR_BUSSPEED_Pos = 0x13     // Position of BUSSPEED field.
	SDMMC_SDMMC_CLKCR_BUSSPEED_Msk = 0x80000  // Bit mask of BUSSPEED field.
	SDMMC_SDMMC_CLKCR_BUSSPEED     = 0x80000  // Bit BUSSPEED.
	SDMMC_SDMMC_CLKCR_SELCLKRX_Pos = 0x14     // Position of SELCLKRX field.
	SDMMC_SDMMC_CLKCR_SELCLKRX_Msk = 0x300000 // Bit mask of SELCLKRX field.

	// SDMMC_ARGR: The SDMMC_ARGR register contains a 32-bit           command argument, which is sent to a card as part of a           command message.
	SDMMC_SDMMC_ARGR_CMDARG_Pos = 0x0        // Position of CMDARG field.
	SDMMC_SDMMC_ARGR_CMDARG_Msk = 0xffffffff // Bit mask of CMDARG field.

	// SDMMC_CMDR: The SDMMC_CMDR register contains the command           index and command type bits. The command index is sent to           a card as part of a command message. The command type           bits control the command path state machine           (CPSM).
	SDMMC_SDMMC_CMDR_CMDINDEX_Pos   = 0x0     // Position of CMDINDEX field.
	SDMMC_SDMMC_CMDR_CMDINDEX_Msk   = 0x3f    // Bit mask of CMDINDEX field.
	SDMMC_SDMMC_CMDR_CMDTRANS_Pos   = 0x6     // Position of CMDTRANS field.
	SDMMC_SDMMC_CMDR_CMDTRANS_Msk   = 0x40    // Bit mask of CMDTRANS field.
	SDMMC_SDMMC_CMDR_CMDTRANS       = 0x40    // Bit CMDTRANS.
	SDMMC_SDMMC_CMDR_CMDSTOP_Pos    = 0x7     // Position of CMDSTOP field.
	SDMMC_SDMMC_CMDR_CMDSTOP_Msk    = 0x80    // Bit mask of CMDSTOP field.
	SDMMC_SDMMC_CMDR_CMDSTOP        = 0x80    // Bit CMDSTOP.
	SDMMC_SDMMC_CMDR_WAITRESP_Pos   = 0x8     // Position of WAITRESP field.
	SDMMC_SDMMC_CMDR_WAITRESP_Msk   = 0x300   // Bit mask of WAITRESP field.
	SDMMC_SDMMC_CMDR_WAITINT_Pos    = 0xa     // Position of WAITINT field.
	SDMMC_SDMMC_CMDR_WAITINT_Msk    = 0x400   // Bit mask of WAITINT field.
	SDMMC_SDMMC_CMDR_WAITINT        = 0x400   // Bit WAITINT.
	SDMMC_SDMMC_CMDR_WAITPEND_Pos   = 0xb     // Position of WAITPEND field.
	SDMMC_SDMMC_CMDR_WAITPEND_Msk   = 0x800   // Bit mask of WAITPEND field.
	SDMMC_SDMMC_CMDR_WAITPEND       = 0x800   // Bit WAITPEND.
	SDMMC_SDMMC_CMDR_CPSMEN_Pos     = 0xc     // Position of CPSMEN field.
	SDMMC_SDMMC_CMDR_CPSMEN_Msk     = 0x1000  // Bit mask of CPSMEN field.
	SDMMC_SDMMC_CMDR_CPSMEN         = 0x1000  // Bit CPSMEN.
	SDMMC_SDMMC_CMDR_DTHOLD_Pos     = 0xd     // Position of DTHOLD field.
	SDMMC_SDMMC_CMDR_DTHOLD_Msk     = 0x2000  // Bit mask of DTHOLD field.
	SDMMC_SDMMC_CMDR_DTHOLD         = 0x2000  // Bit DTHOLD.
	SDMMC_SDMMC_CMDR_BOOTMODE_Pos   = 0xe     // Position of BOOTMODE field.
	SDMMC_SDMMC_CMDR_BOOTMODE_Msk   = 0x4000  // Bit mask of BOOTMODE field.
	SDMMC_SDMMC_CMDR_BOOTMODE       = 0x4000  // Bit BOOTMODE.
	SDMMC_SDMMC_CMDR_BOOTEN_Pos     = 0xf     // Position of BOOTEN field.
	SDMMC_SDMMC_CMDR_BOOTEN_Msk     = 0x8000  // Bit mask of BOOTEN field.
	SDMMC_SDMMC_CMDR_BOOTEN         = 0x8000  // Bit BOOTEN.
	SDMMC_SDMMC_CMDR_CMDSUSPEND_Pos = 0x10    // Position of CMDSUSPEND field.
	SDMMC_SDMMC_CMDR_CMDSUSPEND_Msk = 0x10000 // Bit mask of CMDSUSPEND field.
	SDMMC_SDMMC_CMDR_CMDSUSPEND     = 0x10000 // Bit CMDSUSPEND.

	// SDMMC_RESP1R: The SDMMC_RESP1/2/3/4R registers contain the           status of a card, which is part of the received           response.
	SDMMC_SDMMC_RESP1R_CARDSTATUS1_Pos = 0x0        // Position of CARDSTATUS1 field.
	SDMMC_SDMMC_RESP1R_CARDSTATUS1_Msk = 0xffffffff // Bit mask of CARDSTATUS1 field.

	// SDMMC_RESP2R: The SDMMC_RESP1/2/3/4R registers contain the           status of a card, which is part of the received           response.
	SDMMC_SDMMC_RESP2R_CARDSTATUS2_Pos = 0x0        // Position of CARDSTATUS2 field.
	SDMMC_SDMMC_RESP2R_CARDSTATUS2_Msk = 0xffffffff // Bit mask of CARDSTATUS2 field.

	// SDMMC_RESP3R: The SDMMC_RESP1/2/3/4R registers contain the           status of a card, which is part of the received           response.
	SDMMC_SDMMC_RESP3R_CARDSTATUS3_Pos = 0x0        // Position of CARDSTATUS3 field.
	SDMMC_SDMMC_RESP3R_CARDSTATUS3_Msk = 0xffffffff // Bit mask of CARDSTATUS3 field.

	// SDMMC_RESP4R: The SDMMC_RESP1/2/3/4R registers contain the           status of a card, which is part of the received           response.
	SDMMC_SDMMC_RESP4R_CARDSTATUS4_Pos = 0x0        // Position of CARDSTATUS4 field.
	SDMMC_SDMMC_RESP4R_CARDSTATUS4_Msk = 0xffffffff // Bit mask of CARDSTATUS4 field.

	// SDMMC_DTIMER: The SDMMC_DTIMER register contains the data           timeout period, in card bus clock periods. A counter           loads the value from the SDMMC_DTIMER register, and           starts decrementing when the data path state machine           (DPSM) enters the Wait_R or Busy state. If the timer           reaches 0 while the DPSM is in either of these states,           the timeout status flag is set.
	SDMMC_SDMMC_DTIMER_DATATIME_Pos = 0x0        // Position of DATATIME field.
	SDMMC_SDMMC_DTIMER_DATATIME_Msk = 0xffffffff // Bit mask of DATATIME field.

	// SDMMC_DLENR: The SDMMC_DLENR register contains the number           of data bytes to be transferred. The value is loaded into           the data counter when data transfer starts.
	SDMMC_SDMMC_DLENR_DATALENGTH_Pos = 0x0       // Position of DATALENGTH field.
	SDMMC_SDMMC_DLENR_DATALENGTH_Msk = 0x1ffffff // Bit mask of DATALENGTH field.

	// SDMMC_DCTRL: The SDMMC_DCTRL register control the data           path state machine (DPSM).
	SDMMC_SDMMC_DCTRL_DTEN_Pos       = 0x0    // Position of DTEN field.
	SDMMC_SDMMC_DCTRL_DTEN_Msk       = 0x1    // Bit mask of DTEN field.
	SDMMC_SDMMC_DCTRL_DTEN           = 0x1    // Bit DTEN.
	SDMMC_SDMMC_DCTRL_DTDIR_Pos      = 0x1    // Position of DTDIR field.
	SDMMC_SDMMC_DCTRL_DTDIR_Msk      = 0x2    // Bit mask of DTDIR field.
	SDMMC_SDMMC_DCTRL_DTDIR          = 0x2    // Bit DTDIR.
	SDMMC_SDMMC_DCTRL_DTMODE_Pos     = 0x2    // Position of DTMODE field.
	SDMMC_SDMMC_DCTRL_DTMODE_Msk     = 0xc    // Bit mask of DTMODE field.
	SDMMC_SDMMC_DCTRL_DBLOCKSIZE_Pos = 0x4    // Position of DBLOCKSIZE field.
	SDMMC_SDMMC_DCTRL_DBLOCKSIZE_Msk = 0xf0   // Bit mask of DBLOCKSIZE field.
	SDMMC_SDMMC_DCTRL_RWSTART_Pos    = 0x8    // Position of RWSTART field.
	SDMMC_SDMMC_DCTRL_RWSTART_Msk    = 0x100  // Bit mask of RWSTART field.
	SDMMC_SDMMC_DCTRL_RWSTART        = 0x100  // Bit RWSTART.
	SDMMC_SDMMC_DCTRL_RWSTOP_Pos     = 0x9    // Position of RWSTOP field.
	SDMMC_SDMMC_DCTRL_RWSTOP_Msk     = 0x200  // Bit mask of RWSTOP field.
	SDMMC_SDMMC_DCTRL_RWSTOP         = 0x200  // Bit RWSTOP.
	SDMMC_SDMMC_DCTRL_RWMOD_Pos      = 0xa    // Position of RWMOD field.
	SDMMC_SDMMC_DCTRL_RWMOD_Msk      = 0x400  // Bit mask of RWMOD field.
	SDMMC_SDMMC_DCTRL_RWMOD          = 0x400  // Bit RWMOD.
	SDMMC_SDMMC_DCTRL_SDIOEN_Pos     = 0xb    // Position of SDIOEN field.
	SDMMC_SDMMC_DCTRL_SDIOEN_Msk     = 0x800  // Bit mask of SDIOEN field.
	SDMMC_SDMMC_DCTRL_SDIOEN         = 0x800  // Bit SDIOEN.
	SDMMC_SDMMC_DCTRL_BOOTACKEN_Pos  = 0xc    // Position of BOOTACKEN field.
	SDMMC_SDMMC_DCTRL_BOOTACKEN_Msk  = 0x1000 // Bit mask of BOOTACKEN field.
	SDMMC_SDMMC_DCTRL_BOOTACKEN      = 0x1000 // Bit BOOTACKEN.
	SDMMC_SDMMC_DCTRL_FIFORST_Pos    = 0xd    // Position of FIFORST field.
	SDMMC_SDMMC_DCTRL_FIFORST_Msk    = 0x2000 // Bit mask of FIFORST field.
	SDMMC_SDMMC_DCTRL_FIFORST        = 0x2000 // Bit FIFORST.

	// SDMMC_DCNTR: The SDMMC_DCNTR register loads the value           from the data length register (see SDMMC_DLENR) when the           DPSM moves from the Idle state to the Wait_R or Wait_S           state. As data is transferred, the counter decrements the           value until it reaches 0. The DPSM then moves to the Idle           state and when there has been no error, the data status           end flag (DATAEND) is set.
	SDMMC_SDMMC_DCNTR_DATACOUNT_Pos = 0x0       // Position of DATACOUNT field.
	SDMMC_SDMMC_DCNTR_DATACOUNT_Msk = 0x7ffffff // Bit mask of DATACOUNT field.

	// SDMMC_STAR: The SDMMC_STAR register is a read-only           register. It contains two types of flag:Static flags           (bits [29,21,11:0]): these bits remain asserted until           they are cleared by writing to the SDMMC interrupt Clear           register (see SDMMC_ICR)Dynamic flags (bits [20:12]):           these bits change state depending on the state of the           underlying logic (for example, FIFO full and empty flags           are asserted and de-asserted as data while written to the           FIFO)
	SDMMC_SDMMC_STAR_CCRCFAIL_Pos   = 0x0        // Position of CCRCFAIL field.
	SDMMC_SDMMC_STAR_CCRCFAIL_Msk   = 0x1        // Bit mask of CCRCFAIL field.
	SDMMC_SDMMC_STAR_CCRCFAIL       = 0x1        // Bit CCRCFAIL.
	SDMMC_SDMMC_STAR_DCRCFAIL_Pos   = 0x1        // Position of DCRCFAIL field.
	SDMMC_SDMMC_STAR_DCRCFAIL_Msk   = 0x2        // Bit mask of DCRCFAIL field.
	SDMMC_SDMMC_STAR_DCRCFAIL       = 0x2        // Bit DCRCFAIL.
	SDMMC_SDMMC_STAR_CTIMEOUT_Pos   = 0x2        // Position of CTIMEOUT field.
	SDMMC_SDMMC_STAR_CTIMEOUT_Msk   = 0x4        // Bit mask of CTIMEOUT field.
	SDMMC_SDMMC_STAR_CTIMEOUT       = 0x4        // Bit CTIMEOUT.
	SDMMC_SDMMC_STAR_DTIMEOUT_Pos   = 0x3        // Position of DTIMEOUT field.
	SDMMC_SDMMC_STAR_DTIMEOUT_Msk   = 0x8        // Bit mask of DTIMEOUT field.
	SDMMC_SDMMC_STAR_DTIMEOUT       = 0x8        // Bit DTIMEOUT.
	SDMMC_SDMMC_STAR_TXUNDERR_Pos   = 0x4        // Position of TXUNDERR field.
	SDMMC_SDMMC_STAR_TXUNDERR_Msk   = 0x10       // Bit mask of TXUNDERR field.
	SDMMC_SDMMC_STAR_TXUNDERR       = 0x10       // Bit TXUNDERR.
	SDMMC_SDMMC_STAR_RXOVERR_Pos    = 0x5        // Position of RXOVERR field.
	SDMMC_SDMMC_STAR_RXOVERR_Msk    = 0x20       // Bit mask of RXOVERR field.
	SDMMC_SDMMC_STAR_RXOVERR        = 0x20       // Bit RXOVERR.
	SDMMC_SDMMC_STAR_CMDREND_Pos    = 0x6        // Position of CMDREND field.
	SDMMC_SDMMC_STAR_CMDREND_Msk    = 0x40       // Bit mask of CMDREND field.
	SDMMC_SDMMC_STAR_CMDREND        = 0x40       // Bit CMDREND.
	SDMMC_SDMMC_STAR_CMDSENT_Pos    = 0x7        // Position of CMDSENT field.
	SDMMC_SDMMC_STAR_CMDSENT_Msk    = 0x80       // Bit mask of CMDSENT field.
	SDMMC_SDMMC_STAR_CMDSENT        = 0x80       // Bit CMDSENT.
	SDMMC_SDMMC_STAR_DATAEND_Pos    = 0x8        // Position of DATAEND field.
	SDMMC_SDMMC_STAR_DATAEND_Msk    = 0x100      // Bit mask of DATAEND field.
	SDMMC_SDMMC_STAR_DATAEND        = 0x100      // Bit DATAEND.
	SDMMC_SDMMC_STAR_DHOLD_Pos      = 0x9        // Position of DHOLD field.
	SDMMC_SDMMC_STAR_DHOLD_Msk      = 0x200      // Bit mask of DHOLD field.
	SDMMC_SDMMC_STAR_DHOLD          = 0x200      // Bit DHOLD.
	SDMMC_SDMMC_STAR_DBCKEND_Pos    = 0xa        // Position of DBCKEND field.
	SDMMC_SDMMC_STAR_DBCKEND_Msk    = 0x400      // Bit mask of DBCKEND field.
	SDMMC_SDMMC_STAR_DBCKEND        = 0x400      // Bit DBCKEND.
	SDMMC_SDMMC_STAR_DABORT_Pos     = 0xb        // Position of DABORT field.
	SDMMC_SDMMC_STAR_DABORT_Msk     = 0x800      // Bit mask of DABORT field.
	SDMMC_SDMMC_STAR_DABORT         = 0x800      // Bit DABORT.
	SDMMC_SDMMC_STAR_DPSMACT_Pos    = 0xc        // Position of DPSMACT field.
	SDMMC_SDMMC_STAR_DPSMACT_Msk    = 0x1000     // Bit mask of DPSMACT field.
	SDMMC_SDMMC_STAR_DPSMACT        = 0x1000     // Bit DPSMACT.
	SDMMC_SDMMC_STAR_CPSMACT_Pos    = 0xd        // Position of CPSMACT field.
	SDMMC_SDMMC_STAR_CPSMACT_Msk    = 0x2000     // Bit mask of CPSMACT field.
	SDMMC_SDMMC_STAR_CPSMACT        = 0x2000     // Bit CPSMACT.
	SDMMC_SDMMC_STAR_TXFIFOHE_Pos   = 0xe        // Position of TXFIFOHE field.
	SDMMC_SDMMC_STAR_TXFIFOHE_Msk   = 0x4000     // Bit mask of TXFIFOHE field.
	SDMMC_SDMMC_STAR_TXFIFOHE       = 0x4000     // Bit TXFIFOHE.
	SDMMC_SDMMC_STAR_RXFIFOHF_Pos   = 0xf        // Position of RXFIFOHF field.
	SDMMC_SDMMC_STAR_RXFIFOHF_Msk   = 0x8000     // Bit mask of RXFIFOHF field.
	SDMMC_SDMMC_STAR_RXFIFOHF       = 0x8000     // Bit RXFIFOHF.
	SDMMC_SDMMC_STAR_TXFIFOF_Pos    = 0x10       // Position of TXFIFOF field.
	SDMMC_SDMMC_STAR_TXFIFOF_Msk    = 0x10000    // Bit mask of TXFIFOF field.
	SDMMC_SDMMC_STAR_TXFIFOF        = 0x10000    // Bit TXFIFOF.
	SDMMC_SDMMC_STAR_RXFIFOF_Pos    = 0x11       // Position of RXFIFOF field.
	SDMMC_SDMMC_STAR_RXFIFOF_Msk    = 0x20000    // Bit mask of RXFIFOF field.
	SDMMC_SDMMC_STAR_RXFIFOF        = 0x20000    // Bit RXFIFOF.
	SDMMC_SDMMC_STAR_TXFIFOE_Pos    = 0x12       // Position of TXFIFOE field.
	SDMMC_SDMMC_STAR_TXFIFOE_Msk    = 0x40000    // Bit mask of TXFIFOE field.
	SDMMC_SDMMC_STAR_TXFIFOE        = 0x40000    // Bit TXFIFOE.
	SDMMC_SDMMC_STAR_RXFIFOE_Pos    = 0x13       // Position of RXFIFOE field.
	SDMMC_SDMMC_STAR_RXFIFOE_Msk    = 0x80000    // Bit mask of RXFIFOE field.
	SDMMC_SDMMC_STAR_RXFIFOE        = 0x80000    // Bit RXFIFOE.
	SDMMC_SDMMC_STAR_BUSYD0_Pos     = 0x14       // Position of BUSYD0 field.
	SDMMC_SDMMC_STAR_BUSYD0_Msk     = 0x100000   // Bit mask of BUSYD0 field.
	SDMMC_SDMMC_STAR_BUSYD0         = 0x100000   // Bit BUSYD0.
	SDMMC_SDMMC_STAR_BUSYD0END_Pos  = 0x15       // Position of BUSYD0END field.
	SDMMC_SDMMC_STAR_BUSYD0END_Msk  = 0x200000   // Bit mask of BUSYD0END field.
	SDMMC_SDMMC_STAR_BUSYD0END      = 0x200000   // Bit BUSYD0END.
	SDMMC_SDMMC_STAR_SDIOIT_Pos     = 0x16       // Position of SDIOIT field.
	SDMMC_SDMMC_STAR_SDIOIT_Msk     = 0x400000   // Bit mask of SDIOIT field.
	SDMMC_SDMMC_STAR_SDIOIT         = 0x400000   // Bit SDIOIT.
	SDMMC_SDMMC_STAR_ACKFAIL_Pos    = 0x17       // Position of ACKFAIL field.
	SDMMC_SDMMC_STAR_ACKFAIL_Msk    = 0x800000   // Bit mask of ACKFAIL field.
	SDMMC_SDMMC_STAR_ACKFAIL        = 0x800000   // Bit ACKFAIL.
	SDMMC_SDMMC_STAR_ACKTIMEOUT_Pos = 0x18       // Position of ACKTIMEOUT field.
	SDMMC_SDMMC_STAR_ACKTIMEOUT_Msk = 0x1000000  // Bit mask of ACKTIMEOUT field.
	SDMMC_SDMMC_STAR_ACKTIMEOUT     = 0x1000000  // Bit ACKTIMEOUT.
	SDMMC_SDMMC_STAR_VSWEND_Pos     = 0x19       // Position of VSWEND field.
	SDMMC_SDMMC_STAR_VSWEND_Msk     = 0x2000000  // Bit mask of VSWEND field.
	SDMMC_SDMMC_STAR_VSWEND         = 0x2000000  // Bit VSWEND.
	SDMMC_SDMMC_STAR_CKSTOP_Pos     = 0x1a       // Position of CKSTOP field.
	SDMMC_SDMMC_STAR_CKSTOP_Msk     = 0x4000000  // Bit mask of CKSTOP field.
	SDMMC_SDMMC_STAR_CKSTOP         = 0x4000000  // Bit CKSTOP.
	SDMMC_SDMMC_STAR_IDMATE_Pos     = 0x1b       // Position of IDMATE field.
	SDMMC_SDMMC_STAR_IDMATE_Msk     = 0x8000000  // Bit mask of IDMATE field.
	SDMMC_SDMMC_STAR_IDMATE         = 0x8000000  // Bit IDMATE.
	SDMMC_SDMMC_STAR_IDMABTC_Pos    = 0x1c       // Position of IDMABTC field.
	SDMMC_SDMMC_STAR_IDMABTC_Msk    = 0x10000000 // Bit mask of IDMABTC field.
	SDMMC_SDMMC_STAR_IDMABTC        = 0x10000000 // Bit IDMABTC.

	// SDMMC_ICR: The SDMMC_ICR register is a write-only           register. Writing a bit with 1 clears the corresponding           bit in the SDMMC_STAR status register.
	SDMMC_SDMMC_ICR_CCRCFAILC_Pos   = 0x0        // Position of CCRCFAILC field.
	SDMMC_SDMMC_ICR_CCRCFAILC_Msk   = 0x1        // Bit mask of CCRCFAILC field.
	SDMMC_SDMMC_ICR_CCRCFAILC       = 0x1        // Bit CCRCFAILC.
	SDMMC_SDMMC_ICR_DCRCFAILC_Pos   = 0x1        // Position of DCRCFAILC field.
	SDMMC_SDMMC_ICR_DCRCFAILC_Msk   = 0x2        // Bit mask of DCRCFAILC field.
	SDMMC_SDMMC_ICR_DCRCFAILC       = 0x2        // Bit DCRCFAILC.
	SDMMC_SDMMC_ICR_CTIMEOUTC_Pos   = 0x2        // Position of CTIMEOUTC field.
	SDMMC_SDMMC_ICR_CTIMEOUTC_Msk   = 0x4        // Bit mask of CTIMEOUTC field.
	SDMMC_SDMMC_ICR_CTIMEOUTC       = 0x4        // Bit CTIMEOUTC.
	SDMMC_SDMMC_ICR_DTIMEOUTC_Pos   = 0x3        // Position of DTIMEOUTC field.
	SDMMC_SDMMC_ICR_DTIMEOUTC_Msk   = 0x8        // Bit mask of DTIMEOUTC field.
	SDMMC_SDMMC_ICR_DTIMEOUTC       = 0x8        // Bit DTIMEOUTC.
	SDMMC_SDMMC_ICR_TXUNDERRC_Pos   = 0x4        // Position of TXUNDERRC field.
	SDMMC_SDMMC_ICR_TXUNDERRC_Msk   = 0x10       // Bit mask of TXUNDERRC field.
	SDMMC_SDMMC_ICR_TXUNDERRC       = 0x10       // Bit TXUNDERRC.
	SDMMC_SDMMC_ICR_RXOVERRC_Pos    = 0x5        // Position of RXOVERRC field.
	SDMMC_SDMMC_ICR_RXOVERRC_Msk    = 0x20       // Bit mask of RXOVERRC field.
	SDMMC_SDMMC_ICR_RXOVERRC        = 0x20       // Bit RXOVERRC.
	SDMMC_SDMMC_ICR_CMDRENDC_Pos    = 0x6        // Position of CMDRENDC field.
	SDMMC_SDMMC_ICR_CMDRENDC_Msk    = 0x40       // Bit mask of CMDRENDC field.
	SDMMC_SDMMC_ICR_CMDRENDC        = 0x40       // Bit CMDRENDC.
	SDMMC_SDMMC_ICR_CMDSENTC_Pos    = 0x7        // Position of CMDSENTC field.
	SDMMC_SDMMC_ICR_CMDSENTC_Msk    = 0x80       // Bit mask of CMDSENTC field.
	SDMMC_SDMMC_ICR_CMDSENTC        = 0x80       // Bit CMDSENTC.
	SDMMC_SDMMC_ICR_DATAENDC_Pos    = 0x8        // Position of DATAENDC field.
	SDMMC_SDMMC_ICR_DATAENDC_Msk    = 0x100      // Bit mask of DATAENDC field.
	SDMMC_SDMMC_ICR_DATAENDC        = 0x100      // Bit DATAENDC.
	SDMMC_SDMMC_ICR_DHOLDC_Pos      = 0x9        // Position of DHOLDC field.
	SDMMC_SDMMC_ICR_DHOLDC_Msk      = 0x200      // Bit mask of DHOLDC field.
	SDMMC_SDMMC_ICR_DHOLDC          = 0x200      // Bit DHOLDC.
	SDMMC_SDMMC_ICR_DBCKENDC_Pos    = 0xa        // Position of DBCKENDC field.
	SDMMC_SDMMC_ICR_DBCKENDC_Msk    = 0x400      // Bit mask of DBCKENDC field.
	SDMMC_SDMMC_ICR_DBCKENDC        = 0x400      // Bit DBCKENDC.
	SDMMC_SDMMC_ICR_DABORTC_Pos     = 0xb        // Position of DABORTC field.
	SDMMC_SDMMC_ICR_DABORTC_Msk     = 0x800      // Bit mask of DABORTC field.
	SDMMC_SDMMC_ICR_DABORTC         = 0x800      // Bit DABORTC.
	SDMMC_SDMMC_ICR_BUSYD0ENDC_Pos  = 0x15       // Position of BUSYD0ENDC field.
	SDMMC_SDMMC_ICR_BUSYD0ENDC_Msk  = 0x200000   // Bit mask of BUSYD0ENDC field.
	SDMMC_SDMMC_ICR_BUSYD0ENDC      = 0x200000   // Bit BUSYD0ENDC.
	SDMMC_SDMMC_ICR_SDIOITC_Pos     = 0x16       // Position of SDIOITC field.
	SDMMC_SDMMC_ICR_SDIOITC_Msk     = 0x400000   // Bit mask of SDIOITC field.
	SDMMC_SDMMC_ICR_SDIOITC         = 0x400000   // Bit SDIOITC.
	SDMMC_SDMMC_ICR_ACKFAILC_Pos    = 0x17       // Position of ACKFAILC field.
	SDMMC_SDMMC_ICR_ACKFAILC_Msk    = 0x800000   // Bit mask of ACKFAILC field.
	SDMMC_SDMMC_ICR_ACKFAILC        = 0x800000   // Bit ACKFAILC.
	SDMMC_SDMMC_ICR_ACKTIMEOUTC_Pos = 0x18       // Position of ACKTIMEOUTC field.
	SDMMC_SDMMC_ICR_ACKTIMEOUTC_Msk = 0x1000000  // Bit mask of ACKTIMEOUTC field.
	SDMMC_SDMMC_ICR_ACKTIMEOUTC     = 0x1000000  // Bit ACKTIMEOUTC.
	SDMMC_SDMMC_ICR_VSWENDC_Pos     = 0x19       // Position of VSWENDC field.
	SDMMC_SDMMC_ICR_VSWENDC_Msk     = 0x2000000  // Bit mask of VSWENDC field.
	SDMMC_SDMMC_ICR_VSWENDC         = 0x2000000  // Bit VSWENDC.
	SDMMC_SDMMC_ICR_CKSTOPC_Pos     = 0x1a       // Position of CKSTOPC field.
	SDMMC_SDMMC_ICR_CKSTOPC_Msk     = 0x4000000  // Bit mask of CKSTOPC field.
	SDMMC_SDMMC_ICR_CKSTOPC         = 0x4000000  // Bit CKSTOPC.
	SDMMC_SDMMC_ICR_IDMATEC_Pos     = 0x1b       // Position of IDMATEC field.
	SDMMC_SDMMC_ICR_IDMATEC_Msk     = 0x8000000  // Bit mask of IDMATEC field.
	SDMMC_SDMMC_ICR_IDMATEC         = 0x8000000  // Bit IDMATEC.
	SDMMC_SDMMC_ICR_IDMABTCC_Pos    = 0x1c       // Position of IDMABTCC field.
	SDMMC_SDMMC_ICR_IDMABTCC_Msk    = 0x10000000 // Bit mask of IDMABTCC field.
	SDMMC_SDMMC_ICR_IDMABTCC        = 0x10000000 // Bit IDMABTCC.

	// SDMMC_MASKR: The interrupt mask register determines which           status flags generate an interrupt request by setting the           corresponding bit to 1.
	SDMMC_SDMMC_MASKR_CCRCFAILIE_Pos   = 0x0        // Position of CCRCFAILIE field.
	SDMMC_SDMMC_MASKR_CCRCFAILIE_Msk   = 0x1        // Bit mask of CCRCFAILIE field.
	SDMMC_SDMMC_MASKR_CCRCFAILIE       = 0x1        // Bit CCRCFAILIE.
	SDMMC_SDMMC_MASKR_DCRCFAILIE_Pos   = 0x1        // Position of DCRCFAILIE field.
	SDMMC_SDMMC_MASKR_DCRCFAILIE_Msk   = 0x2        // Bit mask of DCRCFAILIE field.
	SDMMC_SDMMC_MASKR_DCRCFAILIE       = 0x2        // Bit DCRCFAILIE.
	SDMMC_SDMMC_MASKR_CTIMEOUTIE_Pos   = 0x2        // Position of CTIMEOUTIE field.
	SDMMC_SDMMC_MASKR_CTIMEOUTIE_Msk   = 0x4        // Bit mask of CTIMEOUTIE field.
	SDMMC_SDMMC_MASKR_CTIMEOUTIE       = 0x4        // Bit CTIMEOUTIE.
	SDMMC_SDMMC_MASKR_DTIMEOUTIE_Pos   = 0x3        // Position of DTIMEOUTIE field.
	SDMMC_SDMMC_MASKR_DTIMEOUTIE_Msk   = 0x8        // Bit mask of DTIMEOUTIE field.
	SDMMC_SDMMC_MASKR_DTIMEOUTIE       = 0x8        // Bit DTIMEOUTIE.
	SDMMC_SDMMC_MASKR_TXUNDERRIE_Pos   = 0x4        // Position of TXUNDERRIE field.
	SDMMC_SDMMC_MASKR_TXUNDERRIE_Msk   = 0x10       // Bit mask of TXUNDERRIE field.
	SDMMC_SDMMC_MASKR_TXUNDERRIE       = 0x10       // Bit TXUNDERRIE.
	SDMMC_SDMMC_MASKR_RXOVERRIE_Pos    = 0x5        // Position of RXOVERRIE field.
	SDMMC_SDMMC_MASKR_RXOVERRIE_Msk    = 0x20       // Bit mask of RXOVERRIE field.
	SDMMC_SDMMC_MASKR_RXOVERRIE        = 0x20       // Bit RXOVERRIE.
	SDMMC_SDMMC_MASKR_CMDRENDIE_Pos    = 0x6        // Position of CMDRENDIE field.
	SDMMC_SDMMC_MASKR_CMDRENDIE_Msk    = 0x40       // Bit mask of CMDRENDIE field.
	SDMMC_SDMMC_MASKR_CMDRENDIE        = 0x40       // Bit CMDRENDIE.
	SDMMC_SDMMC_MASKR_CMDSENTIE_Pos    = 0x7        // Position of CMDSENTIE field.
	SDMMC_SDMMC_MASKR_CMDSENTIE_Msk    = 0x80       // Bit mask of CMDSENTIE field.
	SDMMC_SDMMC_MASKR_CMDSENTIE        = 0x80       // Bit CMDSENTIE.
	SDMMC_SDMMC_MASKR_DATAENDIE_Pos    = 0x8        // Position of DATAENDIE field.
	SDMMC_SDMMC_MASKR_DATAENDIE_Msk    = 0x100      // Bit mask of DATAENDIE field.
	SDMMC_SDMMC_MASKR_DATAENDIE        = 0x100      // Bit DATAENDIE.
	SDMMC_SDMMC_MASKR_DHOLDIE_Pos      = 0x9        // Position of DHOLDIE field.
	SDMMC_SDMMC_MASKR_DHOLDIE_Msk      = 0x200      // Bit mask of DHOLDIE field.
	SDMMC_SDMMC_MASKR_DHOLDIE          = 0x200      // Bit DHOLDIE.
	SDMMC_SDMMC_MASKR_DBCKENDIE_Pos    = 0xa        // Position of DBCKENDIE field.
	SDMMC_SDMMC_MASKR_DBCKENDIE_Msk    = 0x400      // Bit mask of DBCKENDIE field.
	SDMMC_SDMMC_MASKR_DBCKENDIE        = 0x400      // Bit DBCKENDIE.
	SDMMC_SDMMC_MASKR_DABORTIE_Pos     = 0xb        // Position of DABORTIE field.
	SDMMC_SDMMC_MASKR_DABORTIE_Msk     = 0x800      // Bit mask of DABORTIE field.
	SDMMC_SDMMC_MASKR_DABORTIE         = 0x800      // Bit DABORTIE.
	SDMMC_SDMMC_MASKR_TXFIFOHEIE_Pos   = 0xe        // Position of TXFIFOHEIE field.
	SDMMC_SDMMC_MASKR_TXFIFOHEIE_Msk   = 0x4000     // Bit mask of TXFIFOHEIE field.
	SDMMC_SDMMC_MASKR_TXFIFOHEIE       = 0x4000     // Bit TXFIFOHEIE.
	SDMMC_SDMMC_MASKR_RXFIFOHFIE_Pos   = 0xf        // Position of RXFIFOHFIE field.
	SDMMC_SDMMC_MASKR_RXFIFOHFIE_Msk   = 0x8000     // Bit mask of RXFIFOHFIE field.
	SDMMC_SDMMC_MASKR_RXFIFOHFIE       = 0x8000     // Bit RXFIFOHFIE.
	SDMMC_SDMMC_MASKR_RXFIFOFIE_Pos    = 0x11       // Position of RXFIFOFIE field.
	SDMMC_SDMMC_MASKR_RXFIFOFIE_Msk    = 0x20000    // Bit mask of RXFIFOFIE field.
	SDMMC_SDMMC_MASKR_RXFIFOFIE        = 0x20000    // Bit RXFIFOFIE.
	SDMMC_SDMMC_MASKR_TXFIFOEIE_Pos    = 0x12       // Position of TXFIFOEIE field.
	SDMMC_SDMMC_MASKR_TXFIFOEIE_Msk    = 0x40000    // Bit mask of TXFIFOEIE field.
	SDMMC_SDMMC_MASKR_TXFIFOEIE        = 0x40000    // Bit TXFIFOEIE.
	SDMMC_SDMMC_MASKR_BUSYD0ENDIE_Pos  = 0x15       // Position of BUSYD0ENDIE field.
	SDMMC_SDMMC_MASKR_BUSYD0ENDIE_Msk  = 0x200000   // Bit mask of BUSYD0ENDIE field.
	SDMMC_SDMMC_MASKR_BUSYD0ENDIE      = 0x200000   // Bit BUSYD0ENDIE.
	SDMMC_SDMMC_MASKR_SDIOITIE_Pos     = 0x16       // Position of SDIOITIE field.
	SDMMC_SDMMC_MASKR_SDIOITIE_Msk     = 0x400000   // Bit mask of SDIOITIE field.
	SDMMC_SDMMC_MASKR_SDIOITIE         = 0x400000   // Bit SDIOITIE.
	SDMMC_SDMMC_MASKR_ACKFAILIE_Pos    = 0x17       // Position of ACKFAILIE field.
	SDMMC_SDMMC_MASKR_ACKFAILIE_Msk    = 0x800000   // Bit mask of ACKFAILIE field.
	SDMMC_SDMMC_MASKR_ACKFAILIE        = 0x800000   // Bit ACKFAILIE.
	SDMMC_SDMMC_MASKR_ACKTIMEOUTIE_Pos = 0x18       // Position of ACKTIMEOUTIE field.
	SDMMC_SDMMC_MASKR_ACKTIMEOUTIE_Msk = 0x1000000  // Bit mask of ACKTIMEOUTIE field.
	SDMMC_SDMMC_MASKR_ACKTIMEOUTIE     = 0x1000000  // Bit ACKTIMEOUTIE.
	SDMMC_SDMMC_MASKR_VSWENDIE_Pos     = 0x19       // Position of VSWENDIE field.
	SDMMC_SDMMC_MASKR_VSWENDIE_Msk     = 0x2000000  // Bit mask of VSWENDIE field.
	SDMMC_SDMMC_MASKR_VSWENDIE         = 0x2000000  // Bit VSWENDIE.
	SDMMC_SDMMC_MASKR_CKSTOPIE_Pos     = 0x1a       // Position of CKSTOPIE field.
	SDMMC_SDMMC_MASKR_CKSTOPIE_Msk     = 0x4000000  // Bit mask of CKSTOPIE field.
	SDMMC_SDMMC_MASKR_CKSTOPIE         = 0x4000000  // Bit CKSTOPIE.
	SDMMC_SDMMC_MASKR_IDMABTCIE_Pos    = 0x1c       // Position of IDMABTCIE field.
	SDMMC_SDMMC_MASKR_IDMABTCIE_Msk    = 0x10000000 // Bit mask of IDMABTCIE field.
	SDMMC_SDMMC_MASKR_IDMABTCIE        = 0x10000000 // Bit IDMABTCIE.

	// SDMMC_ACKTIMER: The SDMMC_ACKTIMER register contains the           acknowledgment timeout period, in SDMMC_CK bus clock           periods. A counter loads the value from the           SDMMC_ACKTIMER register, and starts decrementing when the           data path state machine (DPSM) enters the Wait_Ack state.           If the timer reaches 0 while the DPSM is in this states,           the acknowledgment timeout status flag is           set.
	SDMMC_SDMMC_ACKTIMER_ACKTIME_Pos = 0x0       // Position of ACKTIME field.
	SDMMC_SDMMC_ACKTIMER_ACKTIME_Msk = 0x1ffffff // Bit mask of ACKTIME field.

	// SDMMC_IDMACTRLR: The receive and transmit FIFOs can be read           or written as 32-bit wide registers. The FIFOs contain 32           entries on 32 sequential addresses. This allows the CPU           to use its load and store multiple operands to read           from/write to the FIFO.
	SDMMC_SDMMC_IDMACTRLR_IDMAEN_Pos    = 0x0 // Position of IDMAEN field.
	SDMMC_SDMMC_IDMACTRLR_IDMAEN_Msk    = 0x1 // Bit mask of IDMAEN field.
	SDMMC_SDMMC_IDMACTRLR_IDMAEN        = 0x1 // Bit IDMAEN.
	SDMMC_SDMMC_IDMACTRLR_IDMABMODE_Pos = 0x1 // Position of IDMABMODE field.
	SDMMC_SDMMC_IDMACTRLR_IDMABMODE_Msk = 0x2 // Bit mask of IDMABMODE field.
	SDMMC_SDMMC_IDMACTRLR_IDMABMODE     = 0x2 // Bit IDMABMODE.
	SDMMC_SDMMC_IDMACTRLR_IDMABACT_Pos  = 0x2 // Position of IDMABACT field.
	SDMMC_SDMMC_IDMACTRLR_IDMABACT_Msk  = 0x4 // Bit mask of IDMABACT field.
	SDMMC_SDMMC_IDMACTRLR_IDMABACT      = 0x4 // Bit IDMABACT.

	// SDMMC_IDMABSIZER: The SDMMC_IDMABSIZER register contains the           buffers size when in double buffer           configuration.
	SDMMC_SDMMC_IDMABSIZER_IDMABNDT_Pos = 0x5    // Position of IDMABNDT field.
	SDMMC_SDMMC_IDMABSIZER_IDMABNDT_Msk = 0x1fe0 // Bit mask of IDMABNDT field.

	// SDMMC_IDMABASE0R: The SDMMC_IDMABASE0R register contains the           memory buffer base address in single buffer configuration           and the buffer 0 base address in double buffer           configuration.
	SDMMC_SDMMC_IDMABASE0R_IDMABASE0_Pos = 0x0        // Position of IDMABASE0 field.
	SDMMC_SDMMC_IDMABASE0R_IDMABASE0_Msk = 0xffffffff // Bit mask of IDMABASE0 field.

	// SDMMC_IDMABASE1R: The SDMMC_IDMABASE1R register contains the           double buffer configuration second buffer memory base           address.
	SDMMC_SDMMC_IDMABASE1R_IDMABASE1_Pos = 0x0        // Position of IDMABASE1 field.
	SDMMC_SDMMC_IDMABASE1R_IDMABASE1_Msk = 0xffffffff // Bit mask of IDMABASE1 field.

	// SDMMC_RESPCMDR: The SDMMC_RESPCMDR register contains the           command index field of the last command response           received. If the command response transmission does not           contain the command index field (long or OCR response),           the RESPCMD field is unknown, although it must contain           111111b (the value of the reserved field from the           response).
	SDMMC_SDMMC_RESPCMDR_RESPCMD_Pos = 0x0  // Position of RESPCMD field.
	SDMMC_SDMMC_RESPCMDR_RESPCMD_Msk = 0x3f // Bit mask of RESPCMD field.

	// SDMMC_FIFOR: The receive and transmit FIFOs can be only           read or written as word (32-bit) wide registers. The           FIFOs contain 16 entries on sequential addresses. This           allows the CPU to use its load and store multiple           operands to read from/write to the FIFO.When accessing           SDMMC_FIFOR with half word or byte access an AHB bus           fault is generated.
	SDMMC_SDMMC_FIFOR_FIFODATA_Pos = 0x0        // Position of FIFODATA field.
	SDMMC_SDMMC_FIFOR_FIFODATA_Msk = 0xffffffff // Bit mask of FIFODATA field.

	// SDMMC_VER: SDMMC IP version register
	SDMMC_SDMMC_VER_MINREV_Pos = 0x0  // Position of MINREV field.
	SDMMC_SDMMC_VER_MINREV_Msk = 0xf  // Bit mask of MINREV field.
	SDMMC_SDMMC_VER_MAJREV_Pos = 0x4  // Position of MAJREV field.
	SDMMC_SDMMC_VER_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.

	// SDMMC_ID: SDMMC IP identification           register
	SDMMC_SDMMC_ID_IP_ID_Pos = 0x0        // Position of IP_ID field.
	SDMMC_SDMMC_ID_IP_ID_Msk = 0xffffffff // Bit mask of IP_ID field.
)

// Bitfields for HDMI_CEC: HDMI-CEC controller
const (
	// CEC_CR: CEC control register
	HDMI_CEC_CEC_CR_TXEOM_Pos = 0x2 // Position of TXEOM field.
	HDMI_CEC_CEC_CR_TXEOM_Msk = 0x4 // Bit mask of TXEOM field.
	HDMI_CEC_CEC_CR_TXEOM     = 0x4 // Bit TXEOM.
	HDMI_CEC_CEC_CR_TXSOM_Pos = 0x1 // Position of TXSOM field.
	HDMI_CEC_CEC_CR_TXSOM_Msk = 0x2 // Bit mask of TXSOM field.
	HDMI_CEC_CEC_CR_TXSOM     = 0x2 // Bit TXSOM.
	HDMI_CEC_CEC_CR_CECEN_Pos = 0x0 // Position of CECEN field.
	HDMI_CEC_CEC_CR_CECEN_Msk = 0x1 // Bit mask of CECEN field.
	HDMI_CEC_CEC_CR_CECEN     = 0x1 // Bit CECEN.

	// CEC_CFGR: CEC configuration register
	HDMI_CEC_CEC_CFGR_LSTN_Pos     = 0x1f       // Position of LSTN field.
	HDMI_CEC_CEC_CFGR_LSTN_Msk     = 0x80000000 // Bit mask of LSTN field.
	HDMI_CEC_CEC_CFGR_LSTN         = 0x80000000 // Bit LSTN.
	HDMI_CEC_CEC_CFGR_OAR_Pos      = 0x10       // Position of OAR field.
	HDMI_CEC_CEC_CFGR_OAR_Msk      = 0x7fff0000 // Bit mask of OAR field.
	HDMI_CEC_CEC_CFGR_SFTOP_Pos    = 0x8        // Position of SFTOP field.
	HDMI_CEC_CEC_CFGR_SFTOP_Msk    = 0x100      // Bit mask of SFTOP field.
	HDMI_CEC_CEC_CFGR_SFTOP        = 0x100      // Bit SFTOP.
	HDMI_CEC_CEC_CFGR_BRDNOGEN_Pos = 0x7        // Position of BRDNOGEN field.
	HDMI_CEC_CEC_CFGR_BRDNOGEN_Msk = 0x80       // Bit mask of BRDNOGEN field.
	HDMI_CEC_CEC_CFGR_BRDNOGEN     = 0x80       // Bit BRDNOGEN.
	HDMI_CEC_CEC_CFGR_LBPEGEN_Pos  = 0x6        // Position of LBPEGEN field.
	HDMI_CEC_CEC_CFGR_LBPEGEN_Msk  = 0x40       // Bit mask of LBPEGEN field.
	HDMI_CEC_CEC_CFGR_LBPEGEN      = 0x40       // Bit LBPEGEN.
	HDMI_CEC_CEC_CFGR_BREGEN_Pos   = 0x5        // Position of BREGEN field.
	HDMI_CEC_CEC_CFGR_BREGEN_Msk   = 0x20       // Bit mask of BREGEN field.
	HDMI_CEC_CEC_CFGR_BREGEN       = 0x20       // Bit BREGEN.
	HDMI_CEC_CEC_CFGR_BRESTP_Pos   = 0x4        // Position of BRESTP field.
	HDMI_CEC_CEC_CFGR_BRESTP_Msk   = 0x10       // Bit mask of BRESTP field.
	HDMI_CEC_CEC_CFGR_BRESTP       = 0x10       // Bit BRESTP.
	HDMI_CEC_CEC_CFGR_RXTOL_Pos    = 0x3        // Position of RXTOL field.
	HDMI_CEC_CEC_CFGR_RXTOL_Msk    = 0x8        // Bit mask of RXTOL field.
	HDMI_CEC_CEC_CFGR_RXTOL        = 0x8        // Bit RXTOL.
	HDMI_CEC_CEC_CFGR_SFT_Pos      = 0x0        // Position of SFT field.
	HDMI_CEC_CEC_CFGR_SFT_Msk      = 0x7        // Bit mask of SFT field.

	// CEC_TXDR: CEC Tx data register
	HDMI_CEC_CEC_TXDR_TXD_Pos = 0x0  // Position of TXD field.
	HDMI_CEC_CEC_TXDR_TXD_Msk = 0xff // Bit mask of TXD field.

	// CEC_RXDR: CEC Rx Data Register
	HDMI_CEC_CEC_RXDR_RXD_Pos = 0x0  // Position of RXD field.
	HDMI_CEC_CEC_RXDR_RXD_Msk = 0xff // Bit mask of RXD field.

	// CEC_ISR: CEC Interrupt and Status           Register
	HDMI_CEC_CEC_ISR_TXACKE_Pos = 0xc    // Position of TXACKE field.
	HDMI_CEC_CEC_ISR_TXACKE_Msk = 0x1000 // Bit mask of TXACKE field.
	HDMI_CEC_CEC_ISR_TXACKE     = 0x1000 // Bit TXACKE.
	HDMI_CEC_CEC_ISR_TXERR_Pos  = 0xb    // Position of TXERR field.
	HDMI_CEC_CEC_ISR_TXERR_Msk  = 0x800  // Bit mask of TXERR field.
	HDMI_CEC_CEC_ISR_TXERR      = 0x800  // Bit TXERR.
	HDMI_CEC_CEC_ISR_TXUDR_Pos  = 0xa    // Position of TXUDR field.
	HDMI_CEC_CEC_ISR_TXUDR_Msk  = 0x400  // Bit mask of TXUDR field.
	HDMI_CEC_CEC_ISR_TXUDR      = 0x400  // Bit TXUDR.
	HDMI_CEC_CEC_ISR_TXEND_Pos  = 0x9    // Position of TXEND field.
	HDMI_CEC_CEC_ISR_TXEND_Msk  = 0x200  // Bit mask of TXEND field.
	HDMI_CEC_CEC_ISR_TXEND      = 0x200  // Bit TXEND.
	HDMI_CEC_CEC_ISR_TXBR_Pos   = 0x8    // Position of TXBR field.
	HDMI_CEC_CEC_ISR_TXBR_Msk   = 0x100  // Bit mask of TXBR field.
	HDMI_CEC_CEC_ISR_TXBR       = 0x100  // Bit TXBR.
	HDMI_CEC_CEC_ISR_ARBLST_Pos = 0x7    // Position of ARBLST field.
	HDMI_CEC_CEC_ISR_ARBLST_Msk = 0x80   // Bit mask of ARBLST field.
	HDMI_CEC_CEC_ISR_ARBLST     = 0x80   // Bit ARBLST.
	HDMI_CEC_CEC_ISR_RXACKE_Pos = 0x6    // Position of RXACKE field.
	HDMI_CEC_CEC_ISR_RXACKE_Msk = 0x40   // Bit mask of RXACKE field.
	HDMI_CEC_CEC_ISR_RXACKE     = 0x40   // Bit RXACKE.
	HDMI_CEC_CEC_ISR_LBPE_Pos   = 0x5    // Position of LBPE field.
	HDMI_CEC_CEC_ISR_LBPE_Msk   = 0x20   // Bit mask of LBPE field.
	HDMI_CEC_CEC_ISR_LBPE       = 0x20   // Bit LBPE.
	HDMI_CEC_CEC_ISR_SBPE_Pos   = 0x4    // Position of SBPE field.
	HDMI_CEC_CEC_ISR_SBPE_Msk   = 0x10   // Bit mask of SBPE field.
	HDMI_CEC_CEC_ISR_SBPE       = 0x10   // Bit SBPE.
	HDMI_CEC_CEC_ISR_BRE_Pos    = 0x3    // Position of BRE field.
	HDMI_CEC_CEC_ISR_BRE_Msk    = 0x8    // Bit mask of BRE field.
	HDMI_CEC_CEC_ISR_BRE        = 0x8    // Bit BRE.
	HDMI_CEC_CEC_ISR_RXOVR_Pos  = 0x2    // Position of RXOVR field.
	HDMI_CEC_CEC_ISR_RXOVR_Msk  = 0x4    // Bit mask of RXOVR field.
	HDMI_CEC_CEC_ISR_RXOVR      = 0x4    // Bit RXOVR.
	HDMI_CEC_CEC_ISR_RXEND_Pos  = 0x1    // Position of RXEND field.
	HDMI_CEC_CEC_ISR_RXEND_Msk  = 0x2    // Bit mask of RXEND field.
	HDMI_CEC_CEC_ISR_RXEND      = 0x2    // Bit RXEND.
	HDMI_CEC_CEC_ISR_RXBR_Pos   = 0x0    // Position of RXBR field.
	HDMI_CEC_CEC_ISR_RXBR_Msk   = 0x1    // Bit mask of RXBR field.
	HDMI_CEC_CEC_ISR_RXBR       = 0x1    // Bit RXBR.

	// CEC_IER: CEC interrupt enable register
	HDMI_CEC_CEC_IER_TXACKIE_Pos  = 0xc    // Position of TXACKIE field.
	HDMI_CEC_CEC_IER_TXACKIE_Msk  = 0x1000 // Bit mask of TXACKIE field.
	HDMI_CEC_CEC_IER_TXACKIE      = 0x1000 // Bit TXACKIE.
	HDMI_CEC_CEC_IER_TXERRIE_Pos  = 0xb    // Position of TXERRIE field.
	HDMI_CEC_CEC_IER_TXERRIE_Msk  = 0x800  // Bit mask of TXERRIE field.
	HDMI_CEC_CEC_IER_TXERRIE      = 0x800  // Bit TXERRIE.
	HDMI_CEC_CEC_IER_TXUDRIE_Pos  = 0xa    // Position of TXUDRIE field.
	HDMI_CEC_CEC_IER_TXUDRIE_Msk  = 0x400  // Bit mask of TXUDRIE field.
	HDMI_CEC_CEC_IER_TXUDRIE      = 0x400  // Bit TXUDRIE.
	HDMI_CEC_CEC_IER_TXENDIE_Pos  = 0x9    // Position of TXENDIE field.
	HDMI_CEC_CEC_IER_TXENDIE_Msk  = 0x200  // Bit mask of TXENDIE field.
	HDMI_CEC_CEC_IER_TXENDIE      = 0x200  // Bit TXENDIE.
	HDMI_CEC_CEC_IER_TXBRIE_Pos   = 0x8    // Position of TXBRIE field.
	HDMI_CEC_CEC_IER_TXBRIE_Msk   = 0x100  // Bit mask of TXBRIE field.
	HDMI_CEC_CEC_IER_TXBRIE       = 0x100  // Bit TXBRIE.
	HDMI_CEC_CEC_IER_ARBLSTIE_Pos = 0x7    // Position of ARBLSTIE field.
	HDMI_CEC_CEC_IER_ARBLSTIE_Msk = 0x80   // Bit mask of ARBLSTIE field.
	HDMI_CEC_CEC_IER_ARBLSTIE     = 0x80   // Bit ARBLSTIE.
	HDMI_CEC_CEC_IER_RXACKIE_Pos  = 0x6    // Position of RXACKIE field.
	HDMI_CEC_CEC_IER_RXACKIE_Msk  = 0x40   // Bit mask of RXACKIE field.
	HDMI_CEC_CEC_IER_RXACKIE      = 0x40   // Bit RXACKIE.
	HDMI_CEC_CEC_IER_LBPEIE_Pos   = 0x5    // Position of LBPEIE field.
	HDMI_CEC_CEC_IER_LBPEIE_Msk   = 0x20   // Bit mask of LBPEIE field.
	HDMI_CEC_CEC_IER_LBPEIE       = 0x20   // Bit LBPEIE.
	HDMI_CEC_CEC_IER_SBPEIE_Pos   = 0x4    // Position of SBPEIE field.
	HDMI_CEC_CEC_IER_SBPEIE_Msk   = 0x10   // Bit mask of SBPEIE field.
	HDMI_CEC_CEC_IER_SBPEIE       = 0x10   // Bit SBPEIE.
	HDMI_CEC_CEC_IER_BREIE_Pos    = 0x3    // Position of BREIE field.
	HDMI_CEC_CEC_IER_BREIE_Msk    = 0x8    // Bit mask of BREIE field.
	HDMI_CEC_CEC_IER_BREIE        = 0x8    // Bit BREIE.
	HDMI_CEC_CEC_IER_RXOVRIE_Pos  = 0x2    // Position of RXOVRIE field.
	HDMI_CEC_CEC_IER_RXOVRIE_Msk  = 0x4    // Bit mask of RXOVRIE field.
	HDMI_CEC_CEC_IER_RXOVRIE      = 0x4    // Bit RXOVRIE.
	HDMI_CEC_CEC_IER_RXENDIE_Pos  = 0x1    // Position of RXENDIE field.
	HDMI_CEC_CEC_IER_RXENDIE_Msk  = 0x2    // Bit mask of RXENDIE field.
	HDMI_CEC_CEC_IER_RXENDIE      = 0x2    // Bit RXENDIE.
	HDMI_CEC_CEC_IER_RXBRIE_Pos   = 0x0    // Position of RXBRIE field.
	HDMI_CEC_CEC_IER_RXBRIE_Msk   = 0x1    // Bit mask of RXBRIE field.
	HDMI_CEC_CEC_IER_RXBRIE       = 0x1    // Bit RXBRIE.
)

// Bitfields for FPU: Floting point unit
const (
	// FPCCR: Floating-point context control           register
	FPU_FPCCR_LSPACT_Pos = 0x0        // Position of LSPACT field.
	FPU_FPCCR_LSPACT_Msk = 0x1        // Bit mask of LSPACT field.
	FPU_FPCCR_LSPACT     = 0x1        // Bit LSPACT.
	FPU_FPCCR_USER_Pos   = 0x1        // Position of USER field.
	FPU_FPCCR_USER_Msk   = 0x2        // Bit mask of USER field.
	FPU_FPCCR_USER       = 0x2        // Bit USER.
	FPU_FPCCR_THREAD_Pos = 0x3        // Position of THREAD field.
	FPU_FPCCR_THREAD_Msk = 0x8        // Bit mask of THREAD field.
	FPU_FPCCR_THREAD     = 0x8        // Bit THREAD.
	FPU_FPCCR_HFRDY_Pos  = 0x4        // Position of HFRDY field.
	FPU_FPCCR_HFRDY_Msk  = 0x10       // Bit mask of HFRDY field.
	FPU_FPCCR_HFRDY      = 0x10       // Bit HFRDY.
	FPU_FPCCR_MMRDY_Pos  = 0x5        // Position of MMRDY field.
	FPU_FPCCR_MMRDY_Msk  = 0x20       // Bit mask of MMRDY field.
	FPU_FPCCR_MMRDY      = 0x20       // Bit MMRDY.
	FPU_FPCCR_BFRDY_Pos  = 0x6        // Position of BFRDY field.
	FPU_FPCCR_BFRDY_Msk  = 0x40       // Bit mask of BFRDY field.
	FPU_FPCCR_BFRDY      = 0x40       // Bit BFRDY.
	FPU_FPCCR_MONRDY_Pos = 0x8        // Position of MONRDY field.
	FPU_FPCCR_MONRDY_Msk = 0x100      // Bit mask of MONRDY field.
	FPU_FPCCR_MONRDY     = 0x100      // Bit MONRDY.
	FPU_FPCCR_LSPEN_Pos  = 0x1e       // Position of LSPEN field.
	FPU_FPCCR_LSPEN_Msk  = 0x40000000 // Bit mask of LSPEN field.
	FPU_FPCCR_LSPEN      = 0x40000000 // Bit LSPEN.
	FPU_FPCCR_ASPEN_Pos  = 0x1f       // Position of ASPEN field.
	FPU_FPCCR_ASPEN_Msk  = 0x80000000 // Bit mask of ASPEN field.
	FPU_FPCCR_ASPEN      = 0x80000000 // Bit ASPEN.

	// FPCAR: Floating-point context address           register
	FPU_FPCAR_ADDRESS_Pos = 0x3        // Position of ADDRESS field.
	FPU_FPCAR_ADDRESS_Msk = 0xfffffff8 // Bit mask of ADDRESS field.

	// FPSCR: Floating-point status control           register
	FPU_FPSCR_IOC_Pos   = 0x0        // Position of IOC field.
	FPU_FPSCR_IOC_Msk   = 0x1        // Bit mask of IOC field.
	FPU_FPSCR_IOC       = 0x1        // Bit IOC.
	FPU_FPSCR_DZC_Pos   = 0x1        // Position of DZC field.
	FPU_FPSCR_DZC_Msk   = 0x2        // Bit mask of DZC field.
	FPU_FPSCR_DZC       = 0x2        // Bit DZC.
	FPU_FPSCR_OFC_Pos   = 0x2        // Position of OFC field.
	FPU_FPSCR_OFC_Msk   = 0x4        // Bit mask of OFC field.
	FPU_FPSCR_OFC       = 0x4        // Bit OFC.
	FPU_FPSCR_UFC_Pos   = 0x3        // Position of UFC field.
	FPU_FPSCR_UFC_Msk   = 0x8        // Bit mask of UFC field.
	FPU_FPSCR_UFC       = 0x8        // Bit UFC.
	FPU_FPSCR_IXC_Pos   = 0x4        // Position of IXC field.
	FPU_FPSCR_IXC_Msk   = 0x10       // Bit mask of IXC field.
	FPU_FPSCR_IXC       = 0x10       // Bit IXC.
	FPU_FPSCR_IDC_Pos   = 0x7        // Position of IDC field.
	FPU_FPSCR_IDC_Msk   = 0x80       // Bit mask of IDC field.
	FPU_FPSCR_IDC       = 0x80       // Bit IDC.
	FPU_FPSCR_RMode_Pos = 0x16       // Position of RMode field.
	FPU_FPSCR_RMode_Msk = 0xc00000   // Bit mask of RMode field.
	FPU_FPSCR_FZ_Pos    = 0x18       // Position of FZ field.
	FPU_FPSCR_FZ_Msk    = 0x1000000  // Bit mask of FZ field.
	FPU_FPSCR_FZ        = 0x1000000  // Bit FZ.
	FPU_FPSCR_DN_Pos    = 0x19       // Position of DN field.
	FPU_FPSCR_DN_Msk    = 0x2000000  // Bit mask of DN field.
	FPU_FPSCR_DN        = 0x2000000  // Bit DN.
	FPU_FPSCR_AHP_Pos   = 0x1a       // Position of AHP field.
	FPU_FPSCR_AHP_Msk   = 0x4000000  // Bit mask of AHP field.
	FPU_FPSCR_AHP       = 0x4000000  // Bit AHP.
	FPU_FPSCR_V_Pos     = 0x1c       // Position of V field.
	FPU_FPSCR_V_Msk     = 0x10000000 // Bit mask of V field.
	FPU_FPSCR_V         = 0x10000000 // Bit V.
	FPU_FPSCR_C_Pos     = 0x1d       // Position of C field.
	FPU_FPSCR_C_Msk     = 0x20000000 // Bit mask of C field.
	FPU_FPSCR_C         = 0x20000000 // Bit C.
	FPU_FPSCR_Z_Pos     = 0x1e       // Position of Z field.
	FPU_FPSCR_Z_Msk     = 0x40000000 // Bit mask of Z field.
	FPU_FPSCR_Z         = 0x40000000 // Bit Z.
	FPU_FPSCR_N_Pos     = 0x1f       // Position of N field.
	FPU_FPSCR_N_Msk     = 0x80000000 // Bit mask of N field.
	FPU_FPSCR_N         = 0x80000000 // Bit N.
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0      // Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1      // Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE     = 0x1      // Bit SEPARATE.
	MPU_MPU_TYPER_DREGION_Pos  = 0x8      // Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk  = 0xff00   // Bit mask of DREGION field.
	MPU_MPU_TYPER_IREGION_Pos  = 0x10     // Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk  = 0xff0000 // Bit mask of IREGION field.

	// MPU_CTRL: MPU control register
	MPU_MPU_CTRL_ENABLE_Pos     = 0x0 // Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk     = 0x1 // Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE         = 0x1 // Bit ENABLE.
	MPU_MPU_CTRL_HFNMIENA_Pos   = 0x1 // Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk   = 0x2 // Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA       = 0x2 // Bit HFNMIENA.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2 // Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4 // Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA     = 0x4 // Bit PRIVDEFENA.

	// MPU_RNR: MPU region number register
	MPU_MPU_RNR_REGION_Pos = 0x0  // Position of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff // Bit mask of REGION field.

	// MPU_RBAR: MPU region base address           register
	MPU_MPU_RBAR_REGION_Pos = 0x0        // Position of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf        // Bit mask of REGION field.
	MPU_MPU_RBAR_VALID_Pos  = 0x4        // Position of VALID field.
	MPU_MPU_RBAR_VALID_Msk  = 0x10       // Bit mask of VALID field.
	MPU_MPU_RBAR_VALID      = 0x10       // Bit VALID.
	MPU_MPU_RBAR_ADDR_Pos   = 0x5        // Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk   = 0xffffffe0 // Bit mask of ADDR field.

	// MPU_RASR: MPU region attribute and size           register
	MPU_MPU_RASR_ENABLE_Pos = 0x0        // Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1        // Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE     = 0x1        // Bit ENABLE.
	MPU_MPU_RASR_SIZE_Pos   = 0x1        // Position of SIZE field.
	MPU_MPU_RASR_SIZE_Msk   = 0x3e       // Bit mask of SIZE field.
	MPU_MPU_RASR_SRD_Pos    = 0x8        // Position of SRD field.
	MPU_MPU_RASR_SRD_Msk    = 0xff00     // Bit mask of SRD field.
	MPU_MPU_RASR_B_Pos      = 0x10       // Position of B field.
	MPU_MPU_RASR_B_Msk      = 0x10000    // Bit mask of B field.
	MPU_MPU_RASR_B          = 0x10000    // Bit B.
	MPU_MPU_RASR_C_Pos      = 0x11       // Position of C field.
	MPU_MPU_RASR_C_Msk      = 0x20000    // Bit mask of C field.
	MPU_MPU_RASR_C          = 0x20000    // Bit C.
	MPU_MPU_RASR_S_Pos      = 0x12       // Position of S field.
	MPU_MPU_RASR_S_Msk      = 0x40000    // Bit mask of S field.
	MPU_MPU_RASR_S          = 0x40000    // Bit S.
	MPU_MPU_RASR_TEX_Pos    = 0x13       // Position of TEX field.
	MPU_MPU_RASR_TEX_Msk    = 0x380000   // Bit mask of TEX field.
	MPU_MPU_RASR_AP_Pos     = 0x18       // Position of AP field.
	MPU_MPU_RASR_AP_Msk     = 0x7000000  // Bit mask of AP field.
	MPU_MPU_RASR_XN_Pos     = 0x1c       // Position of XN field.
	MPU_MPU_RASR_XN_Msk     = 0x10000000 // Bit mask of XN field.
	MPU_MPU_RASR_XN         = 0x10000000 // Bit XN.
)

// Bitfields for STK: SysTick timer
const (
	// CTRL: SysTick control and status           register
	STK_CTRL_ENABLE_Pos    = 0x0     // Position of ENABLE field.
	STK_CTRL_ENABLE_Msk    = 0x1     // Bit mask of ENABLE field.
	STK_CTRL_ENABLE        = 0x1     // Bit ENABLE.
	STK_CTRL_TICKINT_Pos   = 0x1     // Position of TICKINT field.
	STK_CTRL_TICKINT_Msk   = 0x2     // Bit mask of TICKINT field.
	STK_CTRL_TICKINT       = 0x2     // Bit TICKINT.
	STK_CTRL_CLKSOURCE_Pos = 0x2     // Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4     // Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE     = 0x4     // Bit CLKSOURCE.
	STK_CTRL_COUNTFLAG_Pos = 0x10    // Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000 // Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG     = 0x10000 // Bit COUNTFLAG.

	// LOAD: SysTick reload value register
	STK_LOAD_RELOAD_Pos = 0x0      // Position of RELOAD field.
	STK_LOAD_RELOAD_Msk = 0xffffff // Bit mask of RELOAD field.

	// VAL: SysTick current value register
	STK_VAL_CURRENT_Pos = 0x0      // Position of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff // Bit mask of CURRENT field.

	// CALIB: SysTick calibration value           register
	STK_CALIB_TENMS_Pos = 0x0        // Position of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff   // Bit mask of TENMS field.
	STK_CALIB_SKEW_Pos  = 0x1e       // Position of SKEW field.
	STK_CALIB_SKEW_Msk  = 0x40000000 // Bit mask of SKEW field.
	STK_CALIB_SKEW      = 0x40000000 // Bit SKEW.
	STK_CALIB_NOREF_Pos = 0x1f       // Position of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000 // Bit mask of NOREF field.
	STK_CALIB_NOREF     = 0x80000000 // Bit NOREF.
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	SCB_CPUID_Revision_Pos    = 0x0        // Position of Revision field.
	SCB_CPUID_Revision_Msk    = 0xf        // Bit mask of Revision field.
	SCB_CPUID_PartNo_Pos      = 0x4        // Position of PartNo field.
	SCB_CPUID_PartNo_Msk      = 0xfff0     // Bit mask of PartNo field.
	SCB_CPUID_Constant_Pos    = 0x10       // Position of Constant field.
	SCB_CPUID_Constant_Msk    = 0xf0000    // Bit mask of Constant field.
	SCB_CPUID_Variant_Pos     = 0x14       // Position of Variant field.
	SCB_CPUID_Variant_Msk     = 0xf00000   // Bit mask of Variant field.
	SCB_CPUID_Implementer_Pos = 0x18       // Position of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000 // Bit mask of Implementer field.

	// ICSR: Interrupt control and state           register
	SCB_ICSR_VECTACTIVE_Pos  = 0x0        // Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk  = 0x1ff      // Bit mask of VECTACTIVE field.
	SCB_ICSR_RETTOBASE_Pos   = 0xb        // Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk   = 0x800      // Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE       = 0x800      // Bit RETTOBASE.
	SCB_ICSR_VECTPENDING_Pos = 0xc        // Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000    // Bit mask of VECTPENDING field.
	SCB_ICSR_ISRPENDING_Pos  = 0x16       // Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk  = 0x400000   // Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING      = 0x400000   // Bit ISRPENDING.
	SCB_ICSR_PENDSTCLR_Pos   = 0x19       // Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk   = 0x2000000  // Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR       = 0x2000000  // Bit PENDSTCLR.
	SCB_ICSR_PENDSTSET_Pos   = 0x1a       // Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk   = 0x4000000  // Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET       = 0x4000000  // Bit PENDSTSET.
	SCB_ICSR_PENDSVCLR_Pos   = 0x1b       // Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk   = 0x8000000  // Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR       = 0x8000000  // Bit PENDSVCLR.
	SCB_ICSR_PENDSVSET_Pos   = 0x1c       // Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk   = 0x10000000 // Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET       = 0x10000000 // Bit PENDSVSET.
	SCB_ICSR_NMIPENDSET_Pos  = 0x1f       // Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk  = 0x80000000 // Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET      = 0x80000000 // Bit NMIPENDSET.

	// VTOR: Vector table offset register
	SCB_VTOR_TBLOFF_Pos = 0x9        // Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0x3ffffe00 // Bit mask of TBLOFF field.

	// AIRCR: Application interrupt and reset control           register
	SCB_AIRCR_VECTRESET_Pos     = 0x0        // Position of VECTRESET field.
	SCB_AIRCR_VECTRESET_Msk     = 0x1        // Bit mask of VECTRESET field.
	SCB_AIRCR_VECTRESET         = 0x1        // Bit VECTRESET.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1        // Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2        // Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE     = 0x2        // Bit VECTCLRACTIVE.
	SCB_AIRCR_SYSRESETREQ_Pos   = 0x2        // Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk   = 0x4        // Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ       = 0x4        // Bit SYSRESETREQ.
	SCB_AIRCR_PRIGROUP_Pos      = 0x8        // Position of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Msk      = 0x700      // Bit mask of PRIGROUP field.
	SCB_AIRCR_ENDIANESS_Pos     = 0xf        // Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk     = 0x8000     // Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS         = 0x8000     // Bit ENDIANESS.
	SCB_AIRCR_VECTKEYSTAT_Pos   = 0x10       // Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk   = 0xffff0000 // Bit mask of VECTKEYSTAT field.

	// SCR: System control register
	SCB_SCR_SLEEPONEXIT_Pos = 0x1  // Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2  // Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT     = 0x2  // Bit SLEEPONEXIT.
	SCB_SCR_SLEEPDEEP_Pos   = 0x2  // Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk   = 0x4  // Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP       = 0x4  // Bit SLEEPDEEP.
	SCB_SCR_SEVEONPEND_Pos  = 0x4  // Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk  = 0x10 // Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND      = 0x10 // Bit SEVEONPEND.

	// CCR: Configuration and control           register
	SCB_CCR_NONBASETHRDENA_Pos = 0x0   // Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1   // Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA     = 0x1   // Bit NONBASETHRDENA.
	SCB_CCR_USERSETMPEND_Pos   = 0x1   // Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk   = 0x2   // Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND       = 0x2   // Bit USERSETMPEND.
	SCB_CCR_UNALIGN__TRP_Pos   = 0x3   // Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk   = 0x8   // Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP       = 0x8   // Bit UNALIGN__TRP.
	SCB_CCR_DIV_0_TRP_Pos      = 0x4   // Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk      = 0x10  // Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP          = 0x10  // Bit DIV_0_TRP.
	SCB_CCR_BFHFNMIGN_Pos      = 0x8   // Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk      = 0x100 // Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN          = 0x100 // Bit BFHFNMIGN.
	SCB_CCR_STKALIGN_Pos       = 0x9   // Position of STKALIGN field.
	SCB_CCR_STKALIGN_Msk       = 0x200 // Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN           = 0x200 // Bit STKALIGN.

	// SHPR1: System handler priority           registers
	SCB_SHPR1_PRI_4_Pos = 0x0      // Position of PRI_4 field.
	SCB_SHPR1_PRI_4_Msk = 0xff     // Bit mask of PRI_4 field.
	SCB_SHPR1_PRI_5_Pos = 0x8      // Position of PRI_5 field.
	SCB_SHPR1_PRI_5_Msk = 0xff00   // Bit mask of PRI_5 field.
	SCB_SHPR1_PRI_6_Pos = 0x10     // Position of PRI_6 field.
	SCB_SHPR1_PRI_6_Msk = 0xff0000 // Bit mask of PRI_6 field.

	// SHPR2: System handler priority           registers
	SCB_SHPR2_PRI_11_Pos = 0x18       // Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000 // Bit mask of PRI_11 field.

	// SHPR3: System handler priority           registers
	SCB_SHPR3_PRI_14_Pos = 0x10       // Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000   // Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_15_Pos = 0x18       // Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000 // Bit mask of PRI_15 field.

	// SHCRS: System handler control and state           register
	SCB_SHCRS_MEMFAULTACT_Pos    = 0x0     // Position of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Msk    = 0x1     // Bit mask of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT        = 0x1     // Bit MEMFAULTACT.
	SCB_SHCRS_BUSFAULTACT_Pos    = 0x1     // Position of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Msk    = 0x2     // Bit mask of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT        = 0x2     // Bit BUSFAULTACT.
	SCB_SHCRS_USGFAULTACT_Pos    = 0x3     // Position of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Msk    = 0x8     // Bit mask of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT        = 0x8     // Bit USGFAULTACT.
	SCB_SHCRS_SVCALLACT_Pos      = 0x7     // Position of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Msk      = 0x80    // Bit mask of SVCALLACT field.
	SCB_SHCRS_SVCALLACT          = 0x80    // Bit SVCALLACT.
	SCB_SHCRS_MONITORACT_Pos     = 0x8     // Position of MONITORACT field.
	SCB_SHCRS_MONITORACT_Msk     = 0x100   // Bit mask of MONITORACT field.
	SCB_SHCRS_MONITORACT         = 0x100   // Bit MONITORACT.
	SCB_SHCRS_PENDSVACT_Pos      = 0xa     // Position of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Msk      = 0x400   // Bit mask of PENDSVACT field.
	SCB_SHCRS_PENDSVACT          = 0x400   // Bit PENDSVACT.
	SCB_SHCRS_SYSTICKACT_Pos     = 0xb     // Position of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Msk     = 0x800   // Bit mask of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT         = 0x800   // Bit SYSTICKACT.
	SCB_SHCRS_USGFAULTPENDED_Pos = 0xc     // Position of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Msk = 0x1000  // Bit mask of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED     = 0x1000  // Bit USGFAULTPENDED.
	SCB_SHCRS_MEMFAULTPENDED_Pos = 0xd     // Position of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Msk = 0x2000  // Bit mask of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED     = 0x2000  // Bit MEMFAULTPENDED.
	SCB_SHCRS_BUSFAULTPENDED_Pos = 0xe     // Position of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Msk = 0x4000  // Bit mask of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED     = 0x4000  // Bit BUSFAULTPENDED.
	SCB_SHCRS_SVCALLPENDED_Pos   = 0xf     // Position of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Msk   = 0x8000  // Bit mask of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED       = 0x8000  // Bit SVCALLPENDED.
	SCB_SHCRS_MEMFAULTENA_Pos    = 0x10    // Position of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Msk    = 0x10000 // Bit mask of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA        = 0x10000 // Bit MEMFAULTENA.
	SCB_SHCRS_BUSFAULTENA_Pos    = 0x11    // Position of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Msk    = 0x20000 // Bit mask of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA        = 0x20000 // Bit BUSFAULTENA.
	SCB_SHCRS_USGFAULTENA_Pos    = 0x12    // Position of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Msk    = 0x40000 // Bit mask of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA        = 0x40000 // Bit USGFAULTENA.

	// CFSR_UFSR_BFSR_MMFSR: Configurable fault status           register
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Pos    = 0x1       // Position of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Msk    = 0x2       // Bit mask of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL        = 0x2       // Bit IACCVIOL.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Pos   = 0x3       // Position of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Msk   = 0x8       // Bit mask of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR       = 0x8       // Bit MUNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Pos     = 0x4       // Position of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Msk     = 0x10      // Bit mask of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR         = 0x10      // Bit MSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Pos     = 0x5       // Position of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Msk     = 0x20      // Bit mask of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR         = 0x20      // Bit MLSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Pos   = 0x7       // Position of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Msk   = 0x80      // Bit mask of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID       = 0x80      // Bit MMARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Pos     = 0x8       // Position of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Msk     = 0x100     // Bit mask of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR         = 0x100     // Bit IBUSERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Pos   = 0x9       // Position of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Msk   = 0x200     // Bit mask of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR       = 0x200     // Bit PRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Pos = 0xa       // Position of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Msk = 0x400     // Bit mask of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR     = 0x400     // Bit IMPRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Pos    = 0xb       // Position of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Msk    = 0x800     // Bit mask of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR        = 0x800     // Bit UNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Pos      = 0xc       // Position of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Msk      = 0x1000    // Bit mask of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR          = 0x1000    // Bit STKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Pos      = 0xd       // Position of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Msk      = 0x2000    // Bit mask of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR          = 0x2000    // Bit LSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Pos   = 0xf       // Position of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Msk   = 0x8000    // Bit mask of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID       = 0x8000    // Bit BFARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Pos  = 0x10      // Position of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Msk  = 0x10000   // Bit mask of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR      = 0x10000   // Bit UNDEFINSTR.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Pos    = 0x11      // Position of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Msk    = 0x20000   // Bit mask of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE        = 0x20000   // Bit INVSTATE.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Pos       = 0x12      // Position of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Msk       = 0x40000   // Bit mask of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC           = 0x40000   // Bit INVPC.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Pos        = 0x13      // Position of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Msk        = 0x80000   // Bit mask of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP            = 0x80000   // Bit NOCP.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Pos   = 0x18      // Position of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Msk   = 0x1000000 // Bit mask of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED       = 0x1000000 // Bit UNALIGNED.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Pos   = 0x19      // Position of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Msk   = 0x2000000 // Bit mask of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO       = 0x2000000 // Bit DIVBYZERO.

	// HFSR: Hard fault status register
	SCB_HFSR_VECTTBL_Pos  = 0x1        // Position of VECTTBL field.
	SCB_HFSR_VECTTBL_Msk  = 0x2        // Bit mask of VECTTBL field.
	SCB_HFSR_VECTTBL      = 0x2        // Bit VECTTBL.
	SCB_HFSR_FORCED_Pos   = 0x1e       // Position of FORCED field.
	SCB_HFSR_FORCED_Msk   = 0x40000000 // Bit mask of FORCED field.
	SCB_HFSR_FORCED       = 0x40000000 // Bit FORCED.
	SCB_HFSR_DEBUG_VT_Pos = 0x1f       // Position of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Msk = 0x80000000 // Bit mask of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT     = 0x80000000 // Bit DEBUG_VT.

	// MMFAR: Memory management fault address           register
	SCB_MMFAR_MMFAR_Pos = 0x0        // Position of MMFAR field.
	SCB_MMFAR_MMFAR_Msk = 0xffffffff // Bit mask of MMFAR field.

	// BFAR: Bus fault address register
	SCB_BFAR_BFAR_Pos = 0x0        // Position of BFAR field.
	SCB_BFAR_BFAR_Msk = 0xffffffff // Bit mask of BFAR field.

	// AFSR: Auxiliary fault status           register
	SCB_AFSR_IMPDEF_Pos = 0x0        // Position of IMPDEF field.
	SCB_AFSR_IMPDEF_Msk = 0xffffffff // Bit mask of IMPDEF field.
)
