/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureDescriptor;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.FirDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmKotlinMangler;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmVisibilityConverter;
import org.jetbrains.kotlin.fir.builder.RawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessor;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmManglerDesc;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0007J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u0007R\u001a\u0010\n\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/FirAnalyzerFacade;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Ljava/util/List;)V", "collectedDiagnostics", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "firFiles", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getKtFiles", "()Ljava/util/List;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildRawFir", "", "convertToIr", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "generateFacades", "", "runCheckers", "runResolution", "entrypoint"})
public final class FirAnalyzerFacade {
    private List<? extends FirFile> firFiles;
    private ScopeSession scopeSession;
    private List<? extends FirDiagnostic<?>> collectedDiagnostics;
    private final FirSession session;
    private final LanguageVersionSettings languageVersionSettings;
    private final List<KtFile> ktFiles;

    /*
     * WARNING - void declaration
     */
    private final void buildRawFir() {
        Collection<FirFile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.firFiles != null) {
            return;
        }
        FirProvider firProvider = MainSessionComponentsKt.getFirProvider(this.session);
        if (firProvider == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl");
        }
        FirProviderImpl firProvider2 = (FirProviderImpl)firProvider;
        RawFirBuilder builder = new RawFirBuilder(this.session, firProvider2.getKotlinScopeProvider(), false);
        Iterable iterable = this.ktFiles;
        FirAnalyzerFacade firAnalyzerFacade = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtFile ktFile = (KtFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirFile firFile = builder.buildFirFile((KtFile)it);
            firProvider2.recordFile(firFile);
            FirFile firFile2 = firFile;
            collection.add(firFile2);
        }
        collection = (List)destination$iv$iv;
        firAnalyzerFacade.firFiles = collection;
    }

    @NotNull
    public final List<FirFile> runResolution() {
        if (this.firFiles == null) {
            this.buildRawFir();
        }
        if (this.scopeSession != null) {
            List<FirFile> list2 = this.firFiles;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        FirTotalResolveProcessor resolveProcessor = new FirTotalResolveProcessor(this.session);
        List<? extends FirFile> list3 = this.firFiles;
        Intrinsics.checkNotNull(list3);
        resolveProcessor.process(list3);
        this.scopeSession = resolveProcessor.getScopeSession();
        List<FirFile> list4 = this.firFiles;
        Intrinsics.checkNotNull(list4);
        return list4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirDiagnostic<?>> runCheckers() {
        if (this.scopeSession == null) {
            this.runResolution();
        }
        if (this.collectedDiagnostics != null) {
            List<FirDiagnostic<?>> list2 = this.collectedDiagnostics;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        AbstractDiagnosticCollector collector2 = FirDiagnosticsCollector.INSTANCE.create(this.session);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        List list3 = CollectionsKt.createListBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        List list4 = list3;
        FirAnalyzerFacade firAnalyzerFacade = this;
        boolean bl5 = false;
        List<? extends FirFile> list5 = this.firFiles;
        Intrinsics.checkNotNull(list5);
        for (FirFile firFile : list5) {
            void $this$buildList;
            CollectionsKt.addAll((Collection)$this$buildList, collector2.collectDiagnostics(firFile));
        }
        Unit unit = Unit.INSTANCE;
        firAnalyzerFacade.collectedDiagnostics = CollectionsKt.build(list3);
        List<FirDiagnostic<?>> list6 = this.collectedDiagnostics;
        Intrinsics.checkNotNull(list6);
        return list6;
    }

    @NotNull
    public final Fir2IrResult convertToIr(boolean generateFacades) {
        if (this.scopeSession == null) {
            this.runResolution();
        }
        IdSignatureDescriptor signaturer = new IdSignatureDescriptor(new JvmManglerDesc(null, 1, null));
        ScopeSession scopeSession = this.scopeSession;
        Intrinsics.checkNotNull(scopeSession);
        List<? extends FirFile> list2 = this.firFiles;
        Intrinsics.checkNotNull(list2);
        return Fir2IrConverter.Companion.createModuleFragment(this.session, scopeSession, list2, this.languageVersionSettings, signaturer, new JvmGeneratorExtensions(generateFacades), new FirJvmKotlinMangler(this.session), IrFactoryImpl.INSTANCE, FirJvmVisibilityConverter.INSTANCE);
    }

    public static /* synthetic */ Fir2IrResult convertToIr$default(FirAnalyzerFacade firAnalyzerFacade, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return firAnalyzerFacade.convertToIr(bl);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final List<KtFile> getKtFiles() {
        return this.ktFiles;
    }

    public FirAnalyzerFacade(@NotNull FirSession session2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull List<? extends KtFile> ktFiles) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(ktFiles, "ktFiles");
        this.session = session2;
        this.languageVersionSettings = languageVersionSettings;
        this.ktFiles = ktFiles;
    }
}

