/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.awt.XDialog;
import com.sun.star.awt.XDialogProvider2;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextField;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Desktop;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import org.jbibtex.ParseException;
import org.openoffice.da.comp.w2lcommon.helper.DialogAccess;
import org.openoffice.da.comp.w2lcommon.helper.DialogBase;
import org.openoffice.da.comp.w2lcommon.helper.MessageBox;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;
import org.openoffice.da.comp.writer2latex.BibTeXReader;
import org.openoffice.da.comp.writer2latex.Messages;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.office.BibMark;
import writer2latex.util.Misc;

public class BibTeXDialog
extends DialogBase
implements XInitialization {
    public static String __serviceName = "org.openoffice.da.writer2latex.BibTeXDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer2latex.BibTeXDialog";
    XFrame xFrame = null;
    File bibTeXDirectory = null;
    String sBibTeXJavaEncoding = this.getBibTeXJavaEncoding();
    File[] files = null;
    BibTeXReader currentFile = null;

    public void initialize(Object[] objects) throws Exception {
        for (Object object : objects) {
            if (object instanceof XFrame) {
                this.xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)object);
            }
            if (!(object instanceof String)) continue;
            this.bibTeXDirectory = new File((String)object);
        }
    }

    public BibTeXDialog(XComponentContext xContext) {
        super(xContext);
    }

    private String getBibTeXJavaEncoding() {
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            Object view = registry.getRegistryView("/org.openoffice.da.Writer2LaTeX.toolbar.ToolbarOptions/BibliographyOptions", false);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            short nBibTeXEncoding = XPropertySetHelper.getPropertyValueAsShort(xProps, "BibTeXEncoding");
            registry.disposeRegistryView(view);
            return ClassicI18n.writeJavaEncoding(nBibTeXEncoding);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getDialogLibraryName() {
        return "W2LDialogs2";
    }

    @Override
    public String getDialogName() {
        return "BibTeXEntry";
    }

    @Override
    public void initialize() {
        this.reload(null);
    }

    @Override
    public void endDialog() {
    }

    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object event, String sMethod) {
        this.clearUpdateLabel();
        if (sMethod.equals("FileChange")) {
            this.fileChange();
        } else if (sMethod.equals("EntryChange")) {
            this.entryChange();
        } else if (sMethod.equals("New")) {
            this.newFile();
        } else if (sMethod.equals("Edit")) {
            this.edit();
        } else if (sMethod.equals("Reload")) {
            this.reload(null);
        } else if (sMethod.equals("InsertReference")) {
            this.insertReference();
        } else if (sMethod.equals("Update")) {
            this.update();
        }
        return true;
    }

    @Override
    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"FileChange", "EntryChange", "New", "Edit", "Reload", "InsertReference", "Update"};
        return sNames;
    }

    private void clearUpdateLabel() {
        this.setLabelText("UpdateLabel", "");
    }

    private void reload(String sSelectedFileName) {
        String sFile = null;
        if (sSelectedFileName != null) {
            sFile = sSelectedFileName;
        } else {
            short nSelectedFile = this.getListBoxSelectedItem("File");
            if (nSelectedFile >= 0 && this.files[nSelectedFile] != null) {
                sFile = this.getListBoxStringItemList("File")[nSelectedFile];
            }
        }
        if (this.bibTeXDirectory != null && this.bibTeXDirectory.isDirectory()) {
            this.files = this.bibTeXDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String sName) {
                    return sName != null && sName.endsWith(".bib");
                }
            });
            int nFileCount = this.files.length;
            String[] sFileNames = new String[nFileCount];
            int nFile = 0;
            for (int i = 0; i < nFileCount; i = (int)((short)(i + 1))) {
                sFileNames[i] = this.files[i].getName();
                if (!sFileNames[i].equals(sFile)) continue;
                nFile = i;
            }
            this.setListBoxStringItemList("File", sFileNames);
            this.setListBoxSelectedItem("File", (short)nFile);
            if (nFileCount > 0) {
                this.setControlEnabled("FileLabel", true);
                this.setControlEnabled("File", true);
                this.setControlEnabled("EntryLabel", true);
                this.setControlEnabled("Entry", true);
                this.setControlEnabled("Edit", true);
                this.setControlEnabled("Insert", true);
                this.setControlEnabled("Update", true);
                this.fileChange();
                return;
            }
        }
        this.setControlEnabled("FileLabel", false);
        this.setControlEnabled("File", false);
        this.setControlEnabled("EntryLabel", false);
        this.setControlEnabled("Entry", false);
        this.setControlEnabled("Edit", false);
        this.setControlEnabled("Insert", false);
        this.setControlEnabled("Update", false);
        this.setLabelText("EntryInformation", Messages.getString("BibTeXDialog.nobibtexfiles"));
    }

    private void fileChange() {
        short nFile;
        String sEntry = null;
        int nEntry = this.getListBoxSelectedItem("Entry");
        if (nEntry >= 0) {
            sEntry = this.getListBoxStringItemList("Entry")[nEntry];
        }
        if ((nFile = this.getListBoxSelectedItem("File")) >= 0) {
            try {
                this.currentFile = new BibTeXReader(this.files[nFile], this.sBibTeXJavaEncoding);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                this.currentFile = null;
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                this.currentFile = null;
            }
            if (this.currentFile != null) {
                String[] sCurrentKeys = this.currentFile.getEntries().keySet().toArray(new String[0]);
                this.setListBoxStringItemList("Entry", sCurrentKeys);
                if (sCurrentKeys.length > 0) {
                    nEntry = 0;
                    if (sEntry != null) {
                        int nEntryCount = sCurrentKeys.length;
                        for (int i = 0; i < nEntryCount; i = (int)((short)(i + 1))) {
                            if (!sEntry.equals(sCurrentKeys[i])) continue;
                            nEntry = i;
                        }
                    }
                    this.setListBoxSelectedItem("Entry", (short)nEntry);
                    this.setControlEnabled("EntryLabel", true);
                    this.setControlEnabled("Entry", true);
                    this.setControlEnabled("Insert", true);
                    this.entryChange();
                } else {
                    this.setControlEnabled("EntryLabel", false);
                    this.setControlEnabled("Entry", false);
                    this.setControlEnabled("Insert", false);
                    this.setLabelText("EntryInformation", Messages.getString("BibTeXDialog.noentries"));
                }
                this.setControlEnabled("Edit", true);
            } else {
                this.setListBoxStringItemList("Entry", new String[0]);
                this.setControlEnabled("EntryLabel", false);
                this.setControlEnabled("Entry", false);
                this.setControlEnabled("Edit", false);
                this.setControlEnabled("Insert", false);
                this.setLabelText("EntryInformation", Messages.getString("BibTeXDialog.errorreadingfile"));
            }
        }
    }

    private void entryChange() {
        BibMark bibMark = this.getCurrentEntry();
        if (bibMark != null) {
            String sYear;
            String sPublisher;
            String sTitle;
            String sAuthor = bibMark.getField(BibMark.EntryType.author);
            if (sAuthor == null) {
                sAuthor = "";
            }
            if ((sTitle = bibMark.getField(BibMark.EntryType.title)) == null) {
                sTitle = "";
            }
            if ((sPublisher = bibMark.getField(BibMark.EntryType.publisher)) == null) {
                sPublisher = "";
            }
            if ((sYear = bibMark.getField(BibMark.EntryType.year)) == null) {
                sYear = "";
            }
            this.setLabelText("EntryInformation", sAuthor + "\n" + sTitle + "\n" + sPublisher + "\n" + sYear);
        } else {
            this.setLabelText("EntryInformation", Messages.getString("BibTeXDialog.noinformation"));
        }
    }

    private void insertReference() {
        this.insertReference(this.getCurrentEntry());
    }

    private void newFile() {
        String sFileName = this.getFileName();
        if (sFileName != null) {
            if (!sFileName.equals(".bib")) {
                File file = new File(this.bibTeXDirectory, sFileName);
                try {
                    if (!file.createNewFile() && this.xFrame != null) {
                        MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
                        msgBox.showMessage("Writer2LaTeX", Messages.getString("BibTeXDialog.thefile") + " " + sFileName + " " + Messages.getString("BibTeXDialog.alreadyexists"));
                    }
                    this.reload(sFileName);
                }
                catch (IOException iOException) {}
            } else if (this.xFrame != null) {
                MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
                msgBox.showMessage("Writer2LaTeX", Messages.getString("BibTeXDialog.filenameempty"));
            }
        }
    }

    private String getFileName() {
        XDialog xDialog = this.getNewDialog();
        if (xDialog != null) {
            DialogAccess ndlg = new DialogAccess(xDialog);
            ndlg.setListBoxStringItemList("Name", new String[0]);
            String sResult = null;
            if (xDialog.execute() == 1) {
                DialogAccess dlg = new DialogAccess(xDialog);
                sResult = dlg.getTextFieldText("Name");
            }
            xDialog.endExecute();
            if (sResult != null && !sResult.toLowerCase().endsWith(".bib")) {
                sResult = sResult + ".bib";
            }
            return Misc.makeTeXFriendly(sResult, "bibliography");
        }
        return null;
    }

    protected XDialog getNewDialog() {
        XMultiComponentFactory xMCF = this.xContext.getServiceManager();
        try {
            Object provider = xMCF.createInstanceWithContext("com.sun.star.awt.DialogProvider2", this.xContext);
            XDialogProvider2 xDialogProvider = (XDialogProvider2)UnoRuntime.queryInterface(XDialogProvider2.class, (Object)provider);
            String sDialogUrl = "vnd.sun.star.script:" + this.getDialogLibraryName() + ".NewDialog?location=application";
            return xDialogProvider.createDialog(sDialogUrl);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void edit() {
        short nFile = this.getListBoxSelectedItem("File");
        if (nFile >= 0 && this.files[nFile].exists()) {
            this.edit(this.files[nFile]);
        }
    }

    private BibMark getCurrentEntry() {
        BibMark bibMark = null;
        short nEntry = this.getListBoxSelectedItem("Entry");
        if (nEntry >= 0) {
            String[] sCurrentKeys = this.getListBoxStringItemList("Entry");
            String sKey = sCurrentKeys[nEntry];
            bibMark = this.currentFile.getEntries().get(sKey);
        }
        return bibMark;
    }

    private void edit(File file) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.open(file);
            }
            catch (IOException e) {
                if (this.xFrame != null) {
                    MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
                    msgBox.showMessage("Writer2LaTeX", Messages.getString("BibTeXDialog.failedbibtexeditor"));
                }
            }
        } else if (this.xFrame != null) {
            MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
            msgBox.showMessage("Writer2LaTeX", Messages.getString("BibTeXDialog.nobibtexeditor"));
        }
    }

    private void update() {
        if (this.xFrame != null) {
            BibTeXReader[] readers = this.parseAllBibTeXFiles();
            HashSet<String> notUpdated = new HashSet<String>();
            XTextFieldsSupplier xSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.xFrame.getController().getModel());
            XEnumerationAccess fields = xSupplier.getTextFields();
            XEnumeration enumeration = fields.createEnumeration();
            while (enumeration.hasMoreElements()) {
                try {
                    String sId;
                    XServiceInfo xInfo;
                    XTextField xTextField;
                    Object elm = enumeration.nextElement();
                    if (!AnyConverter.isObject((Object)elm) || (xTextField = (XTextField)AnyConverter.toObject(XTextField.class, (Object)elm)) == null || !(xInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xTextField)).supportsService("com.sun.star.text.TextField.Bibliography") || (sId = this.updateBibField(xTextField, readers)) == null) continue;
                    notUpdated.add(sId);
                }
                catch (NoSuchElementException elm) {
                }
                catch (WrappedTargetException elm) {}
            }
            XDocumentIndexesSupplier xIndexSupplier = (XDocumentIndexesSupplier)UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)this.xFrame.getController().getModel());
            XIndexAccess xIndexAccess = xIndexSupplier.getDocumentIndexes();
            int nIndexCount = xIndexAccess.getCount();
            for (int i = 0; i < nIndexCount; ++i) {
                try {
                    XDocumentIndex xDocumentIndex;
                    Object indexElm = xIndexAccess.getByIndex(i);
                    if (!AnyConverter.isObject((Object)indexElm) || (xDocumentIndex = (XDocumentIndex)AnyConverter.toObject(XDocumentIndex.class, (Object)indexElm)) == null || !"com.sun.star.text.Bibliography".equals(xDocumentIndex.getServiceName())) continue;
                    xDocumentIndex.update();
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                catch (WrappedTargetException wrappedTargetException) {
                    // empty catch block
                }
            }
            if (notUpdated.isEmpty()) {
                this.setLabelText("UpdateLabel", Messages.getString("BibTeXDialog.allbibfieldsupdated"));
            } else {
                this.setLabelText("UpdateLabel", Messages.getString("BibTeXDialog.bibfieldsnotupdated") + ":\n" + ((Object)notUpdated).toString());
            }
        }
    }

    private BibTeXReader[] parseAllBibTeXFiles() {
        int nFiles = this.files.length;
        BibTeXReader[] readers = new BibTeXReader[nFiles];
        for (int i = 0; i < nFiles; ++i) {
            try {
                readers[i] = new BibTeXReader(this.files[i], this.sBibTeXJavaEncoding);
                continue;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                readers[i] = null;
                continue;
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                readers[i] = null;
            }
        }
        return readers;
    }

    private String updateBibField(XTextField xTextField, BibTeXReader[] readers) {
        XPropertySet xPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextField);
        if (xPropSet != null) {
            try {
                Object fieldsObj = xPropSet.getPropertyValue("Fields");
                if (fieldsObj != null && fieldsObj instanceof PropertyValue[]) {
                    PropertyValue[] props;
                    for (PropertyValue prop : props = (PropertyValue[])fieldsObj) {
                        if (!"Identifier".equals(prop.Name) || !(prop.Value instanceof String)) continue;
                        String sIdentifier = (String)prop.Value;
                        for (BibTeXReader reader : readers) {
                            if (!reader.getEntries().keySet().contains(sIdentifier)) continue;
                            BibMark bibMark = reader.getEntries().get(sIdentifier);
                            try {
                                xPropSet.setPropertyValue("Fields", (Object)this.createBibliographyFields(bibMark));
                                return null;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                        return sIdentifier;
                    }
                }
            }
            catch (UnknownPropertyException e) {
                System.out.println(e.getMessage());
            }
            catch (WrappedTargetException e) {
                System.out.println(e.getMessage());
            }
        }
        return null;
    }

    private void insertReference(BibMark bibMark) {
        if (this.xFrame != null) {
            try {
                XTextDocument xTextDoc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xFrame.getController().getModel());
                XText xText = xTextDoc.getText();
                XTextViewCursorSupplier xViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)this.xFrame.getController());
                XTextViewCursor xViewCursor = xViewCursorSupplier.getViewCursor();
                XMultiServiceFactory xDocFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xFrame.getController().getModel());
                XDependentTextField xBibField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)xDocFactory.createInstance("com.sun.star.text.textfield.Bibliography"));
                XPropertySet xMasterPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xDocFactory.createInstance("com.sun.star.text.fieldmaster.Bibliography"));
                XPropertySet xPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xBibField);
                PropertyValue[] fields = this.createBibliographyFields(bibMark);
                xPropSet.setPropertyValue("Fields", (Object)fields);
                xBibField.attachTextFieldMaster(xMasterPropSet);
                xText.insertTextContent(xViewCursor.getEnd(), (XTextContent)xBibField, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private PropertyValue[] createBibliographyFields(BibMark bibMark) {
        BibMark.EntryType[] entryTypes = BibMark.EntryType.values();
        PropertyValue[] fields = new PropertyValue[entryTypes.length + 2];
        fields[0] = new PropertyValue();
        fields[0].Name = "Identifier";
        fields[0].Value = bibMark.getIdentifier();
        fields[1] = new PropertyValue();
        fields[1].Name = "BibiliographicType";
        fields[1].Value = new Short(this.getBibliographicType(bibMark.getEntryType()));
        int i = 1;
        for (BibMark.EntryType entryType : entryTypes) {
            fields[++i] = new PropertyValue();
            fields[i].Name = this.getFieldName(entryType);
            String sValue = bibMark.getField(entryType);
            fields[i].Value = sValue != null ? bibMark.getField(entryType) : "";
        }
        return fields;
    }

    private String getFieldName(BibMark.EntryType entryType) {
        switch (entryType) {
            case address: {
                return "Address";
            }
            case annote: {
                return "Annote";
            }
            case author: {
                return "Author";
            }
            case booktitle: {
                return "Booktitle";
            }
            case chapter: {
                return "Chapter";
            }
            case edition: {
                return "Edition";
            }
            case editor: {
                return "Editor";
            }
            case howpublished: {
                return "Howpublished";
            }
            case institution: {
                return "Institution";
            }
            case journal: {
                return "Journal";
            }
            case month: {
                return "Month";
            }
            case note: {
                return "Note";
            }
            case number: {
                return "Number";
            }
            case organizations: {
                return "Organizations";
            }
            case pages: {
                return "Pages";
            }
            case publisher: {
                return "Publisher";
            }
            case school: {
                return "School";
            }
            case series: {
                return "Series";
            }
            case title: {
                return "Title";
            }
            case report_type: {
                return "Report_Type";
            }
            case volume: {
                return "Volume";
            }
            case year: {
                return "Year";
            }
            case url: {
                return "URL";
            }
            case custom1: {
                return "Custom1";
            }
            case custom2: {
                return "Custom2";
            }
            case custom3: {
                return "Custom3";
            }
            case custom4: {
                return "Custom4";
            }
            case custom5: {
                return "Custom5";
            }
            case isbn: {
                return "ISBN";
            }
        }
        return null;
    }

    private short getBibliographicType(String sBibType) {
        String s = sBibType.toUpperCase();
        if ("ARTICLE".equals(s)) {
            return 0;
        }
        if ("BOOK".equals(s)) {
            return 1;
        }
        if ("BOOKLET".equals(s)) {
            return 2;
        }
        if ("CONFERENCE".equals(s)) {
            return 3;
        }
        if ("INBOOK".equals(s)) {
            return 4;
        }
        if ("INCOLLECTION".equals(s)) {
            return 5;
        }
        if ("INPROCEEDINGS".equals(s)) {
            return 6;
        }
        if ("JOURNAL".equals(s)) {
            return 7;
        }
        if ("MANUAL".equals(s)) {
            return 8;
        }
        if ("MASTERSTHESIS".equals(s)) {
            return 9;
        }
        if ("MISC".equals(s)) {
            return 10;
        }
        if ("PHDTHESIS".equals(s)) {
            return 11;
        }
        if ("PROCEEDINGS".equals(s)) {
            return 12;
        }
        if ("TECHREPORT".equals(s)) {
            return 13;
        }
        if ("UNPUBLISHED".equals(s)) {
            return 14;
        }
        if ("EMAIL".equals(s)) {
            return 15;
        }
        if ("WWW".equals(s)) {
            return 16;
        }
        if ("CUSTOM1".equals(s)) {
            return 17;
        }
        if ("CUSTOM2".equals(s)) {
            return 18;
        }
        if ("CUSTOM3".equals(s)) {
            return 19;
        }
        if ("CUSTOM4".equals(s)) {
            return 20;
        }
        if ("CUSTOM5".equals(s)) {
            return 21;
        }
        return 10;
    }
}

