/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.geom.LineSegmentDouble;

public class Box2D {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;

    private Box2D(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static Box2D create(double x, double y, Dimension2D dim) {
        return new Box2D(x, y, x + dim.getWidth(), y + dim.getHeight());
    }

    public String toString() {
        return "Box [" + this.x1 + "," + this.y1 + "] [" + this.x2 + "," + this.y2 + "]";
    }

    public boolean doesIntersect(LineSegmentDouble seg) {
        if (seg.doesIntersect(new LineSegmentDouble(this.x1, this.y1, this.x2, this.y1))) {
            return true;
        }
        if (seg.doesIntersect(new LineSegmentDouble(this.x2, this.y1, this.x2, this.y2))) {
            return true;
        }
        if (seg.doesIntersect(new LineSegmentDouble(this.x2, this.y2, this.x1, this.y2))) {
            return true;
        }
        return seg.doesIntersect(new LineSegmentDouble(this.x1, this.y2, this.x1, this.y1));
    }
}

