/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.objectproperty;

import java.awt.Component;
import java.util.Optional;
import javax.swing.Icon;
import org.protege.editor.core.ui.menu.PopupMenuId;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.selection.SelectionDriver;
import org.protege.editor.owl.ui.renderer.AddChildIcon;
import org.protege.editor.owl.ui.renderer.AddSiblingIcon;
import org.protege.editor.owl.ui.renderer.DeleteEntityIcon;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;
import org.protege.editor.owl.ui.renderer.OWLObjectPropertyIcon;
import org.protege.editor.owl.ui.view.AbstractOWLPropertyHierarchyViewComponent;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;

public class OWLObjectPropertyHierarchyViewComponent
extends AbstractOWLPropertyHierarchyViewComponent<OWLObjectProperty>
implements SelectionDriver {
    @Override
    protected void performExtraInitialisation() throws Exception {
        super.performExtraInitialisation();
        this.getAssertedTree().setPopupMenuId(new PopupMenuId("[AssertedObjectPropertyHierarchy]"));
    }

    @Override
    protected boolean isOWLObjectPropertyView() {
        return true;
    }

    @Override
    protected OWLObjectHierarchyProvider<OWLObjectProperty> getHierarchyProvider() {
        return this.getOWLModelManager().getOWLHierarchyManager().getOWLObjectPropertyHierarchyProvider();
    }

    @Override
    protected Optional<OWLObjectHierarchyProvider<OWLObjectProperty>> getInferredHierarchyProvider() {
        return Optional.of(this.getOWLModelManager().getOWLHierarchyManager().getInferredOWLObjectPropertyHierarchyProvider());
    }

    @Override
    protected OWLSubPropertyAxiom getSubPropertyAxiom(OWLObjectProperty child, OWLObjectProperty parent) {
        return this.getOWLDataFactory().getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)child, (OWLObjectPropertyExpression)parent);
    }

    @Override
    protected boolean canAcceptDrop(Object child, Object parent) {
        return child instanceof OWLObjectProperty;
    }

    @Override
    protected OWLEntityCreationSet<OWLObjectProperty> createProperty() {
        return this.getOWLWorkspace().createOWLObjectProperty();
    }

    @Override
    protected Icon getSubIcon() {
        return new AddChildIcon(new OWLObjectPropertyIcon());
    }

    @Override
    protected Icon getSibIcon() {
        return new AddSiblingIcon(new OWLObjectPropertyIcon());
    }

    @Override
    protected Icon getDeleteIcon() {
        return new DeleteEntityIcon(new OWLObjectPropertyIcon(OWLEntityIcon.FillType.HOLLOW));
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public Optional<OWLObject> getSelection() {
        return Optional.ofNullable(this.getSelectedEntity());
    }
}

