/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassProvider;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAsymmetricObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataAllValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataComplementOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataExactCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataHasValueImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataIntersectionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataMaxCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataMinCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataSomeValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataUnionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeDefinitionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeRestrictionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDeclarationAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDifferentIndividualsAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointDataPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointUnionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentDataPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFacetRestrictionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFunctionalDataPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFunctionalObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLHasKeyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLImportsDeclarationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLInverseFunctionalObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLInverseObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLIrreflexiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNegativeDataPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNegativeObjectPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectAllValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectComplementOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectExactCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectHasSelfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectHasValueImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectIntersectionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectInverseOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectMaxCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectMinCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectSomeValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectUnionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLReflexiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSameIndividualAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubAnnotationPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubClassOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubDataPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubObjectPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubPropertyChainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSymmetricObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLTransitiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLBuiltInAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLClassAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDataPropertyAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDataRangeAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDifferentIndividualsAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLIndividualArgumentImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLLiteralArgumentImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLObjectPropertyAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLRuleImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLSameIndividualAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLVariableImpl;

@Singleton
public class OWLDataFactoryImpl
implements OWLDataFactory,
Serializable,
OWLClassProvider {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private static final OWLClass OWL_THING = new OWLClassImpl(OWLRDFVocabulary.OWL_THING.getIRI());
    @Nonnull
    private static final OWLClass OWL_NOTHING = new OWLClassImpl(OWLRDFVocabulary.OWL_NOTHING.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty RDFS_LABEL = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_LABEL.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty RDFS_COMMENT = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_COMMENT.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty RDFS_SEE_ALSO = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_SEE_ALSO.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty RDFS_IS_DEFINED_BY = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_IS_DEFINED_BY.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty OWL_BACKWARD_COMPATIBLE_WITH = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_BACKWARD_COMPATIBLE_WITH.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty OWL_INCOMPATIBLE_WITH = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_INCOMPATIBLE_WITH.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty OWL_VERSION_INFO = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_VERSION_INFO.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty OWL_DEPRECATED = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_DEPRECATED.getIRI());
    @Nonnull
    private static final OWLObjectProperty OWL_TOP_OBJECT_PROPERTY = new OWLObjectPropertyImpl(OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI());
    @Nonnull
    private static final OWLObjectProperty OWL_BOTTOM_OBJECT_PROPERTY = new OWLObjectPropertyImpl(OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
    @Nonnull
    private static final OWLDataProperty OWL_TOP_DATA_PROPERTY = new OWLDataPropertyImpl(OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI());
    @Nonnull
    private static final OWLDataProperty OWL_BOTTOM_DATA_PROPERTY = new OWLDataPropertyImpl(OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
    private final OWLDataFactoryInternals dataFactoryInternals = new OWLDataFactoryInternalsImpl(false);
    @Nonnull
    private static final Set<OWLAnnotation> EMPTY_ANNOTATIONS_SET = CollectionFactory.emptySet();

    @Override
    public void purge() {
        this.dataFactoryInternals.purge();
    }

    private static void checkAnnotations(@Nonnull Set<? extends OWLAnnotation> o) {
        OWLDataFactoryImpl.checkNull(o, "annotations cannot be null", true);
    }

    private static void checkNull(@Nonnull Collection<?> o, String name, boolean emptyAllowed) {
        OWLAPIPreconditions.checkNotNull(o, name + " cannot be null");
        if (!emptyAllowed && o.isEmpty()) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    private static void checkNull(@Nonnull Object[] o, String name, boolean emptyAllowed) {
        OWLAPIPreconditions.checkNotNull(o, name + " cannot be null");
        if (!emptyAllowed && o.length == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    @Override
    @Nonnull
    public <E extends OWLEntity> E getOWLEntity(@Nonnull EntityType<E> entityType, IRI iri) {
        OWLAPIPreconditions.checkNotNull(entityType, "entityType cannot be null");
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        OWLLogicalEntity ret = null;
        if (entityType.equals(EntityType.CLASS)) {
            ret = this.getOWLClass(iri);
        } else if (entityType.equals(EntityType.OBJECT_PROPERTY)) {
            ret = this.getOWLObjectProperty(iri);
        } else if (entityType.equals(EntityType.DATA_PROPERTY)) {
            ret = this.getOWLDataProperty(iri);
        } else if (entityType.equals(EntityType.ANNOTATION_PROPERTY)) {
            ret = this.getOWLAnnotationProperty(iri);
        } else if (entityType.equals(EntityType.NAMED_INDIVIDUAL)) {
            ret = this.getOWLNamedIndividual(iri);
        } else if (entityType.equals(EntityType.DATATYPE)) {
            ret = this.getOWLDatatype(iri);
        }
        if (ret != null) {
            return (E)ret;
        }
        throw new OWLRuntimeException("Entity type not recognized: " + entityType + " for iri " + iri);
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        return this.dataFactoryInternals.getOWLClass(iri);
    }

    @Override
    public OWLClass getOWLClass(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull(abbreviatedIRI, "iri cannot be null");
        OWLAPIPreconditions.checkNotNull(prefixManager, "prefixManager cannot be null");
        return this.getOWLClass(prefixManager.getIRI(abbreviatedIRI));
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull(abbreviatedIRI, "abbreviatedIRI cannot be null");
        OWLAPIPreconditions.checkNotNull(prefixManager, "prefixManager cannot be null");
        return this.getOWLAnnotationProperty(prefixManager.getIRI(abbreviatedIRI));
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getRDFSLabel() {
        return RDFS_LABEL;
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getRDFSComment() {
        return RDFS_COMMENT;
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getRDFSSeeAlso() {
        return RDFS_SEE_ALSO;
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getRDFSIsDefinedBy() {
        return RDFS_IS_DEFINED_BY;
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getOWLVersionInfo() {
        return OWL_VERSION_INFO;
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getOWLBackwardCompatibleWith() {
        return OWL_BACKWARD_COMPATIBLE_WITH;
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getOWLIncompatibleWith() {
        return OWL_INCOMPATIBLE_WITH;
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getOWLDeprecated() {
        return OWL_DEPRECATED;
    }

    @Override
    public OWLDatatype getOWLDatatype(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull(abbreviatedIRI, "abbreviatedIRI cannot be null");
        OWLAPIPreconditions.checkNotNull(prefixManager, "prefixManager cannot be null");
        return this.dataFactoryInternals.getOWLDatatype(prefixManager.getIRI(abbreviatedIRI));
    }

    @Override
    @Nonnull
    public OWLClass getOWLThing() {
        return OWL_THING;
    }

    @Override
    @Nonnull
    public OWLClass getOWLNothing() {
        return OWL_NOTHING;
    }

    @Override
    @Nonnull
    public OWLDataProperty getOWLBottomDataProperty() {
        return OWL_BOTTOM_DATA_PROPERTY;
    }

    @Override
    @Nonnull
    public OWLObjectProperty getOWLBottomObjectProperty() {
        return OWL_BOTTOM_OBJECT_PROPERTY;
    }

    @Override
    @Nonnull
    public OWLDataProperty getOWLTopDataProperty() {
        return OWL_TOP_DATA_PROPERTY;
    }

    @Override
    @Nonnull
    public OWLObjectProperty getOWLTopObjectProperty() {
        return OWL_TOP_OBJECT_PROPERTY;
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        return this.dataFactoryInternals.getOWLObjectProperty(iri);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        return this.dataFactoryInternals.getOWLDataProperty(iri);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        return this.dataFactoryInternals.getOWLNamedIndividual(iri);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull(abbreviatedIRI, "curi canno be null");
        OWLAPIPreconditions.checkNotNull(prefixManager, "prefixManager cannot be null");
        return this.getOWLDataProperty(prefixManager.getIRI(abbreviatedIRI));
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull(abbreviatedIRI, "curi canno be null");
        OWLAPIPreconditions.checkNotNull(prefixManager, "prefixManager cannot be null");
        return this.getOWLNamedIndividual(prefixManager.getIRI(abbreviatedIRI));
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull(abbreviatedIRI, "curi canno be null");
        OWLAPIPreconditions.checkNotNull(prefixManager, "prefixManager cannot be null");
        return this.getOWLObjectProperty(prefixManager.getIRI(abbreviatedIRI));
    }

    @Override
    @Nonnull
    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        OWLAPIPreconditions.checkNotNull(nodeId, "id cannot be null");
        return new OWLAnonymousIndividualImpl(NodeID.getNodeID(nodeId));
    }

    @Override
    @Nonnull
    public OWLAnonymousIndividual getOWLAnonymousIndividual() {
        return new OWLAnonymousIndividualImpl(NodeID.getNodeID(null));
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        return this.dataFactoryInternals.getOWLDatatype(iri);
    }

    @Override
    public OWLLiteral getOWLLiteral(String lexicalValue, @Nonnull OWL2Datatype datatype) {
        OWLAPIPreconditions.checkNotNull(lexicalValue, "lexicalValue cannot be null");
        OWLAPIPreconditions.checkNotNull(datatype, "datatype cannot be null");
        return this.getOWLLiteral(lexicalValue, this.getOWLDatatype(datatype.getIRI()));
    }

    @Override
    public OWLLiteral getOWLLiteral(boolean value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    @Override
    @Nonnull
    public OWLDataOneOf getOWLDataOneOf(@Nonnull Set<? extends OWLLiteral> values) {
        OWLDataFactoryImpl.checkNull(values, "values", true);
        return new OWLDataOneOfImpl(values);
    }

    @Override
    public OWLDataOneOf getOWLDataOneOf(OWLLiteral ... values) {
        OWLDataFactoryImpl.checkNull(values, "values", true);
        return this.getOWLDataOneOf(CollectionFactory.createSet(values));
    }

    @Override
    @Nonnull
    public OWLDataComplementOf getOWLDataComplementOf(OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull(dataRange, "dataRange cannot be null");
        return new OWLDataComplementOfImpl(dataRange);
    }

    @Override
    public OWLDataIntersectionOf getOWLDataIntersectionOf(OWLDataRange ... dataRanges) {
        OWLDataFactoryImpl.checkNull(dataRanges, "dataRanges", true);
        return this.getOWLDataIntersectionOf(CollectionFactory.createSet(dataRanges));
    }

    @Override
    @Nonnull
    public OWLDataIntersectionOf getOWLDataIntersectionOf(@Nonnull Set<? extends OWLDataRange> dataRanges) {
        OWLDataFactoryImpl.checkNull(dataRanges, "dataRanges", true);
        return new OWLDataIntersectionOfImpl(dataRanges);
    }

    @Override
    public OWLDataUnionOf getOWLDataUnionOf(OWLDataRange ... dataRanges) {
        OWLDataFactoryImpl.checkNull(dataRanges, "dataRanges", true);
        return this.getOWLDataUnionOf(CollectionFactory.createSet(dataRanges));
    }

    @Override
    @Nonnull
    public OWLDataUnionOf getOWLDataUnionOf(@Nonnull Set<? extends OWLDataRange> dataRanges) {
        OWLDataFactoryImpl.checkNull(dataRanges, "dataRanges", true);
        return new OWLDataUnionOfImpl(dataRanges);
    }

    @Override
    @Nonnull
    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, @Nonnull Set<OWLFacetRestriction> facetRestrictions) {
        OWLAPIPreconditions.checkNotNull(dataType, "datatype cannot be null");
        OWLDataFactoryImpl.checkNull(facetRestrictions, "facets", true);
        return new OWLDatatypeRestrictionImpl(dataType, facetRestrictions);
    }

    @Override
    @Nonnull
    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, OWLFacet facet, OWLLiteral typedLiteral) {
        OWLAPIPreconditions.checkNotNull(dataType, "datatype cannot be null");
        OWLAPIPreconditions.checkNotNull(facet, "facet cannot be null");
        OWLAPIPreconditions.checkNotNull(typedLiteral, "typedConstant cannot be null");
        return new OWLDatatypeRestrictionImpl(dataType, CollectionFactory.createSet(this.getOWLFacetRestriction(facet, typedLiteral)));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, OWLFacetRestriction ... facetRestrictions) {
        OWLDataFactoryImpl.checkNull(facetRestrictions, "facetRestrictions", true);
        return this.getOWLDatatypeRestriction(dataType, CollectionFactory.createSet(facetRestrictions));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMinInclusiveRestriction(int minInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMaxInclusiveRestriction(int maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MAX_INCLUSIVE, this.getOWLLiteral(maxInclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMinMaxInclusiveRestriction(int minInclusive, int maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, maxInclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMinExclusiveRestriction(int minExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMaxExclusiveRestriction(int maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MAX_EXCLUSIVE, this.getOWLLiteral(maxExclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMinMaxExclusiveRestriction(int minExclusive, int maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, maxExclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMinInclusiveRestriction(double minInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMaxInclusiveRestriction(double maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MAX_INCLUSIVE, this.getOWLLiteral(maxInclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMinMaxInclusiveRestriction(double minInclusive, double maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, maxInclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMinExclusiveRestriction(double minExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMaxExclusiveRestriction(double maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MAX_EXCLUSIVE, this.getOWLLiteral(maxExclusive));
    }

    @Override
    public OWLDatatypeRestriction getOWLDatatypeMinMaxExclusiveRestriction(double minExclusive, double maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, maxExclusive));
    }

    @Override
    @Nonnull
    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, int facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    @Override
    @Nonnull
    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, double facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    @Override
    @Nonnull
    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, float facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    @Override
    @Nonnull
    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, OWLLiteral facetValue) {
        OWLAPIPreconditions.checkNotNull(facet, "facet cannot be null");
        OWLAPIPreconditions.checkNotNull(facetValue, "facetValue cannot be null");
        return new OWLFacetRestrictionImpl(facet, facetValue);
    }

    @Override
    @Nonnull
    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(@Nonnull Set<? extends OWLClassExpression> operands) {
        OWLDataFactoryImpl.checkNull(operands, "operands", true);
        return new OWLObjectIntersectionOfImpl(operands);
    }

    @Override
    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(OWLClassExpression ... operands) {
        OWLDataFactoryImpl.checkNull(operands, "operands", true);
        return this.getOWLObjectIntersectionOf(CollectionFactory.createSet(operands));
    }

    @Override
    @Nonnull
    public OWLDataAllValuesFrom getOWLDataAllValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull(dataRange, "dataRange cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLDataAllValuesFromImpl(property, dataRange);
    }

    @Override
    @Nonnull
    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLDataExactCardinalityImpl(property, cardinality, this.getTopDatatype());
    }

    @Override
    @Nonnull
    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull(dataRange, "dataRange cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        return new OWLDataExactCardinalityImpl(property, cardinality, dataRange);
    }

    @Override
    @Nonnull
    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLDataMaxCardinalityImpl(property, cardinality, this.getTopDatatype());
    }

    @Override
    @Nonnull
    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(dataRange, "dataRange cannot be null");
        return new OWLDataMaxCardinalityImpl(property, cardinality, dataRange);
    }

    @Override
    @Nonnull
    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLDataMinCardinalityImpl(property, cardinality, this.getTopDatatype());
    }

    @Override
    @Nonnull
    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull(dataRange, "dataRange cannot be null");
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLDataMinCardinalityImpl(property, cardinality, dataRange);
    }

    @Override
    @Nonnull
    public OWLDataSomeValuesFrom getOWLDataSomeValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull(dataRange, "dataRange cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLDataSomeValuesFromImpl(property, dataRange);
    }

    @Override
    @Nonnull
    public OWLDataHasValue getOWLDataHasValue(OWLDataPropertyExpression property, OWLLiteral value) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(value, "value cannot be null");
        return new OWLDataHasValueImpl(property, value);
    }

    @Override
    @Nonnull
    public OWLObjectComplementOf getOWLObjectComplementOf(OWLClassExpression operand) {
        OWLAPIPreconditions.checkNotNull(operand, "operand");
        return new OWLObjectComplementOfImpl(operand);
    }

    @Override
    @Nonnull
    public OWLObjectAllValuesFrom getOWLObjectAllValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLObjectAllValuesFromImpl(property, classExpression);
    }

    @Override
    @Nonnull
    public OWLObjectOneOf getOWLObjectOneOf(@Nonnull Set<? extends OWLIndividual> values) {
        OWLDataFactoryImpl.checkNull(values, "values", true);
        return new OWLObjectOneOfImpl(values);
    }

    @Override
    public OWLObjectOneOf getOWLObjectOneOf(OWLIndividual ... individuals) {
        OWLDataFactoryImpl.checkNull(individuals, "individuals", true);
        return this.getOWLObjectOneOf(CollectionFactory.createSet(individuals));
    }

    @Override
    @Nonnull
    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLObjectExactCardinalityImpl(property, cardinality, OWL_THING);
    }

    @Override
    @Nonnull
    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        return new OWLObjectExactCardinalityImpl(property, cardinality, classExpression);
    }

    @Override
    @Nonnull
    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLObjectMinCardinalityImpl(property, cardinality, OWL_THING);
    }

    @Override
    @Nonnull
    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        return new OWLObjectMinCardinalityImpl(property, cardinality, classExpression);
    }

    @Override
    @Nonnull
    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLObjectMaxCardinalityImpl(property, cardinality, OWL_THING);
    }

    @Override
    @Nonnull
    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNegative(cardinality, "cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLObjectMaxCardinalityImpl(property, cardinality, classExpression);
    }

    @Override
    @Nonnull
    public OWLObjectHasSelf getOWLObjectHasSelf(OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLObjectHasSelfImpl(property);
    }

    @Override
    @Nonnull
    public OWLObjectSomeValuesFrom getOWLObjectSomeValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        return new OWLObjectSomeValuesFromImpl(property, classExpression);
    }

    @Override
    @Nonnull
    public OWLObjectHasValue getOWLObjectHasValue(OWLObjectPropertyExpression property, OWLIndividual individual) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(individual, "individual cannot be null");
        return new OWLObjectHasValueImpl(property, individual);
    }

    @Override
    @Nonnull
    public OWLObjectUnionOf getOWLObjectUnionOf(@Nonnull Set<? extends OWLClassExpression> operands) {
        OWLDataFactoryImpl.checkNull(operands, "operands", true);
        return new OWLObjectUnionOfImpl(operands);
    }

    @Override
    public OWLObjectUnionOf getOWLObjectUnionOf(OWLClassExpression ... operands) {
        OWLDataFactoryImpl.checkNull(operands, "operands", true);
        return this.getOWLObjectUnionOf(CollectionFactory.createSet(operands));
    }

    @Override
    @Nonnull
    public OWLAsymmetricObjectPropertyAxiom getOWLAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression propertyExpression, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(propertyExpression, "property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAsymmetricObjectPropertyAxiomImpl(propertyExpression, annotations);
    }

    @Override
    @Nonnull
    public OWLAsymmetricObjectPropertyAxiom getOWLAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression propertyExpression) {
        return this.getOWLAsymmetricObjectPropertyAxiom(propertyExpression, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDataPropertyDomainAxiom getOWLDataPropertyDomainAxiom(OWLDataPropertyExpression property, OWLClassExpression domain, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(domain, "domain cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyDomainAxiomImpl(property, domain, annotations);
    }

    @Override
    @Nonnull
    public OWLDataPropertyDomainAxiom getOWLDataPropertyDomainAxiom(OWLDataPropertyExpression property, OWLClassExpression domain) {
        return this.getOWLDataPropertyDomainAxiom(property, domain, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWLDataRange owlDataRange, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(owlDataRange, "owlDataRange cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyRangeAxiomImpl(property, owlDataRange, annotations);
    }

    @Override
    @Nonnull
    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWLDataRange owlDataRange) {
        return this.getOWLDataPropertyRangeAxiom(property, owlDataRange, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLSubDataPropertyOfAxiom getOWLSubDataPropertyOfAxiom(OWLDataPropertyExpression subProperty, OWLDataPropertyExpression superProperty, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(subProperty, "subProperty cannot be null");
        OWLAPIPreconditions.checkNotNull(superProperty, "superProperty cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubDataPropertyOfAxiomImpl(subProperty, superProperty, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Override
    @Nonnull
    public OWLSubDataPropertyOfAxiom getOWLSubDataPropertyOfAxiom(OWLDataPropertyExpression subProperty, OWLDataPropertyExpression superProperty) {
        return this.getOWLSubDataPropertyOfAxiom(subProperty, superProperty, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDeclarationAxiom getOWLDeclarationAxiom(OWLEntity owlEntity) {
        return this.getOWLDeclarationAxiom(owlEntity, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDeclarationAxiom getOWLDeclarationAxiom(OWLEntity owlEntity, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(owlEntity, "owlEntity cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDeclarationAxiomImpl(owlEntity, annotations);
    }

    @Override
    @Nonnull
    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(@Nonnull Set<? extends OWLIndividual> individuals, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(individuals, "individuals", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDifferentIndividualsAxiomImpl(individuals, annotations);
    }

    @Override
    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(OWLIndividual ... individuals) {
        OWLDataFactoryImpl.checkNull(individuals, "individuals", true);
        return this.getOWLDifferentIndividualsAxiom(CollectionFactory.createSet(individuals));
    }

    @Override
    @Nonnull
    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(@Nonnull Set<? extends OWLIndividual> individuals) {
        return this.getOWLDifferentIndividualsAxiom(individuals, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(@Nonnull Set<? extends OWLClassExpression> classExpressions, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(classExpressions, "classExpressions", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        if (classExpressions.size() == 1) {
            OWLClassExpression classExpression = classExpressions.iterator().next();
            if (classExpression.isOWLThing()) {
                throw new OWLRuntimeException("DisjointClasses(owl:Thing) cannot be created. It is not a syntactically valid OWL 2 axiom. If the intent is to declare owl:Thing as disjoint with itself and therefore empty, it cannot be created as a DisjointClasses axiom. Please rewrite it as SubClassOf(owl:Thing, owl:Nothing).");
            }
            if (classExpression.isOWLNothing()) {
                throw new OWLRuntimeException("DisjointClasses(owl:Nothing) cannot be created. It is not a syntactically valid OWL 2 axiom. If the intent is to declare owl:Nothing as disjoint with itself and therefore empty, it cannot be created as a DisjointClasses axiom, and it is also redundant as owl:Nothing is always empty. Please rewrite it as SubClassOf(owl:Nothing, owl:Nothing) or remove the axiom.");
            }
            HashSet<OWLClassExpression> modifiedClassExpressions = new HashSet<OWLClassExpression>(2);
            OWLClass addedClass = classExpression.isOWLThing() ? OWL_NOTHING : OWL_THING;
            modifiedClassExpressions.add(addedClass);
            modifiedClassExpressions.add(classExpression);
            return new OWLDisjointClassesAxiomImpl((Set<? extends OWLClassExpression>)modifiedClassExpressions, this.makeSingletonDisjoinClassWarningAnnotation(annotations, classExpression, addedClass));
        }
        return new OWLDisjointClassesAxiomImpl(classExpressions, annotations);
    }

    @Nonnull
    protected Set<? extends OWLAnnotation> makeSingletonDisjoinClassWarningAnnotation(Set<? extends OWLAnnotation> annotations, OWLClassExpression classExpression, OWLClassExpression addedClass) {
        HashSet<? extends OWLAnnotation> modifiedAnnotations = new HashSet<OWLAnnotation>(annotations.size() + 1);
        modifiedAnnotations.addAll(annotations);
        String provenanceComment = String.format("%s on %s", VersionInfo.getVersionInfo().getGeneratedByMessage(), new SimpleDateFormat().format(new Date()));
        OWLAnnotationImpl provenanceAnnotation = new OWLAnnotationImpl(RDFS_COMMENT, this.getOWLLiteral(provenanceComment), EMPTY_ANNOTATIONS_SET);
        Set<OWLAnnotationImpl> metaAnnotations = Collections.singleton(provenanceAnnotation);
        String changeComment = String.format("DisjointClasses(%s) replaced by DisjointClasses(%s %s)", classExpression, classExpression, addedClass);
        modifiedAnnotations.add(new OWLAnnotationImpl(RDFS_COMMENT, this.getOWLLiteral(changeComment), metaAnnotations));
        return modifiedAnnotations;
    }

    @Override
    @Nonnull
    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(@Nonnull Set<? extends OWLClassExpression> classExpressions) {
        return this.getOWLDisjointClassesAxiom(classExpressions, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(OWLClassExpression ... classExpressions) {
        OWLDataFactoryImpl.checkNull(classExpressions, "classExpressions", true);
        HashSet<OWLClassExpression> clses = new HashSet<OWLClassExpression>();
        clses.addAll(Arrays.asList(classExpressions));
        return this.getOWLDisjointClassesAxiom(clses);
    }

    @Override
    @Nonnull
    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(@Nonnull Set<? extends OWLDataPropertyExpression> properties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(properties, "properties", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointDataPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Override
    @Nonnull
    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(@Nonnull Set<? extends OWLDataPropertyExpression> properties) {
        return this.getOWLDisjointDataPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(OWLDataPropertyExpression ... dataProperties) {
        OWLDataFactoryImpl.checkNull(dataProperties, "properties", true);
        return this.getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet(dataProperties));
    }

    @Override
    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(OWLObjectPropertyExpression ... properties) {
        OWLDataFactoryImpl.checkNull(properties, "properties", true);
        return this.getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet(properties));
    }

    @Override
    @Nonnull
    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(@Nonnull Set<? extends OWLObjectPropertyExpression> properties) {
        return this.getOWLDisjointObjectPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(@Nonnull Set<? extends OWLObjectPropertyExpression> properties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(properties, "properties", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointObjectPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Override
    @Nonnull
    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(@Nonnull Set<? extends OWLClassExpression> classExpressions, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(classExpressions, "classExpressions", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentClassesAxiomImpl(classExpressions, annotations);
    }

    @Override
    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(OWLClassExpression clsA, OWLClassExpression clsB) {
        OWLAPIPreconditions.checkNotNull(clsA, "clsA cannot be null");
        OWLAPIPreconditions.checkNotNull(clsB, "clsB cannot be null");
        return this.getOWLEquivalentClassesAxiom(clsA, clsB, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(OWLClassExpression clsA, OWLClassExpression clsB, Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(clsA, "clsA cannot be null");
        OWLAPIPreconditions.checkNotNull(clsB, "clsB cannot be null");
        return this.getOWLEquivalentClassesAxiom(CollectionFactory.createSet(new OWLClassExpression[]{clsA, clsB}), annotations);
    }

    @Override
    @Nonnull
    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(OWLClassExpression ... classExpressions) {
        OWLDataFactoryImpl.checkNull(classExpressions, "classExpressions", true);
        HashSet<OWLClassExpression> clses = new HashSet<OWLClassExpression>();
        clses.addAll(Arrays.asList(classExpressions));
        return this.getOWLEquivalentClassesAxiom(clses);
    }

    @Override
    @Nonnull
    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(@Nonnull Set<? extends OWLClassExpression> classExpressions) {
        return this.getOWLEquivalentClassesAxiom(classExpressions, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(@Nonnull Set<? extends OWLDataPropertyExpression> properties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(properties, "properties", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentDataPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Override
    @Nonnull
    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(@Nonnull Set<? extends OWLDataPropertyExpression> properties) {
        return this.getOWLEquivalentDataPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(OWLDataPropertyExpression propertyA, OWLDataPropertyExpression propertyB) {
        return this.getOWLEquivalentDataPropertiesAxiom(propertyA, propertyB, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(OWLDataPropertyExpression propertyA, OWLDataPropertyExpression propertyB, Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(propertyA, "propertyA cannot be null");
        OWLAPIPreconditions.checkNotNull(propertyB, "propertyB cannot be null");
        return this.getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet(new OWLDataPropertyExpression[]{propertyA, propertyB}), annotations);
    }

    @Override
    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(OWLDataPropertyExpression ... properties) {
        OWLDataFactoryImpl.checkNull(properties, "properties", true);
        return this.getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet(properties));
    }

    @Override
    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(OWLObjectPropertyExpression ... properties) {
        OWLDataFactoryImpl.checkNull(properties, "properties", true);
        return this.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet(properties));
    }

    @Override
    @Nonnull
    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(@Nonnull Set<? extends OWLObjectPropertyExpression> properties) {
        return this.getOWLEquivalentObjectPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(OWLObjectPropertyExpression propertyA, OWLObjectPropertyExpression propertyB) {
        OWLAPIPreconditions.checkNotNull(propertyA, "propertyA cannot be null");
        OWLAPIPreconditions.checkNotNull(propertyB, "propertyB cannot be null");
        return this.getOWLEquivalentObjectPropertiesAxiom(propertyA, propertyB, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(OWLObjectPropertyExpression propertyA, OWLObjectPropertyExpression propertyB, Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(propertyA, "propertyA cannot be null");
        OWLAPIPreconditions.checkNotNull(propertyB, "propertyB cannot be null");
        return this.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet(new OWLObjectPropertyExpression[]{propertyA, propertyB}), annotations);
    }

    @Override
    @Nonnull
    public OWLFunctionalDataPropertyAxiom getOWLFunctionalDataPropertyAxiom(OWLDataPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLFunctionalDataPropertyAxiomImpl(property, annotations);
    }

    @Override
    @Nonnull
    public OWLFunctionalDataPropertyAxiom getOWLFunctionalDataPropertyAxiom(OWLDataPropertyExpression property) {
        return this.getOWLFunctionalDataPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLFunctionalObjectPropertyAxiom getOWLFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    @Override
    @Nonnull
    public OWLFunctionalObjectPropertyAxiom getOWLFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLFunctionalObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLImportsDeclaration getOWLImportsDeclaration(IRI importedOntologyIRI) {
        OWLAPIPreconditions.checkNotNull(importedOntologyIRI, "importedOntologyIRI cannot be null");
        return new OWLImportsDeclarationImpl(importedOntologyIRI);
    }

    @Override
    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    @Override
    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, int value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, double value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, float value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, boolean value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, String value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLNegativeDataPropertyAssertionAxiom getOWLNegativeDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object) {
        return this.getOWLNegativeDataPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLNegativeDataPropertyAssertionAxiom getOWLNegativeDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLNegativeDataPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    @Override
    @Nonnull
    public OWLNegativeObjectPropertyAssertionAxiom getOWLNegativeObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object) {
        return this.getOWLNegativeObjectPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLNegativeObjectPropertyAssertionAxiom getOWLNegativeObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLNegativeObjectPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    @Override
    @Nonnull
    public OWLObjectPropertyAssertionAxiom getOWLObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual individual, OWLIndividual object) {
        return this.getOWLObjectPropertyAssertionAxiom(property, individual, object, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLClassAssertionAxiom getOWLClassAssertionAxiom(OWLClassExpression classExpression, OWLIndividual individual) {
        return this.getOWLClassAssertionAxiom(classExpression, individual, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLClassAssertionAxiom getOWLClassAssertionAxiom(OWLClassExpression classExpression, OWLIndividual individual, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull(individual, "individual cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLClassAssertionAxiomImpl(individual, classExpression, annotations);
    }

    @Override
    @Nonnull
    public OWLInverseFunctionalObjectPropertyAxiom getOWLInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLInverseFunctionalObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLInverseFunctionalObjectPropertyAxiom getOWLInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLInverseFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    @Override
    @Nonnull
    public OWLIrreflexiveObjectPropertyAxiom getOWLIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLIrreflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    @Override
    @Nonnull
    public OWLReflexiveObjectPropertyAxiom getOWLReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLReflexiveObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLIrreflexiveObjectPropertyAxiom getOWLIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLIrreflexiveObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLObjectPropertyDomainAxiom getOWLObjectPropertyDomainAxiom(OWLObjectPropertyExpression property, OWLClassExpression classExpression, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyDomainAxiomImpl(property, classExpression, annotations);
    }

    @Override
    @Nonnull
    public OWLObjectPropertyDomainAxiom getOWLObjectPropertyDomainAxiom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        return this.getOWLObjectPropertyDomainAxiom(property, classExpression, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLObjectPropertyRangeAxiom getOWLObjectPropertyRangeAxiom(OWLObjectPropertyExpression property, OWLClassExpression range, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(range, "range cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyRangeAxiomImpl(property, range, annotations);
    }

    @Override
    @Nonnull
    public OWLObjectPropertyRangeAxiom getOWLObjectPropertyRangeAxiom(OWLObjectPropertyExpression property, OWLClassExpression range) {
        return this.getOWLObjectPropertyRangeAxiom(property, range, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLSubObjectPropertyOfAxiom getOWLSubObjectPropertyOfAxiom(OWLObjectPropertyExpression subProperty, OWLObjectPropertyExpression superProperty, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(subProperty, "subProperty cannot be null");
        OWLAPIPreconditions.checkNotNull(superProperty, "superProperty cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubObjectPropertyOfAxiomImpl(subProperty, superProperty, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Override
    @Nonnull
    public OWLSubObjectPropertyOfAxiom getOWLSubObjectPropertyOfAxiom(OWLObjectPropertyExpression subProperty, OWLObjectPropertyExpression superProperty) {
        return this.getOWLSubObjectPropertyOfAxiom(subProperty, superProperty, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLReflexiveObjectPropertyAxiom getOWLReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLReflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    @Override
    @Nonnull
    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(@Nonnull Set<? extends OWLIndividual> individuals, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(individuals, "individuals", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSameIndividualAxiomImpl(individuals, annotations);
    }

    @Override
    @Nonnull
    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(OWLIndividual ... individual) {
        OWLDataFactoryImpl.checkNull(individual, "individuals", true);
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        inds.addAll(Arrays.asList(individual));
        return this.getOWLSameIndividualAxiom(inds);
    }

    @Override
    @Nonnull
    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(@Nonnull Set<? extends OWLIndividual> individuals) {
        return this.getOWLSameIndividualAxiom(individuals, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLSubClassOfAxiom getOWLSubClassOfAxiom(OWLClassExpression subClass, OWLClassExpression superClass, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(subClass, "subclass cannot be null");
        OWLAPIPreconditions.checkNotNull(superClass, "superclass cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubClassOfAxiomImpl(subClass, superClass, annotations);
    }

    @Override
    @Nonnull
    public OWLSubClassOfAxiom getOWLSubClassOfAxiom(OWLClassExpression subClass, OWLClassExpression superClass) {
        return this.getOWLSubClassOfAxiom(subClass, superClass, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLSymmetricObjectPropertyAxiom getOWLSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSymmetricObjectPropertyAxiomImpl(property, annotations);
    }

    @Override
    @Nonnull
    public OWLSymmetricObjectPropertyAxiom getOWLSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLSymmetricObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLTransitiveObjectPropertyAxiom getOWLTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLTransitiveObjectPropertyAxiomImpl(property, annotations);
    }

    @Override
    @Nonnull
    public OWLTransitiveObjectPropertyAxiom getOWLTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLTransitiveObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLObjectInverseOf getOWLObjectInverseOf(OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        if (!(property instanceof OWLObjectProperty)) {
            throw new IllegalArgumentException("ObjectInverseOf can only be applied to Object Properties");
        }
        return new OWLObjectInverseOfImpl(property);
    }

    @Override
    @Nonnull
    public OWLInverseObjectPropertiesAxiom getOWLInverseObjectPropertiesAxiom(OWLObjectPropertyExpression forwardProperty, OWLObjectPropertyExpression inverseProperty, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(forwardProperty, "forwardProperty cannot be null");
        OWLAPIPreconditions.checkNotNull(inverseProperty, "inverseProperty cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLInverseObjectPropertiesAxiomImpl(forwardProperty, inverseProperty, annotations);
    }

    @Override
    @Nonnull
    public OWLInverseObjectPropertiesAxiom getOWLInverseObjectPropertiesAxiom(OWLObjectPropertyExpression forwardProperty, OWLObjectPropertyExpression inverseProperty) {
        return this.getOWLInverseObjectPropertiesAxiom(forwardProperty, inverseProperty, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLSubPropertyChainOfAxiom getOWLSubPropertyChainOfAxiom(@Nonnull List<? extends OWLObjectPropertyExpression> chain, OWLObjectPropertyExpression superProperty, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(superProperty, "superProperty cannot be null");
        OWLDataFactoryImpl.checkNull(chain, "chain", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubPropertyChainAxiomImpl(chain, superProperty, annotations);
    }

    @Override
    @Nonnull
    public OWLSubPropertyChainOfAxiom getOWLSubPropertyChainOfAxiom(@Nonnull List<? extends OWLObjectPropertyExpression> chain, OWLObjectPropertyExpression superProperty) {
        return this.getOWLSubPropertyChainOfAxiom(chain, superProperty, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, @Nonnull Set<? extends OWLPropertyExpression> objectProperties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(ce, "classExpression cannot be null");
        OWLDataFactoryImpl.checkNull(objectProperties, "properties", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLHasKeyAxiomImpl(ce, objectProperties, annotations);
    }

    @Override
    @Nonnull
    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, @Nonnull Set<? extends OWLPropertyExpression> properties) {
        return this.getOWLHasKeyAxiom(ce, properties, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, OWLPropertyExpression ... properties) {
        OWLAPIPreconditions.checkNotNull(ce, "classExpression cannot be null");
        OWLDataFactoryImpl.checkNull(properties, "properties", true);
        return this.getOWLHasKeyAxiom(ce, CollectionFactory.createSet(properties));
    }

    @Override
    @Nonnull
    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass owlClass, @Nonnull Set<? extends OWLClassExpression> classExpressions, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(owlClass, "owlClass cannot be null");
        OWLDataFactoryImpl.checkNull(classExpressions, "classExpressions", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointUnionAxiomImpl(owlClass, classExpressions, annotations);
    }

    @Override
    @Nonnull
    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass owlClass, @Nonnull Set<? extends OWLClassExpression> classExpressions) {
        return this.getOWLDisjointUnionAxiom(owlClass, classExpressions, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(@Nonnull Set<? extends OWLObjectPropertyExpression> properties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(properties, "properties", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentObjectPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Override
    @Nonnull
    public OWLObjectPropertyAssertionAxiom getOWLObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual individual, OWLIndividual object, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(individual, "individual cannot be null");
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyAssertionAxiomImpl(individual, property, object, annotations);
    }

    @Override
    @Nonnull
    public OWLSubAnnotationPropertyOfAxiom getOWLSubAnnotationPropertyOfAxiom(OWLAnnotationProperty sub, OWLAnnotationProperty sup) {
        return this.getOWLSubAnnotationPropertyOfAxiom(sub, sup, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLSubAnnotationPropertyOfAxiom getOWLSubAnnotationPropertyOfAxiom(OWLAnnotationProperty sub, OWLAnnotationProperty sup, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(sub, "subProperty cannot be null");
        OWLAPIPreconditions.checkNotNull(sup, "superProperty cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubAnnotationPropertyOfAxiomImpl(sub, sup, annotations);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        return this.dataFactoryInternals.getOWLAnnotationProperty(iri);
    }

    @Override
    @Nonnull
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value) {
        return this.getOWLAnnotation(property, value, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(value, "value cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return this.dataFactoryInternals.getOWLAnnotation(property, value, annotations);
    }

    @Override
    @Nonnull
    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, @Nonnull OWLAnnotation annotation) {
        OWLAPIPreconditions.checkNotNull(annotation, "annotation cannot be null");
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotation.getAnnotations());
    }

    @Override
    @Nonnull
    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, @Nonnull OWLAnnotation annotation, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(annotation, "annotation cannot be null");
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotations);
    }

    @Override
    @Nonnull
    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationProperty property, OWLAnnotationSubject subject, OWLAnnotationValue value) {
        return this.getOWLAnnotationAssertionAxiom(property, subject, value, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationProperty property, OWLAnnotationSubject subject, OWLAnnotationValue value, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(value, "value cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationAssertionAxiomImpl(subject, property, value, annotations);
    }

    @Override
    public OWLAnnotationAssertionAxiom getDeprecatedOWLAnnotationAssertionAxiom(IRI subject) {
        OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        return this.getOWLAnnotationAssertionAxiom(this.getOWLDeprecated(), subject, this.getOWLLiteral(true));
    }

    @Override
    @Nonnull
    public OWLAnnotationPropertyDomainAxiom getOWLAnnotationPropertyDomainAxiom(OWLAnnotationProperty prop, IRI domain, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(prop, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(domain, "domain cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationPropertyDomainAxiomImpl(prop, domain, annotations);
    }

    @Override
    @Nonnull
    public OWLAnnotationPropertyDomainAxiom getOWLAnnotationPropertyDomainAxiom(OWLAnnotationProperty prop, IRI domain) {
        return this.getOWLAnnotationPropertyDomainAxiom(prop, domain, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLAnnotationPropertyRangeAxiom getOWLAnnotationPropertyRangeAxiom(OWLAnnotationProperty prop, IRI range, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(prop, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(range, "range cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationPropertyRangeAxiomImpl(prop, range, annotations);
    }

    @Override
    @Nonnull
    public OWLAnnotationPropertyRangeAxiom getOWLAnnotationPropertyRangeAxiom(OWLAnnotationProperty prop, IRI range) {
        return this.getOWLAnnotationPropertyRangeAxiom(prop, range, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public SWRLRule getSWRLRule(@Nonnull Set<? extends SWRLAtom> body, @Nonnull Set<? extends SWRLAtom> head, @Nonnull Set<OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(body, "body", true);
        OWLDataFactoryImpl.checkNull(head, "head", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new SWRLRuleImpl(body, head, annotations);
    }

    @Override
    @Nonnull
    public SWRLRule getSWRLRule(@Nonnull Set<? extends SWRLAtom> body, @Nonnull Set<? extends SWRLAtom> head) {
        OWLDataFactoryImpl.checkNull(body, "antecedent", true);
        OWLDataFactoryImpl.checkNull(head, "consequent", true);
        return new SWRLRuleImpl(body, head);
    }

    @Override
    @Nonnull
    public SWRLClassAtom getSWRLClassAtom(OWLClassExpression predicate, SWRLIArgument arg) {
        OWLAPIPreconditions.checkNotNull(predicate, "predicate cannot be null");
        OWLAPIPreconditions.checkNotNull(arg, "arg cannot be null");
        return new SWRLClassAtomImpl(predicate, arg);
    }

    @Override
    @Nonnull
    public SWRLDataRangeAtom getSWRLDataRangeAtom(OWLDataRange predicate, SWRLDArgument arg) {
        OWLAPIPreconditions.checkNotNull(predicate, "predicate cannot be null");
        OWLAPIPreconditions.checkNotNull(arg, "arg cannot be null");
        return new SWRLDataRangeAtomImpl(predicate, arg);
    }

    @Override
    @Nonnull
    public SWRLObjectPropertyAtom getSWRLObjectPropertyAtom(OWLObjectPropertyExpression property, SWRLIArgument arg0, SWRLIArgument arg1) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(arg0, "arg0 cannot be null");
        OWLAPIPreconditions.checkNotNull(arg1, "arg1 cannot be null");
        return new SWRLObjectPropertyAtomImpl(property, arg0, arg1);
    }

    @Override
    @Nonnull
    public SWRLDataPropertyAtom getSWRLDataPropertyAtom(OWLDataPropertyExpression property, SWRLIArgument arg0, SWRLDArgument arg1) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(arg0, "arg0 cannot be null");
        OWLAPIPreconditions.checkNotNull(arg1, "arg1 cannot be null");
        return new SWRLDataPropertyAtomImpl(property, arg0, arg1);
    }

    @Override
    @Nonnull
    public SWRLBuiltInAtom getSWRLBuiltInAtom(IRI builtInIRI, List<SWRLDArgument> args) {
        OWLAPIPreconditions.checkNotNull(builtInIRI, "builtInIRI cannot be null");
        OWLAPIPreconditions.checkNotNull(args, "args cannot be null");
        return new SWRLBuiltInAtomImpl(builtInIRI, args);
    }

    @Override
    @Nonnull
    public SWRLVariable getSWRLVariable(IRI var) {
        OWLAPIPreconditions.checkNotNull(var, "var cannot be null");
        return new SWRLVariableImpl(var);
    }

    @Override
    @Nonnull
    public SWRLIndividualArgument getSWRLIndividualArgument(OWLIndividual individual) {
        OWLAPIPreconditions.checkNotNull(individual, "individual cannot be null");
        return new SWRLIndividualArgumentImpl(individual);
    }

    @Override
    @Nonnull
    public SWRLLiteralArgument getSWRLLiteralArgument(OWLLiteral literal) {
        OWLAPIPreconditions.checkNotNull(literal, "literal");
        return new SWRLLiteralArgumentImpl(literal);
    }

    @Override
    @Nonnull
    public SWRLDifferentIndividualsAtom getSWRLDifferentIndividualsAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        OWLAPIPreconditions.checkNotNull(arg0, "arg0 cannot be null");
        OWLAPIPreconditions.checkNotNull(arg1, "arg1 cannot be null");
        return new SWRLDifferentIndividualsAtomImpl(this.getOWLObjectProperty(OWLRDFVocabulary.OWL_DIFFERENT_FROM.getIRI()), arg0, arg1);
    }

    @Override
    @Nonnull
    public SWRLSameIndividualAtom getSWRLSameIndividualAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        OWLAPIPreconditions.checkNotNull(arg0, "arg0 cannot be null");
        OWLAPIPreconditions.checkNotNull(arg1, "arg1 cannot be null");
        return new SWRLSameIndividualAtomImpl(this.getOWLObjectProperty(OWLRDFVocabulary.OWL_SAME_AS.getIRI()), arg0, arg1);
    }

    @Override
    @Nonnull
    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull(datatype, "datatype cannot be null");
        OWLAPIPreconditions.checkNotNull(dataRange, "dataRange cannot be null");
        return this.getOWLDatatypeDefinitionAxiom(datatype, dataRange, EMPTY_ANNOTATIONS_SET);
    }

    @Override
    @Nonnull
    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWLDataRange dataRange, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(datatype, "datatype cannot be null");
        OWLAPIPreconditions.checkNotNull(dataRange, "dataRange cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDatatypeDefinitionAxiomImpl(datatype, dataRange, annotations);
    }

    @Override
    public OWLLiteral getOWLLiteral(String lexicalValue, OWLDatatype datatype) {
        OWLAPIPreconditions.checkNotNull(lexicalValue, "lexicalValue cannot be null");
        OWLAPIPreconditions.checkNotNull(datatype, "datatype cannot be null");
        return this.dataFactoryInternals.getOWLLiteral(lexicalValue, datatype);
    }

    @Override
    public OWLLiteral getOWLLiteral(int value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    @Override
    public OWLLiteral getOWLLiteral(double value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    @Override
    public OWLLiteral getOWLLiteral(float value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    @Override
    public OWLLiteral getOWLLiteral(String value) {
        OWLAPIPreconditions.checkNotNull(value, "value cannot be null");
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    @Override
    public OWLLiteral getOWLLiteral(String literal, String lang) {
        OWLAPIPreconditions.checkNotNull(literal, "literal cannot be null");
        return this.dataFactoryInternals.getOWLLiteral(literal, lang);
    }

    @Override
    public OWLDatatype getBooleanOWLDatatype() {
        return this.dataFactoryInternals.getBooleanOWLDatatype();
    }

    @Override
    public OWLDatatype getDoubleOWLDatatype() {
        return this.dataFactoryInternals.getDoubleOWLDatatype();
    }

    @Override
    public OWLDatatype getFloatOWLDatatype() {
        return this.dataFactoryInternals.getFloatOWLDatatype();
    }

    @Override
    public OWLDatatype getIntegerOWLDatatype() {
        return this.dataFactoryInternals.getIntegerOWLDatatype();
    }

    @Override
    public OWLDatatype getTopDatatype() {
        return this.dataFactoryInternals.getTopDatatype();
    }

    @Override
    public OWLDatatype getRDFPlainLiteral() {
        return this.dataFactoryInternals.getRDFPlainLiteral();
    }
}

