// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32G07x.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32g07x

// STM32G07x
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32G07x"
)

// Interrupt numbers.
const (
	IRQ_WWDG                  = 0  // System window watchdog
	IRQ_PVD                   = 1  // Power control
	IRQ_RTC_STAMP             = 2  // Real-time clock
	IRQ_FLASH                 = 3  // Flash
	IRQ_RCC                   = 4  // Reset and clock control
	IRQ_EXTI0_1               = 5  // External interrupt/event controller
	IRQ_EXTI2_3               = 6  // External interrupt/event controller
	IRQ_EXTI4_15              = 7  // External interrupt/event controller
	IRQ_UCPD1_UCPD2           = 8  // USB Power Delivery interface
	IRQ_DMA_Channel1          = 9  // DMA controller
	IRQ_DMA_Channel2_3        = 10 // DMA controller
	IRQ_DMA_Channel4_5_6_7    = 11 // DMAMUX
	IRQ_ADC_COMP              = 12 // Analog to Digital Converter instance 1
	IRQ_TIM1_BRK_UP_TRG_COMP  = 13 // Advanced-timers
	IRQ_TIM1_CC               = 14 // Advanced-timers
	IRQ_TIM2                  = 15 // General-purpose-timers
	IRQ_TIM3                  = 16 // General-purpose-timers
	IRQ_TIM6_DAC_LPTIM1       = 17 // Basic timers
	IRQ_TIM7_LPTIM2           = 18 //
	IRQ_TIM14                 = 19 // General purpose timers
	IRQ_TIM15                 = 20 //
	IRQ_TIM16                 = 21 // General purpose timers
	IRQ_TIM17                 = 22 //
	IRQ_I2C1                  = 23 // Inter-integrated circuit
	IRQ_I2C2                  = 24 //
	IRQ_SPI1                  = 25 // Serial peripheral interface/Inter-IC sound
	IRQ_SPI2                  = 26 //
	IRQ_USART1                = 27 // Universal synchronous asynchronous receiver transmitter
	IRQ_USART2                = 28 //
	IRQ_USART3_USART4_LPUART1 = 29 //
	IRQ_CEC                   = 30 // Cyclic redundancy check calculation unit
	IRQ_AES_RNG               = 31 // Advanced encryption standard hardware accelerator 1
	IRQ_max                   = 31 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_STAMP, "RTC_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0_1, "EXTI0_1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2_3, "EXTI2_3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4_15, "EXTI4_15_IRQHandler")
	_ = interrupt.Register(IRQ_UCPD1_UCPD2, "UCPD1_UCPD2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_Channel1, "DMA_Channel1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_Channel2_3, "DMA_Channel2_3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_Channel4_5_6_7, "DMA_Channel4_5_6_7_IRQHandler")
	_ = interrupt.Register(IRQ_ADC_COMP, "ADC_COMP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_UP_TRG_COMP, "TIM1_BRK_UP_TRG_COMP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DAC_LPTIM1, "TIM6_DAC_LPTIM1_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7_LPTIM2, "TIM7_LPTIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM14, "TIM14_IRQHandler")
	_ = interrupt.Register(IRQ_TIM15, "TIM15_IRQHandler")
	_ = interrupt.Register(IRQ_TIM16, "TIM16_IRQHandler")
	_ = interrupt.Register(IRQ_TIM17, "TIM17_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1, "I2C1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2, "I2C2_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3_USART4_LPUART1, "USART3_USART4_LPUART1_IRQHandler")
	_ = interrupt.Register(IRQ_CEC, "CEC_IRQHandler")
	_ = interrupt.Register(IRQ_AES_RNG, "AES_RNG_IRQHandler")
)

// Peripherals.
var (
	IWDG           = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))   // Independent watchdog
	WWDG           = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))   // System window watchdog
	FLASH          = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))  // Flash
	DBG            = (*DBG_Type)(unsafe.Pointer(uintptr(0x40015800)))    // Debug support
	RCC            = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))    // Reset and clock control
	PWR            = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))    // Power control
	DMA            = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))    // DMA controller
	DMAMUX         = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800))) // DMAMUX
	GPIOA          = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))   // General-purpose I/Os
	GPIOB          = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000400)))   // General-purpose I/Os
	AES            = (*AES_Type)(unsafe.Pointer(uintptr(0x40026000)))    // Advanced encryption standard hardware accelerator 1
	RNG            = (*RNG_Type)(unsafe.Pointer(uintptr(0x40025000)))    // Random number generator
	CRC            = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))    // Cyclic redundancy check calculation unit
	EXTI           = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40021800)))   // External interrupt/event controller
	TIM16          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))    // General purpose timers
	USART1         = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))  // Universal synchronous asynchronous receiver transmitter
	SPI1           = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))    // Serial peripheral interface/Inter-IC sound
	TIM1           = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))    // Advanced-timers
	ADC            = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))    // Analog to Digital Converter instance 1
	COMP           = (*COMP1_Type)(unsafe.Pointer(uintptr(0x40010200)))  // COMP1
	SYSCFG_VREFBUF = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000))) // System configuration controller
	TAMP           = (*TAMP_Type)(unsafe.Pointer(uintptr(0x4000b000)))   // Tamper and backup registers
	UCPD1          = (*UCPD_Type)(unsafe.Pointer(uintptr(0x4000a000)))   // USB Power Delivery interface
	LPTIM1         = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))  // Low power timer
	LPUART         = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))  // Universal synchronous asynchronous receiver transmitter
	HDMI_CEC       = (*CEC_Type)(unsafe.Pointer(uintptr(0x40007800)))    // HDMI-CEC
	DAC            = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))    // DAC
	I2C1           = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))    // Inter-integrated circuit
	RTC            = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))    // Real-time clock
	TIM14          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))    // General purpose timers
	TIM6           = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))    // Basic timers
	TIM2           = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))    // General-purpose-timers
	NVIC           = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))   // Nested Vectored Interrupt Controller
	MPU            = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))    // Memory protection unit
	STK            = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))    // SysTick timer
	SCB            = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))    // System control block
	GPIOC          = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000800)))   // General-purpose I/Os
	GPIOD          = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000c00)))   // General-purpose I/Os
	GPIOF          = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001400)))   // General-purpose I/Os
	TIM17          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))    // General purpose timers
	TIM15          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))    // General purpose timers
	USART2         = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))  // Universal synchronous asynchronous receiver transmitter
	USART3         = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))  // Universal synchronous asynchronous receiver transmitter
	USART4         = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))  // Universal synchronous asynchronous receiver transmitter
	SPI2           = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))    // Serial peripheral interface/Inter-IC sound
	UCPD2          = (*UCPD_Type)(unsafe.Pointer(uintptr(0x4000a400)))   // USB Power Delivery interface
	LPTIM2         = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))  // Low power timer
	I2C2           = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))    // Inter-integrated circuit
	TIM7           = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))    // Basic timers
	TIM3           = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))    // General-purpose-timers
)

// Independent watchdog
type IWDG_Type struct {
	KR     volatile.Register32 // 0x0
	PR     volatile.Register32 // 0x4
	RLR    volatile.Register32 // 0x8
	SR     volatile.Register32 // 0xC
	WINR   volatile.Register32 // 0x10
	_      [988]byte
	HWCFGR volatile.Register32 // 0x3F0
	VERR   volatile.Register32 // 0x3F4
	IPIDR  volatile.Register32 // 0x3F8
	SIDR   volatile.Register32 // 0x3FC
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Flash
type Flash_Type struct {
	ACR       volatile.Register32 // 0x0
	_         [4]byte
	KEYR      volatile.Register32 // 0x8
	OPTKEYR   volatile.Register32 // 0xC
	SR        volatile.Register32 // 0x10
	CR        volatile.Register32 // 0x14
	ECCR      volatile.Register32 // 0x18
	_         [4]byte
	OPTR      volatile.Register32 // 0x20
	PCROP1ASR volatile.Register32 // 0x24
	PCROP1AER volatile.Register32 // 0x28
	WRP1AR    volatile.Register32 // 0x2C
	WRP1BR    volatile.Register32 // 0x30
	PCROP1BSR volatile.Register32 // 0x34
	PCROP1BER volatile.Register32 // 0x38
	_         [68]byte
	SECR      volatile.Register32 // 0x80
}

// Debug support
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB_FZ1 volatile.Register32 // 0x8
	APB_FZ2 volatile.Register32 // 0xC
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	ICSCR      volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	PLLSYSCFGR volatile.Register32 // 0xC
	_          [8]byte
	CIER       volatile.Register32 // 0x18
	CIFR       volatile.Register32 // 0x1C
	CICR       volatile.Register32 // 0x20
	IOPRSTR    volatile.Register32 // 0x24
	AHBRSTR    volatile.Register32 // 0x28
	APBRSTR1   volatile.Register32 // 0x2C
	APBRSTR2   volatile.Register32 // 0x30
	IOPENR     volatile.Register32 // 0x34
	AHBENR     volatile.Register32 // 0x38
	APBENR1    volatile.Register32 // 0x3C
	APBENR2    volatile.Register32 // 0x40
	IOPSMENR   volatile.Register32 // 0x44
	AHBSMENR   volatile.Register32 // 0x48
	APBSMENR1  volatile.Register32 // 0x4C
	APBSMENR2  volatile.Register32 // 0x50
	CCIPR      volatile.Register32 // 0x54
	_          [4]byte
	BDCR       volatile.Register32 // 0x5C
	CSR        volatile.Register32 // 0x60
}

// Power control
type PWR_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	CR4   volatile.Register32 // 0xC
	SR1   volatile.Register32 // 0x10
	SR2   volatile.Register32 // 0x14
	SCR   volatile.Register32 // 0x18
	_     [4]byte
	PUCRA volatile.Register32 // 0x20
	PDCRA volatile.Register32 // 0x24
	PUCRB volatile.Register32 // 0x28
	PDCRB volatile.Register32 // 0x2C
	PUCRC volatile.Register32 // 0x30
	PDCRC volatile.Register32 // 0x34
	PUCRD volatile.Register32 // 0x38
	PDCRD volatile.Register32 // 0x3C
	_     [8]byte
	PUCRF volatile.Register32 // 0x48
	PDCRF volatile.Register32 // 0x4C
}

// DMA controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// DMAMUX
type DMAMUX_Type struct {
	DMAMUX_C0CR    volatile.Register32 // 0x0
	DMAMUX_C1CR    volatile.Register32 // 0x4
	DMAMUX_C2CR    volatile.Register32 // 0x8
	DMAMUX_C3CR    volatile.Register32 // 0xC
	DMAMUX_C4CR    volatile.Register32 // 0x10
	DMAMUX_C5CR    volatile.Register32 // 0x14
	DMAMUX_C6CR    volatile.Register32 // 0x18
	_              [100]byte
	DMAMUX_CSR     volatile.Register32 // 0x80
	DMAMUX_CFR     volatile.Register32 // 0x84
	_              [120]byte
	DMAMUX_RG0CR   volatile.Register32 // 0x100
	DMAMUX_RG1CR   volatile.Register32 // 0x104
	DMAMUX_RG2CR   volatile.Register32 // 0x108
	DMAMUX_RG3CR   volatile.Register32 // 0x10C
	_              [48]byte
	DMAMUX_RGSR    volatile.Register32 // 0x140
	DMAMUX_RGCFR   volatile.Register32 // 0x144
	_              [676]byte
	DMAMUX_HWCFGR2 volatile.Register32 // 0x3EC
	DMAMUX_HWCFGR1 volatile.Register32 // 0x3F0
	DMAMUX_VERR    volatile.Register32 // 0x3F4
	DMAMUX_IPIDR   volatile.Register32 // 0x3F8
	DMAMUX_SIDR    volatile.Register32 // 0x3FC
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// Advanced encryption standard hardware accelerator 1
type AES_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	DINR   volatile.Register32 // 0x8
	DOUTR  volatile.Register32 // 0xC
	KEYR0  volatile.Register32 // 0x10
	KEYR1  volatile.Register32 // 0x14
	KEYR2  volatile.Register32 // 0x18
	KEYR3  volatile.Register32 // 0x1C
	IVR0   volatile.Register32 // 0x20
	IVR1   volatile.Register32 // 0x24
	IVR2   volatile.Register32 // 0x28
	IVR3   volatile.Register32 // 0x2C
	KEYR4  volatile.Register32 // 0x30
	KEYR5  volatile.Register32 // 0x34
	KEYR6  volatile.Register32 // 0x38
	KEYR7  volatile.Register32 // 0x3C
	SUSP0R volatile.Register32 // 0x40
	SUSP1R volatile.Register32 // 0x44
	SUSP2R volatile.Register32 // 0x48
	SUSP3R volatile.Register32 // 0x4C
	SUSP4R volatile.Register32 // 0x50
	SUSP5R volatile.Register32 // 0x54
	SUSP6R volatile.Register32 // 0x58
	SUSP7R volatile.Register32 // 0x5C
	_      [912]byte
	HWCFR  volatile.Register32 // 0x3F0
	VERR   volatile.Register32 // 0x3F4
	IPIDR  volatile.Register32 // 0x3F8
	SIDR   volatile.Register32 // 0x3FC
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1   volatile.Register32 // 0x0
	FTSR1   volatile.Register32 // 0x4
	SWIER1  volatile.Register32 // 0x8
	RPR1    volatile.Register32 // 0xC
	FPR1    volatile.Register32 // 0x10
	_       [76]byte
	EXTICR1 volatile.Register32 // 0x60
	EXTICR2 volatile.Register32 // 0x64
	EXTICR3 volatile.Register32 // 0x68
	EXTICR4 volatile.Register32 // 0x6C
	_       [16]byte
	IMR1    volatile.Register32 // 0x80
	_       [12]byte
	IMR2    volatile.Register32 // 0x90
	EMR2    volatile.Register32 // 0x94
	_       [832]byte
	HWCFGR7 volatile.Register32 // 0x3D8
	HWCFGR6 volatile.Register32 // 0x3DC
	HWCFGR5 volatile.Register32 // 0x3E0
	HWCFGR4 volatile.Register32 // 0x3E4
	HWCFGR3 volatile.Register32 // 0x3E8
	HWCFGR2 volatile.Register32 // 0x3EC
	HWCFGR1 volatile.Register32 // 0x3F0
	VERR    volatile.Register32 // 0x3F4
	IPIDR   volatile.Register32 // 0x3F8
	SIDR    volatile.Register32 // 0x3FC
}

// General purpose timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	_            [4]byte
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	_            [4]byte
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	_            [12]byte
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	_            [16]byte
	AF1          volatile.Register32 // 0x60
	_            [4]byte
	TISEL        volatile.Register32 // 0x68
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	BRR   volatile.Register32 // 0xC
	GTPR  volatile.Register32 // 0x10
	RTOR  volatile.Register32 // 0x14
	RQR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	RDR   volatile.Register32 // 0x24
	TDR   volatile.Register32 // 0x28
	PRESC volatile.Register32 // 0x2C
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
	_       [972]byte
	HWCFGR  volatile.Register32 // 0x3F0
	VERR    volatile.Register32 // 0x3F4
	IPIDR   volatile.Register32 // 0x3F8
	SIDR    volatile.Register32 // 0x3FC
}

// Analog to Digital Converter instance 1
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR1   volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR    volatile.Register32 // 0x14
	_       [8]byte
	AWD1TR  volatile.Register32 // 0x20
	AWD2TR  volatile.Register32 // 0x24
	CHSELR  volatile.Register32 // 0x28
	AWD3TR  volatile.Register32 // 0x2C
	_       [16]byte
	DR      volatile.Register32 // 0x40
	_       [92]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [12]byte
	CALFACT volatile.Register32 // 0xB4
	_       [592]byte
	CCR     volatile.Register32 // 0x308
	_       [204]byte
	HWCFGR6 volatile.Register32 // 0x3D8
	HWCFGR5 volatile.Register32 // 0x3DC
	HWCFGR4 volatile.Register32 // 0x3E0
	HWCFGR3 volatile.Register32 // 0x3E4
	HWCFGR2 volatile.Register32 // 0x3E8
	HWCFGR1 volatile.Register32 // 0x3EC
	HWCFGR0 volatile.Register32 // 0x3F0
	VERR    volatile.Register32 // 0x3F4
	IPIDR   volatile.Register32 // 0x3F8
	SIDR    volatile.Register32 // 0x3FC
}

// COMP1
type COMP1_Type struct {
	COMP1_CSR volatile.Register32 // 0x0
	COMP2_CSR volatile.Register32 // 0x4
}

// System configuration controller
type SYSCFG_Type struct {
	CFGR1       volatile.Register32 // 0x0
	_           [20]byte
	CFGR2       volatile.Register32 // 0x18
	_           [20]byte
	VREFBUF_CSR volatile.Register32 // 0x30
	VREFBUF_CCR volatile.Register32 // 0x34
	_           [72]byte
	ITLINE0     volatile.Register32 // 0x80
	ITLINE1     volatile.Register32 // 0x84
	ITLINE2     volatile.Register32 // 0x88
	ITLINE3     volatile.Register32 // 0x8C
	ITLINE4     volatile.Register32 // 0x90
	ITLINE5     volatile.Register32 // 0x94
	ITLINE6     volatile.Register32 // 0x98
	ITLINE7     volatile.Register32 // 0x9C
	ITLINE8     volatile.Register32 // 0xA0
	ITLINE9     volatile.Register32 // 0xA4
	ITLINE10    volatile.Register32 // 0xA8
	ITLINE11    volatile.Register32 // 0xAC
	ITLINE12    volatile.Register32 // 0xB0
	ITLINE13    volatile.Register32 // 0xB4
	ITLINE14    volatile.Register32 // 0xB8
	ITLINE15    volatile.Register32 // 0xBC
	ITLINE16    volatile.Register32 // 0xC0
	ITLINE17    volatile.Register32 // 0xC4
	ITLINE18    volatile.Register32 // 0xC8
	ITLINE19    volatile.Register32 // 0xCC
	ITLINE20    volatile.Register32 // 0xD0
	ITLINE21    volatile.Register32 // 0xD4
	ITLINE22    volatile.Register32 // 0xD8
	ITLINE23    volatile.Register32 // 0xDC
	ITLINE24    volatile.Register32 // 0xE0
	ITLINE25    volatile.Register32 // 0xE4
	ITLINE26    volatile.Register32 // 0xE8
	ITLINE27    volatile.Register32 // 0xEC
	ITLINE28    volatile.Register32 // 0xF0
	ITLINE29    volatile.Register32 // 0xF4
	ITLINE30    volatile.Register32 // 0xF8
	ITLINE31    volatile.Register32 // 0xFC
}

// Tamper and backup registers
type TAMP_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	_       [4]byte
	FLTCR   volatile.Register32 // 0xC
	_       [28]byte
	IER     volatile.Register32 // 0x2C
	SR      volatile.Register32 // 0x30
	MISR    volatile.Register32 // 0x34
	_       [4]byte
	SCR     volatile.Register32 // 0x3C
	_       [192]byte
	BKP0R   volatile.Register32 // 0x100
	BKP1R   volatile.Register32 // 0x104
	BKP2R   volatile.Register32 // 0x108
	BKP3R   volatile.Register32 // 0x10C
	BKP4R   volatile.Register32 // 0x110
	_       [728]byte
	HWCFGR2 volatile.Register32 // 0x3EC
	HWCFGR1 volatile.Register32 // 0x3F0
	VERR    volatile.Register32 // 0x3F4
	IPIDR   volatile.Register32 // 0x3F8
	SIDR    volatile.Register32 // 0x3FC
}

// USB Power Delivery interface
type UCPD_Type struct {
	CFG1       volatile.Register32 // 0x0
	CFG2       volatile.Register32 // 0x4
	CFG3       volatile.Register32 // 0x8
	CR         volatile.Register32 // 0xC
	IMR        volatile.Register32 // 0x10
	SR         volatile.Register32 // 0x14
	ICR        volatile.Register32 // 0x18
	TX_ORDSET  volatile.Register32 // 0x1C
	TX_PAYSZ   volatile.Register32 // 0x20
	TXDR       volatile.Register32 // 0x24
	RX_ORDSET  volatile.Register32 // 0x28
	RX_PAYSZ   volatile.Register32 // 0x2C
	RXDR       volatile.Register32 // 0x30
	RX_ORDEXT1 volatile.Register32 // 0x34
	RX_ORDEXT2 volatile.Register32 // 0x38
	_          [952]byte
	IPVER      volatile.Register32 // 0x3F4
	IPID       volatile.Register32 // 0x3F8
	MID        volatile.Register32 // 0x3FC
}

// Low power timer
type LPTIM_Type struct {
	ISR   volatile.Register32 // 0x0
	ICR   volatile.Register32 // 0x4
	IER   volatile.Register32 // 0x8
	CFGR  volatile.Register32 // 0xC
	CR    volatile.Register32 // 0x10
	CMP   volatile.Register32 // 0x14
	ARR   volatile.Register32 // 0x18
	CNT   volatile.Register32 // 0x1C
	_     [4]byte
	CFGR2 volatile.Register32 // 0x24
}

// HDMI-CEC
type CEC_Type struct {
	CEC_CR   volatile.Register32 // 0x0
	CEC_CFGR volatile.Register32 // 0x4
	CEC_TXDR volatile.Register32 // 0x8
	CEC_RXDR volatile.Register32 // 0xC
	CEC_ISR  volatile.Register32 // 0x10
	CEC_IER  volatile.Register32 // 0x14
}

// DAC
type DAC_Type struct {
	DAC_CR      volatile.Register32 // 0x0
	DAC_SWTRGR  volatile.Register32 // 0x4
	DAC_DHR12R1 volatile.Register32 // 0x8
	DAC_DHR12L1 volatile.Register32 // 0xC
	DAC_DHR8R1  volatile.Register32 // 0x10
	DAC_DHR12R2 volatile.Register32 // 0x14
	DAC_DHR12L2 volatile.Register32 // 0x18
	DAC_DHR8R2  volatile.Register32 // 0x1C
	DAC_DHR12RD volatile.Register32 // 0x20
	DAC_DHR12LD volatile.Register32 // 0x24
	DAC_DHR8RD  volatile.Register32 // 0x28
	DAC_DOR1    volatile.Register32 // 0x2C
	DAC_DOR2    volatile.Register32 // 0x30
	DAC_SR      volatile.Register32 // 0x34
	DAC_CCR     volatile.Register32 // 0x38
	DAC_MCR     volatile.Register32 // 0x3C
	DAC_SHSR1   volatile.Register32 // 0x40
	DAC_SHSR2   volatile.Register32 // 0x44
	DAC_SHHR    volatile.Register32 // 0x48
	DAC_SHRR    volatile.Register32 // 0x4C
	_           [928]byte
	IP_HWCFGR0  volatile.Register32 // 0x3F0
	VERR        volatile.Register32 // 0x3F4
	IPIDR       volatile.Register32 // 0x3F8
	SIDR        volatile.Register32 // 0x3FC
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	SSR      volatile.Register32 // 0x8
	ICSR     volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CR       volatile.Register32 // 0x18
	_        [8]byte
	WPR      volatile.Register32 // 0x24
	CALR     volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBR   volatile.Register32 // 0x48
	ALRMBSSR volatile.Register32 // 0x4C
	SR       volatile.Register32 // 0x50
	MISR     volatile.Register32 // 0x54
	_        [4]byte
	SCR      volatile.Register32 // 0x5C
	_        [912]byte
	HWCFGR   volatile.Register32 // 0x3F0
	VERR     volatile.Register32 // 0x3F4
	IPIDR    volatile.Register32 // 0x3F8
	SIDR     volatile.Register32 // 0x3FC
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER volatile.Register32 // 0x0
	_    [124]byte
	ICER volatile.Register32 // 0x80
	_    [124]byte
	ISPR volatile.Register32 // 0x100
	_    [124]byte
	ICPR volatile.Register32 // 0x180
	_    [380]byte
	IPR0 volatile.Register32 // 0x300
	IPR1 volatile.Register32 // 0x304
	IPR2 volatile.Register32 // 0x308
	IPR3 volatile.Register32 // 0x30C
	IPR4 volatile.Register32 // 0x310
	IPR5 volatile.Register32 // 0x314
	IPR6 volatile.Register32 // 0x318
	IPR7 volatile.Register32 // 0x31C
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID volatile.Register32 // 0x0
	ICSR  volatile.Register32 // 0x4
	VTOR  volatile.Register32 // 0x8
	AIRCR volatile.Register32 // 0xC
	SCR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	_     [4]byte
	SHPR2 volatile.Register32 // 0x1C
	SHPR3 volatile.Register32 // 0x20
}

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register
	IWDG_SR_WVU_Pos = 0x2 // Position of WVU field.
	IWDG_SR_WVU_Msk = 0x4 // Bit mask of WVU field.
	IWDG_SR_WVU     = 0x4 // Bit WVU.
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.

	// WINR: Window register
	IWDG_WINR_WIN_Pos = 0x0   // Position of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff // Bit mask of WIN field.

	// HWCFGR: hardware configuration           register
	IWDG_HWCFGR_WINDOW_Pos     = 0x0  // Position of WINDOW field.
	IWDG_HWCFGR_WINDOW_Msk     = 0xf  // Bit mask of WINDOW field.
	IWDG_HWCFGR_PR_DEFAULT_Pos = 0x4  // Position of PR_DEFAULT field.
	IWDG_HWCFGR_PR_DEFAULT_Msk = 0xf0 // Bit mask of PR_DEFAULT field.

	// VERR: EXTI IP Version register
	IWDG_VERR_MINREV_Pos = 0x0  // Position of MINREV field.
	IWDG_VERR_MINREV_Msk = 0xf  // Bit mask of MINREV field.
	IWDG_VERR_MAJREV_Pos = 0x4  // Position of MAJREV field.
	IWDG_VERR_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.

	// IPIDR: EXTI Identification register
	IWDG_IPIDR_IPID_Pos = 0x0        // Position of IPID field.
	IWDG_IPIDR_IPID_Msk = 0xffffffff // Bit mask of IPID field.

	// SIDR: EXTI Size ID register
	IWDG_SIDR_SID_Pos = 0x0        // Position of SID field.
	IWDG_SIDR_SID_Msk = 0xffffffff // Bit mask of SID field.
)

// Bitfields for WWDG: System window watchdog
const (
	// CR: Control register
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.

	// CFR: Configuration register
	WWDG_CFR_WDGTB_Pos = 0xb    // Position of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x3800 // Bit mask of WDGTB field.
	WWDG_CFR_EWI_Pos   = 0x9    // Position of EWI field.
	WWDG_CFR_EWI_Msk   = 0x200  // Bit mask of EWI field.
	WWDG_CFR_EWI       = 0x200  // Bit EWI.
	WWDG_CFR_W_Pos     = 0x0    // Position of W field.
	WWDG_CFR_W_Msk     = 0x7f   // Bit mask of W field.

	// SR: Status register
	WWDG_SR_EWIF_Pos = 0x0 // Position of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1 // Bit mask of EWIF field.
	WWDG_SR_EWIF     = 0x1 // Bit EWIF.
)

// Bitfields for FLASH: Flash
const (
	// ACR: Access control register
	Flash_ACR_LATENCY_Pos  = 0x0     // Position of LATENCY field.
	Flash_ACR_LATENCY_Msk  = 0x7     // Bit mask of LATENCY field.
	Flash_ACR_PRFTEN_Pos   = 0x8     // Position of PRFTEN field.
	Flash_ACR_PRFTEN_Msk   = 0x100   // Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN       = 0x100   // Bit PRFTEN.
	Flash_ACR_ICEN_Pos     = 0x9     // Position of ICEN field.
	Flash_ACR_ICEN_Msk     = 0x200   // Bit mask of ICEN field.
	Flash_ACR_ICEN         = 0x200   // Bit ICEN.
	Flash_ACR_ICRST_Pos    = 0xb     // Position of ICRST field.
	Flash_ACR_ICRST_Msk    = 0x800   // Bit mask of ICRST field.
	Flash_ACR_ICRST        = 0x800   // Bit ICRST.
	Flash_ACR_EMPTY_Pos    = 0x10    // Position of EMPTY field.
	Flash_ACR_EMPTY_Msk    = 0x10000 // Bit mask of EMPTY field.
	Flash_ACR_EMPTY        = 0x10000 // Bit EMPTY.
	Flash_ACR_DBG_SWEN_Pos = 0x12    // Position of DBG_SWEN field.
	Flash_ACR_DBG_SWEN_Msk = 0x40000 // Bit mask of DBG_SWEN field.
	Flash_ACR_DBG_SWEN     = 0x40000 // Bit DBG_SWEN.

	// KEYR: Flash key register
	Flash_KEYR_KEYR_Pos = 0x0        // Position of KEYR field.
	Flash_KEYR_KEYR_Msk = 0xffffffff // Bit mask of KEYR field.

	// OPTKEYR: Option byte key register
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0        // Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff // Bit mask of OPTKEYR field.

	// SR: Status register
	Flash_SR_EOP_Pos     = 0x0     // Position of EOP field.
	Flash_SR_EOP_Msk     = 0x1     // Bit mask of EOP field.
	Flash_SR_EOP         = 0x1     // Bit EOP.
	Flash_SR_OPERR_Pos   = 0x1     // Position of OPERR field.
	Flash_SR_OPERR_Msk   = 0x2     // Bit mask of OPERR field.
	Flash_SR_OPERR       = 0x2     // Bit OPERR.
	Flash_SR_PROGERR_Pos = 0x3     // Position of PROGERR field.
	Flash_SR_PROGERR_Msk = 0x8     // Bit mask of PROGERR field.
	Flash_SR_PROGERR     = 0x8     // Bit PROGERR.
	Flash_SR_WRPERR_Pos  = 0x4     // Position of WRPERR field.
	Flash_SR_WRPERR_Msk  = 0x10    // Bit mask of WRPERR field.
	Flash_SR_WRPERR      = 0x10    // Bit WRPERR.
	Flash_SR_PGAERR_Pos  = 0x5     // Position of PGAERR field.
	Flash_SR_PGAERR_Msk  = 0x20    // Bit mask of PGAERR field.
	Flash_SR_PGAERR      = 0x20    // Bit PGAERR.
	Flash_SR_SIZERR_Pos  = 0x6     // Position of SIZERR field.
	Flash_SR_SIZERR_Msk  = 0x40    // Bit mask of SIZERR field.
	Flash_SR_SIZERR      = 0x40    // Bit SIZERR.
	Flash_SR_PGSERR_Pos  = 0x7     // Position of PGSERR field.
	Flash_SR_PGSERR_Msk  = 0x80    // Bit mask of PGSERR field.
	Flash_SR_PGSERR      = 0x80    // Bit PGSERR.
	Flash_SR_MISERR_Pos  = 0x8     // Position of MISERR field.
	Flash_SR_MISERR_Msk  = 0x100   // Bit mask of MISERR field.
	Flash_SR_MISERR      = 0x100   // Bit MISERR.
	Flash_SR_FASTERR_Pos = 0x9     // Position of FASTERR field.
	Flash_SR_FASTERR_Msk = 0x200   // Bit mask of FASTERR field.
	Flash_SR_FASTERR     = 0x200   // Bit FASTERR.
	Flash_SR_RDERR_Pos   = 0xe     // Position of RDERR field.
	Flash_SR_RDERR_Msk   = 0x4000  // Bit mask of RDERR field.
	Flash_SR_RDERR       = 0x4000  // Bit RDERR.
	Flash_SR_OPTVERR_Pos = 0xf     // Position of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x8000  // Bit mask of OPTVERR field.
	Flash_SR_OPTVERR     = 0x8000  // Bit OPTVERR.
	Flash_SR_BSY_Pos     = 0x10    // Position of BSY field.
	Flash_SR_BSY_Msk     = 0x10000 // Bit mask of BSY field.
	Flash_SR_BSY         = 0x10000 // Bit BSY.
	Flash_SR_CFGBSY_Pos  = 0x12    // Position of CFGBSY field.
	Flash_SR_CFGBSY_Msk  = 0x40000 // Bit mask of CFGBSY field.
	Flash_SR_CFGBSY      = 0x40000 // Bit CFGBSY.

	// CR: Flash control register
	Flash_CR_PG_Pos         = 0x0        // Position of PG field.
	Flash_CR_PG_Msk         = 0x1        // Bit mask of PG field.
	Flash_CR_PG             = 0x1        // Bit PG.
	Flash_CR_PER_Pos        = 0x1        // Position of PER field.
	Flash_CR_PER_Msk        = 0x2        // Bit mask of PER field.
	Flash_CR_PER            = 0x2        // Bit PER.
	Flash_CR_MER_Pos        = 0x2        // Position of MER field.
	Flash_CR_MER_Msk        = 0x4        // Bit mask of MER field.
	Flash_CR_MER            = 0x4        // Bit MER.
	Flash_CR_PNB_Pos        = 0x3        // Position of PNB field.
	Flash_CR_PNB_Msk        = 0x1f8      // Bit mask of PNB field.
	Flash_CR_STRT_Pos       = 0x10       // Position of STRT field.
	Flash_CR_STRT_Msk       = 0x10000    // Bit mask of STRT field.
	Flash_CR_STRT           = 0x10000    // Bit STRT.
	Flash_CR_OPTSTRT_Pos    = 0x11       // Position of OPTSTRT field.
	Flash_CR_OPTSTRT_Msk    = 0x20000    // Bit mask of OPTSTRT field.
	Flash_CR_OPTSTRT        = 0x20000    // Bit OPTSTRT.
	Flash_CR_FSTPG_Pos      = 0x12       // Position of FSTPG field.
	Flash_CR_FSTPG_Msk      = 0x40000    // Bit mask of FSTPG field.
	Flash_CR_FSTPG          = 0x40000    // Bit FSTPG.
	Flash_CR_EOPIE_Pos      = 0x18       // Position of EOPIE field.
	Flash_CR_EOPIE_Msk      = 0x1000000  // Bit mask of EOPIE field.
	Flash_CR_EOPIE          = 0x1000000  // Bit EOPIE.
	Flash_CR_ERRIE_Pos      = 0x19       // Position of ERRIE field.
	Flash_CR_ERRIE_Msk      = 0x2000000  // Bit mask of ERRIE field.
	Flash_CR_ERRIE          = 0x2000000  // Bit ERRIE.
	Flash_CR_RDERRIE_Pos    = 0x1a       // Position of RDERRIE field.
	Flash_CR_RDERRIE_Msk    = 0x4000000  // Bit mask of RDERRIE field.
	Flash_CR_RDERRIE        = 0x4000000  // Bit RDERRIE.
	Flash_CR_OBL_LAUNCH_Pos = 0x1b       // Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x8000000  // Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH     = 0x8000000  // Bit OBL_LAUNCH.
	Flash_CR_SEC_PROT_Pos   = 0x1c       // Position of SEC_PROT field.
	Flash_CR_SEC_PROT_Msk   = 0x10000000 // Bit mask of SEC_PROT field.
	Flash_CR_SEC_PROT       = 0x10000000 // Bit SEC_PROT.
	Flash_CR_OPTLOCK_Pos    = 0x1e       // Position of OPTLOCK field.
	Flash_CR_OPTLOCK_Msk    = 0x40000000 // Bit mask of OPTLOCK field.
	Flash_CR_OPTLOCK        = 0x40000000 // Bit OPTLOCK.
	Flash_CR_LOCK_Pos       = 0x1f       // Position of LOCK field.
	Flash_CR_LOCK_Msk       = 0x80000000 // Bit mask of LOCK field.
	Flash_CR_LOCK           = 0x80000000 // Bit LOCK.

	// ECCR: Flash ECC register
	Flash_ECCR_ADDR_ECC_Pos = 0x0        // Position of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Msk = 0x3fff     // Bit mask of ADDR_ECC field.
	Flash_ECCR_SYSF_ECC_Pos = 0x14       // Position of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Msk = 0x100000   // Bit mask of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC     = 0x100000   // Bit SYSF_ECC.
	Flash_ECCR_ECCIE_Pos    = 0x18       // Position of ECCIE field.
	Flash_ECCR_ECCIE_Msk    = 0x1000000  // Bit mask of ECCIE field.
	Flash_ECCR_ECCIE        = 0x1000000  // Bit ECCIE.
	Flash_ECCR_ECCC_Pos     = 0x1e       // Position of ECCC field.
	Flash_ECCR_ECCC_Msk     = 0x40000000 // Bit mask of ECCC field.
	Flash_ECCR_ECCC         = 0x40000000 // Bit ECCC.
	Flash_ECCR_ECCD_Pos     = 0x1f       // Position of ECCD field.
	Flash_ECCR_ECCD_Msk     = 0x80000000 // Bit mask of ECCD field.
	Flash_ECCR_ECCD         = 0x80000000 // Bit ECCD.

	// OPTR: Flash option register
	Flash_OPTR_RDP_Pos              = 0x0        // Position of RDP field.
	Flash_OPTR_RDP_Msk              = 0xff       // Bit mask of RDP field.
	Flash_OPTR_BOREN_Pos            = 0x8        // Position of BOREN field.
	Flash_OPTR_BOREN_Msk            = 0x100      // Bit mask of BOREN field.
	Flash_OPTR_BOREN                = 0x100      // Bit BOREN.
	Flash_OPTR_BORF_LEV_Pos         = 0x9        // Position of BORF_LEV field.
	Flash_OPTR_BORF_LEV_Msk         = 0x600      // Bit mask of BORF_LEV field.
	Flash_OPTR_BORR_LEV_Pos         = 0xb        // Position of BORR_LEV field.
	Flash_OPTR_BORR_LEV_Msk         = 0x1800     // Bit mask of BORR_LEV field.
	Flash_OPTR_NRST_STOP_Pos        = 0xd        // Position of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Msk        = 0x2000     // Bit mask of NRST_STOP field.
	Flash_OPTR_NRST_STOP            = 0x2000     // Bit NRST_STOP.
	Flash_OPTR_NRST_STDBY_Pos       = 0xe        // Position of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Msk       = 0x4000     // Bit mask of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY           = 0x4000     // Bit NRST_STDBY.
	Flash_OPTR_NRSTS_HDW_Pos        = 0xf        // Position of NRSTS_HDW field.
	Flash_OPTR_NRSTS_HDW_Msk        = 0x8000     // Bit mask of NRSTS_HDW field.
	Flash_OPTR_NRSTS_HDW            = 0x8000     // Bit NRSTS_HDW.
	Flash_OPTR_IDWG_SW_Pos          = 0x10       // Position of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Msk          = 0x10000    // Bit mask of IDWG_SW field.
	Flash_OPTR_IDWG_SW              = 0x10000    // Bit IDWG_SW.
	Flash_OPTR_IWDG_STOP_Pos        = 0x11       // Position of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Msk        = 0x20000    // Bit mask of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP            = 0x20000    // Bit IWDG_STOP.
	Flash_OPTR_IWDG_STDBY_Pos       = 0x12       // Position of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Msk       = 0x40000    // Bit mask of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY           = 0x40000    // Bit IWDG_STDBY.
	Flash_OPTR_WWDG_SW_Pos          = 0x13       // Position of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Msk          = 0x80000    // Bit mask of WWDG_SW field.
	Flash_OPTR_WWDG_SW              = 0x80000    // Bit WWDG_SW.
	Flash_OPTR_RAM_PARITY_CHECK_Pos = 0x16       // Position of RAM_PARITY_CHECK field.
	Flash_OPTR_RAM_PARITY_CHECK_Msk = 0x400000   // Bit mask of RAM_PARITY_CHECK field.
	Flash_OPTR_RAM_PARITY_CHECK     = 0x400000   // Bit RAM_PARITY_CHECK.
	Flash_OPTR_NBOOT_SEL_Pos        = 0x18       // Position of NBOOT_SEL field.
	Flash_OPTR_NBOOT_SEL_Msk        = 0x1000000  // Bit mask of NBOOT_SEL field.
	Flash_OPTR_NBOOT_SEL            = 0x1000000  // Bit NBOOT_SEL.
	Flash_OPTR_NBOOT1_Pos           = 0x19       // Position of NBOOT1 field.
	Flash_OPTR_NBOOT1_Msk           = 0x2000000  // Bit mask of NBOOT1 field.
	Flash_OPTR_NBOOT1               = 0x2000000  // Bit NBOOT1.
	Flash_OPTR_NBOOT0_Pos           = 0x1a       // Position of NBOOT0 field.
	Flash_OPTR_NBOOT0_Msk           = 0x4000000  // Bit mask of NBOOT0 field.
	Flash_OPTR_NBOOT0               = 0x4000000  // Bit NBOOT0.
	Flash_OPTR_NRST_MODE_Pos        = 0x1b       // Position of NRST_MODE field.
	Flash_OPTR_NRST_MODE_Msk        = 0x18000000 // Bit mask of NRST_MODE field.
	Flash_OPTR_IRHEN_Pos            = 0x1d       // Position of IRHEN field.
	Flash_OPTR_IRHEN_Msk            = 0x20000000 // Bit mask of IRHEN field.
	Flash_OPTR_IRHEN                = 0x20000000 // Bit IRHEN.

	// PCROP1ASR: Flash PCROP zone A Start address           register
	Flash_PCROP1ASR_PCROP1A_STRT_Pos = 0x0  // Position of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Msk = 0xff // Bit mask of PCROP1A_STRT field.

	// PCROP1AER: Flash PCROP zone A End address           register
	Flash_PCROP1AER_PCROP1A_END_Pos = 0x0        // Position of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Msk = 0xff       // Bit mask of PCROP1A_END field.
	Flash_PCROP1AER_PCROP_RDP_Pos   = 0x1f       // Position of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Msk   = 0x80000000 // Bit mask of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP       = 0x80000000 // Bit PCROP_RDP.

	// WRP1AR: Flash WRP area A address           register
	Flash_WRP1AR_WRP1A_STRT_Pos = 0x0      // Position of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Msk = 0x3f     // Bit mask of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_END_Pos  = 0x10     // Position of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Msk  = 0x3f0000 // Bit mask of WRP1A_END field.

	// WRP1BR: Flash WRP area B address           register
	Flash_WRP1BR_WRP1B_STRT_Pos = 0x0      // Position of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Msk = 0x3f     // Bit mask of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_END_Pos  = 0x10     // Position of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Msk  = 0x3f0000 // Bit mask of WRP1B_END field.

	// PCROP1BSR: Flash PCROP zone B Start address           register
	Flash_PCROP1BSR_PCROP1B_STRT_Pos = 0x0  // Position of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Msk = 0xff // Bit mask of PCROP1B_STRT field.

	// PCROP1BER: Flash PCROP zone B End address           register
	Flash_PCROP1BER_PCROP1B_END_Pos = 0x0  // Position of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Msk = 0xff // Bit mask of PCROP1B_END field.

	// SECR: Flash Security register
	Flash_SECR_SEC_SIZE_Pos  = 0x0     // Position of SEC_SIZE field.
	Flash_SECR_SEC_SIZE_Msk  = 0x7f    // Bit mask of SEC_SIZE field.
	Flash_SECR_BOOT_LOCK_Pos = 0x10    // Position of BOOT_LOCK field.
	Flash_SECR_BOOT_LOCK_Msk = 0x10000 // Bit mask of BOOT_LOCK field.
	Flash_SECR_BOOT_LOCK     = 0x10000 // Bit BOOT_LOCK.
)

// Bitfields for DBG: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	DBG_IDCODE_DEV_ID_Pos = 0x0        // Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xffff     // Bit mask of DEV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10       // Position of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000 // Bit mask of REV_ID field.

	// CR: Debug MCU Configuration           Register
	DBG_CR_DBG_STOP_Pos    = 0x1 // Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk    = 0x2 // Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP        = 0x2 // Bit DBG_STOP.
	DBG_CR_DBG_STANDBY_Pos = 0x2 // Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk = 0x4 // Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY     = 0x4 // Bit DBG_STANDBY.

	// APB_FZ1: DBG APB freeze register 1
	DBG_APB_FZ1_DBG_TIMER2_STOP_Pos = 0x0        // Position of DBG_TIMER2_STOP field.
	DBG_APB_FZ1_DBG_TIMER2_STOP_Msk = 0x1        // Bit mask of DBG_TIMER2_STOP field.
	DBG_APB_FZ1_DBG_TIMER2_STOP     = 0x1        // Bit DBG_TIMER2_STOP.
	DBG_APB_FZ1_DBG_TIM3_STOP_Pos   = 0x1        // Position of DBG_TIM3_STOP field.
	DBG_APB_FZ1_DBG_TIM3_STOP_Msk   = 0x2        // Bit mask of DBG_TIM3_STOP field.
	DBG_APB_FZ1_DBG_TIM3_STOP       = 0x2        // Bit DBG_TIM3_STOP.
	DBG_APB_FZ1_DBG_TIMER6_STOP_Pos = 0x4        // Position of DBG_TIMER6_STOP field.
	DBG_APB_FZ1_DBG_TIMER6_STOP_Msk = 0x10       // Bit mask of DBG_TIMER6_STOP field.
	DBG_APB_FZ1_DBG_TIMER6_STOP     = 0x10       // Bit DBG_TIMER6_STOP.
	DBG_APB_FZ1_DBG_TIM7_STOP_Pos   = 0x5        // Position of DBG_TIM7_STOP field.
	DBG_APB_FZ1_DBG_TIM7_STOP_Msk   = 0x20       // Bit mask of DBG_TIM7_STOP field.
	DBG_APB_FZ1_DBG_TIM7_STOP       = 0x20       // Bit DBG_TIM7_STOP.
	DBG_APB_FZ1_DBG_RTC_STOP_Pos    = 0xa        // Position of DBG_RTC_STOP field.
	DBG_APB_FZ1_DBG_RTC_STOP_Msk    = 0x400      // Bit mask of DBG_RTC_STOP field.
	DBG_APB_FZ1_DBG_RTC_STOP        = 0x400      // Bit DBG_RTC_STOP.
	DBG_APB_FZ1_DBG_WWDG_STOP_Pos   = 0xb        // Position of DBG_WWDG_STOP field.
	DBG_APB_FZ1_DBG_WWDG_STOP_Msk   = 0x800      // Bit mask of DBG_WWDG_STOP field.
	DBG_APB_FZ1_DBG_WWDG_STOP       = 0x800      // Bit DBG_WWDG_STOP.
	DBG_APB_FZ1_DBG_IWDG_STOP_Pos   = 0xc        // Position of DBG_IWDG_STOP field.
	DBG_APB_FZ1_DBG_IWDG_STOP_Msk   = 0x1000     // Bit mask of DBG_IWDG_STOP field.
	DBG_APB_FZ1_DBG_IWDG_STOP       = 0x1000     // Bit DBG_IWDG_STOP.
	DBG_APB_FZ1_DBG_I2C1_STOP_Pos   = 0x15       // Position of DBG_I2C1_STOP field.
	DBG_APB_FZ1_DBG_I2C1_STOP_Msk   = 0x200000   // Bit mask of DBG_I2C1_STOP field.
	DBG_APB_FZ1_DBG_I2C1_STOP       = 0x200000   // Bit DBG_I2C1_STOP.
	DBG_APB_FZ1_DBG_LPTIM2_STOP_Pos = 0x1e       // Position of DBG_LPTIM2_STOP field.
	DBG_APB_FZ1_DBG_LPTIM2_STOP_Msk = 0x40000000 // Bit mask of DBG_LPTIM2_STOP field.
	DBG_APB_FZ1_DBG_LPTIM2_STOP     = 0x40000000 // Bit DBG_LPTIM2_STOP.
	DBG_APB_FZ1_DBG_LPTIM1_STOP_Pos = 0x1f       // Position of DBG_LPTIM1_STOP field.
	DBG_APB_FZ1_DBG_LPTIM1_STOP_Msk = 0x80000000 // Bit mask of DBG_LPTIM1_STOP field.
	DBG_APB_FZ1_DBG_LPTIM1_STOP     = 0x80000000 // Bit DBG_LPTIM1_STOP.

	// APB_FZ2: DBG APB freeze register 2
	DBG_APB_FZ2_DBG_TIM1_STOP_Pos  = 0xb     // Position of DBG_TIM1_STOP field.
	DBG_APB_FZ2_DBG_TIM1_STOP_Msk  = 0x800   // Bit mask of DBG_TIM1_STOP field.
	DBG_APB_FZ2_DBG_TIM1_STOP      = 0x800   // Bit DBG_TIM1_STOP.
	DBG_APB_FZ2_DBG_TIM14_STOP_Pos = 0xf     // Position of DBG_TIM14_STOP field.
	DBG_APB_FZ2_DBG_TIM14_STOP_Msk = 0x8000  // Bit mask of DBG_TIM14_STOP field.
	DBG_APB_FZ2_DBG_TIM14_STOP     = 0x8000  // Bit DBG_TIM14_STOP.
	DBG_APB_FZ2_DBG_TIM15_STOP_Pos = 0x10    // Position of DBG_TIM15_STOP field.
	DBG_APB_FZ2_DBG_TIM15_STOP_Msk = 0x10000 // Bit mask of DBG_TIM15_STOP field.
	DBG_APB_FZ2_DBG_TIM15_STOP     = 0x10000 // Bit DBG_TIM15_STOP.
	DBG_APB_FZ2_DBG_TIM16_STOP_Pos = 0x11    // Position of DBG_TIM16_STOP field.
	DBG_APB_FZ2_DBG_TIM16_STOP_Msk = 0x20000 // Bit mask of DBG_TIM16_STOP field.
	DBG_APB_FZ2_DBG_TIM16_STOP     = 0x20000 // Bit DBG_TIM16_STOP.
	DBG_APB_FZ2_DBG_TIM17_STOP_Pos = 0x12    // Position of DBG_TIM17_STOP field.
	DBG_APB_FZ2_DBG_TIM17_STOP_Msk = 0x40000 // Bit mask of DBG_TIM17_STOP field.
	DBG_APB_FZ2_DBG_TIM17_STOP     = 0x40000 // Bit DBG_TIM17_STOP.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	RCC_CR_HSION_Pos    = 0x8       // Position of HSION field.
	RCC_CR_HSION_Msk    = 0x100     // Bit mask of HSION field.
	RCC_CR_HSION        = 0x100     // Bit HSION.
	RCC_CR_HSIKERON_Pos = 0x9       // Position of HSIKERON field.
	RCC_CR_HSIKERON_Msk = 0x200     // Bit mask of HSIKERON field.
	RCC_CR_HSIKERON     = 0x200     // Bit HSIKERON.
	RCC_CR_HSIRDY_Pos   = 0xa       // Position of HSIRDY field.
	RCC_CR_HSIRDY_Msk   = 0x400     // Bit mask of HSIRDY field.
	RCC_CR_HSIRDY       = 0x400     // Bit HSIRDY.
	RCC_CR_HSIDIV_Pos   = 0xb       // Position of HSIDIV field.
	RCC_CR_HSIDIV_Msk   = 0x3800    // Bit mask of HSIDIV field.
	RCC_CR_HSEON_Pos    = 0x10      // Position of HSEON field.
	RCC_CR_HSEON_Msk    = 0x10000   // Bit mask of HSEON field.
	RCC_CR_HSEON        = 0x10000   // Bit HSEON.
	RCC_CR_HSERDY_Pos   = 0x11      // Position of HSERDY field.
	RCC_CR_HSERDY_Msk   = 0x20000   // Bit mask of HSERDY field.
	RCC_CR_HSERDY       = 0x20000   // Bit HSERDY.
	RCC_CR_HSEBYP_Pos   = 0x12      // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk   = 0x40000   // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP       = 0x40000   // Bit HSEBYP.
	RCC_CR_CSSON_Pos    = 0x13      // Position of CSSON field.
	RCC_CR_CSSON_Msk    = 0x80000   // Bit mask of CSSON field.
	RCC_CR_CSSON        = 0x80000   // Bit CSSON.
	RCC_CR_PLLON_Pos    = 0x18      // Position of PLLON field.
	RCC_CR_PLLON_Msk    = 0x1000000 // Bit mask of PLLON field.
	RCC_CR_PLLON        = 0x1000000 // Bit PLLON.
	RCC_CR_PLLRDY_Pos   = 0x19      // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk   = 0x2000000 // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY       = 0x2000000 // Bit PLLRDY.

	// ICSCR: Internal clock sources calibration           register
	RCC_ICSCR_HSICAL_Pos  = 0x0    // Position of HSICAL field.
	RCC_ICSCR_HSICAL_Msk  = 0xff   // Bit mask of HSICAL field.
	RCC_ICSCR_HSITRIM_Pos = 0x8    // Position of HSITRIM field.
	RCC_ICSCR_HSITRIM_Msk = 0x7f00 // Bit mask of HSITRIM field.

	// CFGR: Clock configuration register
	RCC_CFGR_MCOPRE_Pos = 0x1c       // Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000 // Bit mask of MCOPRE field.
	RCC_CFGR_MCOSEL_Pos = 0x18       // Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk = 0x7000000  // Bit mask of MCOSEL field.
	RCC_CFGR_PPRE_Pos   = 0xc        // Position of PPRE field.
	RCC_CFGR_PPRE_Msk   = 0x7000     // Bit mask of PPRE field.
	RCC_CFGR_HPRE_Pos   = 0x8        // Position of HPRE field.
	RCC_CFGR_HPRE_Msk   = 0xf00      // Bit mask of HPRE field.
	RCC_CFGR_SWS_Pos    = 0x3        // Position of SWS field.
	RCC_CFGR_SWS_Msk    = 0x38       // Bit mask of SWS field.
	RCC_CFGR_SW_Pos     = 0x0        // Position of SW field.
	RCC_CFGR_SW_Msk     = 0x7        // Bit mask of SW field.

	// PLLSYSCFGR: PLL configuration register
	RCC_PLLSYSCFGR_PLLSRC_Pos = 0x0        // Position of PLLSRC field.
	RCC_PLLSYSCFGR_PLLSRC_Msk = 0x3        // Bit mask of PLLSRC field.
	RCC_PLLSYSCFGR_PLLM_Pos   = 0x4        // Position of PLLM field.
	RCC_PLLSYSCFGR_PLLM_Msk   = 0x70       // Bit mask of PLLM field.
	RCC_PLLSYSCFGR_PLLN_Pos   = 0x8        // Position of PLLN field.
	RCC_PLLSYSCFGR_PLLN_Msk   = 0x7f00     // Bit mask of PLLN field.
	RCC_PLLSYSCFGR_PLLPEN_Pos = 0x10       // Position of PLLPEN field.
	RCC_PLLSYSCFGR_PLLPEN_Msk = 0x10000    // Bit mask of PLLPEN field.
	RCC_PLLSYSCFGR_PLLPEN     = 0x10000    // Bit PLLPEN.
	RCC_PLLSYSCFGR_PLLP_Pos   = 0x11       // Position of PLLP field.
	RCC_PLLSYSCFGR_PLLP_Msk   = 0x3e0000   // Bit mask of PLLP field.
	RCC_PLLSYSCFGR_PLLQEN_Pos = 0x18       // Position of PLLQEN field.
	RCC_PLLSYSCFGR_PLLQEN_Msk = 0x1000000  // Bit mask of PLLQEN field.
	RCC_PLLSYSCFGR_PLLQEN     = 0x1000000  // Bit PLLQEN.
	RCC_PLLSYSCFGR_PLLQ_Pos   = 0x19       // Position of PLLQ field.
	RCC_PLLSYSCFGR_PLLQ_Msk   = 0xe000000  // Bit mask of PLLQ field.
	RCC_PLLSYSCFGR_PLLREN_Pos = 0x1c       // Position of PLLREN field.
	RCC_PLLSYSCFGR_PLLREN_Msk = 0x10000000 // Bit mask of PLLREN field.
	RCC_PLLSYSCFGR_PLLREN     = 0x10000000 // Bit PLLREN.
	RCC_PLLSYSCFGR_PLLR_Pos   = 0x1d       // Position of PLLR field.
	RCC_PLLSYSCFGR_PLLR_Msk   = 0xe0000000 // Bit mask of PLLR field.

	// CIER: Clock interrupt enable           register
	RCC_CIER_LSIRDYIE_Pos    = 0x0  // Position of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Msk    = 0x1  // Bit mask of LSIRDYIE field.
	RCC_CIER_LSIRDYIE        = 0x1  // Bit LSIRDYIE.
	RCC_CIER_LSERDYIE_Pos    = 0x1  // Position of LSERDYIE field.
	RCC_CIER_LSERDYIE_Msk    = 0x2  // Bit mask of LSERDYIE field.
	RCC_CIER_LSERDYIE        = 0x2  // Bit LSERDYIE.
	RCC_CIER_HSIRDYIE_Pos    = 0x3  // Position of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Msk    = 0x8  // Bit mask of HSIRDYIE field.
	RCC_CIER_HSIRDYIE        = 0x8  // Bit HSIRDYIE.
	RCC_CIER_HSERDYIE_Pos    = 0x4  // Position of HSERDYIE field.
	RCC_CIER_HSERDYIE_Msk    = 0x10 // Bit mask of HSERDYIE field.
	RCC_CIER_HSERDYIE        = 0x10 // Bit HSERDYIE.
	RCC_CIER_PLLSYSRDYIE_Pos = 0x5  // Position of PLLSYSRDYIE field.
	RCC_CIER_PLLSYSRDYIE_Msk = 0x20 // Bit mask of PLLSYSRDYIE field.
	RCC_CIER_PLLSYSRDYIE     = 0x20 // Bit PLLSYSRDYIE.

	// CIFR: Clock interrupt flag register
	RCC_CIFR_LSIRDYF_Pos    = 0x0   // Position of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Msk    = 0x1   // Bit mask of LSIRDYF field.
	RCC_CIFR_LSIRDYF        = 0x1   // Bit LSIRDYF.
	RCC_CIFR_LSERDYF_Pos    = 0x1   // Position of LSERDYF field.
	RCC_CIFR_LSERDYF_Msk    = 0x2   // Bit mask of LSERDYF field.
	RCC_CIFR_LSERDYF        = 0x2   // Bit LSERDYF.
	RCC_CIFR_HSIRDYF_Pos    = 0x3   // Position of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Msk    = 0x8   // Bit mask of HSIRDYF field.
	RCC_CIFR_HSIRDYF        = 0x8   // Bit HSIRDYF.
	RCC_CIFR_HSERDYF_Pos    = 0x4   // Position of HSERDYF field.
	RCC_CIFR_HSERDYF_Msk    = 0x10  // Bit mask of HSERDYF field.
	RCC_CIFR_HSERDYF        = 0x10  // Bit HSERDYF.
	RCC_CIFR_PLLSYSRDYF_Pos = 0x5   // Position of PLLSYSRDYF field.
	RCC_CIFR_PLLSYSRDYF_Msk = 0x20  // Bit mask of PLLSYSRDYF field.
	RCC_CIFR_PLLSYSRDYF     = 0x20  // Bit PLLSYSRDYF.
	RCC_CIFR_CSSF_Pos       = 0x8   // Position of CSSF field.
	RCC_CIFR_CSSF_Msk       = 0x100 // Bit mask of CSSF field.
	RCC_CIFR_CSSF           = 0x100 // Bit CSSF.
	RCC_CIFR_LSECSSF_Pos    = 0x9   // Position of LSECSSF field.
	RCC_CIFR_LSECSSF_Msk    = 0x200 // Bit mask of LSECSSF field.
	RCC_CIFR_LSECSSF        = 0x200 // Bit LSECSSF.

	// CICR: Clock interrupt clear register
	RCC_CICR_LSIRDYC_Pos    = 0x0   // Position of LSIRDYC field.
	RCC_CICR_LSIRDYC_Msk    = 0x1   // Bit mask of LSIRDYC field.
	RCC_CICR_LSIRDYC        = 0x1   // Bit LSIRDYC.
	RCC_CICR_LSERDYC_Pos    = 0x1   // Position of LSERDYC field.
	RCC_CICR_LSERDYC_Msk    = 0x2   // Bit mask of LSERDYC field.
	RCC_CICR_LSERDYC        = 0x2   // Bit LSERDYC.
	RCC_CICR_HSIRDYC_Pos    = 0x3   // Position of HSIRDYC field.
	RCC_CICR_HSIRDYC_Msk    = 0x8   // Bit mask of HSIRDYC field.
	RCC_CICR_HSIRDYC        = 0x8   // Bit HSIRDYC.
	RCC_CICR_HSERDYC_Pos    = 0x4   // Position of HSERDYC field.
	RCC_CICR_HSERDYC_Msk    = 0x10  // Bit mask of HSERDYC field.
	RCC_CICR_HSERDYC        = 0x10  // Bit HSERDYC.
	RCC_CICR_PLLSYSRDYC_Pos = 0x5   // Position of PLLSYSRDYC field.
	RCC_CICR_PLLSYSRDYC_Msk = 0x20  // Bit mask of PLLSYSRDYC field.
	RCC_CICR_PLLSYSRDYC     = 0x20  // Bit PLLSYSRDYC.
	RCC_CICR_CSSC_Pos       = 0x8   // Position of CSSC field.
	RCC_CICR_CSSC_Msk       = 0x100 // Bit mask of CSSC field.
	RCC_CICR_CSSC           = 0x100 // Bit CSSC.
	RCC_CICR_LSECSSC_Pos    = 0x9   // Position of LSECSSC field.
	RCC_CICR_LSECSSC_Msk    = 0x200 // Bit mask of LSECSSC field.
	RCC_CICR_LSECSSC        = 0x200 // Bit LSECSSC.

	// IOPRSTR: GPIO reset register
	RCC_IOPRSTR_IOPARST_Pos = 0x0  // Position of IOPARST field.
	RCC_IOPRSTR_IOPARST_Msk = 0x1  // Bit mask of IOPARST field.
	RCC_IOPRSTR_IOPARST     = 0x1  // Bit IOPARST.
	RCC_IOPRSTR_IOPBRST_Pos = 0x1  // Position of IOPBRST field.
	RCC_IOPRSTR_IOPBRST_Msk = 0x2  // Bit mask of IOPBRST field.
	RCC_IOPRSTR_IOPBRST     = 0x2  // Bit IOPBRST.
	RCC_IOPRSTR_IOPCRST_Pos = 0x2  // Position of IOPCRST field.
	RCC_IOPRSTR_IOPCRST_Msk = 0x4  // Bit mask of IOPCRST field.
	RCC_IOPRSTR_IOPCRST     = 0x4  // Bit IOPCRST.
	RCC_IOPRSTR_IOPDRST_Pos = 0x3  // Position of IOPDRST field.
	RCC_IOPRSTR_IOPDRST_Msk = 0x8  // Bit mask of IOPDRST field.
	RCC_IOPRSTR_IOPDRST     = 0x8  // Bit IOPDRST.
	RCC_IOPRSTR_IOPFRST_Pos = 0x5  // Position of IOPFRST field.
	RCC_IOPRSTR_IOPFRST_Msk = 0x20 // Bit mask of IOPFRST field.
	RCC_IOPRSTR_IOPFRST     = 0x20 // Bit IOPFRST.

	// AHBRSTR: AHB peripheral reset register
	RCC_AHBRSTR_DMARST_Pos   = 0x0     // Position of DMARST field.
	RCC_AHBRSTR_DMARST_Msk   = 0x1     // Bit mask of DMARST field.
	RCC_AHBRSTR_DMARST       = 0x1     // Bit DMARST.
	RCC_AHBRSTR_FLASHRST_Pos = 0x8     // Position of FLASHRST field.
	RCC_AHBRSTR_FLASHRST_Msk = 0x100   // Bit mask of FLASHRST field.
	RCC_AHBRSTR_FLASHRST     = 0x100   // Bit FLASHRST.
	RCC_AHBRSTR_CRCRST_Pos   = 0xc     // Position of CRCRST field.
	RCC_AHBRSTR_CRCRST_Msk   = 0x1000  // Bit mask of CRCRST field.
	RCC_AHBRSTR_CRCRST       = 0x1000  // Bit CRCRST.
	RCC_AHBRSTR_AESRST_Pos   = 0x10    // Position of AESRST field.
	RCC_AHBRSTR_AESRST_Msk   = 0x10000 // Bit mask of AESRST field.
	RCC_AHBRSTR_AESRST       = 0x10000 // Bit AESRST.
	RCC_AHBRSTR_RNGRST_Pos   = 0x12    // Position of RNGRST field.
	RCC_AHBRSTR_RNGRST_Msk   = 0x40000 // Bit mask of RNGRST field.
	RCC_AHBRSTR_RNGRST       = 0x40000 // Bit RNGRST.

	// APBRSTR1: APB peripheral reset register           1
	RCC_APBRSTR1_TIM2RST_Pos    = 0x0        // Position of TIM2RST field.
	RCC_APBRSTR1_TIM2RST_Msk    = 0x1        // Bit mask of TIM2RST field.
	RCC_APBRSTR1_TIM2RST        = 0x1        // Bit TIM2RST.
	RCC_APBRSTR1_TIM3RST_Pos    = 0x1        // Position of TIM3RST field.
	RCC_APBRSTR1_TIM3RST_Msk    = 0x2        // Bit mask of TIM3RST field.
	RCC_APBRSTR1_TIM3RST        = 0x2        // Bit TIM3RST.
	RCC_APBRSTR1_TIM6RST_Pos    = 0x4        // Position of TIM6RST field.
	RCC_APBRSTR1_TIM6RST_Msk    = 0x10       // Bit mask of TIM6RST field.
	RCC_APBRSTR1_TIM6RST        = 0x10       // Bit TIM6RST.
	RCC_APBRSTR1_TIM7RST_Pos    = 0x5        // Position of TIM7RST field.
	RCC_APBRSTR1_TIM7RST_Msk    = 0x20       // Bit mask of TIM7RST field.
	RCC_APBRSTR1_TIM7RST        = 0x20       // Bit TIM7RST.
	RCC_APBRSTR1_SPI2RST_Pos    = 0xe        // Position of SPI2RST field.
	RCC_APBRSTR1_SPI2RST_Msk    = 0x4000     // Bit mask of SPI2RST field.
	RCC_APBRSTR1_SPI2RST        = 0x4000     // Bit SPI2RST.
	RCC_APBRSTR1_USART2RST_Pos  = 0x11       // Position of USART2RST field.
	RCC_APBRSTR1_USART2RST_Msk  = 0x20000    // Bit mask of USART2RST field.
	RCC_APBRSTR1_USART2RST      = 0x20000    // Bit USART2RST.
	RCC_APBRSTR1_USART3RST_Pos  = 0x12       // Position of USART3RST field.
	RCC_APBRSTR1_USART3RST_Msk  = 0x40000    // Bit mask of USART3RST field.
	RCC_APBRSTR1_USART3RST      = 0x40000    // Bit USART3RST.
	RCC_APBRSTR1_USART4RST_Pos  = 0x13       // Position of USART4RST field.
	RCC_APBRSTR1_USART4RST_Msk  = 0x80000    // Bit mask of USART4RST field.
	RCC_APBRSTR1_USART4RST      = 0x80000    // Bit USART4RST.
	RCC_APBRSTR1_LPUART1RST_Pos = 0x14       // Position of LPUART1RST field.
	RCC_APBRSTR1_LPUART1RST_Msk = 0x100000   // Bit mask of LPUART1RST field.
	RCC_APBRSTR1_LPUART1RST     = 0x100000   // Bit LPUART1RST.
	RCC_APBRSTR1_I2C1RST_Pos    = 0x15       // Position of I2C1RST field.
	RCC_APBRSTR1_I2C1RST_Msk    = 0x200000   // Bit mask of I2C1RST field.
	RCC_APBRSTR1_I2C1RST        = 0x200000   // Bit I2C1RST.
	RCC_APBRSTR1_I2C2RST_Pos    = 0x16       // Position of I2C2RST field.
	RCC_APBRSTR1_I2C2RST_Msk    = 0x400000   // Bit mask of I2C2RST field.
	RCC_APBRSTR1_I2C2RST        = 0x400000   // Bit I2C2RST.
	RCC_APBRSTR1_CECRST_Pos     = 0x18       // Position of CECRST field.
	RCC_APBRSTR1_CECRST_Msk     = 0x1000000  // Bit mask of CECRST field.
	RCC_APBRSTR1_CECRST         = 0x1000000  // Bit CECRST.
	RCC_APBRSTR1_UCPD1RST_Pos   = 0x19       // Position of UCPD1RST field.
	RCC_APBRSTR1_UCPD1RST_Msk   = 0x2000000  // Bit mask of UCPD1RST field.
	RCC_APBRSTR1_UCPD1RST       = 0x2000000  // Bit UCPD1RST.
	RCC_APBRSTR1_UCPD2RST_Pos   = 0x1a       // Position of UCPD2RST field.
	RCC_APBRSTR1_UCPD2RST_Msk   = 0x4000000  // Bit mask of UCPD2RST field.
	RCC_APBRSTR1_UCPD2RST       = 0x4000000  // Bit UCPD2RST.
	RCC_APBRSTR1_DBGRST_Pos     = 0x1b       // Position of DBGRST field.
	RCC_APBRSTR1_DBGRST_Msk     = 0x8000000  // Bit mask of DBGRST field.
	RCC_APBRSTR1_DBGRST         = 0x8000000  // Bit DBGRST.
	RCC_APBRSTR1_PWRRST_Pos     = 0x1c       // Position of PWRRST field.
	RCC_APBRSTR1_PWRRST_Msk     = 0x10000000 // Bit mask of PWRRST field.
	RCC_APBRSTR1_PWRRST         = 0x10000000 // Bit PWRRST.
	RCC_APBRSTR1_DAC1RST_Pos    = 0x1d       // Position of DAC1RST field.
	RCC_APBRSTR1_DAC1RST_Msk    = 0x20000000 // Bit mask of DAC1RST field.
	RCC_APBRSTR1_DAC1RST        = 0x20000000 // Bit DAC1RST.
	RCC_APBRSTR1_LPTIM2RST_Pos  = 0x1e       // Position of LPTIM2RST field.
	RCC_APBRSTR1_LPTIM2RST_Msk  = 0x40000000 // Bit mask of LPTIM2RST field.
	RCC_APBRSTR1_LPTIM2RST      = 0x40000000 // Bit LPTIM2RST.
	RCC_APBRSTR1_LPTIM1RST_Pos  = 0x1f       // Position of LPTIM1RST field.
	RCC_APBRSTR1_LPTIM1RST_Msk  = 0x80000000 // Bit mask of LPTIM1RST field.
	RCC_APBRSTR1_LPTIM1RST      = 0x80000000 // Bit LPTIM1RST.

	// APBRSTR2: APB peripheral reset register           2
	RCC_APBRSTR2_SYSCFGRST_Pos = 0x0      // Position of SYSCFGRST field.
	RCC_APBRSTR2_SYSCFGRST_Msk = 0x1      // Bit mask of SYSCFGRST field.
	RCC_APBRSTR2_SYSCFGRST     = 0x1      // Bit SYSCFGRST.
	RCC_APBRSTR2_TIM1RST_Pos   = 0xb      // Position of TIM1RST field.
	RCC_APBRSTR2_TIM1RST_Msk   = 0x800    // Bit mask of TIM1RST field.
	RCC_APBRSTR2_TIM1RST       = 0x800    // Bit TIM1RST.
	RCC_APBRSTR2_SPI1RST_Pos   = 0xc      // Position of SPI1RST field.
	RCC_APBRSTR2_SPI1RST_Msk   = 0x1000   // Bit mask of SPI1RST field.
	RCC_APBRSTR2_SPI1RST       = 0x1000   // Bit SPI1RST.
	RCC_APBRSTR2_USART1RST_Pos = 0xe      // Position of USART1RST field.
	RCC_APBRSTR2_USART1RST_Msk = 0x4000   // Bit mask of USART1RST field.
	RCC_APBRSTR2_USART1RST     = 0x4000   // Bit USART1RST.
	RCC_APBRSTR2_TIM14RST_Pos  = 0xf      // Position of TIM14RST field.
	RCC_APBRSTR2_TIM14RST_Msk  = 0x8000   // Bit mask of TIM14RST field.
	RCC_APBRSTR2_TIM14RST      = 0x8000   // Bit TIM14RST.
	RCC_APBRSTR2_TIM15RST_Pos  = 0x10     // Position of TIM15RST field.
	RCC_APBRSTR2_TIM15RST_Msk  = 0x10000  // Bit mask of TIM15RST field.
	RCC_APBRSTR2_TIM15RST      = 0x10000  // Bit TIM15RST.
	RCC_APBRSTR2_TIM16RST_Pos  = 0x11     // Position of TIM16RST field.
	RCC_APBRSTR2_TIM16RST_Msk  = 0x20000  // Bit mask of TIM16RST field.
	RCC_APBRSTR2_TIM16RST      = 0x20000  // Bit TIM16RST.
	RCC_APBRSTR2_TIM17RST_Pos  = 0x12     // Position of TIM17RST field.
	RCC_APBRSTR2_TIM17RST_Msk  = 0x40000  // Bit mask of TIM17RST field.
	RCC_APBRSTR2_TIM17RST      = 0x40000  // Bit TIM17RST.
	RCC_APBRSTR2_ADCRST_Pos    = 0x14     // Position of ADCRST field.
	RCC_APBRSTR2_ADCRST_Msk    = 0x100000 // Bit mask of ADCRST field.
	RCC_APBRSTR2_ADCRST        = 0x100000 // Bit ADCRST.

	// IOPENR: GPIO clock enable register
	RCC_IOPENR_IOPAEN_Pos = 0x0  // Position of IOPAEN field.
	RCC_IOPENR_IOPAEN_Msk = 0x1  // Bit mask of IOPAEN field.
	RCC_IOPENR_IOPAEN     = 0x1  // Bit IOPAEN.
	RCC_IOPENR_IOPBEN_Pos = 0x1  // Position of IOPBEN field.
	RCC_IOPENR_IOPBEN_Msk = 0x2  // Bit mask of IOPBEN field.
	RCC_IOPENR_IOPBEN     = 0x2  // Bit IOPBEN.
	RCC_IOPENR_IOPCEN_Pos = 0x2  // Position of IOPCEN field.
	RCC_IOPENR_IOPCEN_Msk = 0x4  // Bit mask of IOPCEN field.
	RCC_IOPENR_IOPCEN     = 0x4  // Bit IOPCEN.
	RCC_IOPENR_IOPDEN_Pos = 0x3  // Position of IOPDEN field.
	RCC_IOPENR_IOPDEN_Msk = 0x8  // Bit mask of IOPDEN field.
	RCC_IOPENR_IOPDEN     = 0x8  // Bit IOPDEN.
	RCC_IOPENR_IOPFEN_Pos = 0x5  // Position of IOPFEN field.
	RCC_IOPENR_IOPFEN_Msk = 0x20 // Bit mask of IOPFEN field.
	RCC_IOPENR_IOPFEN     = 0x20 // Bit IOPFEN.

	// AHBENR: AHB peripheral clock enable           register
	RCC_AHBENR_DMAEN_Pos   = 0x0     // Position of DMAEN field.
	RCC_AHBENR_DMAEN_Msk   = 0x1     // Bit mask of DMAEN field.
	RCC_AHBENR_DMAEN       = 0x1     // Bit DMAEN.
	RCC_AHBENR_FLASHEN_Pos = 0x8     // Position of FLASHEN field.
	RCC_AHBENR_FLASHEN_Msk = 0x100   // Bit mask of FLASHEN field.
	RCC_AHBENR_FLASHEN     = 0x100   // Bit FLASHEN.
	RCC_AHBENR_CRCEN_Pos   = 0xc     // Position of CRCEN field.
	RCC_AHBENR_CRCEN_Msk   = 0x1000  // Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN       = 0x1000  // Bit CRCEN.
	RCC_AHBENR_AESEN_Pos   = 0x10    // Position of AESEN field.
	RCC_AHBENR_AESEN_Msk   = 0x10000 // Bit mask of AESEN field.
	RCC_AHBENR_AESEN       = 0x10000 // Bit AESEN.
	RCC_AHBENR_RNGEN_Pos   = 0x12    // Position of RNGEN field.
	RCC_AHBENR_RNGEN_Msk   = 0x40000 // Bit mask of RNGEN field.
	RCC_AHBENR_RNGEN       = 0x40000 // Bit RNGEN.

	// APBENR1: APB peripheral clock enable register           1
	RCC_APBENR1_TIM2EN_Pos    = 0x0        // Position of TIM2EN field.
	RCC_APBENR1_TIM2EN_Msk    = 0x1        // Bit mask of TIM2EN field.
	RCC_APBENR1_TIM2EN        = 0x1        // Bit TIM2EN.
	RCC_APBENR1_TIM3EN_Pos    = 0x1        // Position of TIM3EN field.
	RCC_APBENR1_TIM3EN_Msk    = 0x2        // Bit mask of TIM3EN field.
	RCC_APBENR1_TIM3EN        = 0x2        // Bit TIM3EN.
	RCC_APBENR1_TIM6EN_Pos    = 0x4        // Position of TIM6EN field.
	RCC_APBENR1_TIM6EN_Msk    = 0x10       // Bit mask of TIM6EN field.
	RCC_APBENR1_TIM6EN        = 0x10       // Bit TIM6EN.
	RCC_APBENR1_TIM7EN_Pos    = 0x5        // Position of TIM7EN field.
	RCC_APBENR1_TIM7EN_Msk    = 0x20       // Bit mask of TIM7EN field.
	RCC_APBENR1_TIM7EN        = 0x20       // Bit TIM7EN.
	RCC_APBENR1_RTCAPBEN_Pos  = 0xa        // Position of RTCAPBEN field.
	RCC_APBENR1_RTCAPBEN_Msk  = 0x400      // Bit mask of RTCAPBEN field.
	RCC_APBENR1_RTCAPBEN      = 0x400      // Bit RTCAPBEN.
	RCC_APBENR1_WWDGEN_Pos    = 0xb        // Position of WWDGEN field.
	RCC_APBENR1_WWDGEN_Msk    = 0x800      // Bit mask of WWDGEN field.
	RCC_APBENR1_WWDGEN        = 0x800      // Bit WWDGEN.
	RCC_APBENR1_SPI2EN_Pos    = 0xe        // Position of SPI2EN field.
	RCC_APBENR1_SPI2EN_Msk    = 0x4000     // Bit mask of SPI2EN field.
	RCC_APBENR1_SPI2EN        = 0x4000     // Bit SPI2EN.
	RCC_APBENR1_USART2EN_Pos  = 0x11       // Position of USART2EN field.
	RCC_APBENR1_USART2EN_Msk  = 0x20000    // Bit mask of USART2EN field.
	RCC_APBENR1_USART2EN      = 0x20000    // Bit USART2EN.
	RCC_APBENR1_USART3EN_Pos  = 0x12       // Position of USART3EN field.
	RCC_APBENR1_USART3EN_Msk  = 0x40000    // Bit mask of USART3EN field.
	RCC_APBENR1_USART3EN      = 0x40000    // Bit USART3EN.
	RCC_APBENR1_USART4EN_Pos  = 0x13       // Position of USART4EN field.
	RCC_APBENR1_USART4EN_Msk  = 0x80000    // Bit mask of USART4EN field.
	RCC_APBENR1_USART4EN      = 0x80000    // Bit USART4EN.
	RCC_APBENR1_LPUART1EN_Pos = 0x14       // Position of LPUART1EN field.
	RCC_APBENR1_LPUART1EN_Msk = 0x100000   // Bit mask of LPUART1EN field.
	RCC_APBENR1_LPUART1EN     = 0x100000   // Bit LPUART1EN.
	RCC_APBENR1_I2C1EN_Pos    = 0x15       // Position of I2C1EN field.
	RCC_APBENR1_I2C1EN_Msk    = 0x200000   // Bit mask of I2C1EN field.
	RCC_APBENR1_I2C1EN        = 0x200000   // Bit I2C1EN.
	RCC_APBENR1_I2C2EN_Pos    = 0x16       // Position of I2C2EN field.
	RCC_APBENR1_I2C2EN_Msk    = 0x400000   // Bit mask of I2C2EN field.
	RCC_APBENR1_I2C2EN        = 0x400000   // Bit I2C2EN.
	RCC_APBENR1_CECEN_Pos     = 0x18       // Position of CECEN field.
	RCC_APBENR1_CECEN_Msk     = 0x1000000  // Bit mask of CECEN field.
	RCC_APBENR1_CECEN         = 0x1000000  // Bit CECEN.
	RCC_APBENR1_UCPD1EN_Pos   = 0x19       // Position of UCPD1EN field.
	RCC_APBENR1_UCPD1EN_Msk   = 0x2000000  // Bit mask of UCPD1EN field.
	RCC_APBENR1_UCPD1EN       = 0x2000000  // Bit UCPD1EN.
	RCC_APBENR1_UCPD2EN_Pos   = 0x1a       // Position of UCPD2EN field.
	RCC_APBENR1_UCPD2EN_Msk   = 0x4000000  // Bit mask of UCPD2EN field.
	RCC_APBENR1_UCPD2EN       = 0x4000000  // Bit UCPD2EN.
	RCC_APBENR1_DBGEN_Pos     = 0x1b       // Position of DBGEN field.
	RCC_APBENR1_DBGEN_Msk     = 0x8000000  // Bit mask of DBGEN field.
	RCC_APBENR1_DBGEN         = 0x8000000  // Bit DBGEN.
	RCC_APBENR1_PWREN_Pos     = 0x1c       // Position of PWREN field.
	RCC_APBENR1_PWREN_Msk     = 0x10000000 // Bit mask of PWREN field.
	RCC_APBENR1_PWREN         = 0x10000000 // Bit PWREN.
	RCC_APBENR1_DAC1EN_Pos    = 0x1d       // Position of DAC1EN field.
	RCC_APBENR1_DAC1EN_Msk    = 0x20000000 // Bit mask of DAC1EN field.
	RCC_APBENR1_DAC1EN        = 0x20000000 // Bit DAC1EN.
	RCC_APBENR1_LPTIM2EN_Pos  = 0x1e       // Position of LPTIM2EN field.
	RCC_APBENR1_LPTIM2EN_Msk  = 0x40000000 // Bit mask of LPTIM2EN field.
	RCC_APBENR1_LPTIM2EN      = 0x40000000 // Bit LPTIM2EN.
	RCC_APBENR1_LPTIM1EN_Pos  = 0x1f       // Position of LPTIM1EN field.
	RCC_APBENR1_LPTIM1EN_Msk  = 0x80000000 // Bit mask of LPTIM1EN field.
	RCC_APBENR1_LPTIM1EN      = 0x80000000 // Bit LPTIM1EN.

	// APBENR2: APB peripheral clock enable register           2
	RCC_APBENR2_SYSCFGEN_Pos = 0x0      // Position of SYSCFGEN field.
	RCC_APBENR2_SYSCFGEN_Msk = 0x1      // Bit mask of SYSCFGEN field.
	RCC_APBENR2_SYSCFGEN     = 0x1      // Bit SYSCFGEN.
	RCC_APBENR2_TIM1EN_Pos   = 0xb      // Position of TIM1EN field.
	RCC_APBENR2_TIM1EN_Msk   = 0x800    // Bit mask of TIM1EN field.
	RCC_APBENR2_TIM1EN       = 0x800    // Bit TIM1EN.
	RCC_APBENR2_SPI1EN_Pos   = 0xc      // Position of SPI1EN field.
	RCC_APBENR2_SPI1EN_Msk   = 0x1000   // Bit mask of SPI1EN field.
	RCC_APBENR2_SPI1EN       = 0x1000   // Bit SPI1EN.
	RCC_APBENR2_USART1EN_Pos = 0xe      // Position of USART1EN field.
	RCC_APBENR2_USART1EN_Msk = 0x4000   // Bit mask of USART1EN field.
	RCC_APBENR2_USART1EN     = 0x4000   // Bit USART1EN.
	RCC_APBENR2_TIM14EN_Pos  = 0xf      // Position of TIM14EN field.
	RCC_APBENR2_TIM14EN_Msk  = 0x8000   // Bit mask of TIM14EN field.
	RCC_APBENR2_TIM14EN      = 0x8000   // Bit TIM14EN.
	RCC_APBENR2_TIM15EN_Pos  = 0x10     // Position of TIM15EN field.
	RCC_APBENR2_TIM15EN_Msk  = 0x10000  // Bit mask of TIM15EN field.
	RCC_APBENR2_TIM15EN      = 0x10000  // Bit TIM15EN.
	RCC_APBENR2_TIM16EN_Pos  = 0x11     // Position of TIM16EN field.
	RCC_APBENR2_TIM16EN_Msk  = 0x20000  // Bit mask of TIM16EN field.
	RCC_APBENR2_TIM16EN      = 0x20000  // Bit TIM16EN.
	RCC_APBENR2_TIM17EN_Pos  = 0x12     // Position of TIM17EN field.
	RCC_APBENR2_TIM17EN_Msk  = 0x40000  // Bit mask of TIM17EN field.
	RCC_APBENR2_TIM17EN      = 0x40000  // Bit TIM17EN.
	RCC_APBENR2_ADCEN_Pos    = 0x14     // Position of ADCEN field.
	RCC_APBENR2_ADCEN_Msk    = 0x100000 // Bit mask of ADCEN field.
	RCC_APBENR2_ADCEN        = 0x100000 // Bit ADCEN.

	// IOPSMENR: GPIO in Sleep mode clock enable           register
	RCC_IOPSMENR_IOPASMEN_Pos = 0x0  // Position of IOPASMEN field.
	RCC_IOPSMENR_IOPASMEN_Msk = 0x1  // Bit mask of IOPASMEN field.
	RCC_IOPSMENR_IOPASMEN     = 0x1  // Bit IOPASMEN.
	RCC_IOPSMENR_IOPBSMEN_Pos = 0x1  // Position of IOPBSMEN field.
	RCC_IOPSMENR_IOPBSMEN_Msk = 0x2  // Bit mask of IOPBSMEN field.
	RCC_IOPSMENR_IOPBSMEN     = 0x2  // Bit IOPBSMEN.
	RCC_IOPSMENR_IOPCSMEN_Pos = 0x2  // Position of IOPCSMEN field.
	RCC_IOPSMENR_IOPCSMEN_Msk = 0x4  // Bit mask of IOPCSMEN field.
	RCC_IOPSMENR_IOPCSMEN     = 0x4  // Bit IOPCSMEN.
	RCC_IOPSMENR_IOPDSMEN_Pos = 0x3  // Position of IOPDSMEN field.
	RCC_IOPSMENR_IOPDSMEN_Msk = 0x8  // Bit mask of IOPDSMEN field.
	RCC_IOPSMENR_IOPDSMEN     = 0x8  // Bit IOPDSMEN.
	RCC_IOPSMENR_IOPFSMEN_Pos = 0x5  // Position of IOPFSMEN field.
	RCC_IOPSMENR_IOPFSMEN_Msk = 0x20 // Bit mask of IOPFSMEN field.
	RCC_IOPSMENR_IOPFSMEN     = 0x20 // Bit IOPFSMEN.

	// AHBSMENR: AHB peripheral clock enable in Sleep mode           register
	RCC_AHBSMENR_DMASMEN_Pos   = 0x0     // Position of DMASMEN field.
	RCC_AHBSMENR_DMASMEN_Msk   = 0x1     // Bit mask of DMASMEN field.
	RCC_AHBSMENR_DMASMEN       = 0x1     // Bit DMASMEN.
	RCC_AHBSMENR_FLASHSMEN_Pos = 0x8     // Position of FLASHSMEN field.
	RCC_AHBSMENR_FLASHSMEN_Msk = 0x100   // Bit mask of FLASHSMEN field.
	RCC_AHBSMENR_FLASHSMEN     = 0x100   // Bit FLASHSMEN.
	RCC_AHBSMENR_SRAMSMEN_Pos  = 0x9     // Position of SRAMSMEN field.
	RCC_AHBSMENR_SRAMSMEN_Msk  = 0x200   // Bit mask of SRAMSMEN field.
	RCC_AHBSMENR_SRAMSMEN      = 0x200   // Bit SRAMSMEN.
	RCC_AHBSMENR_CRCSMEN_Pos   = 0xc     // Position of CRCSMEN field.
	RCC_AHBSMENR_CRCSMEN_Msk   = 0x1000  // Bit mask of CRCSMEN field.
	RCC_AHBSMENR_CRCSMEN       = 0x1000  // Bit CRCSMEN.
	RCC_AHBSMENR_AESSMEN_Pos   = 0x10    // Position of AESSMEN field.
	RCC_AHBSMENR_AESSMEN_Msk   = 0x10000 // Bit mask of AESSMEN field.
	RCC_AHBSMENR_AESSMEN       = 0x10000 // Bit AESSMEN.
	RCC_AHBSMENR_RNGSMEN_Pos   = 0x12    // Position of RNGSMEN field.
	RCC_AHBSMENR_RNGSMEN_Msk   = 0x40000 // Bit mask of RNGSMEN field.
	RCC_AHBSMENR_RNGSMEN       = 0x40000 // Bit RNGSMEN.

	// APBSMENR1: APB peripheral clock enable in Sleep mode           register 1
	RCC_APBSMENR1_TIM2SMEN_Pos    = 0x0        // Position of TIM2SMEN field.
	RCC_APBSMENR1_TIM2SMEN_Msk    = 0x1        // Bit mask of TIM2SMEN field.
	RCC_APBSMENR1_TIM2SMEN        = 0x1        // Bit TIM2SMEN.
	RCC_APBSMENR1_TIM3SMEN_Pos    = 0x1        // Position of TIM3SMEN field.
	RCC_APBSMENR1_TIM3SMEN_Msk    = 0x2        // Bit mask of TIM3SMEN field.
	RCC_APBSMENR1_TIM3SMEN        = 0x2        // Bit TIM3SMEN.
	RCC_APBSMENR1_TIM6SMEN_Pos    = 0x4        // Position of TIM6SMEN field.
	RCC_APBSMENR1_TIM6SMEN_Msk    = 0x10       // Bit mask of TIM6SMEN field.
	RCC_APBSMENR1_TIM6SMEN        = 0x10       // Bit TIM6SMEN.
	RCC_APBSMENR1_TIM7SMEN_Pos    = 0x5        // Position of TIM7SMEN field.
	RCC_APBSMENR1_TIM7SMEN_Msk    = 0x20       // Bit mask of TIM7SMEN field.
	RCC_APBSMENR1_TIM7SMEN        = 0x20       // Bit TIM7SMEN.
	RCC_APBSMENR1_RTCAPBSMEN_Pos  = 0xa        // Position of RTCAPBSMEN field.
	RCC_APBSMENR1_RTCAPBSMEN_Msk  = 0x400      // Bit mask of RTCAPBSMEN field.
	RCC_APBSMENR1_RTCAPBSMEN      = 0x400      // Bit RTCAPBSMEN.
	RCC_APBSMENR1_WWDGSMEN_Pos    = 0xb        // Position of WWDGSMEN field.
	RCC_APBSMENR1_WWDGSMEN_Msk    = 0x800      // Bit mask of WWDGSMEN field.
	RCC_APBSMENR1_WWDGSMEN        = 0x800      // Bit WWDGSMEN.
	RCC_APBSMENR1_SPI2SMEN_Pos    = 0xe        // Position of SPI2SMEN field.
	RCC_APBSMENR1_SPI2SMEN_Msk    = 0x4000     // Bit mask of SPI2SMEN field.
	RCC_APBSMENR1_SPI2SMEN        = 0x4000     // Bit SPI2SMEN.
	RCC_APBSMENR1_USART2SMEN_Pos  = 0x11       // Position of USART2SMEN field.
	RCC_APBSMENR1_USART2SMEN_Msk  = 0x20000    // Bit mask of USART2SMEN field.
	RCC_APBSMENR1_USART2SMEN      = 0x20000    // Bit USART2SMEN.
	RCC_APBSMENR1_USART3SMEN_Pos  = 0x12       // Position of USART3SMEN field.
	RCC_APBSMENR1_USART3SMEN_Msk  = 0x40000    // Bit mask of USART3SMEN field.
	RCC_APBSMENR1_USART3SMEN      = 0x40000    // Bit USART3SMEN.
	RCC_APBSMENR1_USART4SMEN_Pos  = 0x13       // Position of USART4SMEN field.
	RCC_APBSMENR1_USART4SMEN_Msk  = 0x80000    // Bit mask of USART4SMEN field.
	RCC_APBSMENR1_USART4SMEN      = 0x80000    // Bit USART4SMEN.
	RCC_APBSMENR1_LPUART1SMEN_Pos = 0x14       // Position of LPUART1SMEN field.
	RCC_APBSMENR1_LPUART1SMEN_Msk = 0x100000   // Bit mask of LPUART1SMEN field.
	RCC_APBSMENR1_LPUART1SMEN     = 0x100000   // Bit LPUART1SMEN.
	RCC_APBSMENR1_I2C1SMEN_Pos    = 0x15       // Position of I2C1SMEN field.
	RCC_APBSMENR1_I2C1SMEN_Msk    = 0x200000   // Bit mask of I2C1SMEN field.
	RCC_APBSMENR1_I2C1SMEN        = 0x200000   // Bit I2C1SMEN.
	RCC_APBSMENR1_I2C2SMEN_Pos    = 0x16       // Position of I2C2SMEN field.
	RCC_APBSMENR1_I2C2SMEN_Msk    = 0x400000   // Bit mask of I2C2SMEN field.
	RCC_APBSMENR1_I2C2SMEN        = 0x400000   // Bit I2C2SMEN.
	RCC_APBSMENR1_CECSMEN_Pos     = 0x18       // Position of CECSMEN field.
	RCC_APBSMENR1_CECSMEN_Msk     = 0x1000000  // Bit mask of CECSMEN field.
	RCC_APBSMENR1_CECSMEN         = 0x1000000  // Bit CECSMEN.
	RCC_APBSMENR1_UCPD1SMEN_Pos   = 0x19       // Position of UCPD1SMEN field.
	RCC_APBSMENR1_UCPD1SMEN_Msk   = 0x2000000  // Bit mask of UCPD1SMEN field.
	RCC_APBSMENR1_UCPD1SMEN       = 0x2000000  // Bit UCPD1SMEN.
	RCC_APBSMENR1_UCPD2SMEN_Pos   = 0x1a       // Position of UCPD2SMEN field.
	RCC_APBSMENR1_UCPD2SMEN_Msk   = 0x4000000  // Bit mask of UCPD2SMEN field.
	RCC_APBSMENR1_UCPD2SMEN       = 0x4000000  // Bit UCPD2SMEN.
	RCC_APBSMENR1_DBGSMEN_Pos     = 0x1b       // Position of DBGSMEN field.
	RCC_APBSMENR1_DBGSMEN_Msk     = 0x8000000  // Bit mask of DBGSMEN field.
	RCC_APBSMENR1_DBGSMEN         = 0x8000000  // Bit DBGSMEN.
	RCC_APBSMENR1_PWRSMEN_Pos     = 0x1c       // Position of PWRSMEN field.
	RCC_APBSMENR1_PWRSMEN_Msk     = 0x10000000 // Bit mask of PWRSMEN field.
	RCC_APBSMENR1_PWRSMEN         = 0x10000000 // Bit PWRSMEN.
	RCC_APBSMENR1_DAC1SMEN_Pos    = 0x1d       // Position of DAC1SMEN field.
	RCC_APBSMENR1_DAC1SMEN_Msk    = 0x20000000 // Bit mask of DAC1SMEN field.
	RCC_APBSMENR1_DAC1SMEN        = 0x20000000 // Bit DAC1SMEN.
	RCC_APBSMENR1_LPTIM2SMEN_Pos  = 0x1e       // Position of LPTIM2SMEN field.
	RCC_APBSMENR1_LPTIM2SMEN_Msk  = 0x40000000 // Bit mask of LPTIM2SMEN field.
	RCC_APBSMENR1_LPTIM2SMEN      = 0x40000000 // Bit LPTIM2SMEN.
	RCC_APBSMENR1_LPTIM1SMEN_Pos  = 0x1f       // Position of LPTIM1SMEN field.
	RCC_APBSMENR1_LPTIM1SMEN_Msk  = 0x80000000 // Bit mask of LPTIM1SMEN field.
	RCC_APBSMENR1_LPTIM1SMEN      = 0x80000000 // Bit LPTIM1SMEN.

	// APBSMENR2: APB peripheral clock enable in Sleep mode           register 2
	RCC_APBSMENR2_SYSCFGSMEN_Pos = 0x0      // Position of SYSCFGSMEN field.
	RCC_APBSMENR2_SYSCFGSMEN_Msk = 0x1      // Bit mask of SYSCFGSMEN field.
	RCC_APBSMENR2_SYSCFGSMEN     = 0x1      // Bit SYSCFGSMEN.
	RCC_APBSMENR2_TIM1SMEN_Pos   = 0xb      // Position of TIM1SMEN field.
	RCC_APBSMENR2_TIM1SMEN_Msk   = 0x800    // Bit mask of TIM1SMEN field.
	RCC_APBSMENR2_TIM1SMEN       = 0x800    // Bit TIM1SMEN.
	RCC_APBSMENR2_SPI1SMEN_Pos   = 0xc      // Position of SPI1SMEN field.
	RCC_APBSMENR2_SPI1SMEN_Msk   = 0x1000   // Bit mask of SPI1SMEN field.
	RCC_APBSMENR2_SPI1SMEN       = 0x1000   // Bit SPI1SMEN.
	RCC_APBSMENR2_USART1SMEN_Pos = 0xe      // Position of USART1SMEN field.
	RCC_APBSMENR2_USART1SMEN_Msk = 0x4000   // Bit mask of USART1SMEN field.
	RCC_APBSMENR2_USART1SMEN     = 0x4000   // Bit USART1SMEN.
	RCC_APBSMENR2_TIM14SMEN_Pos  = 0xf      // Position of TIM14SMEN field.
	RCC_APBSMENR2_TIM14SMEN_Msk  = 0x8000   // Bit mask of TIM14SMEN field.
	RCC_APBSMENR2_TIM14SMEN      = 0x8000   // Bit TIM14SMEN.
	RCC_APBSMENR2_TIM15SMEN_Pos  = 0x10     // Position of TIM15SMEN field.
	RCC_APBSMENR2_TIM15SMEN_Msk  = 0x10000  // Bit mask of TIM15SMEN field.
	RCC_APBSMENR2_TIM15SMEN      = 0x10000  // Bit TIM15SMEN.
	RCC_APBSMENR2_TIM16SMEN_Pos  = 0x11     // Position of TIM16SMEN field.
	RCC_APBSMENR2_TIM16SMEN_Msk  = 0x20000  // Bit mask of TIM16SMEN field.
	RCC_APBSMENR2_TIM16SMEN      = 0x20000  // Bit TIM16SMEN.
	RCC_APBSMENR2_TIM17SMEN_Pos  = 0x12     // Position of TIM17SMEN field.
	RCC_APBSMENR2_TIM17SMEN_Msk  = 0x40000  // Bit mask of TIM17SMEN field.
	RCC_APBSMENR2_TIM17SMEN      = 0x40000  // Bit TIM17SMEN.
	RCC_APBSMENR2_ADCSMEN_Pos    = 0x14     // Position of ADCSMEN field.
	RCC_APBSMENR2_ADCSMEN_Msk    = 0x100000 // Bit mask of ADCSMEN field.
	RCC_APBSMENR2_ADCSMEN        = 0x100000 // Bit ADCSMEN.

	// CCIPR: Peripherals independent clock configuration           register
	RCC_CCIPR_USART1SEL_Pos  = 0x0        // Position of USART1SEL field.
	RCC_CCIPR_USART1SEL_Msk  = 0x3        // Bit mask of USART1SEL field.
	RCC_CCIPR_USART2SEL_Pos  = 0x2        // Position of USART2SEL field.
	RCC_CCIPR_USART2SEL_Msk  = 0xc        // Bit mask of USART2SEL field.
	RCC_CCIPR_CECSEL_Pos     = 0x6        // Position of CECSEL field.
	RCC_CCIPR_CECSEL_Msk     = 0x40       // Bit mask of CECSEL field.
	RCC_CCIPR_CECSEL         = 0x40       // Bit CECSEL.
	RCC_CCIPR_LPUART1SEL_Pos = 0xa        // Position of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Msk = 0xc00      // Bit mask of LPUART1SEL field.
	RCC_CCIPR_I2C1SEL_Pos    = 0xc        // Position of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Msk    = 0x3000     // Bit mask of I2C1SEL field.
	RCC_CCIPR_I2S2SEL_Pos    = 0xe        // Position of I2S2SEL field.
	RCC_CCIPR_I2S2SEL_Msk    = 0xc000     // Bit mask of I2S2SEL field.
	RCC_CCIPR_LPTIM1SEL_Pos  = 0x12       // Position of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Msk  = 0xc0000    // Bit mask of LPTIM1SEL field.
	RCC_CCIPR_LPTIM2SEL_Pos  = 0x14       // Position of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Msk  = 0x300000   // Bit mask of LPTIM2SEL field.
	RCC_CCIPR_TIM1SEL_Pos    = 0x16       // Position of TIM1SEL field.
	RCC_CCIPR_TIM1SEL_Msk    = 0x400000   // Bit mask of TIM1SEL field.
	RCC_CCIPR_TIM1SEL        = 0x400000   // Bit TIM1SEL.
	RCC_CCIPR_TIM15SEL_Pos   = 0x18       // Position of TIM15SEL field.
	RCC_CCIPR_TIM15SEL_Msk   = 0x1000000  // Bit mask of TIM15SEL field.
	RCC_CCIPR_TIM15SEL       = 0x1000000  // Bit TIM15SEL.
	RCC_CCIPR_RNGSEL_Pos     = 0x1a       // Position of RNGSEL field.
	RCC_CCIPR_RNGSEL_Msk     = 0xc000000  // Bit mask of RNGSEL field.
	RCC_CCIPR_RNGDIV_Pos     = 0x1c       // Position of RNGDIV field.
	RCC_CCIPR_RNGDIV_Msk     = 0x30000000 // Bit mask of RNGDIV field.
	RCC_CCIPR_ADCSEL_Pos     = 0x1e       // Position of ADCSEL field.
	RCC_CCIPR_ADCSEL_Msk     = 0xc0000000 // Bit mask of ADCSEL field.

	// BDCR: RTC domain control register
	RCC_BDCR_LSEON_Pos    = 0x0       // Position of LSEON field.
	RCC_BDCR_LSEON_Msk    = 0x1       // Bit mask of LSEON field.
	RCC_BDCR_LSEON        = 0x1       // Bit LSEON.
	RCC_BDCR_LSERDY_Pos   = 0x1       // Position of LSERDY field.
	RCC_BDCR_LSERDY_Msk   = 0x2       // Bit mask of LSERDY field.
	RCC_BDCR_LSERDY       = 0x2       // Bit LSERDY.
	RCC_BDCR_LSEBYP_Pos   = 0x2       // Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk   = 0x4       // Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP       = 0x4       // Bit LSEBYP.
	RCC_BDCR_LSEDRV_Pos   = 0x3       // Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk   = 0x18      // Bit mask of LSEDRV field.
	RCC_BDCR_LSECSSON_Pos = 0x5       // Position of LSECSSON field.
	RCC_BDCR_LSECSSON_Msk = 0x20      // Bit mask of LSECSSON field.
	RCC_BDCR_LSECSSON     = 0x20      // Bit LSECSSON.
	RCC_BDCR_LSECSSD_Pos  = 0x6       // Position of LSECSSD field.
	RCC_BDCR_LSECSSD_Msk  = 0x40      // Bit mask of LSECSSD field.
	RCC_BDCR_LSECSSD      = 0x40      // Bit LSECSSD.
	RCC_BDCR_RTCSEL_Pos   = 0x8       // Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk   = 0x300     // Bit mask of RTCSEL field.
	RCC_BDCR_RTCEN_Pos    = 0xf       // Position of RTCEN field.
	RCC_BDCR_RTCEN_Msk    = 0x8000    // Bit mask of RTCEN field.
	RCC_BDCR_RTCEN        = 0x8000    // Bit RTCEN.
	RCC_BDCR_BDRST_Pos    = 0x10      // Position of BDRST field.
	RCC_BDCR_BDRST_Msk    = 0x10000   // Bit mask of BDRST field.
	RCC_BDCR_BDRST        = 0x10000   // Bit BDRST.
	RCC_BDCR_LSCOEN_Pos   = 0x18      // Position of LSCOEN field.
	RCC_BDCR_LSCOEN_Msk   = 0x1000000 // Bit mask of LSCOEN field.
	RCC_BDCR_LSCOEN       = 0x1000000 // Bit LSCOEN.
	RCC_BDCR_LSCOSEL_Pos  = 0x19      // Position of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Msk  = 0x2000000 // Bit mask of LSCOSEL field.
	RCC_BDCR_LSCOSEL      = 0x2000000 // Bit LSCOSEL.

	// CSR: Control/status register
	RCC_CSR_LSION_Pos    = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk    = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION        = 0x1        // Bit LSION.
	RCC_CSR_LSIRDY_Pos   = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk   = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY       = 0x2        // Bit LSIRDY.
	RCC_CSR_RMVF_Pos     = 0x17       // Position of RMVF field.
	RCC_CSR_RMVF_Msk     = 0x800000   // Bit mask of RMVF field.
	RCC_CSR_RMVF         = 0x800000   // Bit RMVF.
	RCC_CSR_OBLRSTF_Pos  = 0x19       // Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk  = 0x2000000  // Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF      = 0x2000000  // Bit OBLRSTF.
	RCC_CSR_PINRSTF_Pos  = 0x1a       // Position of PINRSTF field.
	RCC_CSR_PINRSTF_Msk  = 0x4000000  // Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF      = 0x4000000  // Bit PINRSTF.
	RCC_CSR_PWRRSTF_Pos  = 0x1b       // Position of PWRRSTF field.
	RCC_CSR_PWRRSTF_Msk  = 0x8000000  // Bit mask of PWRRSTF field.
	RCC_CSR_PWRRSTF      = 0x8000000  // Bit PWRRSTF.
	RCC_CSR_SFTRSTF_Pos  = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk  = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF      = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_IWDGRSTF_Pos = 0x1d       // Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000 // Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF     = 0x20000000 // Bit IWDGRSTF.
	RCC_CSR_WWDGRSTF_Pos = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF     = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_LPWRRSTF_Pos = 0x1f       // Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000 // Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF     = 0x80000000 // Bit LPWRRSTF.
)

// Bitfields for PWR: Power control
const (
	// CR1: Power control register 1
	PWR_CR1_LPR_Pos       = 0xe    // Position of LPR field.
	PWR_CR1_LPR_Msk       = 0x4000 // Bit mask of LPR field.
	PWR_CR1_LPR           = 0x4000 // Bit LPR.
	PWR_CR1_VOS_Pos       = 0x9    // Position of VOS field.
	PWR_CR1_VOS_Msk       = 0x600  // Bit mask of VOS field.
	PWR_CR1_DBP_Pos       = 0x8    // Position of DBP field.
	PWR_CR1_DBP_Msk       = 0x100  // Bit mask of DBP field.
	PWR_CR1_DBP           = 0x100  // Bit DBP.
	PWR_CR1_FPD_LPSLP_Pos = 0x5    // Position of FPD_LPSLP field.
	PWR_CR1_FPD_LPSLP_Msk = 0x20   // Bit mask of FPD_LPSLP field.
	PWR_CR1_FPD_LPSLP     = 0x20   // Bit FPD_LPSLP.
	PWR_CR1_FPD_LPRUN_Pos = 0x4    // Position of FPD_LPRUN field.
	PWR_CR1_FPD_LPRUN_Msk = 0x10   // Bit mask of FPD_LPRUN field.
	PWR_CR1_FPD_LPRUN     = 0x10   // Bit FPD_LPRUN.
	PWR_CR1_FPD_STOP_Pos  = 0x3    // Position of FPD_STOP field.
	PWR_CR1_FPD_STOP_Msk  = 0x8    // Bit mask of FPD_STOP field.
	PWR_CR1_FPD_STOP      = 0x8    // Bit FPD_STOP.
	PWR_CR1_LPMS_Pos      = 0x0    // Position of LPMS field.
	PWR_CR1_LPMS_Msk      = 0x7    // Bit mask of LPMS field.

	// CR2: Power control register 2
	PWR_CR2_PVDE_Pos  = 0x0  // Position of PVDE field.
	PWR_CR2_PVDE_Msk  = 0x1  // Bit mask of PVDE field.
	PWR_CR2_PVDE      = 0x1  // Bit PVDE.
	PWR_CR2_PVDFT_Pos = 0x1  // Position of PVDFT field.
	PWR_CR2_PVDFT_Msk = 0xe  // Bit mask of PVDFT field.
	PWR_CR2_PVDRT_Pos = 0x4  // Position of PVDRT field.
	PWR_CR2_PVDRT_Msk = 0x70 // Bit mask of PVDRT field.

	// CR3: Power control register 3
	PWR_CR3_EWUP1_Pos = 0x0    // Position of EWUP1 field.
	PWR_CR3_EWUP1_Msk = 0x1    // Bit mask of EWUP1 field.
	PWR_CR3_EWUP1     = 0x1    // Bit EWUP1.
	PWR_CR3_EWUP2_Pos = 0x1    // Position of EWUP2 field.
	PWR_CR3_EWUP2_Msk = 0x2    // Bit mask of EWUP2 field.
	PWR_CR3_EWUP2     = 0x2    // Bit EWUP2.
	PWR_CR3_EWUP4_Pos = 0x3    // Position of EWUP4 field.
	PWR_CR3_EWUP4_Msk = 0x8    // Bit mask of EWUP4 field.
	PWR_CR3_EWUP4     = 0x8    // Bit EWUP4.
	PWR_CR3_EWUP5_Pos = 0x4    // Position of EWUP5 field.
	PWR_CR3_EWUP5_Msk = 0x10   // Bit mask of EWUP5 field.
	PWR_CR3_EWUP5     = 0x10   // Bit EWUP5.
	PWR_CR3_EWUP6_Pos = 0x5    // Position of EWUP6 field.
	PWR_CR3_EWUP6_Msk = 0x20   // Bit mask of EWUP6 field.
	PWR_CR3_EWUP6     = 0x20   // Bit EWUP6.
	PWR_CR3_RRS_Pos   = 0x8    // Position of RRS field.
	PWR_CR3_RRS_Msk   = 0x100  // Bit mask of RRS field.
	PWR_CR3_RRS       = 0x100  // Bit RRS.
	PWR_CR3_ULPEN_Pos = 0x9    // Position of ULPEN field.
	PWR_CR3_ULPEN_Msk = 0x200  // Bit mask of ULPEN field.
	PWR_CR3_ULPEN     = 0x200  // Bit ULPEN.
	PWR_CR3_APC_Pos   = 0xa    // Position of APC field.
	PWR_CR3_APC_Msk   = 0x400  // Bit mask of APC field.
	PWR_CR3_APC       = 0x400  // Bit APC.
	PWR_CR3_EIWUL_Pos = 0xf    // Position of EIWUL field.
	PWR_CR3_EIWUL_Msk = 0x8000 // Bit mask of EIWUL field.
	PWR_CR3_EIWUL     = 0x8000 // Bit EIWUL.

	// CR4: Power control register 4
	PWR_CR4_WP1_Pos  = 0x0   // Position of WP1 field.
	PWR_CR4_WP1_Msk  = 0x1   // Bit mask of WP1 field.
	PWR_CR4_WP1      = 0x1   // Bit WP1.
	PWR_CR4_WP2_Pos  = 0x1   // Position of WP2 field.
	PWR_CR4_WP2_Msk  = 0x2   // Bit mask of WP2 field.
	PWR_CR4_WP2      = 0x2   // Bit WP2.
	PWR_CR4_WP4_Pos  = 0x3   // Position of WP4 field.
	PWR_CR4_WP4_Msk  = 0x8   // Bit mask of WP4 field.
	PWR_CR4_WP4      = 0x8   // Bit WP4.
	PWR_CR4_WP5_Pos  = 0x4   // Position of WP5 field.
	PWR_CR4_WP5_Msk  = 0x10  // Bit mask of WP5 field.
	PWR_CR4_WP5      = 0x10  // Bit WP5.
	PWR_CR4_WP6_Pos  = 0x5   // Position of WP6 field.
	PWR_CR4_WP6_Msk  = 0x20  // Bit mask of WP6 field.
	PWR_CR4_WP6      = 0x20  // Bit WP6.
	PWR_CR4_VBE_Pos  = 0x8   // Position of VBE field.
	PWR_CR4_VBE_Msk  = 0x100 // Bit mask of VBE field.
	PWR_CR4_VBE      = 0x100 // Bit VBE.
	PWR_CR4_VBRS_Pos = 0x9   // Position of VBRS field.
	PWR_CR4_VBRS_Msk = 0x200 // Bit mask of VBRS field.
	PWR_CR4_VBRS     = 0x200 // Bit VBRS.

	// SR1: Power status register 1
	PWR_SR1_WUF1_Pos = 0x0    // Position of WUF1 field.
	PWR_SR1_WUF1_Msk = 0x1    // Bit mask of WUF1 field.
	PWR_SR1_WUF1     = 0x1    // Bit WUF1.
	PWR_SR1_WUF2_Pos = 0x1    // Position of WUF2 field.
	PWR_SR1_WUF2_Msk = 0x2    // Bit mask of WUF2 field.
	PWR_SR1_WUF2     = 0x2    // Bit WUF2.
	PWR_SR1_WUF4_Pos = 0x3    // Position of WUF4 field.
	PWR_SR1_WUF4_Msk = 0x8    // Bit mask of WUF4 field.
	PWR_SR1_WUF4     = 0x8    // Bit WUF4.
	PWR_SR1_WUF5_Pos = 0x4    // Position of WUF5 field.
	PWR_SR1_WUF5_Msk = 0x10   // Bit mask of WUF5 field.
	PWR_SR1_WUF5     = 0x10   // Bit WUF5.
	PWR_SR1_WUF6_Pos = 0x5    // Position of WUF6 field.
	PWR_SR1_WUF6_Msk = 0x20   // Bit mask of WUF6 field.
	PWR_SR1_WUF6     = 0x20   // Bit WUF6.
	PWR_SR1_SBF_Pos  = 0x8    // Position of SBF field.
	PWR_SR1_SBF_Msk  = 0x100  // Bit mask of SBF field.
	PWR_SR1_SBF      = 0x100  // Bit SBF.
	PWR_SR1_WUFI_Pos = 0xf    // Position of WUFI field.
	PWR_SR1_WUFI_Msk = 0x8000 // Bit mask of WUFI field.
	PWR_SR1_WUFI     = 0x8000 // Bit WUFI.

	// SR2: Power status register 2
	PWR_SR2_PVDO_Pos      = 0xb   // Position of PVDO field.
	PWR_SR2_PVDO_Msk      = 0x800 // Bit mask of PVDO field.
	PWR_SR2_PVDO          = 0x800 // Bit PVDO.
	PWR_SR2_VOSF_Pos      = 0xa   // Position of VOSF field.
	PWR_SR2_VOSF_Msk      = 0x400 // Bit mask of VOSF field.
	PWR_SR2_VOSF          = 0x400 // Bit VOSF.
	PWR_SR2_REGLPF_Pos    = 0x9   // Position of REGLPF field.
	PWR_SR2_REGLPF_Msk    = 0x200 // Bit mask of REGLPF field.
	PWR_SR2_REGLPF        = 0x200 // Bit REGLPF.
	PWR_SR2_REGLPS_Pos    = 0x8   // Position of REGLPS field.
	PWR_SR2_REGLPS_Msk    = 0x100 // Bit mask of REGLPS field.
	PWR_SR2_REGLPS        = 0x100 // Bit REGLPS.
	PWR_SR2_FLASH_RDY_Pos = 0x7   // Position of FLASH_RDY field.
	PWR_SR2_FLASH_RDY_Msk = 0x80  // Bit mask of FLASH_RDY field.
	PWR_SR2_FLASH_RDY     = 0x80  // Bit FLASH_RDY.

	// SCR: Power status clear register
	PWR_SCR_CSBF_Pos  = 0x8   // Position of CSBF field.
	PWR_SCR_CSBF_Msk  = 0x100 // Bit mask of CSBF field.
	PWR_SCR_CSBF      = 0x100 // Bit CSBF.
	PWR_SCR_CWUF6_Pos = 0x5   // Position of CWUF6 field.
	PWR_SCR_CWUF6_Msk = 0x20  // Bit mask of CWUF6 field.
	PWR_SCR_CWUF6     = 0x20  // Bit CWUF6.
	PWR_SCR_CWUF5_Pos = 0x4   // Position of CWUF5 field.
	PWR_SCR_CWUF5_Msk = 0x10  // Bit mask of CWUF5 field.
	PWR_SCR_CWUF5     = 0x10  // Bit CWUF5.
	PWR_SCR_CWUF4_Pos = 0x3   // Position of CWUF4 field.
	PWR_SCR_CWUF4_Msk = 0x8   // Bit mask of CWUF4 field.
	PWR_SCR_CWUF4     = 0x8   // Bit CWUF4.
	PWR_SCR_CWUF2_Pos = 0x1   // Position of CWUF2 field.
	PWR_SCR_CWUF2_Msk = 0x2   // Bit mask of CWUF2 field.
	PWR_SCR_CWUF2     = 0x2   // Bit CWUF2.
	PWR_SCR_CWUF1_Pos = 0x0   // Position of CWUF1 field.
	PWR_SCR_CWUF1_Msk = 0x1   // Bit mask of CWUF1 field.
	PWR_SCR_CWUF1     = 0x1   // Bit CWUF1.

	// PUCRA: Power Port A pull-up control           register
	PWR_PUCRA_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRA_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRA_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRA_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRA_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRA_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRA_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRA_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRA_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRA_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRA_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRA_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRA_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRA_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRA_PU11     = 0x800  // Bit PU11.
	PWR_PUCRA_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRA_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRA_PU10     = 0x400  // Bit PU10.
	PWR_PUCRA_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRA_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRA_PU9      = 0x200  // Bit PU9.
	PWR_PUCRA_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRA_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRA_PU8      = 0x100  // Bit PU8.
	PWR_PUCRA_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRA_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRA_PU7      = 0x80   // Bit PU7.
	PWR_PUCRA_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRA_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRA_PU6      = 0x40   // Bit PU6.
	PWR_PUCRA_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRA_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRA_PU5      = 0x20   // Bit PU5.
	PWR_PUCRA_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRA_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRA_PU4      = 0x10   // Bit PU4.
	PWR_PUCRA_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRA_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRA_PU3      = 0x8    // Bit PU3.
	PWR_PUCRA_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRA_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRA_PU2      = 0x4    // Bit PU2.
	PWR_PUCRA_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRA_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRA_PU1      = 0x2    // Bit PU1.
	PWR_PUCRA_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRA_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRA_PU0      = 0x1    // Bit PU0.

	// PDCRA: Power Port A pull-down control           register
	PWR_PDCRA_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRA_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRA_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRA_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRA_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRA_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRA_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRA_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRA_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRA_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRA_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRA_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRA_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRA_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRA_PD11     = 0x800  // Bit PD11.
	PWR_PDCRA_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRA_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRA_PD10     = 0x400  // Bit PD10.
	PWR_PDCRA_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRA_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRA_PD9      = 0x200  // Bit PD9.
	PWR_PDCRA_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRA_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRA_PD8      = 0x100  // Bit PD8.
	PWR_PDCRA_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRA_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRA_PD7      = 0x80   // Bit PD7.
	PWR_PDCRA_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRA_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRA_PD6      = 0x40   // Bit PD6.
	PWR_PDCRA_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRA_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRA_PD5      = 0x20   // Bit PD5.
	PWR_PDCRA_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRA_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRA_PD4      = 0x10   // Bit PD4.
	PWR_PDCRA_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRA_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRA_PD3      = 0x8    // Bit PD3.
	PWR_PDCRA_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRA_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRA_PD2      = 0x4    // Bit PD2.
	PWR_PDCRA_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRA_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRA_PD1      = 0x2    // Bit PD1.
	PWR_PDCRA_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRA_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRA_PD0      = 0x1    // Bit PD0.

	// PUCRB: Power Port B pull-up control           register
	PWR_PUCRB_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRB_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRB_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRB_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRB_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRB_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRB_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRB_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRB_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRB_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRB_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRB_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRB_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRB_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRB_PU11     = 0x800  // Bit PU11.
	PWR_PUCRB_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRB_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRB_PU10     = 0x400  // Bit PU10.
	PWR_PUCRB_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRB_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRB_PU9      = 0x200  // Bit PU9.
	PWR_PUCRB_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRB_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRB_PU8      = 0x100  // Bit PU8.
	PWR_PUCRB_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRB_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRB_PU7      = 0x80   // Bit PU7.
	PWR_PUCRB_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRB_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRB_PU6      = 0x40   // Bit PU6.
	PWR_PUCRB_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRB_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRB_PU5      = 0x20   // Bit PU5.
	PWR_PUCRB_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRB_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRB_PU4      = 0x10   // Bit PU4.
	PWR_PUCRB_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRB_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRB_PU3      = 0x8    // Bit PU3.
	PWR_PUCRB_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRB_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRB_PU2      = 0x4    // Bit PU2.
	PWR_PUCRB_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRB_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRB_PU1      = 0x2    // Bit PU1.
	PWR_PUCRB_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRB_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRB_PU0      = 0x1    // Bit PU0.

	// PDCRB: Power Port B pull-down control           register
	PWR_PDCRB_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRB_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRB_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRB_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRB_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRB_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRB_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRB_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRB_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRB_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRB_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRB_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRB_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRB_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRB_PD11     = 0x800  // Bit PD11.
	PWR_PDCRB_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRB_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRB_PD10     = 0x400  // Bit PD10.
	PWR_PDCRB_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRB_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRB_PD9      = 0x200  // Bit PD9.
	PWR_PDCRB_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRB_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRB_PD8      = 0x100  // Bit PD8.
	PWR_PDCRB_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRB_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRB_PD7      = 0x80   // Bit PD7.
	PWR_PDCRB_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRB_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRB_PD6      = 0x40   // Bit PD6.
	PWR_PDCRB_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRB_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRB_PD5      = 0x20   // Bit PD5.
	PWR_PDCRB_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRB_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRB_PD4      = 0x10   // Bit PD4.
	PWR_PDCRB_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRB_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRB_PD3      = 0x8    // Bit PD3.
	PWR_PDCRB_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRB_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRB_PD2      = 0x4    // Bit PD2.
	PWR_PDCRB_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRB_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRB_PD1      = 0x2    // Bit PD1.
	PWR_PDCRB_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRB_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRB_PD0      = 0x1    // Bit PD0.

	// PUCRC: Power Port C pull-up control           register
	PWR_PUCRC_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRC_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRC_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRC_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRC_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRC_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRC_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRC_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRC_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRC_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRC_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRC_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRC_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRC_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRC_PU11     = 0x800  // Bit PU11.
	PWR_PUCRC_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRC_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRC_PU10     = 0x400  // Bit PU10.
	PWR_PUCRC_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRC_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRC_PU9      = 0x200  // Bit PU9.
	PWR_PUCRC_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRC_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRC_PU8      = 0x100  // Bit PU8.
	PWR_PUCRC_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRC_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRC_PU7      = 0x80   // Bit PU7.
	PWR_PUCRC_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRC_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRC_PU6      = 0x40   // Bit PU6.
	PWR_PUCRC_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRC_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRC_PU5      = 0x20   // Bit PU5.
	PWR_PUCRC_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRC_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRC_PU4      = 0x10   // Bit PU4.
	PWR_PUCRC_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRC_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRC_PU3      = 0x8    // Bit PU3.
	PWR_PUCRC_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRC_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRC_PU2      = 0x4    // Bit PU2.
	PWR_PUCRC_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRC_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRC_PU1      = 0x2    // Bit PU1.
	PWR_PUCRC_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRC_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRC_PU0      = 0x1    // Bit PU0.

	// PDCRC: Power Port C pull-down control           register
	PWR_PDCRC_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRC_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRC_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRC_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRC_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRC_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRC_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRC_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRC_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRC_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRC_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRC_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRC_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRC_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRC_PD11     = 0x800  // Bit PD11.
	PWR_PDCRC_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRC_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRC_PD10     = 0x400  // Bit PD10.
	PWR_PDCRC_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRC_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRC_PD9      = 0x200  // Bit PD9.
	PWR_PDCRC_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRC_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRC_PD8      = 0x100  // Bit PD8.
	PWR_PDCRC_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRC_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRC_PD7      = 0x80   // Bit PD7.
	PWR_PDCRC_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRC_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRC_PD6      = 0x40   // Bit PD6.
	PWR_PDCRC_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRC_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRC_PD5      = 0x20   // Bit PD5.
	PWR_PDCRC_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRC_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRC_PD4      = 0x10   // Bit PD4.
	PWR_PDCRC_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRC_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRC_PD3      = 0x8    // Bit PD3.
	PWR_PDCRC_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRC_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRC_PD2      = 0x4    // Bit PD2.
	PWR_PDCRC_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRC_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRC_PD1      = 0x2    // Bit PD1.
	PWR_PDCRC_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRC_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRC_PD0      = 0x1    // Bit PD0.

	// PUCRD: Power Port D pull-up control           register
	PWR_PUCRD_PU9_Pos = 0x9   // Position of PU9 field.
	PWR_PUCRD_PU9_Msk = 0x200 // Bit mask of PU9 field.
	PWR_PUCRD_PU9     = 0x200 // Bit PU9.
	PWR_PUCRD_PU8_Pos = 0x8   // Position of PU8 field.
	PWR_PUCRD_PU8_Msk = 0x100 // Bit mask of PU8 field.
	PWR_PUCRD_PU8     = 0x100 // Bit PU8.
	PWR_PUCRD_PU6_Pos = 0x6   // Position of PU6 field.
	PWR_PUCRD_PU6_Msk = 0x40  // Bit mask of PU6 field.
	PWR_PUCRD_PU6     = 0x40  // Bit PU6.
	PWR_PUCRD_PU5_Pos = 0x5   // Position of PU5 field.
	PWR_PUCRD_PU5_Msk = 0x20  // Bit mask of PU5 field.
	PWR_PUCRD_PU5     = 0x20  // Bit PU5.
	PWR_PUCRD_PU4_Pos = 0x4   // Position of PU4 field.
	PWR_PUCRD_PU4_Msk = 0x10  // Bit mask of PU4 field.
	PWR_PUCRD_PU4     = 0x10  // Bit PU4.
	PWR_PUCRD_PU3_Pos = 0x3   // Position of PU3 field.
	PWR_PUCRD_PU3_Msk = 0x8   // Bit mask of PU3 field.
	PWR_PUCRD_PU3     = 0x8   // Bit PU3.
	PWR_PUCRD_PU2_Pos = 0x2   // Position of PU2 field.
	PWR_PUCRD_PU2_Msk = 0x4   // Bit mask of PU2 field.
	PWR_PUCRD_PU2     = 0x4   // Bit PU2.
	PWR_PUCRD_PU1_Pos = 0x1   // Position of PU1 field.
	PWR_PUCRD_PU1_Msk = 0x2   // Bit mask of PU1 field.
	PWR_PUCRD_PU1     = 0x2   // Bit PU1.
	PWR_PUCRD_PU0_Pos = 0x0   // Position of PU0 field.
	PWR_PUCRD_PU0_Msk = 0x1   // Bit mask of PU0 field.
	PWR_PUCRD_PU0     = 0x1   // Bit PU0.

	// PDCRD: Power Port D pull-down control           register
	PWR_PDCRD_PD9_Pos = 0x9   // Position of PD9 field.
	PWR_PDCRD_PD9_Msk = 0x200 // Bit mask of PD9 field.
	PWR_PDCRD_PD9     = 0x200 // Bit PD9.
	PWR_PDCRD_PD8_Pos = 0x8   // Position of PD8 field.
	PWR_PDCRD_PD8_Msk = 0x100 // Bit mask of PD8 field.
	PWR_PDCRD_PD8     = 0x100 // Bit PD8.
	PWR_PDCRD_PD6_Pos = 0x6   // Position of PD6 field.
	PWR_PDCRD_PD6_Msk = 0x40  // Bit mask of PD6 field.
	PWR_PDCRD_PD6     = 0x40  // Bit PD6.
	PWR_PDCRD_PD5_Pos = 0x5   // Position of PD5 field.
	PWR_PDCRD_PD5_Msk = 0x20  // Bit mask of PD5 field.
	PWR_PDCRD_PD5     = 0x20  // Bit PD5.
	PWR_PDCRD_PD4_Pos = 0x4   // Position of PD4 field.
	PWR_PDCRD_PD4_Msk = 0x10  // Bit mask of PD4 field.
	PWR_PDCRD_PD4     = 0x10  // Bit PD4.
	PWR_PDCRD_PD3_Pos = 0x3   // Position of PD3 field.
	PWR_PDCRD_PD3_Msk = 0x8   // Bit mask of PD3 field.
	PWR_PDCRD_PD3     = 0x8   // Bit PD3.
	PWR_PDCRD_PD2_Pos = 0x2   // Position of PD2 field.
	PWR_PDCRD_PD2_Msk = 0x4   // Bit mask of PD2 field.
	PWR_PDCRD_PD2     = 0x4   // Bit PD2.
	PWR_PDCRD_PD1_Pos = 0x1   // Position of PD1 field.
	PWR_PDCRD_PD1_Msk = 0x2   // Bit mask of PD1 field.
	PWR_PDCRD_PD1     = 0x2   // Bit PD1.
	PWR_PDCRD_PD0_Pos = 0x0   // Position of PD0 field.
	PWR_PDCRD_PD0_Msk = 0x1   // Bit mask of PD0 field.
	PWR_PDCRD_PD0     = 0x1   // Bit PD0.

	// PUCRF: Power Port F pull-up control           register
	PWR_PUCRF_PU2_Pos = 0x2 // Position of PU2 field.
	PWR_PUCRF_PU2_Msk = 0x4 // Bit mask of PU2 field.
	PWR_PUCRF_PU2     = 0x4 // Bit PU2.
	PWR_PUCRF_PU1_Pos = 0x1 // Position of PU1 field.
	PWR_PUCRF_PU1_Msk = 0x2 // Bit mask of PU1 field.
	PWR_PUCRF_PU1     = 0x2 // Bit PU1.
	PWR_PUCRF_PU0_Pos = 0x0 // Position of PU0 field.
	PWR_PUCRF_PU0_Msk = 0x1 // Bit mask of PU0 field.
	PWR_PUCRF_PU0     = 0x1 // Bit PU0.

	// PDCRF: Power Port F pull-down control           register
	PWR_PDCRF_PD2_Pos = 0x2 // Position of PD2 field.
	PWR_PDCRF_PD2_Msk = 0x4 // Bit mask of PD2 field.
	PWR_PDCRF_PD2     = 0x4 // Bit PD2.
	PWR_PDCRF_PD1_Pos = 0x1 // Position of PD1 field.
	PWR_PDCRF_PD1_Msk = 0x2 // Bit mask of PD1 field.
	PWR_PDCRF_PD1     = 0x2 // Bit PD1.
	PWR_PDCRF_PD0_Pos = 0x0 // Position of PD0 field.
	PWR_PDCRF_PD0_Msk = 0x1 // Bit mask of PD0 field.
	PWR_PDCRF_PD0     = 0x1 // Bit PD0.
)

// Bitfields for DMA: DMA controller
const (
	// ISR: low interrupt status register
	DMA_ISR_GIF0_Pos   = 0x0       // Position of GIF0 field.
	DMA_ISR_GIF0_Msk   = 0x1       // Bit mask of GIF0 field.
	DMA_ISR_GIF0       = 0x1       // Bit GIF0.
	DMA_ISR_TCIF1_Pos  = 0x1       // Position of TCIF1 field.
	DMA_ISR_TCIF1_Msk  = 0x2       // Bit mask of TCIF1 field.
	DMA_ISR_TCIF1      = 0x2       // Bit TCIF1.
	DMA_ISR_HTIF2_Pos  = 0x2       // Position of HTIF2 field.
	DMA_ISR_HTIF2_Msk  = 0x4       // Bit mask of HTIF2 field.
	DMA_ISR_HTIF2      = 0x4       // Bit HTIF2.
	DMA_ISR_TEIF3_Pos  = 0x3       // Position of TEIF3 field.
	DMA_ISR_TEIF3_Msk  = 0x8       // Bit mask of TEIF3 field.
	DMA_ISR_TEIF3      = 0x8       // Bit TEIF3.
	DMA_ISR_GIF4_Pos   = 0x4       // Position of GIF4 field.
	DMA_ISR_GIF4_Msk   = 0x10      // Bit mask of GIF4 field.
	DMA_ISR_GIF4       = 0x10      // Bit GIF4.
	DMA_ISR_TCIF5_Pos  = 0x5       // Position of TCIF5 field.
	DMA_ISR_TCIF5_Msk  = 0x20      // Bit mask of TCIF5 field.
	DMA_ISR_TCIF5      = 0x20      // Bit TCIF5.
	DMA_ISR_HTIF6_Pos  = 0x6       // Position of HTIF6 field.
	DMA_ISR_HTIF6_Msk  = 0x40      // Bit mask of HTIF6 field.
	DMA_ISR_HTIF6      = 0x40      // Bit HTIF6.
	DMA_ISR_TEIF7_Pos  = 0x7       // Position of TEIF7 field.
	DMA_ISR_TEIF7_Msk  = 0x80      // Bit mask of TEIF7 field.
	DMA_ISR_TEIF7      = 0x80      // Bit TEIF7.
	DMA_ISR_GIF8_Pos   = 0x8       // Position of GIF8 field.
	DMA_ISR_GIF8_Msk   = 0x100     // Bit mask of GIF8 field.
	DMA_ISR_GIF8       = 0x100     // Bit GIF8.
	DMA_ISR_TCIF9_Pos  = 0x9       // Position of TCIF9 field.
	DMA_ISR_TCIF9_Msk  = 0x200     // Bit mask of TCIF9 field.
	DMA_ISR_TCIF9      = 0x200     // Bit TCIF9.
	DMA_ISR_HTIF10_Pos = 0xa       // Position of HTIF10 field.
	DMA_ISR_HTIF10_Msk = 0x400     // Bit mask of HTIF10 field.
	DMA_ISR_HTIF10     = 0x400     // Bit HTIF10.
	DMA_ISR_TEIF11_Pos = 0xb       // Position of TEIF11 field.
	DMA_ISR_TEIF11_Msk = 0x800     // Bit mask of TEIF11 field.
	DMA_ISR_TEIF11     = 0x800     // Bit TEIF11.
	DMA_ISR_GIF12_Pos  = 0xc       // Position of GIF12 field.
	DMA_ISR_GIF12_Msk  = 0x1000    // Bit mask of GIF12 field.
	DMA_ISR_GIF12      = 0x1000    // Bit GIF12.
	DMA_ISR_TCIF13_Pos = 0xd       // Position of TCIF13 field.
	DMA_ISR_TCIF13_Msk = 0x2000    // Bit mask of TCIF13 field.
	DMA_ISR_TCIF13     = 0x2000    // Bit TCIF13.
	DMA_ISR_HTIF14_Pos = 0xe       // Position of HTIF14 field.
	DMA_ISR_HTIF14_Msk = 0x4000    // Bit mask of HTIF14 field.
	DMA_ISR_HTIF14     = 0x4000    // Bit HTIF14.
	DMA_ISR_TEIF15_Pos = 0xf       // Position of TEIF15 field.
	DMA_ISR_TEIF15_Msk = 0x8000    // Bit mask of TEIF15 field.
	DMA_ISR_TEIF15     = 0x8000    // Bit TEIF15.
	DMA_ISR_GIF16_Pos  = 0x10      // Position of GIF16 field.
	DMA_ISR_GIF16_Msk  = 0x10000   // Bit mask of GIF16 field.
	DMA_ISR_GIF16      = 0x10000   // Bit GIF16.
	DMA_ISR_TCIF17_Pos = 0x11      // Position of TCIF17 field.
	DMA_ISR_TCIF17_Msk = 0x20000   // Bit mask of TCIF17 field.
	DMA_ISR_TCIF17     = 0x20000   // Bit TCIF17.
	DMA_ISR_HTIF18_Pos = 0x12      // Position of HTIF18 field.
	DMA_ISR_HTIF18_Msk = 0x40000   // Bit mask of HTIF18 field.
	DMA_ISR_HTIF18     = 0x40000   // Bit HTIF18.
	DMA_ISR_TEIF19_Pos = 0x13      // Position of TEIF19 field.
	DMA_ISR_TEIF19_Msk = 0x80000   // Bit mask of TEIF19 field.
	DMA_ISR_TEIF19     = 0x80000   // Bit TEIF19.
	DMA_ISR_GIF20_Pos  = 0x14      // Position of GIF20 field.
	DMA_ISR_GIF20_Msk  = 0x100000  // Bit mask of GIF20 field.
	DMA_ISR_GIF20      = 0x100000  // Bit GIF20.
	DMA_ISR_TCIF21_Pos = 0x15      // Position of TCIF21 field.
	DMA_ISR_TCIF21_Msk = 0x200000  // Bit mask of TCIF21 field.
	DMA_ISR_TCIF21     = 0x200000  // Bit TCIF21.
	DMA_ISR_HTIF22_Pos = 0x16      // Position of HTIF22 field.
	DMA_ISR_HTIF22_Msk = 0x400000  // Bit mask of HTIF22 field.
	DMA_ISR_HTIF22     = 0x400000  // Bit HTIF22.
	DMA_ISR_TEIF23_Pos = 0x17      // Position of TEIF23 field.
	DMA_ISR_TEIF23_Msk = 0x800000  // Bit mask of TEIF23 field.
	DMA_ISR_TEIF23     = 0x800000  // Bit TEIF23.
	DMA_ISR_GIF24_Pos  = 0x18      // Position of GIF24 field.
	DMA_ISR_GIF24_Msk  = 0x1000000 // Bit mask of GIF24 field.
	DMA_ISR_GIF24      = 0x1000000 // Bit GIF24.
	DMA_ISR_TCIF25_Pos = 0x19      // Position of TCIF25 field.
	DMA_ISR_TCIF25_Msk = 0x2000000 // Bit mask of TCIF25 field.
	DMA_ISR_TCIF25     = 0x2000000 // Bit TCIF25.
	DMA_ISR_HTIF26_Pos = 0x1a      // Position of HTIF26 field.
	DMA_ISR_HTIF26_Msk = 0x4000000 // Bit mask of HTIF26 field.
	DMA_ISR_HTIF26     = 0x4000000 // Bit HTIF26.
	DMA_ISR_TEIF27_Pos = 0x1b      // Position of TEIF27 field.
	DMA_ISR_TEIF27_Msk = 0x8000000 // Bit mask of TEIF27 field.
	DMA_ISR_TEIF27     = 0x8000000 // Bit TEIF27.

	// IFCR: high interrupt status register
	DMA_IFCR_CGIF0_Pos   = 0x0       // Position of CGIF0 field.
	DMA_IFCR_CGIF0_Msk   = 0x1       // Bit mask of CGIF0 field.
	DMA_IFCR_CGIF0       = 0x1       // Bit CGIF0.
	DMA_IFCR_CTCIF1_Pos  = 0x1       // Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk  = 0x2       // Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1      = 0x2       // Bit CTCIF1.
	DMA_IFCR_CHTIF2_Pos  = 0x2       // Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk  = 0x4       // Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2      = 0x4       // Bit CHTIF2.
	DMA_IFCR_CTEIF3_Pos  = 0x3       // Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk  = 0x8       // Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3      = 0x8       // Bit CTEIF3.
	DMA_IFCR_CGIF4_Pos   = 0x4       // Position of CGIF4 field.
	DMA_IFCR_CGIF4_Msk   = 0x10      // Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4       = 0x10      // Bit CGIF4.
	DMA_IFCR_CTCIF5_Pos  = 0x5       // Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk  = 0x20      // Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5      = 0x20      // Bit CTCIF5.
	DMA_IFCR_CHTIF6_Pos  = 0x6       // Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk  = 0x40      // Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6      = 0x40      // Bit CHTIF6.
	DMA_IFCR_CTEIF7_Pos  = 0x7       // Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk  = 0x80      // Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7      = 0x80      // Bit CTEIF7.
	DMA_IFCR_CGIF8_Pos   = 0x8       // Position of CGIF8 field.
	DMA_IFCR_CGIF8_Msk   = 0x100     // Bit mask of CGIF8 field.
	DMA_IFCR_CGIF8       = 0x100     // Bit CGIF8.
	DMA_IFCR_CTCIF9_Pos  = 0x9       // Position of CTCIF9 field.
	DMA_IFCR_CTCIF9_Msk  = 0x200     // Bit mask of CTCIF9 field.
	DMA_IFCR_CTCIF9      = 0x200     // Bit CTCIF9.
	DMA_IFCR_CHTIF10_Pos = 0xa       // Position of CHTIF10 field.
	DMA_IFCR_CHTIF10_Msk = 0x400     // Bit mask of CHTIF10 field.
	DMA_IFCR_CHTIF10     = 0x400     // Bit CHTIF10.
	DMA_IFCR_CTEIF11_Pos = 0xb       // Position of CTEIF11 field.
	DMA_IFCR_CTEIF11_Msk = 0x800     // Bit mask of CTEIF11 field.
	DMA_IFCR_CTEIF11     = 0x800     // Bit CTEIF11.
	DMA_IFCR_CGIF12_Pos  = 0xc       // Position of CGIF12 field.
	DMA_IFCR_CGIF12_Msk  = 0x1000    // Bit mask of CGIF12 field.
	DMA_IFCR_CGIF12      = 0x1000    // Bit CGIF12.
	DMA_IFCR_CTCIF13_Pos = 0xd       // Position of CTCIF13 field.
	DMA_IFCR_CTCIF13_Msk = 0x2000    // Bit mask of CTCIF13 field.
	DMA_IFCR_CTCIF13     = 0x2000    // Bit CTCIF13.
	DMA_IFCR_CHTIF14_Pos = 0xe       // Position of CHTIF14 field.
	DMA_IFCR_CHTIF14_Msk = 0x4000    // Bit mask of CHTIF14 field.
	DMA_IFCR_CHTIF14     = 0x4000    // Bit CHTIF14.
	DMA_IFCR_CTEIF15_Pos = 0xf       // Position of CTEIF15 field.
	DMA_IFCR_CTEIF15_Msk = 0x8000    // Bit mask of CTEIF15 field.
	DMA_IFCR_CTEIF15     = 0x8000    // Bit CTEIF15.
	DMA_IFCR_CGIF16_Pos  = 0x10      // Position of CGIF16 field.
	DMA_IFCR_CGIF16_Msk  = 0x10000   // Bit mask of CGIF16 field.
	DMA_IFCR_CGIF16      = 0x10000   // Bit CGIF16.
	DMA_IFCR_CTCIF17_Pos = 0x11      // Position of CTCIF17 field.
	DMA_IFCR_CTCIF17_Msk = 0x20000   // Bit mask of CTCIF17 field.
	DMA_IFCR_CTCIF17     = 0x20000   // Bit CTCIF17.
	DMA_IFCR_CHTIF18_Pos = 0x12      // Position of CHTIF18 field.
	DMA_IFCR_CHTIF18_Msk = 0x40000   // Bit mask of CHTIF18 field.
	DMA_IFCR_CHTIF18     = 0x40000   // Bit CHTIF18.
	DMA_IFCR_CTEIF19_Pos = 0x13      // Position of CTEIF19 field.
	DMA_IFCR_CTEIF19_Msk = 0x80000   // Bit mask of CTEIF19 field.
	DMA_IFCR_CTEIF19     = 0x80000   // Bit CTEIF19.
	DMA_IFCR_CGIF20_Pos  = 0x14      // Position of CGIF20 field.
	DMA_IFCR_CGIF20_Msk  = 0x100000  // Bit mask of CGIF20 field.
	DMA_IFCR_CGIF20      = 0x100000  // Bit CGIF20.
	DMA_IFCR_CTCIF21_Pos = 0x15      // Position of CTCIF21 field.
	DMA_IFCR_CTCIF21_Msk = 0x200000  // Bit mask of CTCIF21 field.
	DMA_IFCR_CTCIF21     = 0x200000  // Bit CTCIF21.
	DMA_IFCR_CHTIF22_Pos = 0x16      // Position of CHTIF22 field.
	DMA_IFCR_CHTIF22_Msk = 0x400000  // Bit mask of CHTIF22 field.
	DMA_IFCR_CHTIF22     = 0x400000  // Bit CHTIF22.
	DMA_IFCR_CTEIF23_Pos = 0x17      // Position of CTEIF23 field.
	DMA_IFCR_CTEIF23_Msk = 0x800000  // Bit mask of CTEIF23 field.
	DMA_IFCR_CTEIF23     = 0x800000  // Bit CTEIF23.
	DMA_IFCR_CGIF24_Pos  = 0x18      // Position of CGIF24 field.
	DMA_IFCR_CGIF24_Msk  = 0x1000000 // Bit mask of CGIF24 field.
	DMA_IFCR_CGIF24      = 0x1000000 // Bit CGIF24.
	DMA_IFCR_CTCIF25_Pos = 0x19      // Position of CTCIF25 field.
	DMA_IFCR_CTCIF25_Msk = 0x2000000 // Bit mask of CTCIF25 field.
	DMA_IFCR_CTCIF25     = 0x2000000 // Bit CTCIF25.
	DMA_IFCR_CHTIF26_Pos = 0x1a      // Position of CHTIF26 field.
	DMA_IFCR_CHTIF26_Msk = 0x4000000 // Bit mask of CHTIF26 field.
	DMA_IFCR_CHTIF26     = 0x4000000 // Bit CHTIF26.
	DMA_IFCR_CTEIF27_Pos = 0x1b      // Position of CTEIF27 field.
	DMA_IFCR_CTEIF27_Msk = 0x8000000 // Bit mask of CTEIF27 field.
	DMA_IFCR_CTEIF27     = 0x8000000 // Bit CTEIF27.

	// CCR1: DMA channel x configuration           register
	DMA_CCR1_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR1_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR1_EN          = 0x1    // Bit EN.
	DMA_CCR1_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR1_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR1_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR1_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR1_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR1_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR1_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR1_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR1_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR1_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR1_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR1_DIR         = 0x10   // Bit DIR.
	DMA_CCR1_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR1_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR1_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR1_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR1_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR1_PINC        = 0x40   // Bit PINC.
	DMA_CCR1_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR1_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR1_MINC        = 0x80   // Bit MINC.
	DMA_CCR1_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR1_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR1_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR1_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR1_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR1_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR1_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR1: DMA channel x number of data           register
	DMA_CNDTR1_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR1: DMA channel x peripheral address           register
	DMA_CPAR1_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR1: DMA channel x memory address           register
	DMA_CMAR1_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR2: DMA channel x configuration           register
	DMA_CCR2_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR2_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR2_EN          = 0x1    // Bit EN.
	DMA_CCR2_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR2_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR2_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR2_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR2_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR2_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR2_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR2_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR2_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR2_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR2_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR2_DIR         = 0x10   // Bit DIR.
	DMA_CCR2_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR2_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR2_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR2_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR2_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR2_PINC        = 0x40   // Bit PINC.
	DMA_CCR2_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR2_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR2_MINC        = 0x80   // Bit MINC.
	DMA_CCR2_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR2_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR2_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR2_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR2_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR2_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR2_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR2: DMA channel x number of data           register
	DMA_CNDTR2_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR2: DMA channel x peripheral address           register
	DMA_CPAR2_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR2: DMA channel x memory address           register
	DMA_CMAR2_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR3: DMA channel x configuration           register
	DMA_CCR3_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR3_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR3_EN          = 0x1    // Bit EN.
	DMA_CCR3_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR3_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR3_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR3_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR3_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR3_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR3_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR3_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR3_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR3_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR3_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR3_DIR         = 0x10   // Bit DIR.
	DMA_CCR3_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR3_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR3_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR3_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR3_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR3_PINC        = 0x40   // Bit PINC.
	DMA_CCR3_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR3_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR3_MINC        = 0x80   // Bit MINC.
	DMA_CCR3_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR3_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR3_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR3_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR3_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR3_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR3_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR3: DMA channel x configuration           register
	DMA_CNDTR3_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR3: DMA channel x peripheral address           register
	DMA_CPAR3_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR3: DMA channel x memory address           register
	DMA_CMAR3_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR4: DMA channel x configuration           register
	DMA_CCR4_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR4_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR4_EN          = 0x1    // Bit EN.
	DMA_CCR4_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR4_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR4_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR4_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR4_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR4_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR4_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR4_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR4_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR4_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR4_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR4_DIR         = 0x10   // Bit DIR.
	DMA_CCR4_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR4_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR4_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR4_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR4_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR4_PINC        = 0x40   // Bit PINC.
	DMA_CCR4_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR4_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR4_MINC        = 0x80   // Bit MINC.
	DMA_CCR4_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR4_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR4_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR4_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR4_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR4_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR4_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR4: DMA channel x configuration           register
	DMA_CNDTR4_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR4: DMA channel x peripheral address           register
	DMA_CPAR4_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR4: DMA channel x memory address           register
	DMA_CMAR4_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR5: DMA channel x configuration           register
	DMA_CCR5_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR5_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR5_EN          = 0x1    // Bit EN.
	DMA_CCR5_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR5_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR5_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR5_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR5_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR5_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR5_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR5_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR5_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR5_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR5_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR5_DIR         = 0x10   // Bit DIR.
	DMA_CCR5_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR5_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR5_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR5_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR5_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR5_PINC        = 0x40   // Bit PINC.
	DMA_CCR5_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR5_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR5_MINC        = 0x80   // Bit MINC.
	DMA_CCR5_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR5_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR5_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR5_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR5_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR5_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR5_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR5: DMA channel x configuration           register
	DMA_CNDTR5_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR5: DMA channel x peripheral address           register
	DMA_CPAR5_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR5: DMA channel x memory address           register
	DMA_CMAR5_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR6: DMA channel x configuration           register
	DMA_CCR6_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR6_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR6_EN          = 0x1    // Bit EN.
	DMA_CCR6_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR6_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR6_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR6_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR6_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR6_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR6_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR6_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR6_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR6_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR6_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR6_DIR         = 0x10   // Bit DIR.
	DMA_CCR6_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR6_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR6_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR6_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR6_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR6_PINC        = 0x40   // Bit PINC.
	DMA_CCR6_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR6_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR6_MINC        = 0x80   // Bit MINC.
	DMA_CCR6_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR6_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR6_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR6_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR6_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR6_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR6_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR6: DMA channel x configuration           register
	DMA_CNDTR6_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR6: DMA channel x peripheral address           register
	DMA_CPAR6_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR6: DMA channel x memory address           register
	DMA_CMAR6_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR7: DMA channel x configuration           register
	DMA_CCR7_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR7_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR7_EN          = 0x1    // Bit EN.
	DMA_CCR7_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR7_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR7_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR7_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR7_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR7_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR7_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR7_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR7_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR7_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR7_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR7_DIR         = 0x10   // Bit DIR.
	DMA_CCR7_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR7_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR7_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR7_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR7_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR7_PINC        = 0x40   // Bit PINC.
	DMA_CCR7_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR7_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR7_MINC        = 0x80   // Bit MINC.
	DMA_CCR7_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR7_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR7_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR7_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR7_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR7_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR7_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR7: DMA channel x configuration           register
	DMA_CNDTR7_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR7: DMA channel x peripheral address           register
	DMA_CPAR7_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR7: DMA channel x memory address           register
	DMA_CMAR7_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff // Bit mask of MA field.
)

// Bitfields for DMAMUX: DMAMUX
const (
	// DMAMUX_C0CR: DMAMux - DMA request line multiplexer           channel x control register
	DMAMUX_DMAMUX_C0CR_DMAREQ_ID_Pos = 0x0        // Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C0CR_DMAREQ_ID_Msk = 0xff       // Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C0CR_SOIE_Pos      = 0x8        // Position of SOIE field.
	DMAMUX_DMAMUX_C0CR_SOIE_Msk      = 0x100      // Bit mask of SOIE field.
	DMAMUX_DMAMUX_C0CR_SOIE          = 0x100      // Bit SOIE.
	DMAMUX_DMAMUX_C0CR_EGE_Pos       = 0x9        // Position of EGE field.
	DMAMUX_DMAMUX_C0CR_EGE_Msk       = 0x200      // Bit mask of EGE field.
	DMAMUX_DMAMUX_C0CR_EGE           = 0x200      // Bit EGE.
	DMAMUX_DMAMUX_C0CR_SE_Pos        = 0x10       // Position of SE field.
	DMAMUX_DMAMUX_C0CR_SE_Msk        = 0x10000    // Bit mask of SE field.
	DMAMUX_DMAMUX_C0CR_SE            = 0x10000    // Bit SE.
	DMAMUX_DMAMUX_C0CR_SPOL_Pos      = 0x11       // Position of SPOL field.
	DMAMUX_DMAMUX_C0CR_SPOL_Msk      = 0x60000    // Bit mask of SPOL field.
	DMAMUX_DMAMUX_C0CR_NBREQ_Pos     = 0x13       // Position of NBREQ field.
	DMAMUX_DMAMUX_C0CR_NBREQ_Msk     = 0xf80000   // Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C0CR_SYNC_ID_Pos   = 0x18       // Position of SYNC_ID field.
	DMAMUX_DMAMUX_C0CR_SYNC_ID_Msk   = 0x1f000000 // Bit mask of SYNC_ID field.

	// DMAMUX_C1CR: DMAMux - DMA request line multiplexer           channel x control register
	DMAMUX_DMAMUX_C1CR_DMAREQ_ID_Pos = 0x0        // Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C1CR_DMAREQ_ID_Msk = 0xff       // Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C1CR_SOIE_Pos      = 0x8        // Position of SOIE field.
	DMAMUX_DMAMUX_C1CR_SOIE_Msk      = 0x100      // Bit mask of SOIE field.
	DMAMUX_DMAMUX_C1CR_SOIE          = 0x100      // Bit SOIE.
	DMAMUX_DMAMUX_C1CR_EGE_Pos       = 0x9        // Position of EGE field.
	DMAMUX_DMAMUX_C1CR_EGE_Msk       = 0x200      // Bit mask of EGE field.
	DMAMUX_DMAMUX_C1CR_EGE           = 0x200      // Bit EGE.
	DMAMUX_DMAMUX_C1CR_SE_Pos        = 0x10       // Position of SE field.
	DMAMUX_DMAMUX_C1CR_SE_Msk        = 0x10000    // Bit mask of SE field.
	DMAMUX_DMAMUX_C1CR_SE            = 0x10000    // Bit SE.
	DMAMUX_DMAMUX_C1CR_SPOL_Pos      = 0x11       // Position of SPOL field.
	DMAMUX_DMAMUX_C1CR_SPOL_Msk      = 0x60000    // Bit mask of SPOL field.
	DMAMUX_DMAMUX_C1CR_NBREQ_Pos     = 0x13       // Position of NBREQ field.
	DMAMUX_DMAMUX_C1CR_NBREQ_Msk     = 0xf80000   // Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C1CR_SYNC_ID_Pos   = 0x18       // Position of SYNC_ID field.
	DMAMUX_DMAMUX_C1CR_SYNC_ID_Msk   = 0x1f000000 // Bit mask of SYNC_ID field.

	// DMAMUX_C2CR: DMAMux - DMA request line multiplexer           channel x control register
	DMAMUX_DMAMUX_C2CR_DMAREQ_ID_Pos = 0x0        // Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C2CR_DMAREQ_ID_Msk = 0xff       // Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C2CR_SOIE_Pos      = 0x8        // Position of SOIE field.
	DMAMUX_DMAMUX_C2CR_SOIE_Msk      = 0x100      // Bit mask of SOIE field.
	DMAMUX_DMAMUX_C2CR_SOIE          = 0x100      // Bit SOIE.
	DMAMUX_DMAMUX_C2CR_EGE_Pos       = 0x9        // Position of EGE field.
	DMAMUX_DMAMUX_C2CR_EGE_Msk       = 0x200      // Bit mask of EGE field.
	DMAMUX_DMAMUX_C2CR_EGE           = 0x200      // Bit EGE.
	DMAMUX_DMAMUX_C2CR_SE_Pos        = 0x10       // Position of SE field.
	DMAMUX_DMAMUX_C2CR_SE_Msk        = 0x10000    // Bit mask of SE field.
	DMAMUX_DMAMUX_C2CR_SE            = 0x10000    // Bit SE.
	DMAMUX_DMAMUX_C2CR_SPOL_Pos      = 0x11       // Position of SPOL field.
	DMAMUX_DMAMUX_C2CR_SPOL_Msk      = 0x60000    // Bit mask of SPOL field.
	DMAMUX_DMAMUX_C2CR_NBREQ_Pos     = 0x13       // Position of NBREQ field.
	DMAMUX_DMAMUX_C2CR_NBREQ_Msk     = 0xf80000   // Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C2CR_SYNC_ID_Pos   = 0x18       // Position of SYNC_ID field.
	DMAMUX_DMAMUX_C2CR_SYNC_ID_Msk   = 0x1f000000 // Bit mask of SYNC_ID field.

	// DMAMUX_C3CR: DMAMux - DMA request line multiplexer           channel x control register
	DMAMUX_DMAMUX_C3CR_DMAREQ_ID_Pos = 0x0        // Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C3CR_DMAREQ_ID_Msk = 0xff       // Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C3CR_SOIE_Pos      = 0x8        // Position of SOIE field.
	DMAMUX_DMAMUX_C3CR_SOIE_Msk      = 0x100      // Bit mask of SOIE field.
	DMAMUX_DMAMUX_C3CR_SOIE          = 0x100      // Bit SOIE.
	DMAMUX_DMAMUX_C3CR_EGE_Pos       = 0x9        // Position of EGE field.
	DMAMUX_DMAMUX_C3CR_EGE_Msk       = 0x200      // Bit mask of EGE field.
	DMAMUX_DMAMUX_C3CR_EGE           = 0x200      // Bit EGE.
	DMAMUX_DMAMUX_C3CR_SE_Pos        = 0x10       // Position of SE field.
	DMAMUX_DMAMUX_C3CR_SE_Msk        = 0x10000    // Bit mask of SE field.
	DMAMUX_DMAMUX_C3CR_SE            = 0x10000    // Bit SE.
	DMAMUX_DMAMUX_C3CR_SPOL_Pos      = 0x11       // Position of SPOL field.
	DMAMUX_DMAMUX_C3CR_SPOL_Msk      = 0x60000    // Bit mask of SPOL field.
	DMAMUX_DMAMUX_C3CR_NBREQ_Pos     = 0x13       // Position of NBREQ field.
	DMAMUX_DMAMUX_C3CR_NBREQ_Msk     = 0xf80000   // Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C3CR_SYNC_ID_Pos   = 0x18       // Position of SYNC_ID field.
	DMAMUX_DMAMUX_C3CR_SYNC_ID_Msk   = 0x1f000000 // Bit mask of SYNC_ID field.

	// DMAMUX_C4CR: DMAMux - DMA request line multiplexer           channel x control register
	DMAMUX_DMAMUX_C4CR_DMAREQ_ID_Pos = 0x0        // Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C4CR_DMAREQ_ID_Msk = 0xff       // Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C4CR_SOIE_Pos      = 0x8        // Position of SOIE field.
	DMAMUX_DMAMUX_C4CR_SOIE_Msk      = 0x100      // Bit mask of SOIE field.
	DMAMUX_DMAMUX_C4CR_SOIE          = 0x100      // Bit SOIE.
	DMAMUX_DMAMUX_C4CR_EGE_Pos       = 0x9        // Position of EGE field.
	DMAMUX_DMAMUX_C4CR_EGE_Msk       = 0x200      // Bit mask of EGE field.
	DMAMUX_DMAMUX_C4CR_EGE           = 0x200      // Bit EGE.
	DMAMUX_DMAMUX_C4CR_SE_Pos        = 0x10       // Position of SE field.
	DMAMUX_DMAMUX_C4CR_SE_Msk        = 0x10000    // Bit mask of SE field.
	DMAMUX_DMAMUX_C4CR_SE            = 0x10000    // Bit SE.
	DMAMUX_DMAMUX_C4CR_SPOL_Pos      = 0x11       // Position of SPOL field.
	DMAMUX_DMAMUX_C4CR_SPOL_Msk      = 0x60000    // Bit mask of SPOL field.
	DMAMUX_DMAMUX_C4CR_NBREQ_Pos     = 0x13       // Position of NBREQ field.
	DMAMUX_DMAMUX_C4CR_NBREQ_Msk     = 0xf80000   // Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C4CR_SYNC_ID_Pos   = 0x18       // Position of SYNC_ID field.
	DMAMUX_DMAMUX_C4CR_SYNC_ID_Msk   = 0x1f000000 // Bit mask of SYNC_ID field.

	// DMAMUX_C5CR: DMAMux - DMA request line multiplexer           channel x control register
	DMAMUX_DMAMUX_C5CR_DMAREQ_ID_Pos = 0x0        // Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C5CR_DMAREQ_ID_Msk = 0xff       // Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C5CR_SOIE_Pos      = 0x8        // Position of SOIE field.
	DMAMUX_DMAMUX_C5CR_SOIE_Msk      = 0x100      // Bit mask of SOIE field.
	DMAMUX_DMAMUX_C5CR_SOIE          = 0x100      // Bit SOIE.
	DMAMUX_DMAMUX_C5CR_EGE_Pos       = 0x9        // Position of EGE field.
	DMAMUX_DMAMUX_C5CR_EGE_Msk       = 0x200      // Bit mask of EGE field.
	DMAMUX_DMAMUX_C5CR_EGE           = 0x200      // Bit EGE.
	DMAMUX_DMAMUX_C5CR_SE_Pos        = 0x10       // Position of SE field.
	DMAMUX_DMAMUX_C5CR_SE_Msk        = 0x10000    // Bit mask of SE field.
	DMAMUX_DMAMUX_C5CR_SE            = 0x10000    // Bit SE.
	DMAMUX_DMAMUX_C5CR_SPOL_Pos      = 0x11       // Position of SPOL field.
	DMAMUX_DMAMUX_C5CR_SPOL_Msk      = 0x60000    // Bit mask of SPOL field.
	DMAMUX_DMAMUX_C5CR_NBREQ_Pos     = 0x13       // Position of NBREQ field.
	DMAMUX_DMAMUX_C5CR_NBREQ_Msk     = 0xf80000   // Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C5CR_SYNC_ID_Pos   = 0x18       // Position of SYNC_ID field.
	DMAMUX_DMAMUX_C5CR_SYNC_ID_Msk   = 0x1f000000 // Bit mask of SYNC_ID field.

	// DMAMUX_C6CR: DMAMux - DMA request line multiplexer           channel x control register
	DMAMUX_DMAMUX_C6CR_DMAREQ_ID_Pos = 0x0        // Position of DMAREQ_ID field.
	DMAMUX_DMAMUX_C6CR_DMAREQ_ID_Msk = 0xff       // Bit mask of DMAREQ_ID field.
	DMAMUX_DMAMUX_C6CR_SOIE_Pos      = 0x8        // Position of SOIE field.
	DMAMUX_DMAMUX_C6CR_SOIE_Msk      = 0x100      // Bit mask of SOIE field.
	DMAMUX_DMAMUX_C6CR_SOIE          = 0x100      // Bit SOIE.
	DMAMUX_DMAMUX_C6CR_EGE_Pos       = 0x9        // Position of EGE field.
	DMAMUX_DMAMUX_C6CR_EGE_Msk       = 0x200      // Bit mask of EGE field.
	DMAMUX_DMAMUX_C6CR_EGE           = 0x200      // Bit EGE.
	DMAMUX_DMAMUX_C6CR_SE_Pos        = 0x10       // Position of SE field.
	DMAMUX_DMAMUX_C6CR_SE_Msk        = 0x10000    // Bit mask of SE field.
	DMAMUX_DMAMUX_C6CR_SE            = 0x10000    // Bit SE.
	DMAMUX_DMAMUX_C6CR_SPOL_Pos      = 0x11       // Position of SPOL field.
	DMAMUX_DMAMUX_C6CR_SPOL_Msk      = 0x60000    // Bit mask of SPOL field.
	DMAMUX_DMAMUX_C6CR_NBREQ_Pos     = 0x13       // Position of NBREQ field.
	DMAMUX_DMAMUX_C6CR_NBREQ_Msk     = 0xf80000   // Bit mask of NBREQ field.
	DMAMUX_DMAMUX_C6CR_SYNC_ID_Pos   = 0x18       // Position of SYNC_ID field.
	DMAMUX_DMAMUX_C6CR_SYNC_ID_Msk   = 0x1f000000 // Bit mask of SYNC_ID field.

	// DMAMUX_CSR: DMAMUX request line multiplexer interrupt           channel status register
	DMAMUX_DMAMUX_CSR_SOF_Pos = 0x0  // Position of SOF field.
	DMAMUX_DMAMUX_CSR_SOF_Msk = 0x7f // Bit mask of SOF field.

	// DMAMUX_CFR: DMAMUX request line multiplexer interrupt           clear flag register
	DMAMUX_DMAMUX_CFR_CSOF_Pos = 0x0  // Position of CSOF field.
	DMAMUX_DMAMUX_CFR_CSOF_Msk = 0x7f // Bit mask of CSOF field.

	// DMAMUX_RG0CR: DMAMux - DMA request generator channel x           control register
	DMAMUX_DMAMUX_RG0CR_SIG_ID_Pos = 0x0      // Position of SIG_ID field.
	DMAMUX_DMAMUX_RG0CR_SIG_ID_Msk = 0x1f     // Bit mask of SIG_ID field.
	DMAMUX_DMAMUX_RG0CR_OIE_Pos    = 0x8      // Position of OIE field.
	DMAMUX_DMAMUX_RG0CR_OIE_Msk    = 0x100    // Bit mask of OIE field.
	DMAMUX_DMAMUX_RG0CR_OIE        = 0x100    // Bit OIE.
	DMAMUX_DMAMUX_RG0CR_GE_Pos     = 0x10     // Position of GE field.
	DMAMUX_DMAMUX_RG0CR_GE_Msk     = 0x10000  // Bit mask of GE field.
	DMAMUX_DMAMUX_RG0CR_GE         = 0x10000  // Bit GE.
	DMAMUX_DMAMUX_RG0CR_GPOL_Pos   = 0x11     // Position of GPOL field.
	DMAMUX_DMAMUX_RG0CR_GPOL_Msk   = 0x60000  // Bit mask of GPOL field.
	DMAMUX_DMAMUX_RG0CR_GNBREQ_Pos = 0x13     // Position of GNBREQ field.
	DMAMUX_DMAMUX_RG0CR_GNBREQ_Msk = 0xf80000 // Bit mask of GNBREQ field.

	// DMAMUX_RG1CR: DMAMux - DMA request generator channel x           control register
	DMAMUX_DMAMUX_RG1CR_SIG_ID_Pos = 0x0      // Position of SIG_ID field.
	DMAMUX_DMAMUX_RG1CR_SIG_ID_Msk = 0x1f     // Bit mask of SIG_ID field.
	DMAMUX_DMAMUX_RG1CR_OIE_Pos    = 0x8      // Position of OIE field.
	DMAMUX_DMAMUX_RG1CR_OIE_Msk    = 0x100    // Bit mask of OIE field.
	DMAMUX_DMAMUX_RG1CR_OIE        = 0x100    // Bit OIE.
	DMAMUX_DMAMUX_RG1CR_GE_Pos     = 0x10     // Position of GE field.
	DMAMUX_DMAMUX_RG1CR_GE_Msk     = 0x10000  // Bit mask of GE field.
	DMAMUX_DMAMUX_RG1CR_GE         = 0x10000  // Bit GE.
	DMAMUX_DMAMUX_RG1CR_GPOL_Pos   = 0x11     // Position of GPOL field.
	DMAMUX_DMAMUX_RG1CR_GPOL_Msk   = 0x60000  // Bit mask of GPOL field.
	DMAMUX_DMAMUX_RG1CR_GNBREQ_Pos = 0x13     // Position of GNBREQ field.
	DMAMUX_DMAMUX_RG1CR_GNBREQ_Msk = 0xf80000 // Bit mask of GNBREQ field.

	// DMAMUX_RG2CR: DMAMux - DMA request generator channel x           control register
	DMAMUX_DMAMUX_RG2CR_SIG_ID_Pos = 0x0      // Position of SIG_ID field.
	DMAMUX_DMAMUX_RG2CR_SIG_ID_Msk = 0x1f     // Bit mask of SIG_ID field.
	DMAMUX_DMAMUX_RG2CR_OIE_Pos    = 0x8      // Position of OIE field.
	DMAMUX_DMAMUX_RG2CR_OIE_Msk    = 0x100    // Bit mask of OIE field.
	DMAMUX_DMAMUX_RG2CR_OIE        = 0x100    // Bit OIE.
	DMAMUX_DMAMUX_RG2CR_GE_Pos     = 0x10     // Position of GE field.
	DMAMUX_DMAMUX_RG2CR_GE_Msk     = 0x10000  // Bit mask of GE field.
	DMAMUX_DMAMUX_RG2CR_GE         = 0x10000  // Bit GE.
	DMAMUX_DMAMUX_RG2CR_GPOL_Pos   = 0x11     // Position of GPOL field.
	DMAMUX_DMAMUX_RG2CR_GPOL_Msk   = 0x60000  // Bit mask of GPOL field.
	DMAMUX_DMAMUX_RG2CR_GNBREQ_Pos = 0x13     // Position of GNBREQ field.
	DMAMUX_DMAMUX_RG2CR_GNBREQ_Msk = 0xf80000 // Bit mask of GNBREQ field.

	// DMAMUX_RG3CR: DMAMux - DMA request generator channel x           control register
	DMAMUX_DMAMUX_RG3CR_SIG_ID_Pos = 0x0      // Position of SIG_ID field.
	DMAMUX_DMAMUX_RG3CR_SIG_ID_Msk = 0x1f     // Bit mask of SIG_ID field.
	DMAMUX_DMAMUX_RG3CR_OIE_Pos    = 0x8      // Position of OIE field.
	DMAMUX_DMAMUX_RG3CR_OIE_Msk    = 0x100    // Bit mask of OIE field.
	DMAMUX_DMAMUX_RG3CR_OIE        = 0x100    // Bit OIE.
	DMAMUX_DMAMUX_RG3CR_GE_Pos     = 0x10     // Position of GE field.
	DMAMUX_DMAMUX_RG3CR_GE_Msk     = 0x10000  // Bit mask of GE field.
	DMAMUX_DMAMUX_RG3CR_GE         = 0x10000  // Bit GE.
	DMAMUX_DMAMUX_RG3CR_GPOL_Pos   = 0x11     // Position of GPOL field.
	DMAMUX_DMAMUX_RG3CR_GPOL_Msk   = 0x60000  // Bit mask of GPOL field.
	DMAMUX_DMAMUX_RG3CR_GNBREQ_Pos = 0x13     // Position of GNBREQ field.
	DMAMUX_DMAMUX_RG3CR_GNBREQ_Msk = 0xf80000 // Bit mask of GNBREQ field.

	// DMAMUX_RGSR: DMAMux - DMA request generator status           register
	DMAMUX_DMAMUX_RGSR_OF_Pos = 0x0 // Position of OF field.
	DMAMUX_DMAMUX_RGSR_OF_Msk = 0xf // Bit mask of OF field.

	// DMAMUX_RGCFR: DMAMux - DMA request generator clear flag           register
	DMAMUX_DMAMUX_RGCFR_COF_Pos = 0x0 // Position of COF field.
	DMAMUX_DMAMUX_RGCFR_COF_Msk = 0xf // Bit mask of COF field.

	// DMAMUX_HWCFGR2: DMAMUX hardware configuration 2           register
	DMAMUX_DMAMUX_HWCFGR2_NUM_DMA_EXT_REQ_Pos = 0x0  // Position of NUM_DMA_EXT_REQ field.
	DMAMUX_DMAMUX_HWCFGR2_NUM_DMA_EXT_REQ_Msk = 0xff // Bit mask of NUM_DMA_EXT_REQ field.

	// DMAMUX_HWCFGR1: DMAMUX hardware configuration 1           register
	DMAMUX_DMAMUX_HWCFGR1_NUM_DMA_STREAMS_Pos    = 0x0        // Position of NUM_DMA_STREAMS field.
	DMAMUX_DMAMUX_HWCFGR1_NUM_DMA_STREAMS_Msk    = 0xff       // Bit mask of NUM_DMA_STREAMS field.
	DMAMUX_DMAMUX_HWCFGR1_NUM_DMA_PERIPH_REQ_Pos = 0x8        // Position of NUM_DMA_PERIPH_REQ field.
	DMAMUX_DMAMUX_HWCFGR1_NUM_DMA_PERIPH_REQ_Msk = 0xff00     // Bit mask of NUM_DMA_PERIPH_REQ field.
	DMAMUX_DMAMUX_HWCFGR1_NUM_DMA_TRIG_Pos       = 0x10       // Position of NUM_DMA_TRIG field.
	DMAMUX_DMAMUX_HWCFGR1_NUM_DMA_TRIG_Msk       = 0xff0000   // Bit mask of NUM_DMA_TRIG field.
	DMAMUX_DMAMUX_HWCFGR1_NUM_DMA_REQGEN_Pos     = 0x18       // Position of NUM_DMA_REQGEN field.
	DMAMUX_DMAMUX_HWCFGR1_NUM_DMA_REQGEN_Msk     = 0xff000000 // Bit mask of NUM_DMA_REQGEN field.

	// DMAMUX_VERR: DMAMUX version register
	DMAMUX_DMAMUX_VERR_MINREV_Pos = 0x0  // Position of MINREV field.
	DMAMUX_DMAMUX_VERR_MINREV_Msk = 0xf  // Bit mask of MINREV field.
	DMAMUX_DMAMUX_VERR_MAJREV_Pos = 0x4  // Position of MAJREV field.
	DMAMUX_DMAMUX_VERR_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.

	// DMAMUX_IPIDR: DMAMUX IP identification           register
	DMAMUX_DMAMUX_IPIDR_ID_Pos = 0x0        // Position of ID field.
	DMAMUX_DMAMUX_IPIDR_ID_Msk = 0xffffffff // Bit mask of ID field.

	// DMAMUX_SIDR: DMAMUX size identification           register
	DMAMUX_DMAMUX_SIDR_SID_Pos = 0x0        // Position of SID field.
	DMAMUX_DMAMUX_SIDR_SID_Msk = 0xffffffff // Bit mask of SID field.
)

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	GPIO_MODER_MODER15_Pos = 0x1e       // Position of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000 // Bit mask of MODER15 field.
	GPIO_MODER_MODER14_Pos = 0x1c       // Position of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000 // Bit mask of MODER14 field.
	GPIO_MODER_MODER13_Pos = 0x1a       // Position of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000  // Bit mask of MODER13 field.
	GPIO_MODER_MODER12_Pos = 0x18       // Position of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000  // Bit mask of MODER12 field.
	GPIO_MODER_MODER11_Pos = 0x16       // Position of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000   // Bit mask of MODER11 field.
	GPIO_MODER_MODER10_Pos = 0x14       // Position of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000   // Bit mask of MODER10 field.
	GPIO_MODER_MODER9_Pos  = 0x12       // Position of MODER9 field.
	GPIO_MODER_MODER9_Msk  = 0xc0000    // Bit mask of MODER9 field.
	GPIO_MODER_MODER8_Pos  = 0x10       // Position of MODER8 field.
	GPIO_MODER_MODER8_Msk  = 0x30000    // Bit mask of MODER8 field.
	GPIO_MODER_MODER7_Pos  = 0xe        // Position of MODER7 field.
	GPIO_MODER_MODER7_Msk  = 0xc000     // Bit mask of MODER7 field.
	GPIO_MODER_MODER6_Pos  = 0xc        // Position of MODER6 field.
	GPIO_MODER_MODER6_Msk  = 0x3000     // Bit mask of MODER6 field.
	GPIO_MODER_MODER5_Pos  = 0xa        // Position of MODER5 field.
	GPIO_MODER_MODER5_Msk  = 0xc00      // Bit mask of MODER5 field.
	GPIO_MODER_MODER4_Pos  = 0x8        // Position of MODER4 field.
	GPIO_MODER_MODER4_Msk  = 0x300      // Bit mask of MODER4 field.
	GPIO_MODER_MODER3_Pos  = 0x6        // Position of MODER3 field.
	GPIO_MODER_MODER3_Msk  = 0xc0       // Bit mask of MODER3 field.
	GPIO_MODER_MODER2_Pos  = 0x4        // Position of MODER2 field.
	GPIO_MODER_MODER2_Msk  = 0x30       // Bit mask of MODER2 field.
	GPIO_MODER_MODER1_Pos  = 0x2        // Position of MODER1 field.
	GPIO_MODER_MODER1_Msk  = 0xc        // Bit mask of MODER1 field.
	GPIO_MODER_MODER0_Pos  = 0x0        // Position of MODER0 field.
	GPIO_MODER_MODER0_Msk  = 0x3        // Bit mask of MODER0 field.

	// OTYPER: GPIO port output type register
	GPIO_OTYPER_OT15_Pos = 0xf    // Position of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000 // Bit mask of OT15 field.
	GPIO_OTYPER_OT15     = 0x8000 // Bit OT15.
	GPIO_OTYPER_OT14_Pos = 0xe    // Position of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000 // Bit mask of OT14 field.
	GPIO_OTYPER_OT14     = 0x4000 // Bit OT14.
	GPIO_OTYPER_OT13_Pos = 0xd    // Position of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000 // Bit mask of OT13 field.
	GPIO_OTYPER_OT13     = 0x2000 // Bit OT13.
	GPIO_OTYPER_OT12_Pos = 0xc    // Position of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000 // Bit mask of OT12 field.
	GPIO_OTYPER_OT12     = 0x1000 // Bit OT12.
	GPIO_OTYPER_OT11_Pos = 0xb    // Position of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800  // Bit mask of OT11 field.
	GPIO_OTYPER_OT11     = 0x800  // Bit OT11.
	GPIO_OTYPER_OT10_Pos = 0xa    // Position of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400  // Bit mask of OT10 field.
	GPIO_OTYPER_OT10     = 0x400  // Bit OT10.
	GPIO_OTYPER_OT9_Pos  = 0x9    // Position of OT9 field.
	GPIO_OTYPER_OT9_Msk  = 0x200  // Bit mask of OT9 field.
	GPIO_OTYPER_OT9      = 0x200  // Bit OT9.
	GPIO_OTYPER_OT8_Pos  = 0x8    // Position of OT8 field.
	GPIO_OTYPER_OT8_Msk  = 0x100  // Bit mask of OT8 field.
	GPIO_OTYPER_OT8      = 0x100  // Bit OT8.
	GPIO_OTYPER_OT7_Pos  = 0x7    // Position of OT7 field.
	GPIO_OTYPER_OT7_Msk  = 0x80   // Bit mask of OT7 field.
	GPIO_OTYPER_OT7      = 0x80   // Bit OT7.
	GPIO_OTYPER_OT6_Pos  = 0x6    // Position of OT6 field.
	GPIO_OTYPER_OT6_Msk  = 0x40   // Bit mask of OT6 field.
	GPIO_OTYPER_OT6      = 0x40   // Bit OT6.
	GPIO_OTYPER_OT5_Pos  = 0x5    // Position of OT5 field.
	GPIO_OTYPER_OT5_Msk  = 0x20   // Bit mask of OT5 field.
	GPIO_OTYPER_OT5      = 0x20   // Bit OT5.
	GPIO_OTYPER_OT4_Pos  = 0x4    // Position of OT4 field.
	GPIO_OTYPER_OT4_Msk  = 0x10   // Bit mask of OT4 field.
	GPIO_OTYPER_OT4      = 0x10   // Bit OT4.
	GPIO_OTYPER_OT3_Pos  = 0x3    // Position of OT3 field.
	GPIO_OTYPER_OT3_Msk  = 0x8    // Bit mask of OT3 field.
	GPIO_OTYPER_OT3      = 0x8    // Bit OT3.
	GPIO_OTYPER_OT2_Pos  = 0x2    // Position of OT2 field.
	GPIO_OTYPER_OT2_Msk  = 0x4    // Bit mask of OT2 field.
	GPIO_OTYPER_OT2      = 0x4    // Bit OT2.
	GPIO_OTYPER_OT1_Pos  = 0x1    // Position of OT1 field.
	GPIO_OTYPER_OT1_Msk  = 0x2    // Bit mask of OT1 field.
	GPIO_OTYPER_OT1      = 0x2    // Bit OT1.
	GPIO_OTYPER_OT0_Pos  = 0x0    // Position of OT0 field.
	GPIO_OTYPER_OT0_Msk  = 0x1    // Bit mask of OT0 field.
	GPIO_OTYPER_OT0      = 0x1    // Bit OT0.

	// OSPEEDR: GPIO port output speed           register
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e       // Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000 // Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c       // Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000 // Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a       // Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000  // Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18       // Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000  // Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16       // Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000   // Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14       // Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000   // Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos  = 0x12       // Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk  = 0xc0000    // Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos  = 0x10       // Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk  = 0x30000    // Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos  = 0xe        // Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk  = 0xc000     // Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos  = 0xc        // Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk  = 0x3000     // Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos  = 0xa        // Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk  = 0xc00      // Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos  = 0x8        // Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk  = 0x300      // Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos  = 0x6        // Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk  = 0xc0       // Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos  = 0x4        // Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk  = 0x30       // Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos  = 0x2        // Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk  = 0xc        // Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos  = 0x0        // Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk  = 0x3        // Bit mask of OSPEEDR0 field.

	// PUPDR: GPIO port pull-up/pull-down           register
	GPIO_PUPDR_PUPDR15_Pos = 0x1e       // Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000 // Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c       // Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000 // Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a       // Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000  // Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18       // Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000  // Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16       // Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000   // Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14       // Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000   // Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR9_Pos  = 0x12       // Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk  = 0xc0000    // Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR8_Pos  = 0x10       // Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk  = 0x30000    // Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR7_Pos  = 0xe        // Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk  = 0xc000     // Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR6_Pos  = 0xc        // Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk  = 0x3000     // Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR5_Pos  = 0xa        // Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk  = 0xc00      // Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR4_Pos  = 0x8        // Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk  = 0x300      // Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR3_Pos  = 0x6        // Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk  = 0xc0       // Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR2_Pos  = 0x4        // Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk  = 0x30       // Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR1_Pos  = 0x2        // Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk  = 0xc        // Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR0_Pos  = 0x0        // Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk  = 0x3        // Bit mask of PUPDR0 field.

	// IDR: GPIO port input data register
	GPIO_IDR_IDR15_Pos = 0xf    // Position of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000 // Bit mask of IDR15 field.
	GPIO_IDR_IDR15     = 0x8000 // Bit IDR15.
	GPIO_IDR_IDR14_Pos = 0xe    // Position of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000 // Bit mask of IDR14 field.
	GPIO_IDR_IDR14     = 0x4000 // Bit IDR14.
	GPIO_IDR_IDR13_Pos = 0xd    // Position of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000 // Bit mask of IDR13 field.
	GPIO_IDR_IDR13     = 0x2000 // Bit IDR13.
	GPIO_IDR_IDR12_Pos = 0xc    // Position of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000 // Bit mask of IDR12 field.
	GPIO_IDR_IDR12     = 0x1000 // Bit IDR12.
	GPIO_IDR_IDR11_Pos = 0xb    // Position of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800  // Bit mask of IDR11 field.
	GPIO_IDR_IDR11     = 0x800  // Bit IDR11.
	GPIO_IDR_IDR10_Pos = 0xa    // Position of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400  // Bit mask of IDR10 field.
	GPIO_IDR_IDR10     = 0x400  // Bit IDR10.
	GPIO_IDR_IDR9_Pos  = 0x9    // Position of IDR9 field.
	GPIO_IDR_IDR9_Msk  = 0x200  // Bit mask of IDR9 field.
	GPIO_IDR_IDR9      = 0x200  // Bit IDR9.
	GPIO_IDR_IDR8_Pos  = 0x8    // Position of IDR8 field.
	GPIO_IDR_IDR8_Msk  = 0x100  // Bit mask of IDR8 field.
	GPIO_IDR_IDR8      = 0x100  // Bit IDR8.
	GPIO_IDR_IDR7_Pos  = 0x7    // Position of IDR7 field.
	GPIO_IDR_IDR7_Msk  = 0x80   // Bit mask of IDR7 field.
	GPIO_IDR_IDR7      = 0x80   // Bit IDR7.
	GPIO_IDR_IDR6_Pos  = 0x6    // Position of IDR6 field.
	GPIO_IDR_IDR6_Msk  = 0x40   // Bit mask of IDR6 field.
	GPIO_IDR_IDR6      = 0x40   // Bit IDR6.
	GPIO_IDR_IDR5_Pos  = 0x5    // Position of IDR5 field.
	GPIO_IDR_IDR5_Msk  = 0x20   // Bit mask of IDR5 field.
	GPIO_IDR_IDR5      = 0x20   // Bit IDR5.
	GPIO_IDR_IDR4_Pos  = 0x4    // Position of IDR4 field.
	GPIO_IDR_IDR4_Msk  = 0x10   // Bit mask of IDR4 field.
	GPIO_IDR_IDR4      = 0x10   // Bit IDR4.
	GPIO_IDR_IDR3_Pos  = 0x3    // Position of IDR3 field.
	GPIO_IDR_IDR3_Msk  = 0x8    // Bit mask of IDR3 field.
	GPIO_IDR_IDR3      = 0x8    // Bit IDR3.
	GPIO_IDR_IDR2_Pos  = 0x2    // Position of IDR2 field.
	GPIO_IDR_IDR2_Msk  = 0x4    // Bit mask of IDR2 field.
	GPIO_IDR_IDR2      = 0x4    // Bit IDR2.
	GPIO_IDR_IDR1_Pos  = 0x1    // Position of IDR1 field.
	GPIO_IDR_IDR1_Msk  = 0x2    // Bit mask of IDR1 field.
	GPIO_IDR_IDR1      = 0x2    // Bit IDR1.
	GPIO_IDR_IDR0_Pos  = 0x0    // Position of IDR0 field.
	GPIO_IDR_IDR0_Msk  = 0x1    // Bit mask of IDR0 field.
	GPIO_IDR_IDR0      = 0x1    // Bit IDR0.

	// ODR: GPIO port output data register
	GPIO_ODR_ODR15_Pos = 0xf    // Position of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000 // Bit mask of ODR15 field.
	GPIO_ODR_ODR15     = 0x8000 // Bit ODR15.
	GPIO_ODR_ODR14_Pos = 0xe    // Position of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000 // Bit mask of ODR14 field.
	GPIO_ODR_ODR14     = 0x4000 // Bit ODR14.
	GPIO_ODR_ODR13_Pos = 0xd    // Position of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000 // Bit mask of ODR13 field.
	GPIO_ODR_ODR13     = 0x2000 // Bit ODR13.
	GPIO_ODR_ODR12_Pos = 0xc    // Position of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000 // Bit mask of ODR12 field.
	GPIO_ODR_ODR12     = 0x1000 // Bit ODR12.
	GPIO_ODR_ODR11_Pos = 0xb    // Position of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800  // Bit mask of ODR11 field.
	GPIO_ODR_ODR11     = 0x800  // Bit ODR11.
	GPIO_ODR_ODR10_Pos = 0xa    // Position of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400  // Bit mask of ODR10 field.
	GPIO_ODR_ODR10     = 0x400  // Bit ODR10.
	GPIO_ODR_ODR9_Pos  = 0x9    // Position of ODR9 field.
	GPIO_ODR_ODR9_Msk  = 0x200  // Bit mask of ODR9 field.
	GPIO_ODR_ODR9      = 0x200  // Bit ODR9.
	GPIO_ODR_ODR8_Pos  = 0x8    // Position of ODR8 field.
	GPIO_ODR_ODR8_Msk  = 0x100  // Bit mask of ODR8 field.
	GPIO_ODR_ODR8      = 0x100  // Bit ODR8.
	GPIO_ODR_ODR7_Pos  = 0x7    // Position of ODR7 field.
	GPIO_ODR_ODR7_Msk  = 0x80   // Bit mask of ODR7 field.
	GPIO_ODR_ODR7      = 0x80   // Bit ODR7.
	GPIO_ODR_ODR6_Pos  = 0x6    // Position of ODR6 field.
	GPIO_ODR_ODR6_Msk  = 0x40   // Bit mask of ODR6 field.
	GPIO_ODR_ODR6      = 0x40   // Bit ODR6.
	GPIO_ODR_ODR5_Pos  = 0x5    // Position of ODR5 field.
	GPIO_ODR_ODR5_Msk  = 0x20   // Bit mask of ODR5 field.
	GPIO_ODR_ODR5      = 0x20   // Bit ODR5.
	GPIO_ODR_ODR4_Pos  = 0x4    // Position of ODR4 field.
	GPIO_ODR_ODR4_Msk  = 0x10   // Bit mask of ODR4 field.
	GPIO_ODR_ODR4      = 0x10   // Bit ODR4.
	GPIO_ODR_ODR3_Pos  = 0x3    // Position of ODR3 field.
	GPIO_ODR_ODR3_Msk  = 0x8    // Bit mask of ODR3 field.
	GPIO_ODR_ODR3      = 0x8    // Bit ODR3.
	GPIO_ODR_ODR2_Pos  = 0x2    // Position of ODR2 field.
	GPIO_ODR_ODR2_Msk  = 0x4    // Bit mask of ODR2 field.
	GPIO_ODR_ODR2      = 0x4    // Bit ODR2.
	GPIO_ODR_ODR1_Pos  = 0x1    // Position of ODR1 field.
	GPIO_ODR_ODR1_Msk  = 0x2    // Bit mask of ODR1 field.
	GPIO_ODR_ODR1      = 0x2    // Bit ODR1.
	GPIO_ODR_ODR0_Pos  = 0x0    // Position of ODR0 field.
	GPIO_ODR_ODR0_Msk  = 0x1    // Bit mask of ODR0 field.
	GPIO_ODR_ODR0      = 0x1    // Bit ODR0.

	// BSRR: GPIO port bit set/reset           register
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.

	// LCKR: GPIO port configuration lock           register
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.

	// AFRL: GPIO alternate function low           register
	GPIO_AFRL_AFSEL7_Pos = 0x1c       // Position of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Msk = 0xf0000000 // Bit mask of AFSEL7 field.
	GPIO_AFRL_AFSEL6_Pos = 0x18       // Position of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Msk = 0xf000000  // Bit mask of AFSEL6 field.
	GPIO_AFRL_AFSEL5_Pos = 0x14       // Position of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Msk = 0xf00000   // Bit mask of AFSEL5 field.
	GPIO_AFRL_AFSEL4_Pos = 0x10       // Position of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Msk = 0xf0000    // Bit mask of AFSEL4 field.
	GPIO_AFRL_AFSEL3_Pos = 0xc        // Position of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Msk = 0xf000     // Bit mask of AFSEL3 field.
	GPIO_AFRL_AFSEL2_Pos = 0x8        // Position of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Msk = 0xf00      // Bit mask of AFSEL2 field.
	GPIO_AFRL_AFSEL1_Pos = 0x4        // Position of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Msk = 0xf0       // Bit mask of AFSEL1 field.
	GPIO_AFRL_AFSEL0_Pos = 0x0        // Position of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Msk = 0xf        // Bit mask of AFSEL0 field.

	// AFRH: GPIO alternate function high           register
	GPIO_AFRH_AFSEL15_Pos = 0x1c       // Position of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Msk = 0xf0000000 // Bit mask of AFSEL15 field.
	GPIO_AFRH_AFSEL14_Pos = 0x18       // Position of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Msk = 0xf000000  // Bit mask of AFSEL14 field.
	GPIO_AFRH_AFSEL13_Pos = 0x14       // Position of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Msk = 0xf00000   // Bit mask of AFSEL13 field.
	GPIO_AFRH_AFSEL12_Pos = 0x10       // Position of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Msk = 0xf0000    // Bit mask of AFSEL12 field.
	GPIO_AFRH_AFSEL11_Pos = 0xc        // Position of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Msk = 0xf000     // Bit mask of AFSEL11 field.
	GPIO_AFRH_AFSEL10_Pos = 0x8        // Position of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Msk = 0xf00      // Bit mask of AFSEL10 field.
	GPIO_AFRH_AFSEL9_Pos  = 0x4        // Position of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Msk  = 0xf0       // Bit mask of AFSEL9 field.
	GPIO_AFRH_AFSEL8_Pos  = 0x0        // Position of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Msk  = 0xf        // Bit mask of AFSEL8 field.

	// BRR: port bit reset register
	GPIO_BRR_BR0_Pos  = 0x0    // Position of BR0 field.
	GPIO_BRR_BR0_Msk  = 0x1    // Bit mask of BR0 field.
	GPIO_BRR_BR0      = 0x1    // Bit BR0.
	GPIO_BRR_BR1_Pos  = 0x1    // Position of BR1 field.
	GPIO_BRR_BR1_Msk  = 0x2    // Bit mask of BR1 field.
	GPIO_BRR_BR1      = 0x2    // Bit BR1.
	GPIO_BRR_BR2_Pos  = 0x2    // Position of BR2 field.
	GPIO_BRR_BR2_Msk  = 0x4    // Bit mask of BR2 field.
	GPIO_BRR_BR2      = 0x4    // Bit BR2.
	GPIO_BRR_BR3_Pos  = 0x3    // Position of BR3 field.
	GPIO_BRR_BR3_Msk  = 0x8    // Bit mask of BR3 field.
	GPIO_BRR_BR3      = 0x8    // Bit BR3.
	GPIO_BRR_BR4_Pos  = 0x4    // Position of BR4 field.
	GPIO_BRR_BR4_Msk  = 0x10   // Bit mask of BR4 field.
	GPIO_BRR_BR4      = 0x10   // Bit BR4.
	GPIO_BRR_BR5_Pos  = 0x5    // Position of BR5 field.
	GPIO_BRR_BR5_Msk  = 0x20   // Bit mask of BR5 field.
	GPIO_BRR_BR5      = 0x20   // Bit BR5.
	GPIO_BRR_BR6_Pos  = 0x6    // Position of BR6 field.
	GPIO_BRR_BR6_Msk  = 0x40   // Bit mask of BR6 field.
	GPIO_BRR_BR6      = 0x40   // Bit BR6.
	GPIO_BRR_BR7_Pos  = 0x7    // Position of BR7 field.
	GPIO_BRR_BR7_Msk  = 0x80   // Bit mask of BR7 field.
	GPIO_BRR_BR7      = 0x80   // Bit BR7.
	GPIO_BRR_BR8_Pos  = 0x8    // Position of BR8 field.
	GPIO_BRR_BR8_Msk  = 0x100  // Bit mask of BR8 field.
	GPIO_BRR_BR8      = 0x100  // Bit BR8.
	GPIO_BRR_BR9_Pos  = 0x9    // Position of BR9 field.
	GPIO_BRR_BR9_Msk  = 0x200  // Bit mask of BR9 field.
	GPIO_BRR_BR9      = 0x200  // Bit BR9.
	GPIO_BRR_BR10_Pos = 0xa    // Position of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400  // Bit mask of BR10 field.
	GPIO_BRR_BR10     = 0x400  // Bit BR10.
	GPIO_BRR_BR11_Pos = 0xb    // Position of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800  // Bit mask of BR11 field.
	GPIO_BRR_BR11     = 0x800  // Bit BR11.
	GPIO_BRR_BR12_Pos = 0xc    // Position of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000 // Bit mask of BR12 field.
	GPIO_BRR_BR12     = 0x1000 // Bit BR12.
	GPIO_BRR_BR13_Pos = 0xd    // Position of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000 // Bit mask of BR13 field.
	GPIO_BRR_BR13     = 0x2000 // Bit BR13.
	GPIO_BRR_BR14_Pos = 0xe    // Position of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000 // Bit mask of BR14 field.
	GPIO_BRR_BR14     = 0x4000 // Bit BR14.
	GPIO_BRR_BR15_Pos = 0xf    // Position of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000 // Bit mask of BR15 field.
	GPIO_BRR_BR15     = 0x8000 // Bit BR15.
)

// Bitfields for AES: Advanced encryption standard hardware accelerator 1
const (
	// CR: control register
	AES_CR_NPBLB_Pos    = 0x14     // Position of NPBLB field.
	AES_CR_NPBLB_Msk    = 0xf00000 // Bit mask of NPBLB field.
	AES_CR_KEYSIZE_Pos  = 0x12     // Position of KEYSIZE field.
	AES_CR_KEYSIZE_Msk  = 0x40000  // Bit mask of KEYSIZE field.
	AES_CR_KEYSIZE      = 0x40000  // Bit KEYSIZE.
	AES_CR_CHMOD2_Pos   = 0x10     // Position of CHMOD2 field.
	AES_CR_CHMOD2_Msk   = 0x10000  // Bit mask of CHMOD2 field.
	AES_CR_CHMOD2       = 0x10000  // Bit CHMOD2.
	AES_CR_GCMPH_Pos    = 0xd      // Position of GCMPH field.
	AES_CR_GCMPH_Msk    = 0x6000   // Bit mask of GCMPH field.
	AES_CR_DMAOUTEN_Pos = 0xc      // Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000   // Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN     = 0x1000   // Bit DMAOUTEN.
	AES_CR_DMAINEN_Pos  = 0xb      // Position of DMAINEN field.
	AES_CR_DMAINEN_Msk  = 0x800    // Bit mask of DMAINEN field.
	AES_CR_DMAINEN      = 0x800    // Bit DMAINEN.
	AES_CR_ERRIE_Pos    = 0xa      // Position of ERRIE field.
	AES_CR_ERRIE_Msk    = 0x400    // Bit mask of ERRIE field.
	AES_CR_ERRIE        = 0x400    // Bit ERRIE.
	AES_CR_CCFIE_Pos    = 0x9      // Position of CCFIE field.
	AES_CR_CCFIE_Msk    = 0x200    // Bit mask of CCFIE field.
	AES_CR_CCFIE        = 0x200    // Bit CCFIE.
	AES_CR_ERRC_Pos     = 0x8      // Position of ERRC field.
	AES_CR_ERRC_Msk     = 0x100    // Bit mask of ERRC field.
	AES_CR_ERRC         = 0x100    // Bit ERRC.
	AES_CR_CCFC_Pos     = 0x7      // Position of CCFC field.
	AES_CR_CCFC_Msk     = 0x80     // Bit mask of CCFC field.
	AES_CR_CCFC         = 0x80     // Bit CCFC.
	AES_CR_CHMOD10_Pos  = 0x5      // Position of CHMOD10 field.
	AES_CR_CHMOD10_Msk  = 0x60     // Bit mask of CHMOD10 field.
	AES_CR_MODE_Pos     = 0x3      // Position of MODE field.
	AES_CR_MODE_Msk     = 0x18     // Bit mask of MODE field.
	AES_CR_DATATYPE_Pos = 0x1      // Position of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6      // Bit mask of DATATYPE field.
	AES_CR_EN_Pos       = 0x0      // Position of EN field.
	AES_CR_EN_Msk       = 0x1      // Bit mask of EN field.
	AES_CR_EN           = 0x1      // Bit EN.

	// SR: status register
	AES_SR_BUSY_Pos  = 0x3 // Position of BUSY field.
	AES_SR_BUSY_Msk  = 0x8 // Bit mask of BUSY field.
	AES_SR_BUSY      = 0x8 // Bit BUSY.
	AES_SR_WRERR_Pos = 0x2 // Position of WRERR field.
	AES_SR_WRERR_Msk = 0x4 // Bit mask of WRERR field.
	AES_SR_WRERR     = 0x4 // Bit WRERR.
	AES_SR_RDERR_Pos = 0x1 // Position of RDERR field.
	AES_SR_RDERR_Msk = 0x2 // Bit mask of RDERR field.
	AES_SR_RDERR     = 0x2 // Bit RDERR.
	AES_SR_CCF_Pos   = 0x0 // Position of CCF field.
	AES_SR_CCF_Msk   = 0x1 // Bit mask of CCF field.
	AES_SR_CCF       = 0x1 // Bit CCF.

	// DINR: data input register
	AES_DINR_AES_DINR_Pos = 0x0        // Position of AES_DINR field.
	AES_DINR_AES_DINR_Msk = 0xffffffff // Bit mask of AES_DINR field.

	// DOUTR: data output register
	AES_DOUTR_AES_DOUTR_Pos = 0x0        // Position of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Msk = 0xffffffff // Bit mask of AES_DOUTR field.

	// KEYR0: key register 0
	AES_KEYR0_AES_KEYR0_Pos = 0x0        // Position of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Msk = 0xffffffff // Bit mask of AES_KEYR0 field.

	// KEYR1: key register 1
	AES_KEYR1_AES_KEYR1_Pos = 0x0        // Position of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Msk = 0xffffffff // Bit mask of AES_KEYR1 field.

	// KEYR2: key register 2
	AES_KEYR2_AES_KEYR2_Pos = 0x0        // Position of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Msk = 0xffffffff // Bit mask of AES_KEYR2 field.

	// KEYR3: key register 3
	AES_KEYR3_AES_KEYR3_Pos = 0x0        // Position of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Msk = 0xffffffff // Bit mask of AES_KEYR3 field.

	// IVR0: initialization vector register           0
	AES_IVR0_AES_IVR0_Pos = 0x0        // Position of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Msk = 0xffffffff // Bit mask of AES_IVR0 field.

	// IVR1: initialization vector register           1
	AES_IVR1_AES_IVR1_Pos = 0x0        // Position of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Msk = 0xffffffff // Bit mask of AES_IVR1 field.

	// IVR2: initialization vector register           2
	AES_IVR2_AES_IVR2_Pos = 0x0        // Position of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Msk = 0xffffffff // Bit mask of AES_IVR2 field.

	// IVR3: initialization vector register           3
	AES_IVR3_AES_IVR3_Pos = 0x0        // Position of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Msk = 0xffffffff // Bit mask of AES_IVR3 field.

	// KEYR4: key register 4
	AES_KEYR4_AES_KEYR4_Pos = 0x0        // Position of AES_KEYR4 field.
	AES_KEYR4_AES_KEYR4_Msk = 0xffffffff // Bit mask of AES_KEYR4 field.

	// KEYR5: key register 5
	AES_KEYR5_AES_KEYR5_Pos = 0x0        // Position of AES_KEYR5 field.
	AES_KEYR5_AES_KEYR5_Msk = 0xffffffff // Bit mask of AES_KEYR5 field.

	// KEYR6: key register 6
	AES_KEYR6_AES_KEYR6_Pos = 0x0        // Position of AES_KEYR6 field.
	AES_KEYR6_AES_KEYR6_Msk = 0xffffffff // Bit mask of AES_KEYR6 field.

	// KEYR7: key register 7
	AES_KEYR7_AES_KEYR7_Pos = 0x0        // Position of AES_KEYR7 field.
	AES_KEYR7_AES_KEYR7_Msk = 0xffffffff // Bit mask of AES_KEYR7 field.

	// SUSP0R: AES suspend register 0
	AES_SUSP0R_AES_SUSP0R_Pos = 0x0        // Position of AES_SUSP0R field.
	AES_SUSP0R_AES_SUSP0R_Msk = 0xffffffff // Bit mask of AES_SUSP0R field.

	// SUSP1R: AES suspend register 1
	AES_SUSP1R_AES_SUSP1R_Pos = 0x0        // Position of AES_SUSP1R field.
	AES_SUSP1R_AES_SUSP1R_Msk = 0xffffffff // Bit mask of AES_SUSP1R field.

	// SUSP2R: AES suspend register 2
	AES_SUSP2R_AES_SUSP2R_Pos = 0x0        // Position of AES_SUSP2R field.
	AES_SUSP2R_AES_SUSP2R_Msk = 0xffffffff // Bit mask of AES_SUSP2R field.

	// SUSP3R: AES suspend register 3
	AES_SUSP3R_AES_SUSP3R_Pos = 0x0        // Position of AES_SUSP3R field.
	AES_SUSP3R_AES_SUSP3R_Msk = 0xffffffff // Bit mask of AES_SUSP3R field.

	// SUSP4R: AES suspend register 4
	AES_SUSP4R_AES_SUSP4R_Pos = 0x0        // Position of AES_SUSP4R field.
	AES_SUSP4R_AES_SUSP4R_Msk = 0xffffffff // Bit mask of AES_SUSP4R field.

	// SUSP5R: AES suspend register 5
	AES_SUSP5R_AES_SUSP5R_Pos = 0x0        // Position of AES_SUSP5R field.
	AES_SUSP5R_AES_SUSP5R_Msk = 0xffffffff // Bit mask of AES_SUSP5R field.

	// SUSP6R: AES suspend register 6
	AES_SUSP6R_AES_SUSP6R_Pos = 0x0        // Position of AES_SUSP6R field.
	AES_SUSP6R_AES_SUSP6R_Msk = 0xffffffff // Bit mask of AES_SUSP6R field.

	// SUSP7R: AES suspend register 7
	AES_SUSP7R_AES_SUSP7R_Pos = 0x0        // Position of AES_SUSP7R field.
	AES_SUSP7R_AES_SUSP7R_Msk = 0xffffffff // Bit mask of AES_SUSP7R field.

	// HWCFR: AES hardware configuration           register
	AES_HWCFR_CFG4_Pos = 0xc    // Position of CFG4 field.
	AES_HWCFR_CFG4_Msk = 0xf000 // Bit mask of CFG4 field.
	AES_HWCFR_CFG3_Pos = 0x8    // Position of CFG3 field.
	AES_HWCFR_CFG3_Msk = 0xf00  // Bit mask of CFG3 field.
	AES_HWCFR_CFG2_Pos = 0x4    // Position of CFG2 field.
	AES_HWCFR_CFG2_Msk = 0xf0   // Bit mask of CFG2 field.
	AES_HWCFR_CFG1_Pos = 0x0    // Position of CFG1 field.
	AES_HWCFR_CFG1_Msk = 0xf    // Bit mask of CFG1 field.

	// VERR: AES version register
	AES_VERR_MAJREV_Pos = 0x4  // Position of MAJREV field.
	AES_VERR_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.
	AES_VERR_MINREV_Pos = 0x0  // Position of MINREV field.
	AES_VERR_MINREV_Msk = 0xf  // Bit mask of MINREV field.

	// IPIDR: AES identification register
	AES_IPIDR_ID_Pos = 0x0        // Position of ID field.
	AES_IPIDR_ID_Msk = 0xffffffff // Bit mask of ID field.

	// SIDR: AES size ID register
	AES_SIDR_ID_Pos = 0x0        // Position of ID field.
	AES_SIDR_ID_Msk = 0xffffffff // Bit mask of ID field.
)

// Bitfields for RNG: Random number generator
const (
	// CR: control register
	RNG_CR_RNGEN_Pos = 0x2  // Position of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4  // Bit mask of RNGEN field.
	RNG_CR_RNGEN     = 0x4  // Bit RNGEN.
	RNG_CR_IE_Pos    = 0x3  // Position of IE field.
	RNG_CR_IE_Msk    = 0x8  // Bit mask of IE field.
	RNG_CR_IE        = 0x8  // Bit IE.
	RNG_CR_CED_Pos   = 0x5  // Position of CED field.
	RNG_CR_CED_Msk   = 0x20 // Bit mask of CED field.
	RNG_CR_CED       = 0x20 // Bit CED.
	RNG_CR_BYP_Pos   = 0x6  // Position of BYP field.
	RNG_CR_BYP_Msk   = 0x40 // Bit mask of BYP field.
	RNG_CR_BYP       = 0x40 // Bit BYP.

	// SR: status register
	RNG_SR_SEIS_Pos = 0x6  // Position of SEIS field.
	RNG_SR_SEIS_Msk = 0x40 // Bit mask of SEIS field.
	RNG_SR_SEIS     = 0x40 // Bit SEIS.
	RNG_SR_CEIS_Pos = 0x5  // Position of CEIS field.
	RNG_SR_CEIS_Msk = 0x20 // Bit mask of CEIS field.
	RNG_SR_CEIS     = 0x20 // Bit CEIS.
	RNG_SR_SECS_Pos = 0x2  // Position of SECS field.
	RNG_SR_SECS_Msk = 0x4  // Bit mask of SECS field.
	RNG_SR_SECS     = 0x4  // Bit SECS.
	RNG_SR_CECS_Pos = 0x1  // Position of CECS field.
	RNG_SR_CECS_Msk = 0x2  // Bit mask of CECS field.
	RNG_SR_CECS     = 0x2  // Bit CECS.
	RNG_SR_DRDY_Pos = 0x0  // Position of DRDY field.
	RNG_SR_DRDY_Msk = 0x1  // Bit mask of DRDY field.
	RNG_SR_DRDY     = 0x1  // Bit DRDY.

	// DR: data register
	RNG_DR_RNDATA_Pos = 0x0        // Position of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff // Bit mask of RNDATA field.
)

// Bitfields for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	CRC_DR_DR_Pos = 0x0        // Position of DR field.
	CRC_DR_DR_Msk = 0xffffffff // Bit mask of DR field.

	// IDR: Independent data register
	CRC_IDR_IDR_Pos = 0x0        // Position of IDR field.
	CRC_IDR_IDR_Msk = 0xffffffff // Bit mask of IDR field.

	// CR: Control register
	CRC_CR_REV_OUT_Pos  = 0x7  // Position of REV_OUT field.
	CRC_CR_REV_OUT_Msk  = 0x80 // Bit mask of REV_OUT field.
	CRC_CR_REV_OUT      = 0x80 // Bit REV_OUT.
	CRC_CR_REV_IN_Pos   = 0x5  // Position of REV_IN field.
	CRC_CR_REV_IN_Msk   = 0x60 // Bit mask of REV_IN field.
	CRC_CR_POLYSIZE_Pos = 0x3  // Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18 // Bit mask of POLYSIZE field.
	CRC_CR_RESET_Pos    = 0x0  // Position of RESET field.
	CRC_CR_RESET_Msk    = 0x1  // Bit mask of RESET field.
	CRC_CR_RESET        = 0x1  // Bit RESET.

	// INIT: Initial CRC value
	CRC_INIT_CRC_INIT_Pos = 0x0        // Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff // Bit mask of CRC_INIT field.

	// POL: polynomial
	CRC_POL_POL_Pos = 0x0        // Position of POL field.
	CRC_POL_POL_Msk = 0xffffffff // Bit mask of POL field.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// RTSR1: EXTI rising trigger selection           register
	EXTI_RTSR1_TR0_Pos  = 0x0     // Position of TR0 field.
	EXTI_RTSR1_TR0_Msk  = 0x1     // Bit mask of TR0 field.
	EXTI_RTSR1_TR0      = 0x1     // Bit TR0.
	EXTI_RTSR1_TR1_Pos  = 0x1     // Position of TR1 field.
	EXTI_RTSR1_TR1_Msk  = 0x2     // Bit mask of TR1 field.
	EXTI_RTSR1_TR1      = 0x2     // Bit TR1.
	EXTI_RTSR1_TR2_Pos  = 0x2     // Position of TR2 field.
	EXTI_RTSR1_TR2_Msk  = 0x4     // Bit mask of TR2 field.
	EXTI_RTSR1_TR2      = 0x4     // Bit TR2.
	EXTI_RTSR1_TR3_Pos  = 0x3     // Position of TR3 field.
	EXTI_RTSR1_TR3_Msk  = 0x8     // Bit mask of TR3 field.
	EXTI_RTSR1_TR3      = 0x8     // Bit TR3.
	EXTI_RTSR1_TR4_Pos  = 0x4     // Position of TR4 field.
	EXTI_RTSR1_TR4_Msk  = 0x10    // Bit mask of TR4 field.
	EXTI_RTSR1_TR4      = 0x10    // Bit TR4.
	EXTI_RTSR1_TR5_Pos  = 0x5     // Position of TR5 field.
	EXTI_RTSR1_TR5_Msk  = 0x20    // Bit mask of TR5 field.
	EXTI_RTSR1_TR5      = 0x20    // Bit TR5.
	EXTI_RTSR1_TR6_Pos  = 0x6     // Position of TR6 field.
	EXTI_RTSR1_TR6_Msk  = 0x40    // Bit mask of TR6 field.
	EXTI_RTSR1_TR6      = 0x40    // Bit TR6.
	EXTI_RTSR1_TR7_Pos  = 0x7     // Position of TR7 field.
	EXTI_RTSR1_TR7_Msk  = 0x80    // Bit mask of TR7 field.
	EXTI_RTSR1_TR7      = 0x80    // Bit TR7.
	EXTI_RTSR1_TR8_Pos  = 0x8     // Position of TR8 field.
	EXTI_RTSR1_TR8_Msk  = 0x100   // Bit mask of TR8 field.
	EXTI_RTSR1_TR8      = 0x100   // Bit TR8.
	EXTI_RTSR1_TR9_Pos  = 0x9     // Position of TR9 field.
	EXTI_RTSR1_TR9_Msk  = 0x200   // Bit mask of TR9 field.
	EXTI_RTSR1_TR9      = 0x200   // Bit TR9.
	EXTI_RTSR1_TR10_Pos = 0xa     // Position of TR10 field.
	EXTI_RTSR1_TR10_Msk = 0x400   // Bit mask of TR10 field.
	EXTI_RTSR1_TR10     = 0x400   // Bit TR10.
	EXTI_RTSR1_TR11_Pos = 0xb     // Position of TR11 field.
	EXTI_RTSR1_TR11_Msk = 0x800   // Bit mask of TR11 field.
	EXTI_RTSR1_TR11     = 0x800   // Bit TR11.
	EXTI_RTSR1_TR12_Pos = 0xc     // Position of TR12 field.
	EXTI_RTSR1_TR12_Msk = 0x1000  // Bit mask of TR12 field.
	EXTI_RTSR1_TR12     = 0x1000  // Bit TR12.
	EXTI_RTSR1_TR13_Pos = 0xd     // Position of TR13 field.
	EXTI_RTSR1_TR13_Msk = 0x2000  // Bit mask of TR13 field.
	EXTI_RTSR1_TR13     = 0x2000  // Bit TR13.
	EXTI_RTSR1_TR14_Pos = 0xe     // Position of TR14 field.
	EXTI_RTSR1_TR14_Msk = 0x4000  // Bit mask of TR14 field.
	EXTI_RTSR1_TR14     = 0x4000  // Bit TR14.
	EXTI_RTSR1_TR15_Pos = 0xf     // Position of TR15 field.
	EXTI_RTSR1_TR15_Msk = 0x8000  // Bit mask of TR15 field.
	EXTI_RTSR1_TR15     = 0x8000  // Bit TR15.
	EXTI_RTSR1_TR16_Pos = 0x10    // Position of TR16 field.
	EXTI_RTSR1_TR16_Msk = 0x10000 // Bit mask of TR16 field.
	EXTI_RTSR1_TR16     = 0x10000 // Bit TR16.
	EXTI_RTSR1_TR17_Pos = 0x11    // Position of TR17 field.
	EXTI_RTSR1_TR17_Msk = 0x20000 // Bit mask of TR17 field.
	EXTI_RTSR1_TR17     = 0x20000 // Bit TR17.
	EXTI_RTSR1_TR18_Pos = 0x12    // Position of TR18 field.
	EXTI_RTSR1_TR18_Msk = 0x40000 // Bit mask of TR18 field.
	EXTI_RTSR1_TR18     = 0x40000 // Bit TR18.

	// FTSR1: EXTI falling trigger selection           register
	EXTI_FTSR1_TR0_Pos  = 0x0     // Position of TR0 field.
	EXTI_FTSR1_TR0_Msk  = 0x1     // Bit mask of TR0 field.
	EXTI_FTSR1_TR0      = 0x1     // Bit TR0.
	EXTI_FTSR1_TR1_Pos  = 0x1     // Position of TR1 field.
	EXTI_FTSR1_TR1_Msk  = 0x2     // Bit mask of TR1 field.
	EXTI_FTSR1_TR1      = 0x2     // Bit TR1.
	EXTI_FTSR1_TR2_Pos  = 0x2     // Position of TR2 field.
	EXTI_FTSR1_TR2_Msk  = 0x4     // Bit mask of TR2 field.
	EXTI_FTSR1_TR2      = 0x4     // Bit TR2.
	EXTI_FTSR1_TR3_Pos  = 0x3     // Position of TR3 field.
	EXTI_FTSR1_TR3_Msk  = 0x8     // Bit mask of TR3 field.
	EXTI_FTSR1_TR3      = 0x8     // Bit TR3.
	EXTI_FTSR1_TR4_Pos  = 0x4     // Position of TR4 field.
	EXTI_FTSR1_TR4_Msk  = 0x10    // Bit mask of TR4 field.
	EXTI_FTSR1_TR4      = 0x10    // Bit TR4.
	EXTI_FTSR1_TR5_Pos  = 0x5     // Position of TR5 field.
	EXTI_FTSR1_TR5_Msk  = 0x20    // Bit mask of TR5 field.
	EXTI_FTSR1_TR5      = 0x20    // Bit TR5.
	EXTI_FTSR1_TR6_Pos  = 0x6     // Position of TR6 field.
	EXTI_FTSR1_TR6_Msk  = 0x40    // Bit mask of TR6 field.
	EXTI_FTSR1_TR6      = 0x40    // Bit TR6.
	EXTI_FTSR1_TR7_Pos  = 0x7     // Position of TR7 field.
	EXTI_FTSR1_TR7_Msk  = 0x80    // Bit mask of TR7 field.
	EXTI_FTSR1_TR7      = 0x80    // Bit TR7.
	EXTI_FTSR1_TR8_Pos  = 0x8     // Position of TR8 field.
	EXTI_FTSR1_TR8_Msk  = 0x100   // Bit mask of TR8 field.
	EXTI_FTSR1_TR8      = 0x100   // Bit TR8.
	EXTI_FTSR1_TR9_Pos  = 0x9     // Position of TR9 field.
	EXTI_FTSR1_TR9_Msk  = 0x200   // Bit mask of TR9 field.
	EXTI_FTSR1_TR9      = 0x200   // Bit TR9.
	EXTI_FTSR1_TR10_Pos = 0xa     // Position of TR10 field.
	EXTI_FTSR1_TR10_Msk = 0x400   // Bit mask of TR10 field.
	EXTI_FTSR1_TR10     = 0x400   // Bit TR10.
	EXTI_FTSR1_TR11_Pos = 0xb     // Position of TR11 field.
	EXTI_FTSR1_TR11_Msk = 0x800   // Bit mask of TR11 field.
	EXTI_FTSR1_TR11     = 0x800   // Bit TR11.
	EXTI_FTSR1_TR12_Pos = 0xc     // Position of TR12 field.
	EXTI_FTSR1_TR12_Msk = 0x1000  // Bit mask of TR12 field.
	EXTI_FTSR1_TR12     = 0x1000  // Bit TR12.
	EXTI_FTSR1_TR13_Pos = 0xd     // Position of TR13 field.
	EXTI_FTSR1_TR13_Msk = 0x2000  // Bit mask of TR13 field.
	EXTI_FTSR1_TR13     = 0x2000  // Bit TR13.
	EXTI_FTSR1_TR14_Pos = 0xe     // Position of TR14 field.
	EXTI_FTSR1_TR14_Msk = 0x4000  // Bit mask of TR14 field.
	EXTI_FTSR1_TR14     = 0x4000  // Bit TR14.
	EXTI_FTSR1_TR15_Pos = 0xf     // Position of TR15 field.
	EXTI_FTSR1_TR15_Msk = 0x8000  // Bit mask of TR15 field.
	EXTI_FTSR1_TR15     = 0x8000  // Bit TR15.
	EXTI_FTSR1_TR16_Pos = 0x10    // Position of TR16 field.
	EXTI_FTSR1_TR16_Msk = 0x10000 // Bit mask of TR16 field.
	EXTI_FTSR1_TR16     = 0x10000 // Bit TR16.
	EXTI_FTSR1_TR17_Pos = 0x11    // Position of TR17 field.
	EXTI_FTSR1_TR17_Msk = 0x20000 // Bit mask of TR17 field.
	EXTI_FTSR1_TR17     = 0x20000 // Bit TR17.
	EXTI_FTSR1_TR18_Pos = 0x12    // Position of TR18 field.
	EXTI_FTSR1_TR18_Msk = 0x40000 // Bit mask of TR18 field.
	EXTI_FTSR1_TR18     = 0x40000 // Bit TR18.

	// SWIER1: EXTI software interrupt event           register
	EXTI_SWIER1_SWIER0_Pos  = 0x0     // Position of SWIER0 field.
	EXTI_SWIER1_SWIER0_Msk  = 0x1     // Bit mask of SWIER0 field.
	EXTI_SWIER1_SWIER0      = 0x1     // Bit SWIER0.
	EXTI_SWIER1_SWIER1_Pos  = 0x1     // Position of SWIER1 field.
	EXTI_SWIER1_SWIER1_Msk  = 0x2     // Bit mask of SWIER1 field.
	EXTI_SWIER1_SWIER1      = 0x2     // Bit SWIER1.
	EXTI_SWIER1_SWIER2_Pos  = 0x2     // Position of SWIER2 field.
	EXTI_SWIER1_SWIER2_Msk  = 0x4     // Bit mask of SWIER2 field.
	EXTI_SWIER1_SWIER2      = 0x4     // Bit SWIER2.
	EXTI_SWIER1_SWIER3_Pos  = 0x3     // Position of SWIER3 field.
	EXTI_SWIER1_SWIER3_Msk  = 0x8     // Bit mask of SWIER3 field.
	EXTI_SWIER1_SWIER3      = 0x8     // Bit SWIER3.
	EXTI_SWIER1_SWIER4_Pos  = 0x4     // Position of SWIER4 field.
	EXTI_SWIER1_SWIER4_Msk  = 0x10    // Bit mask of SWIER4 field.
	EXTI_SWIER1_SWIER4      = 0x10    // Bit SWIER4.
	EXTI_SWIER1_SWIER5_Pos  = 0x5     // Position of SWIER5 field.
	EXTI_SWIER1_SWIER5_Msk  = 0x20    // Bit mask of SWIER5 field.
	EXTI_SWIER1_SWIER5      = 0x20    // Bit SWIER5.
	EXTI_SWIER1_SWIER6_Pos  = 0x6     // Position of SWIER6 field.
	EXTI_SWIER1_SWIER6_Msk  = 0x40    // Bit mask of SWIER6 field.
	EXTI_SWIER1_SWIER6      = 0x40    // Bit SWIER6.
	EXTI_SWIER1_SWIER7_Pos  = 0x7     // Position of SWIER7 field.
	EXTI_SWIER1_SWIER7_Msk  = 0x80    // Bit mask of SWIER7 field.
	EXTI_SWIER1_SWIER7      = 0x80    // Bit SWIER7.
	EXTI_SWIER1_SWIER8_Pos  = 0x8     // Position of SWIER8 field.
	EXTI_SWIER1_SWIER8_Msk  = 0x100   // Bit mask of SWIER8 field.
	EXTI_SWIER1_SWIER8      = 0x100   // Bit SWIER8.
	EXTI_SWIER1_SWIER9_Pos  = 0x9     // Position of SWIER9 field.
	EXTI_SWIER1_SWIER9_Msk  = 0x200   // Bit mask of SWIER9 field.
	EXTI_SWIER1_SWIER9      = 0x200   // Bit SWIER9.
	EXTI_SWIER1_SWIER10_Pos = 0xa     // Position of SWIER10 field.
	EXTI_SWIER1_SWIER10_Msk = 0x400   // Bit mask of SWIER10 field.
	EXTI_SWIER1_SWIER10     = 0x400   // Bit SWIER10.
	EXTI_SWIER1_SWIER11_Pos = 0xb     // Position of SWIER11 field.
	EXTI_SWIER1_SWIER11_Msk = 0x800   // Bit mask of SWIER11 field.
	EXTI_SWIER1_SWIER11     = 0x800   // Bit SWIER11.
	EXTI_SWIER1_SWIER12_Pos = 0xc     // Position of SWIER12 field.
	EXTI_SWIER1_SWIER12_Msk = 0x1000  // Bit mask of SWIER12 field.
	EXTI_SWIER1_SWIER12     = 0x1000  // Bit SWIER12.
	EXTI_SWIER1_SWIER13_Pos = 0xd     // Position of SWIER13 field.
	EXTI_SWIER1_SWIER13_Msk = 0x2000  // Bit mask of SWIER13 field.
	EXTI_SWIER1_SWIER13     = 0x2000  // Bit SWIER13.
	EXTI_SWIER1_SWIER14_Pos = 0xe     // Position of SWIER14 field.
	EXTI_SWIER1_SWIER14_Msk = 0x4000  // Bit mask of SWIER14 field.
	EXTI_SWIER1_SWIER14     = 0x4000  // Bit SWIER14.
	EXTI_SWIER1_SWIER15_Pos = 0xf     // Position of SWIER15 field.
	EXTI_SWIER1_SWIER15_Msk = 0x8000  // Bit mask of SWIER15 field.
	EXTI_SWIER1_SWIER15     = 0x8000  // Bit SWIER15.
	EXTI_SWIER1_SWIER16_Pos = 0x10    // Position of SWIER16 field.
	EXTI_SWIER1_SWIER16_Msk = 0x10000 // Bit mask of SWIER16 field.
	EXTI_SWIER1_SWIER16     = 0x10000 // Bit SWIER16.
	EXTI_SWIER1_SWIER17_Pos = 0x11    // Position of SWIER17 field.
	EXTI_SWIER1_SWIER17_Msk = 0x20000 // Bit mask of SWIER17 field.
	EXTI_SWIER1_SWIER17     = 0x20000 // Bit SWIER17.
	EXTI_SWIER1_SWIER18_Pos = 0x12    // Position of SWIER18 field.
	EXTI_SWIER1_SWIER18_Msk = 0x40000 // Bit mask of SWIER18 field.
	EXTI_SWIER1_SWIER18     = 0x40000 // Bit SWIER18.

	// RPR1: EXTI rising edge pending           register
	EXTI_RPR1_RPIF0_Pos  = 0x0     // Position of RPIF0 field.
	EXTI_RPR1_RPIF0_Msk  = 0x1     // Bit mask of RPIF0 field.
	EXTI_RPR1_RPIF0      = 0x1     // Bit RPIF0.
	EXTI_RPR1_RPIF1_Pos  = 0x1     // Position of RPIF1 field.
	EXTI_RPR1_RPIF1_Msk  = 0x2     // Bit mask of RPIF1 field.
	EXTI_RPR1_RPIF1      = 0x2     // Bit RPIF1.
	EXTI_RPR1_RPIF2_Pos  = 0x2     // Position of RPIF2 field.
	EXTI_RPR1_RPIF2_Msk  = 0x4     // Bit mask of RPIF2 field.
	EXTI_RPR1_RPIF2      = 0x4     // Bit RPIF2.
	EXTI_RPR1_RPIF3_Pos  = 0x3     // Position of RPIF3 field.
	EXTI_RPR1_RPIF3_Msk  = 0x8     // Bit mask of RPIF3 field.
	EXTI_RPR1_RPIF3      = 0x8     // Bit RPIF3.
	EXTI_RPR1_RPIF4_Pos  = 0x4     // Position of RPIF4 field.
	EXTI_RPR1_RPIF4_Msk  = 0x10    // Bit mask of RPIF4 field.
	EXTI_RPR1_RPIF4      = 0x10    // Bit RPIF4.
	EXTI_RPR1_RPIF5_Pos  = 0x5     // Position of RPIF5 field.
	EXTI_RPR1_RPIF5_Msk  = 0x20    // Bit mask of RPIF5 field.
	EXTI_RPR1_RPIF5      = 0x20    // Bit RPIF5.
	EXTI_RPR1_RPIF6_Pos  = 0x6     // Position of RPIF6 field.
	EXTI_RPR1_RPIF6_Msk  = 0x40    // Bit mask of RPIF6 field.
	EXTI_RPR1_RPIF6      = 0x40    // Bit RPIF6.
	EXTI_RPR1_RPIF7_Pos  = 0x7     // Position of RPIF7 field.
	EXTI_RPR1_RPIF7_Msk  = 0x80    // Bit mask of RPIF7 field.
	EXTI_RPR1_RPIF7      = 0x80    // Bit RPIF7.
	EXTI_RPR1_RPIF8_Pos  = 0x8     // Position of RPIF8 field.
	EXTI_RPR1_RPIF8_Msk  = 0x100   // Bit mask of RPIF8 field.
	EXTI_RPR1_RPIF8      = 0x100   // Bit RPIF8.
	EXTI_RPR1_RPIF9_Pos  = 0x9     // Position of RPIF9 field.
	EXTI_RPR1_RPIF9_Msk  = 0x200   // Bit mask of RPIF9 field.
	EXTI_RPR1_RPIF9      = 0x200   // Bit RPIF9.
	EXTI_RPR1_RPIF10_Pos = 0xa     // Position of RPIF10 field.
	EXTI_RPR1_RPIF10_Msk = 0x400   // Bit mask of RPIF10 field.
	EXTI_RPR1_RPIF10     = 0x400   // Bit RPIF10.
	EXTI_RPR1_RPIF11_Pos = 0xb     // Position of RPIF11 field.
	EXTI_RPR1_RPIF11_Msk = 0x800   // Bit mask of RPIF11 field.
	EXTI_RPR1_RPIF11     = 0x800   // Bit RPIF11.
	EXTI_RPR1_RPIF12_Pos = 0xc     // Position of RPIF12 field.
	EXTI_RPR1_RPIF12_Msk = 0x1000  // Bit mask of RPIF12 field.
	EXTI_RPR1_RPIF12     = 0x1000  // Bit RPIF12.
	EXTI_RPR1_RPIF13_Pos = 0xd     // Position of RPIF13 field.
	EXTI_RPR1_RPIF13_Msk = 0x2000  // Bit mask of RPIF13 field.
	EXTI_RPR1_RPIF13     = 0x2000  // Bit RPIF13.
	EXTI_RPR1_RPIF14_Pos = 0xe     // Position of RPIF14 field.
	EXTI_RPR1_RPIF14_Msk = 0x4000  // Bit mask of RPIF14 field.
	EXTI_RPR1_RPIF14     = 0x4000  // Bit RPIF14.
	EXTI_RPR1_RPIF15_Pos = 0xf     // Position of RPIF15 field.
	EXTI_RPR1_RPIF15_Msk = 0x8000  // Bit mask of RPIF15 field.
	EXTI_RPR1_RPIF15     = 0x8000  // Bit RPIF15.
	EXTI_RPR1_RPIF16_Pos = 0x10    // Position of RPIF16 field.
	EXTI_RPR1_RPIF16_Msk = 0x10000 // Bit mask of RPIF16 field.
	EXTI_RPR1_RPIF16     = 0x10000 // Bit RPIF16.
	EXTI_RPR1_RPIF17_Pos = 0x11    // Position of RPIF17 field.
	EXTI_RPR1_RPIF17_Msk = 0x20000 // Bit mask of RPIF17 field.
	EXTI_RPR1_RPIF17     = 0x20000 // Bit RPIF17.
	EXTI_RPR1_RPIF18_Pos = 0x12    // Position of RPIF18 field.
	EXTI_RPR1_RPIF18_Msk = 0x40000 // Bit mask of RPIF18 field.
	EXTI_RPR1_RPIF18     = 0x40000 // Bit RPIF18.

	// FPR1: EXTI falling edge pending           register
	EXTI_FPR1_FPIF0_Pos  = 0x0     // Position of FPIF0 field.
	EXTI_FPR1_FPIF0_Msk  = 0x1     // Bit mask of FPIF0 field.
	EXTI_FPR1_FPIF0      = 0x1     // Bit FPIF0.
	EXTI_FPR1_FPIF1_Pos  = 0x1     // Position of FPIF1 field.
	EXTI_FPR1_FPIF1_Msk  = 0x2     // Bit mask of FPIF1 field.
	EXTI_FPR1_FPIF1      = 0x2     // Bit FPIF1.
	EXTI_FPR1_FPIF2_Pos  = 0x2     // Position of FPIF2 field.
	EXTI_FPR1_FPIF2_Msk  = 0x4     // Bit mask of FPIF2 field.
	EXTI_FPR1_FPIF2      = 0x4     // Bit FPIF2.
	EXTI_FPR1_FPIF3_Pos  = 0x3     // Position of FPIF3 field.
	EXTI_FPR1_FPIF3_Msk  = 0x8     // Bit mask of FPIF3 field.
	EXTI_FPR1_FPIF3      = 0x8     // Bit FPIF3.
	EXTI_FPR1_FPIF4_Pos  = 0x4     // Position of FPIF4 field.
	EXTI_FPR1_FPIF4_Msk  = 0x10    // Bit mask of FPIF4 field.
	EXTI_FPR1_FPIF4      = 0x10    // Bit FPIF4.
	EXTI_FPR1_FPIF5_Pos  = 0x5     // Position of FPIF5 field.
	EXTI_FPR1_FPIF5_Msk  = 0x20    // Bit mask of FPIF5 field.
	EXTI_FPR1_FPIF5      = 0x20    // Bit FPIF5.
	EXTI_FPR1_FPIF6_Pos  = 0x6     // Position of FPIF6 field.
	EXTI_FPR1_FPIF6_Msk  = 0x40    // Bit mask of FPIF6 field.
	EXTI_FPR1_FPIF6      = 0x40    // Bit FPIF6.
	EXTI_FPR1_FPIF7_Pos  = 0x7     // Position of FPIF7 field.
	EXTI_FPR1_FPIF7_Msk  = 0x80    // Bit mask of FPIF7 field.
	EXTI_FPR1_FPIF7      = 0x80    // Bit FPIF7.
	EXTI_FPR1_FPIF8_Pos  = 0x8     // Position of FPIF8 field.
	EXTI_FPR1_FPIF8_Msk  = 0x100   // Bit mask of FPIF8 field.
	EXTI_FPR1_FPIF8      = 0x100   // Bit FPIF8.
	EXTI_FPR1_FPIF9_Pos  = 0x9     // Position of FPIF9 field.
	EXTI_FPR1_FPIF9_Msk  = 0x200   // Bit mask of FPIF9 field.
	EXTI_FPR1_FPIF9      = 0x200   // Bit FPIF9.
	EXTI_FPR1_FPIF10_Pos = 0xa     // Position of FPIF10 field.
	EXTI_FPR1_FPIF10_Msk = 0x400   // Bit mask of FPIF10 field.
	EXTI_FPR1_FPIF10     = 0x400   // Bit FPIF10.
	EXTI_FPR1_FPIF11_Pos = 0xb     // Position of FPIF11 field.
	EXTI_FPR1_FPIF11_Msk = 0x800   // Bit mask of FPIF11 field.
	EXTI_FPR1_FPIF11     = 0x800   // Bit FPIF11.
	EXTI_FPR1_FPIF12_Pos = 0xc     // Position of FPIF12 field.
	EXTI_FPR1_FPIF12_Msk = 0x1000  // Bit mask of FPIF12 field.
	EXTI_FPR1_FPIF12     = 0x1000  // Bit FPIF12.
	EXTI_FPR1_FPIF13_Pos = 0xd     // Position of FPIF13 field.
	EXTI_FPR1_FPIF13_Msk = 0x2000  // Bit mask of FPIF13 field.
	EXTI_FPR1_FPIF13     = 0x2000  // Bit FPIF13.
	EXTI_FPR1_FPIF14_Pos = 0xe     // Position of FPIF14 field.
	EXTI_FPR1_FPIF14_Msk = 0x4000  // Bit mask of FPIF14 field.
	EXTI_FPR1_FPIF14     = 0x4000  // Bit FPIF14.
	EXTI_FPR1_FPIF15_Pos = 0xf     // Position of FPIF15 field.
	EXTI_FPR1_FPIF15_Msk = 0x8000  // Bit mask of FPIF15 field.
	EXTI_FPR1_FPIF15     = 0x8000  // Bit FPIF15.
	EXTI_FPR1_FPIF16_Pos = 0x10    // Position of FPIF16 field.
	EXTI_FPR1_FPIF16_Msk = 0x10000 // Bit mask of FPIF16 field.
	EXTI_FPR1_FPIF16     = 0x10000 // Bit FPIF16.
	EXTI_FPR1_FPIF17_Pos = 0x11    // Position of FPIF17 field.
	EXTI_FPR1_FPIF17_Msk = 0x20000 // Bit mask of FPIF17 field.
	EXTI_FPR1_FPIF17     = 0x20000 // Bit FPIF17.
	EXTI_FPR1_FPIF18_Pos = 0x12    // Position of FPIF18 field.
	EXTI_FPR1_FPIF18_Msk = 0x40000 // Bit mask of FPIF18 field.
	EXTI_FPR1_FPIF18     = 0x40000 // Bit FPIF18.

	// EXTICR1: EXTI external interrupt selection           register
	EXTI_EXTICR1_EXTI0_7_Pos   = 0x0        // Position of EXTI0_7 field.
	EXTI_EXTICR1_EXTI0_7_Msk   = 0xff       // Bit mask of EXTI0_7 field.
	EXTI_EXTICR1_EXTI8_15_Pos  = 0x8        // Position of EXTI8_15 field.
	EXTI_EXTICR1_EXTI8_15_Msk  = 0xff00     // Bit mask of EXTI8_15 field.
	EXTI_EXTICR1_EXTI16_23_Pos = 0x10       // Position of EXTI16_23 field.
	EXTI_EXTICR1_EXTI16_23_Msk = 0xff0000   // Bit mask of EXTI16_23 field.
	EXTI_EXTICR1_EXTI24_31_Pos = 0x18       // Position of EXTI24_31 field.
	EXTI_EXTICR1_EXTI24_31_Msk = 0xff000000 // Bit mask of EXTI24_31 field.

	// EXTICR2: EXTI external interrupt selection           register
	EXTI_EXTICR2_EXTI0_7_Pos   = 0x0        // Position of EXTI0_7 field.
	EXTI_EXTICR2_EXTI0_7_Msk   = 0xff       // Bit mask of EXTI0_7 field.
	EXTI_EXTICR2_EXTI8_15_Pos  = 0x8        // Position of EXTI8_15 field.
	EXTI_EXTICR2_EXTI8_15_Msk  = 0xff00     // Bit mask of EXTI8_15 field.
	EXTI_EXTICR2_EXTI16_23_Pos = 0x10       // Position of EXTI16_23 field.
	EXTI_EXTICR2_EXTI16_23_Msk = 0xff0000   // Bit mask of EXTI16_23 field.
	EXTI_EXTICR2_EXTI24_31_Pos = 0x18       // Position of EXTI24_31 field.
	EXTI_EXTICR2_EXTI24_31_Msk = 0xff000000 // Bit mask of EXTI24_31 field.

	// EXTICR3: EXTI external interrupt selection           register
	EXTI_EXTICR3_EXTI0_7_Pos   = 0x0        // Position of EXTI0_7 field.
	EXTI_EXTICR3_EXTI0_7_Msk   = 0xff       // Bit mask of EXTI0_7 field.
	EXTI_EXTICR3_EXTI8_15_Pos  = 0x8        // Position of EXTI8_15 field.
	EXTI_EXTICR3_EXTI8_15_Msk  = 0xff00     // Bit mask of EXTI8_15 field.
	EXTI_EXTICR3_EXTI16_23_Pos = 0x10       // Position of EXTI16_23 field.
	EXTI_EXTICR3_EXTI16_23_Msk = 0xff0000   // Bit mask of EXTI16_23 field.
	EXTI_EXTICR3_EXTI24_31_Pos = 0x18       // Position of EXTI24_31 field.
	EXTI_EXTICR3_EXTI24_31_Msk = 0xff000000 // Bit mask of EXTI24_31 field.

	// EXTICR4: EXTI external interrupt selection           register
	EXTI_EXTICR4_EXTI0_7_Pos   = 0x0        // Position of EXTI0_7 field.
	EXTI_EXTICR4_EXTI0_7_Msk   = 0xff       // Bit mask of EXTI0_7 field.
	EXTI_EXTICR4_EXTI8_15_Pos  = 0x8        // Position of EXTI8_15 field.
	EXTI_EXTICR4_EXTI8_15_Msk  = 0xff00     // Bit mask of EXTI8_15 field.
	EXTI_EXTICR4_EXTI16_23_Pos = 0x10       // Position of EXTI16_23 field.
	EXTI_EXTICR4_EXTI16_23_Msk = 0xff0000   // Bit mask of EXTI16_23 field.
	EXTI_EXTICR4_EXTI24_31_Pos = 0x18       // Position of EXTI24_31 field.
	EXTI_EXTICR4_EXTI24_31_Msk = 0xff000000 // Bit mask of EXTI24_31 field.

	// IMR1: EXTI CPU wakeup with interrupt mask           register
	EXTI_IMR1_IM0_Pos  = 0x0        // Position of IM0 field.
	EXTI_IMR1_IM0_Msk  = 0x1        // Bit mask of IM0 field.
	EXTI_IMR1_IM0      = 0x1        // Bit IM0.
	EXTI_IMR1_IM1_Pos  = 0x1        // Position of IM1 field.
	EXTI_IMR1_IM1_Msk  = 0x2        // Bit mask of IM1 field.
	EXTI_IMR1_IM1      = 0x2        // Bit IM1.
	EXTI_IMR1_IM2_Pos  = 0x2        // Position of IM2 field.
	EXTI_IMR1_IM2_Msk  = 0x4        // Bit mask of IM2 field.
	EXTI_IMR1_IM2      = 0x4        // Bit IM2.
	EXTI_IMR1_IM3_Pos  = 0x3        // Position of IM3 field.
	EXTI_IMR1_IM3_Msk  = 0x8        // Bit mask of IM3 field.
	EXTI_IMR1_IM3      = 0x8        // Bit IM3.
	EXTI_IMR1_IM4_Pos  = 0x4        // Position of IM4 field.
	EXTI_IMR1_IM4_Msk  = 0x10       // Bit mask of IM4 field.
	EXTI_IMR1_IM4      = 0x10       // Bit IM4.
	EXTI_IMR1_IM5_Pos  = 0x5        // Position of IM5 field.
	EXTI_IMR1_IM5_Msk  = 0x20       // Bit mask of IM5 field.
	EXTI_IMR1_IM5      = 0x20       // Bit IM5.
	EXTI_IMR1_IM6_Pos  = 0x6        // Position of IM6 field.
	EXTI_IMR1_IM6_Msk  = 0x40       // Bit mask of IM6 field.
	EXTI_IMR1_IM6      = 0x40       // Bit IM6.
	EXTI_IMR1_IM7_Pos  = 0x7        // Position of IM7 field.
	EXTI_IMR1_IM7_Msk  = 0x80       // Bit mask of IM7 field.
	EXTI_IMR1_IM7      = 0x80       // Bit IM7.
	EXTI_IMR1_IM8_Pos  = 0x8        // Position of IM8 field.
	EXTI_IMR1_IM8_Msk  = 0x100      // Bit mask of IM8 field.
	EXTI_IMR1_IM8      = 0x100      // Bit IM8.
	EXTI_IMR1_IM9_Pos  = 0x9        // Position of IM9 field.
	EXTI_IMR1_IM9_Msk  = 0x200      // Bit mask of IM9 field.
	EXTI_IMR1_IM9      = 0x200      // Bit IM9.
	EXTI_IMR1_IM10_Pos = 0xa        // Position of IM10 field.
	EXTI_IMR1_IM10_Msk = 0x400      // Bit mask of IM10 field.
	EXTI_IMR1_IM10     = 0x400      // Bit IM10.
	EXTI_IMR1_IM11_Pos = 0xb        // Position of IM11 field.
	EXTI_IMR1_IM11_Msk = 0x800      // Bit mask of IM11 field.
	EXTI_IMR1_IM11     = 0x800      // Bit IM11.
	EXTI_IMR1_IM12_Pos = 0xc        // Position of IM12 field.
	EXTI_IMR1_IM12_Msk = 0x1000     // Bit mask of IM12 field.
	EXTI_IMR1_IM12     = 0x1000     // Bit IM12.
	EXTI_IMR1_IM13_Pos = 0xd        // Position of IM13 field.
	EXTI_IMR1_IM13_Msk = 0x2000     // Bit mask of IM13 field.
	EXTI_IMR1_IM13     = 0x2000     // Bit IM13.
	EXTI_IMR1_IM14_Pos = 0xe        // Position of IM14 field.
	EXTI_IMR1_IM14_Msk = 0x4000     // Bit mask of IM14 field.
	EXTI_IMR1_IM14     = 0x4000     // Bit IM14.
	EXTI_IMR1_IM15_Pos = 0xf        // Position of IM15 field.
	EXTI_IMR1_IM15_Msk = 0x8000     // Bit mask of IM15 field.
	EXTI_IMR1_IM15     = 0x8000     // Bit IM15.
	EXTI_IMR1_IM16_Pos = 0x10       // Position of IM16 field.
	EXTI_IMR1_IM16_Msk = 0x10000    // Bit mask of IM16 field.
	EXTI_IMR1_IM16     = 0x10000    // Bit IM16.
	EXTI_IMR1_IM17_Pos = 0x11       // Position of IM17 field.
	EXTI_IMR1_IM17_Msk = 0x20000    // Bit mask of IM17 field.
	EXTI_IMR1_IM17     = 0x20000    // Bit IM17.
	EXTI_IMR1_IM18_Pos = 0x12       // Position of IM18 field.
	EXTI_IMR1_IM18_Msk = 0x40000    // Bit mask of IM18 field.
	EXTI_IMR1_IM18     = 0x40000    // Bit IM18.
	EXTI_IMR1_IM19_Pos = 0x13       // Position of IM19 field.
	EXTI_IMR1_IM19_Msk = 0x80000    // Bit mask of IM19 field.
	EXTI_IMR1_IM19     = 0x80000    // Bit IM19.
	EXTI_IMR1_IM20_Pos = 0x14       // Position of IM20 field.
	EXTI_IMR1_IM20_Msk = 0x100000   // Bit mask of IM20 field.
	EXTI_IMR1_IM20     = 0x100000   // Bit IM20.
	EXTI_IMR1_IM21_Pos = 0x15       // Position of IM21 field.
	EXTI_IMR1_IM21_Msk = 0x200000   // Bit mask of IM21 field.
	EXTI_IMR1_IM21     = 0x200000   // Bit IM21.
	EXTI_IMR1_IM22_Pos = 0x16       // Position of IM22 field.
	EXTI_IMR1_IM22_Msk = 0x400000   // Bit mask of IM22 field.
	EXTI_IMR1_IM22     = 0x400000   // Bit IM22.
	EXTI_IMR1_IM23_Pos = 0x17       // Position of IM23 field.
	EXTI_IMR1_IM23_Msk = 0x800000   // Bit mask of IM23 field.
	EXTI_IMR1_IM23     = 0x800000   // Bit IM23.
	EXTI_IMR1_IM24_Pos = 0x18       // Position of IM24 field.
	EXTI_IMR1_IM24_Msk = 0x1000000  // Bit mask of IM24 field.
	EXTI_IMR1_IM24     = 0x1000000  // Bit IM24.
	EXTI_IMR1_IM25_Pos = 0x19       // Position of IM25 field.
	EXTI_IMR1_IM25_Msk = 0x2000000  // Bit mask of IM25 field.
	EXTI_IMR1_IM25     = 0x2000000  // Bit IM25.
	EXTI_IMR1_IM26_Pos = 0x1a       // Position of IM26 field.
	EXTI_IMR1_IM26_Msk = 0x4000000  // Bit mask of IM26 field.
	EXTI_IMR1_IM26     = 0x4000000  // Bit IM26.
	EXTI_IMR1_IM27_Pos = 0x1b       // Position of IM27 field.
	EXTI_IMR1_IM27_Msk = 0x8000000  // Bit mask of IM27 field.
	EXTI_IMR1_IM27     = 0x8000000  // Bit IM27.
	EXTI_IMR1_IM28_Pos = 0x1c       // Position of IM28 field.
	EXTI_IMR1_IM28_Msk = 0x10000000 // Bit mask of IM28 field.
	EXTI_IMR1_IM28     = 0x10000000 // Bit IM28.
	EXTI_IMR1_IM29_Pos = 0x1d       // Position of IM29 field.
	EXTI_IMR1_IM29_Msk = 0x20000000 // Bit mask of IM29 field.
	EXTI_IMR1_IM29     = 0x20000000 // Bit IM29.
	EXTI_IMR1_IM30_Pos = 0x1e       // Position of IM30 field.
	EXTI_IMR1_IM30_Msk = 0x40000000 // Bit mask of IM30 field.
	EXTI_IMR1_IM30     = 0x40000000 // Bit IM30.
	EXTI_IMR1_IM31_Pos = 0x1f       // Position of IM31 field.
	EXTI_IMR1_IM31_Msk = 0x80000000 // Bit mask of IM31 field.
	EXTI_IMR1_IM31     = 0x80000000 // Bit IM31.

	// EMR1: EXTI CPU wakeup with event mask           register
	EXTI_EMR1_EM0_Pos  = 0x0        // Position of EM0 field.
	EXTI_EMR1_EM0_Msk  = 0x1        // Bit mask of EM0 field.
	EXTI_EMR1_EM0      = 0x1        // Bit EM0.
	EXTI_EMR1_EM1_Pos  = 0x1        // Position of EM1 field.
	EXTI_EMR1_EM1_Msk  = 0x2        // Bit mask of EM1 field.
	EXTI_EMR1_EM1      = 0x2        // Bit EM1.
	EXTI_EMR1_EM2_Pos  = 0x2        // Position of EM2 field.
	EXTI_EMR1_EM2_Msk  = 0x4        // Bit mask of EM2 field.
	EXTI_EMR1_EM2      = 0x4        // Bit EM2.
	EXTI_EMR1_EM3_Pos  = 0x3        // Position of EM3 field.
	EXTI_EMR1_EM3_Msk  = 0x8        // Bit mask of EM3 field.
	EXTI_EMR1_EM3      = 0x8        // Bit EM3.
	EXTI_EMR1_EM4_Pos  = 0x4        // Position of EM4 field.
	EXTI_EMR1_EM4_Msk  = 0x10       // Bit mask of EM4 field.
	EXTI_EMR1_EM4      = 0x10       // Bit EM4.
	EXTI_EMR1_EM5_Pos  = 0x5        // Position of EM5 field.
	EXTI_EMR1_EM5_Msk  = 0x20       // Bit mask of EM5 field.
	EXTI_EMR1_EM5      = 0x20       // Bit EM5.
	EXTI_EMR1_EM6_Pos  = 0x6        // Position of EM6 field.
	EXTI_EMR1_EM6_Msk  = 0x40       // Bit mask of EM6 field.
	EXTI_EMR1_EM6      = 0x40       // Bit EM6.
	EXTI_EMR1_EM7_Pos  = 0x7        // Position of EM7 field.
	EXTI_EMR1_EM7_Msk  = 0x80       // Bit mask of EM7 field.
	EXTI_EMR1_EM7      = 0x80       // Bit EM7.
	EXTI_EMR1_EM8_Pos  = 0x8        // Position of EM8 field.
	EXTI_EMR1_EM8_Msk  = 0x100      // Bit mask of EM8 field.
	EXTI_EMR1_EM8      = 0x100      // Bit EM8.
	EXTI_EMR1_EM9_Pos  = 0x9        // Position of EM9 field.
	EXTI_EMR1_EM9_Msk  = 0x200      // Bit mask of EM9 field.
	EXTI_EMR1_EM9      = 0x200      // Bit EM9.
	EXTI_EMR1_EM10_Pos = 0xa        // Position of EM10 field.
	EXTI_EMR1_EM10_Msk = 0x400      // Bit mask of EM10 field.
	EXTI_EMR1_EM10     = 0x400      // Bit EM10.
	EXTI_EMR1_EM11_Pos = 0xb        // Position of EM11 field.
	EXTI_EMR1_EM11_Msk = 0x800      // Bit mask of EM11 field.
	EXTI_EMR1_EM11     = 0x800      // Bit EM11.
	EXTI_EMR1_EM12_Pos = 0xc        // Position of EM12 field.
	EXTI_EMR1_EM12_Msk = 0x1000     // Bit mask of EM12 field.
	EXTI_EMR1_EM12     = 0x1000     // Bit EM12.
	EXTI_EMR1_EM13_Pos = 0xd        // Position of EM13 field.
	EXTI_EMR1_EM13_Msk = 0x2000     // Bit mask of EM13 field.
	EXTI_EMR1_EM13     = 0x2000     // Bit EM13.
	EXTI_EMR1_EM14_Pos = 0xe        // Position of EM14 field.
	EXTI_EMR1_EM14_Msk = 0x4000     // Bit mask of EM14 field.
	EXTI_EMR1_EM14     = 0x4000     // Bit EM14.
	EXTI_EMR1_EM15_Pos = 0xf        // Position of EM15 field.
	EXTI_EMR1_EM15_Msk = 0x8000     // Bit mask of EM15 field.
	EXTI_EMR1_EM15     = 0x8000     // Bit EM15.
	EXTI_EMR1_EM16_Pos = 0x10       // Position of EM16 field.
	EXTI_EMR1_EM16_Msk = 0x10000    // Bit mask of EM16 field.
	EXTI_EMR1_EM16     = 0x10000    // Bit EM16.
	EXTI_EMR1_EM17_Pos = 0x11       // Position of EM17 field.
	EXTI_EMR1_EM17_Msk = 0x20000    // Bit mask of EM17 field.
	EXTI_EMR1_EM17     = 0x20000    // Bit EM17.
	EXTI_EMR1_EM18_Pos = 0x12       // Position of EM18 field.
	EXTI_EMR1_EM18_Msk = 0x40000    // Bit mask of EM18 field.
	EXTI_EMR1_EM18     = 0x40000    // Bit EM18.
	EXTI_EMR1_EM19_Pos = 0x13       // Position of EM19 field.
	EXTI_EMR1_EM19_Msk = 0x80000    // Bit mask of EM19 field.
	EXTI_EMR1_EM19     = 0x80000    // Bit EM19.
	EXTI_EMR1_EM21_Pos = 0x15       // Position of EM21 field.
	EXTI_EMR1_EM21_Msk = 0x200000   // Bit mask of EM21 field.
	EXTI_EMR1_EM21     = 0x200000   // Bit EM21.
	EXTI_EMR1_EM23_Pos = 0x17       // Position of EM23 field.
	EXTI_EMR1_EM23_Msk = 0x800000   // Bit mask of EM23 field.
	EXTI_EMR1_EM23     = 0x800000   // Bit EM23.
	EXTI_EMR1_EM25_Pos = 0x19       // Position of EM25 field.
	EXTI_EMR1_EM25_Msk = 0x2000000  // Bit mask of EM25 field.
	EXTI_EMR1_EM25     = 0x2000000  // Bit EM25.
	EXTI_EMR1_EM26_Pos = 0x1a       // Position of EM26 field.
	EXTI_EMR1_EM26_Msk = 0x4000000  // Bit mask of EM26 field.
	EXTI_EMR1_EM26     = 0x4000000  // Bit EM26.
	EXTI_EMR1_EM27_Pos = 0x1b       // Position of EM27 field.
	EXTI_EMR1_EM27_Msk = 0x8000000  // Bit mask of EM27 field.
	EXTI_EMR1_EM27     = 0x8000000  // Bit EM27.
	EXTI_EMR1_EM28_Pos = 0x1c       // Position of EM28 field.
	EXTI_EMR1_EM28_Msk = 0x10000000 // Bit mask of EM28 field.
	EXTI_EMR1_EM28     = 0x10000000 // Bit EM28.
	EXTI_EMR1_EM29_Pos = 0x1d       // Position of EM29 field.
	EXTI_EMR1_EM29_Msk = 0x20000000 // Bit mask of EM29 field.
	EXTI_EMR1_EM29     = 0x20000000 // Bit EM29.
	EXTI_EMR1_EM30_Pos = 0x1e       // Position of EM30 field.
	EXTI_EMR1_EM30_Msk = 0x40000000 // Bit mask of EM30 field.
	EXTI_EMR1_EM30     = 0x40000000 // Bit EM30.
	EXTI_EMR1_EM31_Pos = 0x1f       // Position of EM31 field.
	EXTI_EMR1_EM31_Msk = 0x80000000 // Bit mask of EM31 field.
	EXTI_EMR1_EM31     = 0x80000000 // Bit EM31.

	// IMR2: EXTI CPU wakeup with interrupt mask           register
	EXTI_IMR2_IM32_Pos = 0x0 // Position of IM32 field.
	EXTI_IMR2_IM32_Msk = 0x1 // Bit mask of IM32 field.
	EXTI_IMR2_IM32     = 0x1 // Bit IM32.
	EXTI_IMR2_IM33_Pos = 0x1 // Position of IM33 field.
	EXTI_IMR2_IM33_Msk = 0x2 // Bit mask of IM33 field.
	EXTI_IMR2_IM33     = 0x2 // Bit IM33.

	// EMR2: EXTI CPU wakeup with event mask           register
	EXTI_EMR2_EM32_Pos = 0x0 // Position of EM32 field.
	EXTI_EMR2_EM32_Msk = 0x1 // Bit mask of EM32 field.
	EXTI_EMR2_EM32     = 0x1 // Bit EM32.
	EXTI_EMR2_EM33_Pos = 0x1 // Position of EM33 field.
	EXTI_EMR2_EM33_Msk = 0x2 // Bit mask of EM33 field.
	EXTI_EMR2_EM33     = 0x2 // Bit EM33.

	// HWCFGR7: Hardware configuration           registers
	EXTI_HWCFGR7_CPUEVENT_Pos = 0x0        // Position of CPUEVENT field.
	EXTI_HWCFGR7_CPUEVENT_Msk = 0xffffffff // Bit mask of CPUEVENT field.

	// HWCFGR6: Hardware configuration           registers
	EXTI_HWCFGR6_CPUEVENT_Pos = 0x0        // Position of CPUEVENT field.
	EXTI_HWCFGR6_CPUEVENT_Msk = 0xffffffff // Bit mask of CPUEVENT field.

	// HWCFGR5: Hardware configuration           registers
	EXTI_HWCFGR5_CPUEVENT_Pos = 0x0        // Position of CPUEVENT field.
	EXTI_HWCFGR5_CPUEVENT_Msk = 0xffffffff // Bit mask of CPUEVENT field.

	// HWCFGR4: Hardware configuration           registers
	EXTI_HWCFGR4_EVENT_TRG_Pos = 0x0        // Position of EVENT_TRG field.
	EXTI_HWCFGR4_EVENT_TRG_Msk = 0xffffffff // Bit mask of EVENT_TRG field.

	// HWCFGR3: Hardware configuration           registers
	EXTI_HWCFGR3_EVENT_TRG_Pos = 0x0        // Position of EVENT_TRG field.
	EXTI_HWCFGR3_EVENT_TRG_Msk = 0xffffffff // Bit mask of EVENT_TRG field.

	// HWCFGR2: Hardware configuration           registers
	EXTI_HWCFGR2_EVENT_TRG_Pos = 0x0        // Position of EVENT_TRG field.
	EXTI_HWCFGR2_EVENT_TRG_Msk = 0xffffffff // Bit mask of EVENT_TRG field.

	// HWCFGR1: Hardware configuration           registers
	EXTI_HWCFGR1_NBIOPORT_Pos = 0x10     // Position of NBIOPORT field.
	EXTI_HWCFGR1_NBIOPORT_Msk = 0xff0000 // Bit mask of NBIOPORT field.
	EXTI_HWCFGR1_CPUEVTEN_Pos = 0xc      // Position of CPUEVTEN field.
	EXTI_HWCFGR1_CPUEVTEN_Msk = 0xf000   // Bit mask of CPUEVTEN field.
	EXTI_HWCFGR1_NBCPUS_Pos   = 0x8      // Position of NBCPUS field.
	EXTI_HWCFGR1_NBCPUS_Msk   = 0xf00    // Bit mask of NBCPUS field.
	EXTI_HWCFGR1_NBEVENTS_Pos = 0x0      // Position of NBEVENTS field.
	EXTI_HWCFGR1_NBEVENTS_Msk = 0xff     // Bit mask of NBEVENTS field.

	// VERR: AES version register
	EXTI_VERR_MAJREV_Pos = 0x4  // Position of MAJREV field.
	EXTI_VERR_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.
	EXTI_VERR_MINREV_Pos = 0x0  // Position of MINREV field.
	EXTI_VERR_MINREV_Msk = 0xf  // Bit mask of MINREV field.

	// IPIDR: AES identification register
	EXTI_IPIDR_ID_Pos = 0x0        // Position of ID field.
	EXTI_IPIDR_ID_Msk = 0xffffffff // Bit mask of ID field.

	// SIDR: AES size ID register
	EXTI_SIDR_ID_Pos = 0x0        // Position of ID field.
	EXTI_SIDR_ID_Msk = 0xffffffff // Bit mask of ID field.
)

// Bitfields for TIM16: General purpose timers
const (
	// CR1: control register 1
	TIM_CR1_CEN_Pos      = 0x0   // Position of CEN field.
	TIM_CR1_CEN_Msk      = 0x1   // Bit mask of CEN field.
	TIM_CR1_CEN          = 0x1   // Bit CEN.
	TIM_CR1_UDIS_Pos     = 0x1   // Position of UDIS field.
	TIM_CR1_UDIS_Msk     = 0x2   // Bit mask of UDIS field.
	TIM_CR1_UDIS         = 0x2   // Bit UDIS.
	TIM_CR1_URS_Pos      = 0x2   // Position of URS field.
	TIM_CR1_URS_Msk      = 0x4   // Bit mask of URS field.
	TIM_CR1_URS          = 0x4   // Bit URS.
	TIM_CR1_OPM_Pos      = 0x3   // Position of OPM field.
	TIM_CR1_OPM_Msk      = 0x8   // Bit mask of OPM field.
	TIM_CR1_OPM          = 0x8   // Bit OPM.
	TIM_CR1_ARPE_Pos     = 0x7   // Position of ARPE field.
	TIM_CR1_ARPE_Msk     = 0x80  // Bit mask of ARPE field.
	TIM_CR1_ARPE         = 0x80  // Bit ARPE.
	TIM_CR1_CKD_Pos      = 0x8   // Position of CKD field.
	TIM_CR1_CKD_Msk      = 0x300 // Bit mask of CKD field.
	TIM_CR1_UIFREMAP_Pos = 0xb   // Position of UIFREMAP field.
	TIM_CR1_UIFREMAP_Msk = 0x800 // Bit mask of UIFREMAP field.
	TIM_CR1_UIFREMAP     = 0x800 // Bit UIFREMAP.

	// CR2: control register 2
	TIM_CR2_OIS1N_Pos = 0x9   // Position of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200 // Bit mask of OIS1N field.
	TIM_CR2_OIS1N     = 0x200 // Bit OIS1N.
	TIM_CR2_OIS1_Pos  = 0x8   // Position of OIS1 field.
	TIM_CR2_OIS1_Msk  = 0x100 // Bit mask of OIS1 field.
	TIM_CR2_OIS1      = 0x100 // Bit OIS1.
	TIM_CR2_CCDS_Pos  = 0x3   // Position of CCDS field.
	TIM_CR2_CCDS_Msk  = 0x8   // Bit mask of CCDS field.
	TIM_CR2_CCDS      = 0x8   // Bit CCDS.
	TIM_CR2_CCUS_Pos  = 0x2   // Position of CCUS field.
	TIM_CR2_CCUS_Msk  = 0x4   // Bit mask of CCUS field.
	TIM_CR2_CCUS      = 0x4   // Bit CCUS.
	TIM_CR2_CCPC_Pos  = 0x0   // Position of CCPC field.
	TIM_CR2_CCPC_Msk  = 0x1   // Bit mask of CCPC field.
	TIM_CR2_CCPC      = 0x1   // Bit CCPC.

	// DIER: DMA/Interrupt enable register
	TIM_DIER_COMDE_Pos = 0xd    // Position of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000 // Bit mask of COMDE field.
	TIM_DIER_COMDE     = 0x2000 // Bit COMDE.
	TIM_DIER_CC1DE_Pos = 0x9    // Position of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200  // Bit mask of CC1DE field.
	TIM_DIER_CC1DE     = 0x200  // Bit CC1DE.
	TIM_DIER_UDE_Pos   = 0x8    // Position of UDE field.
	TIM_DIER_UDE_Msk   = 0x100  // Bit mask of UDE field.
	TIM_DIER_UDE       = 0x100  // Bit UDE.
	TIM_DIER_BIE_Pos   = 0x7    // Position of BIE field.
	TIM_DIER_BIE_Msk   = 0x80   // Bit mask of BIE field.
	TIM_DIER_BIE       = 0x80   // Bit BIE.
	TIM_DIER_COMIE_Pos = 0x5    // Position of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20   // Bit mask of COMIE field.
	TIM_DIER_COMIE     = 0x20   // Bit COMIE.
	TIM_DIER_CC1IE_Pos = 0x1    // Position of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2    // Bit mask of CC1IE field.
	TIM_DIER_CC1IE     = 0x2    // Bit CC1IE.
	TIM_DIER_UIE_Pos   = 0x0    // Position of UIE field.
	TIM_DIER_UIE_Msk   = 0x1    // Bit mask of UIE field.
	TIM_DIER_UIE       = 0x1    // Bit UIE.

	// SR: status register
	TIM_SR_CC1OF_Pos = 0x9   // Position of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200 // Bit mask of CC1OF field.
	TIM_SR_CC1OF     = 0x200 // Bit CC1OF.
	TIM_SR_BIF_Pos   = 0x7   // Position of BIF field.
	TIM_SR_BIF_Msk   = 0x80  // Bit mask of BIF field.
	TIM_SR_BIF       = 0x80  // Bit BIF.
	TIM_SR_COMIF_Pos = 0x5   // Position of COMIF field.
	TIM_SR_COMIF_Msk = 0x20  // Bit mask of COMIF field.
	TIM_SR_COMIF     = 0x20  // Bit COMIF.
	TIM_SR_CC1IF_Pos = 0x1   // Position of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2   // Bit mask of CC1IF field.
	TIM_SR_CC1IF     = 0x2   // Bit CC1IF.
	TIM_SR_UIF_Pos   = 0x0   // Position of UIF field.
	TIM_SR_UIF_Msk   = 0x1   // Bit mask of UIF field.
	TIM_SR_UIF       = 0x1   // Bit UIF.

	// EGR: event generation register
	TIM_EGR_BG_Pos   = 0x7  // Position of BG field.
	TIM_EGR_BG_Msk   = 0x80 // Bit mask of BG field.
	TIM_EGR_BG       = 0x80 // Bit BG.
	TIM_EGR_COMG_Pos = 0x5  // Position of COMG field.
	TIM_EGR_COMG_Msk = 0x20 // Bit mask of COMG field.
	TIM_EGR_COMG     = 0x20 // Bit COMG.
	TIM_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIM_EGR_CC1G     = 0x2  // Bit CC1G.
	TIM_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIM_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIM_EGR_UG       = 0x1  // Bit UG.

	// CCMR1_Output: capture/compare mode register (output           mode)
	TIM_CCMR1_Output_OC1M_2_Pos = 0x10    // Position of OC1M_2 field.
	TIM_CCMR1_Output_OC1M_2_Msk = 0x10000 // Bit mask of OC1M_2 field.
	TIM_CCMR1_Output_OC1M_2     = 0x10000 // Bit OC1M_2.
	TIM_CCMR1_Output_OC1M_Pos   = 0x4     // Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk   = 0x70    // Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1PE_Pos  = 0x3     // Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk  = 0x8     // Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE      = 0x8     // Bit OC1PE.
	TIM_CCMR1_Output_OC1FE_Pos  = 0x2     // Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk  = 0x4     // Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE      = 0x4     // Bit OC1FE.
	TIM_CCMR1_Output_CC1S_Pos   = 0x0     // Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk   = 0x3     // Bit mask of CC1S field.

	// CCMR1_Input: capture/compare mode register 1 (input           mode)
	TIM_CCMR1_Input_IC1F_Pos   = 0x4  // Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk   = 0xf0 // Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2  // Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc  // Bit mask of IC1PSC field.
	TIM_CCMR1_Input_CC1S_Pos   = 0x0  // Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk   = 0x3  // Bit mask of CC1S field.

	// CCER: capture/compare enable           register
	TIM_CCER_CC1NP_Pos = 0x3 // Position of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8 // Bit mask of CC1NP field.
	TIM_CCER_CC1NP     = 0x8 // Bit CC1NP.
	TIM_CCER_CC1NE_Pos = 0x2 // Position of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4 // Bit mask of CC1NE field.
	TIM_CCER_CC1NE     = 0x4 // Bit CC1NE.
	TIM_CCER_CC1P_Pos  = 0x1 // Position of CC1P field.
	TIM_CCER_CC1P_Msk  = 0x2 // Bit mask of CC1P field.
	TIM_CCER_CC1P      = 0x2 // Bit CC1P.
	TIM_CCER_CC1E_Pos  = 0x0 // Position of CC1E field.
	TIM_CCER_CC1E_Msk  = 0x1 // Bit mask of CC1E field.
	TIM_CCER_CC1E      = 0x1 // Bit CC1E.

	// CNT: counter
	TIM_CNT_CNT_Pos    = 0x0        // Position of CNT field.
	TIM_CNT_CNT_Msk    = 0xffff     // Bit mask of CNT field.
	TIM_CNT_UIFCPY_Pos = 0x1f       // Position of UIFCPY field.
	TIM_CNT_UIFCPY_Msk = 0x80000000 // Bit mask of UIFCPY field.
	TIM_CNT_UIFCPY     = 0x80000000 // Bit UIFCPY.

	// PSC: prescaler
	TIM_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: auto-reload register
	TIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	TIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// RCR: repetition counter register
	TIM_RCR_REP_Pos = 0x0  // Position of REP field.
	TIM_RCR_REP_Msk = 0xff // Bit mask of REP field.

	// CCR1: capture/compare register 1
	TIM_CCR1_CCR1_Pos = 0x0    // Position of CCR1 field.
	TIM_CCR1_CCR1_Msk = 0xffff // Bit mask of CCR1 field.

	// BDTR: break and dead-time register
	TIM_BDTR_DTG_Pos    = 0x0        // Position of DTG field.
	TIM_BDTR_DTG_Msk    = 0xff       // Bit mask of DTG field.
	TIM_BDTR_LOCK_Pos   = 0x8        // Position of LOCK field.
	TIM_BDTR_LOCK_Msk   = 0x300      // Bit mask of LOCK field.
	TIM_BDTR_OSSI_Pos   = 0xa        // Position of OSSI field.
	TIM_BDTR_OSSI_Msk   = 0x400      // Bit mask of OSSI field.
	TIM_BDTR_OSSI       = 0x400      // Bit OSSI.
	TIM_BDTR_OSSR_Pos   = 0xb        // Position of OSSR field.
	TIM_BDTR_OSSR_Msk   = 0x800      // Bit mask of OSSR field.
	TIM_BDTR_OSSR       = 0x800      // Bit OSSR.
	TIM_BDTR_BKE_Pos    = 0xc        // Position of BKE field.
	TIM_BDTR_BKE_Msk    = 0x1000     // Bit mask of BKE field.
	TIM_BDTR_BKE        = 0x1000     // Bit BKE.
	TIM_BDTR_BKP_Pos    = 0xd        // Position of BKP field.
	TIM_BDTR_BKP_Msk    = 0x2000     // Bit mask of BKP field.
	TIM_BDTR_BKP        = 0x2000     // Bit BKP.
	TIM_BDTR_AOE_Pos    = 0xe        // Position of AOE field.
	TIM_BDTR_AOE_Msk    = 0x4000     // Bit mask of AOE field.
	TIM_BDTR_AOE        = 0x4000     // Bit AOE.
	TIM_BDTR_MOE_Pos    = 0xf        // Position of MOE field.
	TIM_BDTR_MOE_Msk    = 0x8000     // Bit mask of MOE field.
	TIM_BDTR_MOE        = 0x8000     // Bit MOE.
	TIM_BDTR_BKF_Pos    = 0x10       // Position of BKF field.
	TIM_BDTR_BKF_Msk    = 0xf0000    // Bit mask of BKF field.
	TIM_BDTR_BKDSRM_Pos = 0x1a       // Position of BKDSRM field.
	TIM_BDTR_BKDSRM_Msk = 0x4000000  // Bit mask of BKDSRM field.
	TIM_BDTR_BKDSRM     = 0x4000000  // Bit BKDSRM.
	TIM_BDTR_BKBID_Pos  = 0x1c       // Position of BKBID field.
	TIM_BDTR_BKBID_Msk  = 0x10000000 // Bit mask of BKBID field.
	TIM_BDTR_BKBID      = 0x10000000 // Bit BKBID.

	// DCR: DMA control register
	TIM_DCR_DBL_Pos = 0x8    // Position of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00 // Bit mask of DBL field.
	TIM_DCR_DBA_Pos = 0x0    // Position of DBA field.
	TIM_DCR_DBA_Msk = 0x1f   // Bit mask of DBA field.

	// DMAR: DMA address for full transfer
	TIM_DMAR_DMAB_Pos = 0x0    // Position of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff // Bit mask of DMAB field.

	// AF1: TIM17 option register 1
	TIM_AF1_BKINE_Pos    = 0x0   // Position of BKINE field.
	TIM_AF1_BKINE_Msk    = 0x1   // Bit mask of BKINE field.
	TIM_AF1_BKINE        = 0x1   // Bit BKINE.
	TIM_AF1_BKCMP1E_Pos  = 0x1   // Position of BKCMP1E field.
	TIM_AF1_BKCMP1E_Msk  = 0x2   // Bit mask of BKCMP1E field.
	TIM_AF1_BKCMP1E      = 0x2   // Bit BKCMP1E.
	TIM_AF1_BKCMP2E_Pos  = 0x2   // Position of BKCMP2E field.
	TIM_AF1_BKCMP2E_Msk  = 0x4   // Bit mask of BKCMP2E field.
	TIM_AF1_BKCMP2E      = 0x4   // Bit BKCMP2E.
	TIM_AF1_BKDFBK1E_Pos = 0x8   // Position of BKDFBK1E field.
	TIM_AF1_BKDFBK1E_Msk = 0x100 // Bit mask of BKDFBK1E field.
	TIM_AF1_BKDFBK1E     = 0x100 // Bit BKDFBK1E.
	TIM_AF1_BKINP_Pos    = 0x9   // Position of BKINP field.
	TIM_AF1_BKINP_Msk    = 0x200 // Bit mask of BKINP field.
	TIM_AF1_BKINP        = 0x200 // Bit BKINP.
	TIM_AF1_BKCMP1P_Pos  = 0xa   // Position of BKCMP1P field.
	TIM_AF1_BKCMP1P_Msk  = 0x400 // Bit mask of BKCMP1P field.
	TIM_AF1_BKCMP1P      = 0x400 // Bit BKCMP1P.
	TIM_AF1_BKCMP2P_Pos  = 0xb   // Position of BKCMP2P field.
	TIM_AF1_BKCMP2P_Msk  = 0x800 // Bit mask of BKCMP2P field.
	TIM_AF1_BKCMP2P      = 0x800 // Bit BKCMP2P.

	// TISEL: input selection register
	TIM_TISEL_TI1SEL_Pos = 0x0 // Position of TI1SEL field.
	TIM_TISEL_TI1SEL_Msk = 0xf // Bit mask of TI1SEL field.
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	USART_CR1_RXFFIE_Pos = 0x1f       // Position of RXFFIE field.
	USART_CR1_RXFFIE_Msk = 0x80000000 // Bit mask of RXFFIE field.
	USART_CR1_RXFFIE     = 0x80000000 // Bit RXFFIE.
	USART_CR1_TXFEIE_Pos = 0x1e       // Position of TXFEIE field.
	USART_CR1_TXFEIE_Msk = 0x40000000 // Bit mask of TXFEIE field.
	USART_CR1_TXFEIE     = 0x40000000 // Bit TXFEIE.
	USART_CR1_FIFOEN_Pos = 0x1d       // Position of FIFOEN field.
	USART_CR1_FIFOEN_Msk = 0x20000000 // Bit mask of FIFOEN field.
	USART_CR1_FIFOEN     = 0x20000000 // Bit FIFOEN.
	USART_CR1_M1_Pos     = 0x1c       // Position of M1 field.
	USART_CR1_M1_Msk     = 0x10000000 // Bit mask of M1 field.
	USART_CR1_M1         = 0x10000000 // Bit M1.
	USART_CR1_EOBIE_Pos  = 0x1b       // Position of EOBIE field.
	USART_CR1_EOBIE_Msk  = 0x8000000  // Bit mask of EOBIE field.
	USART_CR1_EOBIE      = 0x8000000  // Bit EOBIE.
	USART_CR1_RTOIE_Pos  = 0x1a       // Position of RTOIE field.
	USART_CR1_RTOIE_Msk  = 0x4000000  // Bit mask of RTOIE field.
	USART_CR1_RTOIE      = 0x4000000  // Bit RTOIE.
	USART_CR1_DEAT_Pos   = 0x15       // Position of DEAT field.
	USART_CR1_DEAT_Msk   = 0x3e00000  // Bit mask of DEAT field.
	USART_CR1_DEDT_Pos   = 0x10       // Position of DEDT field.
	USART_CR1_DEDT_Msk   = 0x1f0000   // Bit mask of DEDT field.
	USART_CR1_OVER8_Pos  = 0xf        // Position of OVER8 field.
	USART_CR1_OVER8_Msk  = 0x8000     // Bit mask of OVER8 field.
	USART_CR1_OVER8      = 0x8000     // Bit OVER8.
	USART_CR1_CMIE_Pos   = 0xe        // Position of CMIE field.
	USART_CR1_CMIE_Msk   = 0x4000     // Bit mask of CMIE field.
	USART_CR1_CMIE       = 0x4000     // Bit CMIE.
	USART_CR1_MME_Pos    = 0xd        // Position of MME field.
	USART_CR1_MME_Msk    = 0x2000     // Bit mask of MME field.
	USART_CR1_MME        = 0x2000     // Bit MME.
	USART_CR1_M0_Pos     = 0xc        // Position of M0 field.
	USART_CR1_M0_Msk     = 0x1000     // Bit mask of M0 field.
	USART_CR1_M0         = 0x1000     // Bit M0.
	USART_CR1_WAKE_Pos   = 0xb        // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800      // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800      // Bit WAKE.
	USART_CR1_PCE_Pos    = 0xa        // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400      // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400      // Bit PCE.
	USART_CR1_PS_Pos     = 0x9        // Position of PS field.
	USART_CR1_PS_Msk     = 0x200      // Bit mask of PS field.
	USART_CR1_PS         = 0x200      // Bit PS.
	USART_CR1_PEIE_Pos   = 0x8        // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100      // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100      // Bit PEIE.
	USART_CR1_TXEIE_Pos  = 0x7        // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80       // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80       // Bit TXEIE.
	USART_CR1_TCIE_Pos   = 0x6        // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40       // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40       // Bit TCIE.
	USART_CR1_RXNEIE_Pos = 0x5        // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20       // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20       // Bit RXNEIE.
	USART_CR1_IDLEIE_Pos = 0x4        // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10       // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10       // Bit IDLEIE.
	USART_CR1_TE_Pos     = 0x3        // Position of TE field.
	USART_CR1_TE_Msk     = 0x8        // Bit mask of TE field.
	USART_CR1_TE         = 0x8        // Bit TE.
	USART_CR1_RE_Pos     = 0x2        // Position of RE field.
	USART_CR1_RE_Msk     = 0x4        // Bit mask of RE field.
	USART_CR1_RE         = 0x4        // Bit RE.
	USART_CR1_UESM_Pos   = 0x1        // Position of UESM field.
	USART_CR1_UESM_Msk   = 0x2        // Bit mask of UESM field.
	USART_CR1_UESM       = 0x2        // Bit UESM.
	USART_CR1_UE_Pos     = 0x0        // Position of UE field.
	USART_CR1_UE_Msk     = 0x1        // Bit mask of UE field.
	USART_CR1_UE         = 0x1        // Bit UE.

	// CR2: Control register 2
	USART_CR2_ADD4_7_Pos   = 0x1c       // Position of ADD4_7 field.
	USART_CR2_ADD4_7_Msk   = 0xf0000000 // Bit mask of ADD4_7 field.
	USART_CR2_ADD0_3_Pos   = 0x18       // Position of ADD0_3 field.
	USART_CR2_ADD0_3_Msk   = 0xf000000  // Bit mask of ADD0_3 field.
	USART_CR2_RTOEN_Pos    = 0x17       // Position of RTOEN field.
	USART_CR2_RTOEN_Msk    = 0x800000   // Bit mask of RTOEN field.
	USART_CR2_RTOEN        = 0x800000   // Bit RTOEN.
	USART_CR2_ABRMOD_Pos   = 0x15       // Position of ABRMOD field.
	USART_CR2_ABRMOD_Msk   = 0x600000   // Bit mask of ABRMOD field.
	USART_CR2_ABREN_Pos    = 0x14       // Position of ABREN field.
	USART_CR2_ABREN_Msk    = 0x100000   // Bit mask of ABREN field.
	USART_CR2_ABREN        = 0x100000   // Bit ABREN.
	USART_CR2_MSBFIRST_Pos = 0x13       // Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000    // Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST     = 0x80000    // Bit MSBFIRST.
	USART_CR2_TAINV_Pos    = 0x12       // Position of TAINV field.
	USART_CR2_TAINV_Msk    = 0x40000    // Bit mask of TAINV field.
	USART_CR2_TAINV        = 0x40000    // Bit TAINV.
	USART_CR2_TXINV_Pos    = 0x11       // Position of TXINV field.
	USART_CR2_TXINV_Msk    = 0x20000    // Bit mask of TXINV field.
	USART_CR2_TXINV        = 0x20000    // Bit TXINV.
	USART_CR2_RXINV_Pos    = 0x10       // Position of RXINV field.
	USART_CR2_RXINV_Msk    = 0x10000    // Bit mask of RXINV field.
	USART_CR2_RXINV        = 0x10000    // Bit RXINV.
	USART_CR2_SWAP_Pos     = 0xf        // Position of SWAP field.
	USART_CR2_SWAP_Msk     = 0x8000     // Bit mask of SWAP field.
	USART_CR2_SWAP         = 0x8000     // Bit SWAP.
	USART_CR2_LINEN_Pos    = 0xe        // Position of LINEN field.
	USART_CR2_LINEN_Msk    = 0x4000     // Bit mask of LINEN field.
	USART_CR2_LINEN        = 0x4000     // Bit LINEN.
	USART_CR2_STOP_Pos     = 0xc        // Position of STOP field.
	USART_CR2_STOP_Msk     = 0x3000     // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos    = 0xb        // Position of CLKEN field.
	USART_CR2_CLKEN_Msk    = 0x800      // Bit mask of CLKEN field.
	USART_CR2_CLKEN        = 0x800      // Bit CLKEN.
	USART_CR2_CPOL_Pos     = 0xa        // Position of CPOL field.
	USART_CR2_CPOL_Msk     = 0x400      // Bit mask of CPOL field.
	USART_CR2_CPOL         = 0x400      // Bit CPOL.
	USART_CR2_CPHA_Pos     = 0x9        // Position of CPHA field.
	USART_CR2_CPHA_Msk     = 0x200      // Bit mask of CPHA field.
	USART_CR2_CPHA         = 0x200      // Bit CPHA.
	USART_CR2_LBCL_Pos     = 0x8        // Position of LBCL field.
	USART_CR2_LBCL_Msk     = 0x100      // Bit mask of LBCL field.
	USART_CR2_LBCL         = 0x100      // Bit LBCL.
	USART_CR2_LBDIE_Pos    = 0x6        // Position of LBDIE field.
	USART_CR2_LBDIE_Msk    = 0x40       // Bit mask of LBDIE field.
	USART_CR2_LBDIE        = 0x40       // Bit LBDIE.
	USART_CR2_LBDL_Pos     = 0x5        // Position of LBDL field.
	USART_CR2_LBDL_Msk     = 0x20       // Bit mask of LBDL field.
	USART_CR2_LBDL         = 0x20       // Bit LBDL.
	USART_CR2_ADDM7_Pos    = 0x4        // Position of ADDM7 field.
	USART_CR2_ADDM7_Msk    = 0x10       // Bit mask of ADDM7 field.
	USART_CR2_ADDM7        = 0x10       // Bit ADDM7.
	USART_CR2_DIS_NSS_Pos  = 0x3        // Position of DIS_NSS field.
	USART_CR2_DIS_NSS_Msk  = 0x8        // Bit mask of DIS_NSS field.
	USART_CR2_DIS_NSS      = 0x8        // Bit DIS_NSS.
	USART_CR2_SLVEN_Pos    = 0x0        // Position of SLVEN field.
	USART_CR2_SLVEN_Msk    = 0x1        // Bit mask of SLVEN field.
	USART_CR2_SLVEN        = 0x1        // Bit SLVEN.

	// CR3: Control register 3
	USART_CR3_TXFTCFG_Pos = 0x1d       // Position of TXFTCFG field.
	USART_CR3_TXFTCFG_Msk = 0xe0000000 // Bit mask of TXFTCFG field.
	USART_CR3_RXFTIE_Pos  = 0x1c       // Position of RXFTIE field.
	USART_CR3_RXFTIE_Msk  = 0x10000000 // Bit mask of RXFTIE field.
	USART_CR3_RXFTIE      = 0x10000000 // Bit RXFTIE.
	USART_CR3_RXFTCFG_Pos = 0x19       // Position of RXFTCFG field.
	USART_CR3_RXFTCFG_Msk = 0xe000000  // Bit mask of RXFTCFG field.
	USART_CR3_TCBGTIE_Pos = 0x18       // Position of TCBGTIE field.
	USART_CR3_TCBGTIE_Msk = 0x1000000  // Bit mask of TCBGTIE field.
	USART_CR3_TCBGTIE     = 0x1000000  // Bit TCBGTIE.
	USART_CR3_TXFTIE_Pos  = 0x17       // Position of TXFTIE field.
	USART_CR3_TXFTIE_Msk  = 0x800000   // Bit mask of TXFTIE field.
	USART_CR3_TXFTIE      = 0x800000   // Bit TXFTIE.
	USART_CR3_WUFIE_Pos   = 0x16       // Position of WUFIE field.
	USART_CR3_WUFIE_Msk   = 0x400000   // Bit mask of WUFIE field.
	USART_CR3_WUFIE       = 0x400000   // Bit WUFIE.
	USART_CR3_WUS_Pos     = 0x14       // Position of WUS field.
	USART_CR3_WUS_Msk     = 0x300000   // Bit mask of WUS field.
	USART_CR3_SCARCNT_Pos = 0x11       // Position of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000    // Bit mask of SCARCNT field.
	USART_CR3_DEP_Pos     = 0xf        // Position of DEP field.
	USART_CR3_DEP_Msk     = 0x8000     // Bit mask of DEP field.
	USART_CR3_DEP         = 0x8000     // Bit DEP.
	USART_CR3_DEM_Pos     = 0xe        // Position of DEM field.
	USART_CR3_DEM_Msk     = 0x4000     // Bit mask of DEM field.
	USART_CR3_DEM         = 0x4000     // Bit DEM.
	USART_CR3_DDRE_Pos    = 0xd        // Position of DDRE field.
	USART_CR3_DDRE_Msk    = 0x2000     // Bit mask of DDRE field.
	USART_CR3_DDRE        = 0x2000     // Bit DDRE.
	USART_CR3_OVRDIS_Pos  = 0xc        // Position of OVRDIS field.
	USART_CR3_OVRDIS_Msk  = 0x1000     // Bit mask of OVRDIS field.
	USART_CR3_OVRDIS      = 0x1000     // Bit OVRDIS.
	USART_CR3_ONEBIT_Pos  = 0xb        // Position of ONEBIT field.
	USART_CR3_ONEBIT_Msk  = 0x800      // Bit mask of ONEBIT field.
	USART_CR3_ONEBIT      = 0x800      // Bit ONEBIT.
	USART_CR3_CTSIE_Pos   = 0xa        // Position of CTSIE field.
	USART_CR3_CTSIE_Msk   = 0x400      // Bit mask of CTSIE field.
	USART_CR3_CTSIE       = 0x400      // Bit CTSIE.
	USART_CR3_CTSE_Pos    = 0x9        // Position of CTSE field.
	USART_CR3_CTSE_Msk    = 0x200      // Bit mask of CTSE field.
	USART_CR3_CTSE        = 0x200      // Bit CTSE.
	USART_CR3_RTSE_Pos    = 0x8        // Position of RTSE field.
	USART_CR3_RTSE_Msk    = 0x100      // Bit mask of RTSE field.
	USART_CR3_RTSE        = 0x100      // Bit RTSE.
	USART_CR3_DMAT_Pos    = 0x7        // Position of DMAT field.
	USART_CR3_DMAT_Msk    = 0x80       // Bit mask of DMAT field.
	USART_CR3_DMAT        = 0x80       // Bit DMAT.
	USART_CR3_DMAR_Pos    = 0x6        // Position of DMAR field.
	USART_CR3_DMAR_Msk    = 0x40       // Bit mask of DMAR field.
	USART_CR3_DMAR        = 0x40       // Bit DMAR.
	USART_CR3_SCEN_Pos    = 0x5        // Position of SCEN field.
	USART_CR3_SCEN_Msk    = 0x20       // Bit mask of SCEN field.
	USART_CR3_SCEN        = 0x20       // Bit SCEN.
	USART_CR3_NACK_Pos    = 0x4        // Position of NACK field.
	USART_CR3_NACK_Msk    = 0x10       // Bit mask of NACK field.
	USART_CR3_NACK        = 0x10       // Bit NACK.
	USART_CR3_HDSEL_Pos   = 0x3        // Position of HDSEL field.
	USART_CR3_HDSEL_Msk   = 0x8        // Bit mask of HDSEL field.
	USART_CR3_HDSEL       = 0x8        // Bit HDSEL.
	USART_CR3_IRLP_Pos    = 0x2        // Position of IRLP field.
	USART_CR3_IRLP_Msk    = 0x4        // Bit mask of IRLP field.
	USART_CR3_IRLP        = 0x4        // Bit IRLP.
	USART_CR3_IREN_Pos    = 0x1        // Position of IREN field.
	USART_CR3_IREN_Msk    = 0x2        // Bit mask of IREN field.
	USART_CR3_IREN        = 0x2        // Bit IREN.
	USART_CR3_EIE_Pos     = 0x0        // Position of EIE field.
	USART_CR3_EIE_Msk     = 0x1        // Bit mask of EIE field.
	USART_CR3_EIE         = 0x1        // Bit EIE.

	// BRR: Baud rate register
	USART_BRR_BRR_4_15_Pos = 0x4    // Position of BRR_4_15 field.
	USART_BRR_BRR_4_15_Msk = 0xfff0 // Bit mask of BRR_4_15 field.
	USART_BRR_BRR_0_3_Pos  = 0x0    // Position of BRR_0_3 field.
	USART_BRR_BRR_0_3_Msk  = 0xf    // Bit mask of BRR_0_3 field.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.

	// RTOR: Receiver timeout register
	USART_RTOR_BLEN_Pos = 0x18       // Position of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000 // Bit mask of BLEN field.
	USART_RTOR_RTO_Pos  = 0x0        // Position of RTO field.
	USART_RTOR_RTO_Msk  = 0xffffff   // Bit mask of RTO field.

	// RQR: Request register
	USART_RQR_TXFRQ_Pos = 0x4  // Position of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10 // Bit mask of TXFRQ field.
	USART_RQR_TXFRQ     = 0x10 // Bit TXFRQ.
	USART_RQR_RXFRQ_Pos = 0x3  // Position of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8  // Bit mask of RXFRQ field.
	USART_RQR_RXFRQ     = 0x8  // Bit RXFRQ.
	USART_RQR_MMRQ_Pos  = 0x2  // Position of MMRQ field.
	USART_RQR_MMRQ_Msk  = 0x4  // Bit mask of MMRQ field.
	USART_RQR_MMRQ      = 0x4  // Bit MMRQ.
	USART_RQR_SBKRQ_Pos = 0x1  // Position of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2  // Bit mask of SBKRQ field.
	USART_RQR_SBKRQ     = 0x2  // Bit SBKRQ.
	USART_RQR_ABRRQ_Pos = 0x0  // Position of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1  // Bit mask of ABRRQ field.
	USART_RQR_ABRRQ     = 0x1  // Bit ABRRQ.

	// ISR: Interrupt & status           register
	USART_ISR_TXFT_Pos  = 0x1b      // Position of TXFT field.
	USART_ISR_TXFT_Msk  = 0x8000000 // Bit mask of TXFT field.
	USART_ISR_TXFT      = 0x8000000 // Bit TXFT.
	USART_ISR_RXFT_Pos  = 0x1a      // Position of RXFT field.
	USART_ISR_RXFT_Msk  = 0x4000000 // Bit mask of RXFT field.
	USART_ISR_RXFT      = 0x4000000 // Bit RXFT.
	USART_ISR_TCBGT_Pos = 0x19      // Position of TCBGT field.
	USART_ISR_TCBGT_Msk = 0x2000000 // Bit mask of TCBGT field.
	USART_ISR_TCBGT     = 0x2000000 // Bit TCBGT.
	USART_ISR_RXFF_Pos  = 0x18      // Position of RXFF field.
	USART_ISR_RXFF_Msk  = 0x1000000 // Bit mask of RXFF field.
	USART_ISR_RXFF      = 0x1000000 // Bit RXFF.
	USART_ISR_TXFE_Pos  = 0x17      // Position of TXFE field.
	USART_ISR_TXFE_Msk  = 0x800000  // Bit mask of TXFE field.
	USART_ISR_TXFE      = 0x800000  // Bit TXFE.
	USART_ISR_REACK_Pos = 0x16      // Position of REACK field.
	USART_ISR_REACK_Msk = 0x400000  // Bit mask of REACK field.
	USART_ISR_REACK     = 0x400000  // Bit REACK.
	USART_ISR_TEACK_Pos = 0x15      // Position of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000  // Bit mask of TEACK field.
	USART_ISR_TEACK     = 0x200000  // Bit TEACK.
	USART_ISR_WUF_Pos   = 0x14      // Position of WUF field.
	USART_ISR_WUF_Msk   = 0x100000  // Bit mask of WUF field.
	USART_ISR_WUF       = 0x100000  // Bit WUF.
	USART_ISR_RWU_Pos   = 0x13      // Position of RWU field.
	USART_ISR_RWU_Msk   = 0x80000   // Bit mask of RWU field.
	USART_ISR_RWU       = 0x80000   // Bit RWU.
	USART_ISR_SBKF_Pos  = 0x12      // Position of SBKF field.
	USART_ISR_SBKF_Msk  = 0x40000   // Bit mask of SBKF field.
	USART_ISR_SBKF      = 0x40000   // Bit SBKF.
	USART_ISR_CMF_Pos   = 0x11      // Position of CMF field.
	USART_ISR_CMF_Msk   = 0x20000   // Bit mask of CMF field.
	USART_ISR_CMF       = 0x20000   // Bit CMF.
	USART_ISR_BUSY_Pos  = 0x10      // Position of BUSY field.
	USART_ISR_BUSY_Msk  = 0x10000   // Bit mask of BUSY field.
	USART_ISR_BUSY      = 0x10000   // Bit BUSY.
	USART_ISR_ABRF_Pos  = 0xf       // Position of ABRF field.
	USART_ISR_ABRF_Msk  = 0x8000    // Bit mask of ABRF field.
	USART_ISR_ABRF      = 0x8000    // Bit ABRF.
	USART_ISR_ABRE_Pos  = 0xe       // Position of ABRE field.
	USART_ISR_ABRE_Msk  = 0x4000    // Bit mask of ABRE field.
	USART_ISR_ABRE      = 0x4000    // Bit ABRE.
	USART_ISR_UDR_Pos   = 0xd       // Position of UDR field.
	USART_ISR_UDR_Msk   = 0x2000    // Bit mask of UDR field.
	USART_ISR_UDR       = 0x2000    // Bit UDR.
	USART_ISR_EOBF_Pos  = 0xc       // Position of EOBF field.
	USART_ISR_EOBF_Msk  = 0x1000    // Bit mask of EOBF field.
	USART_ISR_EOBF      = 0x1000    // Bit EOBF.
	USART_ISR_RTOF_Pos  = 0xb       // Position of RTOF field.
	USART_ISR_RTOF_Msk  = 0x800     // Bit mask of RTOF field.
	USART_ISR_RTOF      = 0x800     // Bit RTOF.
	USART_ISR_CTS_Pos   = 0xa       // Position of CTS field.
	USART_ISR_CTS_Msk   = 0x400     // Bit mask of CTS field.
	USART_ISR_CTS       = 0x400     // Bit CTS.
	USART_ISR_CTSIF_Pos = 0x9       // Position of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200     // Bit mask of CTSIF field.
	USART_ISR_CTSIF     = 0x200     // Bit CTSIF.
	USART_ISR_LBDF_Pos  = 0x8       // Position of LBDF field.
	USART_ISR_LBDF_Msk  = 0x100     // Bit mask of LBDF field.
	USART_ISR_LBDF      = 0x100     // Bit LBDF.
	USART_ISR_TXE_Pos   = 0x7       // Position of TXE field.
	USART_ISR_TXE_Msk   = 0x80      // Bit mask of TXE field.
	USART_ISR_TXE       = 0x80      // Bit TXE.
	USART_ISR_TC_Pos    = 0x6       // Position of TC field.
	USART_ISR_TC_Msk    = 0x40      // Bit mask of TC field.
	USART_ISR_TC        = 0x40      // Bit TC.
	USART_ISR_RXNE_Pos  = 0x5       // Position of RXNE field.
	USART_ISR_RXNE_Msk  = 0x20      // Bit mask of RXNE field.
	USART_ISR_RXNE      = 0x20      // Bit RXNE.
	USART_ISR_IDLE_Pos  = 0x4       // Position of IDLE field.
	USART_ISR_IDLE_Msk  = 0x10      // Bit mask of IDLE field.
	USART_ISR_IDLE      = 0x10      // Bit IDLE.
	USART_ISR_ORE_Pos   = 0x3       // Position of ORE field.
	USART_ISR_ORE_Msk   = 0x8       // Bit mask of ORE field.
	USART_ISR_ORE       = 0x8       // Bit ORE.
	USART_ISR_NF_Pos    = 0x2       // Position of NF field.
	USART_ISR_NF_Msk    = 0x4       // Bit mask of NF field.
	USART_ISR_NF        = 0x4       // Bit NF.
	USART_ISR_FE_Pos    = 0x1       // Position of FE field.
	USART_ISR_FE_Msk    = 0x2       // Bit mask of FE field.
	USART_ISR_FE        = 0x2       // Bit FE.
	USART_ISR_PE_Pos    = 0x0       // Position of PE field.
	USART_ISR_PE_Msk    = 0x1       // Bit mask of PE field.
	USART_ISR_PE        = 0x1       // Bit PE.

	// ICR: Interrupt flag clear register
	USART_ICR_WUCF_Pos    = 0x14     // Position of WUCF field.
	USART_ICR_WUCF_Msk    = 0x100000 // Bit mask of WUCF field.
	USART_ICR_WUCF        = 0x100000 // Bit WUCF.
	USART_ICR_CMCF_Pos    = 0x11     // Position of CMCF field.
	USART_ICR_CMCF_Msk    = 0x20000  // Bit mask of CMCF field.
	USART_ICR_CMCF        = 0x20000  // Bit CMCF.
	USART_ICR_UDRCF_Pos   = 0xd      // Position of UDRCF field.
	USART_ICR_UDRCF_Msk   = 0x2000   // Bit mask of UDRCF field.
	USART_ICR_UDRCF       = 0x2000   // Bit UDRCF.
	USART_ICR_EOBCF_Pos   = 0xc      // Position of EOBCF field.
	USART_ICR_EOBCF_Msk   = 0x1000   // Bit mask of EOBCF field.
	USART_ICR_EOBCF       = 0x1000   // Bit EOBCF.
	USART_ICR_RTOCF_Pos   = 0xb      // Position of RTOCF field.
	USART_ICR_RTOCF_Msk   = 0x800    // Bit mask of RTOCF field.
	USART_ICR_RTOCF       = 0x800    // Bit RTOCF.
	USART_ICR_CTSCF_Pos   = 0x9      // Position of CTSCF field.
	USART_ICR_CTSCF_Msk   = 0x200    // Bit mask of CTSCF field.
	USART_ICR_CTSCF       = 0x200    // Bit CTSCF.
	USART_ICR_LBDCF_Pos   = 0x8      // Position of LBDCF field.
	USART_ICR_LBDCF_Msk   = 0x100    // Bit mask of LBDCF field.
	USART_ICR_LBDCF       = 0x100    // Bit LBDCF.
	USART_ICR_TCBGTCF_Pos = 0x7      // Position of TCBGTCF field.
	USART_ICR_TCBGTCF_Msk = 0x80     // Bit mask of TCBGTCF field.
	USART_ICR_TCBGTCF     = 0x80     // Bit TCBGTCF.
	USART_ICR_TCCF_Pos    = 0x6      // Position of TCCF field.
	USART_ICR_TCCF_Msk    = 0x40     // Bit mask of TCCF field.
	USART_ICR_TCCF        = 0x40     // Bit TCCF.
	USART_ICR_TXFECF_Pos  = 0x5      // Position of TXFECF field.
	USART_ICR_TXFECF_Msk  = 0x20     // Bit mask of TXFECF field.
	USART_ICR_TXFECF      = 0x20     // Bit TXFECF.
	USART_ICR_IDLECF_Pos  = 0x4      // Position of IDLECF field.
	USART_ICR_IDLECF_Msk  = 0x10     // Bit mask of IDLECF field.
	USART_ICR_IDLECF      = 0x10     // Bit IDLECF.
	USART_ICR_ORECF_Pos   = 0x3      // Position of ORECF field.
	USART_ICR_ORECF_Msk   = 0x8      // Bit mask of ORECF field.
	USART_ICR_ORECF       = 0x8      // Bit ORECF.
	USART_ICR_NCF_Pos     = 0x2      // Position of NCF field.
	USART_ICR_NCF_Msk     = 0x4      // Bit mask of NCF field.
	USART_ICR_NCF         = 0x4      // Bit NCF.
	USART_ICR_FECF_Pos    = 0x1      // Position of FECF field.
	USART_ICR_FECF_Msk    = 0x2      // Bit mask of FECF field.
	USART_ICR_FECF        = 0x2      // Bit FECF.
	USART_ICR_PECF_Pos    = 0x0      // Position of PECF field.
	USART_ICR_PECF_Msk    = 0x1      // Bit mask of PECF field.
	USART_ICR_PECF        = 0x1      // Bit PECF.

	// RDR: Receive data register
	USART_RDR_RDR_Pos = 0x0   // Position of RDR field.
	USART_RDR_RDR_Msk = 0x1ff // Bit mask of RDR field.

	// TDR: Transmit data register
	USART_TDR_TDR_Pos = 0x0   // Position of TDR field.
	USART_TDR_TDR_Msk = 0x1ff // Bit mask of TDR field.

	// PRESC: Prescaler register
	USART_PRESC_PRESCALER_Pos = 0x0 // Position of PRESCALER field.
	USART_PRESC_PRESCALER_Msk = 0xf // Bit mask of PRESCALER field.
)

// Bitfields for SPI1: Serial peripheral interface/Inter-IC sound
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_DFF_Pos      = 0xb    // Position of DFF field.
	SPI_CR1_DFF_Msk      = 0x800  // Bit mask of DFF field.
	SPI_CR1_DFF          = 0x800  // Bit DFF.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_RXDMAEN_Pos = 0x0    // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1    // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1    // Bit RXDMAEN.
	SPI_CR2_TXDMAEN_Pos = 0x1    // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2    // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2    // Bit TXDMAEN.
	SPI_CR2_SSOE_Pos    = 0x2    // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4    // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4    // Bit SSOE.
	SPI_CR2_NSSP_Pos    = 0x3    // Position of NSSP field.
	SPI_CR2_NSSP_Msk    = 0x8    // Bit mask of NSSP field.
	SPI_CR2_NSSP        = 0x8    // Bit NSSP.
	SPI_CR2_FRF_Pos     = 0x4    // Position of FRF field.
	SPI_CR2_FRF_Msk     = 0x10   // Bit mask of FRF field.
	SPI_CR2_FRF         = 0x10   // Bit FRF.
	SPI_CR2_ERRIE_Pos   = 0x5    // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20   // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20   // Bit ERRIE.
	SPI_CR2_RXNEIE_Pos  = 0x6    // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40   // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40   // Bit RXNEIE.
	SPI_CR2_TXEIE_Pos   = 0x7    // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80   // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80   // Bit TXEIE.
	SPI_CR2_DS_Pos      = 0x8    // Position of DS field.
	SPI_CR2_DS_Msk      = 0xf00  // Bit mask of DS field.
	SPI_CR2_FRXTH_Pos   = 0xc    // Position of FRXTH field.
	SPI_CR2_FRXTH_Msk   = 0x1000 // Bit mask of FRXTH field.
	SPI_CR2_FRXTH       = 0x1000 // Bit FRXTH.
	SPI_CR2_LDMA_RX_Pos = 0xd    // Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000 // Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX     = 0x2000 // Bit LDMA_RX.
	SPI_CR2_LDMA_TX_Pos = 0xe    // Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000 // Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX     = 0x4000 // Bit LDMA_TX.

	// SR: status register
	SPI_SR_RXNE_Pos   = 0x0    // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1    // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1    // Bit RXNE.
	SPI_SR_TXE_Pos    = 0x1    // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2    // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2    // Bit TXE.
	SPI_SR_CHSIDE_Pos = 0x2    // Position of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4    // Bit mask of CHSIDE field.
	SPI_SR_CHSIDE     = 0x4    // Bit CHSIDE.
	SPI_SR_UDR_Pos    = 0x3    // Position of UDR field.
	SPI_SR_UDR_Msk    = 0x8    // Bit mask of UDR field.
	SPI_SR_UDR        = 0x8    // Bit UDR.
	SPI_SR_CRCERR_Pos = 0x4    // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10   // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10   // Bit CRCERR.
	SPI_SR_MODF_Pos   = 0x5    // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20   // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20   // Bit MODF.
	SPI_SR_OVR_Pos    = 0x6    // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40   // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40   // Bit OVR.
	SPI_SR_BSY_Pos    = 0x7    // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80   // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80   // Bit BSY.
	SPI_SR_TIFRFE_Pos = 0x8    // Position of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100  // Bit mask of TIFRFE field.
	SPI_SR_TIFRFE     = 0x100  // Bit TIFRFE.
	SPI_SR_FRLVL_Pos  = 0x9    // Position of FRLVL field.
	SPI_SR_FRLVL_Msk  = 0x600  // Bit mask of FRLVL field.
	SPI_SR_FTLVL_Pos  = 0xb    // Position of FTLVL field.
	SPI_SR_FTLVL_Msk  = 0x1800 // Bit mask of FTLVL field.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.

	// I2SCFGR: configuration register
	SPI_I2SCFGR_CHLEN_Pos   = 0x0   // Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk   = 0x1   // Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN       = 0x1   // Bit CHLEN.
	SPI_I2SCFGR_DATLEN_Pos  = 0x1   // Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk  = 0x6   // Bit mask of DATLEN field.
	SPI_I2SCFGR_CKPOL_Pos   = 0x3   // Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk   = 0x8   // Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL       = 0x8   // Bit CKPOL.
	SPI_I2SCFGR_I2SSTD_Pos  = 0x4   // Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk  = 0x30  // Bit mask of I2SSTD field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7   // Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80  // Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC     = 0x80  // Bit PCMSYNC.
	SPI_I2SCFGR_I2SCFG_Pos  = 0x8   // Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk  = 0x300 // Bit mask of I2SCFG field.
	SPI_I2SCFGR_SE2_Pos     = 0xa   // Position of SE2 field.
	SPI_I2SCFGR_SE2_Msk     = 0x400 // Bit mask of SE2 field.
	SPI_I2SCFGR_SE2         = 0x400 // Bit SE2.
	SPI_I2SCFGR_I2SMOD_Pos  = 0xb   // Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk  = 0x800 // Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD      = 0x800 // Bit I2SMOD.

	// I2SPR: prescaler register
	SPI_I2SPR_I2SDIV_Pos = 0x0   // Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff  // Bit mask of I2SDIV field.
	SPI_I2SPR_ODD_Pos    = 0x8   // Position of ODD field.
	SPI_I2SPR_ODD_Msk    = 0x100 // Bit mask of ODD field.
	SPI_I2SPR_ODD        = 0x100 // Bit ODD.
	SPI_I2SPR_MCKOE_Pos  = 0x9   // Position of MCKOE field.
	SPI_I2SPR_MCKOE_Msk  = 0x200 // Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE      = 0x200 // Bit MCKOE.

	// HWCFGR: hardware configuration           register
	SPI_HWCFGR_CRCCFG_Pos   = 0x0     // Position of CRCCFG field.
	SPI_HWCFGR_CRCCFG_Msk   = 0xf     // Bit mask of CRCCFG field.
	SPI_HWCFGR_I2SCFG_Pos   = 0x4     // Position of I2SCFG field.
	SPI_HWCFGR_I2SCFG_Msk   = 0xf0    // Bit mask of I2SCFG field.
	SPI_HWCFGR_I2SCKCFG_Pos = 0x8     // Position of I2SCKCFG field.
	SPI_HWCFGR_I2SCKCFG_Msk = 0xf00   // Bit mask of I2SCKCFG field.
	SPI_HWCFGR_DSCFG_Pos    = 0xc     // Position of DSCFG field.
	SPI_HWCFGR_DSCFG_Msk    = 0xf000  // Bit mask of DSCFG field.
	SPI_HWCFGR_NSSCFG_Pos   = 0x10    // Position of NSSCFG field.
	SPI_HWCFGR_NSSCFG_Msk   = 0xf0000 // Bit mask of NSSCFG field.

	// VERR: EXTI IP Version register
	SPI_VERR_MINREV_Pos = 0x0  // Position of MINREV field.
	SPI_VERR_MINREV_Msk = 0xf  // Bit mask of MINREV field.
	SPI_VERR_MAJREV_Pos = 0x4  // Position of MAJREV field.
	SPI_VERR_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.

	// IPIDR: EXTI Identification register
	SPI_IPIDR_IPID_Pos = 0x0        // Position of IPID field.
	SPI_IPIDR_IPID_Msk = 0xffffffff // Bit mask of IPID field.

	// SIDR: EXTI Size ID register
	SPI_SIDR_SID_Pos = 0x0        // Position of SID field.
	SPI_SIDR_SID_Msk = 0xffffffff // Bit mask of SID field.
)

// Bitfields for ADC: Analog to Digital Converter instance 1
const (
	// ISR: ADC interrupt and status           register
	ADC_ISR_CCRDY_Pos = 0xd    // Position of CCRDY field.
	ADC_ISR_CCRDY_Msk = 0x2000 // Bit mask of CCRDY field.
	ADC_ISR_CCRDY     = 0x2000 // Bit CCRDY.
	ADC_ISR_EOCAL_Pos = 0xb    // Position of EOCAL field.
	ADC_ISR_EOCAL_Msk = 0x800  // Bit mask of EOCAL field.
	ADC_ISR_EOCAL     = 0x800  // Bit EOCAL.
	ADC_ISR_AWD3_Pos  = 0x9    // Position of AWD3 field.
	ADC_ISR_AWD3_Msk  = 0x200  // Bit mask of AWD3 field.
	ADC_ISR_AWD3      = 0x200  // Bit AWD3.
	ADC_ISR_AWD2_Pos  = 0x8    // Position of AWD2 field.
	ADC_ISR_AWD2_Msk  = 0x100  // Bit mask of AWD2 field.
	ADC_ISR_AWD2      = 0x100  // Bit AWD2.
	ADC_ISR_AWD1_Pos  = 0x7    // Position of AWD1 field.
	ADC_ISR_AWD1_Msk  = 0x80   // Bit mask of AWD1 field.
	ADC_ISR_AWD1      = 0x80   // Bit AWD1.
	ADC_ISR_OVR_Pos   = 0x4    // Position of OVR field.
	ADC_ISR_OVR_Msk   = 0x10   // Bit mask of OVR field.
	ADC_ISR_OVR       = 0x10   // Bit OVR.
	ADC_ISR_EOS_Pos   = 0x3    // Position of EOS field.
	ADC_ISR_EOS_Msk   = 0x8    // Bit mask of EOS field.
	ADC_ISR_EOS       = 0x8    // Bit EOS.
	ADC_ISR_EOC_Pos   = 0x2    // Position of EOC field.
	ADC_ISR_EOC_Msk   = 0x4    // Bit mask of EOC field.
	ADC_ISR_EOC       = 0x4    // Bit EOC.
	ADC_ISR_EOSMP_Pos = 0x1    // Position of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2    // Bit mask of EOSMP field.
	ADC_ISR_EOSMP     = 0x2    // Bit EOSMP.
	ADC_ISR_ADRDY_Pos = 0x0    // Position of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1    // Bit mask of ADRDY field.
	ADC_ISR_ADRDY     = 0x1    // Bit ADRDY.

	// IER: ADC interrupt enable register
	ADC_IER_CCRDYIE_Pos = 0xd    // Position of CCRDYIE field.
	ADC_IER_CCRDYIE_Msk = 0x2000 // Bit mask of CCRDYIE field.
	ADC_IER_CCRDYIE     = 0x2000 // Bit CCRDYIE.
	ADC_IER_EOCALIE_Pos = 0xb    // Position of EOCALIE field.
	ADC_IER_EOCALIE_Msk = 0x800  // Bit mask of EOCALIE field.
	ADC_IER_EOCALIE     = 0x800  // Bit EOCALIE.
	ADC_IER_AWD3IE_Pos  = 0x9    // Position of AWD3IE field.
	ADC_IER_AWD3IE_Msk  = 0x200  // Bit mask of AWD3IE field.
	ADC_IER_AWD3IE      = 0x200  // Bit AWD3IE.
	ADC_IER_AWD2IE_Pos  = 0x8    // Position of AWD2IE field.
	ADC_IER_AWD2IE_Msk  = 0x100  // Bit mask of AWD2IE field.
	ADC_IER_AWD2IE      = 0x100  // Bit AWD2IE.
	ADC_IER_AWD1IE_Pos  = 0x7    // Position of AWD1IE field.
	ADC_IER_AWD1IE_Msk  = 0x80   // Bit mask of AWD1IE field.
	ADC_IER_AWD1IE      = 0x80   // Bit AWD1IE.
	ADC_IER_OVRIE_Pos   = 0x4    // Position of OVRIE field.
	ADC_IER_OVRIE_Msk   = 0x10   // Bit mask of OVRIE field.
	ADC_IER_OVRIE       = 0x10   // Bit OVRIE.
	ADC_IER_EOSIE_Pos   = 0x3    // Position of EOSIE field.
	ADC_IER_EOSIE_Msk   = 0x8    // Bit mask of EOSIE field.
	ADC_IER_EOSIE       = 0x8    // Bit EOSIE.
	ADC_IER_EOCIE_Pos   = 0x2    // Position of EOCIE field.
	ADC_IER_EOCIE_Msk   = 0x4    // Bit mask of EOCIE field.
	ADC_IER_EOCIE       = 0x4    // Bit EOCIE.
	ADC_IER_EOSMPIE_Pos = 0x1    // Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2    // Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE     = 0x2    // Bit EOSMPIE.
	ADC_IER_ADRDYIE_Pos = 0x0    // Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1    // Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE     = 0x1    // Bit ADRDYIE.

	// CR: ADC control register
	ADC_CR_ADCAL_Pos    = 0x1f       // Position of ADCAL field.
	ADC_CR_ADCAL_Msk    = 0x80000000 // Bit mask of ADCAL field.
	ADC_CR_ADCAL        = 0x80000000 // Bit ADCAL.
	ADC_CR_ADVREGEN_Pos = 0x1c       // Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000 // Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN     = 0x10000000 // Bit ADVREGEN.
	ADC_CR_ADSTP_Pos    = 0x4        // Position of ADSTP field.
	ADC_CR_ADSTP_Msk    = 0x10       // Bit mask of ADSTP field.
	ADC_CR_ADSTP        = 0x10       // Bit ADSTP.
	ADC_CR_ADSTART_Pos  = 0x2        // Position of ADSTART field.
	ADC_CR_ADSTART_Msk  = 0x4        // Bit mask of ADSTART field.
	ADC_CR_ADSTART      = 0x4        // Bit ADSTART.
	ADC_CR_ADDIS_Pos    = 0x1        // Position of ADDIS field.
	ADC_CR_ADDIS_Msk    = 0x2        // Bit mask of ADDIS field.
	ADC_CR_ADDIS        = 0x2        // Bit ADDIS.
	ADC_CR_ADEN_Pos     = 0x0        // Position of ADEN field.
	ADC_CR_ADEN_Msk     = 0x1        // Bit mask of ADEN field.
	ADC_CR_ADEN         = 0x1        // Bit ADEN.

	// CFGR1: ADC configuration register 1
	ADC_CFGR1_AWDCH1CH_Pos  = 0x1a       // Position of AWDCH1CH field.
	ADC_CFGR1_AWDCH1CH_Msk  = 0x7c000000 // Bit mask of AWDCH1CH field.
	ADC_CFGR1_AWD1EN_Pos    = 0x17       // Position of AWD1EN field.
	ADC_CFGR1_AWD1EN_Msk    = 0x800000   // Bit mask of AWD1EN field.
	ADC_CFGR1_AWD1EN        = 0x800000   // Bit AWD1EN.
	ADC_CFGR1_AWD1SGL_Pos   = 0x16       // Position of AWD1SGL field.
	ADC_CFGR1_AWD1SGL_Msk   = 0x400000   // Bit mask of AWD1SGL field.
	ADC_CFGR1_AWD1SGL       = 0x400000   // Bit AWD1SGL.
	ADC_CFGR1_CHSELRMOD_Pos = 0x15       // Position of CHSELRMOD field.
	ADC_CFGR1_CHSELRMOD_Msk = 0x200000   // Bit mask of CHSELRMOD field.
	ADC_CFGR1_CHSELRMOD     = 0x200000   // Bit CHSELRMOD.
	ADC_CFGR1_DISCEN_Pos    = 0x10       // Position of DISCEN field.
	ADC_CFGR1_DISCEN_Msk    = 0x10000    // Bit mask of DISCEN field.
	ADC_CFGR1_DISCEN        = 0x10000    // Bit DISCEN.
	ADC_CFGR1_AUTOFF_Pos    = 0xf        // Position of AUTOFF field.
	ADC_CFGR1_AUTOFF_Msk    = 0x8000     // Bit mask of AUTOFF field.
	ADC_CFGR1_AUTOFF        = 0x8000     // Bit AUTOFF.
	ADC_CFGR1_WAIT_Pos      = 0xe        // Position of WAIT field.
	ADC_CFGR1_WAIT_Msk      = 0x4000     // Bit mask of WAIT field.
	ADC_CFGR1_WAIT          = 0x4000     // Bit WAIT.
	ADC_CFGR1_CONT_Pos      = 0xd        // Position of CONT field.
	ADC_CFGR1_CONT_Msk      = 0x2000     // Bit mask of CONT field.
	ADC_CFGR1_CONT          = 0x2000     // Bit CONT.
	ADC_CFGR1_OVRMOD_Pos    = 0xc        // Position of OVRMOD field.
	ADC_CFGR1_OVRMOD_Msk    = 0x1000     // Bit mask of OVRMOD field.
	ADC_CFGR1_OVRMOD        = 0x1000     // Bit OVRMOD.
	ADC_CFGR1_EXTEN_Pos     = 0xa        // Position of EXTEN field.
	ADC_CFGR1_EXTEN_Msk     = 0xc00      // Bit mask of EXTEN field.
	ADC_CFGR1_EXTSEL_Pos    = 0x6        // Position of EXTSEL field.
	ADC_CFGR1_EXTSEL_Msk    = 0x1c0      // Bit mask of EXTSEL field.
	ADC_CFGR1_ALIGN_Pos     = 0x5        // Position of ALIGN field.
	ADC_CFGR1_ALIGN_Msk     = 0x20       // Bit mask of ALIGN field.
	ADC_CFGR1_ALIGN         = 0x20       // Bit ALIGN.
	ADC_CFGR1_RES_Pos       = 0x3        // Position of RES field.
	ADC_CFGR1_RES_Msk       = 0x18       // Bit mask of RES field.
	ADC_CFGR1_SCANDIR_Pos   = 0x2        // Position of SCANDIR field.
	ADC_CFGR1_SCANDIR_Msk   = 0x4        // Bit mask of SCANDIR field.
	ADC_CFGR1_SCANDIR       = 0x4        // Bit SCANDIR.
	ADC_CFGR1_DMACFG_Pos    = 0x1        // Position of DMACFG field.
	ADC_CFGR1_DMACFG_Msk    = 0x2        // Bit mask of DMACFG field.
	ADC_CFGR1_DMACFG        = 0x2        // Bit DMACFG.
	ADC_CFGR1_DMAEN_Pos     = 0x0        // Position of DMAEN field.
	ADC_CFGR1_DMAEN_Msk     = 0x1        // Bit mask of DMAEN field.
	ADC_CFGR1_DMAEN         = 0x1        // Bit DMAEN.

	// CFGR2: ADC configuration register 2
	ADC_CFGR2_CKMODE_Pos = 0x1e       // Position of CKMODE field.
	ADC_CFGR2_CKMODE_Msk = 0xc0000000 // Bit mask of CKMODE field.
	ADC_CFGR2_LFTRIG_Pos = 0x1d       // Position of LFTRIG field.
	ADC_CFGR2_LFTRIG_Msk = 0x20000000 // Bit mask of LFTRIG field.
	ADC_CFGR2_LFTRIG     = 0x20000000 // Bit LFTRIG.
	ADC_CFGR2_TOVS_Pos   = 0x9        // Position of TOVS field.
	ADC_CFGR2_TOVS_Msk   = 0x200      // Bit mask of TOVS field.
	ADC_CFGR2_TOVS       = 0x200      // Bit TOVS.
	ADC_CFGR2_OVSS_Pos   = 0x5        // Position of OVSS field.
	ADC_CFGR2_OVSS_Msk   = 0x1e0      // Bit mask of OVSS field.
	ADC_CFGR2_OVSR_Pos   = 0x2        // Position of OVSR field.
	ADC_CFGR2_OVSR_Msk   = 0x1c       // Bit mask of OVSR field.
	ADC_CFGR2_OVSE_Pos   = 0x0        // Position of OVSE field.
	ADC_CFGR2_OVSE_Msk   = 0x1        // Bit mask of OVSE field.
	ADC_CFGR2_OVSE       = 0x1        // Bit OVSE.

	// SMPR: ADC sampling time register
	ADC_SMPR_SMP1_Pos   = 0x0       // Position of SMP1 field.
	ADC_SMPR_SMP1_Msk   = 0x7       // Bit mask of SMP1 field.
	ADC_SMPR_SMP2_Pos   = 0x4       // Position of SMP2 field.
	ADC_SMPR_SMP2_Msk   = 0x70      // Bit mask of SMP2 field.
	ADC_SMPR_SMPSEL_Pos = 0x8       // Position of SMPSEL field.
	ADC_SMPR_SMPSEL_Msk = 0x7ffff00 // Bit mask of SMPSEL field.

	// AWD1TR: watchdog threshold register
	ADC_AWD1TR_HT1_Pos = 0x10      // Position of HT1 field.
	ADC_AWD1TR_HT1_Msk = 0xfff0000 // Bit mask of HT1 field.
	ADC_AWD1TR_LT1_Pos = 0x0       // Position of LT1 field.
	ADC_AWD1TR_LT1_Msk = 0xfff     // Bit mask of LT1 field.

	// AWD2TR: watchdog threshold register
	ADC_AWD2TR_HT2_Pos = 0x10      // Position of HT2 field.
	ADC_AWD2TR_HT2_Msk = 0xfff0000 // Bit mask of HT2 field.
	ADC_AWD2TR_LT2_Pos = 0x0       // Position of LT2 field.
	ADC_AWD2TR_LT2_Msk = 0xfff     // Bit mask of LT2 field.

	// CHSELR: channel selection register
	ADC_CHSELR_CHSEL_Pos = 0x0     // Position of CHSEL field.
	ADC_CHSELR_CHSEL_Msk = 0x7ffff // Bit mask of CHSEL field.

	// CHSELR_1: channel selection register CHSELRMOD = 1 in           ADC_CFGR1
	ADC_CHSELR_1_SQ1_Pos = 0x0        // Position of SQ1 field.
	ADC_CHSELR_1_SQ1_Msk = 0xf        // Bit mask of SQ1 field.
	ADC_CHSELR_1_SQ2_Pos = 0x4        // Position of SQ2 field.
	ADC_CHSELR_1_SQ2_Msk = 0xf0       // Bit mask of SQ2 field.
	ADC_CHSELR_1_SQ3_Pos = 0x8        // Position of SQ3 field.
	ADC_CHSELR_1_SQ3_Msk = 0xf00      // Bit mask of SQ3 field.
	ADC_CHSELR_1_SQ4_Pos = 0xc        // Position of SQ4 field.
	ADC_CHSELR_1_SQ4_Msk = 0xf000     // Bit mask of SQ4 field.
	ADC_CHSELR_1_SQ5_Pos = 0x10       // Position of SQ5 field.
	ADC_CHSELR_1_SQ5_Msk = 0xf0000    // Bit mask of SQ5 field.
	ADC_CHSELR_1_SQ6_Pos = 0x14       // Position of SQ6 field.
	ADC_CHSELR_1_SQ6_Msk = 0xf00000   // Bit mask of SQ6 field.
	ADC_CHSELR_1_SQ7_Pos = 0x18       // Position of SQ7 field.
	ADC_CHSELR_1_SQ7_Msk = 0xf000000  // Bit mask of SQ7 field.
	ADC_CHSELR_1_SQ8_Pos = 0x1c       // Position of SQ8 field.
	ADC_CHSELR_1_SQ8_Msk = 0xf0000000 // Bit mask of SQ8 field.

	// AWD3TR: watchdog threshold register
	ADC_AWD3TR_HT3_Pos = 0x10      // Position of HT3 field.
	ADC_AWD3TR_HT3_Msk = 0xfff0000 // Bit mask of HT3 field.
	ADC_AWD3TR_LT3_Pos = 0x0       // Position of LT3 field.
	ADC_AWD3TR_LT3_Msk = 0xfff     // Bit mask of LT3 field.

	// DR: ADC group regular conversion data           register
	ADC_DR_REGULARDATA_Pos = 0x0    // Position of REGULARDATA field.
	ADC_DR_REGULARDATA_Msk = 0xffff // Bit mask of REGULARDATA field.

	// AWD2CR: ADC analog watchdog 2 configuration           register
	ADC_AWD2CR_AWD2CH_Pos = 0x0     // Position of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Msk = 0x7ffff // Bit mask of AWD2CH field.

	// AWD3CR: ADC analog watchdog 3 configuration           register
	ADC_AWD3CR_AWD3CH_Pos = 0x0     // Position of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Msk = 0x7ffff // Bit mask of AWD3CH field.

	// CALFACT: ADC calibration factors           register
	ADC_CALFACT_CALFACT_Pos = 0x0  // Position of CALFACT field.
	ADC_CALFACT_CALFACT_Msk = 0x7f // Bit mask of CALFACT field.

	// CCR: ADC common control register
	ADC_CCR_PRESC_Pos  = 0x12      // Position of PRESC field.
	ADC_CCR_PRESC_Msk  = 0x3c0000  // Bit mask of PRESC field.
	ADC_CCR_VREFEN_Pos = 0x16      // Position of VREFEN field.
	ADC_CCR_VREFEN_Msk = 0x400000  // Bit mask of VREFEN field.
	ADC_CCR_VREFEN     = 0x400000  // Bit VREFEN.
	ADC_CCR_TSEN_Pos   = 0x17      // Position of TSEN field.
	ADC_CCR_TSEN_Msk   = 0x800000  // Bit mask of TSEN field.
	ADC_CCR_TSEN       = 0x800000  // Bit TSEN.
	ADC_CCR_VBATEN_Pos = 0x18      // Position of VBATEN field.
	ADC_CCR_VBATEN_Msk = 0x1000000 // Bit mask of VBATEN field.
	ADC_CCR_VBATEN     = 0x1000000 // Bit VBATEN.

	// HWCFGR6: Hardware Configuration           Register
	ADC_HWCFGR6_CHMAP20_Pos = 0x0        // Position of CHMAP20 field.
	ADC_HWCFGR6_CHMAP20_Msk = 0x1f       // Bit mask of CHMAP20 field.
	ADC_HWCFGR6_CHMAP21_Pos = 0x8        // Position of CHMAP21 field.
	ADC_HWCFGR6_CHMAP21_Msk = 0x1f00     // Bit mask of CHMAP21 field.
	ADC_HWCFGR6_CHMAP22_Pos = 0x10       // Position of CHMAP22 field.
	ADC_HWCFGR6_CHMAP22_Msk = 0x1f0000   // Bit mask of CHMAP22 field.
	ADC_HWCFGR6_CHMAP23_Pos = 0x18       // Position of CHMAP23 field.
	ADC_HWCFGR6_CHMAP23_Msk = 0x1f000000 // Bit mask of CHMAP23 field.

	// HWCFGR5: Hardware Configuration           Register
	ADC_HWCFGR5_CHMAP19_Pos = 0x0        // Position of CHMAP19 field.
	ADC_HWCFGR5_CHMAP19_Msk = 0x1f       // Bit mask of CHMAP19 field.
	ADC_HWCFGR5_CHMAP18_Pos = 0x8        // Position of CHMAP18 field.
	ADC_HWCFGR5_CHMAP18_Msk = 0x1f00     // Bit mask of CHMAP18 field.
	ADC_HWCFGR5_CHMAP17_Pos = 0x10       // Position of CHMAP17 field.
	ADC_HWCFGR5_CHMAP17_Msk = 0x1f0000   // Bit mask of CHMAP17 field.
	ADC_HWCFGR5_CHMAP16_Pos = 0x18       // Position of CHMAP16 field.
	ADC_HWCFGR5_CHMAP16_Msk = 0x1f000000 // Bit mask of CHMAP16 field.

	// HWCFGR4: Hardware Configuration           Register
	ADC_HWCFGR4_CHMAP15_Pos = 0x0        // Position of CHMAP15 field.
	ADC_HWCFGR4_CHMAP15_Msk = 0x1f       // Bit mask of CHMAP15 field.
	ADC_HWCFGR4_CHMAP14_Pos = 0x8        // Position of CHMAP14 field.
	ADC_HWCFGR4_CHMAP14_Msk = 0x1f00     // Bit mask of CHMAP14 field.
	ADC_HWCFGR4_CHMAP13_Pos = 0x10       // Position of CHMAP13 field.
	ADC_HWCFGR4_CHMAP13_Msk = 0x1f0000   // Bit mask of CHMAP13 field.
	ADC_HWCFGR4_CHMAP12_Pos = 0x18       // Position of CHMAP12 field.
	ADC_HWCFGR4_CHMAP12_Msk = 0x1f000000 // Bit mask of CHMAP12 field.

	// HWCFGR3: Hardware Configuration           Register
	ADC_HWCFGR3_CHMAP11_Pos = 0x0        // Position of CHMAP11 field.
	ADC_HWCFGR3_CHMAP11_Msk = 0x1f       // Bit mask of CHMAP11 field.
	ADC_HWCFGR3_CHMAP10_Pos = 0x8        // Position of CHMAP10 field.
	ADC_HWCFGR3_CHMAP10_Msk = 0x1f00     // Bit mask of CHMAP10 field.
	ADC_HWCFGR3_CHMAP9_Pos  = 0x10       // Position of CHMAP9 field.
	ADC_HWCFGR3_CHMAP9_Msk  = 0x1f0000   // Bit mask of CHMAP9 field.
	ADC_HWCFGR3_CHMAP8_Pos  = 0x18       // Position of CHMAP8 field.
	ADC_HWCFGR3_CHMAP8_Msk  = 0x1f000000 // Bit mask of CHMAP8 field.

	// HWCFGR2: Hardware Configuration           Register
	ADC_HWCFGR2_CHMAP7_Pos = 0x0        // Position of CHMAP7 field.
	ADC_HWCFGR2_CHMAP7_Msk = 0x1f       // Bit mask of CHMAP7 field.
	ADC_HWCFGR2_CHMAP6_Pos = 0x8        // Position of CHMAP6 field.
	ADC_HWCFGR2_CHMAP6_Msk = 0x1f00     // Bit mask of CHMAP6 field.
	ADC_HWCFGR2_CHMAP5_Pos = 0x10       // Position of CHMAP5 field.
	ADC_HWCFGR2_CHMAP5_Msk = 0x1f0000   // Bit mask of CHMAP5 field.
	ADC_HWCFGR2_CHMAP4_Pos = 0x18       // Position of CHMAP4 field.
	ADC_HWCFGR2_CHMAP4_Msk = 0x1f000000 // Bit mask of CHMAP4 field.

	// HWCFGR1: Hardware Configuration           Register
	ADC_HWCFGR1_CHMAP3_Pos = 0x0        // Position of CHMAP3 field.
	ADC_HWCFGR1_CHMAP3_Msk = 0x1f       // Bit mask of CHMAP3 field.
	ADC_HWCFGR1_CHMAP2_Pos = 0x8        // Position of CHMAP2 field.
	ADC_HWCFGR1_CHMAP2_Msk = 0x1f00     // Bit mask of CHMAP2 field.
	ADC_HWCFGR1_CHMAP1_Pos = 0x10       // Position of CHMAP1 field.
	ADC_HWCFGR1_CHMAP1_Msk = 0x1f0000   // Bit mask of CHMAP1 field.
	ADC_HWCFGR1_CHMAP0_Pos = 0x18       // Position of CHMAP0 field.
	ADC_HWCFGR1_CHMAP0_Msk = 0x1f000000 // Bit mask of CHMAP0 field.

	// HWCFGR0: Hardware Configuration           Register
	ADC_HWCFGR0_NUM_CHAN_24_Pos = 0x0   // Position of NUM_CHAN_24 field.
	ADC_HWCFGR0_NUM_CHAN_24_Msk = 0xf   // Bit mask of NUM_CHAN_24 field.
	ADC_HWCFGR0_EXTRA_AWDS_Pos  = 0x4   // Position of EXTRA_AWDS field.
	ADC_HWCFGR0_EXTRA_AWDS_Msk  = 0xf0  // Bit mask of EXTRA_AWDS field.
	ADC_HWCFGR0_OVS_Pos         = 0x8   // Position of OVS field.
	ADC_HWCFGR0_OVS_Msk         = 0xf00 // Bit mask of OVS field.

	// VERR: EXTI IP Version register
	ADC_VERR_MINREV_Pos = 0x0  // Position of MINREV field.
	ADC_VERR_MINREV_Msk = 0xf  // Bit mask of MINREV field.
	ADC_VERR_MAJREV_Pos = 0x4  // Position of MAJREV field.
	ADC_VERR_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.

	// IPIDR: EXTI Identification register
	ADC_IPIDR_IPID_Pos = 0x0        // Position of IPID field.
	ADC_IPIDR_IPID_Msk = 0xffffffff // Bit mask of IPID field.

	// SIDR: EXTI Size ID register
	ADC_SIDR_SID_Pos = 0x0        // Position of SID field.
	ADC_SIDR_SID_Msk = 0xffffffff // Bit mask of SID field.
)

// Bitfields for COMP: COMP1
const (
	// COMP1_CSR: Comparator 1 control and status           register
	COMP1_COMP1_CSR_EN_Pos       = 0x0        // Position of EN field.
	COMP1_COMP1_CSR_EN_Msk       = 0x1        // Bit mask of EN field.
	COMP1_COMP1_CSR_EN           = 0x1        // Bit EN.
	COMP1_COMP1_CSR_INMSEL_Pos   = 0x4        // Position of INMSEL field.
	COMP1_COMP1_CSR_INMSEL_Msk   = 0xf0       // Bit mask of INMSEL field.
	COMP1_COMP1_CSR_INPSEL_Pos   = 0x8        // Position of INPSEL field.
	COMP1_COMP1_CSR_INPSEL_Msk   = 0x300      // Bit mask of INPSEL field.
	COMP1_COMP1_CSR_WINMODE_Pos  = 0xb        // Position of WINMODE field.
	COMP1_COMP1_CSR_WINMODE_Msk  = 0x800      // Bit mask of WINMODE field.
	COMP1_COMP1_CSR_WINMODE      = 0x800      // Bit WINMODE.
	COMP1_COMP1_CSR_WINOUT_Pos   = 0xe        // Position of WINOUT field.
	COMP1_COMP1_CSR_WINOUT_Msk   = 0x4000     // Bit mask of WINOUT field.
	COMP1_COMP1_CSR_WINOUT       = 0x4000     // Bit WINOUT.
	COMP1_COMP1_CSR_POLARITY_Pos = 0xf        // Position of POLARITY field.
	COMP1_COMP1_CSR_POLARITY_Msk = 0x8000     // Bit mask of POLARITY field.
	COMP1_COMP1_CSR_POLARITY     = 0x8000     // Bit POLARITY.
	COMP1_COMP1_CSR_HYST_Pos     = 0x10       // Position of HYST field.
	COMP1_COMP1_CSR_HYST_Msk     = 0x30000    // Bit mask of HYST field.
	COMP1_COMP1_CSR_PWRMODE_Pos  = 0x12       // Position of PWRMODE field.
	COMP1_COMP1_CSR_PWRMODE_Msk  = 0xc0000    // Bit mask of PWRMODE field.
	COMP1_COMP1_CSR_BLANKSEL_Pos = 0x14       // Position of BLANKSEL field.
	COMP1_COMP1_CSR_BLANKSEL_Msk = 0x1f00000  // Bit mask of BLANKSEL field.
	COMP1_COMP1_CSR_VALUE_Pos    = 0x1e       // Position of VALUE field.
	COMP1_COMP1_CSR_VALUE_Msk    = 0x40000000 // Bit mask of VALUE field.
	COMP1_COMP1_CSR_VALUE        = 0x40000000 // Bit VALUE.
	COMP1_COMP1_CSR_LOCK_Pos     = 0x1f       // Position of LOCK field.
	COMP1_COMP1_CSR_LOCK_Msk     = 0x80000000 // Bit mask of LOCK field.
	COMP1_COMP1_CSR_LOCK         = 0x80000000 // Bit LOCK.

	// COMP2_CSR: Comparator 2 control and status           register
	COMP1_COMP2_CSR_EN_Pos       = 0x0        // Position of EN field.
	COMP1_COMP2_CSR_EN_Msk       = 0x1        // Bit mask of EN field.
	COMP1_COMP2_CSR_EN           = 0x1        // Bit EN.
	COMP1_COMP2_CSR_INMSEL_Pos   = 0x4        // Position of INMSEL field.
	COMP1_COMP2_CSR_INMSEL_Msk   = 0xf0       // Bit mask of INMSEL field.
	COMP1_COMP2_CSR_INPSEL_Pos   = 0x8        // Position of INPSEL field.
	COMP1_COMP2_CSR_INPSEL_Msk   = 0x300      // Bit mask of INPSEL field.
	COMP1_COMP2_CSR_WINMODE_Pos  = 0xb        // Position of WINMODE field.
	COMP1_COMP2_CSR_WINMODE_Msk  = 0x800      // Bit mask of WINMODE field.
	COMP1_COMP2_CSR_WINMODE      = 0x800      // Bit WINMODE.
	COMP1_COMP2_CSR_WINOUT_Pos   = 0xe        // Position of WINOUT field.
	COMP1_COMP2_CSR_WINOUT_Msk   = 0x4000     // Bit mask of WINOUT field.
	COMP1_COMP2_CSR_WINOUT       = 0x4000     // Bit WINOUT.
	COMP1_COMP2_CSR_POLARITY_Pos = 0xf        // Position of POLARITY field.
	COMP1_COMP2_CSR_POLARITY_Msk = 0x8000     // Bit mask of POLARITY field.
	COMP1_COMP2_CSR_POLARITY     = 0x8000     // Bit POLARITY.
	COMP1_COMP2_CSR_HYST_Pos     = 0x10       // Position of HYST field.
	COMP1_COMP2_CSR_HYST_Msk     = 0x30000    // Bit mask of HYST field.
	COMP1_COMP2_CSR_PWRMODE_Pos  = 0x12       // Position of PWRMODE field.
	COMP1_COMP2_CSR_PWRMODE_Msk  = 0xc0000    // Bit mask of PWRMODE field.
	COMP1_COMP2_CSR_BLANKSEL_Pos = 0x14       // Position of BLANKSEL field.
	COMP1_COMP2_CSR_BLANKSEL_Msk = 0x1f00000  // Bit mask of BLANKSEL field.
	COMP1_COMP2_CSR_VALUE_Pos    = 0x1e       // Position of VALUE field.
	COMP1_COMP2_CSR_VALUE_Msk    = 0x40000000 // Bit mask of VALUE field.
	COMP1_COMP2_CSR_VALUE        = 0x40000000 // Bit VALUE.
	COMP1_COMP2_CSR_LOCK_Pos     = 0x1f       // Position of LOCK field.
	COMP1_COMP2_CSR_LOCK_Msk     = 0x80000000 // Bit mask of LOCK field.
	COMP1_COMP2_CSR_LOCK         = 0x80000000 // Bit LOCK.
)

// Bitfields for SYSCFG_VREFBUF: System configuration controller
const (
	// CFGR1: SYSCFG configuration register           1
	SYSCFG_CFGR1_I2C_PAx_FMP_Pos   = 0x16     // Position of I2C_PAx_FMP field.
	SYSCFG_CFGR1_I2C_PAx_FMP_Msk   = 0xc00000 // Bit mask of I2C_PAx_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Pos      = 0x15     // Position of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Msk      = 0x200000 // Bit mask of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP          = 0x200000 // Bit I2C2_FMP.
	SYSCFG_CFGR1_I2C1_FMP_Pos      = 0x14     // Position of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Msk      = 0x100000 // Bit mask of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP          = 0x100000 // Bit I2C1_FMP.
	SYSCFG_CFGR1_I2C_PBx_FMP_Pos   = 0x10     // Position of I2C_PBx_FMP field.
	SYSCFG_CFGR1_I2C_PBx_FMP_Msk   = 0xf0000  // Bit mask of I2C_PBx_FMP field.
	SYSCFG_CFGR1_UCPD2_STROBE_Pos  = 0xa      // Position of UCPD2_STROBE field.
	SYSCFG_CFGR1_UCPD2_STROBE_Msk  = 0x400    // Bit mask of UCPD2_STROBE field.
	SYSCFG_CFGR1_UCPD2_STROBE      = 0x400    // Bit UCPD2_STROBE.
	SYSCFG_CFGR1_UCPD1_STROBE_Pos  = 0x9      // Position of UCPD1_STROBE field.
	SYSCFG_CFGR1_UCPD1_STROBE_Msk  = 0x200    // Bit mask of UCPD1_STROBE field.
	SYSCFG_CFGR1_UCPD1_STROBE      = 0x200    // Bit UCPD1_STROBE.
	SYSCFG_CFGR1_BOOSTEN_Pos       = 0x8      // Position of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Msk       = 0x100    // Bit mask of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN           = 0x100    // Bit BOOSTEN.
	SYSCFG_CFGR1_IR_MOD_Pos        = 0x6      // Position of IR_MOD field.
	SYSCFG_CFGR1_IR_MOD_Msk        = 0xc0     // Bit mask of IR_MOD field.
	SYSCFG_CFGR1_IR_POL_Pos        = 0x5      // Position of IR_POL field.
	SYSCFG_CFGR1_IR_POL_Msk        = 0x20     // Bit mask of IR_POL field.
	SYSCFG_CFGR1_IR_POL            = 0x20     // Bit IR_POL.
	SYSCFG_CFGR1_PA11_PA12_RMP_Pos = 0x4      // Position of PA11_PA12_RMP field.
	SYSCFG_CFGR1_PA11_PA12_RMP_Msk = 0x10     // Bit mask of PA11_PA12_RMP field.
	SYSCFG_CFGR1_PA11_PA12_RMP     = 0x10     // Bit PA11_PA12_RMP.
	SYSCFG_CFGR1_MEM_MODE_Pos      = 0x0      // Position of MEM_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Msk      = 0x3      // Bit mask of MEM_MODE field.

	// CFGR2: SYSCFG configuration register           1
	SYSCFG_CFGR2_LOCKUP_LOCK_Pos      = 0x0   // Position of LOCKUP_LOCK field.
	SYSCFG_CFGR2_LOCKUP_LOCK_Msk      = 0x1   // Bit mask of LOCKUP_LOCK field.
	SYSCFG_CFGR2_LOCKUP_LOCK          = 0x1   // Bit LOCKUP_LOCK.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Pos = 0x1   // Position of SRAM_PARITY_LOCK field.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Msk = 0x2   // Bit mask of SRAM_PARITY_LOCK field.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK     = 0x2   // Bit SRAM_PARITY_LOCK.
	SYSCFG_CFGR2_PVD_LOCK_Pos         = 0x2   // Position of PVD_LOCK field.
	SYSCFG_CFGR2_PVD_LOCK_Msk         = 0x4   // Bit mask of PVD_LOCK field.
	SYSCFG_CFGR2_PVD_LOCK             = 0x4   // Bit PVD_LOCK.
	SYSCFG_CFGR2_ECC_LOCK_Pos         = 0x3   // Position of ECC_LOCK field.
	SYSCFG_CFGR2_ECC_LOCK_Msk         = 0x8   // Bit mask of ECC_LOCK field.
	SYSCFG_CFGR2_ECC_LOCK             = 0x8   // Bit ECC_LOCK.
	SYSCFG_CFGR2_SRAM_PEF_Pos         = 0x8   // Position of SRAM_PEF field.
	SYSCFG_CFGR2_SRAM_PEF_Msk         = 0x100 // Bit mask of SRAM_PEF field.
	SYSCFG_CFGR2_SRAM_PEF             = 0x100 // Bit SRAM_PEF.

	// VREFBUF_CSR: VREFBUF control and status           register
	SYSCFG_VREFBUF_CSR_ENVR_Pos = 0x0  // Position of ENVR field.
	SYSCFG_VREFBUF_CSR_ENVR_Msk = 0x1  // Bit mask of ENVR field.
	SYSCFG_VREFBUF_CSR_ENVR     = 0x1  // Bit ENVR.
	SYSCFG_VREFBUF_CSR_HIZ_Pos  = 0x1  // Position of HIZ field.
	SYSCFG_VREFBUF_CSR_HIZ_Msk  = 0x2  // Bit mask of HIZ field.
	SYSCFG_VREFBUF_CSR_HIZ      = 0x2  // Bit HIZ.
	SYSCFG_VREFBUF_CSR_VRR_Pos  = 0x3  // Position of VRR field.
	SYSCFG_VREFBUF_CSR_VRR_Msk  = 0x8  // Bit mask of VRR field.
	SYSCFG_VREFBUF_CSR_VRR      = 0x8  // Bit VRR.
	SYSCFG_VREFBUF_CSR_VRS_Pos  = 0x4  // Position of VRS field.
	SYSCFG_VREFBUF_CSR_VRS_Msk  = 0x70 // Bit mask of VRS field.

	// VREFBUF_CCR: VREFBUF calibration control           register
	SYSCFG_VREFBUF_CCR_TRIM_Pos = 0x0  // Position of TRIM field.
	SYSCFG_VREFBUF_CCR_TRIM_Msk = 0x3f // Bit mask of TRIM field.

	// ITLINE0: interrupt line 0 status           register
	SYSCFG_ITLINE0_WWDG_Pos = 0x0 // Position of WWDG field.
	SYSCFG_ITLINE0_WWDG_Msk = 0x1 // Bit mask of WWDG field.
	SYSCFG_ITLINE0_WWDG     = 0x1 // Bit WWDG.

	// ITLINE1: interrupt line 1 status           register
	SYSCFG_ITLINE1_PVDOUT_Pos = 0x0 // Position of PVDOUT field.
	SYSCFG_ITLINE1_PVDOUT_Msk = 0x1 // Bit mask of PVDOUT field.
	SYSCFG_ITLINE1_PVDOUT     = 0x1 // Bit PVDOUT.

	// ITLINE2: interrupt line 2 status           register
	SYSCFG_ITLINE2_TAMP_Pos = 0x0 // Position of TAMP field.
	SYSCFG_ITLINE2_TAMP_Msk = 0x1 // Bit mask of TAMP field.
	SYSCFG_ITLINE2_TAMP     = 0x1 // Bit TAMP.
	SYSCFG_ITLINE2_RTC_Pos  = 0x1 // Position of RTC field.
	SYSCFG_ITLINE2_RTC_Msk  = 0x2 // Bit mask of RTC field.
	SYSCFG_ITLINE2_RTC      = 0x2 // Bit RTC.

	// ITLINE3: interrupt line 3 status           register
	SYSCFG_ITLINE3_FLASH_ITF_Pos = 0x0 // Position of FLASH_ITF field.
	SYSCFG_ITLINE3_FLASH_ITF_Msk = 0x1 // Bit mask of FLASH_ITF field.
	SYSCFG_ITLINE3_FLASH_ITF     = 0x1 // Bit FLASH_ITF.
	SYSCFG_ITLINE3_FLASH_ECC_Pos = 0x1 // Position of FLASH_ECC field.
	SYSCFG_ITLINE3_FLASH_ECC_Msk = 0x2 // Bit mask of FLASH_ECC field.
	SYSCFG_ITLINE3_FLASH_ECC     = 0x2 // Bit FLASH_ECC.

	// ITLINE4: interrupt line 4 status           register
	SYSCFG_ITLINE4_RCC_Pos = 0x0 // Position of RCC field.
	SYSCFG_ITLINE4_RCC_Msk = 0x1 // Bit mask of RCC field.
	SYSCFG_ITLINE4_RCC     = 0x1 // Bit RCC.

	// ITLINE5: interrupt line 5 status           register
	SYSCFG_ITLINE5_EXTI0_Pos = 0x0 // Position of EXTI0 field.
	SYSCFG_ITLINE5_EXTI0_Msk = 0x1 // Bit mask of EXTI0 field.
	SYSCFG_ITLINE5_EXTI0     = 0x1 // Bit EXTI0.
	SYSCFG_ITLINE5_EXTI1_Pos = 0x1 // Position of EXTI1 field.
	SYSCFG_ITLINE5_EXTI1_Msk = 0x2 // Bit mask of EXTI1 field.
	SYSCFG_ITLINE5_EXTI1     = 0x2 // Bit EXTI1.

	// ITLINE6: interrupt line 6 status           register
	SYSCFG_ITLINE6_EXTI2_Pos = 0x0 // Position of EXTI2 field.
	SYSCFG_ITLINE6_EXTI2_Msk = 0x1 // Bit mask of EXTI2 field.
	SYSCFG_ITLINE6_EXTI2     = 0x1 // Bit EXTI2.
	SYSCFG_ITLINE6_EXTI3_Pos = 0x1 // Position of EXTI3 field.
	SYSCFG_ITLINE6_EXTI3_Msk = 0x2 // Bit mask of EXTI3 field.
	SYSCFG_ITLINE6_EXTI3     = 0x2 // Bit EXTI3.

	// ITLINE7: interrupt line 7 status           register
	SYSCFG_ITLINE7_EXTI4_Pos  = 0x0   // Position of EXTI4 field.
	SYSCFG_ITLINE7_EXTI4_Msk  = 0x1   // Bit mask of EXTI4 field.
	SYSCFG_ITLINE7_EXTI4      = 0x1   // Bit EXTI4.
	SYSCFG_ITLINE7_EXTI5_Pos  = 0x1   // Position of EXTI5 field.
	SYSCFG_ITLINE7_EXTI5_Msk  = 0x2   // Bit mask of EXTI5 field.
	SYSCFG_ITLINE7_EXTI5      = 0x2   // Bit EXTI5.
	SYSCFG_ITLINE7_EXTI6_Pos  = 0x2   // Position of EXTI6 field.
	SYSCFG_ITLINE7_EXTI6_Msk  = 0x4   // Bit mask of EXTI6 field.
	SYSCFG_ITLINE7_EXTI6      = 0x4   // Bit EXTI6.
	SYSCFG_ITLINE7_EXTI7_Pos  = 0x3   // Position of EXTI7 field.
	SYSCFG_ITLINE7_EXTI7_Msk  = 0x8   // Bit mask of EXTI7 field.
	SYSCFG_ITLINE7_EXTI7      = 0x8   // Bit EXTI7.
	SYSCFG_ITLINE7_EXTI8_Pos  = 0x4   // Position of EXTI8 field.
	SYSCFG_ITLINE7_EXTI8_Msk  = 0x10  // Bit mask of EXTI8 field.
	SYSCFG_ITLINE7_EXTI8      = 0x10  // Bit EXTI8.
	SYSCFG_ITLINE7_EXTI9_Pos  = 0x5   // Position of EXTI9 field.
	SYSCFG_ITLINE7_EXTI9_Msk  = 0x20  // Bit mask of EXTI9 field.
	SYSCFG_ITLINE7_EXTI9      = 0x20  // Bit EXTI9.
	SYSCFG_ITLINE7_EXTI10_Pos = 0x6   // Position of EXTI10 field.
	SYSCFG_ITLINE7_EXTI10_Msk = 0x40  // Bit mask of EXTI10 field.
	SYSCFG_ITLINE7_EXTI10     = 0x40  // Bit EXTI10.
	SYSCFG_ITLINE7_EXTI11_Pos = 0x7   // Position of EXTI11 field.
	SYSCFG_ITLINE7_EXTI11_Msk = 0x80  // Bit mask of EXTI11 field.
	SYSCFG_ITLINE7_EXTI11     = 0x80  // Bit EXTI11.
	SYSCFG_ITLINE7_EXTI12_Pos = 0x8   // Position of EXTI12 field.
	SYSCFG_ITLINE7_EXTI12_Msk = 0x100 // Bit mask of EXTI12 field.
	SYSCFG_ITLINE7_EXTI12     = 0x100 // Bit EXTI12.
	SYSCFG_ITLINE7_EXTI13_Pos = 0x9   // Position of EXTI13 field.
	SYSCFG_ITLINE7_EXTI13_Msk = 0x200 // Bit mask of EXTI13 field.
	SYSCFG_ITLINE7_EXTI13     = 0x200 // Bit EXTI13.
	SYSCFG_ITLINE7_EXTI14_Pos = 0xa   // Position of EXTI14 field.
	SYSCFG_ITLINE7_EXTI14_Msk = 0x400 // Bit mask of EXTI14 field.
	SYSCFG_ITLINE7_EXTI14     = 0x400 // Bit EXTI14.
	SYSCFG_ITLINE7_EXTI15_Pos = 0xb   // Position of EXTI15 field.
	SYSCFG_ITLINE7_EXTI15_Msk = 0x800 // Bit mask of EXTI15 field.
	SYSCFG_ITLINE7_EXTI15     = 0x800 // Bit EXTI15.

	// ITLINE8: interrupt line 8 status           register
	SYSCFG_ITLINE8_UCPD1_Pos = 0x0 // Position of UCPD1 field.
	SYSCFG_ITLINE8_UCPD1_Msk = 0x1 // Bit mask of UCPD1 field.
	SYSCFG_ITLINE8_UCPD1     = 0x1 // Bit UCPD1.
	SYSCFG_ITLINE8_UCPD2_Pos = 0x1 // Position of UCPD2 field.
	SYSCFG_ITLINE8_UCPD2_Msk = 0x2 // Bit mask of UCPD2 field.
	SYSCFG_ITLINE8_UCPD2     = 0x2 // Bit UCPD2.

	// ITLINE9: interrupt line 9 status           register
	SYSCFG_ITLINE9_DMA1_CH1_Pos = 0x0 // Position of DMA1_CH1 field.
	SYSCFG_ITLINE9_DMA1_CH1_Msk = 0x1 // Bit mask of DMA1_CH1 field.
	SYSCFG_ITLINE9_DMA1_CH1     = 0x1 // Bit DMA1_CH1.

	// ITLINE10: interrupt line 10 status           register
	SYSCFG_ITLINE10_DMA1_CH2_Pos = 0x0 // Position of DMA1_CH2 field.
	SYSCFG_ITLINE10_DMA1_CH2_Msk = 0x1 // Bit mask of DMA1_CH2 field.
	SYSCFG_ITLINE10_DMA1_CH2     = 0x1 // Bit DMA1_CH2.
	SYSCFG_ITLINE10_DMA1_CH3_Pos = 0x1 // Position of DMA1_CH3 field.
	SYSCFG_ITLINE10_DMA1_CH3_Msk = 0x2 // Bit mask of DMA1_CH3 field.
	SYSCFG_ITLINE10_DMA1_CH3     = 0x2 // Bit DMA1_CH3.

	// ITLINE11: interrupt line 11 status           register
	SYSCFG_ITLINE11_DMAMUX_Pos   = 0x0  // Position of DMAMUX field.
	SYSCFG_ITLINE11_DMAMUX_Msk   = 0x1  // Bit mask of DMAMUX field.
	SYSCFG_ITLINE11_DMAMUX       = 0x1  // Bit DMAMUX.
	SYSCFG_ITLINE11_DMA1_CH4_Pos = 0x1  // Position of DMA1_CH4 field.
	SYSCFG_ITLINE11_DMA1_CH4_Msk = 0x2  // Bit mask of DMA1_CH4 field.
	SYSCFG_ITLINE11_DMA1_CH4     = 0x2  // Bit DMA1_CH4.
	SYSCFG_ITLINE11_DMA1_CH5_Pos = 0x2  // Position of DMA1_CH5 field.
	SYSCFG_ITLINE11_DMA1_CH5_Msk = 0x4  // Bit mask of DMA1_CH5 field.
	SYSCFG_ITLINE11_DMA1_CH5     = 0x4  // Bit DMA1_CH5.
	SYSCFG_ITLINE11_DMA1_CH6_Pos = 0x3  // Position of DMA1_CH6 field.
	SYSCFG_ITLINE11_DMA1_CH6_Msk = 0x8  // Bit mask of DMA1_CH6 field.
	SYSCFG_ITLINE11_DMA1_CH6     = 0x8  // Bit DMA1_CH6.
	SYSCFG_ITLINE11_DMA1_CH7_Pos = 0x4  // Position of DMA1_CH7 field.
	SYSCFG_ITLINE11_DMA1_CH7_Msk = 0x10 // Bit mask of DMA1_CH7 field.
	SYSCFG_ITLINE11_DMA1_CH7     = 0x10 // Bit DMA1_CH7.

	// ITLINE12: interrupt line 12 status           register
	SYSCFG_ITLINE12_ADC_Pos   = 0x0 // Position of ADC field.
	SYSCFG_ITLINE12_ADC_Msk   = 0x1 // Bit mask of ADC field.
	SYSCFG_ITLINE12_ADC       = 0x1 // Bit ADC.
	SYSCFG_ITLINE12_COMP1_Pos = 0x1 // Position of COMP1 field.
	SYSCFG_ITLINE12_COMP1_Msk = 0x2 // Bit mask of COMP1 field.
	SYSCFG_ITLINE12_COMP1     = 0x2 // Bit COMP1.
	SYSCFG_ITLINE12_COMP2_Pos = 0x2 // Position of COMP2 field.
	SYSCFG_ITLINE12_COMP2_Msk = 0x4 // Bit mask of COMP2 field.
	SYSCFG_ITLINE12_COMP2     = 0x4 // Bit COMP2.

	// ITLINE13: interrupt line 13 status           register
	SYSCFG_ITLINE13_TIM1_CCU_Pos = 0x0 // Position of TIM1_CCU field.
	SYSCFG_ITLINE13_TIM1_CCU_Msk = 0x1 // Bit mask of TIM1_CCU field.
	SYSCFG_ITLINE13_TIM1_CCU     = 0x1 // Bit TIM1_CCU.
	SYSCFG_ITLINE13_TIM1_TRG_Pos = 0x1 // Position of TIM1_TRG field.
	SYSCFG_ITLINE13_TIM1_TRG_Msk = 0x2 // Bit mask of TIM1_TRG field.
	SYSCFG_ITLINE13_TIM1_TRG     = 0x2 // Bit TIM1_TRG.
	SYSCFG_ITLINE13_TIM1_UPD_Pos = 0x2 // Position of TIM1_UPD field.
	SYSCFG_ITLINE13_TIM1_UPD_Msk = 0x4 // Bit mask of TIM1_UPD field.
	SYSCFG_ITLINE13_TIM1_UPD     = 0x4 // Bit TIM1_UPD.
	SYSCFG_ITLINE13_TIM1_BRK_Pos = 0x3 // Position of TIM1_BRK field.
	SYSCFG_ITLINE13_TIM1_BRK_Msk = 0x8 // Bit mask of TIM1_BRK field.
	SYSCFG_ITLINE13_TIM1_BRK     = 0x8 // Bit TIM1_BRK.

	// ITLINE14: interrupt line 14 status           register
	SYSCFG_ITLINE14_TIM1_CC_Pos = 0x0 // Position of TIM1_CC field.
	SYSCFG_ITLINE14_TIM1_CC_Msk = 0x1 // Bit mask of TIM1_CC field.
	SYSCFG_ITLINE14_TIM1_CC     = 0x1 // Bit TIM1_CC.

	// ITLINE15: interrupt line 15 status           register
	SYSCFG_ITLINE15_TIM2_Pos = 0x0 // Position of TIM2 field.
	SYSCFG_ITLINE15_TIM2_Msk = 0x1 // Bit mask of TIM2 field.
	SYSCFG_ITLINE15_TIM2     = 0x1 // Bit TIM2.

	// ITLINE16: interrupt line 16 status           register
	SYSCFG_ITLINE16_TIM3_Pos = 0x0 // Position of TIM3 field.
	SYSCFG_ITLINE16_TIM3_Msk = 0x1 // Bit mask of TIM3 field.
	SYSCFG_ITLINE16_TIM3     = 0x1 // Bit TIM3.

	// ITLINE17: interrupt line 17 status           register
	SYSCFG_ITLINE17_TIM6_Pos   = 0x0 // Position of TIM6 field.
	SYSCFG_ITLINE17_TIM6_Msk   = 0x1 // Bit mask of TIM6 field.
	SYSCFG_ITLINE17_TIM6       = 0x1 // Bit TIM6.
	SYSCFG_ITLINE17_DAC_Pos    = 0x1 // Position of DAC field.
	SYSCFG_ITLINE17_DAC_Msk    = 0x2 // Bit mask of DAC field.
	SYSCFG_ITLINE17_DAC        = 0x2 // Bit DAC.
	SYSCFG_ITLINE17_LPTIM1_Pos = 0x2 // Position of LPTIM1 field.
	SYSCFG_ITLINE17_LPTIM1_Msk = 0x4 // Bit mask of LPTIM1 field.
	SYSCFG_ITLINE17_LPTIM1     = 0x4 // Bit LPTIM1.

	// ITLINE18: interrupt line 18 status           register
	SYSCFG_ITLINE18_TIM7_Pos   = 0x0 // Position of TIM7 field.
	SYSCFG_ITLINE18_TIM7_Msk   = 0x1 // Bit mask of TIM7 field.
	SYSCFG_ITLINE18_TIM7       = 0x1 // Bit TIM7.
	SYSCFG_ITLINE18_LPTIM2_Pos = 0x1 // Position of LPTIM2 field.
	SYSCFG_ITLINE18_LPTIM2_Msk = 0x2 // Bit mask of LPTIM2 field.
	SYSCFG_ITLINE18_LPTIM2     = 0x2 // Bit LPTIM2.

	// ITLINE19: interrupt line 19 status           register
	SYSCFG_ITLINE19_TIM14_Pos = 0x0 // Position of TIM14 field.
	SYSCFG_ITLINE19_TIM14_Msk = 0x1 // Bit mask of TIM14 field.
	SYSCFG_ITLINE19_TIM14     = 0x1 // Bit TIM14.

	// ITLINE20: interrupt line 20 status           register
	SYSCFG_ITLINE20_TIM15_Pos = 0x0 // Position of TIM15 field.
	SYSCFG_ITLINE20_TIM15_Msk = 0x1 // Bit mask of TIM15 field.
	SYSCFG_ITLINE20_TIM15     = 0x1 // Bit TIM15.

	// ITLINE21: interrupt line 21 status           register
	SYSCFG_ITLINE21_TIM16_Pos = 0x0 // Position of TIM16 field.
	SYSCFG_ITLINE21_TIM16_Msk = 0x1 // Bit mask of TIM16 field.
	SYSCFG_ITLINE21_TIM16     = 0x1 // Bit TIM16.

	// ITLINE22: interrupt line 22 status           register
	SYSCFG_ITLINE22_TIM17_Pos = 0x0 // Position of TIM17 field.
	SYSCFG_ITLINE22_TIM17_Msk = 0x1 // Bit mask of TIM17 field.
	SYSCFG_ITLINE22_TIM17     = 0x1 // Bit TIM17.

	// ITLINE23: interrupt line 23 status           register
	SYSCFG_ITLINE23_I2C1_Pos = 0x0 // Position of I2C1 field.
	SYSCFG_ITLINE23_I2C1_Msk = 0x1 // Bit mask of I2C1 field.
	SYSCFG_ITLINE23_I2C1     = 0x1 // Bit I2C1.

	// ITLINE24: interrupt line 24 status           register
	SYSCFG_ITLINE24_I2C2_Pos = 0x0 // Position of I2C2 field.
	SYSCFG_ITLINE24_I2C2_Msk = 0x1 // Bit mask of I2C2 field.
	SYSCFG_ITLINE24_I2C2     = 0x1 // Bit I2C2.

	// ITLINE25: interrupt line 25 status           register
	SYSCFG_ITLINE25_SPI1_Pos = 0x0 // Position of SPI1 field.
	SYSCFG_ITLINE25_SPI1_Msk = 0x1 // Bit mask of SPI1 field.
	SYSCFG_ITLINE25_SPI1     = 0x1 // Bit SPI1.

	// ITLINE26: interrupt line 26 status           register
	SYSCFG_ITLINE26_SPI2_Pos = 0x0 // Position of SPI2 field.
	SYSCFG_ITLINE26_SPI2_Msk = 0x1 // Bit mask of SPI2 field.
	SYSCFG_ITLINE26_SPI2     = 0x1 // Bit SPI2.

	// ITLINE27: interrupt line 27 status           register
	SYSCFG_ITLINE27_USART1_Pos = 0x0 // Position of USART1 field.
	SYSCFG_ITLINE27_USART1_Msk = 0x1 // Bit mask of USART1 field.
	SYSCFG_ITLINE27_USART1     = 0x1 // Bit USART1.

	// ITLINE28: interrupt line 28 status           register
	SYSCFG_ITLINE28_USART2_Pos = 0x0 // Position of USART2 field.
	SYSCFG_ITLINE28_USART2_Msk = 0x1 // Bit mask of USART2 field.
	SYSCFG_ITLINE28_USART2     = 0x1 // Bit USART2.

	// ITLINE29: interrupt line 29 status           register
	SYSCFG_ITLINE29_USART3_Pos = 0x0 // Position of USART3 field.
	SYSCFG_ITLINE29_USART3_Msk = 0x1 // Bit mask of USART3 field.
	SYSCFG_ITLINE29_USART3     = 0x1 // Bit USART3.
	SYSCFG_ITLINE29_USART4_Pos = 0x1 // Position of USART4 field.
	SYSCFG_ITLINE29_USART4_Msk = 0x2 // Bit mask of USART4 field.
	SYSCFG_ITLINE29_USART4     = 0x2 // Bit USART4.
	SYSCFG_ITLINE29_USART5_Pos = 0x2 // Position of USART5 field.
	SYSCFG_ITLINE29_USART5_Msk = 0x4 // Bit mask of USART5 field.
	SYSCFG_ITLINE29_USART5     = 0x4 // Bit USART5.

	// ITLINE30: interrupt line 30 status           register
	SYSCFG_ITLINE30_USART2_Pos = 0x0 // Position of USART2 field.
	SYSCFG_ITLINE30_USART2_Msk = 0x1 // Bit mask of USART2 field.
	SYSCFG_ITLINE30_USART2     = 0x1 // Bit USART2.

	// ITLINE31: interrupt line 31 status           register
	SYSCFG_ITLINE31_RNG_Pos = 0x0 // Position of RNG field.
	SYSCFG_ITLINE31_RNG_Msk = 0x1 // Bit mask of RNG field.
	SYSCFG_ITLINE31_RNG     = 0x1 // Bit RNG.
	SYSCFG_ITLINE31_AES_Pos = 0x1 // Position of AES field.
	SYSCFG_ITLINE31_AES_Msk = 0x2 // Bit mask of AES field.
	SYSCFG_ITLINE31_AES     = 0x2 // Bit AES.
)

// Bitfields for TAMP: Tamper and backup registers
const (
	// CR1: control register 1
	TAMP_CR1_TAMP1E_Pos  = 0x0      // Position of TAMP1E field.
	TAMP_CR1_TAMP1E_Msk  = 0x1      // Bit mask of TAMP1E field.
	TAMP_CR1_TAMP1E      = 0x1      // Bit TAMP1E.
	TAMP_CR1_TAMP2E_Pos  = 0x1      // Position of TAMP2E field.
	TAMP_CR1_TAMP2E_Msk  = 0x2      // Bit mask of TAMP2E field.
	TAMP_CR1_TAMP2E      = 0x2      // Bit TAMP2E.
	TAMP_CR1_ITAMP1E_Pos = 0x10     // Position of ITAMP1E field.
	TAMP_CR1_ITAMP1E_Msk = 0x10000  // Bit mask of ITAMP1E field.
	TAMP_CR1_ITAMP1E     = 0x10000  // Bit ITAMP1E.
	TAMP_CR1_ITAMP3E_Pos = 0x12     // Position of ITAMP3E field.
	TAMP_CR1_ITAMP3E_Msk = 0x40000  // Bit mask of ITAMP3E field.
	TAMP_CR1_ITAMP3E     = 0x40000  // Bit ITAMP3E.
	TAMP_CR1_ITAMP4E_Pos = 0x13     // Position of ITAMP4E field.
	TAMP_CR1_ITAMP4E_Msk = 0x80000  // Bit mask of ITAMP4E field.
	TAMP_CR1_ITAMP4E     = 0x80000  // Bit ITAMP4E.
	TAMP_CR1_ITAMP5E_Pos = 0x14     // Position of ITAMP5E field.
	TAMP_CR1_ITAMP5E_Msk = 0x100000 // Bit mask of ITAMP5E field.
	TAMP_CR1_ITAMP5E     = 0x100000 // Bit ITAMP5E.
	TAMP_CR1_ITAMP6E_Pos = 0x15     // Position of ITAMP6E field.
	TAMP_CR1_ITAMP6E_Msk = 0x200000 // Bit mask of ITAMP6E field.
	TAMP_CR1_ITAMP6E     = 0x200000 // Bit ITAMP6E.

	// CR2: control register 2
	TAMP_CR2_TAMP1NOER_Pos = 0x0       // Position of TAMP1NOER field.
	TAMP_CR2_TAMP1NOER_Msk = 0x1       // Bit mask of TAMP1NOER field.
	TAMP_CR2_TAMP1NOER     = 0x1       // Bit TAMP1NOER.
	TAMP_CR2_TAMP2NOER_Pos = 0x1       // Position of TAMP2NOER field.
	TAMP_CR2_TAMP2NOER_Msk = 0x2       // Bit mask of TAMP2NOER field.
	TAMP_CR2_TAMP2NOER     = 0x2       // Bit TAMP2NOER.
	TAMP_CR2_TAMP1MSK_Pos  = 0x10      // Position of TAMP1MSK field.
	TAMP_CR2_TAMP1MSK_Msk  = 0x10000   // Bit mask of TAMP1MSK field.
	TAMP_CR2_TAMP1MSK      = 0x10000   // Bit TAMP1MSK.
	TAMP_CR2_TAMP2MSK_Pos  = 0x11      // Position of TAMP2MSK field.
	TAMP_CR2_TAMP2MSK_Msk  = 0x20000   // Bit mask of TAMP2MSK field.
	TAMP_CR2_TAMP2MSK      = 0x20000   // Bit TAMP2MSK.
	TAMP_CR2_TAMP1TRG_Pos  = 0x18      // Position of TAMP1TRG field.
	TAMP_CR2_TAMP1TRG_Msk  = 0x1000000 // Bit mask of TAMP1TRG field.
	TAMP_CR2_TAMP1TRG      = 0x1000000 // Bit TAMP1TRG.
	TAMP_CR2_TAMP2TRG_Pos  = 0x19      // Position of TAMP2TRG field.
	TAMP_CR2_TAMP2TRG_Msk  = 0x2000000 // Bit mask of TAMP2TRG field.
	TAMP_CR2_TAMP2TRG      = 0x2000000 // Bit TAMP2TRG.

	// FLTCR: TAMP filter control register
	TAMP_FLTCR_TAMPFREQ_Pos  = 0x0  // Position of TAMPFREQ field.
	TAMP_FLTCR_TAMPFREQ_Msk  = 0x7  // Bit mask of TAMPFREQ field.
	TAMP_FLTCR_TAMPFLT_Pos   = 0x3  // Position of TAMPFLT field.
	TAMP_FLTCR_TAMPFLT_Msk   = 0x18 // Bit mask of TAMPFLT field.
	TAMP_FLTCR_TAMPPRCH_Pos  = 0x5  // Position of TAMPPRCH field.
	TAMP_FLTCR_TAMPPRCH_Msk  = 0x60 // Bit mask of TAMPPRCH field.
	TAMP_FLTCR_TAMPPUDIS_Pos = 0x7  // Position of TAMPPUDIS field.
	TAMP_FLTCR_TAMPPUDIS_Msk = 0x80 // Bit mask of TAMPPUDIS field.
	TAMP_FLTCR_TAMPPUDIS     = 0x80 // Bit TAMPPUDIS.

	// IER: TAMP interrupt enable register
	TAMP_IER_TAMP1IE_Pos  = 0x0      // Position of TAMP1IE field.
	TAMP_IER_TAMP1IE_Msk  = 0x1      // Bit mask of TAMP1IE field.
	TAMP_IER_TAMP1IE      = 0x1      // Bit TAMP1IE.
	TAMP_IER_TAMP2IE_Pos  = 0x1      // Position of TAMP2IE field.
	TAMP_IER_TAMP2IE_Msk  = 0x2      // Bit mask of TAMP2IE field.
	TAMP_IER_TAMP2IE      = 0x2      // Bit TAMP2IE.
	TAMP_IER_ITAMP1IE_Pos = 0x10     // Position of ITAMP1IE field.
	TAMP_IER_ITAMP1IE_Msk = 0x10000  // Bit mask of ITAMP1IE field.
	TAMP_IER_ITAMP1IE     = 0x10000  // Bit ITAMP1IE.
	TAMP_IER_ITAMP3IE_Pos = 0x12     // Position of ITAMP3IE field.
	TAMP_IER_ITAMP3IE_Msk = 0x40000  // Bit mask of ITAMP3IE field.
	TAMP_IER_ITAMP3IE     = 0x40000  // Bit ITAMP3IE.
	TAMP_IER_ITAMP4IE_Pos = 0x13     // Position of ITAMP4IE field.
	TAMP_IER_ITAMP4IE_Msk = 0x80000  // Bit mask of ITAMP4IE field.
	TAMP_IER_ITAMP4IE     = 0x80000  // Bit ITAMP4IE.
	TAMP_IER_ITAMP5IE_Pos = 0x14     // Position of ITAMP5IE field.
	TAMP_IER_ITAMP5IE_Msk = 0x100000 // Bit mask of ITAMP5IE field.
	TAMP_IER_ITAMP5IE     = 0x100000 // Bit ITAMP5IE.
	TAMP_IER_ITAMP6IE_Pos = 0x15     // Position of ITAMP6IE field.
	TAMP_IER_ITAMP6IE_Msk = 0x200000 // Bit mask of ITAMP6IE field.
	TAMP_IER_ITAMP6IE     = 0x200000 // Bit ITAMP6IE.

	// SR: TAMP status register
	TAMP_SR_TAMP1F_Pos  = 0x0      // Position of TAMP1F field.
	TAMP_SR_TAMP1F_Msk  = 0x1      // Bit mask of TAMP1F field.
	TAMP_SR_TAMP1F      = 0x1      // Bit TAMP1F.
	TAMP_SR_TAMP2F_Pos  = 0x1      // Position of TAMP2F field.
	TAMP_SR_TAMP2F_Msk  = 0x2      // Bit mask of TAMP2F field.
	TAMP_SR_TAMP2F      = 0x2      // Bit TAMP2F.
	TAMP_SR_ITAMP1F_Pos = 0x10     // Position of ITAMP1F field.
	TAMP_SR_ITAMP1F_Msk = 0x10000  // Bit mask of ITAMP1F field.
	TAMP_SR_ITAMP1F     = 0x10000  // Bit ITAMP1F.
	TAMP_SR_ITAMP3F_Pos = 0x12     // Position of ITAMP3F field.
	TAMP_SR_ITAMP3F_Msk = 0x40000  // Bit mask of ITAMP3F field.
	TAMP_SR_ITAMP3F     = 0x40000  // Bit ITAMP3F.
	TAMP_SR_ITAMP4F_Pos = 0x13     // Position of ITAMP4F field.
	TAMP_SR_ITAMP4F_Msk = 0x80000  // Bit mask of ITAMP4F field.
	TAMP_SR_ITAMP4F     = 0x80000  // Bit ITAMP4F.
	TAMP_SR_ITAMP5F_Pos = 0x14     // Position of ITAMP5F field.
	TAMP_SR_ITAMP5F_Msk = 0x100000 // Bit mask of ITAMP5F field.
	TAMP_SR_ITAMP5F     = 0x100000 // Bit ITAMP5F.
	TAMP_SR_ITAMP6F_Pos = 0x15     // Position of ITAMP6F field.
	TAMP_SR_ITAMP6F_Msk = 0x200000 // Bit mask of ITAMP6F field.
	TAMP_SR_ITAMP6F     = 0x200000 // Bit ITAMP6F.
	TAMP_SR_ITAMP7F_Pos = 0x16     // Position of ITAMP7F field.
	TAMP_SR_ITAMP7F_Msk = 0x400000 // Bit mask of ITAMP7F field.
	TAMP_SR_ITAMP7F     = 0x400000 // Bit ITAMP7F.

	// MISR: TAMP masked interrupt status           register
	TAMP_MISR_TAMP1MF_Pos  = 0x0      // Position of TAMP1MF field.
	TAMP_MISR_TAMP1MF_Msk  = 0x1      // Bit mask of TAMP1MF field.
	TAMP_MISR_TAMP1MF      = 0x1      // Bit TAMP1MF.
	TAMP_MISR_TAMP2MF_Pos  = 0x1      // Position of TAMP2MF field.
	TAMP_MISR_TAMP2MF_Msk  = 0x2      // Bit mask of TAMP2MF field.
	TAMP_MISR_TAMP2MF      = 0x2      // Bit TAMP2MF.
	TAMP_MISR_ITAMP1MF_Pos = 0x10     // Position of ITAMP1MF field.
	TAMP_MISR_ITAMP1MF_Msk = 0x10000  // Bit mask of ITAMP1MF field.
	TAMP_MISR_ITAMP1MF     = 0x10000  // Bit ITAMP1MF.
	TAMP_MISR_ITAMP3MF_Pos = 0x12     // Position of ITAMP3MF field.
	TAMP_MISR_ITAMP3MF_Msk = 0x40000  // Bit mask of ITAMP3MF field.
	TAMP_MISR_ITAMP3MF     = 0x40000  // Bit ITAMP3MF.
	TAMP_MISR_ITAMP4MF_Pos = 0x13     // Position of ITAMP4MF field.
	TAMP_MISR_ITAMP4MF_Msk = 0x80000  // Bit mask of ITAMP4MF field.
	TAMP_MISR_ITAMP4MF     = 0x80000  // Bit ITAMP4MF.
	TAMP_MISR_ITAMP5MF_Pos = 0x14     // Position of ITAMP5MF field.
	TAMP_MISR_ITAMP5MF_Msk = 0x100000 // Bit mask of ITAMP5MF field.
	TAMP_MISR_ITAMP5MF     = 0x100000 // Bit ITAMP5MF.
	TAMP_MISR_ITAMP6MF_Pos = 0x15     // Position of ITAMP6MF field.
	TAMP_MISR_ITAMP6MF_Msk = 0x200000 // Bit mask of ITAMP6MF field.
	TAMP_MISR_ITAMP6MF     = 0x200000 // Bit ITAMP6MF.

	// SCR: TAMP status clear register
	TAMP_SCR_CTAMP1F_Pos  = 0x0      // Position of CTAMP1F field.
	TAMP_SCR_CTAMP1F_Msk  = 0x1      // Bit mask of CTAMP1F field.
	TAMP_SCR_CTAMP1F      = 0x1      // Bit CTAMP1F.
	TAMP_SCR_CTAMP2F_Pos  = 0x1      // Position of CTAMP2F field.
	TAMP_SCR_CTAMP2F_Msk  = 0x2      // Bit mask of CTAMP2F field.
	TAMP_SCR_CTAMP2F      = 0x2      // Bit CTAMP2F.
	TAMP_SCR_CITAMP1F_Pos = 0x10     // Position of CITAMP1F field.
	TAMP_SCR_CITAMP1F_Msk = 0x10000  // Bit mask of CITAMP1F field.
	TAMP_SCR_CITAMP1F     = 0x10000  // Bit CITAMP1F.
	TAMP_SCR_CITAMP3F_Pos = 0x12     // Position of CITAMP3F field.
	TAMP_SCR_CITAMP3F_Msk = 0x40000  // Bit mask of CITAMP3F field.
	TAMP_SCR_CITAMP3F     = 0x40000  // Bit CITAMP3F.
	TAMP_SCR_CITAMP4F_Pos = 0x13     // Position of CITAMP4F field.
	TAMP_SCR_CITAMP4F_Msk = 0x80000  // Bit mask of CITAMP4F field.
	TAMP_SCR_CITAMP4F     = 0x80000  // Bit CITAMP4F.
	TAMP_SCR_CITAMP5F_Pos = 0x14     // Position of CITAMP5F field.
	TAMP_SCR_CITAMP5F_Msk = 0x100000 // Bit mask of CITAMP5F field.
	TAMP_SCR_CITAMP5F     = 0x100000 // Bit CITAMP5F.
	TAMP_SCR_CITAMP6F_Pos = 0x15     // Position of CITAMP6F field.
	TAMP_SCR_CITAMP6F_Msk = 0x200000 // Bit mask of CITAMP6F field.
	TAMP_SCR_CITAMP6F     = 0x200000 // Bit CITAMP6F.
	TAMP_SCR_CITAMP7F_Pos = 0x16     // Position of CITAMP7F field.
	TAMP_SCR_CITAMP7F_Msk = 0x400000 // Bit mask of CITAMP7F field.
	TAMP_SCR_CITAMP7F     = 0x400000 // Bit CITAMP7F.

	// BKP0R: TAMP backup register
	TAMP_BKP0R_BKP_Pos = 0x0        // Position of BKP field.
	TAMP_BKP0R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP1R: TAMP backup register
	TAMP_BKP1R_BKP_Pos = 0x0        // Position of BKP field.
	TAMP_BKP1R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP2R: TAMP backup register
	TAMP_BKP2R_BKP_Pos = 0x0        // Position of BKP field.
	TAMP_BKP2R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP3R: TAMP backup register
	TAMP_BKP3R_BKP_Pos = 0x0        // Position of BKP field.
	TAMP_BKP3R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP4R: TAMP backup register
	TAMP_BKP4R_BKP_Pos = 0x0        // Position of BKP field.
	TAMP_BKP4R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// HWCFGR2: TAMP hardware configuration register           2
	TAMP_HWCFGR2_PTIONREG_OUT_Pos = 0x0   // Position of PTIONREG_OUT field.
	TAMP_HWCFGR2_PTIONREG_OUT_Msk = 0xff  // Bit mask of PTIONREG_OUT field.
	TAMP_HWCFGR2_TRUST_ZONE_Pos   = 0x8   // Position of TRUST_ZONE field.
	TAMP_HWCFGR2_TRUST_ZONE_Msk   = 0xf00 // Bit mask of TRUST_ZONE field.

	// HWCFGR1: TAMP hardware configuration register           1
	TAMP_HWCFGR1_BACKUP_REGS_Pos   = 0x0        // Position of BACKUP_REGS field.
	TAMP_HWCFGR1_BACKUP_REGS_Msk   = 0xff       // Bit mask of BACKUP_REGS field.
	TAMP_HWCFGR1_TAMPER_Pos        = 0x8        // Position of TAMPER field.
	TAMP_HWCFGR1_TAMPER_Msk        = 0xf00      // Bit mask of TAMPER field.
	TAMP_HWCFGR1_ACTIVE_TAMPER_Pos = 0xc        // Position of ACTIVE_TAMPER field.
	TAMP_HWCFGR1_ACTIVE_TAMPER_Msk = 0xf000     // Bit mask of ACTIVE_TAMPER field.
	TAMP_HWCFGR1_INT_TAMPER_Pos    = 0x10       // Position of INT_TAMPER field.
	TAMP_HWCFGR1_INT_TAMPER_Msk    = 0xffff0000 // Bit mask of INT_TAMPER field.

	// VERR: EXTI IP Version register
	TAMP_VERR_MINREV_Pos = 0x0  // Position of MINREV field.
	TAMP_VERR_MINREV_Msk = 0xf  // Bit mask of MINREV field.
	TAMP_VERR_MAJREV_Pos = 0x4  // Position of MAJREV field.
	TAMP_VERR_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.

	// IPIDR: EXTI Identification register
	TAMP_IPIDR_IPID_Pos = 0x0        // Position of IPID field.
	TAMP_IPIDR_IPID_Msk = 0xffffffff // Bit mask of IPID field.

	// SIDR: EXTI Size ID register
	TAMP_SIDR_SID_Pos = 0x0        // Position of SID field.
	TAMP_SIDR_SID_Msk = 0xffffffff // Bit mask of SID field.
)

// Bitfields for UCPD1: USB Power Delivery interface
const (
	// CFG1: UCPD configuration register
	UCPD_CFG1_HBITCLKDIV_Pos   = 0x0        // Position of HBITCLKDIV field.
	UCPD_CFG1_HBITCLKDIV_Msk   = 0x3f       // Bit mask of HBITCLKDIV field.
	UCPD_CFG1_IFRGAP_Pos       = 0x6        // Position of IFRGAP field.
	UCPD_CFG1_IFRGAP_Msk       = 0x7c0      // Bit mask of IFRGAP field.
	UCPD_CFG1_TRANSWIN_Pos     = 0xb        // Position of TRANSWIN field.
	UCPD_CFG1_TRANSWIN_Msk     = 0xf800     // Bit mask of TRANSWIN field.
	UCPD_CFG1_PSC_USBPDCLK_Pos = 0x11       // Position of PSC_USBPDCLK field.
	UCPD_CFG1_PSC_USBPDCLK_Msk = 0xe0000    // Bit mask of PSC_USBPDCLK field.
	UCPD_CFG1_RXORDSETEN_Pos   = 0x14       // Position of RXORDSETEN field.
	UCPD_CFG1_RXORDSETEN_Msk   = 0x1ff00000 // Bit mask of RXORDSETEN field.
	UCPD_CFG1_TXDMAEN_Pos      = 0x1d       // Position of TXDMAEN field.
	UCPD_CFG1_TXDMAEN_Msk      = 0x20000000 // Bit mask of TXDMAEN field.
	UCPD_CFG1_TXDMAEN          = 0x20000000 // Bit TXDMAEN.
	UCPD_CFG1_RXDMAEN_Pos      = 0x1e       // Position of RXDMAEN field.
	UCPD_CFG1_RXDMAEN_Msk      = 0x40000000 // Bit mask of RXDMAEN field.
	UCPD_CFG1_RXDMAEN          = 0x40000000 // Bit RXDMAEN.
	UCPD_CFG1_UCPDEN_Pos       = 0x1f       // Position of UCPDEN field.
	UCPD_CFG1_UCPDEN_Msk       = 0x80000000 // Bit mask of UCPDEN field.
	UCPD_CFG1_UCPDEN           = 0x80000000 // Bit UCPDEN.

	// CFG2: UCPD configuration register 2
	UCPD_CFG2_RXFILTDIS_Pos = 0x0 // Position of RXFILTDIS field.
	UCPD_CFG2_RXFILTDIS_Msk = 0x1 // Bit mask of RXFILTDIS field.
	UCPD_CFG2_RXFILTDIS     = 0x1 // Bit RXFILTDIS.
	UCPD_CFG2_RXFILT2N3_Pos = 0x1 // Position of RXFILT2N3 field.
	UCPD_CFG2_RXFILT2N3_Msk = 0x2 // Bit mask of RXFILT2N3 field.
	UCPD_CFG2_RXFILT2N3     = 0x2 // Bit RXFILT2N3.
	UCPD_CFG2_FORCECLK_Pos  = 0x2 // Position of FORCECLK field.
	UCPD_CFG2_FORCECLK_Msk  = 0x4 // Bit mask of FORCECLK field.
	UCPD_CFG2_FORCECLK      = 0x4 // Bit FORCECLK.
	UCPD_CFG2_WUPEN_Pos     = 0x3 // Position of WUPEN field.
	UCPD_CFG2_WUPEN_Msk     = 0x8 // Bit mask of WUPEN field.
	UCPD_CFG2_WUPEN         = 0x8 // Bit WUPEN.

	// CFG3: UCPD configuration register 3
	UCPD_CFG3_TRIM1_NG_CCRPD_Pos = 0x0        // Position of TRIM1_NG_CCRPD field.
	UCPD_CFG3_TRIM1_NG_CCRPD_Msk = 0xf        // Bit mask of TRIM1_NG_CCRPD field.
	UCPD_CFG3_TRIM1_NG_CC1A5_Pos = 0x4        // Position of TRIM1_NG_CC1A5 field.
	UCPD_CFG3_TRIM1_NG_CC1A5_Msk = 0x1f0      // Bit mask of TRIM1_NG_CC1A5 field.
	UCPD_CFG3_TRIM1_NG_CC3A0_Pos = 0x9        // Position of TRIM1_NG_CC3A0 field.
	UCPD_CFG3_TRIM1_NG_CC3A0_Msk = 0x1e00     // Bit mask of TRIM1_NG_CC3A0 field.
	UCPD_CFG3_TRIM2_NG_CCRPD_Pos = 0x10       // Position of TRIM2_NG_CCRPD field.
	UCPD_CFG3_TRIM2_NG_CCRPD_Msk = 0xf0000    // Bit mask of TRIM2_NG_CCRPD field.
	UCPD_CFG3_TRIM2_NG_CC1A5_Pos = 0x14       // Position of TRIM2_NG_CC1A5 field.
	UCPD_CFG3_TRIM2_NG_CC1A5_Msk = 0x1f00000  // Bit mask of TRIM2_NG_CC1A5 field.
	UCPD_CFG3_TRIM2_NG_CC3A0_Pos = 0x19       // Position of TRIM2_NG_CC3A0 field.
	UCPD_CFG3_TRIM2_NG_CC3A0_Msk = 0x1e000000 // Bit mask of TRIM2_NG_CC3A0 field.

	// CR: UCPD control register
	UCPD_CR_TXMODE_Pos     = 0x0      // Position of TXMODE field.
	UCPD_CR_TXMODE_Msk     = 0x3      // Bit mask of TXMODE field.
	UCPD_CR_TXSEND_Pos     = 0x2      // Position of TXSEND field.
	UCPD_CR_TXSEND_Msk     = 0x4      // Bit mask of TXSEND field.
	UCPD_CR_TXSEND         = 0x4      // Bit TXSEND.
	UCPD_CR_TXHRST_Pos     = 0x3      // Position of TXHRST field.
	UCPD_CR_TXHRST_Msk     = 0x8      // Bit mask of TXHRST field.
	UCPD_CR_TXHRST         = 0x8      // Bit TXHRST.
	UCPD_CR_RXMODE_Pos     = 0x4      // Position of RXMODE field.
	UCPD_CR_RXMODE_Msk     = 0x10     // Bit mask of RXMODE field.
	UCPD_CR_RXMODE         = 0x10     // Bit RXMODE.
	UCPD_CR_PHYRXEN_Pos    = 0x5      // Position of PHYRXEN field.
	UCPD_CR_PHYRXEN_Msk    = 0x20     // Bit mask of PHYRXEN field.
	UCPD_CR_PHYRXEN        = 0x20     // Bit PHYRXEN.
	UCPD_CR_PHYCCSEL_Pos   = 0x6      // Position of PHYCCSEL field.
	UCPD_CR_PHYCCSEL_Msk   = 0x40     // Bit mask of PHYCCSEL field.
	UCPD_CR_PHYCCSEL       = 0x40     // Bit PHYCCSEL.
	UCPD_CR_ANASUBMODE_Pos = 0x7      // Position of ANASUBMODE field.
	UCPD_CR_ANASUBMODE_Msk = 0x180    // Bit mask of ANASUBMODE field.
	UCPD_CR_ANAMODE_Pos    = 0x9      // Position of ANAMODE field.
	UCPD_CR_ANAMODE_Msk    = 0x200    // Bit mask of ANAMODE field.
	UCPD_CR_ANAMODE        = 0x200    // Bit ANAMODE.
	UCPD_CR_CCENABLE_Pos   = 0xa      // Position of CCENABLE field.
	UCPD_CR_CCENABLE_Msk   = 0xc00    // Bit mask of CCENABLE field.
	UCPD_CR_DBATTEN_Pos    = 0xf      // Position of DBATTEN field.
	UCPD_CR_DBATTEN_Msk    = 0x8000   // Bit mask of DBATTEN field.
	UCPD_CR_DBATTEN        = 0x8000   // Bit DBATTEN.
	UCPD_CR_FRSRXEN_Pos    = 0x10     // Position of FRSRXEN field.
	UCPD_CR_FRSRXEN_Msk    = 0x10000  // Bit mask of FRSRXEN field.
	UCPD_CR_FRSRXEN        = 0x10000  // Bit FRSRXEN.
	UCPD_CR_FRSTX_Pos      = 0x11     // Position of FRSTX field.
	UCPD_CR_FRSTX_Msk      = 0x20000  // Bit mask of FRSTX field.
	UCPD_CR_FRSTX          = 0x20000  // Bit FRSTX.
	UCPD_CR_RDCH_Pos       = 0x12     // Position of RDCH field.
	UCPD_CR_RDCH_Msk       = 0x40000  // Bit mask of RDCH field.
	UCPD_CR_RDCH           = 0x40000  // Bit RDCH.
	UCPD_CR_CC1TCDIS_Pos   = 0x14     // Position of CC1TCDIS field.
	UCPD_CR_CC1TCDIS_Msk   = 0x100000 // Bit mask of CC1TCDIS field.
	UCPD_CR_CC1TCDIS       = 0x100000 // Bit CC1TCDIS.
	UCPD_CR_CC2TCDIS_Pos   = 0x15     // Position of CC2TCDIS field.
	UCPD_CR_CC2TCDIS_Msk   = 0x200000 // Bit mask of CC2TCDIS field.
	UCPD_CR_CC2TCDIS       = 0x200000 // Bit CC2TCDIS.

	// IMR: UCPD Interrupt Mask Register
	UCPD_IMR_TXISIE_Pos      = 0x0      // Position of TXISIE field.
	UCPD_IMR_TXISIE_Msk      = 0x1      // Bit mask of TXISIE field.
	UCPD_IMR_TXISIE          = 0x1      // Bit TXISIE.
	UCPD_IMR_TXMSGDISCIE_Pos = 0x1      // Position of TXMSGDISCIE field.
	UCPD_IMR_TXMSGDISCIE_Msk = 0x2      // Bit mask of TXMSGDISCIE field.
	UCPD_IMR_TXMSGDISCIE     = 0x2      // Bit TXMSGDISCIE.
	UCPD_IMR_TXMSGSENTIE_Pos = 0x2      // Position of TXMSGSENTIE field.
	UCPD_IMR_TXMSGSENTIE_Msk = 0x4      // Bit mask of TXMSGSENTIE field.
	UCPD_IMR_TXMSGSENTIE     = 0x4      // Bit TXMSGSENTIE.
	UCPD_IMR_TXMSGABTIE_Pos  = 0x3      // Position of TXMSGABTIE field.
	UCPD_IMR_TXMSGABTIE_Msk  = 0x8      // Bit mask of TXMSGABTIE field.
	UCPD_IMR_TXMSGABTIE      = 0x8      // Bit TXMSGABTIE.
	UCPD_IMR_HRSTDISCIE_Pos  = 0x4      // Position of HRSTDISCIE field.
	UCPD_IMR_HRSTDISCIE_Msk  = 0x10     // Bit mask of HRSTDISCIE field.
	UCPD_IMR_HRSTDISCIE      = 0x10     // Bit HRSTDISCIE.
	UCPD_IMR_HRSTSENTIE_Pos  = 0x5      // Position of HRSTSENTIE field.
	UCPD_IMR_HRSTSENTIE_Msk  = 0x20     // Bit mask of HRSTSENTIE field.
	UCPD_IMR_HRSTSENTIE      = 0x20     // Bit HRSTSENTIE.
	UCPD_IMR_TXUNDIE_Pos     = 0x6      // Position of TXUNDIE field.
	UCPD_IMR_TXUNDIE_Msk     = 0x40     // Bit mask of TXUNDIE field.
	UCPD_IMR_TXUNDIE         = 0x40     // Bit TXUNDIE.
	UCPD_IMR_RXNEIE_Pos      = 0x8      // Position of RXNEIE field.
	UCPD_IMR_RXNEIE_Msk      = 0x100    // Bit mask of RXNEIE field.
	UCPD_IMR_RXNEIE          = 0x100    // Bit RXNEIE.
	UCPD_IMR_RXORDDETIE_Pos  = 0x9      // Position of RXORDDETIE field.
	UCPD_IMR_RXORDDETIE_Msk  = 0x200    // Bit mask of RXORDDETIE field.
	UCPD_IMR_RXORDDETIE      = 0x200    // Bit RXORDDETIE.
	UCPD_IMR_RXHRSTDETIE_Pos = 0xa      // Position of RXHRSTDETIE field.
	UCPD_IMR_RXHRSTDETIE_Msk = 0x400    // Bit mask of RXHRSTDETIE field.
	UCPD_IMR_RXHRSTDETIE     = 0x400    // Bit RXHRSTDETIE.
	UCPD_IMR_RXOVRIE_Pos     = 0xb      // Position of RXOVRIE field.
	UCPD_IMR_RXOVRIE_Msk     = 0x800    // Bit mask of RXOVRIE field.
	UCPD_IMR_RXOVRIE         = 0x800    // Bit RXOVRIE.
	UCPD_IMR_RXMSGENDIE_Pos  = 0xc      // Position of RXMSGENDIE field.
	UCPD_IMR_RXMSGENDIE_Msk  = 0x1000   // Bit mask of RXMSGENDIE field.
	UCPD_IMR_RXMSGENDIE      = 0x1000   // Bit RXMSGENDIE.
	UCPD_IMR_TYPECEVT1IE_Pos = 0xe      // Position of TYPECEVT1IE field.
	UCPD_IMR_TYPECEVT1IE_Msk = 0x4000   // Bit mask of TYPECEVT1IE field.
	UCPD_IMR_TYPECEVT1IE     = 0x4000   // Bit TYPECEVT1IE.
	UCPD_IMR_TYPECEVT2IE_Pos = 0xf      // Position of TYPECEVT2IE field.
	UCPD_IMR_TYPECEVT2IE_Msk = 0x8000   // Bit mask of TYPECEVT2IE field.
	UCPD_IMR_TYPECEVT2IE     = 0x8000   // Bit TYPECEVT2IE.
	UCPD_IMR_FRSEVTIE_Pos    = 0x14     // Position of FRSEVTIE field.
	UCPD_IMR_FRSEVTIE_Msk    = 0x100000 // Bit mask of FRSEVTIE field.
	UCPD_IMR_FRSEVTIE        = 0x100000 // Bit FRSEVTIE.

	// SR: UCPD Status Register
	UCPD_SR_TXIS_Pos             = 0x0      // Position of TXIS field.
	UCPD_SR_TXIS_Msk             = 0x1      // Bit mask of TXIS field.
	UCPD_SR_TXIS                 = 0x1      // Bit TXIS.
	UCPD_SR_TXMSGDISC_Pos        = 0x1      // Position of TXMSGDISC field.
	UCPD_SR_TXMSGDISC_Msk        = 0x2      // Bit mask of TXMSGDISC field.
	UCPD_SR_TXMSGDISC            = 0x2      // Bit TXMSGDISC.
	UCPD_SR_TXMSGSENT_Pos        = 0x2      // Position of TXMSGSENT field.
	UCPD_SR_TXMSGSENT_Msk        = 0x4      // Bit mask of TXMSGSENT field.
	UCPD_SR_TXMSGSENT            = 0x4      // Bit TXMSGSENT.
	UCPD_SR_TXMSGABT_Pos         = 0x3      // Position of TXMSGABT field.
	UCPD_SR_TXMSGABT_Msk         = 0x8      // Bit mask of TXMSGABT field.
	UCPD_SR_TXMSGABT             = 0x8      // Bit TXMSGABT.
	UCPD_SR_HRSTDISC_Pos         = 0x4      // Position of HRSTDISC field.
	UCPD_SR_HRSTDISC_Msk         = 0x10     // Bit mask of HRSTDISC field.
	UCPD_SR_HRSTDISC             = 0x10     // Bit HRSTDISC.
	UCPD_SR_HRSTSENT_Pos         = 0x5      // Position of HRSTSENT field.
	UCPD_SR_HRSTSENT_Msk         = 0x20     // Bit mask of HRSTSENT field.
	UCPD_SR_HRSTSENT             = 0x20     // Bit HRSTSENT.
	UCPD_SR_TXUND_Pos            = 0x6      // Position of TXUND field.
	UCPD_SR_TXUND_Msk            = 0x40     // Bit mask of TXUND field.
	UCPD_SR_TXUND                = 0x40     // Bit TXUND.
	UCPD_SR_RXNE_Pos             = 0x8      // Position of RXNE field.
	UCPD_SR_RXNE_Msk             = 0x100    // Bit mask of RXNE field.
	UCPD_SR_RXNE                 = 0x100    // Bit RXNE.
	UCPD_SR_RXORDDET_Pos         = 0x9      // Position of RXORDDET field.
	UCPD_SR_RXORDDET_Msk         = 0x200    // Bit mask of RXORDDET field.
	UCPD_SR_RXORDDET             = 0x200    // Bit RXORDDET.
	UCPD_SR_RXHRSTDET_Pos        = 0xa      // Position of RXHRSTDET field.
	UCPD_SR_RXHRSTDET_Msk        = 0x400    // Bit mask of RXHRSTDET field.
	UCPD_SR_RXHRSTDET            = 0x400    // Bit RXHRSTDET.
	UCPD_SR_RXOVR_Pos            = 0xb      // Position of RXOVR field.
	UCPD_SR_RXOVR_Msk            = 0x800    // Bit mask of RXOVR field.
	UCPD_SR_RXOVR                = 0x800    // Bit RXOVR.
	UCPD_SR_RXMSGEND_Pos         = 0xc      // Position of RXMSGEND field.
	UCPD_SR_RXMSGEND_Msk         = 0x1000   // Bit mask of RXMSGEND field.
	UCPD_SR_RXMSGEND             = 0x1000   // Bit RXMSGEND.
	UCPD_SR_RXERR_Pos            = 0xd      // Position of RXERR field.
	UCPD_SR_RXERR_Msk            = 0x2000   // Bit mask of RXERR field.
	UCPD_SR_RXERR                = 0x2000   // Bit RXERR.
	UCPD_SR_TYPECEVT1_Pos        = 0xe      // Position of TYPECEVT1 field.
	UCPD_SR_TYPECEVT1_Msk        = 0x4000   // Bit mask of TYPECEVT1 field.
	UCPD_SR_TYPECEVT1            = 0x4000   // Bit TYPECEVT1.
	UCPD_SR_TYPECEVT2_Pos        = 0xf      // Position of TYPECEVT2 field.
	UCPD_SR_TYPECEVT2_Msk        = 0x8000   // Bit mask of TYPECEVT2 field.
	UCPD_SR_TYPECEVT2            = 0x8000   // Bit TYPECEVT2.
	UCPD_SR_TYPEC_VSTATE_CC1_Pos = 0x10     // Position of TYPEC_VSTATE_CC1 field.
	UCPD_SR_TYPEC_VSTATE_CC1_Msk = 0x30000  // Bit mask of TYPEC_VSTATE_CC1 field.
	UCPD_SR_TYPEC_VSTATE_CC2_Pos = 0x12     // Position of TYPEC_VSTATE_CC2 field.
	UCPD_SR_TYPEC_VSTATE_CC2_Msk = 0xc0000  // Bit mask of TYPEC_VSTATE_CC2 field.
	UCPD_SR_FRSEVT_Pos           = 0x14     // Position of FRSEVT field.
	UCPD_SR_FRSEVT_Msk           = 0x100000 // Bit mask of FRSEVT field.
	UCPD_SR_FRSEVT               = 0x100000 // Bit FRSEVT.

	// ICR: UCPD Interrupt Clear Register
	UCPD_ICR_TXMSGDISCCF_Pos = 0x1      // Position of TXMSGDISCCF field.
	UCPD_ICR_TXMSGDISCCF_Msk = 0x2      // Bit mask of TXMSGDISCCF field.
	UCPD_ICR_TXMSGDISCCF     = 0x2      // Bit TXMSGDISCCF.
	UCPD_ICR_TXMSGSENTCF_Pos = 0x2      // Position of TXMSGSENTCF field.
	UCPD_ICR_TXMSGSENTCF_Msk = 0x4      // Bit mask of TXMSGSENTCF field.
	UCPD_ICR_TXMSGSENTCF     = 0x4      // Bit TXMSGSENTCF.
	UCPD_ICR_TXMSGABTCF_Pos  = 0x3      // Position of TXMSGABTCF field.
	UCPD_ICR_TXMSGABTCF_Msk  = 0x8      // Bit mask of TXMSGABTCF field.
	UCPD_ICR_TXMSGABTCF      = 0x8      // Bit TXMSGABTCF.
	UCPD_ICR_HRSTDISCCF_Pos  = 0x4      // Position of HRSTDISCCF field.
	UCPD_ICR_HRSTDISCCF_Msk  = 0x10     // Bit mask of HRSTDISCCF field.
	UCPD_ICR_HRSTDISCCF      = 0x10     // Bit HRSTDISCCF.
	UCPD_ICR_HRSTSENTCF_Pos  = 0x5      // Position of HRSTSENTCF field.
	UCPD_ICR_HRSTSENTCF_Msk  = 0x20     // Bit mask of HRSTSENTCF field.
	UCPD_ICR_HRSTSENTCF      = 0x20     // Bit HRSTSENTCF.
	UCPD_ICR_TXUNDCF_Pos     = 0x6      // Position of TXUNDCF field.
	UCPD_ICR_TXUNDCF_Msk     = 0x40     // Bit mask of TXUNDCF field.
	UCPD_ICR_TXUNDCF         = 0x40     // Bit TXUNDCF.
	UCPD_ICR_RXORDDETCF_Pos  = 0x9      // Position of RXORDDETCF field.
	UCPD_ICR_RXORDDETCF_Msk  = 0x200    // Bit mask of RXORDDETCF field.
	UCPD_ICR_RXORDDETCF      = 0x200    // Bit RXORDDETCF.
	UCPD_ICR_RXHRSTDETCF_Pos = 0xa      // Position of RXHRSTDETCF field.
	UCPD_ICR_RXHRSTDETCF_Msk = 0x400    // Bit mask of RXHRSTDETCF field.
	UCPD_ICR_RXHRSTDETCF     = 0x400    // Bit RXHRSTDETCF.
	UCPD_ICR_RXOVRCF_Pos     = 0xb      // Position of RXOVRCF field.
	UCPD_ICR_RXOVRCF_Msk     = 0x800    // Bit mask of RXOVRCF field.
	UCPD_ICR_RXOVRCF         = 0x800    // Bit RXOVRCF.
	UCPD_ICR_RXMSGENDCF_Pos  = 0xc      // Position of RXMSGENDCF field.
	UCPD_ICR_RXMSGENDCF_Msk  = 0x1000   // Bit mask of RXMSGENDCF field.
	UCPD_ICR_RXMSGENDCF      = 0x1000   // Bit RXMSGENDCF.
	UCPD_ICR_TYPECEVT1CF_Pos = 0xe      // Position of TYPECEVT1CF field.
	UCPD_ICR_TYPECEVT1CF_Msk = 0x4000   // Bit mask of TYPECEVT1CF field.
	UCPD_ICR_TYPECEVT1CF     = 0x4000   // Bit TYPECEVT1CF.
	UCPD_ICR_TYPECEVT2CF_Pos = 0xf      // Position of TYPECEVT2CF field.
	UCPD_ICR_TYPECEVT2CF_Msk = 0x8000   // Bit mask of TYPECEVT2CF field.
	UCPD_ICR_TYPECEVT2CF     = 0x8000   // Bit TYPECEVT2CF.
	UCPD_ICR_FRSEVTCF_Pos    = 0x14     // Position of FRSEVTCF field.
	UCPD_ICR_FRSEVTCF_Msk    = 0x100000 // Bit mask of FRSEVTCF field.
	UCPD_ICR_FRSEVTCF        = 0x100000 // Bit FRSEVTCF.

	// TX_ORDSET: UCPD Tx Ordered Set Type           Register
	UCPD_TX_ORDSET_TXORDSET_Pos = 0x0     // Position of TXORDSET field.
	UCPD_TX_ORDSET_TXORDSET_Msk = 0xfffff // Bit mask of TXORDSET field.

	// TX_PAYSZ: UCPD Tx Paysize Register
	UCPD_TX_PAYSZ_TXPAYSZ_Pos = 0x0   // Position of TXPAYSZ field.
	UCPD_TX_PAYSZ_TXPAYSZ_Msk = 0x3ff // Bit mask of TXPAYSZ field.

	// TXDR: UCPD Tx Data Register
	UCPD_TXDR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	UCPD_TXDR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.

	// RX_ORDSET: UCPD Rx Ordered Set Register
	UCPD_RX_ORDSET_RXORDSET_Pos      = 0x0  // Position of RXORDSET field.
	UCPD_RX_ORDSET_RXORDSET_Msk      = 0x7  // Bit mask of RXORDSET field.
	UCPD_RX_ORDSET_RXSOP3OF4_Pos     = 0x3  // Position of RXSOP3OF4 field.
	UCPD_RX_ORDSET_RXSOP3OF4_Msk     = 0x8  // Bit mask of RXSOP3OF4 field.
	UCPD_RX_ORDSET_RXSOP3OF4         = 0x8  // Bit RXSOP3OF4.
	UCPD_RX_ORDSET_RXSOPKINVALID_Pos = 0x4  // Position of RXSOPKINVALID field.
	UCPD_RX_ORDSET_RXSOPKINVALID_Msk = 0x70 // Bit mask of RXSOPKINVALID field.

	// RX_PAYSZ: UCPD Rx Paysize Register
	UCPD_RX_PAYSZ_RXPAYSZ_Pos = 0x0   // Position of RXPAYSZ field.
	UCPD_RX_PAYSZ_RXPAYSZ_Msk = 0x3ff // Bit mask of RXPAYSZ field.

	// RXDR: UCPD Receive Data Register
	UCPD_RXDR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	UCPD_RXDR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// RX_ORDEXT1: UCPD Rx Ordered Set Extension           Register
	UCPD_RX_ORDEXT1_RXSOPX1_Pos = 0x0     // Position of RXSOPX1 field.
	UCPD_RX_ORDEXT1_RXSOPX1_Msk = 0xfffff // Bit mask of RXSOPX1 field.

	// RX_ORDEXT2: UCPD Rx Ordered Set Extension           Register
	UCPD_RX_ORDEXT2_RXSOPX2_Pos = 0x0     // Position of RXSOPX2 field.
	UCPD_RX_ORDEXT2_RXSOPX2_Msk = 0xfffff // Bit mask of RXSOPX2 field.

	// IPVER: UCPD IP ID register
	UCPD_IPVER_IPVER_Pos = 0x0        // Position of IPVER field.
	UCPD_IPVER_IPVER_Msk = 0xffffffff // Bit mask of IPVER field.

	// IPID: UCPD IP ID register
	UCPD_IPID_IPID_Pos = 0x0        // Position of IPID field.
	UCPD_IPID_IPID_Msk = 0xffffffff // Bit mask of IPID field.

	// MID: UCPD IP ID register
	UCPD_MID_IPID_Pos = 0x0        // Position of IPID field.
	UCPD_MID_IPID_Msk = 0xffffffff // Bit mask of IPID field.
)

// Bitfields for LPTIM1: Low power timer
const (
	// ISR: Interrupt and Status Register
	LPTIM_ISR_DOWN_Pos    = 0x6  // Position of DOWN field.
	LPTIM_ISR_DOWN_Msk    = 0x40 // Bit mask of DOWN field.
	LPTIM_ISR_DOWN        = 0x40 // Bit DOWN.
	LPTIM_ISR_UP_Pos      = 0x5  // Position of UP field.
	LPTIM_ISR_UP_Msk      = 0x20 // Bit mask of UP field.
	LPTIM_ISR_UP          = 0x20 // Bit UP.
	LPTIM_ISR_ARROK_Pos   = 0x4  // Position of ARROK field.
	LPTIM_ISR_ARROK_Msk   = 0x10 // Bit mask of ARROK field.
	LPTIM_ISR_ARROK       = 0x10 // Bit ARROK.
	LPTIM_ISR_CMPOK_Pos   = 0x3  // Position of CMPOK field.
	LPTIM_ISR_CMPOK_Msk   = 0x8  // Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK       = 0x8  // Bit CMPOK.
	LPTIM_ISR_EXTTRIG_Pos = 0x2  // Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4  // Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG     = 0x4  // Bit EXTTRIG.
	LPTIM_ISR_ARRM_Pos    = 0x1  // Position of ARRM field.
	LPTIM_ISR_ARRM_Msk    = 0x2  // Bit mask of ARRM field.
	LPTIM_ISR_ARRM        = 0x2  // Bit ARRM.
	LPTIM_ISR_CMPM_Pos    = 0x0  // Position of CMPM field.
	LPTIM_ISR_CMPM_Msk    = 0x1  // Bit mask of CMPM field.
	LPTIM_ISR_CMPM        = 0x1  // Bit CMPM.

	// ICR: Interrupt Clear Register
	LPTIM_ICR_DOWNCF_Pos    = 0x6  // Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk    = 0x40 // Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF        = 0x40 // Bit DOWNCF.
	LPTIM_ICR_UPCF_Pos      = 0x5  // Position of UPCF field.
	LPTIM_ICR_UPCF_Msk      = 0x20 // Bit mask of UPCF field.
	LPTIM_ICR_UPCF          = 0x20 // Bit UPCF.
	LPTIM_ICR_ARROKCF_Pos   = 0x4  // Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk   = 0x10 // Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF       = 0x10 // Bit ARROKCF.
	LPTIM_ICR_CMPOKCF_Pos   = 0x3  // Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk   = 0x8  // Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF       = 0x8  // Bit CMPOKCF.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2  // Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4  // Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF     = 0x4  // Bit EXTTRIGCF.
	LPTIM_ICR_ARRMCF_Pos    = 0x1  // Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk    = 0x2  // Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF        = 0x2  // Bit ARRMCF.
	LPTIM_ICR_CMPMCF_Pos    = 0x0  // Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk    = 0x1  // Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF        = 0x1  // Bit CMPMCF.

	// IER: Interrupt Enable Register
	LPTIM_IER_DOWNIE_Pos    = 0x6  // Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk    = 0x40 // Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE        = 0x40 // Bit DOWNIE.
	LPTIM_IER_UPIE_Pos      = 0x5  // Position of UPIE field.
	LPTIM_IER_UPIE_Msk      = 0x20 // Bit mask of UPIE field.
	LPTIM_IER_UPIE          = 0x20 // Bit UPIE.
	LPTIM_IER_ARROKIE_Pos   = 0x4  // Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk   = 0x10 // Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE       = 0x10 // Bit ARROKIE.
	LPTIM_IER_CMPOKIE_Pos   = 0x3  // Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk   = 0x8  // Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE       = 0x8  // Bit CMPOKIE.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2  // Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4  // Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE     = 0x4  // Bit EXTTRIGIE.
	LPTIM_IER_ARRMIE_Pos    = 0x1  // Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk    = 0x2  // Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE        = 0x2  // Bit ARRMIE.
	LPTIM_IER_CMPMIE_Pos    = 0x0  // Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk    = 0x1  // Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE        = 0x1  // Bit CMPMIE.

	// CFGR: Configuration Register
	LPTIM_CFGR_ENC_Pos       = 0x18      // Position of ENC field.
	LPTIM_CFGR_ENC_Msk       = 0x1000000 // Bit mask of ENC field.
	LPTIM_CFGR_ENC           = 0x1000000 // Bit ENC.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17      // Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000  // Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE     = 0x800000  // Bit COUNTMODE.
	LPTIM_CFGR_PRELOAD_Pos   = 0x16      // Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk   = 0x400000  // Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD       = 0x400000  // Bit PRELOAD.
	LPTIM_CFGR_WAVPOL_Pos    = 0x15      // Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk    = 0x200000  // Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL        = 0x200000  // Bit WAVPOL.
	LPTIM_CFGR_WAVE_Pos      = 0x14      // Position of WAVE field.
	LPTIM_CFGR_WAVE_Msk      = 0x100000  // Bit mask of WAVE field.
	LPTIM_CFGR_WAVE          = 0x100000  // Bit WAVE.
	LPTIM_CFGR_TIMOUT_Pos    = 0x13      // Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk    = 0x80000   // Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT        = 0x80000   // Bit TIMOUT.
	LPTIM_CFGR_TRIGEN_Pos    = 0x11      // Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk    = 0x60000   // Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGSEL_Pos   = 0xd       // Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk   = 0xe000    // Bit mask of TRIGSEL field.
	LPTIM_CFGR_PRESC_Pos     = 0x9       // Position of PRESC field.
	LPTIM_CFGR_PRESC_Msk     = 0xe00     // Bit mask of PRESC field.
	LPTIM_CFGR_TRGFLT_Pos    = 0x6       // Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk    = 0xc0      // Bit mask of TRGFLT field.
	LPTIM_CFGR_CKFLT_Pos     = 0x3       // Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk     = 0x18      // Bit mask of CKFLT field.
	LPTIM_CFGR_CKPOL_Pos     = 0x1       // Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk     = 0x6       // Bit mask of CKPOL field.
	LPTIM_CFGR_CKSEL_Pos     = 0x0       // Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk     = 0x1       // Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL         = 0x1       // Bit CKSEL.

	// CR: Control Register
	LPTIM_CR_RSTARE_Pos   = 0x4  // Position of RSTARE field.
	LPTIM_CR_RSTARE_Msk   = 0x10 // Bit mask of RSTARE field.
	LPTIM_CR_RSTARE       = 0x10 // Bit RSTARE.
	LPTIM_CR_COUNTRST_Pos = 0x3  // Position of COUNTRST field.
	LPTIM_CR_COUNTRST_Msk = 0x8  // Bit mask of COUNTRST field.
	LPTIM_CR_COUNTRST     = 0x8  // Bit COUNTRST.
	LPTIM_CR_CNTSTRT_Pos  = 0x2  // Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk  = 0x4  // Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT      = 0x4  // Bit CNTSTRT.
	LPTIM_CR_SNGSTRT_Pos  = 0x1  // Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk  = 0x2  // Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT      = 0x2  // Bit SNGSTRT.
	LPTIM_CR_ENABLE_Pos   = 0x0  // Position of ENABLE field.
	LPTIM_CR_ENABLE_Msk   = 0x1  // Bit mask of ENABLE field.
	LPTIM_CR_ENABLE       = 0x1  // Bit ENABLE.

	// CMP: Compare Register
	LPTIM_CMP_CMP_Pos = 0x0    // Position of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff // Bit mask of CMP field.

	// ARR: Autoreload Register
	LPTIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// CNT: Counter Register
	LPTIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.

	// CFGR2: LPTIM configuration register 2
	LPTIM_CFGR2_IN2SEL_Pos = 0x4  // Position of IN2SEL field.
	LPTIM_CFGR2_IN2SEL_Msk = 0x30 // Bit mask of IN2SEL field.
	LPTIM_CFGR2_IN1SEL_Pos = 0x0  // Position of IN1SEL field.
	LPTIM_CFGR2_IN1SEL_Msk = 0x3  // Bit mask of IN1SEL field.
)

// Bitfields for HDMI_CEC: HDMI-CEC
const (
	// CEC_CR: CEC control register
	CEC_CEC_CR_CECEN_Pos = 0x0 // Position of CECEN field.
	CEC_CEC_CR_CECEN_Msk = 0x1 // Bit mask of CECEN field.
	CEC_CEC_CR_CECEN     = 0x1 // Bit CECEN.
	CEC_CEC_CR_TXSOM_Pos = 0x1 // Position of TXSOM field.
	CEC_CEC_CR_TXSOM_Msk = 0x2 // Bit mask of TXSOM field.
	CEC_CEC_CR_TXSOM     = 0x2 // Bit TXSOM.
	CEC_CEC_CR_TXEOM_Pos = 0x2 // Position of TXEOM field.
	CEC_CEC_CR_TXEOM_Msk = 0x4 // Bit mask of TXEOM field.
	CEC_CEC_CR_TXEOM     = 0x4 // Bit TXEOM.

	// CEC_CFGR: This register is used to configure the           HDMI-CEC controller. It is mandatory to write CEC_CFGR           only when CECEN=0.
	CEC_CEC_CFGR_SFT_Pos      = 0x0        // Position of SFT field.
	CEC_CEC_CFGR_SFT_Msk      = 0x7        // Bit mask of SFT field.
	CEC_CEC_CFGR_RXTOL_Pos    = 0x3        // Position of RXTOL field.
	CEC_CEC_CFGR_RXTOL_Msk    = 0x8        // Bit mask of RXTOL field.
	CEC_CEC_CFGR_RXTOL        = 0x8        // Bit RXTOL.
	CEC_CEC_CFGR_BRESTP_Pos   = 0x4        // Position of BRESTP field.
	CEC_CEC_CFGR_BRESTP_Msk   = 0x10       // Bit mask of BRESTP field.
	CEC_CEC_CFGR_BRESTP       = 0x10       // Bit BRESTP.
	CEC_CEC_CFGR_BREGEN_Pos   = 0x5        // Position of BREGEN field.
	CEC_CEC_CFGR_BREGEN_Msk   = 0x20       // Bit mask of BREGEN field.
	CEC_CEC_CFGR_BREGEN       = 0x20       // Bit BREGEN.
	CEC_CEC_CFGR_LBPEGEN_Pos  = 0x6        // Position of LBPEGEN field.
	CEC_CEC_CFGR_LBPEGEN_Msk  = 0x40       // Bit mask of LBPEGEN field.
	CEC_CEC_CFGR_LBPEGEN      = 0x40       // Bit LBPEGEN.
	CEC_CEC_CFGR_BRDNOGEN_Pos = 0x7        // Position of BRDNOGEN field.
	CEC_CEC_CFGR_BRDNOGEN_Msk = 0x80       // Bit mask of BRDNOGEN field.
	CEC_CEC_CFGR_BRDNOGEN     = 0x80       // Bit BRDNOGEN.
	CEC_CEC_CFGR_SFTOPT_Pos   = 0x8        // Position of SFTOPT field.
	CEC_CEC_CFGR_SFTOPT_Msk   = 0x100      // Bit mask of SFTOPT field.
	CEC_CEC_CFGR_SFTOPT       = 0x100      // Bit SFTOPT.
	CEC_CEC_CFGR_OAR_Pos      = 0x10       // Position of OAR field.
	CEC_CEC_CFGR_OAR_Msk      = 0x7fff0000 // Bit mask of OAR field.
	CEC_CEC_CFGR_LSTN_Pos     = 0x1f       // Position of LSTN field.
	CEC_CEC_CFGR_LSTN_Msk     = 0x80000000 // Bit mask of LSTN field.
	CEC_CEC_CFGR_LSTN         = 0x80000000 // Bit LSTN.

	// CEC_TXDR: CEC Tx data register
	CEC_CEC_TXDR_TXD_Pos = 0x0  // Position of TXD field.
	CEC_CEC_TXDR_TXD_Msk = 0xff // Bit mask of TXD field.

	// CEC_RXDR: CEC Rx Data Register
	CEC_CEC_RXDR_RXD_Pos = 0x0  // Position of RXD field.
	CEC_CEC_RXDR_RXD_Msk = 0xff // Bit mask of RXD field.

	// CEC_ISR: CEC Interrupt and Status           Register
	CEC_CEC_ISR_RXBR_Pos   = 0x0    // Position of RXBR field.
	CEC_CEC_ISR_RXBR_Msk   = 0x1    // Bit mask of RXBR field.
	CEC_CEC_ISR_RXBR       = 0x1    // Bit RXBR.
	CEC_CEC_ISR_RXEND_Pos  = 0x1    // Position of RXEND field.
	CEC_CEC_ISR_RXEND_Msk  = 0x2    // Bit mask of RXEND field.
	CEC_CEC_ISR_RXEND      = 0x2    // Bit RXEND.
	CEC_CEC_ISR_RXOVR_Pos  = 0x2    // Position of RXOVR field.
	CEC_CEC_ISR_RXOVR_Msk  = 0x4    // Bit mask of RXOVR field.
	CEC_CEC_ISR_RXOVR      = 0x4    // Bit RXOVR.
	CEC_CEC_ISR_BRE_Pos    = 0x3    // Position of BRE field.
	CEC_CEC_ISR_BRE_Msk    = 0x8    // Bit mask of BRE field.
	CEC_CEC_ISR_BRE        = 0x8    // Bit BRE.
	CEC_CEC_ISR_SBPE_Pos   = 0x4    // Position of SBPE field.
	CEC_CEC_ISR_SBPE_Msk   = 0x10   // Bit mask of SBPE field.
	CEC_CEC_ISR_SBPE       = 0x10   // Bit SBPE.
	CEC_CEC_ISR_LBPE_Pos   = 0x5    // Position of LBPE field.
	CEC_CEC_ISR_LBPE_Msk   = 0x20   // Bit mask of LBPE field.
	CEC_CEC_ISR_LBPE       = 0x20   // Bit LBPE.
	CEC_CEC_ISR_RXACKE_Pos = 0x6    // Position of RXACKE field.
	CEC_CEC_ISR_RXACKE_Msk = 0x40   // Bit mask of RXACKE field.
	CEC_CEC_ISR_RXACKE     = 0x40   // Bit RXACKE.
	CEC_CEC_ISR_ARBLST_Pos = 0x7    // Position of ARBLST field.
	CEC_CEC_ISR_ARBLST_Msk = 0x80   // Bit mask of ARBLST field.
	CEC_CEC_ISR_ARBLST     = 0x80   // Bit ARBLST.
	CEC_CEC_ISR_TXBR_Pos   = 0x8    // Position of TXBR field.
	CEC_CEC_ISR_TXBR_Msk   = 0x100  // Bit mask of TXBR field.
	CEC_CEC_ISR_TXBR       = 0x100  // Bit TXBR.
	CEC_CEC_ISR_TXEND_Pos  = 0x9    // Position of TXEND field.
	CEC_CEC_ISR_TXEND_Msk  = 0x200  // Bit mask of TXEND field.
	CEC_CEC_ISR_TXEND      = 0x200  // Bit TXEND.
	CEC_CEC_ISR_TXUDR_Pos  = 0xa    // Position of TXUDR field.
	CEC_CEC_ISR_TXUDR_Msk  = 0x400  // Bit mask of TXUDR field.
	CEC_CEC_ISR_TXUDR      = 0x400  // Bit TXUDR.
	CEC_CEC_ISR_TXERR_Pos  = 0xb    // Position of TXERR field.
	CEC_CEC_ISR_TXERR_Msk  = 0x800  // Bit mask of TXERR field.
	CEC_CEC_ISR_TXERR      = 0x800  // Bit TXERR.
	CEC_CEC_ISR_TXACKE_Pos = 0xc    // Position of TXACKE field.
	CEC_CEC_ISR_TXACKE_Msk = 0x1000 // Bit mask of TXACKE field.
	CEC_CEC_ISR_TXACKE     = 0x1000 // Bit TXACKE.

	// CEC_IER: CEC interrupt enable register
	CEC_CEC_IER_RXBRIE_Pos   = 0x0    // Position of RXBRIE field.
	CEC_CEC_IER_RXBRIE_Msk   = 0x1    // Bit mask of RXBRIE field.
	CEC_CEC_IER_RXBRIE       = 0x1    // Bit RXBRIE.
	CEC_CEC_IER_RXENDIE_Pos  = 0x1    // Position of RXENDIE field.
	CEC_CEC_IER_RXENDIE_Msk  = 0x2    // Bit mask of RXENDIE field.
	CEC_CEC_IER_RXENDIE      = 0x2    // Bit RXENDIE.
	CEC_CEC_IER_RXOVRIE_Pos  = 0x2    // Position of RXOVRIE field.
	CEC_CEC_IER_RXOVRIE_Msk  = 0x4    // Bit mask of RXOVRIE field.
	CEC_CEC_IER_RXOVRIE      = 0x4    // Bit RXOVRIE.
	CEC_CEC_IER_BREIE_Pos    = 0x3    // Position of BREIE field.
	CEC_CEC_IER_BREIE_Msk    = 0x8    // Bit mask of BREIE field.
	CEC_CEC_IER_BREIE        = 0x8    // Bit BREIE.
	CEC_CEC_IER_SBPEIE_Pos   = 0x4    // Position of SBPEIE field.
	CEC_CEC_IER_SBPEIE_Msk   = 0x10   // Bit mask of SBPEIE field.
	CEC_CEC_IER_SBPEIE       = 0x10   // Bit SBPEIE.
	CEC_CEC_IER_LBPEIE_Pos   = 0x5    // Position of LBPEIE field.
	CEC_CEC_IER_LBPEIE_Msk   = 0x20   // Bit mask of LBPEIE field.
	CEC_CEC_IER_LBPEIE       = 0x20   // Bit LBPEIE.
	CEC_CEC_IER_RXACKIE_Pos  = 0x6    // Position of RXACKIE field.
	CEC_CEC_IER_RXACKIE_Msk  = 0x40   // Bit mask of RXACKIE field.
	CEC_CEC_IER_RXACKIE      = 0x40   // Bit RXACKIE.
	CEC_CEC_IER_ARBLSTIE_Pos = 0x7    // Position of ARBLSTIE field.
	CEC_CEC_IER_ARBLSTIE_Msk = 0x80   // Bit mask of ARBLSTIE field.
	CEC_CEC_IER_ARBLSTIE     = 0x80   // Bit ARBLSTIE.
	CEC_CEC_IER_TXBRIE_Pos   = 0x8    // Position of TXBRIE field.
	CEC_CEC_IER_TXBRIE_Msk   = 0x100  // Bit mask of TXBRIE field.
	CEC_CEC_IER_TXBRIE       = 0x100  // Bit TXBRIE.
	CEC_CEC_IER_TXENDIE_Pos  = 0x9    // Position of TXENDIE field.
	CEC_CEC_IER_TXENDIE_Msk  = 0x200  // Bit mask of TXENDIE field.
	CEC_CEC_IER_TXENDIE      = 0x200  // Bit TXENDIE.
	CEC_CEC_IER_TXUDRIE_Pos  = 0xa    // Position of TXUDRIE field.
	CEC_CEC_IER_TXUDRIE_Msk  = 0x400  // Bit mask of TXUDRIE field.
	CEC_CEC_IER_TXUDRIE      = 0x400  // Bit TXUDRIE.
	CEC_CEC_IER_TXERRIE_Pos  = 0xb    // Position of TXERRIE field.
	CEC_CEC_IER_TXERRIE_Msk  = 0x800  // Bit mask of TXERRIE field.
	CEC_CEC_IER_TXERRIE      = 0x800  // Bit TXERRIE.
	CEC_CEC_IER_TXACKIE_Pos  = 0xc    // Position of TXACKIE field.
	CEC_CEC_IER_TXACKIE_Msk  = 0x1000 // Bit mask of TXACKIE field.
	CEC_CEC_IER_TXACKIE      = 0x1000 // Bit TXACKIE.
)

// Bitfields for DAC: DAC
const (
	// DAC_CR: DAC control register
	DAC_DAC_CR_EN1_Pos       = 0x0        // Position of EN1 field.
	DAC_DAC_CR_EN1_Msk       = 0x1        // Bit mask of EN1 field.
	DAC_DAC_CR_EN1           = 0x1        // Bit EN1.
	DAC_DAC_CR_TEN1_Pos      = 0x1        // Position of TEN1 field.
	DAC_DAC_CR_TEN1_Msk      = 0x2        // Bit mask of TEN1 field.
	DAC_DAC_CR_TEN1          = 0x2        // Bit TEN1.
	DAC_DAC_CR_TSEL1_Pos     = 0x2        // Position of TSEL1 field.
	DAC_DAC_CR_TSEL1_Msk     = 0x3c       // Bit mask of TSEL1 field.
	DAC_DAC_CR_WAVE1_Pos     = 0x6        // Position of WAVE1 field.
	DAC_DAC_CR_WAVE1_Msk     = 0xc0       // Bit mask of WAVE1 field.
	DAC_DAC_CR_MAMP1_Pos     = 0x8        // Position of MAMP1 field.
	DAC_DAC_CR_MAMP1_Msk     = 0xf00      // Bit mask of MAMP1 field.
	DAC_DAC_CR_DMAEN1_Pos    = 0xc        // Position of DMAEN1 field.
	DAC_DAC_CR_DMAEN1_Msk    = 0x1000     // Bit mask of DMAEN1 field.
	DAC_DAC_CR_DMAEN1        = 0x1000     // Bit DMAEN1.
	DAC_DAC_CR_DMAUDRIE1_Pos = 0xd        // Position of DMAUDRIE1 field.
	DAC_DAC_CR_DMAUDRIE1_Msk = 0x2000     // Bit mask of DMAUDRIE1 field.
	DAC_DAC_CR_DMAUDRIE1     = 0x2000     // Bit DMAUDRIE1.
	DAC_DAC_CR_CEN1_Pos      = 0xe        // Position of CEN1 field.
	DAC_DAC_CR_CEN1_Msk      = 0x4000     // Bit mask of CEN1 field.
	DAC_DAC_CR_CEN1          = 0x4000     // Bit CEN1.
	DAC_DAC_CR_EN2_Pos       = 0x10       // Position of EN2 field.
	DAC_DAC_CR_EN2_Msk       = 0x10000    // Bit mask of EN2 field.
	DAC_DAC_CR_EN2           = 0x10000    // Bit EN2.
	DAC_DAC_CR_TEN2_Pos      = 0x11       // Position of TEN2 field.
	DAC_DAC_CR_TEN2_Msk      = 0x20000    // Bit mask of TEN2 field.
	DAC_DAC_CR_TEN2          = 0x20000    // Bit TEN2.
	DAC_DAC_CR_TSEL2_Pos     = 0x12       // Position of TSEL2 field.
	DAC_DAC_CR_TSEL2_Msk     = 0x3c0000   // Bit mask of TSEL2 field.
	DAC_DAC_CR_WAVE2_Pos     = 0x16       // Position of WAVE2 field.
	DAC_DAC_CR_WAVE2_Msk     = 0xc00000   // Bit mask of WAVE2 field.
	DAC_DAC_CR_MAMP2_Pos     = 0x18       // Position of MAMP2 field.
	DAC_DAC_CR_MAMP2_Msk     = 0xf000000  // Bit mask of MAMP2 field.
	DAC_DAC_CR_DMAEN2_Pos    = 0x1c       // Position of DMAEN2 field.
	DAC_DAC_CR_DMAEN2_Msk    = 0x10000000 // Bit mask of DMAEN2 field.
	DAC_DAC_CR_DMAEN2        = 0x10000000 // Bit DMAEN2.
	DAC_DAC_CR_DMAUDRIE2_Pos = 0x1d       // Position of DMAUDRIE2 field.
	DAC_DAC_CR_DMAUDRIE2_Msk = 0x20000000 // Bit mask of DMAUDRIE2 field.
	DAC_DAC_CR_DMAUDRIE2     = 0x20000000 // Bit DMAUDRIE2.
	DAC_DAC_CR_CEN2_Pos      = 0x1e       // Position of CEN2 field.
	DAC_DAC_CR_CEN2_Msk      = 0x40000000 // Bit mask of CEN2 field.
	DAC_DAC_CR_CEN2          = 0x40000000 // Bit CEN2.

	// DAC_SWTRGR: DAC software trigger register
	DAC_DAC_SWTRGR_SWTRIG1_Pos = 0x0 // Position of SWTRIG1 field.
	DAC_DAC_SWTRGR_SWTRIG1_Msk = 0x1 // Bit mask of SWTRIG1 field.
	DAC_DAC_SWTRGR_SWTRIG1     = 0x1 // Bit SWTRIG1.
	DAC_DAC_SWTRGR_SWTRIG2_Pos = 0x1 // Position of SWTRIG2 field.
	DAC_DAC_SWTRGR_SWTRIG2_Msk = 0x2 // Bit mask of SWTRIG2 field.
	DAC_DAC_SWTRGR_SWTRIG2     = 0x2 // Bit SWTRIG2.

	// DAC_DHR12R1: DAC channel1 12-bit right-aligned data           holding register
	DAC_DAC_DHR12R1_DACC1DHR_Pos = 0x0   // Position of DACC1DHR field.
	DAC_DAC_DHR12R1_DACC1DHR_Msk = 0xfff // Bit mask of DACC1DHR field.

	// DAC_DHR12L1: DAC channel1 12-bit left aligned data           holding register
	DAC_DAC_DHR12L1_DACC1DHR_Pos = 0x4    // Position of DACC1DHR field.
	DAC_DAC_DHR12L1_DACC1DHR_Msk = 0xfff0 // Bit mask of DACC1DHR field.

	// DAC_DHR8R1: DAC channel1 8-bit right aligned data           holding register
	DAC_DAC_DHR8R1_DACC1DHR_Pos = 0x0  // Position of DACC1DHR field.
	DAC_DAC_DHR8R1_DACC1DHR_Msk = 0xff // Bit mask of DACC1DHR field.

	// DAC_DHR12R2: DAC channel2 12-bit right aligned data           holding register
	DAC_DAC_DHR12R2_DACC2DHR_Pos = 0x0   // Position of DACC2DHR field.
	DAC_DAC_DHR12R2_DACC2DHR_Msk = 0xfff // Bit mask of DACC2DHR field.

	// DAC_DHR12L2: DAC channel2 12-bit left aligned data           holding register
	DAC_DAC_DHR12L2_DACC2DHR_Pos = 0x4    // Position of DACC2DHR field.
	DAC_DAC_DHR12L2_DACC2DHR_Msk = 0xfff0 // Bit mask of DACC2DHR field.

	// DAC_DHR8R2: DAC channel2 8-bit right-aligned data           holding register
	DAC_DAC_DHR8R2_DACC2DHR_Pos = 0x0  // Position of DACC2DHR field.
	DAC_DAC_DHR8R2_DACC2DHR_Msk = 0xff // Bit mask of DACC2DHR field.

	// DAC_DHR12RD: Dual DAC 12-bit right-aligned data holding           register
	DAC_DAC_DHR12RD_DACC1DHR_Pos = 0x0       // Position of DACC1DHR field.
	DAC_DAC_DHR12RD_DACC1DHR_Msk = 0xfff     // Bit mask of DACC1DHR field.
	DAC_DAC_DHR12RD_DACC2DHR_Pos = 0x10      // Position of DACC2DHR field.
	DAC_DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000 // Bit mask of DACC2DHR field.

	// DAC_DHR12LD: DUAL DAC 12-bit left aligned data holding           register
	DAC_DAC_DHR12LD_DACC1DHR_Pos = 0x4        // Position of DACC1DHR field.
	DAC_DAC_DHR12LD_DACC1DHR_Msk = 0xfff0     // Bit mask of DACC1DHR field.
	DAC_DAC_DHR12LD_DACC2DHR_Pos = 0x14       // Position of DACC2DHR field.
	DAC_DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000 // Bit mask of DACC2DHR field.

	// DAC_DHR8RD: DUAL DAC 8-bit right aligned data holding           register
	DAC_DAC_DHR8RD_DACC1DHR_Pos = 0x0    // Position of DACC1DHR field.
	DAC_DAC_DHR8RD_DACC1DHR_Msk = 0xff   // Bit mask of DACC1DHR field.
	DAC_DAC_DHR8RD_DACC2DHR_Pos = 0x8    // Position of DACC2DHR field.
	DAC_DAC_DHR8RD_DACC2DHR_Msk = 0xff00 // Bit mask of DACC2DHR field.

	// DAC_DOR1: DAC channel1 data output           register
	DAC_DAC_DOR1_DACC1DOR_Pos = 0x0   // Position of DACC1DOR field.
	DAC_DAC_DOR1_DACC1DOR_Msk = 0xfff // Bit mask of DACC1DOR field.

	// DAC_DOR2: DAC channel2 data output           register
	DAC_DAC_DOR2_DACC2DOR_Pos = 0x0   // Position of DACC2DOR field.
	DAC_DAC_DOR2_DACC2DOR_Msk = 0xfff // Bit mask of DACC2DOR field.

	// DAC_SR: DAC status register
	DAC_DAC_SR_DMAUDR1_Pos   = 0xd        // Position of DMAUDR1 field.
	DAC_DAC_SR_DMAUDR1_Msk   = 0x2000     // Bit mask of DMAUDR1 field.
	DAC_DAC_SR_DMAUDR1       = 0x2000     // Bit DMAUDR1.
	DAC_DAC_SR_CAL_FLAG1_Pos = 0xe        // Position of CAL_FLAG1 field.
	DAC_DAC_SR_CAL_FLAG1_Msk = 0x4000     // Bit mask of CAL_FLAG1 field.
	DAC_DAC_SR_CAL_FLAG1     = 0x4000     // Bit CAL_FLAG1.
	DAC_DAC_SR_BWST1_Pos     = 0xf        // Position of BWST1 field.
	DAC_DAC_SR_BWST1_Msk     = 0x8000     // Bit mask of BWST1 field.
	DAC_DAC_SR_BWST1         = 0x8000     // Bit BWST1.
	DAC_DAC_SR_DMAUDR2_Pos   = 0x1d       // Position of DMAUDR2 field.
	DAC_DAC_SR_DMAUDR2_Msk   = 0x20000000 // Bit mask of DMAUDR2 field.
	DAC_DAC_SR_DMAUDR2       = 0x20000000 // Bit DMAUDR2.
	DAC_DAC_SR_CAL_FLAG2_Pos = 0x1e       // Position of CAL_FLAG2 field.
	DAC_DAC_SR_CAL_FLAG2_Msk = 0x40000000 // Bit mask of CAL_FLAG2 field.
	DAC_DAC_SR_CAL_FLAG2     = 0x40000000 // Bit CAL_FLAG2.
	DAC_DAC_SR_BWST2_Pos     = 0x1f       // Position of BWST2 field.
	DAC_DAC_SR_BWST2_Msk     = 0x80000000 // Bit mask of BWST2 field.
	DAC_DAC_SR_BWST2         = 0x80000000 // Bit BWST2.

	// DAC_CCR: DAC calibration control           register
	DAC_DAC_CCR_OTRIM1_Pos = 0x0      // Position of OTRIM1 field.
	DAC_DAC_CCR_OTRIM1_Msk = 0x1f     // Bit mask of OTRIM1 field.
	DAC_DAC_CCR_OTRIM2_Pos = 0x10     // Position of OTRIM2 field.
	DAC_DAC_CCR_OTRIM2_Msk = 0x1f0000 // Bit mask of OTRIM2 field.

	// DAC_MCR: DAC mode control register
	DAC_DAC_MCR_MODE1_Pos = 0x0     // Position of MODE1 field.
	DAC_DAC_MCR_MODE1_Msk = 0x7     // Bit mask of MODE1 field.
	DAC_DAC_MCR_MODE2_Pos = 0x10    // Position of MODE2 field.
	DAC_DAC_MCR_MODE2_Msk = 0x70000 // Bit mask of MODE2 field.

	// DAC_SHSR1: DAC Sample and Hold sample time register           1
	DAC_DAC_SHSR1_TSAMPLE1_Pos = 0x0   // Position of TSAMPLE1 field.
	DAC_DAC_SHSR1_TSAMPLE1_Msk = 0x3ff // Bit mask of TSAMPLE1 field.

	// DAC_SHSR2: DAC Sample and Hold sample time register           2
	DAC_DAC_SHSR2_TSAMPLE2_Pos = 0x0   // Position of TSAMPLE2 field.
	DAC_DAC_SHSR2_TSAMPLE2_Msk = 0x3ff // Bit mask of TSAMPLE2 field.

	// DAC_SHHR: DAC Sample and Hold hold time           register
	DAC_DAC_SHHR_THOLD1_Pos = 0x0       // Position of THOLD1 field.
	DAC_DAC_SHHR_THOLD1_Msk = 0x3ff     // Bit mask of THOLD1 field.
	DAC_DAC_SHHR_THOLD2_Pos = 0x10      // Position of THOLD2 field.
	DAC_DAC_SHHR_THOLD2_Msk = 0x3ff0000 // Bit mask of THOLD2 field.

	// DAC_SHRR: DAC Sample and Hold refresh time           register
	DAC_DAC_SHRR_TREFRESH1_Pos = 0x0      // Position of TREFRESH1 field.
	DAC_DAC_SHRR_TREFRESH1_Msk = 0xff     // Bit mask of TREFRESH1 field.
	DAC_DAC_SHRR_TREFRESH2_Pos = 0x10     // Position of TREFRESH2 field.
	DAC_DAC_SHRR_TREFRESH2_Msk = 0xff0000 // Bit mask of TREFRESH2 field.

	// IP_HWCFGR0: DAC IP Hardware Configuration           Register
	DAC_IP_HWCFGR0_DUAL_Pos     = 0x0      // Position of DUAL field.
	DAC_IP_HWCFGR0_DUAL_Msk     = 0xf      // Bit mask of DUAL field.
	DAC_IP_HWCFGR0_LFSR_Pos     = 0x4      // Position of LFSR field.
	DAC_IP_HWCFGR0_LFSR_Msk     = 0xf0     // Bit mask of LFSR field.
	DAC_IP_HWCFGR0_TRIANGLE_Pos = 0x8      // Position of TRIANGLE field.
	DAC_IP_HWCFGR0_TRIANGLE_Msk = 0xf00    // Bit mask of TRIANGLE field.
	DAC_IP_HWCFGR0_SAMPLE_Pos   = 0xc      // Position of SAMPLE field.
	DAC_IP_HWCFGR0_SAMPLE_Msk   = 0xf000   // Bit mask of SAMPLE field.
	DAC_IP_HWCFGR0_OR_CFG_Pos   = 0x10     // Position of OR_CFG field.
	DAC_IP_HWCFGR0_OR_CFG_Msk   = 0xff0000 // Bit mask of OR_CFG field.

	// VERR: EXTI IP Version register
	DAC_VERR_MINREV_Pos = 0x0  // Position of MINREV field.
	DAC_VERR_MINREV_Msk = 0xf  // Bit mask of MINREV field.
	DAC_VERR_MAJREV_Pos = 0x4  // Position of MAJREV field.
	DAC_VERR_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.

	// IPIDR: EXTI Identification register
	DAC_IPIDR_IPID_Pos = 0x0        // Position of IPID field.
	DAC_IPIDR_IPID_Msk = 0xffffffff // Bit mask of IPID field.

	// SIDR: EXTI Size ID register
	DAC_SIDR_SID_Pos = 0x0        // Position of SID field.
	DAC_SIDR_SID_Msk = 0xffffffff // Bit mask of SID field.
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	I2C_CR1_PE_Pos        = 0x0      // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1      // Bit mask of PE field.
	I2C_CR1_PE            = 0x1      // Bit PE.
	I2C_CR1_TXIE_Pos      = 0x1      // Position of TXIE field.
	I2C_CR1_TXIE_Msk      = 0x2      // Bit mask of TXIE field.
	I2C_CR1_TXIE          = 0x2      // Bit TXIE.
	I2C_CR1_RXIE_Pos      = 0x2      // Position of RXIE field.
	I2C_CR1_RXIE_Msk      = 0x4      // Bit mask of RXIE field.
	I2C_CR1_RXIE          = 0x4      // Bit RXIE.
	I2C_CR1_ADDRIE_Pos    = 0x3      // Position of ADDRIE field.
	I2C_CR1_ADDRIE_Msk    = 0x8      // Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE        = 0x8      // Bit ADDRIE.
	I2C_CR1_NACKIE_Pos    = 0x4      // Position of NACKIE field.
	I2C_CR1_NACKIE_Msk    = 0x10     // Bit mask of NACKIE field.
	I2C_CR1_NACKIE        = 0x10     // Bit NACKIE.
	I2C_CR1_STOPIE_Pos    = 0x5      // Position of STOPIE field.
	I2C_CR1_STOPIE_Msk    = 0x20     // Bit mask of STOPIE field.
	I2C_CR1_STOPIE        = 0x20     // Bit STOPIE.
	I2C_CR1_TCIE_Pos      = 0x6      // Position of TCIE field.
	I2C_CR1_TCIE_Msk      = 0x40     // Bit mask of TCIE field.
	I2C_CR1_TCIE          = 0x40     // Bit TCIE.
	I2C_CR1_ERRIE_Pos     = 0x7      // Position of ERRIE field.
	I2C_CR1_ERRIE_Msk     = 0x80     // Bit mask of ERRIE field.
	I2C_CR1_ERRIE         = 0x80     // Bit ERRIE.
	I2C_CR1_DNF_Pos       = 0x8      // Position of DNF field.
	I2C_CR1_DNF_Msk       = 0xf00    // Bit mask of DNF field.
	I2C_CR1_ANFOFF_Pos    = 0xc      // Position of ANFOFF field.
	I2C_CR1_ANFOFF_Msk    = 0x1000   // Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF        = 0x1000   // Bit ANFOFF.
	I2C_CR1_TXDMAEN_Pos   = 0xe      // Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk   = 0x4000   // Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN       = 0x4000   // Bit TXDMAEN.
	I2C_CR1_RXDMAEN_Pos   = 0xf      // Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk   = 0x8000   // Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN       = 0x8000   // Bit RXDMAEN.
	I2C_CR1_SBC_Pos       = 0x10     // Position of SBC field.
	I2C_CR1_SBC_Msk       = 0x10000  // Bit mask of SBC field.
	I2C_CR1_SBC           = 0x10000  // Bit SBC.
	I2C_CR1_NOSTRETCH_Pos = 0x11     // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000  // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x20000  // Bit NOSTRETCH.
	I2C_CR1_WUPEN_Pos     = 0x12     // Position of WUPEN field.
	I2C_CR1_WUPEN_Msk     = 0x40000  // Bit mask of WUPEN field.
	I2C_CR1_WUPEN         = 0x40000  // Bit WUPEN.
	I2C_CR1_GCEN_Pos      = 0x13     // Position of GCEN field.
	I2C_CR1_GCEN_Msk      = 0x80000  // Bit mask of GCEN field.
	I2C_CR1_GCEN          = 0x80000  // Bit GCEN.
	I2C_CR1_SMBHEN_Pos    = 0x14     // Position of SMBHEN field.
	I2C_CR1_SMBHEN_Msk    = 0x100000 // Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN        = 0x100000 // Bit SMBHEN.
	I2C_CR1_SMBDEN_Pos    = 0x15     // Position of SMBDEN field.
	I2C_CR1_SMBDEN_Msk    = 0x200000 // Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN        = 0x200000 // Bit SMBDEN.
	I2C_CR1_ALERTEN_Pos   = 0x16     // Position of ALERTEN field.
	I2C_CR1_ALERTEN_Msk   = 0x400000 // Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN       = 0x400000 // Bit ALERTEN.
	I2C_CR1_PECEN_Pos     = 0x17     // Position of PECEN field.
	I2C_CR1_PECEN_Msk     = 0x800000 // Bit mask of PECEN field.
	I2C_CR1_PECEN         = 0x800000 // Bit PECEN.

	// CR2: Control register 2
	I2C_CR2_PECBYTE_Pos = 0x1a      // Position of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000 // Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE     = 0x4000000 // Bit PECBYTE.
	I2C_CR2_AUTOEND_Pos = 0x19      // Position of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000 // Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND     = 0x2000000 // Bit AUTOEND.
	I2C_CR2_RELOAD_Pos  = 0x18      // Position of RELOAD field.
	I2C_CR2_RELOAD_Msk  = 0x1000000 // Bit mask of RELOAD field.
	I2C_CR2_RELOAD      = 0x1000000 // Bit RELOAD.
	I2C_CR2_NBYTES_Pos  = 0x10      // Position of NBYTES field.
	I2C_CR2_NBYTES_Msk  = 0xff0000  // Bit mask of NBYTES field.
	I2C_CR2_NACK_Pos    = 0xf       // Position of NACK field.
	I2C_CR2_NACK_Msk    = 0x8000    // Bit mask of NACK field.
	I2C_CR2_NACK        = 0x8000    // Bit NACK.
	I2C_CR2_STOP_Pos    = 0xe       // Position of STOP field.
	I2C_CR2_STOP_Msk    = 0x4000    // Bit mask of STOP field.
	I2C_CR2_STOP        = 0x4000    // Bit STOP.
	I2C_CR2_START_Pos   = 0xd       // Position of START field.
	I2C_CR2_START_Msk   = 0x2000    // Bit mask of START field.
	I2C_CR2_START       = 0x2000    // Bit START.
	I2C_CR2_HEAD10R_Pos = 0xc       // Position of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000    // Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R     = 0x1000    // Bit HEAD10R.
	I2C_CR2_ADD10_Pos   = 0xb       // Position of ADD10 field.
	I2C_CR2_ADD10_Msk   = 0x800     // Bit mask of ADD10 field.
	I2C_CR2_ADD10       = 0x800     // Bit ADD10.
	I2C_CR2_RD_WRN_Pos  = 0xa       // Position of RD_WRN field.
	I2C_CR2_RD_WRN_Msk  = 0x400     // Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN      = 0x400     // Bit RD_WRN.
	I2C_CR2_SADD_Pos    = 0x0       // Position of SADD field.
	I2C_CR2_SADD_Msk    = 0x3ff     // Bit mask of SADD field.

	// OAR1: Own address register 1
	I2C_OAR1_OA1_0_Pos   = 0x0    // Position of OA1_0 field.
	I2C_OAR1_OA1_0_Msk   = 0x1    // Bit mask of OA1_0 field.
	I2C_OAR1_OA1_0       = 0x1    // Bit OA1_0.
	I2C_OAR1_OA1_7_1_Pos = 0x1    // Position of OA1_7_1 field.
	I2C_OAR1_OA1_7_1_Msk = 0xfe   // Bit mask of OA1_7_1 field.
	I2C_OAR1_OA1_8_9_Pos = 0x8    // Position of OA1_8_9 field.
	I2C_OAR1_OA1_8_9_Msk = 0x300  // Bit mask of OA1_8_9 field.
	I2C_OAR1_OA1MODE_Pos = 0xa    // Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400  // Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE     = 0x400  // Bit OA1MODE.
	I2C_OAR1_OA1EN_Pos   = 0xf    // Position of OA1EN field.
	I2C_OAR1_OA1EN_Msk   = 0x8000 // Bit mask of OA1EN field.
	I2C_OAR1_OA1EN       = 0x8000 // Bit OA1EN.

	// OAR2: Own address register 2
	I2C_OAR2_OA2_Pos    = 0x1    // Position of OA2 field.
	I2C_OAR2_OA2_Msk    = 0xfe   // Bit mask of OA2 field.
	I2C_OAR2_OA2MSK_Pos = 0x8    // Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700  // Bit mask of OA2MSK field.
	I2C_OAR2_OA2EN_Pos  = 0xf    // Position of OA2EN field.
	I2C_OAR2_OA2EN_Msk  = 0x8000 // Bit mask of OA2EN field.
	I2C_OAR2_OA2EN      = 0x8000 // Bit OA2EN.

	// TIMINGR: Timing register
	I2C_TIMINGR_SCLL_Pos   = 0x0        // Position of SCLL field.
	I2C_TIMINGR_SCLL_Msk   = 0xff       // Bit mask of SCLL field.
	I2C_TIMINGR_SCLH_Pos   = 0x8        // Position of SCLH field.
	I2C_TIMINGR_SCLH_Msk   = 0xff00     // Bit mask of SCLH field.
	I2C_TIMINGR_SDADEL_Pos = 0x10       // Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000    // Bit mask of SDADEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14       // Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000   // Bit mask of SCLDEL field.
	I2C_TIMINGR_PRESC_Pos  = 0x1c       // Position of PRESC field.
	I2C_TIMINGR_PRESC_Msk  = 0xf0000000 // Bit mask of PRESC field.

	// TIMEOUTR: Status register 1
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0        // Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff      // Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIDLE_Pos    = 0xc        // Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk    = 0x1000     // Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE        = 0x1000     // Bit TIDLE.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf        // Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000     // Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN     = 0x8000     // Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10       // Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000  // Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TEXTEN_Pos   = 0x1f       // Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk   = 0x80000000 // Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN       = 0x80000000 // Bit TEXTEN.

	// ISR: Interrupt and Status register
	I2C_ISR_ADDCODE_Pos = 0x11     // Position of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000 // Bit mask of ADDCODE field.
	I2C_ISR_DIR_Pos     = 0x10     // Position of DIR field.
	I2C_ISR_DIR_Msk     = 0x10000  // Bit mask of DIR field.
	I2C_ISR_DIR         = 0x10000  // Bit DIR.
	I2C_ISR_BUSY_Pos    = 0xf      // Position of BUSY field.
	I2C_ISR_BUSY_Msk    = 0x8000   // Bit mask of BUSY field.
	I2C_ISR_BUSY        = 0x8000   // Bit BUSY.
	I2C_ISR_ALERT_Pos   = 0xd      // Position of ALERT field.
	I2C_ISR_ALERT_Msk   = 0x2000   // Bit mask of ALERT field.
	I2C_ISR_ALERT       = 0x2000   // Bit ALERT.
	I2C_ISR_TIMEOUT_Pos = 0xc      // Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000   // Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT     = 0x1000   // Bit TIMEOUT.
	I2C_ISR_PECERR_Pos  = 0xb      // Position of PECERR field.
	I2C_ISR_PECERR_Msk  = 0x800    // Bit mask of PECERR field.
	I2C_ISR_PECERR      = 0x800    // Bit PECERR.
	I2C_ISR_OVR_Pos     = 0xa      // Position of OVR field.
	I2C_ISR_OVR_Msk     = 0x400    // Bit mask of OVR field.
	I2C_ISR_OVR         = 0x400    // Bit OVR.
	I2C_ISR_ARLO_Pos    = 0x9      // Position of ARLO field.
	I2C_ISR_ARLO_Msk    = 0x200    // Bit mask of ARLO field.
	I2C_ISR_ARLO        = 0x200    // Bit ARLO.
	I2C_ISR_BERR_Pos    = 0x8      // Position of BERR field.
	I2C_ISR_BERR_Msk    = 0x100    // Bit mask of BERR field.
	I2C_ISR_BERR        = 0x100    // Bit BERR.
	I2C_ISR_TCR_Pos     = 0x7      // Position of TCR field.
	I2C_ISR_TCR_Msk     = 0x80     // Bit mask of TCR field.
	I2C_ISR_TCR         = 0x80     // Bit TCR.
	I2C_ISR_TC_Pos      = 0x6      // Position of TC field.
	I2C_ISR_TC_Msk      = 0x40     // Bit mask of TC field.
	I2C_ISR_TC          = 0x40     // Bit TC.
	I2C_ISR_STOPF_Pos   = 0x5      // Position of STOPF field.
	I2C_ISR_STOPF_Msk   = 0x20     // Bit mask of STOPF field.
	I2C_ISR_STOPF       = 0x20     // Bit STOPF.
	I2C_ISR_NACKF_Pos   = 0x4      // Position of NACKF field.
	I2C_ISR_NACKF_Msk   = 0x10     // Bit mask of NACKF field.
	I2C_ISR_NACKF       = 0x10     // Bit NACKF.
	I2C_ISR_ADDR_Pos    = 0x3      // Position of ADDR field.
	I2C_ISR_ADDR_Msk    = 0x8      // Bit mask of ADDR field.
	I2C_ISR_ADDR        = 0x8      // Bit ADDR.
	I2C_ISR_RXNE_Pos    = 0x2      // Position of RXNE field.
	I2C_ISR_RXNE_Msk    = 0x4      // Bit mask of RXNE field.
	I2C_ISR_RXNE        = 0x4      // Bit RXNE.
	I2C_ISR_TXIS_Pos    = 0x1      // Position of TXIS field.
	I2C_ISR_TXIS_Msk    = 0x2      // Bit mask of TXIS field.
	I2C_ISR_TXIS        = 0x2      // Bit TXIS.
	I2C_ISR_TXE_Pos     = 0x0      // Position of TXE field.
	I2C_ISR_TXE_Msk     = 0x1      // Bit mask of TXE field.
	I2C_ISR_TXE         = 0x1      // Bit TXE.

	// ICR: Interrupt clear register
	I2C_ICR_ALERTCF_Pos  = 0xd    // Position of ALERTCF field.
	I2C_ICR_ALERTCF_Msk  = 0x2000 // Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF      = 0x2000 // Bit ALERTCF.
	I2C_ICR_TIMOUTCF_Pos = 0xc    // Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000 // Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF     = 0x1000 // Bit TIMOUTCF.
	I2C_ICR_PECCF_Pos    = 0xb    // Position of PECCF field.
	I2C_ICR_PECCF_Msk    = 0x800  // Bit mask of PECCF field.
	I2C_ICR_PECCF        = 0x800  // Bit PECCF.
	I2C_ICR_OVRCF_Pos    = 0xa    // Position of OVRCF field.
	I2C_ICR_OVRCF_Msk    = 0x400  // Bit mask of OVRCF field.
	I2C_ICR_OVRCF        = 0x400  // Bit OVRCF.
	I2C_ICR_ARLOCF_Pos   = 0x9    // Position of ARLOCF field.
	I2C_ICR_ARLOCF_Msk   = 0x200  // Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF       = 0x200  // Bit ARLOCF.
	I2C_ICR_BERRCF_Pos   = 0x8    // Position of BERRCF field.
	I2C_ICR_BERRCF_Msk   = 0x100  // Bit mask of BERRCF field.
	I2C_ICR_BERRCF       = 0x100  // Bit BERRCF.
	I2C_ICR_STOPCF_Pos   = 0x5    // Position of STOPCF field.
	I2C_ICR_STOPCF_Msk   = 0x20   // Bit mask of STOPCF field.
	I2C_ICR_STOPCF       = 0x20   // Bit STOPCF.
	I2C_ICR_NACKCF_Pos   = 0x4    // Position of NACKCF field.
	I2C_ICR_NACKCF_Msk   = 0x10   // Bit mask of NACKCF field.
	I2C_ICR_NACKCF       = 0x10   // Bit NACKCF.
	I2C_ICR_ADDRCF_Pos   = 0x3    // Position of ADDRCF field.
	I2C_ICR_ADDRCF_Msk   = 0x8    // Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF       = 0x8    // Bit ADDRCF.

	// PECR: PEC register
	I2C_PECR_PEC_Pos = 0x0  // Position of PEC field.
	I2C_PECR_PEC_Msk = 0xff // Bit mask of PEC field.

	// RXDR: Receive data register
	I2C_RXDR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// TXDR: Transmit data register
	I2C_TXDR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	RTC_TR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TR_PM      = 0x400000 // Bit PM.
	RTC_TR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TR_SU_Msk  = 0xf      // Bit mask of SU field.

	// DR: date register
	RTC_DR_YT_Pos  = 0x14     // Position of YT field.
	RTC_DR_YT_Msk  = 0xf00000 // Bit mask of YT field.
	RTC_DR_YU_Pos  = 0x10     // Position of YU field.
	RTC_DR_YU_Msk  = 0xf0000  // Bit mask of YU field.
	RTC_DR_WDU_Pos = 0xd      // Position of WDU field.
	RTC_DR_WDU_Msk = 0xe000   // Bit mask of WDU field.
	RTC_DR_MT_Pos  = 0xc      // Position of MT field.
	RTC_DR_MT_Msk  = 0x1000   // Bit mask of MT field.
	RTC_DR_MT      = 0x1000   // Bit MT.
	RTC_DR_MU_Pos  = 0x8      // Position of MU field.
	RTC_DR_MU_Msk  = 0xf00    // Bit mask of MU field.
	RTC_DR_DT_Pos  = 0x4      // Position of DT field.
	RTC_DR_DT_Msk  = 0x30     // Bit mask of DT field.
	RTC_DR_DU_Pos  = 0x0      // Position of DU field.
	RTC_DR_DU_Msk  = 0xf      // Bit mask of DU field.

	// SSR: sub second register
	RTC_SSR_SS_Pos = 0x0    // Position of SS field.
	RTC_SSR_SS_Msk = 0xffff // Bit mask of SS field.

	// ICSR: initialization and status           register
	RTC_ICSR_ALRAWF_Pos  = 0x0     // Position of ALRAWF field.
	RTC_ICSR_ALRAWF_Msk  = 0x1     // Bit mask of ALRAWF field.
	RTC_ICSR_ALRAWF      = 0x1     // Bit ALRAWF.
	RTC_ICSR_ALRBWF_Pos  = 0x1     // Position of ALRBWF field.
	RTC_ICSR_ALRBWF_Msk  = 0x2     // Bit mask of ALRBWF field.
	RTC_ICSR_ALRBWF      = 0x2     // Bit ALRBWF.
	RTC_ICSR_WUTWF_Pos   = 0x2     // Position of WUTWF field.
	RTC_ICSR_WUTWF_Msk   = 0x4     // Bit mask of WUTWF field.
	RTC_ICSR_WUTWF       = 0x4     // Bit WUTWF.
	RTC_ICSR_SHPF_Pos    = 0x3     // Position of SHPF field.
	RTC_ICSR_SHPF_Msk    = 0x8     // Bit mask of SHPF field.
	RTC_ICSR_SHPF        = 0x8     // Bit SHPF.
	RTC_ICSR_INITS_Pos   = 0x4     // Position of INITS field.
	RTC_ICSR_INITS_Msk   = 0x10    // Bit mask of INITS field.
	RTC_ICSR_INITS       = 0x10    // Bit INITS.
	RTC_ICSR_RSF_Pos     = 0x5     // Position of RSF field.
	RTC_ICSR_RSF_Msk     = 0x20    // Bit mask of RSF field.
	RTC_ICSR_RSF         = 0x20    // Bit RSF.
	RTC_ICSR_INITF_Pos   = 0x6     // Position of INITF field.
	RTC_ICSR_INITF_Msk   = 0x40    // Bit mask of INITF field.
	RTC_ICSR_INITF       = 0x40    // Bit INITF.
	RTC_ICSR_INIT_Pos    = 0x7     // Position of INIT field.
	RTC_ICSR_INIT_Msk    = 0x80    // Bit mask of INIT field.
	RTC_ICSR_INIT        = 0x80    // Bit INIT.
	RTC_ICSR_RECALPF_Pos = 0x10    // Position of RECALPF field.
	RTC_ICSR_RECALPF_Msk = 0x10000 // Bit mask of RECALPF field.
	RTC_ICSR_RECALPF     = 0x10000 // Bit RECALPF.

	// PRER: prescaler register
	RTC_PRER_PREDIV_A_Pos = 0x10     // Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000 // Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_S_Pos = 0x0      // Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff   // Bit mask of PREDIV_S field.

	// WUTR: wakeup timer register
	RTC_WUTR_WUT_Pos = 0x0    // Position of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff // Bit mask of WUT field.

	// CR: control register
	RTC_CR_WUCKSEL_Pos       = 0x0        // Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk       = 0x7        // Bit mask of WUCKSEL field.
	RTC_CR_TSEDGE_Pos        = 0x3        // Position of TSEDGE field.
	RTC_CR_TSEDGE_Msk        = 0x8        // Bit mask of TSEDGE field.
	RTC_CR_TSEDGE            = 0x8        // Bit TSEDGE.
	RTC_CR_REFCKON_Pos       = 0x4        // Position of REFCKON field.
	RTC_CR_REFCKON_Msk       = 0x10       // Bit mask of REFCKON field.
	RTC_CR_REFCKON           = 0x10       // Bit REFCKON.
	RTC_CR_BYPSHAD_Pos       = 0x5        // Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk       = 0x20       // Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD           = 0x20       // Bit BYPSHAD.
	RTC_CR_FMT_Pos           = 0x6        // Position of FMT field.
	RTC_CR_FMT_Msk           = 0x40       // Bit mask of FMT field.
	RTC_CR_FMT               = 0x40       // Bit FMT.
	RTC_CR_ALRAE_Pos         = 0x8        // Position of ALRAE field.
	RTC_CR_ALRAE_Msk         = 0x100      // Bit mask of ALRAE field.
	RTC_CR_ALRAE             = 0x100      // Bit ALRAE.
	RTC_CR_ALRBE_Pos         = 0x9        // Position of ALRBE field.
	RTC_CR_ALRBE_Msk         = 0x200      // Bit mask of ALRBE field.
	RTC_CR_ALRBE             = 0x200      // Bit ALRBE.
	RTC_CR_WUTE_Pos          = 0xa        // Position of WUTE field.
	RTC_CR_WUTE_Msk          = 0x400      // Bit mask of WUTE field.
	RTC_CR_WUTE              = 0x400      // Bit WUTE.
	RTC_CR_TSE_Pos           = 0xb        // Position of TSE field.
	RTC_CR_TSE_Msk           = 0x800      // Bit mask of TSE field.
	RTC_CR_TSE               = 0x800      // Bit TSE.
	RTC_CR_ALRAIE_Pos        = 0xc        // Position of ALRAIE field.
	RTC_CR_ALRAIE_Msk        = 0x1000     // Bit mask of ALRAIE field.
	RTC_CR_ALRAIE            = 0x1000     // Bit ALRAIE.
	RTC_CR_ALRBIE_Pos        = 0xd        // Position of ALRBIE field.
	RTC_CR_ALRBIE_Msk        = 0x2000     // Bit mask of ALRBIE field.
	RTC_CR_ALRBIE            = 0x2000     // Bit ALRBIE.
	RTC_CR_WUTIE_Pos         = 0xe        // Position of WUTIE field.
	RTC_CR_WUTIE_Msk         = 0x4000     // Bit mask of WUTIE field.
	RTC_CR_WUTIE             = 0x4000     // Bit WUTIE.
	RTC_CR_TSIE_Pos          = 0xf        // Position of TSIE field.
	RTC_CR_TSIE_Msk          = 0x8000     // Bit mask of TSIE field.
	RTC_CR_TSIE              = 0x8000     // Bit TSIE.
	RTC_CR_ADD1H_Pos         = 0x10       // Position of ADD1H field.
	RTC_CR_ADD1H_Msk         = 0x10000    // Bit mask of ADD1H field.
	RTC_CR_ADD1H             = 0x10000    // Bit ADD1H.
	RTC_CR_SUB1H_Pos         = 0x11       // Position of SUB1H field.
	RTC_CR_SUB1H_Msk         = 0x20000    // Bit mask of SUB1H field.
	RTC_CR_SUB1H             = 0x20000    // Bit SUB1H.
	RTC_CR_BKP_Pos           = 0x12       // Position of BKP field.
	RTC_CR_BKP_Msk           = 0x40000    // Bit mask of BKP field.
	RTC_CR_BKP               = 0x40000    // Bit BKP.
	RTC_CR_COSEL_Pos         = 0x13       // Position of COSEL field.
	RTC_CR_COSEL_Msk         = 0x80000    // Bit mask of COSEL field.
	RTC_CR_COSEL             = 0x80000    // Bit COSEL.
	RTC_CR_POL_Pos           = 0x14       // Position of POL field.
	RTC_CR_POL_Msk           = 0x100000   // Bit mask of POL field.
	RTC_CR_POL               = 0x100000   // Bit POL.
	RTC_CR_OSEL_Pos          = 0x15       // Position of OSEL field.
	RTC_CR_OSEL_Msk          = 0x600000   // Bit mask of OSEL field.
	RTC_CR_COE_Pos           = 0x17       // Position of COE field.
	RTC_CR_COE_Msk           = 0x800000   // Bit mask of COE field.
	RTC_CR_COE               = 0x800000   // Bit COE.
	RTC_CR_ITSE_Pos          = 0x18       // Position of ITSE field.
	RTC_CR_ITSE_Msk          = 0x1000000  // Bit mask of ITSE field.
	RTC_CR_ITSE              = 0x1000000  // Bit ITSE.
	RTC_CR_TAMPTS_Pos        = 0x19       // Position of TAMPTS field.
	RTC_CR_TAMPTS_Msk        = 0x2000000  // Bit mask of TAMPTS field.
	RTC_CR_TAMPTS            = 0x2000000  // Bit TAMPTS.
	RTC_CR_TAMPOE_Pos        = 0x1a       // Position of TAMPOE field.
	RTC_CR_TAMPOE_Msk        = 0x4000000  // Bit mask of TAMPOE field.
	RTC_CR_TAMPOE            = 0x4000000  // Bit TAMPOE.
	RTC_CR_TAMPALRM_PU_Pos   = 0x1d       // Position of TAMPALRM_PU field.
	RTC_CR_TAMPALRM_PU_Msk   = 0x20000000 // Bit mask of TAMPALRM_PU field.
	RTC_CR_TAMPALRM_PU       = 0x20000000 // Bit TAMPALRM_PU.
	RTC_CR_TAMPALRM_TYPE_Pos = 0x1e       // Position of TAMPALRM_TYPE field.
	RTC_CR_TAMPALRM_TYPE_Msk = 0x40000000 // Bit mask of TAMPALRM_TYPE field.
	RTC_CR_TAMPALRM_TYPE     = 0x40000000 // Bit TAMPALRM_TYPE.
	RTC_CR_OUT2EN_Pos        = 0x1f       // Position of OUT2EN field.
	RTC_CR_OUT2EN_Msk        = 0x80000000 // Bit mask of OUT2EN field.
	RTC_CR_OUT2EN            = 0x80000000 // Bit OUT2EN.

	// WPR: write protection register
	RTC_WPR_KEY_Pos = 0x0  // Position of KEY field.
	RTC_WPR_KEY_Msk = 0xff // Bit mask of KEY field.

	// CALR: calibration register
	RTC_CALR_CALP_Pos   = 0xf    // Position of CALP field.
	RTC_CALR_CALP_Msk   = 0x8000 // Bit mask of CALP field.
	RTC_CALR_CALP       = 0x8000 // Bit CALP.
	RTC_CALR_CALW8_Pos  = 0xe    // Position of CALW8 field.
	RTC_CALR_CALW8_Msk  = 0x4000 // Bit mask of CALW8 field.
	RTC_CALR_CALW8      = 0x4000 // Bit CALW8.
	RTC_CALR_CALW16_Pos = 0xd    // Position of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000 // Bit mask of CALW16 field.
	RTC_CALR_CALW16     = 0x2000 // Bit CALW16.
	RTC_CALR_CALM_Pos   = 0x0    // Position of CALM field.
	RTC_CALR_CALM_Msk   = 0x1ff  // Bit mask of CALM field.

	// SHIFTR: shift control register
	RTC_SHIFTR_ADD1S_Pos = 0x1f       // Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000 // Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S     = 0x80000000 // Bit ADD1S.
	RTC_SHIFTR_SUBFS_Pos = 0x0        // Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff     // Bit mask of SUBFS field.

	// TSTR: time stamp time register
	RTC_TSTR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TSTR_SU_Msk  = 0xf      // Bit mask of SU field.
	RTC_TSTR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TSTR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TSTR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TSTR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TSTR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TSTR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TSTR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TSTR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TSTR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TSTR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TSTR_PM      = 0x400000 // Bit PM.

	// TSDR: time stamp date register
	RTC_TSDR_WDU_Pos = 0xd    // Position of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000 // Bit mask of WDU field.
	RTC_TSDR_MT_Pos  = 0xc    // Position of MT field.
	RTC_TSDR_MT_Msk  = 0x1000 // Bit mask of MT field.
	RTC_TSDR_MT      = 0x1000 // Bit MT.
	RTC_TSDR_MU_Pos  = 0x8    // Position of MU field.
	RTC_TSDR_MU_Msk  = 0xf00  // Bit mask of MU field.
	RTC_TSDR_DT_Pos  = 0x4    // Position of DT field.
	RTC_TSDR_DT_Msk  = 0x30   // Bit mask of DT field.
	RTC_TSDR_DU_Pos  = 0x0    // Position of DU field.
	RTC_TSDR_DU_Msk  = 0xf    // Bit mask of DU field.

	// TSSSR: timestamp sub second register
	RTC_TSSSR_SS_Pos = 0x0    // Position of SS field.
	RTC_TSSSR_SS_Msk = 0xffff // Bit mask of SS field.

	// ALRMAR: alarm A register
	RTC_ALRMAR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMAR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMAR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMAR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMAR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMAR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMAR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMAR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMAR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMAR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMAR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMAR_PM        = 0x400000   // Bit PM.
	RTC_ALRMAR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMAR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMAR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMAR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMAR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMAR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMAR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMAR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMAR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMAR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMAR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMAR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMAR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMAR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMAR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMAR_SU_Msk    = 0xf        // Bit mask of SU field.

	// ALRMASSR: alarm A sub second register
	RTC_ALRMASSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMASSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMASSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// ALRMBR: alarm B register
	RTC_ALRMBR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMBR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMBR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMBR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMBR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMBR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMBR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMBR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMBR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMBR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMBR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMBR_PM        = 0x400000   // Bit PM.
	RTC_ALRMBR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMBR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMBR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMBR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMBR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMBR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMBR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMBR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMBR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMBR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMBR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMBR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMBR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMBR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMBR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMBR_SU_Msk    = 0xf        // Bit mask of SU field.

	// ALRMBSSR: alarm B sub second register
	RTC_ALRMBSSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMBSSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMBSSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// SR: status register
	RTC_SR_ALRAF_Pos = 0x0  // Position of ALRAF field.
	RTC_SR_ALRAF_Msk = 0x1  // Bit mask of ALRAF field.
	RTC_SR_ALRAF     = 0x1  // Bit ALRAF.
	RTC_SR_ALRBF_Pos = 0x1  // Position of ALRBF field.
	RTC_SR_ALRBF_Msk = 0x2  // Bit mask of ALRBF field.
	RTC_SR_ALRBF     = 0x2  // Bit ALRBF.
	RTC_SR_WUTF_Pos  = 0x2  // Position of WUTF field.
	RTC_SR_WUTF_Msk  = 0x4  // Bit mask of WUTF field.
	RTC_SR_WUTF      = 0x4  // Bit WUTF.
	RTC_SR_TSF_Pos   = 0x3  // Position of TSF field.
	RTC_SR_TSF_Msk   = 0x8  // Bit mask of TSF field.
	RTC_SR_TSF       = 0x8  // Bit TSF.
	RTC_SR_TSOVF_Pos = 0x4  // Position of TSOVF field.
	RTC_SR_TSOVF_Msk = 0x10 // Bit mask of TSOVF field.
	RTC_SR_TSOVF     = 0x10 // Bit TSOVF.
	RTC_SR_ITSF_Pos  = 0x5  // Position of ITSF field.
	RTC_SR_ITSF_Msk  = 0x20 // Bit mask of ITSF field.
	RTC_SR_ITSF      = 0x20 // Bit ITSF.

	// MISR: masked interrupt status           register
	RTC_MISR_ALRAMF_Pos = 0x0  // Position of ALRAMF field.
	RTC_MISR_ALRAMF_Msk = 0x1  // Bit mask of ALRAMF field.
	RTC_MISR_ALRAMF     = 0x1  // Bit ALRAMF.
	RTC_MISR_ALRBMF_Pos = 0x1  // Position of ALRBMF field.
	RTC_MISR_ALRBMF_Msk = 0x2  // Bit mask of ALRBMF field.
	RTC_MISR_ALRBMF     = 0x2  // Bit ALRBMF.
	RTC_MISR_WUTMF_Pos  = 0x2  // Position of WUTMF field.
	RTC_MISR_WUTMF_Msk  = 0x4  // Bit mask of WUTMF field.
	RTC_MISR_WUTMF      = 0x4  // Bit WUTMF.
	RTC_MISR_TSMF_Pos   = 0x3  // Position of TSMF field.
	RTC_MISR_TSMF_Msk   = 0x8  // Bit mask of TSMF field.
	RTC_MISR_TSMF       = 0x8  // Bit TSMF.
	RTC_MISR_TSOVMF_Pos = 0x4  // Position of TSOVMF field.
	RTC_MISR_TSOVMF_Msk = 0x10 // Bit mask of TSOVMF field.
	RTC_MISR_TSOVMF     = 0x10 // Bit TSOVMF.
	RTC_MISR_ITSMF_Pos  = 0x5  // Position of ITSMF field.
	RTC_MISR_ITSMF_Msk  = 0x20 // Bit mask of ITSMF field.
	RTC_MISR_ITSMF      = 0x20 // Bit ITSMF.

	// SCR: status clear register
	RTC_SCR_CALRAF_Pos = 0x0  // Position of CALRAF field.
	RTC_SCR_CALRAF_Msk = 0x1  // Bit mask of CALRAF field.
	RTC_SCR_CALRAF     = 0x1  // Bit CALRAF.
	RTC_SCR_CALRBF_Pos = 0x1  // Position of CALRBF field.
	RTC_SCR_CALRBF_Msk = 0x2  // Bit mask of CALRBF field.
	RTC_SCR_CALRBF     = 0x2  // Bit CALRBF.
	RTC_SCR_CWUTF_Pos  = 0x2  // Position of CWUTF field.
	RTC_SCR_CWUTF_Msk  = 0x4  // Bit mask of CWUTF field.
	RTC_SCR_CWUTF      = 0x4  // Bit CWUTF.
	RTC_SCR_CTSF_Pos   = 0x3  // Position of CTSF field.
	RTC_SCR_CTSF_Msk   = 0x8  // Bit mask of CTSF field.
	RTC_SCR_CTSF       = 0x8  // Bit CTSF.
	RTC_SCR_CTSOVF_Pos = 0x4  // Position of CTSOVF field.
	RTC_SCR_CTSOVF_Msk = 0x10 // Bit mask of CTSOVF field.
	RTC_SCR_CTSOVF     = 0x10 // Bit CTSOVF.
	RTC_SCR_CITSF_Pos  = 0x5  // Position of CITSF field.
	RTC_SCR_CITSF_Msk  = 0x20 // Bit mask of CITSF field.
	RTC_SCR_CITSF      = 0x20 // Bit CITSF.

	// HWCFGR: hardware configuration           register
	RTC_HWCFGR_ALARMB_Pos        = 0x0       // Position of ALARMB field.
	RTC_HWCFGR_ALARMB_Msk        = 0xf       // Bit mask of ALARMB field.
	RTC_HWCFGR_WAKEUP_Pos        = 0x4       // Position of WAKEUP field.
	RTC_HWCFGR_WAKEUP_Msk        = 0xf0      // Bit mask of WAKEUP field.
	RTC_HWCFGR_SMOOTH_CALIB_Pos  = 0x8       // Position of SMOOTH_CALIB field.
	RTC_HWCFGR_SMOOTH_CALIB_Msk  = 0xf00     // Bit mask of SMOOTH_CALIB field.
	RTC_HWCFGR_TIMESTAMP_Pos     = 0xc       // Position of TIMESTAMP field.
	RTC_HWCFGR_TIMESTAMP_Msk     = 0xf000    // Bit mask of TIMESTAMP field.
	RTC_HWCFGR_OPTIONREG_OUT_Pos = 0x10      // Position of OPTIONREG_OUT field.
	RTC_HWCFGR_OPTIONREG_OUT_Msk = 0xff0000  // Bit mask of OPTIONREG_OUT field.
	RTC_HWCFGR_TRUST_ZONE_Pos    = 0x18      // Position of TRUST_ZONE field.
	RTC_HWCFGR_TRUST_ZONE_Msk    = 0xf000000 // Bit mask of TRUST_ZONE field.

	// VERR: EXTI IP Version register
	RTC_VERR_MINREV_Pos = 0x0  // Position of MINREV field.
	RTC_VERR_MINREV_Msk = 0xf  // Bit mask of MINREV field.
	RTC_VERR_MAJREV_Pos = 0x4  // Position of MAJREV field.
	RTC_VERR_MAJREV_Msk = 0xf0 // Bit mask of MAJREV field.

	// IPIDR: EXTI Identification register
	RTC_IPIDR_IPID_Pos = 0x0        // Position of IPID field.
	RTC_IPIDR_IPID_Msk = 0xffffffff // Bit mask of IPID field.

	// SIDR: EXTI Size ID register
	RTC_SIDR_SID_Pos = 0x0        // Position of SID field.
	RTC_SIDR_SID_Msk = 0xffffffff // Bit mask of SID field.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER: Interrupt Set Enable Register
	NVIC_ISER_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ICER: Interrupt Clear Enable           Register
	NVIC_ICER_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ISPR: Interrupt Set-Pending Register
	NVIC_ISPR_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ICPR: Interrupt Clear-Pending           Register
	NVIC_ICPR_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// IPR0: Interrupt Priority Register 0
	NVIC_IPR0_PRI_0_Pos = 0x0        // Position of PRI_0 field.
	NVIC_IPR0_PRI_0_Msk = 0xff       // Bit mask of PRI_0 field.
	NVIC_IPR0_PRI_1_Pos = 0x8        // Position of PRI_1 field.
	NVIC_IPR0_PRI_1_Msk = 0xff00     // Bit mask of PRI_1 field.
	NVIC_IPR0_PRI_2_Pos = 0x10       // Position of PRI_2 field.
	NVIC_IPR0_PRI_2_Msk = 0xff0000   // Bit mask of PRI_2 field.
	NVIC_IPR0_PRI_3_Pos = 0x18       // Position of PRI_3 field.
	NVIC_IPR0_PRI_3_Msk = 0xff000000 // Bit mask of PRI_3 field.

	// IPR1: Interrupt Priority Register 1
	NVIC_IPR1_PRI_4_Pos = 0x0        // Position of PRI_4 field.
	NVIC_IPR1_PRI_4_Msk = 0xff       // Bit mask of PRI_4 field.
	NVIC_IPR1_PRI_5_Pos = 0x8        // Position of PRI_5 field.
	NVIC_IPR1_PRI_5_Msk = 0xff00     // Bit mask of PRI_5 field.
	NVIC_IPR1_PRI_6_Pos = 0x10       // Position of PRI_6 field.
	NVIC_IPR1_PRI_6_Msk = 0xff0000   // Bit mask of PRI_6 field.
	NVIC_IPR1_PRI_7_Pos = 0x18       // Position of PRI_7 field.
	NVIC_IPR1_PRI_7_Msk = 0xff000000 // Bit mask of PRI_7 field.

	// IPR2: Interrupt Priority Register 2
	NVIC_IPR2_PRI_8_Pos  = 0x0        // Position of PRI_8 field.
	NVIC_IPR2_PRI_8_Msk  = 0xff       // Bit mask of PRI_8 field.
	NVIC_IPR2_PRI_9_Pos  = 0x8        // Position of PRI_9 field.
	NVIC_IPR2_PRI_9_Msk  = 0xff00     // Bit mask of PRI_9 field.
	NVIC_IPR2_PRI_10_Pos = 0x10       // Position of PRI_10 field.
	NVIC_IPR2_PRI_10_Msk = 0xff0000   // Bit mask of PRI_10 field.
	NVIC_IPR2_PRI_11_Pos = 0x18       // Position of PRI_11 field.
	NVIC_IPR2_PRI_11_Msk = 0xff000000 // Bit mask of PRI_11 field.

	// IPR3: Interrupt Priority Register 3
	NVIC_IPR3_PRI_12_Pos = 0x0        // Position of PRI_12 field.
	NVIC_IPR3_PRI_12_Msk = 0xff       // Bit mask of PRI_12 field.
	NVIC_IPR3_PRI_13_Pos = 0x8        // Position of PRI_13 field.
	NVIC_IPR3_PRI_13_Msk = 0xff00     // Bit mask of PRI_13 field.
	NVIC_IPR3_PRI_14_Pos = 0x10       // Position of PRI_14 field.
	NVIC_IPR3_PRI_14_Msk = 0xff0000   // Bit mask of PRI_14 field.
	NVIC_IPR3_PRI_15_Pos = 0x18       // Position of PRI_15 field.
	NVIC_IPR3_PRI_15_Msk = 0xff000000 // Bit mask of PRI_15 field.

	// IPR4: Interrupt Priority Register 4
	NVIC_IPR4_PRI_16_Pos = 0x0        // Position of PRI_16 field.
	NVIC_IPR4_PRI_16_Msk = 0xff       // Bit mask of PRI_16 field.
	NVIC_IPR4_PRI_17_Pos = 0x8        // Position of PRI_17 field.
	NVIC_IPR4_PRI_17_Msk = 0xff00     // Bit mask of PRI_17 field.
	NVIC_IPR4_PRI_18_Pos = 0x10       // Position of PRI_18 field.
	NVIC_IPR4_PRI_18_Msk = 0xff0000   // Bit mask of PRI_18 field.
	NVIC_IPR4_PRI_19_Pos = 0x18       // Position of PRI_19 field.
	NVIC_IPR4_PRI_19_Msk = 0xff000000 // Bit mask of PRI_19 field.

	// IPR5: Interrupt Priority Register 5
	NVIC_IPR5_PRI_20_Pos = 0x0        // Position of PRI_20 field.
	NVIC_IPR5_PRI_20_Msk = 0xff       // Bit mask of PRI_20 field.
	NVIC_IPR5_PRI_21_Pos = 0x8        // Position of PRI_21 field.
	NVIC_IPR5_PRI_21_Msk = 0xff00     // Bit mask of PRI_21 field.
	NVIC_IPR5_PRI_22_Pos = 0x10       // Position of PRI_22 field.
	NVIC_IPR5_PRI_22_Msk = 0xff0000   // Bit mask of PRI_22 field.
	NVIC_IPR5_PRI_23_Pos = 0x18       // Position of PRI_23 field.
	NVIC_IPR5_PRI_23_Msk = 0xff000000 // Bit mask of PRI_23 field.

	// IPR6: Interrupt Priority Register 6
	NVIC_IPR6_PRI_24_Pos = 0x0        // Position of PRI_24 field.
	NVIC_IPR6_PRI_24_Msk = 0xff       // Bit mask of PRI_24 field.
	NVIC_IPR6_PRI_25_Pos = 0x8        // Position of PRI_25 field.
	NVIC_IPR6_PRI_25_Msk = 0xff00     // Bit mask of PRI_25 field.
	NVIC_IPR6_PRI_26_Pos = 0x10       // Position of PRI_26 field.
	NVIC_IPR6_PRI_26_Msk = 0xff0000   // Bit mask of PRI_26 field.
	NVIC_IPR6_PRI_27_Pos = 0x18       // Position of PRI_27 field.
	NVIC_IPR6_PRI_27_Msk = 0xff000000 // Bit mask of PRI_27 field.

	// IPR7: Interrupt Priority Register 7
	NVIC_IPR7_PRI_28_Pos = 0x0        // Position of PRI_28 field.
	NVIC_IPR7_PRI_28_Msk = 0xff       // Bit mask of PRI_28 field.
	NVIC_IPR7_PRI_29_Pos = 0x8        // Position of PRI_29 field.
	NVIC_IPR7_PRI_29_Msk = 0xff00     // Bit mask of PRI_29 field.
	NVIC_IPR7_PRI_30_Pos = 0x10       // Position of PRI_30 field.
	NVIC_IPR7_PRI_30_Msk = 0xff0000   // Bit mask of PRI_30 field.
	NVIC_IPR7_PRI_31_Pos = 0x18       // Position of PRI_31 field.
	NVIC_IPR7_PRI_31_Msk = 0xff000000 // Bit mask of PRI_31 field.
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0      // Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1      // Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE     = 0x1      // Bit SEPARATE.
	MPU_MPU_TYPER_DREGION_Pos  = 0x8      // Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk  = 0xff00   // Bit mask of DREGION field.
	MPU_MPU_TYPER_IREGION_Pos  = 0x10     // Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk  = 0xff0000 // Bit mask of IREGION field.

	// MPU_CTRL: MPU control register
	MPU_MPU_CTRL_ENABLE_Pos     = 0x0 // Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk     = 0x1 // Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE         = 0x1 // Bit ENABLE.
	MPU_MPU_CTRL_HFNMIENA_Pos   = 0x1 // Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk   = 0x2 // Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA       = 0x2 // Bit HFNMIENA.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2 // Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4 // Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA     = 0x4 // Bit PRIVDEFENA.

	// MPU_RNR: MPU region number register
	MPU_MPU_RNR_REGION_Pos = 0x0  // Position of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff // Bit mask of REGION field.

	// MPU_RBAR: MPU region base address           register
	MPU_MPU_RBAR_REGION_Pos = 0x0        // Position of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf        // Bit mask of REGION field.
	MPU_MPU_RBAR_VALID_Pos  = 0x4        // Position of VALID field.
	MPU_MPU_RBAR_VALID_Msk  = 0x10       // Bit mask of VALID field.
	MPU_MPU_RBAR_VALID      = 0x10       // Bit VALID.
	MPU_MPU_RBAR_ADDR_Pos   = 0x5        // Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk   = 0xffffffe0 // Bit mask of ADDR field.

	// MPU_RASR: MPU region attribute and size           register
	MPU_MPU_RASR_ENABLE_Pos = 0x0        // Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1        // Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE     = 0x1        // Bit ENABLE.
	MPU_MPU_RASR_SIZE_Pos   = 0x1        // Position of SIZE field.
	MPU_MPU_RASR_SIZE_Msk   = 0x3e       // Bit mask of SIZE field.
	MPU_MPU_RASR_SRD_Pos    = 0x8        // Position of SRD field.
	MPU_MPU_RASR_SRD_Msk    = 0xff00     // Bit mask of SRD field.
	MPU_MPU_RASR_B_Pos      = 0x10       // Position of B field.
	MPU_MPU_RASR_B_Msk      = 0x10000    // Bit mask of B field.
	MPU_MPU_RASR_B          = 0x10000    // Bit B.
	MPU_MPU_RASR_C_Pos      = 0x11       // Position of C field.
	MPU_MPU_RASR_C_Msk      = 0x20000    // Bit mask of C field.
	MPU_MPU_RASR_C          = 0x20000    // Bit C.
	MPU_MPU_RASR_S_Pos      = 0x12       // Position of S field.
	MPU_MPU_RASR_S_Msk      = 0x40000    // Bit mask of S field.
	MPU_MPU_RASR_S          = 0x40000    // Bit S.
	MPU_MPU_RASR_TEX_Pos    = 0x13       // Position of TEX field.
	MPU_MPU_RASR_TEX_Msk    = 0x380000   // Bit mask of TEX field.
	MPU_MPU_RASR_AP_Pos     = 0x18       // Position of AP field.
	MPU_MPU_RASR_AP_Msk     = 0x7000000  // Bit mask of AP field.
	MPU_MPU_RASR_XN_Pos     = 0x1c       // Position of XN field.
	MPU_MPU_RASR_XN_Msk     = 0x10000000 // Bit mask of XN field.
	MPU_MPU_RASR_XN         = 0x10000000 // Bit XN.
)

// Bitfields for STK: SysTick timer
const (
	// CSR: SysTick control and status           register
	STK_CSR_ENABLE_Pos    = 0x0     // Position of ENABLE field.
	STK_CSR_ENABLE_Msk    = 0x1     // Bit mask of ENABLE field.
	STK_CSR_ENABLE        = 0x1     // Bit ENABLE.
	STK_CSR_TICKINT_Pos   = 0x1     // Position of TICKINT field.
	STK_CSR_TICKINT_Msk   = 0x2     // Bit mask of TICKINT field.
	STK_CSR_TICKINT       = 0x2     // Bit TICKINT.
	STK_CSR_CLKSOURCE_Pos = 0x2     // Position of CLKSOURCE field.
	STK_CSR_CLKSOURCE_Msk = 0x4     // Bit mask of CLKSOURCE field.
	STK_CSR_CLKSOURCE     = 0x4     // Bit CLKSOURCE.
	STK_CSR_COUNTFLAG_Pos = 0x10    // Position of COUNTFLAG field.
	STK_CSR_COUNTFLAG_Msk = 0x10000 // Bit mask of COUNTFLAG field.
	STK_CSR_COUNTFLAG     = 0x10000 // Bit COUNTFLAG.

	// RVR: SysTick reload value register
	STK_RVR_RELOAD_Pos = 0x0      // Position of RELOAD field.
	STK_RVR_RELOAD_Msk = 0xffffff // Bit mask of RELOAD field.

	// CVR: SysTick current value register
	STK_CVR_CURRENT_Pos = 0x0      // Position of CURRENT field.
	STK_CVR_CURRENT_Msk = 0xffffff // Bit mask of CURRENT field.

	// CALIB: SysTick calibration value           register
	STK_CALIB_TENMS_Pos = 0x0        // Position of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff   // Bit mask of TENMS field.
	STK_CALIB_SKEW_Pos  = 0x1e       // Position of SKEW field.
	STK_CALIB_SKEW_Msk  = 0x40000000 // Bit mask of SKEW field.
	STK_CALIB_SKEW      = 0x40000000 // Bit SKEW.
	STK_CALIB_NOREF_Pos = 0x1f       // Position of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000 // Bit mask of NOREF field.
	STK_CALIB_NOREF     = 0x80000000 // Bit NOREF.
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	SCB_CPUID_Revision_Pos     = 0x0        // Position of Revision field.
	SCB_CPUID_Revision_Msk     = 0xf        // Bit mask of Revision field.
	SCB_CPUID_PartNo_Pos       = 0x4        // Position of PartNo field.
	SCB_CPUID_PartNo_Msk       = 0xfff0     // Bit mask of PartNo field.
	SCB_CPUID_Architecture_Pos = 0x10       // Position of Architecture field.
	SCB_CPUID_Architecture_Msk = 0xf0000    // Bit mask of Architecture field.
	SCB_CPUID_Variant_Pos      = 0x14       // Position of Variant field.
	SCB_CPUID_Variant_Msk      = 0xf00000   // Bit mask of Variant field.
	SCB_CPUID_Implementer_Pos  = 0x18       // Position of Implementer field.
	SCB_CPUID_Implementer_Msk  = 0xff000000 // Bit mask of Implementer field.

	// ICSR: Interrupt control and state           register
	SCB_ICSR_VECTACTIVE_Pos  = 0x0        // Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk  = 0x1ff      // Bit mask of VECTACTIVE field.
	SCB_ICSR_RETTOBASE_Pos   = 0xb        // Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk   = 0x800      // Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE       = 0x800      // Bit RETTOBASE.
	SCB_ICSR_VECTPENDING_Pos = 0xc        // Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000    // Bit mask of VECTPENDING field.
	SCB_ICSR_ISRPENDING_Pos  = 0x16       // Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk  = 0x400000   // Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING      = 0x400000   // Bit ISRPENDING.
	SCB_ICSR_PENDSTCLR_Pos   = 0x19       // Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk   = 0x2000000  // Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR       = 0x2000000  // Bit PENDSTCLR.
	SCB_ICSR_PENDSTSET_Pos   = 0x1a       // Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk   = 0x4000000  // Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET       = 0x4000000  // Bit PENDSTSET.
	SCB_ICSR_PENDSVCLR_Pos   = 0x1b       // Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk   = 0x8000000  // Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR       = 0x8000000  // Bit PENDSVCLR.
	SCB_ICSR_PENDSVSET_Pos   = 0x1c       // Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk   = 0x10000000 // Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET       = 0x10000000 // Bit PENDSVSET.
	SCB_ICSR_NMIPENDSET_Pos  = 0x1f       // Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk  = 0x80000000 // Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET      = 0x80000000 // Bit NMIPENDSET.

	// VTOR: Vector table offset register
	SCB_VTOR_TBLOFF_Pos = 0x7        // Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0xffffff80 // Bit mask of TBLOFF field.

	// AIRCR: Application interrupt and reset control           register
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1        // Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2        // Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE     = 0x2        // Bit VECTCLRACTIVE.
	SCB_AIRCR_SYSRESETREQ_Pos   = 0x2        // Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk   = 0x4        // Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ       = 0x4        // Bit SYSRESETREQ.
	SCB_AIRCR_ENDIANESS_Pos     = 0xf        // Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk     = 0x8000     // Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS         = 0x8000     // Bit ENDIANESS.
	SCB_AIRCR_VECTKEYSTAT_Pos   = 0x10       // Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk   = 0xffff0000 // Bit mask of VECTKEYSTAT field.

	// SCR: System control register
	SCB_SCR_SLEEPONEXIT_Pos = 0x1  // Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2  // Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT     = 0x2  // Bit SLEEPONEXIT.
	SCB_SCR_SLEEPDEEP_Pos   = 0x2  // Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk   = 0x4  // Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP       = 0x4  // Bit SLEEPDEEP.
	SCB_SCR_SEVEONPEND_Pos  = 0x4  // Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk  = 0x10 // Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND      = 0x10 // Bit SEVEONPEND.

	// CCR: Configuration and control           register
	SCB_CCR_NONBASETHRDENA_Pos = 0x0   // Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1   // Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA     = 0x1   // Bit NONBASETHRDENA.
	SCB_CCR_USERSETMPEND_Pos   = 0x1   // Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk   = 0x2   // Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND       = 0x2   // Bit USERSETMPEND.
	SCB_CCR_UNALIGN__TRP_Pos   = 0x3   // Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk   = 0x8   // Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP       = 0x8   // Bit UNALIGN__TRP.
	SCB_CCR_DIV_0_TRP_Pos      = 0x4   // Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk      = 0x10  // Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP          = 0x10  // Bit DIV_0_TRP.
	SCB_CCR_BFHFNMIGN_Pos      = 0x8   // Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk      = 0x100 // Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN          = 0x100 // Bit BFHFNMIGN.
	SCB_CCR_STKALIGN_Pos       = 0x9   // Position of STKALIGN field.
	SCB_CCR_STKALIGN_Msk       = 0x200 // Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN           = 0x200 // Bit STKALIGN.

	// SHPR2: System handler priority           registers
	SCB_SHPR2_PRI_11_Pos = 0x18       // Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000 // Bit mask of PRI_11 field.

	// SHPR3: System handler priority           registers
	SCB_SHPR3_PRI_14_Pos = 0x10       // Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000   // Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_15_Pos = 0x18       // Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000 // Bit mask of PRI_15 field.
)
