/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.Algorithm;
import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.Manifest;
import com.sun.org.apache.xml.internal.security.signature.ReferenceNotInitializedException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.signature.reference.ReferenceData;
import com.sun.org.apache.xml.internal.security.signature.reference.ReferenceNodeSetData;
import com.sun.org.apache.xml.internal.security.signature.reference.ReferenceOctetStreamData;
import com.sun.org.apache.xml.internal.security.signature.reference.ReferenceSubTreeData;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.transforms.params.InclusiveNamespaces;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Reference
extends SignatureElementProxy {
    public static final String OBJECT_URI = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String MANIFEST_URI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    public static final int MAXIMUM_TRANSFORM_COUNT = 5;
    private boolean secureValidation;
    private static boolean useC14N11 = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.org.apache.xml.internal.security.useC14N11"));
    private static final Logger LOG = LoggerFactory.getLogger(Reference.class);
    private Manifest manifest;
    private XMLSignatureInput transformsOutput;
    private Transforms transforms;
    private Element digestMethodElem;
    private Element digestValueElement;
    private ReferenceData referenceData;

    protected Reference(Document document, String string, String string2, Manifest manifest, Transforms transforms, String string3) throws XMLSignatureException {
        super(document);
        this.addReturnToSelf();
        this.baseURI = string;
        this.manifest = manifest;
        this.setURI(string2);
        if (transforms != null) {
            this.transforms = transforms;
            this.appendSelf(transforms);
            this.addReturnToSelf();
        }
        Algorithm algorithm = new Algorithm(this.getDocument(), string3){

            @Override
            public String getBaseNamespace() {
                return "http://www.w3.org/2000/09/xmldsig#";
            }

            @Override
            public String getBaseLocalName() {
                return "DigestMethod";
            }
        };
        this.digestMethodElem = algorithm.getElement();
        this.appendSelf(this.digestMethodElem);
        this.addReturnToSelf();
        this.digestValueElement = XMLUtils.createElementInSignatureSpace(this.getDocument(), "DigestValue");
        this.appendSelf(this.digestValueElement);
        this.addReturnToSelf();
    }

    protected Reference(Element element, String string, Manifest manifest) throws XMLSecurityException {
        this(element, string, manifest, true);
    }

    protected Reference(Element element, String string, Manifest manifest, boolean bl) throws XMLSecurityException {
        super(element, string);
        this.secureValidation = bl;
        this.baseURI = string;
        Element element2 = XMLUtils.getNextElement(element.getFirstChild());
        if (element2 != null && "Transforms".equals(element2.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(element2.getNamespaceURI())) {
            this.transforms = new Transforms(element2, this.baseURI);
            this.transforms.setSecureValidation(bl);
            if (bl && this.transforms.getLength() > 5) {
                Object[] objectArray = new Object[]{this.transforms.getLength(), 5};
                throw new XMLSecurityException("signature.tooManyTransforms", objectArray);
            }
            element2 = XMLUtils.getNextElement(element2.getNextSibling());
        }
        this.digestMethodElem = element2;
        if (this.digestMethodElem == null) {
            throw new XMLSecurityException("signature.Reference.NoDigestMethod");
        }
        this.digestValueElement = XMLUtils.getNextElement(this.digestMethodElem.getNextSibling());
        if (this.digestValueElement == null) {
            throw new XMLSecurityException("signature.Reference.NoDigestValue");
        }
        this.manifest = manifest;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        if (this.digestMethodElem == null) {
            return null;
        }
        String string = this.digestMethodElem.getAttributeNS(null, "Algorithm");
        if ("".equals(string)) {
            return null;
        }
        if (this.secureValidation && "http://www.w3.org/2001/04/xmldsig-more#md5".equals(string)) {
            Object[] objectArray = new Object[]{string};
            throw new XMLSignatureException("signature.signatureAlgorithm", objectArray);
        }
        return MessageDigestAlgorithm.getInstance(this.getDocument(), string);
    }

    public void setURI(String string) {
        if (string != null) {
            this.setLocalAttribute("URI", string);
        }
    }

    public String getURI() {
        return this.getLocalAttribute("URI");
    }

    public void setId(String string) {
        if (string != null) {
            this.setLocalIdAttribute("Id", string);
        }
    }

    public String getId() {
        return this.getLocalAttribute("Id");
    }

    public void setType(String string) {
        if (string != null) {
            this.setLocalAttribute("Type", string);
        }
    }

    public String getType() {
        return this.getLocalAttribute("Type");
    }

    public boolean typeIsReferenceToObject() {
        return OBJECT_URI.equals(this.getType());
    }

    public boolean typeIsReferenceToManifest() {
        return MANIFEST_URI.equals(this.getType());
    }

    private void setDigestValueElement(byte[] byArray) {
        for (Node node = this.digestValueElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.digestValueElement.removeChild(node);
        }
        String string = Base64.getMimeEncoder().encodeToString(byArray);
        Text text = this.createText(string);
        this.digestValueElement.appendChild(text);
    }

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        this.setDigestValueElement(this.calculateDigest(false));
    }

    public XMLSignatureInput getContentsBeforeTransformation() throws ReferenceNotInitializedException {
        try {
            Attr attr = this.getElement().getAttributeNodeNS(null, "URI");
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, this.baseURI, this.manifest.getPerManifestResolvers(), this.secureValidation);
            resourceResolver.addProperties(this.manifest.getResolverProperties());
            return resourceResolver.resolve(attr, this.baseURI, this.secureValidation);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new ReferenceNotInitializedException(resourceResolverException);
        }
    }

    private XMLSignatureInput getContentsAfterTransformation(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws XMLSignatureException {
        try {
            Transforms transforms = this.getTransforms();
            XMLSignatureInput xMLSignatureInput2 = null;
            if (transforms != null) {
                this.transformsOutput = xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput, outputStream);
            } else {
                xMLSignatureInput2 = xMLSignatureInput;
            }
            return xMLSignatureInput2;
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException(resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException(canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException(invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException(transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException(xMLSecurityException);
        }
    }

    public XMLSignatureInput getContentsAfterTransformation() throws XMLSignatureException {
        XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
        this.cacheDereferencedElement(xMLSignatureInput);
        return this.getContentsAfterTransformation(xMLSignatureInput, null);
    }

    public XMLSignatureInput getNodesetBeforeFirstCanonicalization() throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
            this.cacheDereferencedElement(xMLSignatureInput);
            XMLSignatureInput xMLSignatureInput2 = xMLSignatureInput;
            Transforms transforms = this.getTransforms();
            if (transforms != null) {
                Transform transform;
                String string;
                for (int i = 0; !(i >= transforms.getLength() || (string = (transform = transforms.item(i)).getURI()).equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || string.equals("http://www.w3.org/2006/12/xml-c14n11") || string.equals("http://www.w3.org/2006/12/xml-c14n11#WithComments")); ++i) {
                    xMLSignatureInput2 = transform.performTransform(xMLSignatureInput2, null);
                }
                xMLSignatureInput2.setSourceURI(xMLSignatureInput.getSourceURI());
            }
            return xMLSignatureInput2;
        }
        catch (IOException iOException) {
            throw new XMLSignatureException(iOException);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException(resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException(canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException(invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException(transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException(xMLSecurityException);
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        try {
            ElementProxy elementProxy;
            XMLSignatureInput xMLSignatureInput = this.getNodesetBeforeFirstCanonicalization();
            Transforms transforms = this.getTransforms();
            ElementProxy elementProxy2 = null;
            if (transforms != null) {
                for (int i = 0; i < transforms.getLength(); ++i) {
                    elementProxy = transforms.item(i);
                    String string = ((Transform)elementProxy).getURI();
                    if (!string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) continue;
                    elementProxy2 = elementProxy;
                    break;
                }
            }
            Set<String> set = new HashSet<String>();
            if (elementProxy2 != null && elementProxy2.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                elementProxy = new InclusiveNamespaces(XMLUtils.selectNode(elementProxy2.getElement().getFirstChild(), "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", 0), this.getBaseURI());
                set = InclusiveNamespaces.prefixStr2Set(((InclusiveNamespaces)elementProxy).getInclusiveNamespaces());
            }
            return xMLSignatureInput.getHTMLRepresentation(set);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException(transformationException);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new XMLSignatureException(invalidTransformException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException(xMLSecurityException);
        }
    }

    public XMLSignatureInput getTransformsOutput() {
        return this.transformsOutput;
    }

    public ReferenceData getReferenceData() {
        return this.referenceData;
    }

    protected XMLSignatureInput dereferenceURIandPerformTransforms(OutputStream outputStream) throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput;
            XMLSignatureInput xMLSignatureInput2 = this.getContentsBeforeTransformation();
            this.cacheDereferencedElement(xMLSignatureInput2);
            this.transformsOutput = xMLSignatureInput = this.getContentsAfterTransformation(xMLSignatureInput2, outputStream);
            return xMLSignatureInput;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException(xMLSecurityException);
        }
    }

    private void cacheDereferencedElement(XMLSignatureInput xMLSignatureInput) {
        if (xMLSignatureInput.isNodeSet()) {
            try {
                final Set<Node> set = xMLSignatureInput.getNodeSet();
                this.referenceData = new ReferenceNodeSetData(){

                    @Override
                    public Iterator<Node> iterator() {
                        return new Iterator<Node>(){
                            Iterator<Node> sIterator;
                            {
                                this.sIterator = set.iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.sIterator.hasNext();
                            }

                            @Override
                            public Node next() {
                                return this.sIterator.next();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }
            catch (Exception exception) {
                LOG.warn("cannot cache dereferenced data: " + exception);
            }
        } else if (xMLSignatureInput.isElement()) {
            this.referenceData = new ReferenceSubTreeData(xMLSignatureInput.getSubNode(), xMLSignatureInput.isExcludeComments());
        } else if (xMLSignatureInput.isOctetStream() || xMLSignatureInput.isByteArray()) {
            try {
                this.referenceData = new ReferenceOctetStreamData(xMLSignatureInput.getOctetStream(), xMLSignatureInput.getSourceURI(), xMLSignatureInput.getMIMEType());
            }
            catch (IOException iOException) {
                LOG.warn("cannot cache dereferenced data: " + iOException);
            }
        }
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        return this.transforms;
    }

    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.dereferenceURIandPerformTransforms(null);
            return xMLSignatureInput.getBytes();
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException(iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException(canonicalizationException);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] calculateDigest(boolean var1_1) throws ReferenceNotInitializedException, XMLSignatureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] getPreCalculatedDigest(XMLSignatureInput xMLSignatureInput) throws ReferenceNotInitializedException {
        LOG.debug("Verifying element with pre-calculated digest");
        String string = xMLSignatureInput.getPreCalculatedDigest();
        return Base64.getMimeDecoder().decode(string);
    }

    public byte[] getDigestValue() throws XMLSecurityException {
        if (this.digestValueElement == null) {
            Object[] objectArray = new Object[]{"DigestValue", "http://www.w3.org/2000/09/xmldsig#"};
            throw new XMLSecurityException("signature.Verification.NoSignatureElement", objectArray);
        }
        String string = XMLUtils.getFullTextChildrenFromElement(this.digestValueElement);
        return Base64.getMimeDecoder().decode(string);
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        byte[] byArray;
        byte[] byArray2 = this.getDigestValue();
        boolean bl = MessageDigestAlgorithm.isEqual(byArray2, byArray = this.calculateDigest(true));
        if (!bl) {
            LOG.warn("Verification failed for URI \"" + this.getURI() + "\"");
            LOG.warn("Expected Digest: " + Base64.getMimeEncoder().encodeToString(byArray2));
            LOG.warn("Actual Digest: " + Base64.getMimeEncoder().encodeToString(byArray));
        } else {
            LOG.debug("Verification successful for URI \"{}\"", this.getURI());
        }
        return bl;
    }

    @Override
    public String getBaseLocalName() {
        return "Reference";
    }
}

