/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.coderegion;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.ResultsSnapshot;

public final class CodeRegionResultsSnapshot
extends ResultsSnapshot {
    private static final String CODE_FRAGMENT_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.coderegion.Bundle").getString("CodeRegionResultsSnapshot_CodeFragmentMsg");
    private long[] rawData;
    private long timerCountsInSecond;

    public CodeRegionResultsSnapshot(long l, long l2, long[] lArray, long l3) {
        super(l, l2);
        this.rawData = lArray;
        this.timerCountsInSecond = l3;
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public CodeRegionResultsSnapshot() {
    }

    public int getInvocations() {
        if (this.rawData == null) {
            return 0;
        }
        return this.rawData.length;
    }

    public long getTimerCountsInSecond() {
        return this.timerCountsInSecond;
    }

    public long[] getTimes() {
        return this.rawData;
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        super.readFromStream(dataInputStream);
        this.timerCountsInSecond = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        this.rawData = new long[n];
        for (int i = 0; i < n; ++i) {
            this.rawData[i] = dataInputStream.readLong();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public String toString() {
        return MessageFormat.format(CODE_FRAGMENT_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeLong(this.timerCountsInSecond);
        dataOutputStream.writeInt(this.rawData.length);
        for (int i = 0; i < this.rawData.length; ++i) {
            dataOutputStream.writeLong(this.rawData[i]);
        }
    }

    private void debugValues() {
        LOGGER.finest("rawData.length: " + this.debugLength(this.rawData));
        LOGGER.finest("timerCountsInSecond: " + this.timerCountsInSecond);
    }
}

