/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Xpp3DomBuilder {
    private static final boolean DEFAULT_TRIM = true;

    public static Xpp3Dom build(Reader reader2) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader2, null);
    }

    public static Xpp3Dom build(Reader reader2, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader2, true, locationBuilder);
    }

    public static Xpp3Dom build(InputStream is2, String encoding2) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(is2, encoding2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(InputStream is2, String encoding2, boolean trim2) throws XmlPullParserException, IOException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(is2, encoding2);
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser, trim2);
            is2.close();
            is2 = null;
            Xpp3Dom xpp3Dom2 = xpp3Dom;
            return xpp3Dom2;
        }
        finally {
            IOUtil.close(is2);
        }
    }

    public static Xpp3Dom build(Reader reader2, boolean trim2) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader2, trim2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(Reader reader2, boolean trim2, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(reader2);
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser, trim2, locationBuilder);
            reader2.close();
            reader2 = null;
            Xpp3Dom xpp3Dom2 = xpp3Dom;
            return xpp3Dom2;
        }
        finally {
            IOUtil.close(reader2);
        }
    }

    public static Xpp3Dom build(XmlPullParser parser) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser, true);
    }

    public static Xpp3Dom build(XmlPullParser parser, boolean trim2) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser, trim2, null);
    }

    public static Xpp3Dom build(XmlPullParser parser, boolean trim2, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuilder> values = new ArrayList<StringBuilder>();
        int eventType = parser.getEventType();
        boolean spacePreserve = false;
        while (eventType != 1) {
            if (eventType == 2) {
                int depth;
                spacePreserve = false;
                String rawName = parser.getName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                if (locationBuilder != null) {
                    childConfiguration.setInputLocation(locationBuilder.toInputLocation(parser));
                }
                if ((depth = elements.size()) > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                if (parser.isEmptyElementTag()) {
                    values.add(null);
                } else {
                    values.add(new StringBuilder());
                }
                int attributesSize = parser.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name2 = parser.getAttributeName(i);
                    String value = parser.getAttributeValue(i);
                    childConfiguration.setAttribute(name2, value);
                    spacePreserve = spacePreserve || "xml:space".equals(name2) && "preserve".equals(value);
                }
            } else if (eventType == 4) {
                int depth = values.size() - 1;
                StringBuilder valueBuffer = (StringBuilder)values.get(depth);
                String text = parser.getText();
                if (trim2 && !spacePreserve) {
                    text = text.trim();
                }
                valueBuffer.append(text);
            } else if (eventType == 3) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                Object accumulatedValue = values.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = parser.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public static interface InputLocationBuilder {
        public Object toInputLocation(XmlPullParser var1);
    }
}

