#ifndef ETEBASE_H
#define ETEBASE_H

/* Generated with cbindgen:0.14.4 */

/* Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
// +1 so we fake ceil it
#define ETEBASE_UTILS_FROM_BASE64_MAX_LEN(X) (((X) * 3U / 4U) + 1U)

// +2 so we fake ceil it + terminating null
#define ETEBASE_UTILS_TO_BASE64_MAX_LEN(X) (((X) * 4U / 3U) + 2U)

#define ETEBASE_UTILS_C_ARRAY_LEN(arr) (sizeof(arr) / sizeof((arr)[0]))


enum EtebaseCollectionAccessLevel
#ifdef __cplusplus
  : uint32_t
#endif // __cplusplus
 {
  ETEBASE_COLLECTION_ACCESS_LEVEL_READ_ONLY,
  ETEBASE_COLLECTION_ACCESS_LEVEL_ADMIN,
  ETEBASE_COLLECTION_ACCESS_LEVEL_READ_WRITE,
};
#ifndef __cplusplus
typedef uint32_t EtebaseCollectionAccessLevel;
#endif // __cplusplus

enum EtebaseErrorCode
#ifdef __cplusplus
  : uint32_t
#endif // __cplusplus
 {
  ETEBASE_ERROR_CODE_NO_ERROR,
  ETEBASE_ERROR_CODE_GENERIC,
  ETEBASE_ERROR_CODE_URL_PARSE,
  ETEBASE_ERROR_CODE_MSG_PACK,
  ETEBASE_ERROR_CODE_PROGRAMMING_ERROR,
  ETEBASE_ERROR_CODE_MISSING_CONTENT,
  ETEBASE_ERROR_CODE_PADDING,
  ETEBASE_ERROR_CODE_BASE64,
  ETEBASE_ERROR_CODE_ENCRYPTION,
  ETEBASE_ERROR_CODE_UNAUTHORIZED,
  ETEBASE_ERROR_CODE_CONFLICT,
  ETEBASE_ERROR_CODE_PERMISSION_DENIED,
  ETEBASE_ERROR_CODE_NOT_FOUND,
  ETEBASE_ERROR_CODE_CONNECTION,
  ETEBASE_ERROR_CODE_TEMPORARY_SERVER_ERROR,
  ETEBASE_ERROR_CODE_SERVER_ERROR,
  ETEBASE_ERROR_CODE_HTTP,
};
#ifndef __cplusplus
typedef uint32_t EtebaseErrorCode;
#endif // __cplusplus

enum EtebasePrefetchOption
#ifdef __cplusplus
  : uint32_t
#endif // __cplusplus
 {
  ETEBASE_PREFETCH_OPTION_AUTO,
  ETEBASE_PREFETCH_OPTION_MEDIUM,
};
#ifndef __cplusplus
typedef uint32_t EtebasePrefetchOption;
#endif // __cplusplus

typedef struct EtebaseAccount EtebaseAccount;

typedef struct EtebaseClient EtebaseClient;

typedef struct EtebaseCollection EtebaseCollection;

typedef struct EtebaseCollectionInvitationManager EtebaseCollectionInvitationManager;

typedef struct EtebaseCollectionListResponse_Collection EtebaseCollectionListResponse_Collection;

typedef struct EtebaseCollectionManager EtebaseCollectionManager;

typedef struct EtebaseCollectionMember EtebaseCollectionMember;

typedef struct EtebaseCollectionMemberManager EtebaseCollectionMemberManager;

typedef struct EtebaseFetchOptions EtebaseFetchOptions;

typedef struct EtebaseFileSystemCache EtebaseFileSystemCache;

typedef struct EtebaseItem EtebaseItem;

typedef struct EtebaseItemListResponse_Item EtebaseItemListResponse_Item;

typedef struct EtebaseItemManager EtebaseItemManager;

typedef struct EtebaseItemMetadata EtebaseItemMetadata;

typedef struct EtebaseIteratorListResponse_CollectionMember EtebaseIteratorListResponse_CollectionMember;

typedef struct EtebaseIteratorListResponse_Item EtebaseIteratorListResponse_Item;

typedef struct EtebaseIteratorListResponse_SignedInvitation EtebaseIteratorListResponse_SignedInvitation;

typedef struct EtebaseRemovedCollection EtebaseRemovedCollection;

typedef struct EtebaseSignedInvitation EtebaseSignedInvitation;

typedef struct EtebaseUser EtebaseUser;

typedef struct EtebaseUserProfile EtebaseUserProfile;

typedef EtebaseCollectionListResponse_Collection EtebaseCollectionListResponse;

typedef EtebaseItemListResponse_Item EtebaseItemListResponse;

typedef EtebaseIteratorListResponse_Item EtebaseItemRevisionsListResponse;

typedef EtebaseIteratorListResponse_SignedInvitation EtebaseInvitationListResponse;

typedef EtebaseIteratorListResponse_CollectionMember EtebaseMemberListResponse;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

extern const uintptr_t ETEBASE_UTILS_PRETTY_FINGERPRINT_SIZE;

EtebaseErrorCode etebase_error_get_code(void);

const char *etebase_error_get_message(void);

const char *etebase_get_default_server_url(void);

int32_t etebase_utils_from_base64(const char *string,
                                  void *buf,
                                  uintptr_t buf_maxlen,
                                  uintptr_t *buf_len);

int32_t etebase_utils_to_base64(const void *bytes,
                                uintptr_t bytes_size,
                                char *out,
                                uintptr_t out_maxlen);

int32_t etebase_utils_randombytes(void *buf, uintptr_t size);

int32_t etebase_utils_pretty_fingerprint(const void *content, uintptr_t content_size, char *buf);

EtebaseClient *etebase_client_new(const char *client_name, const char *server_url);

int32_t etebase_client_set_server_url(EtebaseClient *this_, const char *server_url);

/**
 * Returns 0 if client is pointing an etebase server, 1 if not, -1 on error
 */
int32_t etebase_client_check_etebase_server(const EtebaseClient *client);

void etebase_client_destroy(EtebaseClient *this_);

EtebaseUser *etebase_user_new(const char *username, const char *email);

void etebase_user_set_username(EtebaseUser *this_, const char *username);

const char *etebase_user_get_username(const EtebaseUser *this_);

void etebase_user_set_email(EtebaseUser *this_, const char *email);

const char *etebase_user_get_email(const EtebaseUser *this_);

void etebase_user_destroy(EtebaseUser *this_);

EtebaseAccount *etebase_account_login(const EtebaseClient *client,
                                      const char *username,
                                      const char *password);

EtebaseAccount *etebase_account_signup(const EtebaseClient *client,
                                       const EtebaseUser *user,
                                       const char *password);

int32_t etebase_account_fetch_token(EtebaseAccount *this_);

char *etebase_account_fetch_dashboard_url(const EtebaseAccount *this_);

int32_t etebase_account_force_server_url(EtebaseAccount *this_, const char *server_url);

int32_t etebase_account_change_password(EtebaseAccount *this_, const char *password);

int32_t etebase_account_logout(EtebaseAccount *this_);

EtebaseCollectionManager *etebase_account_get_collection_manager(const EtebaseAccount *this_);

EtebaseCollectionInvitationManager *etebase_account_get_invitation_manager(const EtebaseAccount *this_);

char *etebase_account_save(const EtebaseAccount *this_,
                           const void *encryption_key,
                           uintptr_t encryption_key_size);

EtebaseAccount *etebase_account_restore(const EtebaseClient *client,
                                        const char *account_data_stored,
                                        const void *encryption_key,
                                        uintptr_t encryption_key_size);

void etebase_account_destroy(EtebaseAccount *this_);

const char *etebase_removed_collection_get_uid(const EtebaseRemovedCollection *this_);

void etebase_removed_collection_destroy(EtebaseRemovedCollection *this_);

const char *etebase_collection_list_response_get_stoken(const EtebaseCollectionListResponse *this_);

int32_t etebase_collection_list_response_get_data(const EtebaseCollectionListResponse *this_,
                                                  const EtebaseCollection **data);

uintptr_t etebase_collection_list_response_get_data_length(const EtebaseCollectionListResponse *this_);

bool etebase_collection_list_response_is_done(const EtebaseCollectionListResponse *this_);

int32_t etebase_collection_list_response_get_removed_memberships(const EtebaseCollectionListResponse *this_,
                                                                 const EtebaseRemovedCollection **data);

uintptr_t etebase_collection_list_response_get_removed_memberships_length(const EtebaseCollectionListResponse *this_);

void etebase_collection_list_response_destroy(EtebaseCollectionListResponse *this_);

const char *etebase_item_list_response_get_stoken(const EtebaseItemListResponse *this_);

int32_t etebase_item_list_response_get_data(const EtebaseItemListResponse *this_,
                                            const EtebaseItem **data);

uintptr_t etebase_item_list_response_get_data_length(const EtebaseItemListResponse *this_);

bool etebase_item_list_response_is_done(const EtebaseItemListResponse *this_);

void etebase_item_list_response_destroy(EtebaseItemListResponse *this_);

const char *etebase_item_revisions_list_response_get_iterator(const EtebaseItemRevisionsListResponse *this_);

int32_t etebase_item_revisions_list_response_get_data(const EtebaseItemRevisionsListResponse *this_,
                                                      const EtebaseItem **data);

uintptr_t etebase_item_revisions_list_response_get_data_length(const EtebaseItemRevisionsListResponse *this_);

bool etebase_item_revisions_list_response_is_done(const EtebaseItemRevisionsListResponse *this_);

void etebase_item_revisions_list_response_destroy(EtebaseItemRevisionsListResponse *this_);

EtebaseFetchOptions *etebase_fetch_options_new(void);

void etebase_fetch_options_set_limit(EtebaseFetchOptions *this_, uintptr_t limit);

void etebase_fetch_options_set_prefetch(EtebaseFetchOptions *this_, EtebasePrefetchOption prefetch);

void etebase_fetch_options_set_with_collection(EtebaseFetchOptions *this_, bool with_collection);

void etebase_fetch_options_set_iterator(EtebaseFetchOptions *this_, const char *iterator);

void etebase_fetch_options_set_stoken(EtebaseFetchOptions *this_, const char *stoken);

void etebase_fetch_options_destroy(EtebaseFetchOptions *this_);

EtebaseItemMetadata *etebase_item_metadata_new(void);

void etebase_item_metadata_set_item_type(EtebaseItemMetadata *this_, const char *item_type);

const char *etebase_item_metadata_get_item_type(const EtebaseItemMetadata *this_);

void etebase_item_metadata_set_name(EtebaseItemMetadata *this_, const char *name);

const char *etebase_item_metadata_get_name(const EtebaseItemMetadata *this_);

void etebase_item_metadata_set_mtime(EtebaseItemMetadata *this_, const int64_t *mtime);

const int64_t *etebase_item_metadata_get_mtime(const EtebaseItemMetadata *this_);

void etebase_item_metadata_set_description(EtebaseItemMetadata *this_, const char *description);

const char *etebase_item_metadata_get_description(const EtebaseItemMetadata *this_);

void etebase_item_metadata_set_color(EtebaseItemMetadata *this_, const char *color);

const char *etebase_item_metadata_get_color(const EtebaseItemMetadata *this_);

void etebase_item_metadata_destroy(EtebaseItemMetadata *this_);

EtebaseCollection *etebase_collection_manager_fetch(const EtebaseCollectionManager *this_,
                                                    const char *col_uid,
                                                    const EtebaseFetchOptions *fetch_options);

EtebaseCollection *etebase_collection_manager_create(const EtebaseCollectionManager *this_,
                                                     const char *collection_type,
                                                     const EtebaseItemMetadata *meta,
                                                     const void *content,
                                                     uintptr_t content_size);

EtebaseCollection *etebase_collection_manager_create_raw(const EtebaseCollectionManager *this_,
                                                         const char *collection_type,
                                                         const void *meta,
                                                         uintptr_t meta_size,
                                                         const void *content,
                                                         uintptr_t content_size);

EtebaseItemManager *etebase_collection_manager_get_item_manager(const EtebaseCollectionManager *this_,
                                                                const EtebaseCollection *col);

EtebaseCollectionListResponse *etebase_collection_manager_list(const EtebaseCollectionManager *this_,
                                                               const char *collection_type,
                                                               const EtebaseFetchOptions *fetch_options);

EtebaseCollectionListResponse *etebase_collection_manager_list_multi(const EtebaseCollectionManager *this_,
                                                                     const char *const *collection_types,
                                                                     uintptr_t collection_types_size,
                                                                     const EtebaseFetchOptions *fetch_options);

int32_t etebase_collection_manager_upload(const EtebaseCollectionManager *this_,
                                          const EtebaseCollection *collection,
                                          const EtebaseFetchOptions *fetch_options);

int32_t etebase_collection_manager_transaction(const EtebaseCollectionManager *this_,
                                               const EtebaseCollection *collection,
                                               const EtebaseFetchOptions *fetch_options);

EtebaseCollection *etebase_collection_manager_cache_load(const EtebaseCollectionManager *this_,
                                                         const void *cached,
                                                         uintptr_t cached_size);

void *etebase_collection_manager_cache_save(const EtebaseCollectionManager *this_,
                                            const EtebaseCollection *collection,
                                            uintptr_t *ret_size);

void *etebase_collection_manager_cache_save_with_content(const EtebaseCollectionManager *this_,
                                                         const EtebaseCollection *collection,
                                                         uintptr_t *ret_size);

EtebaseCollectionMemberManager *etebase_collection_manager_get_member_manager(const EtebaseCollectionManager *this_,
                                                                              const EtebaseCollection *col);

void etebase_collection_manager_destroy(EtebaseCollectionManager *this_);

EtebaseItem *etebase_item_manager_fetch(const EtebaseItemManager *this_,
                                        const char *item_uid,
                                        const EtebaseFetchOptions *fetch_options);

EtebaseItem *etebase_item_manager_create(const EtebaseItemManager *this_,
                                         const EtebaseItemMetadata *meta,
                                         const void *content,
                                         uintptr_t content_size);

EtebaseItem *etebase_item_manager_create_raw(const EtebaseItemManager *this_,
                                             const void *meta,
                                             uintptr_t meta_size,
                                             const void *content,
                                             uintptr_t content_size);

EtebaseItemListResponse *etebase_item_manager_list(const EtebaseItemManager *this_,
                                                   const EtebaseFetchOptions *fetch_options);

EtebaseItemRevisionsListResponse *etebase_item_manager_item_revisions(const EtebaseItemManager *this_,
                                                                      const EtebaseItem *item,
                                                                      const EtebaseFetchOptions *fetch_options);

EtebaseItemListResponse *etebase_item_manager_fetch_updates(const EtebaseItemManager *this_,
                                                            const EtebaseItem *const *items,
                                                            uintptr_t items_size,
                                                            const EtebaseFetchOptions *fetch_options);

int32_t etebase_item_manager_batch(const EtebaseItemManager *this_,
                                   const EtebaseItem *const *items,
                                   uintptr_t items_size,
                                   const EtebaseFetchOptions *fetch_options);

int32_t etebase_item_manager_batch_deps(const EtebaseItemManager *this_,
                                        const EtebaseItem *const *items,
                                        uintptr_t items_size,
                                        const EtebaseItem *const *deps,
                                        uintptr_t deps_size,
                                        const EtebaseFetchOptions *fetch_options);

int32_t etebase_item_manager_transaction(const EtebaseItemManager *this_,
                                         const EtebaseItem *const *items,
                                         uintptr_t items_size,
                                         const EtebaseFetchOptions *fetch_options);

int32_t etebase_item_manager_transaction_deps(const EtebaseItemManager *this_,
                                              const EtebaseItem *const *items,
                                              uintptr_t items_size,
                                              const EtebaseItem *const *deps,
                                              uintptr_t deps_size,
                                              const EtebaseFetchOptions *fetch_options);

EtebaseItem *etebase_item_manager_cache_load(const EtebaseItemManager *this_,
                                             const void *cached,
                                             uintptr_t cached_size);

void *etebase_item_manager_cache_save(const EtebaseItemManager *this_,
                                      const EtebaseItem *item,
                                      uintptr_t *ret_size);

void *etebase_item_manager_cache_save_with_content(const EtebaseItemManager *this_,
                                                   const EtebaseItem *item,
                                                   uintptr_t *ret_size);

void etebase_item_manager_destroy(EtebaseItemManager *this_);

EtebaseCollection *etebase_collection_clone(const EtebaseCollection *this_);

bool etebase_collection_verify(const EtebaseCollection *this_);

int32_t etebase_collection_set_meta(EtebaseCollection *this_, const EtebaseItemMetadata *meta);

EtebaseItemMetadata *etebase_collection_get_meta(const EtebaseCollection *this_);

int32_t etebase_collection_set_meta_raw(EtebaseCollection *this_,
                                        const void *meta,
                                        uintptr_t meta_size);

/**
 * Returns the actual size of the data whether buf is NULL or not.
 * Writes at most buf_size to buf, and buf is *NOT* null terminated.
 */
intptr_t etebase_collection_get_meta_raw(const EtebaseCollection *this_,
                                         void *buf,
                                         uintptr_t buf_size);

int32_t etebase_collection_set_content(EtebaseCollection *this_,
                                       const void *content,
                                       uintptr_t content_size);

/**
 * Returns the actual size of the data whether buf is NULL or not.
 * Writes at most buf_size to buf, and buf is *NOT* null terminated.
 */
intptr_t etebase_collection_get_content(const EtebaseCollection *this_,
                                        void *buf,
                                        uintptr_t buf_size);

int32_t etebase_collection_delete(EtebaseCollection *this_);

bool etebase_collection_is_deleted(const EtebaseCollection *this_);

const char *etebase_collection_get_uid(const EtebaseCollection *this_);

const char *etebase_collection_get_etag(const EtebaseCollection *this_);

const char *etebase_collection_get_stoken(const EtebaseCollection *this_);

EtebaseItem *etebase_collection_as_item(const EtebaseCollection *this_);

char *etebase_collection_get_collection_type(const EtebaseCollection *this_);

EtebaseCollectionAccessLevel etebase_collection_get_access_level(const EtebaseCollection *this_);

void etebase_collection_destroy(EtebaseCollection *this_);

EtebaseItem *etebase_item_clone(const EtebaseItem *this_);

bool etebase_item_verify(const EtebaseItem *this_);

int32_t etebase_item_set_meta(EtebaseItem *this_, const EtebaseItemMetadata *meta);

EtebaseItemMetadata *etebase_item_get_meta(const EtebaseItem *this_);

int32_t etebase_item_set_meta_raw(EtebaseItem *this_, const void *meta, uintptr_t meta_size);

/**
 * Returns the actual size of the data whether buf is NULL or not.
 * Writes at most buf_size to buf, and buf is *NOT* null terminated.
 */
intptr_t etebase_item_get_meta_raw(const EtebaseItem *this_, void *buf, uintptr_t buf_size);

int32_t etebase_item_set_content(EtebaseItem *this_, const void *content, uintptr_t content_size);

/**
 * Returns the actual size of the data whether buf is NULL or not.
 * Writes at most buf_size to buf, and buf is *NOT* null terminated.
 */
intptr_t etebase_item_get_content(const EtebaseItem *this_, void *buf, uintptr_t buf_size);

int32_t etebase_item_delete(EtebaseItem *this_);

bool etebase_item_is_deleted(const EtebaseItem *this_);

const char *etebase_item_get_uid(const EtebaseItem *this_);

const char *etebase_item_get_etag(const EtebaseItem *this_);

void etebase_item_destroy(EtebaseItem *this_);

const void *etebase_user_profile_get_pubkey(const EtebaseUserProfile *this_);

uintptr_t etebase_user_profile_get_pubkey_size(const EtebaseUserProfile *this_);

void etebase_user_profile_destroy(EtebaseUserProfile *this_);

const char *etebase_invitation_list_response_get_iterator(const EtebaseInvitationListResponse *this_);

int32_t etebase_invitation_list_response_get_data(const EtebaseInvitationListResponse *this_,
                                                  const EtebaseSignedInvitation **data);

uintptr_t etebase_invitation_list_response_get_data_length(const EtebaseInvitationListResponse *this_);

bool etebase_invitation_list_response_is_done(const EtebaseInvitationListResponse *this_);

void etebase_invitation_list_response_destroy(EtebaseInvitationListResponse *this_);

EtebaseInvitationListResponse *etebase_invitation_manager_list_incoming(const EtebaseCollectionInvitationManager *this_,
                                                                        const EtebaseFetchOptions *fetch_options);

EtebaseInvitationListResponse *etebase_invitation_manager_list_outgoing(const EtebaseCollectionInvitationManager *this_,
                                                                        const EtebaseFetchOptions *fetch_options);

int32_t etebase_invitation_manager_accept(const EtebaseCollectionInvitationManager *this_,
                                          const EtebaseSignedInvitation *invitation);

int32_t etebase_invitation_manager_reject(const EtebaseCollectionInvitationManager *this_,
                                          const EtebaseSignedInvitation *invitation);

EtebaseUserProfile *etebase_invitation_manager_fetch_user_profile(const EtebaseCollectionInvitationManager *this_,
                                                                  const char *username);

int32_t etebase_invitation_manager_invite(const EtebaseCollectionInvitationManager *this_,
                                          const EtebaseCollection *collection,
                                          const char *username,
                                          const void *pubkey,
                                          uintptr_t pubkey_size,
                                          EtebaseCollectionAccessLevel access_level);

int32_t etebase_invitation_manager_disinvite(const EtebaseCollectionInvitationManager *this_,
                                             const EtebaseSignedInvitation *invitation);

const void *etebase_invitation_manager_get_pubkey(const EtebaseCollectionInvitationManager *this_);

uintptr_t etebase_invitation_manager_get_pubkey_size(const EtebaseCollectionInvitationManager *this_);

void etebase_invitation_manager_destroy(EtebaseCollectionInvitationManager *this_);

EtebaseSignedInvitation *etebase_signed_invitation_clone(const EtebaseSignedInvitation *this_);

const char *etebase_signed_invitation_get_uid(const EtebaseSignedInvitation *this_);

const char *etebase_signed_invitation_get_username(const EtebaseSignedInvitation *this_);

const char *etebase_signed_invitation_get_collection(const EtebaseSignedInvitation *this_);

EtebaseCollectionAccessLevel etebase_signed_invitation_get_access_level(const EtebaseSignedInvitation *this_);

const void *etebase_signed_invitation_get_from_username(const EtebaseSignedInvitation *this_);

const void *etebase_signed_invitation_get_from_pubkey(const EtebaseSignedInvitation *this_);

uintptr_t etebase_signed_invitation_get_from_pubkey_size(const EtebaseSignedInvitation *this_);

void etebase_signed_invitation_destroy(EtebaseSignedInvitation *this_);

EtebaseCollectionMember *etebase_collection_member_clone(const EtebaseCollectionMember *this_);

const char *etebase_collection_member_get_username(const EtebaseCollectionMember *this_);

EtebaseCollectionAccessLevel etebase_collection_member_get_access_level(const EtebaseCollectionMember *this_);

void etebase_collection_member_destroy(EtebaseCollectionMember *this_);

const char *etebase_member_list_response_get_iterator(const EtebaseMemberListResponse *this_);

int32_t etebase_member_list_response_get_data(const EtebaseMemberListResponse *this_,
                                              const EtebaseCollectionMember **data);

uintptr_t etebase_member_list_response_get_data_length(const EtebaseMemberListResponse *this_);

bool etebase_member_list_response_is_done(const EtebaseMemberListResponse *this_);

void etebase_member_list_response_destroy(EtebaseMemberListResponse *this_);

EtebaseMemberListResponse *etebase_collection_member_manager_list(const EtebaseCollectionMemberManager *this_,
                                                                  const EtebaseFetchOptions *fetch_options);

int32_t etebase_collection_member_manager_remove(const EtebaseCollectionMemberManager *this_,
                                                 const char *username);

int32_t etebase_collection_member_manager_leave(const EtebaseCollectionMemberManager *this_);

int32_t etebase_collection_member_manager_modify_access_level(const EtebaseCollectionMemberManager *this_,
                                                              const char *username,
                                                              EtebaseCollectionAccessLevel access_level);

void etebase_collection_member_manager_destroy(EtebaseCollectionMemberManager *this_);

EtebaseFileSystemCache *etebase_fs_cache_new(const char *path, const char *username);

int32_t etebase_fs_cache_clear_user(const EtebaseFileSystemCache *this_);

int32_t etebase_fs_cache_save_account(const EtebaseFileSystemCache *this_,
                                      const EtebaseAccount *etebase,
                                      const void *encryption_key,
                                      uintptr_t encryption_key_size);

EtebaseAccount *etebase_fs_cache_load_account(const EtebaseFileSystemCache *this_,
                                              const EtebaseClient *client,
                                              const void *encryption_key,
                                              uintptr_t encryption_key_size);

int32_t etebase_fs_cache_save_stoken(const EtebaseFileSystemCache *this_, const char *stoken);

char *etebase_fs_cache_load_stoken(const EtebaseFileSystemCache *this_);

int32_t etebase_fs_cache_collection_save_stoken(const EtebaseFileSystemCache *this_,
                                                const char *col_uid,
                                                const char *stoken);

char *etebase_fs_cache_collection_load_stoken(const EtebaseFileSystemCache *this_,
                                              const char *col_uid);

int32_t etebase_fs_cache_collection_set(const EtebaseFileSystemCache *this_,
                                        const EtebaseCollectionManager *col_mgr,
                                        const EtebaseCollection *col);

int32_t etebase_fs_cache_collection_unset(const EtebaseFileSystemCache *this_,
                                          const EtebaseCollectionManager *col_mgr,
                                          const char *col_uid);

EtebaseCollection *etebase_fs_cache_collection_get(const EtebaseFileSystemCache *this_,
                                                   const EtebaseCollectionManager *col_mgr,
                                                   const char *col_uid);

int32_t etebase_fs_cache_item_set(const EtebaseFileSystemCache *this_,
                                  const EtebaseItemManager *item_mgr,
                                  const char *col_uid,
                                  const EtebaseItem *item);

int32_t etebase_fs_cache_item_unset(const EtebaseFileSystemCache *this_,
                                    const EtebaseItemManager *item_mgr,
                                    const char *col_uid,
                                    const char *item_uid);

EtebaseItem *etebase_fs_cache_item_get(const EtebaseFileSystemCache *this_,
                                       const EtebaseItemManager *item_mgr,
                                       const char *col_uid,
                                       const char *item_uid);

void etebase_fs_cache_destroy(EtebaseFileSystemCache *this_);

#ifdef __cplusplus
} // extern "C"
#endif // __cplusplus

#endif /* ETEBASE_H */
