/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.security.SecurityUtil;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.res.StringManager;

public class InputBuffer
extends Reader
implements ByteChunk.ByteInputChannel,
CharChunk.CharInputChannel,
CharChunk.CharOutputChannel {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.connector");
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private final ByteChunk bb;
    private CharChunk cb;
    private int state = 0;
    private boolean closed = false;
    private String enc;
    private boolean gotEnc = false;
    private final Map<String, B2CConverter> encoders = new ConcurrentHashMap<String, B2CConverter>();
    protected B2CConverter conv;
    private Request coyoteRequest;
    private int markPos = -1;
    private int size = -1;

    public InputBuffer() {
        this(8192);
    }

    public InputBuffer(int n) {
        this.size = n;
        this.bb = new ByteChunk(n);
        this.bb.setLimit(n);
        this.bb.setByteInputChannel((ByteChunk.ByteInputChannel)this);
        this.cb = new CharChunk(n);
        this.cb.setLimit(n);
        this.cb.setOptimizedWrite(false);
        this.cb.setCharInputChannel((CharChunk.CharInputChannel)this);
        this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
    }

    public void setRequest(Request request) {
        this.coyoteRequest = request;
    }

    @Deprecated
    public Request getRequest() {
        return this.coyoteRequest;
    }

    public void recycle() {
        this.state = 0;
        if (this.cb.getChars().length > this.size) {
            this.cb = new CharChunk(this.size);
            this.cb.setLimit(this.size);
            this.cb.setOptimizedWrite(false);
            this.cb.setCharInputChannel((CharChunk.CharInputChannel)this);
            this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
        } else {
            this.cb.recycle();
        }
        this.markPos = -1;
        this.bb.recycle();
        this.closed = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
    }

    public void clearEncoders() {
        this.encoders.clear();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public int available() {
        int n = 0;
        if (this.state == 2) {
            n = this.bb.getLength();
        } else if (this.state == 1) {
            n = this.cb.getLength();
        }
        if (n == 0) {
            this.coyoteRequest.action(ActionCode.AVAILABLE, null);
            n = this.coyoteRequest.getAvailable() > 0 ? 1 : 0;
        }
        return n;
    }

    public int realReadBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.coyoteRequest == null) {
            return -1;
        }
        if (this.state == 0) {
            this.state = 2;
        }
        int n3 = this.coyoteRequest.doRead(this.bb);
        return n3;
    }

    public int readByte() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.bb.substract();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.bb.substract(byArray, n, n2);
    }

    public void realWriteChars(char[] cArray, int n, int n2) throws IOException {
        this.markPos = -1;
        this.cb.setOffset(0);
        this.cb.setEnd(0);
    }

    public void setEncoding(String string) {
        this.enc = string;
    }

    public int realReadChars(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (!this.gotEnc) {
            this.setConverter();
        }
        boolean bl = false;
        if (this.bb.getLength() <= 0 && (n3 = this.realReadBytes(this.bb.getBytes(), 0, this.bb.getBytes().length)) < 0) {
            bl = true;
        }
        if (this.markPos == -1) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        } else {
            this.cb.makeSpace(this.bb.getLength());
            if (this.cb.getBuffer().length - this.cb.getEnd() == 0 && this.bb.getLength() != 0) {
                this.cb.setOffset(0);
                this.cb.setEnd(0);
                this.markPos = -1;
            }
        }
        this.state = 1;
        this.conv.convert(this.bb, this.cb, bl);
        if (this.cb.getLength() == 0 && bl) {
            return -1;
        }
        return this.cb.getLength();
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.cb.substract();
    }

    @Override
    public int read(char[] cArray) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.cb.substract(cArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        while (l2 < l) {
            if ((long)this.cb.getLength() >= l) {
                this.cb.setOffset(this.cb.getStart() + (int)l);
                l2 = l;
                continue;
            }
            this.cb.setOffset(this.cb.getEnd());
            int n = 0;
            n = (long)this.cb.getChars().length < l - (l2 += (long)this.cb.getLength()) ? this.cb.getChars().length : (int)(l - l2);
            int n2 = this.realReadChars(this.cb.getChars(), 0, n);
            if (n2 >= 0) continue;
            break;
        }
        return l2;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.available() > 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.cb.getLength() <= 0) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        } else if (this.cb.getBuffer().length > 2 * this.size && this.cb.getLength() < this.cb.getStart()) {
            System.arraycopy(this.cb.getBuffer(), this.cb.getStart(), this.cb.getBuffer(), 0, this.cb.getLength());
            this.cb.setEnd(this.cb.getLength());
            this.cb.setOffset(0);
        }
        this.cb.setLimit(this.cb.getStart() + n + this.size);
        this.markPos = this.cb.getStart();
    }

    @Override
    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.state == 1) {
            if (this.markPos < 0) {
                this.cb.recycle();
                this.markPos = -1;
                throw new IOException();
            }
            this.cb.setOffset(this.markPos);
        } else {
            this.bb.recycle();
        }
    }

    public void checkConverter() throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
    }

    protected void setConverter() throws IOException {
        if (this.coyoteRequest != null) {
            this.enc = this.coyoteRequest.getCharacterEncoding();
        }
        this.gotEnc = true;
        if (this.enc == null) {
            this.enc = DEFAULT_ENCODING;
        }
        this.conv = this.encoders.get(this.enc);
        if (this.conv == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    this.conv = AccessController.doPrivileged(new PrivilegedExceptionAction<B2CConverter>(){

                        @Override
                        public B2CConverter run() throws IOException {
                            return new B2CConverter(InputBuffer.this.enc);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new IOException(exception);
                }
            } else {
                this.conv = new B2CConverter(this.enc);
            }
            this.encoders.put(this.enc, this.conv);
        }
    }
}

