/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class WARDirContext
extends BaseDirContext {
    private static final Log log = LogFactory.getLog(WARDirContext.class);
    protected ZipFile base = null;
    protected Entry entries = null;

    public WARDirContext() {
    }

    public WARDirContext(Hashtable<String, Object> hashtable) {
        super(hashtable);
    }

    protected WARDirContext(ZipFile zipFile, Entry entry) {
        this.base = zipFile;
        this.entries = entry;
    }

    @Override
    public void setDocBase(String string) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("resources.null"));
        }
        if (!string.endsWith(".war")) {
            throw new IllegalArgumentException(sm.getString("warResources.notWar"));
        }
        File file = new File(string);
        if (!file.exists() || !file.canRead() || file.isDirectory()) {
            throw new IllegalArgumentException(sm.getString("warResources.invalidWar", string));
        }
        try {
            this.base = new ZipFile(file);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(sm.getString("warResources.invalidWar", exception.getMessage()));
        }
        super.setDocBase(string);
        this.loadEntries();
    }

    @Override
    public void release() {
        this.entries = null;
        if (this.base != null) {
            try {
                this.base.close();
            }
            catch (IOException iOException) {
                log.warn((Object)("Exception closing WAR File " + this.base.getName()), (Throwable)iOException);
            }
        }
        this.base = null;
        super.release();
    }

    @Override
    protected String doGetRealPath(String string) {
        return null;
    }

    @Override
    protected Object doLookup(String string) {
        Name name;
        try {
            name = this.getEscapedJndiName(string);
        }
        catch (InvalidNameException invalidNameException) {
            log.info((Object)sm.getString("resources.invalidName", string), (Throwable)invalidNameException);
            return null;
        }
        if (name.isEmpty()) {
            return this;
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            return null;
        }
        ZipEntry zipEntry = entry.getEntry();
        if (zipEntry.isDirectory()) {
            return new WARDirContext(this.base, entry);
        }
        return new WARResource(entry.getEntry());
    }

    private Name getEscapedJndiName(String string) throws InvalidNameException {
        return new CompositeName(string.replace("'", "\\'").replace("\"", ""));
    }

    @Override
    public void unbind(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    protected List<NamingEntry> doListBindings(String string) throws NamingException {
        Name name = this.getEscapedJndiName(string);
        if (name.isEmpty()) {
            return this.list(this.entries);
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            return null;
        }
        return this.list(entry);
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    @Override
    protected Attributes doGetAttributes(String string, String[] stringArray) throws NamingException {
        return this.getAttributes(this.getEscapedJndiName(string), stringArray);
    }

    @Override
    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        Entry entry = null;
        entry = name.isEmpty() ? this.entries : this.treeLookup(name);
        if (entry == null) {
            return null;
        }
        ZipEntry zipEntry = entry.getEntry();
        ResourceAttributes resourceAttributes = new ResourceAttributes();
        resourceAttributes.setCreationDate(new Date(zipEntry.getTime()));
        resourceAttributes.setName(entry.getName());
        if (!zipEntry.isDirectory()) {
            resourceAttributes.setResourceType("");
        } else {
            resourceAttributes.setCollection(true);
        }
        resourceAttributes.setContentLength(zipEntry.getSize());
        resourceAttributes.setLastModified(zipEntry.getTime());
        return resourceAttributes;
    }

    @Override
    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchema(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, SearchControls searchControls) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected String normalize(ZipEntry zipEntry) {
        String string = "/" + zipEntry.getName();
        if (zipEntry.isDirectory()) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected void loadEntries() {
        try {
            Enumeration<? extends ZipEntry> enumeration = this.base.entries();
            this.entries = new Entry("/", new ZipEntry("/"));
            while (enumeration.hasMoreElements()) {
                Entry entry;
                Object object;
                Name name;
                Object object2;
                ZipEntry zipEntry = enumeration.nextElement();
                String string = this.normalize(zipEntry);
                int n = string.lastIndexOf(47);
                int n2 = -1;
                int n3 = 0;
                while ((n2 = string.indexOf(47, n3)) != -1) {
                    object2 = this.getEscapedJndiName(string.substring(0, n3));
                    name = this.getEscapedJndiName(string.substring(0, n2));
                    object = string.substring(n3, n2);
                    entry = this.treeLookup((Name)object2);
                    Entry entry2 = this.treeLookup(name);
                    if (entry2 == null) {
                        String string2 = string.substring(1, n2) + "/";
                        entry2 = new Entry((String)object, new ZipEntry(string2));
                        if (entry != null) {
                            entry.addChild(entry2);
                        }
                    }
                    n3 = n2 + 1;
                }
                object2 = string.substring(n + 1, string.length());
                name = this.getEscapedJndiName(string.substring(0, n));
                object = this.treeLookup(name);
                entry = new Entry((String)object2, zipEntry);
                if (object == null) continue;
                ((Entry)object).addChild(entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Entry treeLookup(Name name) {
        if (name.isEmpty() || this.entries == null) {
            return this.entries;
        }
        Entry entry = this.entries;
        for (int i = 0; i < name.size(); ++i) {
            if (name.get(i).length() == 0 || (entry = entry.getChild(name.get(i))) != null) continue;
            return null;
        }
        return entry;
    }

    protected ArrayList<NamingEntry> list(Entry entry) {
        ArrayList<NamingEntry> arrayList = new ArrayList<NamingEntry>();
        Entry[] entryArray = entry.getChildren();
        NamingEntry namingEntry = null;
        for (int i = 0; i < entryArray.length; ++i) {
            ZipEntry zipEntry = entryArray[i].getEntry();
            Object object = null;
            object = zipEntry.isDirectory() ? new WARDirContext(this.base, entryArray[i]) : new WARResource(zipEntry);
            namingEntry = new NamingEntry(entryArray[i].getName(), object, 0);
            arrayList.add(namingEntry);
        }
        return arrayList;
    }

    protected class WARResource
    extends Resource {
        protected ZipEntry entry;

        public WARResource(ZipEntry zipEntry) {
            this.entry = zipEntry;
        }

        @Override
        public InputStream streamContent() throws IOException {
            try {
                if (this.binaryContent == null) {
                    InputStream inputStream;
                    this.inputStream = inputStream = WARDirContext.this.base.getInputStream(this.entry);
                    return inputStream;
                }
            }
            catch (ZipException zipException) {
                throw new IOException(zipException.getMessage(), zipException);
            }
            return super.streamContent();
        }
    }

    protected static class Entry
    implements Comparable<Object> {
        protected String name = null;
        protected ZipEntry entry = null;
        protected Entry[] children = new Entry[0];
        protected volatile boolean childrenSorted = false;

        public Entry(String string, ZipEntry zipEntry) {
            this.name = string;
            this.entry = zipEntry;
        }

        @Override
        public int compareTo(Object object) {
            if (!(object instanceof Entry)) {
                return 1;
            }
            return this.name.compareTo(((Entry)object).getName());
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            return this.name.equals(((Entry)object).getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public ZipEntry getEntry() {
            return this.entry;
        }

        public String getName() {
            return this.name;
        }

        public void addChild(Entry entry) {
            Entry[] entryArray = new Entry[this.children.length + 1];
            for (int i = 0; i < this.children.length; ++i) {
                entryArray[i] = this.children[i];
            }
            entryArray[this.children.length] = entry;
            this.children = entryArray;
            this.childrenSorted = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Entry[] getChildren() {
            if (this.childrenSorted) return this.children;
            Entry[] entryArray = this.children;
            synchronized (this.children) {
                if (this.childrenSorted) return this.children;
                Arrays.sort(this.children);
                this.childrenSorted = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.children;
            }
        }

        public Entry getChild(String string) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].name.equals(string)) continue;
                return this.children[i];
            }
            return null;
        }
    }
}

