/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.Socket;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.Http11Processor;
import org.apache.coyote.http11.upgrade.BioProcessor;
import org.apache.coyote.http11.upgrade.UpgradeBioProcessor;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Protocol
extends AbstractHttp11JsseProtocol<Socket> {
    private static final Log log = LogFactory.getLog(Http11Protocol.class);
    protected Http11ConnectionHandler cHandler;
    private int disableKeepAlivePercentage = 75;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11Protocol() {
        this.endpoint = new JIoEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((JIoEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public int getDisableKeepAlivePercentage() {
        return this.disableKeepAlivePercentage;
    }

    public void setDisableKeepAlivePercentage(int n) {
        this.disableKeepAlivePercentage = n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    @Override
    protected String getNamePrefix() {
        return "http-bio";
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler<Socket, Http11Processor>
    implements JIoEndpoint.Handler {
        protected Http11Protocol proto;

        Http11ConnectionHandler(Http11Protocol http11Protocol) {
            this.proto = http11Protocol;
        }

        @Override
        protected AbstractProtocol<Socket> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return this.proto.sslImplementation;
        }

        @Override
        public void release(SocketWrapper<Socket> socketWrapper, Processor<Socket> processor, boolean bl, boolean bl2) {
            processor.recycle(bl);
            this.recycledProcessors.offer(processor);
        }

        @Override
        protected void initSsl(SocketWrapper<Socket> socketWrapper, Processor<Socket> processor) {
            if (this.proto.isSSLEnabled() && this.proto.sslImplementation != null) {
                processor.setSslSupport(this.proto.sslImplementation.getSSLSupport(socketWrapper.getSocket()));
            } else {
                processor.setSslSupport(null);
            }
        }

        @Override
        protected void longPoll(SocketWrapper<Socket> socketWrapper, Processor<Socket> processor) {
        }

        @Override
        protected Http11Processor createProcessor() {
            Http11Processor http11Processor = new Http11Processor(this.proto.getMaxHttpHeaderSize(), this.proto.getRejectIllegalHeader(), (JIoEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize(), this.proto.getAllowedTrailerHeadersAsSet(), this.proto.getMaxExtensionSize(), this.proto.getMaxSwallowSize(), this.proto.getRelaxedPathChars(), this.proto.getRelaxedQueryChars());
            this.proto.configureProcessor(http11Processor);
            http11Processor.setDisableKeepAlivePercentage(this.proto.getDisableKeepAlivePercentage());
            this.register(http11Processor);
            return http11Processor;
        }

        @Override
        @Deprecated
        protected Processor<Socket> createUpgradeProcessor(SocketWrapper<Socket> socketWrapper, UpgradeInbound upgradeInbound) throws IOException {
            return new UpgradeBioProcessor(socketWrapper, upgradeInbound);
        }

        @Override
        protected Processor<Socket> createUpgradeProcessor(SocketWrapper<Socket> socketWrapper, HttpUpgradeHandler httpUpgradeHandler) throws IOException {
            return new BioProcessor(socketWrapper, httpUpgradeHandler, this.proto.getUpgradeAsyncWriteBufferSize());
        }
    }
}

