/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.util.http.parser.HttpParser;

public class AcceptEncoding {
    private final String encoding;
    private final double quality;

    protected AcceptEncoding(String string, double d) {
        this.encoding = string;
        this.quality = d;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public double getQuality() {
        return this.quality;
    }

    public static List<AcceptEncoding> parse(StringReader stringReader) throws IOException {
        ArrayList<AcceptEncoding> arrayList = new ArrayList<AcceptEncoding>();
        while (true) {
            String string;
            if ((string = HttpParser.readToken(stringReader)) == null) {
                HttpParser.skipUntil(stringReader, 0, ',');
                continue;
            }
            if (string.length() == 0) break;
            double d = 1.0;
            HttpParser.SkipResult skipResult = HttpParser.skipConstant(stringReader, ";");
            if (skipResult == HttpParser.SkipResult.FOUND) {
                d = HttpParser.readWeight(stringReader, ',');
            }
            if (!(d > 0.0)) continue;
            arrayList.add(new AcceptEncoding(string, d));
        }
        return arrayList;
    }
}

