/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JarResource;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.jasper.compiler.TldLocation;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

class TagLibraryInfoImpl
extends TagLibraryInfo
implements TagConstants {
    private final Log log;
    private JspCompilationContext ctxt;
    private PageInfo pi;
    private ErrorDispatcher err;
    private ParserController parserController;
    protected TagLibraryValidator tagLibraryValidator;

    private final void print(String string, String string2, PrintWriter printWriter) {
        if (string2 != null) {
            printWriter.print(string + " = {\n\t");
            printWriter.print(string2);
            printWriter.print("\n}\n");
        }
    }

    public String toString() {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.print("tlibversion", this.tlibversion, printWriter);
        this.print("jspversion", this.jspversion, printWriter);
        this.print("shortname", this.shortname, printWriter);
        this.print("urn", this.urn, printWriter);
        this.print("info", this.info, printWriter);
        this.print("uri", this.uri, printWriter);
        this.print("tagLibraryValidator", "" + this.tagLibraryValidator, printWriter);
        for (n = 0; n < this.tags.length; ++n) {
            printWriter.println(this.tags[n].toString());
        }
        for (n = 0; n < this.tagFiles.length; ++n) {
            printWriter.println(this.tagFiles[n].toString());
        }
        for (n = 0; n < this.functions.length; ++n) {
            printWriter.println(this.functions[n].toString());
        }
        return stringWriter.toString();
    }

    private InputStream getResourceAsStream(String string) throws FileNotFoundException {
        if (string.startsWith("file:")) {
            return new FileInputStream(new File(string.substring(5)));
        }
        try {
            String string2 = this.ctxt.getRealPath(string);
            if (string2 == null) {
                return this.ctxt.getResourceAsStream(string);
            }
            return new FileInputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this.ctxt.getResourceAsStream(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagLibraryInfoImpl(JspCompilationContext jspCompilationContext, ParserController parserController, PageInfo pageInfo, String string, String string2, TldLocation tldLocation, ErrorDispatcher errorDispatcher, Mark mark) throws JasperException {
        block16: {
            super(string, string2);
            this.log = LogFactory.getLog(TagLibraryInfoImpl.class);
            this.ctxt = jspCompilationContext;
            this.parserController = parserController;
            this.pi = pageInfo;
            this.err = errorDispatcher;
            InputStream inputStream = null;
            if (tldLocation == null) {
                tldLocation = this.generateTLDLocation(this.uri, jspCompilationContext);
            }
            String string3 = tldLocation.getName();
            JarResource jarResource = tldLocation.getJarResource();
            try {
                if (jarResource == null) {
                    try {
                        inputStream = this.getResourceAsStream(string3);
                        if (inputStream == null) {
                            throw new FileNotFoundException(string3);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        errorDispatcher.jspError(mark, "jsp.error.file.not.found", string3);
                    }
                    this.parseTLD(string3, inputStream, null);
                    PageInfo pageInfo2 = jspCompilationContext.createCompiler().getPageInfo();
                    if (pageInfo2 != null) {
                        pageInfo2.addDependant(string3, jspCompilationContext.getLastModified(string3));
                    }
                    break block16;
                }
                try {
                    inputStream = jarResource.getEntry(string3).openStream();
                    this.parseTLD(jarResource.getUrl(), inputStream, jarResource);
                }
                catch (Exception exception) {
                    errorDispatcher.jspError(mark, "jsp.error.tld.unable_to_read", jarResource.getUrl(), string3, exception.toString());
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable(throwable);
                    }
                }
            }
        }
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        Collection<TagLibraryInfo> collection = this.pi.getTaglibs();
        return collection.toArray(new TagLibraryInfo[0]);
    }

    private void parseTLD(String string, InputStream inputStream, JarResource jarResource) throws JasperException {
        Object object;
        Vector<TagInfo> vector = new Vector<TagInfo>();
        Vector<TagFileInfo> vector2 = new Vector<TagFileInfo>();
        Hashtable<String, TagFileInfo> hashtable = new Hashtable<String, TagFileInfo>();
        ServletContext servletContext = this.ctxt.getServletContext();
        boolean bl = Boolean.parseBoolean(servletContext.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
        String string2 = servletContext.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
        boolean bl2 = string2 == null ? true : Boolean.parseBoolean(string2);
        ParserUtils parserUtils = new ParserUtils(bl, bl2);
        TreeNode treeNode = parserUtils.parseXMLDocument(string, inputStream);
        this.jspversion = treeNode.findAttribute("version");
        Iterator<TreeNode> iterator = treeNode.findChildren();
        while (iterator.hasNext()) {
            TagFileInfo tagFileInfo;
            TreeNode treeNode2 = iterator.next();
            object = treeNode2.getName();
            if ("tlibversion".equals(object) || "tlib-version".equals(object)) {
                this.tlibversion = treeNode2.getBody();
                continue;
            }
            if ("jspversion".equals(object) || "jsp-version".equals(object)) {
                this.jspversion = treeNode2.getBody();
                continue;
            }
            if ("shortname".equals(object) || "short-name".equals(object)) {
                this.shortname = treeNode2.getBody();
                continue;
            }
            if ("uri".equals(object)) {
                this.urn = treeNode2.getBody();
                continue;
            }
            if ("info".equals(object) || "description".equals(object)) {
                this.info = treeNode2.getBody();
                continue;
            }
            if ("validator".equals(object)) {
                this.tagLibraryValidator = this.createValidator(treeNode2);
                continue;
            }
            if ("tag".equals(object)) {
                vector.addElement(this.createTagInfo(treeNode2, this.jspversion));
                continue;
            }
            if ("tag-file".equals(object)) {
                tagFileInfo = this.createTagFileInfo(treeNode2, jarResource);
                vector2.addElement(tagFileInfo);
                continue;
            }
            if ("function".equals(object)) {
                tagFileInfo = this.createFunctionInfo(treeNode2);
                String string3 = tagFileInfo.getName();
                if (hashtable.containsKey(string3)) {
                    this.err.jspError("jsp.error.tld.fn.duplicate.name", string3, string);
                }
                hashtable.put(string3, tagFileInfo);
                continue;
            }
            if ("display-name".equals(object) || "small-icon".equals(object) || "large-icon".equals(object) || "listener".equals(object) || "taglib-extension".equals(object) || !this.log.isWarnEnabled()) continue;
            this.log.warn((Object)Localizer.getMessage("jsp.warning.unknown.element.in.taglib", object));
        }
        if (this.tlibversion == null) {
            this.err.jspError("jsp.error.tld.mandatory.element.missing", "tlib-version", string);
        }
        if (this.jspversion == null) {
            this.err.jspError("jsp.error.tld.mandatory.element.missing", "jsp-version", string);
        }
        this.tags = new TagInfo[vector.size()];
        vector.copyInto(this.tags);
        this.tagFiles = new TagFileInfo[vector2.size()];
        vector2.copyInto(this.tagFiles);
        this.functions = new FunctionInfo[hashtable.size()];
        int n = 0;
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            this.functions[n++] = (FunctionInfo)object.nextElement();
        }
    }

    private TldLocation generateTLDLocation(String string, JspCompilationContext jspCompilationContext) throws JasperException {
        int n = TldLocationsCache.uriType(string);
        if (n == 0) {
            this.err.jspError("jsp.error.taglibDirective.absUriCannotBeResolved", string);
        } else if (n == 2) {
            string = jspCompilationContext.resolveRelativeUri(string);
        }
        if (string.endsWith(".jar")) {
            URL uRL = null;
            try {
                uRL = jspCompilationContext.getResource(string);
            }
            catch (Exception exception) {
                this.err.jspError("jsp.error.tld.unable_to_get_jar", string, exception.toString());
            }
            if (uRL == null) {
                this.err.jspError("jsp.error.tld.missing_jar", string);
            }
            return new TldLocation("META-INF/taglib.tld", uRL.toString());
        }
        if (string.startsWith("/WEB-INF/lib/") || string.startsWith("/WEB-INF/classes/") || string.startsWith("/WEB-INF/tags/") && string.endsWith(".tld") && !string.endsWith("implicit.tld")) {
            this.err.jspError("jsp.error.tld.invalid_tld_file", string);
        }
        return new TldLocation(string);
    }

    private TagInfo createTagInfo(TreeNode treeNode, String string) throws JasperException {
        Object object;
        Object object2;
        TreeNode treeNode2;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "JSP";
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        boolean bl = false;
        Vector<TagAttributeInfo> vector = new Vector<TagAttributeInfo>();
        Vector<TagVariableInfo> vector2 = new Vector<TagVariableInfo>();
        Iterator<TreeNode> iterator = treeNode.findChildren();
        while (iterator.hasNext()) {
            treeNode2 = iterator.next();
            object2 = treeNode2.getName();
            if ("name".equals(object2)) {
                string2 = treeNode2.getBody();
                continue;
            }
            if ("tagclass".equals(object2) || "tag-class".equals(object2)) {
                string3 = treeNode2.getBody();
                continue;
            }
            if ("teiclass".equals(object2) || "tei-class".equals(object2)) {
                string4 = treeNode2.getBody();
                continue;
            }
            if ("bodycontent".equals(object2) || "body-content".equals(object2)) {
                string5 = treeNode2.getBody();
                continue;
            }
            if ("display-name".equals(object2)) {
                string7 = treeNode2.getBody();
                continue;
            }
            if ("small-icon".equals(object2)) {
                string8 = treeNode2.getBody();
                continue;
            }
            if ("large-icon".equals(object2)) {
                string9 = treeNode2.getBody();
                continue;
            }
            if ("icon".equals(object2)) {
                object = treeNode2.findChild("small-icon");
                if (object != null) {
                    string8 = ((TreeNode)object).getBody();
                }
                if ((object = treeNode2.findChild("large-icon")) == null) continue;
                string9 = ((TreeNode)object).getBody();
                continue;
            }
            if ("info".equals(object2) || "description".equals(object2)) {
                string6 = treeNode2.getBody();
                continue;
            }
            if ("variable".equals(object2)) {
                vector2.addElement(this.createVariable(treeNode2));
                continue;
            }
            if ("attribute".equals(object2)) {
                vector.addElement(this.createAttribute(treeNode2, string));
                continue;
            }
            if ("dynamic-attributes".equals(object2)) {
                bl = JspUtil.booleanValue(treeNode2.getBody());
                continue;
            }
            if ("example".equals(object2) || "tag-extension".equals(object2) || !this.log.isWarnEnabled()) continue;
            this.log.warn((Object)Localizer.getMessage("jsp.warning.unknown.element.in.tag", object2));
        }
        treeNode2 = null;
        if (string4 != null && !string4.equals("")) {
            try {
                object2 = this.ctxt.getClassLoader().loadClass(string4);
                treeNode2 = (TagExtraInfo)((Class)object2).newInstance();
            }
            catch (Exception exception) {
                this.err.jspError(exception, "jsp.error.teiclass.instantiation", string4);
            }
        }
        object2 = new TagAttributeInfo[vector.size()];
        vector.copyInto((Object[])object2);
        object = new TagVariableInfo[vector2.size()];
        vector2.copyInto((Object[])object);
        TagInfo tagInfo = new TagInfo(string2, string3, string5, string6, (TagLibraryInfo)this, (TagExtraInfo)treeNode2, (TagAttributeInfo[])object2, string7, string8, string9, (TagVariableInfo[])object, bl);
        return tagInfo;
    }

    private TagFileInfo createTagFileInfo(TreeNode treeNode, JarResource jarResource) throws JasperException {
        TreeNode treeNode2;
        String string = null;
        String string2 = null;
        Iterator<TreeNode> iterator = treeNode.findChildren();
        while (iterator.hasNext()) {
            treeNode2 = iterator.next();
            String string3 = treeNode2.getName();
            if ("name".equals(string3)) {
                string = treeNode2.getBody();
                continue;
            }
            if ("path".equals(string3)) {
                string2 = treeNode2.getBody();
                continue;
            }
            if ("example".equals(string3) || "tag-extension".equals(string3) || "icon".equals(string3) || "display-name".equals(string3) || "description".equals(string3) || !this.log.isWarnEnabled()) continue;
            this.log.warn((Object)Localizer.getMessage("jsp.warning.unknown.element.in.tagfile", string3));
        }
        if (string2 == null) {
            this.err.jspError("jsp.error.tagfile.missingPath");
        } else if (string2.startsWith("/META-INF/tags")) {
            this.ctxt.setTagFileJarResource(string2, jarResource);
        } else if (!string2.startsWith("/WEB-INF/tags")) {
            this.err.jspError("jsp.error.tagfile.illegalPath", string2);
        }
        treeNode2 = TagFileProcessor.parseTagFileDirectives(this.parserController, string, string2, jarResource, this);
        return new TagFileInfo(string, string2, (TagInfo)treeNode2);
    }

    TagAttributeInfo createAttribute(TreeNode treeNode, String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator<TreeNode> iterator = treeNode.findChildren();
        while (iterator.hasNext()) {
            Object object;
            TreeNode treeNode2 = iterator.next();
            String string6 = treeNode2.getName();
            if ("name".equals(string6)) {
                string2 = treeNode2.getBody();
                continue;
            }
            if ("required".equals(string6)) {
                object = treeNode2.getBody();
                if (object == null) continue;
                bl = JspUtil.booleanValue((String)object);
                continue;
            }
            if ("rtexprvalue".equals(string6)) {
                object = treeNode2.getBody();
                if (object == null) continue;
                bl2 = JspUtil.booleanValue((String)object);
                continue;
            }
            if ("type".equals(string6)) {
                string3 = treeNode2.getBody();
                if (!"1.2".equals(string) || !string3.equals("Boolean") && !string3.equals("Byte") && !string3.equals("Character") && !string3.equals("Double") && !string3.equals("Float") && !string3.equals("Integer") && !string3.equals("Long") && !string3.equals("Object") && !string3.equals("Short") && !string3.equals("String")) continue;
                string3 = "java.lang." + string3;
                continue;
            }
            if ("fragment".equals(string6)) {
                object = treeNode2.getBody();
                if (object == null) continue;
                bl3 = JspUtil.booleanValue((String)object);
                continue;
            }
            if ("deferred-value".equals(string6)) {
                bl4 = true;
                string3 = "javax.el.ValueExpression";
                object = treeNode2.findChild("type");
                if (object != null) {
                    string4 = ((TreeNode)object).getBody();
                    if (string4 == null) continue;
                    string4 = string4.trim();
                    continue;
                }
                string4 = "java.lang.Object";
                continue;
            }
            if ("deferred-method".equals(string6)) {
                bl5 = true;
                string3 = "javax.el.MethodExpression";
                object = treeNode2.findChild("method-signature");
                if (object != null) {
                    string5 = ((TreeNode)object).getBody();
                    if (string5 == null) continue;
                    string5 = string5.trim();
                    continue;
                }
                string5 = "java.lang.Object method()";
                continue;
            }
            if ("description".equals(string6) || !this.log.isWarnEnabled()) continue;
            this.log.warn((Object)Localizer.getMessage("jsp.warning.unknown.element.in.attribute", string6));
        }
        if (bl3) {
            string3 = "javax.servlet.jsp.tagext.JspFragment";
            bl2 = true;
        }
        if (!bl2 && string3 == null) {
            string3 = "java.lang.String";
        }
        return new TagAttributeInfo(string2, bl, string3, bl2, bl3, null, bl4, bl5, string4, string5);
    }

    TagVariableInfo createVariable(TreeNode treeNode) {
        String string = null;
        String string2 = null;
        String string3 = "java.lang.String";
        boolean bl = true;
        int n = 0;
        Iterator<TreeNode> iterator = treeNode.findChildren();
        while (iterator.hasNext()) {
            String string4;
            TreeNode treeNode2 = iterator.next();
            String string5 = treeNode2.getName();
            if ("name-given".equals(string5)) {
                string = treeNode2.getBody();
                continue;
            }
            if ("name-from-attribute".equals(string5)) {
                string2 = treeNode2.getBody();
                continue;
            }
            if ("variable-class".equals(string5)) {
                string3 = treeNode2.getBody();
                continue;
            }
            if ("declare".equals(string5)) {
                string4 = treeNode2.getBody();
                if (string4 == null) continue;
                bl = JspUtil.booleanValue(string4);
                continue;
            }
            if ("scope".equals(string5)) {
                string4 = treeNode2.getBody();
                if (string4 == null) continue;
                if ("NESTED".equals(string4)) {
                    n = 0;
                    continue;
                }
                if ("AT_BEGIN".equals(string4)) {
                    n = 1;
                    continue;
                }
                if (!"AT_END".equals(string4)) continue;
                n = 2;
                continue;
            }
            if ("description".equals(string5) || !this.log.isWarnEnabled()) continue;
            this.log.warn((Object)Localizer.getMessage("jsp.warning.unknown.element.in.variable", string5));
        }
        return new TagVariableInfo(string, string2, string3, bl, n);
    }

    private TagLibraryValidator createValidator(TreeNode treeNode) throws JasperException {
        Object object;
        TreeNode treeNode2;
        String string = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator<TreeNode> iterator = treeNode.findChildren();
        while (iterator.hasNext()) {
            treeNode2 = iterator.next();
            object = treeNode2.getName();
            if ("validator-class".equals(object)) {
                string = treeNode2.getBody();
                continue;
            }
            if ("init-param".equals(object)) {
                String[] stringArray = this.createInitParam(treeNode2);
                hashtable.put(stringArray[0], stringArray[1]);
                continue;
            }
            if ("description".equals(object) || !this.log.isWarnEnabled()) continue;
            this.log.warn((Object)Localizer.getMessage("jsp.warning.unknown.element.in.validator", object));
        }
        treeNode2 = null;
        if (string != null && !string.equals("")) {
            try {
                object = this.ctxt.getClassLoader().loadClass(string);
                treeNode2 = (TagLibraryValidator)((Class)object).newInstance();
            }
            catch (Exception exception) {
                this.err.jspError(exception, "jsp.error.tlvclass.instantiation", string);
            }
        }
        if (treeNode2 != null) {
            treeNode2.setInitParameters(hashtable);
        }
        return treeNode2;
    }

    String[] createInitParam(TreeNode treeNode) {
        String[] stringArray = new String[2];
        Iterator<TreeNode> iterator = treeNode.findChildren();
        while (iterator.hasNext()) {
            TreeNode treeNode2 = iterator.next();
            String string = treeNode2.getName();
            if ("param-name".equals(string)) {
                stringArray[0] = treeNode2.getBody();
                continue;
            }
            if ("param-value".equals(string)) {
                stringArray[1] = treeNode2.getBody();
                continue;
            }
            if ("description".equals(string) || !this.log.isWarnEnabled()) continue;
            this.log.warn((Object)Localizer.getMessage("jsp.warning.unknown.element.in.initParam", string));
        }
        return stringArray;
    }

    FunctionInfo createFunctionInfo(TreeNode treeNode) {
        String string = null;
        String string2 = null;
        String string3 = null;
        Iterator<TreeNode> iterator = treeNode.findChildren();
        while (iterator.hasNext()) {
            TreeNode treeNode2 = iterator.next();
            String string4 = treeNode2.getName();
            if ("name".equals(string4)) {
                string = treeNode2.getBody();
                continue;
            }
            if ("function-class".equals(string4)) {
                string2 = treeNode2.getBody();
                continue;
            }
            if ("function-signature".equals(string4)) {
                string3 = treeNode2.getBody();
                continue;
            }
            if ("display-name".equals(string4) || "small-icon".equals(string4) || "large-icon".equals(string4) || "description".equals(string4) || "example".equals(string4) || !this.log.isWarnEnabled()) continue;
            this.log.warn((Object)Localizer.getMessage("jsp.warning.unknown.element.in.function", string4));
        }
        return new FunctionInfo(string, string2, string3);
    }

    public TagLibraryValidator getTagLibraryValidator() {
        return this.tagLibraryValidator;
    }

    public ValidationMessage[] validate(PageData pageData) {
        TagLibraryValidator tagLibraryValidator = this.getTagLibraryValidator();
        if (tagLibraryValidator == null) {
            return null;
        }
        String string = this.getURI();
        if (string.startsWith("/")) {
            string = "urn:jsptld:" + string;
        }
        return tagLibraryValidator.validate(this.getPrefixString(), string, pageData);
    }
}

