/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.AbstractUser;
import org.apache.catalina.users.MemoryUserDatabase;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.security.Escape;

public class MemoryUser
extends AbstractUser {
    protected final MemoryUserDatabase database;
    protected final ArrayList<Group> groups = new ArrayList();
    protected final ArrayList<Role> roles = new ArrayList();

    MemoryUser(MemoryUserDatabase memoryUserDatabase, String string, String string2, String string3) {
        this.database = memoryUserDatabase;
        this.setUsername(string);
        this.setPassword(string2);
        this.setFullName(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Group> getGroups() {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            return this.groups.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.iterator();
        }
    }

    @Override
    public UserDatabase getUserDatabase() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroup(Group group) {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            if (!this.groups.contains(group)) {
                this.groups.add(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            if (!this.roles.contains(role)) {
                this.roles.add(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInGroup(Group group) {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            return this.groups.contains(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.contains(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(Group group) {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            this.groups.remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroups() {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            this.groups.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.remove(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoles() {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXml() {
        StringBuilder stringBuilder = new StringBuilder("<user username=\"");
        stringBuilder.append(Escape.xml((String)this.username));
        stringBuilder.append("\" password=\"");
        stringBuilder.append(Escape.xml((String)this.password));
        stringBuilder.append("\"");
        if (this.fullName != null) {
            stringBuilder.append(" fullName=\"");
            stringBuilder.append(Escape.xml((String)this.fullName));
            stringBuilder.append("\"");
        }
        ArrayList<Principal> arrayList = this.groups;
        synchronized (arrayList) {
            if (this.groups.size() > 0) {
                stringBuilder.append(" groups=\"");
                StringUtils.join(this.groups, (char)',', (StringUtils.Function)new StringUtils.Function<Group>(){

                    public String apply(Group group) {
                        return Escape.xml((String)group.getGroupname());
                    }
                }, (StringBuilder)stringBuilder);
                stringBuilder.append("\"");
            }
        }
        arrayList = this.roles;
        synchronized (arrayList) {
            if (this.roles.size() > 0) {
                stringBuilder.append(" roles=\"");
                StringUtils.join(this.roles, (char)',', (StringUtils.Function)new StringUtils.Function<Role>(){

                    public String apply(Role role) {
                        return Escape.xml((String)role.getRolename());
                    }
                }, (StringBuilder)stringBuilder);
                stringBuilder.append("\"");
            }
        }
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("User username=\"");
        stringBuilder.append(Escape.xml((String)this.username));
        stringBuilder.append("\"");
        if (this.fullName != null) {
            stringBuilder.append(", fullName=\"");
            stringBuilder.append(Escape.xml((String)this.fullName));
            stringBuilder.append("\"");
        }
        ArrayList<Principal> arrayList = this.groups;
        synchronized (arrayList) {
            if (this.groups.size() > 0) {
                stringBuilder.append(", groups=\"");
                StringUtils.join(this.groups, (char)',', (StringUtils.Function)new StringUtils.Function<Group>(){

                    public String apply(Group group) {
                        return Escape.xml((String)group.getGroupname());
                    }
                }, (StringBuilder)stringBuilder);
                stringBuilder.append("\"");
            }
        }
        arrayList = this.roles;
        synchronized (arrayList) {
            if (this.roles.size() > 0) {
                stringBuilder.append(", roles=\"");
                StringUtils.join(this.roles, (char)',', (StringUtils.Function)new StringUtils.Function<Role>(){

                    public String apply(Role role) {
                        return Escape.xml((String)role.getRolename());
                    }
                }, (StringBuilder)stringBuilder);
                stringBuilder.append("\"");
            }
        }
        return stringBuilder.toString();
    }
}

