/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import org.apache.jasper.el.JspELException;
import org.apache.jasper.el.JspMethodNotFoundException;
import org.apache.jasper.el.JspPropertyNotFoundException;

public final class JspMethodExpression
extends MethodExpression
implements Externalizable {
    private String mark;
    private MethodExpression target;

    public JspMethodExpression() {
    }

    public JspMethodExpression(String string, MethodExpression methodExpression) {
        this.target = methodExpression;
        this.mark = string;
    }

    public MethodInfo getMethodInfo(ELContext eLContext) throws NullPointerException, PropertyNotFoundException, MethodNotFoundException, ELException {
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        try {
            MethodInfo methodInfo = this.target.getMethodInfo(eLContext);
            eLContext.notifyAfterEvaluation(this.getExpressionString());
            return methodInfo;
        }
        catch (MethodNotFoundException methodNotFoundException) {
            if (methodNotFoundException instanceof JspMethodNotFoundException) {
                throw methodNotFoundException;
            }
            throw new JspMethodNotFoundException(this.mark, methodNotFoundException);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            if (propertyNotFoundException instanceof JspPropertyNotFoundException) {
                throw propertyNotFoundException;
            }
            throw new JspPropertyNotFoundException(this.mark, propertyNotFoundException);
        }
        catch (ELException eLException) {
            if (eLException instanceof JspELException) {
                throw eLException;
            }
            throw new JspELException(this.mark, eLException);
        }
    }

    public Object invoke(ELContext eLContext, Object[] objectArray) throws NullPointerException, PropertyNotFoundException, MethodNotFoundException, ELException {
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        try {
            Object object = this.target.invoke(eLContext, objectArray);
            eLContext.notifyAfterEvaluation(this.getExpressionString());
            return object;
        }
        catch (MethodNotFoundException methodNotFoundException) {
            if (methodNotFoundException instanceof JspMethodNotFoundException) {
                throw methodNotFoundException;
            }
            throw new JspMethodNotFoundException(this.mark, methodNotFoundException);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            if (propertyNotFoundException instanceof JspPropertyNotFoundException) {
                throw propertyNotFoundException;
            }
            throw new JspPropertyNotFoundException(this.mark, propertyNotFoundException);
        }
        catch (ELException eLException) {
            if (eLException instanceof JspELException) {
                throw eLException;
            }
            throw new JspELException(this.mark, eLException);
        }
    }

    public boolean equals(Object object) {
        return this.target.equals(object);
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String getExpressionString() {
        return this.target.getExpressionString();
    }

    public boolean isLiteralText() {
        return this.target.isLiteralText();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.mark);
        objectOutput.writeObject(this.target);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.mark = objectInput.readUTF();
        this.target = (MethodExpression)objectInput.readObject();
    }
}

