/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;

public class CheckForLJEInstr
extends NoOperandInstr {
    private boolean definedWithinMethod;

    public CheckForLJEInstr(boolean notDefinedWithinMethod) {
        super(Operation.CHECK_FOR_LJE);
        this.definedWithinMethod = notDefinedWithinMethod;
    }

    @Deprecated
    public boolean maybeLambda() {
        return !this.definedWithinMethod;
    }

    public boolean isDefinedWithinMethod() {
        return this.definedWithinMethod;
    }

    @Override
    public Instr clone(CloneInfo info) {
        InlineCloneInfo ii;
        if (info instanceof InlineCloneInfo && (ii = (InlineCloneInfo)info).getScopeBeingInlined().isScopeContainedBy(ii.getHostScope())) {
            return NopInstr.NOP;
        }
        return this;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.isDefinedWithinMethod());
    }

    public static CheckForLJEInstr decode(IRReaderDecoder d) {
        return new CheckForLJEInstr(d.decodeBoolean());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CheckForLJEInstr(this);
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"definedWithinMethod: " + this.definedWithinMethod};
    }

    public void check(ThreadContext context, DynamicScope dynamicScope, Block block) {
        IRRuntimeHelpers.checkForLJE(context, dynamicScope, this.definedWithinMethod, block);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        super.computeScopeFlags(scope, flags2);
        flags2.add(IRFlags.REQUIRES_DYNSCOPE);
        return true;
    }
}

