"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function escapeTypescriptPropertyName(str) {
    return isValidTypescriptIdentifier(str) ? str : JSON.stringify(str);
}
exports.escapeTypescriptPropertyName = escapeTypescriptPropertyName;
// TODO: these are made up lists. check the grammar
var tsKeywords = 'type class interface break case catch continue debugger default delete do else finally for function if in instanceof new return switch this throw try typeof var void while with'.split(' ');
var digitCodesL = "0".charCodeAt(0);
var digitCodesR = "9".charCodeAt(0);
var lowerCaseCodesL = "a".charCodeAt(0);
var lowerCaseCodesR = "z".charCodeAt(0);
var upperCaseCodesL = "A".charCodeAt(0);
var upperCaseCodesR = "Z".charCodeAt(0);
var digitChars = {}; //:boolean[] = []
var validChars = {}; //:boolean[] = []
//for(var i = 0 ; i < 128 ; i++){
//    digitCodes.push(false)
//    validCodes.push(false)
//}
for (var i = digitCodesL, end = digitCodesR; i <= end; i++) {
    digitChars[String.fromCharCode(i)] = true;
    validChars[String.fromCharCode(i)] = true;
}
for (var i = lowerCaseCodesL, end = lowerCaseCodesR; i <= end; i++) {
    validChars[String.fromCharCode(i)] = true;
}
for (var i = upperCaseCodesL, end = upperCaseCodesR; i <= end; i++) {
    validChars[String.fromCharCode(i)] = true;
}
"_ $".split(" ").forEach(function (x) { return validChars[x] = true; });
function isValidTypescriptIdentifier(str) {
    str = str.trim();
    if (str.length == 0) {
        return false;
    }
    if (tsKeywords.indexOf(str) >= 0) {
        return false;
    }
    if (digitChars[str.charAt(0)]) {
        return false;
    }
    for (var i = 0; i < str.length; i++) {
        if (!validChars[str.charAt(i)]) {
            return false;
        }
    }
    return true;
}
exports.isValidTypescriptIdentifier = isValidTypescriptIdentifier;
function escapeToIdentifier(str) {
    str = str.trim();
    var result = '';
    if (str.length > 0 && digitChars[str.charAt(0)]) {
        result += '_';
    }
    for (var i = 0; i < str.length; i++) {
        var ch = str.charAt(i);
        if (validChars[ch]) {
            result += ch;
        }
        else {
            result += '_';
        }
    }
    return result;
}
exports.escapeToIdentifier = escapeToIdentifier;
var typeMap = {
    'string': 'string',
    'integer': 'number',
    'number': 'number',
    'boolean': 'boolean',
    'file': 'string',
    'date': 'string',
    'NumberType': 'number'
};
function ramlType2TSType(ramlType) {
    var tsType = typeMap[ramlType];
    if (!tsType) {
        tsType = 'any';
    }
    return tsType;
}
exports.ramlType2TSType = ramlType2TSType;
function escapeToJavaIdentifier(str) {
    str = escapeToIdentifier(str);
    return exports.javaReservedWords[str] ? str + '_' : str;
}
exports.escapeToJavaIdentifier = escapeToJavaIdentifier;
exports.tsToJavaTypeMap = {
    'number': 'Double',
    'string': 'String',
    'boolean': 'Boolean',
    'any': 'Object'
};
exports.javaReservedWords = {
    "abstract": true,
    "continue": true,
    "for": true,
    "new": true,
    "switch": true,
    "assert": true,
    "default": true,
    "goto": true,
    "package": true,
    "synchronized": true,
    "boolean": true,
    "do": true,
    "if": true,
    "private": true,
    "this": true,
    "break": true,
    "double": true,
    "implements": true,
    "protected": true,
    "throw": true,
    "byte": true,
    "else": true,
    "import": true,
    "public": true,
    "throws": true,
    "case": true,
    "enum": true,
    "instanceof": true,
    "return": true,
    "transient": true,
    "catch": true,
    "extends": true,
    "int": true,
    "short": true,
    "try": true,
    "char": true,
    "final": true,
    "interface": true,
    "static": true,
    "void": true,
    "class": true,
    "finally": true,
    "long": true,
    "strictfp": true,
    "volatile": true,
    "const": true,
    "float": true,
    "native": true,
    "super": true,
    "while": true,
};
//# sourceMappingURL=tsutil.js.map