/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.Visitor;

public class NoObjectType
extends FunctionType {
    private static final long serialVersionUID = 1L;

    NoObjectType(JSTypeRegistry registry) {
        super(FunctionType.builder(registry).withKind(FunctionType.Kind.NONE).withReturnsOwnInstanceType().forNativeType());
        this.eagerlyResolveToSelf();
    }

    @Override
    JSTypeClass getTypeClass() {
        return JSTypeClass.NO_OBJECT;
    }

    @Override
    public final FunctionType toMaybeFunctionType() {
        return null;
    }

    @Override
    public boolean isNoObjectType() {
        return true;
    }

    @Override
    public final ObjectType getImplicitPrototype() {
        return null;
    }

    @Override
    public String getReferenceName() {
        return null;
    }

    @Override
    public final boolean matchesNumberContext() {
        return true;
    }

    @Override
    public final boolean matchesObjectContext() {
        return true;
    }

    @Override
    public final boolean matchesStringContext() {
        return true;
    }

    @Override
    public final boolean matchesSymbolContext() {
        return true;
    }

    @Override
    int recursionUnsafeHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    final boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        return true;
    }

    @Override
    public final boolean removeProperty(String name) {
        return false;
    }

    @Override
    public final void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNoObjectType();
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseNoObjectType(that);
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        sb.append(sb.isForAnnotations() ? "?" : "NoObject");
    }

    @Override
    public final FunctionType getConstructor() {
        return null;
    }

    @Override
    final JSType resolveInternal(ErrorReporter reporter) {
        throw new AssertionError();
    }
}

