/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.reflect;

import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class GenericTypeUtils {
    public static Optional<Class> resolveGenericTypeArgument(Field field) {
        Type[] typeArguments;
        Type genericType;
        Type type = genericType = field != null ? field.getGenericType() : null;
        if (genericType instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
            Type typeArg = typeArguments[0];
            return GenericTypeUtils.resolveParameterizedTypeArgument(typeArg);
        }
        return Optional.empty();
    }

    public static Class[] resolveInterfaceTypeArguments(Class<?> type, Class<?> interfaceType) {
        Optional<Type> resolvedType = GenericTypeUtils.getAllGenericInterfaces(type).stream().filter(t -> {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                return pt.getRawType() == interfaceType;
            }
            return false;
        }).findFirst();
        return resolvedType.map(GenericTypeUtils::resolveTypeArguments).orElse(ReflectionUtils.EMPTY_CLASS_ARRAY);
    }

    public static Class[] resolveSuperTypeGenericArguments(Class<?> type, Class<?> superTypeToResolve) {
        Type supertype = type.getGenericSuperclass();
        for (Class<?> superclass = type.getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
            ParameterizedType pt;
            if (supertype instanceof ParameterizedType && (pt = (ParameterizedType)supertype).getRawType() == superTypeToResolve) {
                return GenericTypeUtils.resolveTypeArguments(supertype);
            }
            supertype = superclass.getGenericSuperclass();
        }
        return ReflectionUtils.EMPTY_CLASS_ARRAY;
    }

    public static Optional<Class> resolveSuperGenericTypeArgument(Class type) {
        try {
            Type genericSuperclass = type.getGenericSuperclass();
            if (genericSuperclass instanceof ParameterizedType) {
                return GenericTypeUtils.resolveSingleTypeArgument(genericSuperclass);
            }
            return Optional.empty();
        }
        catch (NoClassDefFoundError e) {
            return Optional.empty();
        }
    }

    public static Class[] resolveTypeArguments(Type genericType) {
        Class[] typeArguments = ReflectionUtils.EMPTY_CLASS_ARRAY;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            typeArguments = GenericTypeUtils.resolveParameterizedType(pt);
        }
        return typeArguments;
    }

    public static Optional<Class> resolveInterfaceTypeArgument(Class type, Class interfaceType) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = type.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(genericInterface instanceof ParameterizedType) || (pt = (ParameterizedType)genericInterface).getRawType() != interfaceType) continue;
            return GenericTypeUtils.resolveSingleTypeArgument(genericInterface);
        }
        Class superClass = type.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return GenericTypeUtils.resolveInterfaceTypeArgument(superClass, interfaceType);
        }
        return Optional.empty();
    }

    private static Optional<Class> resolveSingleTypeArgument(Type genericType) {
        ParameterizedType pt;
        Type[] actualTypeArguments;
        if (genericType instanceof ParameterizedType && (actualTypeArguments = (pt = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
            Type actualTypeArgument = actualTypeArguments[0];
            return GenericTypeUtils.resolveParameterizedTypeArgument(actualTypeArgument);
        }
        return Optional.empty();
    }

    private static Optional<Class> resolveParameterizedTypeArgument(Type actualTypeArgument) {
        ParameterizedType pt;
        Type rawType;
        if (actualTypeArgument instanceof Class) {
            return Optional.of((Class)actualTypeArgument);
        }
        if (actualTypeArgument instanceof ParameterizedType && (rawType = (pt = (ParameterizedType)actualTypeArgument).getRawType()) instanceof Class) {
            return Optional.of((Class)rawType);
        }
        return Optional.empty();
    }

    private static Set<Type> getAllGenericInterfaces(Class<?> aClass) {
        LinkedHashSet<Type> interfaces = new LinkedHashSet<Type>();
        return GenericTypeUtils.populateInterfaces(aClass, interfaces);
    }

    private static Set<Type> populateInterfaces(Class<?> aClass, Set<Type> interfaces) {
        Type[] theInterfaces = aClass.getGenericInterfaces();
        interfaces.addAll(Arrays.asList(theInterfaces));
        for (Type theInterface : theInterfaces) {
            Class i;
            if (!(theInterface instanceof Class) || !ArrayUtils.isNotEmpty((i = (Class)theInterface).getGenericInterfaces())) continue;
            GenericTypeUtils.populateInterfaces(i, interfaces);
        }
        if (!aClass.isInterface()) {
            for (Class<?> superclass = aClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                GenericTypeUtils.populateInterfaces(superclass, interfaces);
            }
        }
        return interfaces;
    }

    private static Class[] resolveParameterizedType(ParameterizedType pt) {
        Class[] typeArguments = ReflectionUtils.EMPTY_CLASS_ARRAY;
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            typeArguments = new Class[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type actualTypeArgument = actualTypeArguments[i];
                Optional<Class> opt = GenericTypeUtils.resolveParameterizedTypeArgument(actualTypeArgument);
                if (!opt.isPresent()) {
                    typeArguments = ReflectionUtils.EMPTY_CLASS_ARRAY;
                    break;
                }
                typeArguments[i] = opt.get();
            }
        }
        return typeArguments;
    }
}

