/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.notes;

import java.util.Comparator;
import java.util.Date;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.date.DateUtils;

public class NoteComment {
    private final String text;
    private final User user;
    private final Date commentTimestamp;
    private final Action action;
    private boolean isNew;
    public static final Comparator<NoteComment> DATE_COMPARATOR = Comparator.comparing(n -> n.commentTimestamp);

    public NoteComment(Date createDate, User user, String commentText, Action action, boolean isNew) {
        this.text = commentText;
        this.user = user;
        this.commentTimestamp = DateUtils.cloneDate(createDate);
        this.action = action;
        this.isNew = isNew;
    }

    public String getText() {
        return this.text;
    }

    public User getUser() {
        return this.user;
    }

    public Date getCommentTimestamp() {
        return DateUtils.cloneDate(this.commentTimestamp);
    }

    public Action getNoteAction() {
        return this.action;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String toString() {
        return this.text;
    }

    public static enum Action {
        OPENED,
        CLOSED,
        REOPENED,
        COMMENTED,
        HIDDEN;

    }
}

