/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    @Nullable
    private final RegistryKeyDescriptor myKeyDescriptor;
    private final List<RegistryValueListener> myListeners;
    private boolean myChangedSinceStart;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;
    private static final Logger LOG = Logger.getInstance(RegistryValue.class);

    RegistryValue(@NotNull Registry registry, @NonNls @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        if (registry == null) {
            RegistryValue.$$$reportNull$$$0(0);
        }
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDoubleCachedValue = Double.NaN;
        this.myRegistry = registry;
        this.myKey = key;
        this.myKeyDescriptor = keyDescriptor;
    }

    @NotNull
    public String asString() {
        String value2 = this.get(this.myKey, null, true);
        assert (value2 != null) : this.myKey;
        String string2 = value2;
        if (string2 == null) {
            RegistryValue.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public boolean asBoolean() {
        Boolean result2 = this.myBooleanCachedValue;
        if (result2 == null) {
            this.myBooleanCachedValue = result2 = this.calcBoolean();
        }
        return result2;
    }

    @NotNull
    private Boolean calcBoolean() {
        Boolean bl = Boolean.valueOf(this.get(this.myKey, "false", true));
        if (bl == null) {
            RegistryValue.$$$reportNull$$$0(4);
        }
        return bl;
    }

    public int asInteger() {
        Integer result2 = this.myIntCachedValue;
        if (result2 == null) {
            this.myIntCachedValue = result2 = this.calcInt();
        }
        return result2;
    }

    @NotNull
    private Integer calcInt() {
        Integer n;
        try {
            n = Integer.valueOf(this.get(this.myKey, "0", true));
        }
        catch (NumberFormatException e) {
            String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
            assert (bundleValue != null);
            Integer n2 = Integer.valueOf(bundleValue);
            if (n2 == null) {
                RegistryValue.$$$reportNull$$$0(6);
            }
            return n2;
        }
        if (n == null) {
            RegistryValue.$$$reportNull$$$0(5);
        }
        return n;
    }

    boolean isRestartRequired() {
        if (this.myKeyDescriptor != null) {
            return this.myKeyDescriptor.isRestartRequired();
        }
        return Boolean.parseBoolean(this.get(this.myKey + ".restartRequired", "false", false));
    }

    public boolean isChangedFromDefault() {
        return this.isChangedFromDefault(this.asString(), Registry.getInstance());
    }

    final boolean isChangedFromDefault(@NotNull String newValue2, @NotNull Registry registry) {
        if (newValue2 == null) {
            RegistryValue.$$$reportNull$$$0(9);
        }
        if (registry == null) {
            RegistryValue.$$$reportNull$$$0(10);
        }
        return !newValue2.equals(registry.getBundleValue(this.myKey, false));
    }

    protected String get(@NonNls @NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(11);
        }
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, true);
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, false);
    }

    @Nullable
    private String _get(@NonNls @NotNull String key, @Nullable String defaultValue, boolean mustExistInBundle) throws MissingResourceException {
        String bundleValue;
        String userValue;
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(12);
        }
        if ((userValue = this.myRegistry.getUserProperties().get(key)) != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        if (!this.myRegistry.isLoaded()) {
            LOG.warn("The registry key '" + key + "' accessed, but not loaded yet");
        }
        return (bundleValue = Registry.getInstance().getBundleValue(key, mustExistInBundle)) == null ? defaultValue : bundleValue;
    }

    public void setValue(boolean value2) {
        this.setValue(Boolean.toString(value2));
    }

    public void setValue(String value2) {
        this.resetCache();
        for (RegistryValueListener each : this.myListeners) {
            each.beforeValueChanged(this);
        }
        this.myRegistry.getUserProperties().put(this.myKey, value2);
        for (RegistryValueListener each : this.myListeners) {
            each.afterValueChanged(this);
        }
        if (!this.isChangedFromDefault() && !this.isRestartRequired()) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        }
        this.myChangedSinceStart = true;
        LOG.info("Registry value '" + this.myKey + "' has changed to '" + value2 + '\'');
    }

    public void setValue(boolean value2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RegistryValue.$$$reportNull$$$0(13);
        }
        boolean prev = this.asBoolean();
        this.setValue(value2);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    void resetCache() {
        this.myStringCachedValue = null;
        this.myIntCachedValue = null;
        this.myDoubleCachedValue = Double.NaN;
        this.myBooleanCachedValue = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBoolean";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isChangedFromDefault";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "_get";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

