/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.lower.LateinitLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/NullableFieldsForLateinitCreationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "backendContext", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "ir.backend.common"})
public final class NullableFieldsForLateinitCreationLowering
implements DeclarationTransformer {
    private final CommonBackendContext backendContext;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        LowerKt.toFileLoweringPass(LowerKt.runPostfix(this, true)).lower(irFile);
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        Object object;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (declaration2 instanceof IrField && (object = ((IrField)declaration2).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null) {
            IrField newField;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object property2 = object2;
            boolean bl3 = false;
            if (LateinitLoweringKt.access$isRealLateinit$p((IrProperty)property2) && Intrinsics.areEqual(declaration2, newField = LateinitLoweringKt.access$buildOrGetNullableField(this.backendContext, (IrField)declaration2)) ^ true && Intrinsics.areEqual(declaration2.getParent(), property2.getParent()) ^ true) {
                return CollectionsKt.listOf(newField);
            }
        }
        return null;
    }

    @NotNull
    public final CommonBackendContext getBackendContext() {
        return this.backendContext;
    }

    public NullableFieldsForLateinitCreationLowering(@NotNull CommonBackendContext backendContext) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        this.backendContext = backendContext;
    }
}

