/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0002R&\u0010\u0005\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmStandardLibraryBuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "Jvm8builtInReplacements", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "coerceTo", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "target", "Lorg/jetbrains/kotlin/ir/types/IrType;", "replaceWithCallTo", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "replacement", "backend.jvm"})
public final class JvmStandardLibraryBuiltInsLowering
implements FileLoweringPass {
    private final Map<Pair<String, String>, IrSimpleFunctionSymbol> Jvm8builtInReplacements;
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        if (this.context.getState().getTarget().compareTo((Enum)JvmTarget.JVM_1_8) < 0) {
            return;
        }
        IrElementTransformerVoid transformer2 = new IrElementTransformerVoid(this){
            final /* synthetic */ JvmStandardLibraryBuiltInsLowering this$0;

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                expression2.transformChildren(this, null);
                String string2 = AdditionalIrUtilsKt.getFqNameForIrSerialization(((IrSimpleFunction)expression2.getSymbol().getOwner()).getParent()).asString();
                Intrinsics.checkNotNullExpressionValue(string2, "expression.symbol.owner.\u2026rSerialization.asString()");
                String parentClass = string2;
                String string3 = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue(string3, "expression.symbol.owner.name.asString()");
                String functionName = string3;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)JvmStandardLibraryBuiltInsLowering.access$getJvm8builtInReplacements$p(this.this$0).get(TuplesKt.to(parentClass, functionName));
                if (irSimpleFunctionSymbol != null) {
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunctionSymbol;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrSimpleFunctionSymbol it = irSimpleFunctionSymbol2;
                    boolean bl3 = false;
                    return JvmStandardLibraryBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, it);
                }
                return expression2;
            }
            {
                this.this$0 = this$0;
            }
        };
        irFile.transformChildren(transformer2, null);
    }

    private final IrCallImpl replaceWithCallTo(IrCall $this$replaceWithCallTo, IrSimpleFunctionSymbol replacement) {
        IrCallImpl irCallImpl = new IrCallImpl($this$replaceWithCallTo.getStartOffset(), $this$replaceWithCallTo.getEndOffset(), $this$replaceWithCallTo.getType(), replacement, null, null, 48, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl newCall = irCallImpl;
        boolean bl3 = false;
        int valueArgumentOffset = 0;
        IrExpression irExpression = $this$replaceWithCallTo.getDispatchReceiver();
        if (irExpression != null) {
            IrExpression irExpression2 = irExpression;
            boolean bl4 = false;
            boolean bl5 = false;
            IrExpression it = irExpression2;
            boolean bl6 = false;
            newCall.putValueArgument(valueArgumentOffset, this.coerceTo(it, ((IrSimpleFunction)replacement.getOwner()).getValueParameters().get(valueArgumentOffset).getType()));
            int n = valueArgumentOffset;
            valueArgumentOffset = n + 1;
        }
        Iterable $this$forEach$iv = RangesKt.until(0, $this$replaceWithCallTo.getValueArgumentsCount());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl7 = false;
            IrExpression irExpression3 = $this$replaceWithCallTo.getValueArgument(it);
            Intrinsics.checkNotNull(irExpression3);
            newCall.putValueArgument(it + valueArgumentOffset, this.coerceTo(irExpression3, ((IrSimpleFunction)replacement.getOwner()).getValueParameters().get(it).getType()));
        }
        return irCallImpl;
    }

    private final IrExpression coerceTo(IrExpression $this$coerceTo, IrType target) {
        IrCallImpl irCallImpl = new IrCallImpl($this$coerceTo.getStartOffset(), $this$coerceTo.getEndOffset(), target, this.context.getIr().getSymbols().getUnsafeCoerceIntrinsic(), null, null, 48, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl call2 = irCallImpl;
        boolean bl3 = false;
        call2.putTypeArgument(0, $this$coerceTo.getType());
        call2.putTypeArgument(1, target);
        call2.putValueArgument(0, $this$coerceTo);
        return irCallImpl;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public JvmStandardLibraryBuiltInsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.Jvm8builtInReplacements = MapsKt.mapOf(TuplesKt.to(TuplesKt.to("kotlin.UInt", "compareTo"), this.context.getIr().getSymbols().getCompareUnsignedInt()), TuplesKt.to(TuplesKt.to("kotlin.UInt", "div"), this.context.getIr().getSymbols().getDivideUnsignedInt()), TuplesKt.to(TuplesKt.to("kotlin.UInt", "rem"), this.context.getIr().getSymbols().getRemainderUnsignedInt()), TuplesKt.to(TuplesKt.to("kotlin.UInt", "toString"), this.context.getIr().getSymbols().getToUnsignedStringInt()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "compareTo"), this.context.getIr().getSymbols().getCompareUnsignedLong()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "div"), this.context.getIr().getSymbols().getDivideUnsignedLong()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "rem"), this.context.getIr().getSymbols().getRemainderUnsignedLong()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "toString"), this.context.getIr().getSymbols().getToUnsignedStringLong()));
    }

    public static final /* synthetic */ Map access$getJvm8builtInReplacements$p(JvmStandardLibraryBuiltInsLowering $this) {
        return $this.Jvm8builtInReplacements;
    }

    public static final /* synthetic */ IrCallImpl access$replaceWithCallTo(JvmStandardLibraryBuiltInsLowering $this, IrCall $this$access_u24replaceWithCallTo, IrSimpleFunctionSymbol replacement) {
        return $this.replaceWithCallTo($this$access_u24replaceWithCallTo, replacement);
    }
}

