/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\b\u001a\n\u0010!\u001a\u00020\f*\u00020\b\u001a\u0010\u0010\"\u001a\u00020#*\b\u0012\u0004\u0012\u00020\u00120$\u001a-\u0010%\u001a\u0004\u0018\u0001H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\b*\u00020\u0004H\u0086\b\u0082\u0002\n\n\b\b\u0002\u001a\u0004\u0010\u0000(\u0000\u00a2\u0006\u0002\u0010\n\u001a\u001e\u0010(\u001a\u0002H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\b*\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120$*\b\u0012\u0004\u0012\u00020\u00120$\u001a\f\u0010*\u001a\u00020\f*\u00020+H\u0002\u001a\u001c\u0010,\u001a\u00020\f*\u00020\u00042\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\fH\u0002\u001a\n\u00100\u001a\u000201*\u000202\u001a\u0010\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u000104*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0016\u0010\u0007\u001a\u00020\b*\u00020\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\"\u0015\u0010\u000e\u001a\u00020\f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\r\"\u0015\u0010\u000f\u001a\u00020\f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\"\u0015\u0010\u0010\u001a\u00020\f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r\"\u0015\u0010\u0011\u001a\u00020\f*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\"\u0017\u0010\u0014\u001a\u0004\u0018\u00010\f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\"\u0015\u0010\u0017\u001a\u00020\f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\"\u0015\u0010\u0018\u001a\u00020\f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\r\"\u0015\u0010\u0019\u001a\u00020\f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\r\"\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00f2\u0001\u0004\n\u00020'\u00a8\u00065"}, d2={"EXTENSION_FUNCTION_ANNOTATION", "", "classLikeTypeOrNull", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getClassLikeTypeOrNull", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "coneType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getConeType", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isAny", "", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Z", "isArrayType", "isBoolean", "isEnum", "isExtensionFunctionAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)Z", "isMarkedNullable", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Ljava/lang/Boolean;", "isNothing", "isNullableAny", "isNullableNothing", "isUnit", "parametersCount", "", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "getParametersCount", "(Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;)I", "makesSenseToBeDefinitelyNotNull", "type", "canHaveUndefinedNullability", "computeTypeAttributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "", "coneTypeSafe", "T", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "coneTypeUnsafe", "dropExtensionFunctionAnnotation", "hasNotNullUpperBound", "Lorg/jetbrains/kotlin/fir/types/ConeTypeParameterType;", "isBuiltinType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "isNullable", "toConeTypeProjection", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "toConstKind", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "tree"})
public final class FirTypeUtilsKt {
    @NotNull
    public static final String EXTENSION_FUNCTION_ANNOTATION = "kotlin/ExtensionFunctionType";

    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeUnsafe(FirTypeRef $this$coneTypeUnsafe) {
        int $i$f$coneTypeUnsafe = 0;
        Intrinsics.checkNotNullParameter($this$coneTypeUnsafe, "$this$coneTypeUnsafe");
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe).getType();
        Intrinsics.reifiedOperationMarker(1, "T");
        return (T)coneKotlinType;
    }

    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeSafe(FirTypeRef $this$coneTypeSafe) {
        int $i$f$coneTypeSafe = 0;
        Intrinsics.checkNotNullParameter($this$coneTypeSafe, "$this$coneTypeSafe");
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        Intrinsics.reifiedOperationMarker(2, "T");
        return (T)coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType getConeType(@NotNull FirTypeRef $this$coneType) {
        int $i$f$getConeType = 0;
        Intrinsics.checkNotNullParameter($this$coneType, "$this$coneType");
        FirTypeRef $this$coneTypeUnsafe$iv = $this$coneType;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        return coneKotlinType;
    }

    public static final boolean isAny(@NotNull FirTypeRef $this$isAny) {
        Intrinsics.checkNotNullParameter($this$isAny, "$this$isAny");
        return FirTypeUtilsKt.isBuiltinType($this$isAny, StandardClassIds.INSTANCE.getAny(), false);
    }

    public static final boolean isNullableAny(@NotNull FirTypeRef $this$isNullableAny) {
        Intrinsics.checkNotNullParameter($this$isNullableAny, "$this$isNullableAny");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableAny, StandardClassIds.INSTANCE.getAny(), true);
    }

    public static final boolean isNothing(@NotNull FirTypeRef $this$isNothing) {
        Intrinsics.checkNotNullParameter($this$isNothing, "$this$isNothing");
        return FirTypeUtilsKt.isBuiltinType($this$isNothing, StandardClassIds.INSTANCE.getNothing(), false);
    }

    public static final boolean isNullableNothing(@NotNull FirTypeRef $this$isNullableNothing) {
        Intrinsics.checkNotNullParameter($this$isNullableNothing, "$this$isNullableNothing");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableNothing, StandardClassIds.INSTANCE.getNothing(), true);
    }

    public static final boolean isUnit(@NotNull FirTypeRef $this$isUnit) {
        Intrinsics.checkNotNullParameter($this$isUnit, "$this$isUnit");
        return FirTypeUtilsKt.isBuiltinType($this$isUnit, StandardClassIds.INSTANCE.getUnit(), false);
    }

    public static final boolean isBoolean(@NotNull FirTypeRef $this$isBoolean) {
        Intrinsics.checkNotNullParameter($this$isBoolean, "$this$isBoolean");
        return FirTypeUtilsKt.isBuiltinType($this$isBoolean, StandardClassIds.INSTANCE.getBoolean(), false);
    }

    public static final boolean isEnum(@NotNull FirTypeRef $this$isEnum) {
        Intrinsics.checkNotNullParameter($this$isEnum, "$this$isEnum");
        return FirTypeUtilsKt.isBuiltinType($this$isEnum, StandardClassIds.INSTANCE.getEnum(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isArrayType(@NotNull FirTypeRef $this$isArrayType) {
        ClassId it;
        Intrinsics.checkNotNullParameter($this$isArrayType, "$this$isArrayType");
        if (FirTypeUtilsKt.isBuiltinType($this$isArrayType, StandardClassIds.INSTANCE.getArray(), false)) return true;
        Iterable $this$any$iv = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ClassId)element$iv;
            boolean bl = false;
        } while (!FirTypeUtilsKt.isBuiltinType($this$isArrayType, it, false));
        return true;
    }

    private static final ConeClassLikeType getClassLikeTypeOrNull(FirTypeRef $this$classLikeTypeOrNull) {
        ConeClassLikeType coneClassLikeType;
        FirTypeRef firTypeRef = $this$classLikeTypeOrNull;
        if (firTypeRef instanceof FirImplicitBuiltinTypeRef) {
            coneClassLikeType = ((FirImplicitBuiltinTypeRef)$this$classLikeTypeOrNull).getType();
        } else if (firTypeRef instanceof FirResolvedTypeRef) {
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$classLikeTypeOrNull).getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            coneClassLikeType = (ConeClassLikeType)coneKotlinType;
        } else {
            coneClassLikeType = null;
        }
        return coneClassLikeType;
    }

    private static final boolean isBuiltinType(FirTypeRef $this$isBuiltinType, ClassId classId, boolean isNullable) {
        ConeClassLikeType coneClassLikeType = FirTypeUtilsKt.getClassLikeTypeOrNull($this$isBuiltinType);
        if (coneClassLikeType == null) {
            return false;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        return Intrinsics.areEqual(type2.getLookupTag().getClassId(), classId) && ConeTypeUtilsKt.isNullable(type2) == isNullable;
    }

    @Nullable
    public static final Boolean isMarkedNullable(@NotNull FirTypeRef $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter($this$isMarkedNullable, "$this$isMarkedNullable");
        ConeClassLikeType coneClassLikeType = FirTypeUtilsKt.getClassLikeTypeOrNull($this$isMarkedNullable);
        return coneClassLikeType != null ? Boolean.valueOf(ConeTypeUtilsKt.isMarkedNullable(coneClassLikeType)) : null;
    }

    public static final int getParametersCount(@NotNull FirFunctionTypeRef $this$parametersCount) {
        Intrinsics.checkNotNullParameter($this$parametersCount, "$this$parametersCount");
        return $this$parametersCount.getReceiverTypeRef() != null ? $this$parametersCount.getValueParameters().size() + 1 : $this$parametersCount.getValueParameters().size();
    }

    public static final boolean isExtensionFunctionAnnotationCall(@NotNull FirAnnotationCall $this$isExtensionFunctionAnnotationCall) {
        Boolean bl;
        Intrinsics.checkNotNullParameter($this$isExtensionFunctionAnnotationCall, "$this$isExtensionFunctionAnnotationCall");
        FirAnnotationCall firAnnotationCall = $this$isExtensionFunctionAnnotationCall;
        if (firAnnotationCall != null) {
            FirAnnotationCall firAnnotationCall2 = firAnnotationCall;
            boolean bl2 = false;
            boolean bl3 = false;
            FirAnnotationCall annotationCall = firAnnotationCall2;
            boolean bl4 = false;
            FirTypeRef firTypeRef = annotationCall.getAnnotationTypeRef();
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            if (firResolvedTypeRef != null) {
                FirResolvedTypeRef firResolvedTypeRef2 = firResolvedTypeRef;
                boolean bl5 = false;
                boolean bl6 = false;
                FirResolvedTypeRef typeRef = firResolvedTypeRef2;
                boolean bl7 = false;
                ConeKotlinType coneKotlinType = typeRef.getType();
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
                if (coneClassLikeType != null) {
                    ConeClassLikeType coneClassLikeType2 = coneClassLikeType;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    ConeClassLikeType it = coneClassLikeType2;
                    boolean bl10 = false;
                    bl = Intrinsics.areEqual(it.getLookupTag().getClassId().asString(), EXTENSION_FUNCTION_ANNOTATION);
                } else {
                    bl = null;
                }
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotationCall> dropExtensionFunctionAnnotation(@NotNull List<? extends FirAnnotationCall> $this$dropExtensionFunctionAnnotation) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$dropExtensionFunctionAnnotation, "$this$dropExtensionFunctionAnnotation");
        Iterable $this$filterNot$iv = $this$dropExtensionFunctionAnnotation;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl = false;
            if (FirTypeUtilsKt.isExtensionFunctionAnnotationCall(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirConstKind<?> toConstKind(@NotNull ConeClassLikeType $this$toConstKind) {
        Intrinsics.checkNotNullParameter($this$toConstKind, "$this$toConstKind");
        ClassId classId = $this$toConstKind.getLookupTag().getClassId();
        return Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getByte()) ? (FirConstKind)FirConstKind.Byte.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getShort()) ? (FirConstKind)FirConstKind.Short.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getInt()) ? (FirConstKind)FirConstKind.Int.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getLong()) ? (FirConstKind)FirConstKind.Long.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getUInt()) ? (FirConstKind)FirConstKind.UnsignedInt.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getULong()) ? (FirConstKind)FirConstKind.UnsignedLong.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getUShort()) ? (FirConstKind)FirConstKind.UnsignedShort.INSTANCE : (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getUByte()) ? (FirConstKind)FirConstKind.UnsignedByte.INSTANCE : null)))))));
    }

    @NotNull
    public static final ConeAttributes computeTypeAttributes(@NotNull List<? extends FirAnnotationCall> $this$computeTypeAttributes) {
        Intrinsics.checkNotNullParameter($this$computeTypeAttributes, "$this$computeTypeAttributes");
        if ($this$computeTypeAttributes.isEmpty()) {
            return ConeAttributes.Companion.getEmpty();
        }
        boolean bl = false;
        List attributes = new ArrayList();
        for (FirAnnotationCall firAnnotationCall : $this$computeTypeAttributes) {
            boolean bl2;
            ConeClassLikeType type2;
            FirTypeRef $this$coneTypeSafe$iv = firAnnotationCall.getAnnotationTypeRef();
            boolean $i$f$coneTypeSafe = false;
            boolean bl3 = false;
            FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) {
                continue;
            }
            ClassId classId = type2.getLookupTag().getClassId();
            if (Intrinsics.areEqual(classId, CompilerConeAttributes.Exact.INSTANCE.getANNOTATION_CLASS_ID())) {
                Collection collection = attributes;
                CompilerConeAttributes.Exact exact = CompilerConeAttributes.Exact.INSTANCE;
                bl2 = false;
                collection.add(exact);
                continue;
            }
            if (Intrinsics.areEqual(classId, CompilerConeAttributes.NoInfer.INSTANCE.getANNOTATION_CLASS_ID())) {
                Collection collection = attributes;
                CompilerConeAttributes.NoInfer noInfer = CompilerConeAttributes.NoInfer.INSTANCE;
                bl2 = false;
                collection.add(noInfer);
                continue;
            }
            if (!Intrinsics.areEqual(classId, CompilerConeAttributes.ExtensionFunctionType.INSTANCE.getANNOTATION_CLASS_ID())) continue;
            Collection collection = attributes;
            CompilerConeAttributes.ExtensionFunctionType extensionFunctionType = CompilerConeAttributes.ExtensionFunctionType.INSTANCE;
            bl2 = false;
            collection.add(extensionFunctionType);
        }
        return ConeAttributes.Companion.create(attributes);
    }

    @NotNull
    public static final ConeTypeProjection toConeTypeProjection(@NotNull FirTypeProjection $this$toConeTypeProjection) {
        ConeTypeProjection coneTypeProjection;
        Intrinsics.checkNotNullParameter($this$toConeTypeProjection, "$this$toConeTypeProjection");
        FirTypeProjection firTypeProjection = $this$toConeTypeProjection;
        if (firTypeProjection instanceof FirStarProjection) {
            coneTypeProjection = ConeStarProjection.INSTANCE;
        } else if (firTypeProjection instanceof FirTypeProjectionWithVariance) {
            FirTypeRef $this$coneType$iv = ((FirTypeProjectionWithVariance)$this$toConeTypeProjection).getTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            FirTypeRef firTypeRef = $this$coneTypeUnsafe$iv$iv;
            if (firTypeRef == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
            }
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)firTypeRef).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            ConeKotlinType type2 = coneKotlinType;
            coneTypeProjection = ConeTypeUtilsKt.toTypeProjection(type2, ((FirTypeProjectionWithVariance)$this$toConeTypeProjection).getVariance());
        } else {
            String string2 = "!";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return coneTypeProjection;
    }

    public static final boolean makesSenseToBeDefinitelyNotNull(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return FirTypeUtilsKt.canHaveUndefinedNullability(type2);
    }

    public static final boolean canHaveUndefinedNullability(@NotNull ConeKotlinType $this$canHaveUndefinedNullability) {
        Intrinsics.checkNotNullParameter($this$canHaveUndefinedNullability, "$this$canHaveUndefinedNullability");
        ConeKotlinType coneKotlinType = $this$canHaveUndefinedNullability;
        return coneKotlinType instanceof ConeTypeVariableType || coneKotlinType instanceof ConeCapturedType ? true : (coneKotlinType instanceof ConeTypeParameterType ? ConeTypeUtilsKt.isMarkedNullable($this$canHaveUndefinedNullability.getType()) || !FirTypeUtilsKt.hasNotNullUpperBound((ConeTypeParameterType)$this$canHaveUndefinedNullability) : false);
    }

    private static final boolean hasNotNullUpperBound(ConeTypeParameterType $this$hasNotNullUpperBound) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = ((FirTypeParameter)$this$hasNotNullUpperBound.getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeKotlinType boundType;
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl2 = false;
                    FirTypeRef $this$coneType$iv = it;
                    boolean $i$f$getConeType = false;
                    FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                    boolean $i$f$coneTypeUnsafe = false;
                    FirTypeRef firTypeRef = $this$coneTypeUnsafe$iv$iv;
                    if (firTypeRef == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
                    }
                    if (((FirResolvedTypeRef)firTypeRef).getType() == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                    }
                    boolean bl3 = boundType instanceof ConeTypeParameterType ? FirTypeUtilsKt.hasNotNullUpperBound((ConeTypeParameterType)boundType) : boundType.getNullability() == ConeNullability.NOT_NULL;
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }
}

