/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/KClassWithIncorrectTypeArgumentChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isKClassWithBadArgument", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "frontend"})
public final class KClassWithIncorrectTypeArgumentChecker
implements DeclarationChecker {
    @NotNull
    public static final KClassWithIncorrectTypeArgumentChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        void typeParameterWithoutNotNullableUpperBound;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(descriptor2 instanceof CallableMemberDescriptor) || Intrinsics.areEqual(((CallableMemberDescriptor)descriptor2).getVisibility(), DescriptorVisibilities.LOCAL)) {
            return;
        }
        if (!(declaration2 instanceof KtCallableDeclaration) || ((KtCallableDeclaration)declaration2).getTypeReference() != null) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        KotlinType kotlinType = ((CallableMemberDescriptor)descriptor2).getReturnType();
        if (kotlinType == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(kotlinType, "descriptor.returnType ?: return");
        KotlinType returnType2 = kotlinType;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        TypeUtilsKt.contains(returnType2, (Function1<? super UnwrappedType, Boolean>)new Function1<UnwrappedType, Boolean>(descriptor2, (Ref.ObjectRef)typeParameterWithoutNotNullableUpperBound){
            final /* synthetic */ DeclarationDescriptor $descriptor;
            final /* synthetic */ Ref.ObjectRef $typeParameterWithoutNotNullableUpperBound;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull UnwrappedType type2) {
                void var2_2;
                block1: {
                    Object object;
                    Intrinsics.checkNotNullParameter(type2, "type");
                    boolean kClassWithBadArgument = KClassWithIncorrectTypeArgumentChecker.access$isKClassWithBadArgument(KClassWithIncorrectTypeArgumentChecker.INSTANCE, type2);
                    if (!kClassWithBadArgument || (object = CollectionsKt.singleOrNull(type2.getArguments())) == null || (object = object.getType()) == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) break block1;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    if (it instanceof TypeParameterDescriptor && Intrinsics.areEqual(((TypeParameterDescriptor)it).getContainingDeclaration(), this.$descriptor)) {
                        this.$typeParameterWithoutNotNullableUpperBound.element = (TypeParameterDescriptor)it;
                    }
                }
                return (boolean)var2_2;
            }
            {
                this.$descriptor = declarationDescriptor;
                this.$typeParameterWithoutNotNullableUpperBound = objectRef;
                super(1);
            }
        });
        if ((TypeParameterDescriptor)typeParameterWithoutNotNullableUpperBound.element != null) {
            BindingTrace bindingTrace = context2.getTrace();
            PsiElement psiElement = declaration2;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)typeParameterWithoutNotNullableUpperBound.element;
            Intrinsics.checkNotNull(typeParameterDescriptor);
            bindingTrace.report(Errors.KCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE.on((KtNamedDeclaration)psiElement, typeParameterDescriptor));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKClassWithBadArgument(UnwrappedType $this$isKClassWithBadArgument) {
        TypeProjection typeProjection = CollectionsKt.singleOrNull($this$isKClassWithBadArgument.getArguments());
        TypeProjection typeProjection2 = typeProjection;
        if (typeProjection == null) return false;
        TypeProjection typeProjection3 = typeProjection2;
        boolean bl = false;
        boolean bl2 = false;
        TypeProjection it = typeProjection3;
        boolean bl3 = false;
        if (it.isStarProjection()) {
            return false;
        }
        UnwrappedType unwrappedType = it.getType().unwrap();
        typeProjection2 = unwrappedType;
        if (unwrappedType == null) return false;
        TypeProjection argumentType = typeProjection2;
        ClassifierDescriptor classifierDescriptor = $this$isKClassWithBadArgument.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) return false;
        ClassDescriptor klass = classDescriptor2;
        if (!KotlinBuiltIns.isKClass(klass)) return false;
        KotlinType kotlinType = (KotlinType)((Object)argumentType);
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns((KotlinType)((Object)argumentType)).getAnyType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "argumentType.builtIns.anyType");
        if (TypeUtilsKt.isSubtypeOf(kotlinType, simpleType2)) return false;
        return true;
    }

    private KClassWithIncorrectTypeArgumentChecker() {
    }

    static {
        KClassWithIncorrectTypeArgumentChecker kClassWithIncorrectTypeArgumentChecker;
        INSTANCE = kClassWithIncorrectTypeArgumentChecker = new KClassWithIncorrectTypeArgumentChecker();
    }

    public static final /* synthetic */ boolean access$isKClassWithBadArgument(KClassWithIncorrectTypeArgumentChecker $this, UnwrappedType $this$access_u24isKClassWithBadArgument) {
        return $this.isKClassWithBadArgument($this$access_u24isKClassWithBadArgument);
    }
}

