/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.storage;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.storage.DefaultSimpleLock;
import org.jetbrains.annotations.NotNull;

public final class CancellableSimpleLock
extends DefaultSimpleLock {
    private final Runnable checkCancelled;
    private final Function1<InterruptedException, Unit> interruptedExceptionHandler;

    @Override
    public void lock() {
        try {
            while (!this.getLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                this.checkCancelled.run();
            }
        }
        catch (InterruptedException e) {
            this.interruptedExceptionHandler.invoke((Object)e);
        }
    }

    public CancellableSimpleLock(@NotNull Lock lock, @NotNull Runnable checkCancelled, @NotNull Function1<? super InterruptedException, Unit> interruptedExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)checkCancelled, (String)"checkCancelled");
        Intrinsics.checkNotNullParameter(interruptedExceptionHandler, (String)"interruptedExceptionHandler");
        super(lock);
        this.checkCancelled = checkCancelled;
        this.interruptedExceptionHandler = interruptedExceptionHandler;
    }

    public CancellableSimpleLock(@NotNull Runnable checkCancelled, @NotNull Function1<? super InterruptedException, Unit> interruptedExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)checkCancelled, (String)"checkCancelled");
        Intrinsics.checkNotNullParameter(interruptedExceptionHandler, (String)"interruptedExceptionHandler");
        Function1<? super InterruptedException, Unit> function1 = interruptedExceptionHandler;
        Lock lock = new ReentrantLock();
        Runnable runnable = checkCancelled;
        this(lock, runnable, function1);
    }
}

