/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import mediathek.daten.DatenFilm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FilmSize
implements Comparable<FilmSize> {
    private int size;
    private static final Logger logger = LogManager.getLogger();

    public FilmSize(int size) {
        this.size = size;
    }

    public FilmSize(DatenFilm film) {
        if (film.getSize().equalsIgnoreCase("<1")) {
            film.setSize("1");
        }
        try {
            if (!film.getSize().isEmpty()) {
                this.size = Integer.parseInt(film.getSize());
            }
        }
        catch (NumberFormatException ex) {
            logger.error("String: {}", (Object)film.getSize(), (Object)ex);
            this.size = 0;
        }
    }

    public String toString() {
        return this.size == 0 ? "" : Long.toString(this.size);
    }

    @Override
    public int compareTo(@NotNull FilmSize other) {
        return Integer.compare(this.size, other.size);
    }
}

