/*
 * Decompiled with CFR 0.152.
 */
package mediathek.update;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.daten.ListePsetVorlagen;
import mediathek.gui.dialog.DialogNewSet;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.NetUtils;
import mediathek.update.ProgrammUpdateSuchen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgramUpdateCheck
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(ProgramUpdateCheck.class);
    private final Daten daten;
    private ScheduledFuture<?> actionFuture;

    public ProgramUpdateCheck(Daten daten) {
        this.daten = daten;
    }

    private void searchForProgramUpdate() {
        ProgrammUpdateSuchen pgrUpdate = new ProgrammUpdateSuchen();
        pgrUpdate.checkVersion(false, true, false);
    }

    private void checkForPsetUpdates() {
        try {
            SwingUtilities.invokeLater(() -> {
                MediathekGui parent = MediathekGui.ui();
                ListePset listePsetStandard = ListePsetVorlagen.getStandarset(parent, false);
                String version = MVConfig.get(MVConfig.Configs.SYSTEM_VERSION_PROGRAMMSET);
                if (listePsetStandard != null) {
                    if (!Daten.listePset.isEmpty()) {
                        if (listePsetStandard.version.isEmpty()) {
                            return;
                        }
                        if (version.equals(listePsetStandard.version)) {
                            return;
                        }
                        DialogNewSet dialogNewSet = new DialogNewSet(parent);
                        dialogNewSet.setVisible(true);
                        if (!dialogNewSet.ok) {
                            logger.info("Setanlegen: Abbruch");
                            if (!dialogNewSet.morgen) {
                                logger.info("Setanlegen: Nicht wieder nachfragen");
                                MVConfig.add(MVConfig.Configs.SYSTEM_VERSION_PROGRAMMSET, listePsetStandard.version);
                            }
                            return;
                        }
                    }
                    ListePset.progMusterErsetzen((JFrame)parent, listePsetStandard);
                    MVConfig.add(MVConfig.Configs.SYSTEM_VERSION_PROGRAMMSET, listePsetStandard.version);
                    ListePset listePsetOrgSpeichern = Daten.listePset.getListeSpeichern();
                    if (!listePsetOrgSpeichern.isEmpty()) {
                        for (DatenPset psNew2 : listePsetStandard.getListeSpeichern()) {
                            psNew2.arr[4] = ((DatenPset)listePsetOrgSpeichern.get((int)0)).arr[4];
                            psNew2.arr[6] = ((DatenPset)listePsetOrgSpeichern.get((int)0)).arr[6];
                            psNew2.arr[11] = ((DatenPset)listePsetOrgSpeichern.get((int)0)).arr[11];
                            psNew2.arr[12] = ((DatenPset)listePsetOrgSpeichern.get((int)0)).arr[12];
                            psNew2.arr[13] = ((DatenPset)listePsetOrgSpeichern.get((int)0)).arr[13];
                            psNew2.arr[14] = ((DatenPset)listePsetOrgSpeichern.get((int)0)).arr[14];
                        }
                    }
                    if (!Daten.listePset.isEmpty()) {
                        for (DatenPset psNew2 : listePsetStandard) {
                            psNew2.arr[7] = Boolean.FALSE.toString();
                            psNew2.arr[10] = Boolean.FALSE.toString();
                            psNew2.arr[9] = Boolean.FALSE.toString();
                            psNew2.arr[8] = Boolean.FALSE.toString();
                        }
                        String date = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                        listePsetStandard.forEach(psNew -> {
                            psNew.arr[0] = psNew.arr[0] + ", neu: " + date;
                        });
                    }
                    GuiFunktionenProgramme.addSetVorlagen(MediathekGui.ui(), this.daten, listePsetStandard, true);
                    logger.info("Setanlegen: OK");
                    logger.info("==========================================");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void performUpdateCheck() {
        logger.debug("performUpdateCheck started.");
        MediathekGui gui = MediathekGui.ui();
        try {
            if (NetUtils.isReachable("res.mediathekview.de", 1000)) {
                SwingUtilities.invokeLater(() -> gui.enableUpdateMenuItem(false));
                String externalUpdateCheck = System.getProperty("externalUpdateCheck");
                if (externalUpdateCheck == null || !externalUpdateCheck.equalsIgnoreCase("true")) {
                    this.searchForProgramUpdate();
                } else {
                    logger.info("External Update Mechanism in use -> skip program update check");
                }
                this.checkForPsetUpdates();
            } else {
                logger.warn("Update Check: Network is not reachable.");
            }
        }
        finally {
            SwingUtilities.invokeLater(() -> gui.enableUpdateMenuItem(true));
        }
        logger.debug("performUpdateCheck finished.");
    }

    public void start() {
        logger.debug("ProgramUpdateCheck Started.");
        this.actionFuture = this.daten.getTimerPool().scheduleWithFixedDelay(() -> SwingUtilities.invokeLater(this::performUpdateCheck), 60L, TimeUnit.SECONDS.convert(24L, TimeUnit.HOURS), TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.actionFuture != null) {
            this.actionFuture.cancel(true);
        }
        logger.debug("ProgramUpdateCheck closed.");
    }
}

