/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import java.util.Vector;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;

public final class UpdateNode
extends DMLModStatementNode {
    public int[] changedColumnIds;
    public ExecRow emptyHeapRow;
    public boolean deferred;
    public ValueNode checkConstraints;
    public FKInfo fkInfo;
    protected FromTable targetTable;
    protected FormatableBitSet readColsBitSet;
    protected boolean positionedUpdate;
    public static final String COLUMNNAME = "###RowLocationToUpdate";

    public void init(Object object, Object object2) {
        super.init(object2);
        this.targetTableName = (TableName)object;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "UPDATE";
    }

    public void printSubNodes(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStatement() throws StandardException {
        int n;
        Object object;
        Object object2;
        QueryTreeNode queryTreeNode;
        this.getCompilerContext().pushCurrentPrivType(0);
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumn resultColumn = null;
        ValueNode valueNode = null;
        TableName tableName = null;
        CurrentOfNode currentOfNode = null;
        ResultColumnList resultColumnList = null;
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.targetTableName != null && (queryTreeNode = this.resolveTableToSynonym(this.targetTableName)) != null) {
            this.synonymTableName = this.targetTableName;
            this.targetTableName = queryTreeNode;
        }
        this.bindTables(dataDictionary);
        queryTreeNode = (SelectNode)this.resultSet;
        this.targetTable = (FromTable)((SelectNode)queryTreeNode).fromList.elementAt(0);
        if (this.targetTable instanceof CurrentOfNode) {
            this.positionedUpdate = true;
            currentOfNode = (CurrentOfNode)this.targetTable;
            tableName = currentOfNode.getBaseCursorTargetTableName();
        }
        if (this.targetTable instanceof FromVTI) {
            this.targetVTI = (FromVTI)this.targetTable;
            this.targetVTI.setTarget();
        } else if (this.targetTableName == null) {
            this.targetTableName = tableName;
        } else if (tableName != null && !this.targetTableName.equals(tableName)) {
            throw StandardException.newException("42X29", (Object)this.targetTableName, (Object)currentOfNode.getCursorName());
        }
        this.verifyTargetTable();
        ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
        ColumnDescriptorList columnDescriptorList2 = new ColumnDescriptorList();
        this.addGeneratedColumns(this.targetTableDescriptor, this.resultSet, columnDescriptorList2, columnDescriptorList);
        this.resultSet.getResultColumns().markUpdated();
        FromList fromList2 = this.resultSet.getFromList();
        if (this.synonymTableName != null) {
            this.normalizeSynonymColumns(this.resultSet.resultColumns, this.targetTable);
        }
        this.normalizeCorrelatedColumns(this.resultSet.resultColumns, this.targetTable);
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        this.resultSet.bindResultColumns(this.targetTableDescriptor, this.targetVTI, this.resultSet.resultColumns, this, fromList);
        this.getCompilerContext().popCurrentPrivType();
        this.forbidGenerationOverrides(this.resultSet.getResultColumns(), columnDescriptorList);
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        if (!languageConnectionContext.getAutoincrementUpdate()) {
            this.resultSet.getResultColumns().forbidOverrides(null);
        }
        boolean bl = false;
        if (this.targetTable instanceof FromBaseTable) {
            ((FromBaseTable)this.targetTable).markUpdated(this.resultSet.getResultColumns());
        } else if (this.targetTable instanceof FromVTI) {
            this.resultColumnList = this.resultSet.getResultColumns();
        } else {
            object2 = currentOfNode.getCursorStatement();
            object = object2.getUpdateColumns();
            if (object == null || ((String[])object).length == 0) {
                this.getResultColumnList();
                resultColumnList = this.resultSet.getResultColumns().expandToAll(this.targetTableDescriptor, this.targetTable.getTableName());
                this.getAffectedIndexes(this.targetTableDescriptor, null, null);
                bl = true;
            } else {
                this.resultSet.getResultColumns().checkColumnUpdateability((String[])object, currentOfNode.getCursorName());
            }
        }
        this.changedColumnIds = this.getChangedColumnIds(this.resultSet.getResultColumns());
        if (!bl && this.targetVTI == null) {
            this.getCompilerContext().pushCurrentPrivType(-1);
            try {
                int n2;
                this.readColsBitSet = new FormatableBitSet();
                object2 = this.getResultColumnList(this.resultSet.getResultColumns());
                resultColumnList = this.resultSet.getResultColumns().copyListAndObjects();
                this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor, resultColumnList, columnDescriptorList2);
                resultColumnList = ((FromBaseTable)object2).addColsToList(resultColumnList, this.readColsBitSet);
                this.resultColumnList = ((FromBaseTable)object2).addColsToList(this.resultColumnList, this.readColsBitSet);
                n = this.targetTableDescriptor.getMaxColumnID();
                for (n2 = 1; n2 <= n && this.readColsBitSet.get(n2); ++n2) {
                }
                if (n2 > n) {
                    this.readColsBitSet = null;
                    bl = true;
                }
            }
            finally {
                this.getCompilerContext().popCurrentPrivType();
            }
        }
        if (this.targetVTI == null) {
            this.emptyHeapRow = this.targetTableDescriptor.getEmptyExecRow();
            this.resultColumnList.appendResultColumns(resultColumnList, false);
            valueNode = (ValueNode)this.getNodeFactory().getNode(2, this.getContextManager());
        } else {
            valueNode = (ValueNode)this.getNodeFactory().getNode(70, ReuseFactory.getInteger(0), this.getContextManager());
        }
        resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, COLUMNNAME, valueNode, this.getContextManager());
        resultColumn.markGenerated();
        this.resultColumnList.addResultColumn(resultColumn);
        this.checkTableNameAndScrubResultColumns(this.resultColumnList);
        this.resultSet.setResultColumns(this.resultColumnList);
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        super.bindExpressions();
        this.getCompilerContext().popCurrentPrivType();
        this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
        if (null != resultColumn) {
            resultColumn.bindResultColumnToExpression();
        }
        this.resultColumnList.checkStorableExpressions();
        if (!this.resultColumnList.columnTypesAndLengthsMatch()) {
            this.resultSet = (ResultSetNode)this.getNodeFactory().getNode(122, this.resultSet, this.resultColumnList, null, Boolean.TRUE, this.getContextManager());
            if (this.hasCheckConstraints(dataDictionary, this.targetTableDescriptor) || this.hasGenerationClauses(this.targetTableDescriptor)) {
                int n3 = resultColumnList.size();
                resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
                object = this.resultSet.getResultColumns();
                for (n = 0; n < n3; ++n) {
                    resultColumnList.addElement(((QueryTreeNodeVector)object).elementAt(n + n3));
                }
            }
        }
        if (null != this.targetVTI) {
            this.deferred = VTIDeferModPolicy.deferIt(2, this.targetVTI, this.resultColumnList.getColumnNames(), ((SelectNode)queryTreeNode).getWhereClause());
        } else {
            boolean bl2 = this.getAllRelevantTriggers(dataDictionary, this.targetTableDescriptor, this.changedColumnIds, true).size() > 0;
            object = bl2 ? this.resultColumnList : resultColumnList;
            this.parseAndBindGenerationClauses(dataDictionary, this.targetTableDescriptor, resultColumnList, this.resultColumnList, true, this.resultSet);
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getNodeFactory(), this.targetTableDescriptor, null, (ResultColumnList)object, this.changedColumnIds, this.readColsBitSet, false, true);
            if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
            }
        }
        this.getCompilerContext().popCurrentPrivType();
    }

    int getPrivType() {
        return 1;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor;
        if (!this.deferred && (conglomerateDescriptor = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && conglomerateDescriptor.isIndex()) {
            int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(nArray)) {
                this.deferred = true;
            }
        }
        if (null == this.targetTableDescriptor) {
            return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(2, this.deferred, this.changedColumnIds);
        }
        int n = this.resultSet.updateTargetLockMode();
        long l = this.targetTableDescriptor.getHeapConglomerateId();
        TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
        StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
        for (int i = 0; i < staticCompiledOpenConglomInfoArray.length; ++i) {
            staticCompiledOpenConglomInfoArray[i] = transactionController.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[i]);
        }
        if (this.targetTableDescriptor.getLockGranularity() == 'T') {
            n = 7;
        }
        return this.getGenericConstantActionFactory().getUpdateConstantAction(l, this.targetTableDescriptor.getTableType(), transactionController.getStaticCompiledConglomInfo(l), this.indicesToMaintain, this.indexConglomerateNumbers, staticCompiledOpenConglomInfoArray, this.indexNames, this.emptyHeapRow, this.deferred, this.targetTableDescriptor.getUUID(), n, false, this.changedColumnIds, null, null, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), UpdateNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), this.positionedUpdate, this.resultSet.isOneRowResultSet());
    }

    protected void setDeferredForUpdateOfIndexColumn() {
        ConglomerateDescriptor conglomerateDescriptor;
        if (!this.deferred && (conglomerateDescriptor = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && conglomerateDescriptor.isIndex()) {
            int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(nArray)) {
                this.deferred = true;
            }
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCodeForTemporaryTable(activationClassBuilder, activationClassBuilder.getExecuteMethod());
        if (!this.isDependentTable) {
            this.generateParameterValueSet(activationClassBuilder);
        }
        activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.CursorResultSet", activationClassBuilder.newRowLocationScanResultSetName());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.resultSet.generate(activationClassBuilder, methodBuilder);
        if (null != this.targetVTI) {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            methodBuilder.callMethod((short)185, null, "getUpdateVTIResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
        } else {
            this.generateGenerationClauses(this.resultColumnList, this.resultSet.getResultSetNumber(), true, activationClassBuilder, methodBuilder);
            this.generateCheckConstraints(this.checkConstraints, activationClassBuilder, methodBuilder);
            if (this.isDependentTable) {
                methodBuilder.push(activationClassBuilder.addItem(this.makeConstantAction()));
                methodBuilder.push(activationClassBuilder.addItem(this.makeResultDescription()));
                methodBuilder.callMethod((short)185, null, "getDeleteCascadeUpdateResultSet", "org.apache.derby.iapi.sql.ResultSet", 5);
            } else {
                methodBuilder.callMethod((short)185, null, "getUpdateResultSet", "org.apache.derby.iapi.sql.ResultSet", 3);
            }
        }
    }

    protected final int getStatementType() {
        return 3;
    }

    public FormatableBitSet getReadMap(DataDictionary dataDictionary, TableDescriptor tableDescriptor, ResultColumnList resultColumnList, ColumnDescriptorList columnDescriptorList) throws StandardException {
        boolean[] blArray = new boolean[]{this.requiresDeferredProcessing()};
        Vector vector = new Vector();
        this.relevantCdl = new ConstraintDescriptorList();
        this.relevantTriggers = new GenericDescriptorList();
        FormatableBitSet formatableBitSet = UpdateNode.getUpdateReadMap(dataDictionary, tableDescriptor, resultColumnList, vector, this.relevantCdl, this.relevantTriggers, blArray, columnDescriptorList);
        this.markAffectedIndexes(vector);
        this.adjustDeferredFlag(blArray[0]);
        return formatableBitSet;
    }

    private int[] getChangedColumnIds(ResultColumnList resultColumnList) {
        if (resultColumnList == null) {
            return null;
        }
        return resultColumnList.sortMe();
    }

    public static FormatableBitSet getUpdateReadMap(DataDictionary dataDictionary, TableDescriptor tableDescriptor, ResultColumnList resultColumnList, Vector vector, ConstraintDescriptorList constraintDescriptorList, GenericDescriptorList genericDescriptorList, boolean[] blArray, ColumnDescriptorList columnDescriptorList) throws StandardException {
        Object object;
        int n;
        int n2;
        int n3 = tableDescriptor.getMaxColumnID();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n3 + 1);
        int[] nArray = resultColumnList.sortMe();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            formatableBitSet.set(nArray[n2]);
        }
        DMLModStatementNode.getXAffectedIndexes(tableDescriptor, resultColumnList, formatableBitSet, vector);
        tableDescriptor.getAllRelevantConstraints(3, false, nArray, blArray, constraintDescriptorList);
        n2 = constraintDescriptorList.size();
        for (n = 0; n < n2; ++n) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            object = ((CheckConstraintDescriptor)constraintDescriptor).getReferencedColumns();
            for (int i = 0; i < ((int[])object).length; ++i) {
                formatableBitSet.set(object[i]);
            }
        }
        UpdateNode.addGeneratedColumnPrecursors(tableDescriptor, columnDescriptorList, formatableBitSet);
        tableDescriptor.getAllRelevantTriggers(3, nArray, genericDescriptorList);
        if (genericDescriptorList.size() > 0) {
            blArray[0] = true;
            n = 0;
            boolean bl = dataDictionary.checkVersion(210, null);
            object = genericDescriptorList.iterator();
            while (object.hasNext()) {
                TriggerDescriptor triggerDescriptor = (TriggerDescriptor)object.next();
                if (bl) {
                    int n4;
                    int[] nArray2 = triggerDescriptor.getReferencedColsInTriggerAction();
                    int[] nArray3 = triggerDescriptor.getReferencedCols();
                    if (nArray3 == null || nArray3.length == 0) {
                        for (n4 = 0; n4 < n3; ++n4) {
                            formatableBitSet.set(n4 + 1);
                        }
                        break;
                    }
                    if (nArray2 == null || nArray2.length == 0) {
                        if (!triggerDescriptor.getReferencingNew() && !triggerDescriptor.getReferencingOld()) {
                            for (n4 = 0; n4 < nArray3.length; ++n4) {
                                formatableBitSet.set(nArray3[n4]);
                            }
                            continue;
                        }
                        n = 1;
                        break;
                    }
                    for (n4 = 0; n4 < nArray3.length; ++n4) {
                        formatableBitSet.set(nArray3[n4]);
                    }
                    for (n4 = 0; n4 < nArray2.length; ++n4) {
                        formatableBitSet.set(nArray2[n4]);
                    }
                    continue;
                }
                if (!triggerDescriptor.getReferencingNew() && !triggerDescriptor.getReferencingOld()) continue;
                n = 1;
                break;
            }
            if (n != 0) {
                for (int i = 1; i <= n3; ++i) {
                    formatableBitSet.set(i);
                }
            }
        }
        return formatableBitSet;
    }

    private static void addGeneratedColumnPrecursors(TableDescriptor tableDescriptor, ColumnDescriptorList columnDescriptorList, FormatableBitSet formatableBitSet) throws StandardException {
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            String[] stringArray = columnDescriptor.getDefaultInfo().getReferencedColumnNames();
            int[] nArray = tableDescriptor.getColumnIDs(stringArray);
            int n2 = nArray.length;
            for (int j = 0; j < n2; ++j) {
                formatableBitSet.set(nArray[j]);
            }
        }
    }

    private void addGeneratedColumns(TableDescriptor tableDescriptor, ResultSetNode resultSetNode, ColumnDescriptorList columnDescriptorList, ColumnDescriptorList columnDescriptorList2) throws StandardException {
        Object object;
        int n;
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        int n2 = resultColumnList.size();
        ColumnDescriptorList columnDescriptorList3 = tableDescriptor.getGeneratedColumns();
        int n3 = columnDescriptorList3.size();
        int n4 = tableDescriptor.getMaxColumnID();
        HashSet<String> hashSet = new HashSet<String>();
        UUID uUID = tableDescriptor.getObjectID();
        for (n = 0; n < n2; ++n) {
            object = ((ResultColumn)resultColumnList.elementAt(n)).getName();
            hashSet.add((String)object);
        }
        block1: for (n = 0; n < n3; ++n) {
            object = columnDescriptorList3.elementAt(n);
            DefaultInfo defaultInfo = ((ColumnDescriptor)object).getDefaultInfo();
            String[] stringArray = defaultInfo.getReferencedColumnNames();
            int n5 = stringArray.length;
            if (hashSet.contains(((ColumnDescriptor)object).getColumnName())) {
                columnDescriptorList.add(uUID, (ColumnDescriptor)object);
            }
            for (int i = 0; i < n5; ++i) {
                String string = stringArray[i];
                if (!hashSet.contains(string)) continue;
                columnDescriptorList.add(uUID, (ColumnDescriptor)object);
                if (hashSet.contains(((ColumnDescriptor)object).getColumnName())) continue block1;
                columnDescriptorList2.add(uUID, (ColumnDescriptor)object);
                ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(13, this.getContextManager());
                ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, ((ColumnDescriptor)object).getType(), valueNode, this.getContextManager());
                resultColumn.setColumnDescriptor(tableDescriptor, (ColumnDescriptor)object);
                resultColumn.setName(((ColumnDescriptor)object).getColumnName());
                resultColumnList.addResultColumn(resultColumn);
                continue block1;
            }
        }
    }

    private void normalizeCorrelatedColumns(ResultColumnList resultColumnList, FromTable fromTable) throws StandardException {
        String string = fromTable.getCorrelationName();
        if (string == null) {
            return;
        }
        TableName tableName = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName() : this.makeTableName(null, fromTable.getBaseTableName());
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            ColumnReference columnReference = resultColumn.getReference();
            if (columnReference == null || !string.equals(columnReference.getTableName())) continue;
            columnReference.setTableNameNode(tableName);
        }
    }

    private void checkTableNameAndScrubResultColumns(ResultColumnList resultColumnList) throws StandardException {
        int n = resultColumnList.size();
        int n2 = ((SelectNode)this.resultSet).fromList.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (resultColumn.getTableName() != null) {
                for (int j = 0; j < n2; ++j) {
                    FromTable fromTable = (FromTable)((SelectNode)this.resultSet).fromList.elementAt(j);
                    String string = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName().getTableName() : fromTable.getBaseTableName();
                    if (!resultColumn.getTableName().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw StandardException.newException("42X04", resultColumn.getTableName() + "." + resultColumn.getName());
                }
            }
            resultColumn.clearTableName();
        }
    }

    private void normalizeSynonymColumns(ResultColumnList resultColumnList, FromTable fromTable) throws StandardException {
        if (fromTable.getCorrelationName() != null) {
            return;
        }
        TableName tableName = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName() : this.makeTableName(null, fromTable.getBaseTableName());
        super.normalizeSynonymColumns(resultColumnList, tableName);
    }

    private void forbidGenerationOverrides(ResultColumnList resultColumnList, ColumnDescriptorList columnDescriptorList) throws StandardException {
        int n = resultColumnList.size();
        ResultColumnList resultColumnList2 = this.resultSet.getResultColumns();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode;
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (!resultColumn.hasGenerationClause() || (valueNode = ((ResultColumn)resultColumnList2.elementAt(i)).getExpression()) instanceof DefaultNode) continue;
            boolean bl = false;
            String string = resultColumn.getTableColumnDescriptor().getColumnName();
            int n2 = columnDescriptorList.size();
            for (int j = 0; j < n2; ++j) {
                String string2 = columnDescriptorList.elementAt(j).getColumnName();
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw StandardException.newException("42XA3", resultColumn.getName());
        }
    }
}

