/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.spans.AssertingSpans;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

public class AssertingSpanWeight
extends SpanWeight {
    final SpanWeight in;

    public AssertingSpanWeight(IndexSearcher searcher, SpanWeight in) throws IOException {
        super((SpanQuery)in.getQuery(), searcher, null, 1.0f);
        this.in = in;
    }

    public void extractTermStates(Map<Term, TermStates> contexts) {
        this.in.extractTermStates(contexts);
    }

    public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
        Spans spans = this.in.getSpans(context, requiredPostings);
        if (spans == null) {
            return null;
        }
        return new AssertingSpans(spans);
    }

    public LeafSimScorer getSimScorer(LeafReaderContext context) throws IOException {
        return this.in.getSimScorer(context);
    }

    public void extractTerms(Set<Term> terms) {
        this.in.extractTerms(terms);
    }

    public SpanScorer scorer(LeafReaderContext context) throws IOException {
        return this.in.scorer(context);
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return this.in.isCacheable(ctx);
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.in.explain(context, doc);
    }
}

