/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.util.NamedList;

public class CollectionAdminResponse
extends SolrResponseBase {
    public NamedList<NamedList<Object>> getCollectionStatus() {
        return (NamedList)this.getResponse().get("success");
    }

    public boolean isSuccess() {
        return this.getResponse().get("success") != null;
    }

    public String getWarning() {
        return (String)this.getResponse().get("warning");
    }

    public NamedList<String> getErrorMessages() {
        return (NamedList)this.getResponse().get("failure");
    }

    public Map<String, NamedList<Integer>> getCollectionCoresStatus() {
        HashMap<String, NamedList<Integer>> res = new HashMap<String, NamedList<Integer>>();
        NamedList<NamedList<Object>> cols = this.getCollectionStatus();
        if (cols != null) {
            for (Map.Entry<String, NamedList<Object>> entry : cols) {
                NamedList<Object> item = entry.getValue();
                String core = (String)item.get("core");
                if (core == null) continue;
                res.put(core, (NamedList)item.get("responseHeader"));
            }
        }
        return res;
    }

    public Map<String, String> getAliases() {
        NamedList<Object> response = this.getResponse();
        if (response.get("aliases") != null) {
            return (Map)response.get("aliases");
        }
        return Collections.emptyMap();
    }

    public Map<String, List<String>> getAliasesAsLists() {
        return Aliases.convertMapOfCommaDelimitedToMapOfList(this.getAliases());
    }

    public Map<String, Map<String, String>> getAliasProperties() {
        NamedList<Object> response = this.getResponse();
        if (response.get("properties") != null) {
            return (Map)response.get("properties");
        }
        return Collections.emptyMap();
    }

    public Map<String, NamedList<Integer>> getCollectionNodesStatus() {
        HashMap<String, NamedList<Integer>> res = new HashMap<String, NamedList<Integer>>();
        NamedList<NamedList<Object>> cols = this.getCollectionStatus();
        if (cols != null) {
            for (Map.Entry<String, NamedList<Object>> entry : cols) {
                if (entry.getKey() == null) continue;
                res.put(entry.getKey(), (NamedList)entry.getValue().get("responseHeader"));
            }
        }
        return res;
    }
}

