/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.solr.api.ApiBag;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.util.JsonSchemaValidator;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public abstract class Api
implements SpecProvider {
    protected SpecProvider spec;
    protected volatile Map<String, JsonSchemaValidator> commandSchema;

    protected Api(SpecProvider spec) {
        this.spec = spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JsonSchemaValidator> getCommandSchema() {
        if (this.commandSchema == null) {
            Api api = this;
            synchronized (api) {
                if (this.commandSchema == null) {
                    ValidatingJsonMap commands = this.getSpec().getMap("commands", null);
                    this.commandSchema = commands != null ? ImmutableMap.copyOf(ApiBag.getParsedSchema(commands)) : ImmutableMap.of();
                }
            }
        }
        return this.commandSchema;
    }

    public abstract void call(SolrQueryRequest var1, SolrQueryResponse var2);

    public ValidatingJsonMap getSpec() {
        return this.spec.getSpec();
    }
}

