/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.java;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.DriverManager;

public class JavaSystem {
    public static int gcFrequency;
    public static int memoryRecords;
    static final BigDecimal BD_1;
    static final BigDecimal MBD_1;

    public static void gc() {
        if (gcFrequency > 0 && memoryRecords > gcFrequency) {
            memoryRecords = 0;
            System.gc();
        }
    }

    public static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable);
    }

    public static int precision(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n = bigDecimal.compareTo(BD_1) < 0 && bigDecimal.compareTo(MBD_1) > 0 ? bigDecimal.scale() : bigDecimal.precision();
        return n;
    }

    public static String toString(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.toPlainString();
    }

    public static void setLogToSystem(boolean bl) {
        try {
            PrintWriter printWriter = bl ? new PrintWriter(System.out) : null;
            DriverManager.setLogWriter(printWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        BD_1 = BigDecimal.valueOf(1L);
        MBD_1 = BigDecimal.valueOf(-1L);
    }
}

