/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.pkg;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrClassLoader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.pkg.PackageAPI;
import org.apache.solr.pkg.PackageListeners;
import org.apache.solr.pkg.PackageLoader;

public class PackageListeningClassLoader
implements SolrClassLoader,
PackageListeners.Listener {
    private final CoreContainer coreContainer;
    private final SolrResourceLoader coreResourceLoader;
    private final Function<String, String> pkgVersionSupplier;
    private Map<String, PackageAPI.PkgVersion> packageVersions = new HashMap<String, PackageAPI.PkgVersion>(1);
    private final Runnable onReload;

    public PackageListeningClassLoader(CoreContainer coreContainer, SolrResourceLoader coreResourceLoader, Function<String, String> pkgVersionSupplier, Runnable onReload) {
        this.coreContainer = coreContainer;
        this.coreResourceLoader = coreResourceLoader;
        this.pkgVersionSupplier = pkgVersionSupplier;
        this.onReload = () -> {
            this.packageVersions = new HashMap<String, PackageAPI.PkgVersion>();
            onReload.run();
        };
    }

    public <T> T newInstance(String cname, Class<T> expectedType, String ... subpackages) {
        PluginInfo.ClassName cName = new PluginInfo.ClassName(cname);
        if (cName.pkg == null) {
            return this.coreResourceLoader.newInstance(cname, expectedType, subpackages);
        }
        PackageLoader.Package.Version version = this.findPkgVersion(cName);
        return this.applyResourceLoaderAware(version, version.getLoader().newInstance(cName.className, expectedType, subpackages));
    }

    private PackageLoader.Package.Version findPkgVersion(PluginInfo.ClassName cName) {
        PackageLoader.Package.Version theVersion = this.coreContainer.getPackageLoader().getPackage(cName.pkg).getLatest(this.pkgVersionSupplier.apply(cName.pkg));
        this.packageVersions.put(cName.pkg, theVersion.getPkgVersion());
        return theVersion;
    }

    @Override
    public MapWriter getPackageVersion(PluginInfo.ClassName cName) {
        if (cName.pkg == null) {
            return null;
        }
        PackageAPI.PkgVersion p = this.packageVersions.get(cName.pkg);
        return p == null ? null : arg_0 -> ((PackageAPI.PkgVersion)p).writeMap(arg_0);
    }

    private <T> T applyResourceLoaderAware(PackageLoader.Package.Version version, T obj) {
        if (obj instanceof ResourceLoaderAware) {
            SolrResourceLoader.assertAwareCompatibility(ResourceLoaderAware.class, obj);
            try {
                ((ResourceLoaderAware)obj).inform((ResourceLoader)version.getLoader());
                return obj;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        return obj;
    }

    public <T> T newInstance(String cname, Class<T> expectedType, String[] subPackages, Class[] params, Object[] args) {
        PluginInfo.ClassName cName = new PluginInfo.ClassName(cname);
        if (cName.pkg == null) {
            return this.coreResourceLoader.newInstance(cname, expectedType, subPackages, params, args);
        }
        PackageLoader.Package.Version version = this.findPkgVersion(cName);
        return this.applyResourceLoaderAware(version, version.getLoader().newInstance(cName.className, expectedType, subPackages, params, args));
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        PluginInfo.ClassName cName = new PluginInfo.ClassName(cname);
        if (cName.pkg == null) {
            return this.coreResourceLoader.findClass(cname, expectedType);
        }
        PackageLoader.Package.Version version = this.findPkgVersion(cName);
        return version.getLoader().findClass(cName.className, expectedType);
    }

    @Override
    public String packageName() {
        return null;
    }

    @Override
    public PluginInfo pluginInfo() {
        return null;
    }

    @Override
    public void changed(PackageLoader.Package pkg, PackageListeners.Listener.Ctx ctx) {
        PackageAPI.PkgVersion currVer = this.packageVersions.get(pkg.name);
        if (currVer == null) {
            return;
        }
        String latestSupportedVersion = this.pkgVersionSupplier.apply(pkg.name);
        if (latestSupportedVersion == null) {
            latestSupportedVersion = pkg.getLatest().getVersion();
        }
        if (Objects.equals(currVer.version, latestSupportedVersion)) {
            return;
        }
        ctx.runLater(null, this.onReload);
    }
}

