/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class RedactionUtils {
    public static final String SOLR_REDACTION_SYSTEM_PATTERN_PROP = "solr.redaction.system.pattern";
    private static Pattern pattern = Pattern.compile(System.getProperty("solr.redaction.system.pattern", ".*password.*"), 2);
    private static final String REDACT_STRING = "--REDACTED--";
    public static final String NODE_REDACTION_PREFIX = "N_";
    public static final String COLL_REDACTION_PREFIX = "COLL_";
    private static boolean redactSystemProperty = Boolean.parseBoolean(System.getProperty("solr.redaction.system.enabled", "true"));

    public static boolean isSystemPropertySensitive(String name) {
        return redactSystemProperty && pattern.matcher(name).matches();
    }

    public static String getRedactString() {
        return REDACT_STRING;
    }

    public static void setRedactSystemProperty(boolean redactSystemProperty) {
        RedactionUtils.redactSystemProperty = redactSystemProperty;
    }

    public static String redactNames(Map<String, String> redactions, String data) {
        TreeMap<String, String> sorted = new TreeMap<String, String>(Comparator.comparing(String::length).reversed().thenComparing(String::compareTo));
        sorted.putAll(redactions);
        for (Map.Entry entry : sorted.entrySet()) {
            data = data.replaceAll("\\Q" + (String)entry.getKey() + "\\E", (String)entry.getValue());
        }
        return data;
    }

    public static final class RedactionContext {
        private Map<String, String> redactions = new HashMap<String, String>();
        Map<String, Set<Integer>> uniqueCodes = new HashMap<String, Set<Integer>>();
        Map<String, Integer> codeSpaces = new HashMap<String, Integer>();

        public void addName(String name, String redactionPrefix) {
            if (this.redactions.containsKey(name)) {
                return;
            }
            int codeSpace = this.codeSpaces.computeIfAbsent(redactionPrefix, p -> 4);
            int code = Math.abs(name.hashCode() % codeSpace);
            Set uniqueCode = this.uniqueCodes.computeIfAbsent(redactionPrefix, p -> new HashSet());
            while (uniqueCode.contains(code)) {
                this.codeSpaces.put(redactionPrefix, codeSpace <<= 1);
                code = Math.abs(name.hashCode() % codeSpace);
            }
            uniqueCode.add(code);
            this.redactions.put(name, redactionPrefix + Integer.toString(code, 36));
        }

        public void addEquivalentName(String original, String equivalent, String redactionPrefix) {
            if (!this.redactions.containsKey(original)) {
                this.addName(original, redactionPrefix);
            }
            String redaction = this.redactions.get(original);
            this.redactions.put(equivalent, redaction);
        }

        public Map<String, String> getRedactions() {
            return this.redactions;
        }
    }
}

