;;; http-headers.el --- Look up the meaning of HTTP headers
;;
;; This file was automatically generated by
;; https://github.com/for-GET/know-your-http-well
;;
;;; Commentary:
;;; Code goes here:

(defconst http-headers
  '(("content-encoding" ("indicates what content codings have been applied to the representation, beyond those inherent in the media type, and thus what decoding mechanisms have to be applied in order to obtain data in the media type referenced by the Content-Type header field."))
("content-language" ("describes the natural language(s) of the intended audience for the representation."))
("content-location" ("references a URI that can be used as an identifier for a specific resource corresponding to the representation in this message's payload."))
("content-type" ("indicates the media type of the associated representation: either the representation enclosed in the message payload or the selected representation, as determined by the message semantics."))
("content-length" ("can provide the anticipated size, as a decimal number of octets, for a potential payload body."))
("content-range" ("is sent in a single part 206 (Partial Content) response to indicate the partial range of the selected representation enclosed as the message payload, sent in each part of a multipart 206 response to indicate the range enclosed within each body part, and sent in 416 (Range Not Satisfiable) responses to provide information about the selected representation."))
("transfer-encoding" ("lists the transfer coding names corresponding to the sequence of transfer codings that have been (or will be) applied to the payload body in order to form the message body."))
("cache-control" ("is used to specify directives for caches along the request/response chain."))
("expect" ("is used to indicate that particular server behaviors are required by the client."))
("host" ("provides the host and port information from the target URI, enabling the origin server to distinguish among resources while servicing requests for multiple host names on a single IP address."))
("max-forwards" ("provides a mechanism with the TRACE and OPTIONS methods to limit the number of times that the request is forwarded by proxies."))
("pragma" ("allows backwards compatibility with HTTP/1.0 caches, so that clients can specify a no-cache request that they will understand (as Cache-Control was not defined until HTTP/1.1)."))
("range" ("modifies the method semantics to request transfer of only one or more subranges of the selected representation data, rather than the entire selected representation data."))
("te" ("indicates what transfer codings, besides chunked, the client is willing to accept in response, and whether or not the client is willing to accept trailer fields in a chunked transfer coding."))
("if-match" ("can be used to make a request method conditional on the current existence or value of an entity-tag for one or more representations of the target resource."))
("if-modified-since" ("can be used with GET or HEAD to make the method conditional by modification date: if the selected representation has not been modified since the time specified in this field, then do not perform the request method; instead, respond as detailed below."))
("if-none-match" ("can be used to make a request method conditional on not matching any of the current entity-tag values for representations of the target resource."))
("if-range" ("Informally, its meaning is: if the representation is unchanged, send me the part(s) that I am requesting in Range; otherwise, send me the entire representation."))
("if-unmodified-since" ("can be used to make a request method conditional by modification date: if the selected representation has been modified since the time specified in this field, then the server MUST NOT perform the requested operation and MUST instead respond with the 412 (Precondition Failed) status code."))
("accept" ("can be used to specify certain media types which are acceptable for the response."))
("accept-charset" ("can be sent by a user agent to indicate what charsets are acceptable in textual response content."))
("accept-encoding" ("can be used by user agents to indicate what response content-codings are acceptable in the response."))
("accept-language" ("can be used by user agents to indicate the set of natural languages that are preferred in the response."))
("authorization" ("allows a user agent to authenticate itself with a server -- usually, but not necessarily, after receiving a 401 (Unauthorized) response."))
("proxy-authorization" ("allows the client to identify itself (or its user) to a proxy that requires authentication."))
("dnt" ("defined as the means for expressing a user's tracking preference via HTTP."))
("from" ("contains an Internet email address for a human user who controls the requesting user agent."))
("referer" ("allows the user agent to specify a URI reference for the resource from which the target URI was obtained (i.e., the referrer, though the field name is misspelled)."))
("user-agent" ("contains information about the user agent originating the request, which is often used by servers to help identify the scope of reported interoperability problems, to work around or tailor responses to avoid particular user agent limitations, and for analytics regarding browser or operating system use."))
("age" ("conveys the sender's estimate of the amount of time since the response was generated or successfully validated at the origin server."))
("cache-control" ("is used to specify directives for caches along the request/response chain."))
("expires" ("gives the date/time after which the response is considered stale."))
("date" ("represents the date and time at which the message was originated"))
("location" ("is used in some responses to refer to a specific resource in relation to the response."))
("retry-after" ("indicates how long the user agent ought to wait before making a follow-up request."))
("tk" ("defined as an OPTIONAL means for indicating the tracking status that applied to the corresponding request and as a REQUIRED means for indicating that a state-changing request has resulted in an interactive change to the tracking status. "))
("vary" ("describes what parts of a request message, aside from the method and request target, might influence the origin server's process for selecting and representing the response."))
("warning" ("is used to carry additional information about the status or transformation of a message that might not be reflected in the message."))
("etag" ("provides the current entity-tag for the selected representation, as determined at the conclusion of handling the request."))
("last-modified" ("provides a timestamp indicating the date and time at which the origin server believes the selected representation was last modified, as determined at the conclusion of handling the request."))
("www-authenticate" ("consists of at least one challenge that indicates the authentication scheme(s) and parameters applicable to the effective request URI."))
("proxy-authenticate" ("consists of at least one challenge that indicates the authentication scheme(s) and parameters applicable to the proxy for this effective request URI."))
("accept-ranges" ("allows a server to indicate that it supports range requests for the target resource."))
("allow" ("lists the set of methods advertised as supported by the target resource."))
("server" ("contains information about the software used by the origin server to handle the request, which is often used by clients to help identify the scope of reported interoperability problems, to work around or tailor requests to avoid particular server limitations, and for analytics regarding server or operating system use."))
("accept-patch" ("used to specify the patch document formats accepted by the server."))
("accept-post" ("indicates server support for specific media types for entity bodies in HTTP POST requests."))
("access-control-allow-credentials" ("indicates whether the response to request can be exposed when the omit credentials flag is unset"))
("access-control-allow-headers" ("indicates, as part of the response to a preflight request, which header field names can be used during the actual request"))
("access-control-allow-methods" ("indicates, as part of the response to a preflight request, which methods can be used during the actual request"))
("access-control-allow-origin" ("indicates whether a resource can be shared"))
("access-control-expose-headers" ("indicates which headers are safe to expose to the API of a CORS API specification"))
("access-control-max-age" ("indicates how long the results of a preflight request can be cached in a preflight result cache"))
("access-control-request-headers" ("indicates which headers will be used in the actual request as part of the preflight request"))
("access-control-request-method" ("indicates which method will be used in the actual request as part of the preflight request"))
("content-disposition" ("standard"))
("content-security-policy" ("is the preferred mechanism for delivering a CSP policy"))
("content-security-policy-report-only" ("lets servers experiment with policies by monitoring (rather than enforcing) a policy"))
("cookie" ("standard"))
("forwarded" ("standard"))
("link" ("provides a means for serialising one or more links in HTTP headers."))
("origin" ("standard"))
("prefer" ("is used to indicate that particular server behaviors are preferred by the client, but not required for successful completion of the request."))
("preference-applied" ("MAY be included within a response message as an indication as to which Prefer tokens were honored by the server and applied to the processing of a request."))
("set-cookie" ("standard"))
("strict-transport-security" ("standard"))
("accept-ch" ("advertise support for Client Hints"))
("accept-features" ("can be used by a user agent to give information about the presence or absence of certain features in the feature set of the current request."))
("alpn" ("indicates the application-layer protocol that a client intends to use within the tunnel, or a set of protocols that might be used within the tunnel."))
("alt-svc" ("is advertising the availability of alternate services to HTTP/1.1 and HTTP/2.0 clients by adding an Alt-Svc header field to responses."))
("alternates" ("is used to convey the list of variants bound to a negotiable resource."))
("ch" ("describes an example list of client preferences that the server can use to adapt and optimize the resource to satisfy a given request."))
("content-base" ("obsoleted"))
("content-dpr" ("is a number that indicates the ratio between physical pixels over CSS px of the selected image response."))
("dasl" ("standard"))
("dav" ("standard"))
("depth" ("standard"))
("destination" ("standard"))
("dpr" ("is a number that, in requests, indicates the client’s current Device Pixel Ratio (DPR), which is the ratio of physical pixels over CSS px of the layout viewport on the device."))
("encryption" ("describes the encrypted content encoding(s) that have been applied to a payload body, and therefore how those content encoding(s) can be removed."))
("encryption-key" ("can be used to describe the input keying material used in the Encryption header field."))
("if" ("standard"))
("if-schedule-tag-match" ("standard"))
("key" ("allows an origin server to describe the cache key for a negotiated response: a short algorithm that can be used upon later requests to determine if the same response is reusable."))
("last-event-id" ("The value of the event source's last event ID string, encoded as UTF-8."))
("link-template" ("provides a means for serialising one or more links into HTTP headers."))
("lock-token" ("standard"))
("md" ("is a number that, in requests, indicates the client’s maximum downlink speed in megabits per second (Mbps), which is the standardized, or generally accepted, maximum download data rate for the underlying connection technology in use by the client."))
("negotiate" ("can contain directives for any content negotiation process initiated by the request."))
("nice" ("indicates that a request is less important than a request that doesn't bear this header."))
("ordering-type" ("standard"))
("overwrite" ("standard"))
("poe" ("The POE HTTP header is a request-header field whose field-value indicates the version of POE that a client supports."))
("poe-links" ("The POE-Links HTTP header is an entity-header field whose field-value is a comma-separated list of quoted URI-references (without fragment identifiers) that the origin server asserts to be POE resources. The contents of the POE-Links response header SHOULD correspond to links found in the content of the response body."))
("position" ("standard"))
("rw" ("is a number that, in requests, indicates the Resource Width (RW) in CSS px, which is either the display width of the requested resource (e.g. display width of an image), or the layout viewport width if the resource does not have a display width (e.g. a non-image asset)."))
("schedule-reply" ("standard"))
("schedule-tag" ("standard"))
("sec-websocket-accept" ("standard"))
("sec-websocket-extensions" ("standard"))
("sec-websocket-key" ("standard"))
("sec-websocket-protocol" ("standard"))
("sec-websocket-version" ("standard"))
("slug" ("standard"))
("sunset" ("allows a server to communicate the fact that a resource is expected to become unresponsive at a specific point in time."))
("tcn" ("is used by a server to signal that the resource is transparently negotiated."))
("timeout" ("standard"))
("variant-vary" ("can be used in a choice response to record any vary information which applies to the variant data (the entity body combined with some of the entity headers) contained in the response, rather than to the response as a whole."))
("x-frame-options" ("indicates a policy that specifies whether the browser should render the transmitted resource within a &lt;frame&gt; or an &lt;iframe&gt;. Servers can declare this policy in the header of their HTTP responses to prevent clickjacking attacks, which ensures that their content is not embedded into other pages or frames."))))

;;;###autoload
(defun http-header (header)
  "Display the meaning of an HTTP header"
  (interactive
   (list (completing-read "Enter HTTP header: " http-headers)))
  (let* ((lowercased-header (downcase header))
        (found (assoc lowercased-header http-headers)))
    (if found
        (let ((description (car (cdr found))))
          (message
           "%s - HTTP header\n%s"
           lowercased-header (car description) ))
      (message "%s - HTTP header\nUNKNOWN" lowercased-header))
    ))

(provide 'http-headers)

;;; http-headers.el ends here

