/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileObjectLineIterator;

final class FileObjectLines
extends AbstractSequentialList<String> {
    private final FileObjectLineIterator ready;
    final FileObject fo;

    public FileObjectLines(String encoding, FileObject fo) throws IOException {
        this.fo = fo;
        this.ready = new FileObjectLineIterator(this, encoding);
    }

    @Override
    public synchronized ListIterator<String> listIterator(int position) {
        FileObjectLineIterator ret = this.ready.cloneIterator();
        while (position-- > 0) {
            ret.next();
        }
        return ret;
    }

    @Override
    public synchronized int size() {
        int cnt = 0;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            it.next();
            ++cnt;
        }
        return cnt;
    }
}

