/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.ProgressObserver;

class PluginManagerProgress
extends JDialog
implements ProgressObserver {
    private Thread thread;
    private final JProgressBar progress;
    private final int count;
    private int done = 1;
    private int valueSoFar;
    private final Roster roster;

    PluginManagerProgress(PluginManager pluginManager, Roster roster) {
        super(pluginManager, jEdit.getProperty("plugin-manager.progress.title"), true);
        this.roster = roster;
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        this.count = roster.getOperationCount();
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            n += roster.getOperation(i).getMaximum();
        }
        this.progress.setPreferredSize(new Dimension(400, 20));
        this.progress.setMaximum(n);
        jPanel.add("North", this.progress);
        JButton jButton = new JButton(jEdit.getProperty("plugin-manager.progress.stop"));
        jButton.addActionListener(actionEvent -> {
            this.thread.stop();
            this.dispose();
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.add(jButton);
        jPanel.add("Center", jPanel2);
        this.addWindowListener(new WindowHandler());
        this.pack();
        this.setLocationRelativeTo(pluginManager);
        this.setVisible(true);
    }

    @Override
    public void setValue(long l) {
        SwingUtilities.invokeLater(() -> this.progress.setValue(this.valueSoFar + (int)l));
    }

    @Override
    public void setMaximum(long l) {
    }

    @Override
    public void setStatus(String string) {
        SwingUtilities.invokeLater(() -> this.progress.setString(string));
    }

    public void done() {
        try {
            if (this.done == this.count) {
                SwingUtilities.invokeAndWait(this::dispose);
            } else {
                SwingUtilities.invokeAndWait(() -> {
                    this.valueSoFar += this.roster.getOperation(this.done - 1).getMaximum();
                    this.progress.setValue(this.valueSoFar);
                    ++this.done;
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class WindowHandler
    extends WindowAdapter {
        boolean done;

        WindowHandler() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (this.done) {
                return;
            }
            this.done = true;
            PluginManagerProgress.this.thread = new Thread(() -> PluginManagerProgress.this.roster.performOperationsInWorkThread(PluginManagerProgress.this), "Plugin manager thread");
            PluginManagerProgress.this.thread.start();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            PluginManagerProgress.this.thread.stop();
            PluginManagerProgress.this.dispose();
        }
    }
}

