/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;

public class ParserRuleSet {
    private static final ParserRuleSet[] standard = new ParserRuleSet[19];
    private static final int BASE_CACHE = 166;
    private final String modeName;
    private final String setName;
    private Hashtable<String, String> props;
    private KeywordMap keywords;
    private int ruleCount;
    private final List<ParserRule> allRules;
    private List<ParserRule>[] ruleArray;
    private final List<ParserRule> rulesForNull;
    private final List<ParserRuleSet> imports;
    private int terminateChar = -1;
    private boolean ignoreCase = true;
    private byte defaultToken;
    private ParserRule escapeRule;
    private boolean highlightDigits;
    private Pattern digitRE;
    private String _noWordSep;
    private String noWordSep;
    private boolean builtIn;

    public static ParserRuleSet getStandardRuleSet(byte by) {
        return standard[by];
    }

    public ParserRuleSet(String string, String string2) {
        this.modeName = string;
        this.setName = string2;
        this.allRules = new ArrayList<ParserRule>();
        this.rulesForNull = new ArrayList<ParserRule>();
        this.ruleArray = new List[166];
        this.imports = new ArrayList<ParserRuleSet>();
    }

    public String getModeName() {
        return this.modeName;
    }

    public String getSetName() {
        return this.setName;
    }

    public String getName() {
        return this.modeName + "::" + this.setName;
    }

    public Hashtable<String, String> getProperties() {
        return this.props;
    }

    public void setProperties(Hashtable<String, String> hashtable) {
        this.props = hashtable;
        this._noWordSep = null;
    }

    public void resolveImports() {
        for (ParserRuleSet parserRuleSet : this.imports) {
            if (!parserRuleSet.imports.isEmpty()) {
                parserRuleSet.imports.remove(this);
                parserRuleSet.resolveImports();
            }
            parserRuleSet.allRules.forEach(this::addRule);
            if (parserRuleSet.keywords == null) continue;
            if (this.keywords == null) {
                this.keywords = new KeywordMap(this.ignoreCase);
            }
            this.keywords.add(parserRuleSet.keywords);
        }
        this.imports.clear();
    }

    public void addRuleSet(ParserRuleSet parserRuleSet) {
        this.imports.add(parserRuleSet);
    }

    public void addRule(ParserRule parserRule) {
        ++this.ruleCount;
        this.allRules.add(parserRule);
        if (parserRule.upHashChars == null) {
            if (parserRule.upHashChar == null || parserRule.upHashChar.length == 0) {
                this.rulesForNull.add(parserRule);
            } else {
                this.addRule(parserRule.upHashChar[0], parserRule);
                this.addRule(Character.toLowerCase(parserRule.upHashChar[0]), parserRule);
            }
        } else {
            for (char c : parserRule.upHashChars) {
                this.addRule(c, parserRule);
                this.addRule(Character.toLowerCase(c), parserRule);
            }
        }
    }

    private void addRule(char c, ParserRule parserRule) {
        List<ParserRule> list;
        if (c >= this.ruleArray.length) {
            this.ruleArray = Arrays.copyOf(this.ruleArray, Math.min(Math.min(this.ruleArray.length * 2, c + '\u0001'), 131071));
        }
        if ((list = this.ruleArray[c]) == null) {
            this.ruleArray[c] = list = new ArrayList<ParserRule>();
        }
        list.add(parserRule);
    }

    @Nonnull
    public List<ParserRule> getRules(char c) {
        List<ParserRule> list = null;
        if (c < this.ruleArray.length) {
            list = this.ruleArray[c];
        }
        if (this.rulesForNull.isEmpty()) {
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }
        if (list == null || list.isEmpty()) {
            return this.rulesForNull;
        }
        int n = this.rulesForNull.size() + list.size();
        ArrayList<ParserRule> arrayList = new ArrayList<ParserRule>(n);
        arrayList.addAll(list);
        arrayList.addAll(this.rulesForNull);
        return arrayList;
    }

    public int getRuleCount() {
        return this.ruleCount;
    }

    public int getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(int n) {
        this.terminateChar = n >= 0 ? n : -1;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public KeywordMap getKeywords() {
        return this.keywords;
    }

    public void setKeywords(KeywordMap keywordMap) {
        this.keywords = keywordMap;
        this._noWordSep = null;
    }

    public boolean getHighlightDigits() {
        return this.highlightDigits;
    }

    public void setHighlightDigits(boolean bl) {
        this.highlightDigits = bl;
    }

    public Pattern getDigitRegexp() {
        return this.digitRE;
    }

    public void setDigitRegexp(Pattern pattern) {
        this.digitRE = pattern;
    }

    public ParserRule getEscapeRule() {
        return this.escapeRule;
    }

    public void setEscapeRule(ParserRule parserRule) {
        this.escapeRule = parserRule;
    }

    public byte getDefault() {
        return this.defaultToken;
    }

    public void setDefault(byte by) {
        this.defaultToken = by;
    }

    public String getNoWordSep() {
        if (this._noWordSep == null) {
            this._noWordSep = this.noWordSep;
            if (this.noWordSep == null) {
                this.noWordSep = "";
            }
            if (this.keywords != null) {
                this.noWordSep = this.noWordSep + this.keywords.getNonAlphaNumericChars();
            }
        }
        return this.noWordSep;
    }

    public void setNoWordSep(String string) {
        this.noWordSep = string;
        this._noWordSep = null;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.modeName + "::" + this.setName + "]";
    }

    static {
        for (byte by = 0; by < 19; by = (byte)(by + 1)) {
            ParserRuleSet.standard[by] = new ParserRuleSet(null, null);
            standard[by].setDefault(by);
            ParserRuleSet.standard[by].builtIn = true;
        }
    }
}

