/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.inchi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import javajs.util.BS;
import javajs.util.P3;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiStructure;
import net.sf.jniinchi.JniInchiWrapper;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.api.JmolInChI;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.Elements;
import org.jmol.viewer.Viewer;

public class InChIJNI
implements JmolInChI {
    @Override
    public String getInchi(Viewer vwr, BS atoms, String molData, String options) {
        try {
            if (atoms == null ? molData == null : atoms.cardinality() == 0) {
                return "";
            }
            if (options == null) {
                options = "";
            }
            if (options.startsWith("structure/")) {
                String inchi = options.substring(10);
                JniInchiInputInchi in = new JniInchiInputInchi(inchi);
                return this.getStructure((JniInchiStructure)JniInchiWrapper.getStructureFromInchi((JniInchiInputInchi)in));
            }
            String inchi = null;
            boolean haveKey = false;
            if (molData != null && molData.startsWith("InChI=")) {
                inchi = molData;
                haveKey = true;
            } else {
                boolean bl = haveKey = (options = options.toLowerCase()).indexOf("key") >= 0;
                if (haveKey) {
                    options = options.replace("inchikey", "");
                    options = options.replace("key", "");
                }
                JniInchiInput in = new JniInchiInput(options);
                if (atoms == null) {
                    in.setStructure(InChIJNI.newJniInchiStructure(vwr, molData));
                } else {
                    in.setStructure(InChIJNI.newJniInchiStructure(vwr, atoms));
                }
                inchi = JniInchiWrapper.getInchi((JniInchiInput)in).getInchi();
            }
            return haveKey ? JniInchiWrapper.getInchiKey((String)inchi).getKey() : inchi;
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("ption") >= 0) {
                System.out.println(e.getMessage() + ": " + options.toLowerCase() + "\n See https://www.inchi-trust.org/download/104/inchi-faq.pdf for valid options");
            } else {
                e.printStackTrace();
            }
            return "";
        }
    }

    private String getStructure(JniInchiStructure mol) {
        return InChIJNI.toString(mol);
    }

    private static JniInchiStructure newJniInchiStructure(Viewer vwr, BS bsAtoms) {
        JniInchiStructure mol = new JniInchiStructure();
        JniInchiAtom[] atoms = new JniInchiAtom[bsAtoms.cardinality()];
        int[] map = new int[bsAtoms.length()];
        BS bsBonds = vwr.ms.getBondsForSelectedAtoms(bsAtoms, false);
        int pt = 0;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = vwr.ms.at[i];
            atoms[pt] = new JniInchiAtom((double)a.x, (double)a.y, (double)a.z, a.getElementSymbol());
            mol.addAtom(atoms[pt]);
            atoms[pt].setCharge(a.getFormalCharge());
            map[i] = pt++;
            i = bsAtoms.nextSetBit(i + 1);
        }
        Bond[] bonds = vwr.ms.bo;
        i = bsBonds.nextSetBit(0);
        while (i >= 0) {
            Bond bond = bonds[i];
            INCHI_BOND_TYPE order = InChIJNI.getOrder(bond.order);
            if (order != null) {
                mol.addBond(new JniInchiBond(atoms[map[bond.getAtomIndex1()]], atoms[map[bond.getAtomIndex2()]], order));
            }
            i = bsBonds.nextSetBit(i + 1);
        }
        return mol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JniInchiStructure newJniInchiStructure(Viewer vwr, String molData) {
        JniInchiStructure mol = new JniInchiStructure();
        BufferedReader r = new BufferedReader(new StringReader(molData));
        try {
            Hashtable<String, Object> htParams = new Hashtable<String, Object>();
            JmolAdapter adapter = vwr.getModelAdapter();
            Object atomSetReader = adapter.getAtomSetCollectionReader("String", null, r, htParams);
            if (atomSetReader instanceof String) {
                System.err.println("InChIJNI could not read molData");
                JniInchiStructure jniInchiStructure = null;
                return jniInchiStructure;
            }
            AtomSetCollection asc = (AtomSetCollection)adapter.getAtomSetCollection(atomSetReader);
            JmolAdapterAtomIterator ai = adapter.getAtomIterator(asc);
            JmolAdapterBondIterator bi = adapter.getBondIterator(asc);
            JniInchiAtom[] atoms = new JniInchiAtom[asc.getAtomSetAtomCount(0)];
            int n = 0;
            while (ai.hasNext() && n < atoms.length) {
                P3 p = ai.getXYZ();
                JniInchiAtom a = new JniInchiAtom((double)p.x, (double)p.y, (double)p.z, Elements.elementSymbolFromNumber(ai.getElementNumber()));
                a.setCharge(ai.getFormalCharge());
                mol.addAtom(a);
                atoms[n++] = a;
            }
            while (bi.hasNext()) {
                INCHI_BOND_TYPE order = InChIJNI.getOrder(bi.getEncodedOrder());
                if (order == null) continue;
                mol.addBond(new JniInchiBond(atoms[(Integer)bi.getAtomUniqueID1()], atoms[(Integer)bi.getAtomUniqueID2()], order));
            }
        }
        finally {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return mol;
    }

    private static INCHI_BOND_TYPE getOrder(int order) {
        switch (order) {
            case 1: 
            case 513: {
                return INCHI_BOND_TYPE.SINGLE;
            }
            case 2: 
            case 514: {
                return INCHI_BOND_TYPE.DOUBLE;
            }
            case 3: {
                return INCHI_BOND_TYPE.TRIPLE;
            }
        }
        return null;
    }

    private static String toString(JniInchiStructure mol) {
        int i;
        int na = mol.getNumAtoms();
        int nb = mol.getNumBonds();
        String s = "";
        for (i = 0; i < na; ++i) {
            s = s + mol.getAtom(i).getDebugString() + "\n";
        }
        for (i = 0; i < nb; ++i) {
            s = s + mol.getBond(i).getDebugString() + "\n";
        }
        return s;
    }
}

