/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBundle {
    private static final Logger LOG = Logger.getInstance(AbstractBundle.class);
    private Reference<ResourceBundle> myBundle;
    @NonNls
    private final String myPathToBundle;
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = ConcurrentFactoryMap.createWeakMap(k -> ContainerUtil.createConcurrentSoftValueMap());

    protected AbstractBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(0);
        }
        this.myPathToBundle = pathToBundle;
    }

    @NotNull
    public String getMessage(@NotNull String key, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(1);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(2);
        }
        return AbstractBundle.message(this.getResourceBundle(), key, params);
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        if (bundle == null) {
            AbstractBundle.$$$reportNull$$$0(12);
        }
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(13);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(14);
        }
        String string2 = BundleBase.message(bundle, key, params);
        if (string2 == null) {
            AbstractBundle.$$$reportNull$$$0(15);
        }
        return string2;
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(null);
    }

    @ApiStatus.Internal
    @NotNull
    protected ResourceBundle getResourceBundle(@Nullable ClassLoader classLoader) {
        ResourceBundle bundle = SoftReference.dereference(this.myBundle);
        if (bundle == null) {
            bundle = this.getResourceBundle(this.myPathToBundle, classLoader == null ? this.getClass().getClassLoader() : classLoader);
            this.myBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(20);
        }
        return resourceBundle;
    }

    @NotNull
    public ResourceBundle getResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader) {
        Map<String, ResourceBundle> map2;
        ResourceBundle result2;
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(21);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(22);
        }
        if ((result2 = (map2 = ourCache.get(loader)).get(pathToBundle)) == null) {
            try {
                ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
                result2 = this.findBundle(pathToBundle, loader, control);
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
                ResourceBundle.clearCache(loader);
                result2 = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
            }
            map2.put(pathToBundle, result2);
        }
        ResourceBundle resourceBundle = result2;
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(23);
        }
        return resourceBundle;
    }

    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(24);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(25);
        }
        if (control == null) {
            AbstractBundle.$$$reportNull$$$0(26);
        }
        return ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/AbstractBundle";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/AbstractBundle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyMessage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLazyMessage";
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 23: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "messageOfNull";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "messageOrNull";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

