/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.interpreter.ExecutionResult;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterMethodNotFoundException;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.ArrayConstructor;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.ArrayOf;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.ArrayOfNulls;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EmptyArray;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumHashCode;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValueOf;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValues;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.JsPrimitives;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.RegexReplace;
import org.jetbrains.kotlin.ir.interpreter.stack.Stack;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicEvaluator;", "", "()V", "evaluate", "Lorg/jetbrains/kotlin/ir/interpreter/ExecutionResult;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "stack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Stack;", "interpret", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/ExtensionFunctionType;", "ir.interpreter"})
public final class IntrinsicEvaluator {
    @NotNull
    public final ExecutionResult evaluate(@NotNull IrFunction irFunction2, @NotNull Stack stack, @NotNull Function1<? super IrElement, ? extends ExecutionResult> interpret2) {
        ExecutionResult executionResult;
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(interpret2, "interpret");
        if (EmptyArray.INSTANCE.equalTo(irFunction2)) {
            executionResult = EmptyArray.INSTANCE.evaluate(irFunction2, stack, interpret2);
        } else if (ArrayOf.INSTANCE.equalTo(irFunction2)) {
            executionResult = ArrayOf.INSTANCE.evaluate(irFunction2, stack, interpret2);
        } else if (ArrayOfNulls.INSTANCE.equalTo(irFunction2)) {
            executionResult = ArrayOfNulls.INSTANCE.evaluate(irFunction2, stack, interpret2);
        } else if (EnumValues.INSTANCE.equalTo(irFunction2)) {
            executionResult = EnumValues.INSTANCE.evaluate(irFunction2, stack, interpret2);
        } else if (EnumValueOf.INSTANCE.equalTo(irFunction2)) {
            executionResult = EnumValueOf.INSTANCE.evaluate(irFunction2, stack, interpret2);
        } else if (RegexReplace.INSTANCE.equalTo(irFunction2)) {
            executionResult = RegexReplace.INSTANCE.evaluate(irFunction2, stack, interpret2);
        } else if (EnumHashCode.INSTANCE.equalTo(irFunction2)) {
            executionResult = EnumHashCode.INSTANCE.evaluate(irFunction2, stack, interpret2);
        } else if (JsPrimitives.INSTANCE.equalTo(irFunction2)) {
            executionResult = JsPrimitives.INSTANCE.evaluate(irFunction2, stack, interpret2);
        } else if (ArrayConstructor.INSTANCE.equalTo(irFunction2)) {
            executionResult = ArrayConstructor.INSTANCE.evaluate(irFunction2, stack, interpret2);
        } else {
            throw (Throwable)new InterpreterMethodNotFoundException("Method " + irFunction2.getName() + " hasn't implemented");
        }
        return executionResult;
    }
}

