/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.mac.disk;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class Diskutil {
    private static final String DISKUTIL_CS_LIST = "diskutil cs list";
    private static final String LOGICAL_VOLUME_FAMILY = "Logical Volume Family";
    private static final String LOGICAL_VOLUME_GROUP = "Logical Volume Group";

    private Diskutil() {
    }

    public static Map<String, String> queryLogicalVolumeMap() {
        HashMap<String, String> logicalVolumeMap = new HashMap<String, String>();
        HashSet<String> physicalVolumes = new HashSet<String>();
        boolean logicalVolume = false;
        for (String line : ExecutingCommand.runNative(DISKUTIL_CS_LIST)) {
            if (line.contains(LOGICAL_VOLUME_GROUP)) {
                physicalVolumes.clear();
                logicalVolume = false;
                continue;
            }
            if (line.contains(LOGICAL_VOLUME_FAMILY)) {
                logicalVolume = true;
                continue;
            }
            if (!line.contains("Disk:")) continue;
            String volume = ParseUtil.parseLastString(line);
            if (logicalVolume) {
                for (String pv : physicalVolumes) {
                    logicalVolumeMap.put(pv, volume);
                }
                physicalVolumes.clear();
                continue;
            }
            physicalVolumes.add(ParseUtil.parseLastString(line));
        }
        return logicalVolumeMap;
    }
}

