/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.bpm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.sourceforge.plantuml.bpm.Chain;
import net.sourceforge.plantuml.bpm.Navigator;

public class ChainImpl<O>
implements Chain<O> {
    private final List<O> positive = new ArrayList<O>();
    private final List<O> negative = new ArrayList<O>();
    private int currentVersion;

    @Override
    public boolean remove(O data) {
        this.updateStructuralVersion();
        boolean result = this.positive.remove(data);
        if (!result) {
            result = this.negative.remove(data);
        }
        return result;
    }

    public ChainImpl<O> cloneMe() {
        ChainImpl<O> result = new ChainImpl<O>();
        result.currentVersion = this.currentVersion;
        result.positive.addAll(this.positive);
        result.negative.addAll(this.negative);
        return result;
    }

    @Override
    public int compare(O a, O b) {
        if (a.equals(b)) {
            return 0;
        }
        for (int i = this.negative.size() - 1; i >= 0; --i) {
            if (a.equals(this.negative.get(i))) {
                return -1;
            }
            if (!b.equals(this.negative.get(i))) continue;
            return 1;
        }
        for (O cur : this.positive) {
            if (a.equals(cur)) {
                return -1;
            }
            if (!b.equals(cur)) continue;
            return 1;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<O> toList() {
        ArrayList<O> result = new ArrayList<O>();
        for (O element : this.negative) {
            if (element == null) continue;
            result.add(0, element);
        }
        for (O element : this.positive) {
            if (element == null) continue;
            result.add(element);
        }
        return Collections.unmodifiableList(result);
    }

    private ChainImpl() {
    }

    public ChainImpl(O root) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        this.positive.add(root);
    }

    private int updateStructuralVersion() {
        ++this.currentVersion;
        return this.currentVersion;
    }

    @Override
    public boolean contains(O data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < Math.max(this.positive.size(), this.negative.size()); ++i) {
            if (i < this.positive.size() && data == this.positive.get(i)) {
                return true;
            }
            if (i >= this.negative.size() || data != this.negative.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Navigator<O> navigator(O data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < Math.max(this.positive.size(), this.negative.size()); ++i) {
            if (i < this.positive.size() && data == this.positive.get(i)) {
                InternalNavigator result = new InternalNavigator(i, this.currentVersion);
                assert (result.get() == data);
                return result;
            }
            if (i >= this.negative.size() || data != this.negative.get(i)) continue;
            InternalNavigator result = new InternalNavigator(-i - 1, this.currentVersion);
            assert (result.get() == data);
            return result;
        }
        throw new IllegalArgumentException();
    }

    private O getInternal(int position) {
        this.ensure(position);
        if (position >= 0) {
            return this.positive.get(position);
        }
        return this.negative.get(-position - 1);
    }

    private void setInternal(int position, O data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.ensure(position);
        if (position >= 0) {
            this.positive.set(position, data);
        } else {
            this.negative.set(-position - 1, data);
        }
    }

    private void insertInternal(int position, O data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.ensure(position);
        if (position >= 0) {
            this.positive.add(position, data);
        } else {
            this.negative.add(-position - 1, data);
        }
    }

    private void ensure(int position) {
        if (position >= 0) {
            this.ensureInternal(position, this.positive);
        } else {
            this.ensureInternal(-position - 1, this.negative);
        }
    }

    private void ensureInternal(int position, List<O> list) {
        assert (position >= 0) : "position=" + position;
        while (list.size() <= position) {
            list.add(null);
        }
        assert (list.size() > position);
        assert (list.get(position) != this);
    }

    class InternalNavigator
    implements Navigator<O> {
        private int position = 0;
        private int version;

        private InternalNavigator(int position, int version) {
            this.position = position;
            this.version = version;
        }

        private void checkConsistency() {
            if (this.version != ChainImpl.this.currentVersion) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public O next() {
            this.checkConsistency();
            ++this.position;
            return this.get();
        }

        @Override
        public O previous() {
            this.checkConsistency();
            --this.position;
            return this.get();
        }

        @Override
        public O get() {
            this.checkConsistency();
            return ChainImpl.this.getInternal(this.position);
        }

        @Override
        public void set(O data) {
            this.checkConsistency();
            ChainImpl.this.setInternal(this.position, data);
        }

        @Override
        public void insertBefore(O data) {
            this.version = ChainImpl.this.updateStructuralVersion();
            ChainImpl.this.insertInternal(this.position, data);
        }

        @Override
        public void insertAfter(O data) {
            this.version = ChainImpl.this.updateStructuralVersion();
            ChainImpl.this.insertInternal(this.position + 1, data);
        }
    }
}

