/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ALinkImpl;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.ANodeImpl;
import net.sourceforge.plantuml.graph.LinkString;

public class Zoda1 {
    private final Map<String, ANodeImpl> nodes = new LinkedHashMap<String, ANodeImpl>();
    private final List<ALink> links = new ArrayList<ALink>();

    public ANodeImpl getNode(String code) {
        ANodeImpl result = this.nodes.get(code);
        if (result == null) {
            result = new ANodeImpl(code);
            this.nodes.put(code, result);
        }
        return result;
    }

    public ANodeImpl getExistingNode(String code) {
        return this.nodes.get(code);
    }

    public List<ALink> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public List<ANode> getNodes() {
        return Collections.unmodifiableList(new ArrayList<ANodeImpl>(this.nodes.values()));
    }

    public void addLink(String link) {
        LinkString l = new LinkString(link);
        ANodeImpl n1 = this.getNode(l.getNode1());
        ANodeImpl n2 = this.getNode(l.getNode2());
        this.links.add(new ALinkImpl(n1, n2, 1, null));
    }

    public void computeRows() {
        this.getNodes().get(0).setRow(0);
        for (int i = 0; i < this.links.size(); ++i) {
            this.oneStep1();
            this.oneStep2();
        }
        this.removeUnplacedNodes();
    }

    private void removeUnplacedNodes() {
        Iterator<ANodeImpl> it = this.nodes.values().iterator();
        while (it.hasNext()) {
            ANodeImpl n = it.next();
            if (n.getRow() != Integer.MIN_VALUE) continue;
            this.removeLinksOf(n);
            it.remove();
        }
    }

    private void removeLinksOf(ANodeImpl n) {
        Iterator<ALink> it = this.links.iterator();
        while (it.hasNext()) {
            ALink link = it.next();
            if (link.getNode1() != n && link.getNode2() != n) continue;
            it.remove();
        }
    }

    public int getRowMax() {
        int max = 0;
        for (ANode n : this.getNodes()) {
            if (n.getRow() == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            if (n.getRow() <= max) continue;
            max = n.getRow();
        }
        return max;
    }

    private void oneStep1() {
        for (ALink link : this.links) {
            ANode n1 = link.getNode1();
            if (n1.getRow() == Integer.MIN_VALUE) continue;
            ANode n2 = link.getNode2();
            if (n2.getRow() == Integer.MIN_VALUE) {
                n2.setRow(n1.getRow() + 1);
                continue;
            }
            if (n2.getRow() >= n1.getRow() + 1) continue;
            n2.setRow(n1.getRow() + 1);
        }
    }

    private void oneStep2() {
        for (ALink link : this.links) {
            int row;
            ANode n1 = link.getNode1();
            ANode n2 = link.getNode2();
            if (n1.getRow() != Integer.MIN_VALUE || n2.getRow() == Integer.MIN_VALUE) continue;
            if (n2.getRow() == 0) {
                this.allDown();
            }
            if ((row = n2.getRow() - 1) == -1) {
                throw new UnsupportedOperationException();
            }
            n1.setRow(row);
        }
    }

    private void allDown() {
        for (ANodeImpl n : this.nodes.values()) {
            if (n.getRow() == Integer.MIN_VALUE) continue;
            n.setRow(n.getRow() + 1);
        }
    }
}

